-- HLstatsX: CE Installation Database file

-- This file is only needed for new installations.

SET @DBVERSION="78";
SET @VERSION="1.6.19";

-- --------------------------------------------------------

--
-- Table structure for table `geoLiteCity_Blocks`
--

CREATE TABLE IF NOT EXISTS `geoLiteCity_Blocks` (
  `startIpNum` bigint(11) unsigned NOT NULL default '0',
  `endIpNum` bigint(11) unsigned NOT NULL default '0',
  `locId` bigint(11) unsigned NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `geoLiteCity_Location`
--

CREATE TABLE IF NOT EXISTS `geoLiteCity_Location` (
  `locId` bigint(11) unsigned NOT NULL default '0',
  `country` varchar(2) NOT NULL,
  `region` varchar(50) default NULL,
  `city` varchar(50) default NULL,
  `postalCode` varchar(10) default NULL,
  `latitude` decimal(14,4) default NULL,
  `longitude` decimal(14,4) default NULL,
  PRIMARY KEY  (`locId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Actions`
--

CREATE TABLE IF NOT EXISTS `hlstats_Actions` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `game` varchar(32) NOT NULL default 'valve',
  `code` varchar(64) NOT NULL default '',
  `reward_player` int(11) NOT NULL default '10',
  `reward_team` int(11) NOT NULL default '0',
  `team` varchar(64) NOT NULL default '',
  `description` varchar(128) default NULL,
  `for_PlayerActions` enum('0','1') NOT NULL default '0',
  `for_PlayerPlayerActions` enum('0','1') NOT NULL default '0',
  `for_TeamActions` enum('0','1') NOT NULL default '0',
  `for_WorldActions` enum('0','1') NOT NULL default '0',
  `count` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `gamecode` (`code`,`game`,`team`),
  KEY `code` (`code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Actions`
--

INSERT INTO `hlstats_Actions` (`game`, `code`, `reward_player`, `reward_team`, `team`, `description`, `for_PlayerActions`, `for_PlayerPlayerActions`, `for_TeamActions`, `for_WorldActions`) VALUES
('tf', 'flagevent_defended', 1, 0, '', 'Defended the flag', '1', '', '', ''),
('tf', 'flagevent_captured', 5, 1, '', 'Captured the flag', '1', '', '', ''),
('tf', 'flagevent_dropped', -2, 0, '', 'Dropped the flag (while alive)', '1', '', '', ''),
('tf', 'flagevent_dropped_death', 0, 0, '', 'Dropped the flag (on death)', '1', '', '', ''),
('tf', 'flagevent_picked_up', 2, 0, '', 'Picked up the flag', '1', '', '', ''),
('tf', 'killedobject_obj_teleporter', 2, 0, '', 'Destroyed a teleporter', '1', '', '', ''),
('tf', 'killedobject_obj_dispenser', 3, 0, '', 'Destroyed a dispenser', '1', '', '', ''),
('tf', 'killedobject_obj_sentrygun', 4, 0, '', 'Destroyed a sentry gun', '1', '', '', ''),
('tf', 'killedobject_obj_sentrygun_mini', 4, 0, '', 'Destroyed a mini sentry gun', '1', '', '', ''),
('tf', 'builtobject_obj_teleporter', 2, 0, '', 'Built a teleporter', '1', '', '', ''),
('tf', 'builtobject_obj_dispenser', 3, 0, '', 'Built a dispenser', '1', '', '', ''),
('tf', 'builtobject_obj_sentrygun', 3, 0, '', 'Built a sentry gun', '1', '', '', ''),
('tf', 'builtobject_obj_sentrygun_mini', 3, 0, '', 'Built a mini sentry gun', '1', '', '', ''),
('tf', 'captureblocked', 1, 0, '', 'Capture Blocked', '1', '', '', ''),
('tf', 'pointcaptured', 5, 5, '', 'Point Captured', '1', '', '1', ''),
('tf', 'kill assist', 2, 0, '', 'Kill Assist', '1', '', '', ''),
('tf', 'builtobject_obj_attachment_sapper', 2, 0, '', 'Attached a Sapper', '1', '', '', ''),
('tf', 'killedobject_obj_attachment_sapper', 1, 0, '', 'Removed a Sapper', '1', '', '', ''),
('tf', 'chargedeployed', 1, 0, '', 'Ubercharge', '1', '', '', ''),
('tf', 'domination', 5, 0, '', 'Domination', '', '1', '', ''),
('tf', 'revenge', 3, 0, '', 'Revenge', '', '1', '', ''),
('tf', 'Round_Win', 0, 10, '', 'Round Win', '', '', '1', ''),
('tf', 'Mini_Round_Win', 0, 5, '', 'Mini-Round Win', '', '', '1', ''),
('tf', 'owner_killedobject_obj_sentrygun', -3, 0, '', 'Disassembled a sentry gun', '1', '', '', ''),
('tf', 'owner_killedobject_obj_sentrygun_mini', -3, 0, '', 'Disassembled a mini sentry gun', '1', '', '', ''),
('tf', 'owner_killedobject_obj_dispenser', -3, 0, '', 'Disassembled a dispenser', '1', '', '', ''),
('tf', 'owner_killedobject_obj_teleporter', -2, 0, '', 'Disassembled a teleporter', '1', '', '', ''),
('tf', 'owner_killedobject_obj_attachment_sapper', -2, 0, '', 'Console-killed sapper', '1', '', '', ''),
('tf', 'backstab', 2, 0, '', 'Backstab Kill', '1', '', '', ''),
('tf', 'headshot', 2, 0, '', 'Headshot Kill', '1', '', '', ''),
('tf', 'kill_assist_medic', 3, 0, '', 'Kill Assist - Medic', '1', '0', '0', '0'),
('tf', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('tf', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('tf', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('tf', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('tf', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('tf', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('tf', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('tf', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('tf', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('tf', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('tf', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('tf', 'sandvich', 0, 0, '', 'Ate a Sandvich', '1', '', '', ''),
('tf', 'crit_kill', 0, 0, '', 'Critical Kill', '1', '', '', ''),
('tf', 'force_suicide', 0, 0, '', 'Force Suicide', '1', '', '', ''),
('tf', 'hit_by_train', 0, 0, '', 'LOL TRAIN''D', '1', '', '', ''),
('tf', 'first_blood', 1, 0, '', 'First Blood', '1', '', '', ''),
('tf', 'steal_sandvich', 2, 0, '', 'Steal Sandvich', '', '1', '', ''),
('tf', 'stun', 0, 0, '', 'Stun', '', '1', '', ''),
('tf', 'drowned', 0, 0, '', 'Drowned', '1', '', '', ''),
('tf', 'pyro_extinguish', 1, 0, '', 'Extinguished Teammate (Pyro)', '1', '', '', ''),
('tf', 'sniper_extinguish', 1, 0, '', 'Extinguished Teammate (Sniper)', '1', '', '', ''),
('tf', 'medic_extinguish', 1, 0, '', 'Extinguished Teammate (Medic)', '1', '', '', ''),
('tf', 'engineer_extinguish', 1, 0, '', 'Extinguished Teammate (Engineer)', '1', '', '', ''),
('tf', 'teleport', 1, 0, '', 'Teleporter used', '1', '', '', ''),
('tf', 'teleport_self', 0, 0, '', 'Teleporter used (self)', '1', '', '', ''),
('tf', 'killed_charged_medic', 1, 0, '', 'Killed charged medic', '1', '', '', ''),
('tf', 'death_sawblade', 0, 0, '', 'LOL SAW''D', '1', '', '', ''),
('tf', 'jarate', 1, 0, '', 'Jarated player', '0', '1', '0', '0'),
('tf', 'shield_blocked', 0, 0, '', 'Blocked with Shield', '0', '1', '0', '0'),
('tf', 'mvp1', 5, 0, '', 'MVP #1', '1', '0', '0', '0'),
('tf', 'mvp2', 3, 0, '', 'MVP #2', '1', '0', '0', '0'),
('tf', 'mvp3', 2, 0, '', 'MVP #3', '1', '0', '0', '0'),
('tf', 'defended_medic', 1, 0, '', 'Defended a Medic', '1', '0', '0', '0'),
('tf', 'buff_deployed', 1, 0, '', 'Deployed Buff Flag', '1', '0', '0', '0'),
('tf', 'escort_score', 1, 0, '', 'Cart Escort', '1', '0', '0', '0'),
('tf', 'airshot_rocket', 0, 0, '', 'Airshot Rocket', '1', '0', '0', '0'),
('tf', 'airshot_headshot', 0, 0, '', 'Airshot Headshot', '1', '0', '0', '0'),
('tf', 'air2airshot_pipebomb', 0, 0, '', 'Airshot Pipebomb (Airborne)', '1', '0', '0', '0'),
('tf', 'air2airshot_rocket', 0, 0, '', 'Airshot Rocket (Airborne)', '1', '0', '0', '0'),
('tf', 'air2airshot_sticky', 0, 0, '', 'Airshot Sticky (Airborne)', '1', '0', '0', '0'),
('tf', 'airblast_player', 0, 0, '', 'Airblast Player', '0', '1', '0', '0'),
('tf', 'airshot_arrow', 0, 0, '', 'Airshot Arrow', '1', '0', '0', '0'),
('tf', 'airshot_flare', 0, 0, '', 'Airshot Flare', '1', '0', '0', '0'),
('tf', 'airshot_pipebomb', 0, 0, '', 'Airshot Pipebomb', '1', '0', '0', '0'),
('tf', 'airshot_sticky', 0, 0, '', 'Airshot Sticky', '1', '0', '0', '0'),
('tf', 'airshot_stun', 0, 0, '', 'Airshot Stun', '1', '0', '0', '0'),
('tf', 'deflected_arrow', 0, 0, '', 'Deflected Arrow', '0', '1', '0', '0'),
('tf', 'deflected_baseball', 0, 0, '', 'Deflected Baseball', '0', '1', '0', '0'),
('tf', 'deflected_flare', 0, 0, '', 'Deflected Flare', '0', '1', '0', '0'),
('tf', 'deflected_jarate', 0, 0, '', 'Deflected Jarate', '0', '1', '0', '0'),
('tf', 'deflected_pipebomb', 0, 0, '', 'Deflected Pipebomb', '0', '1', '0', '0'),
('tf', 'deflected_rocket', 0, 0, '', 'Deflected Rocket', '0', '1', '0', '0'),
('tf', 'deflected_rocket_dh', 0, 0, '', 'Deflected Directhit Rocket', '0', '1', '0', '0'),
('tf', 'rocket_failjump', 0, 0, '', 'Rocket Jump Failure', '1', '0', '0', '0'),
('tf', 'rocket_jump', 0, 0, '', 'Rocket Jump', '1', '0', '0', '0'),
('tf', 'rocket_jump_kill', 0, 0, '', 'Rocket Jump Kill', '1', '0', '0', '0'),
('tf', 'rocket_jumper_kill', 0, 0, '', 'Rocket Jumper Kill', '1', '0', '0', '0'),
('tf', 'sandvich_healself', 0, 0, '', 'Ate Sandvich for Health', '1', '0', '0', '0'),
('tf', 'sticky_failjump', 0, 0, '', 'Sticky Jump Failure', '1', '0', '0', '0'),
('tf', 'sticky_jump', 0, 0, '', 'Sticky Jump', '1', '0', '0', '0'),
('tf', 'sticky_jump_kill', 0, 0, '', 'Sticky Jump Kill', '1', '0', '0', '0'),
('tf', 'sticky_jumper_kill', 0, 0, '', 'Sticky Jumper Kill', '1', '0', '0', '0'),
('tf', 'teleport_again', 0, 0, '', 'Teleported Again (Past 10 Seconds)', '1', '0', '0', '0'),
('tf', 'teleport_self_again', 0, 0, '', 'Teleported Self Again (Past 10 Seconds)', '1', '0', '0', '0'),
('tf', 'teleport_used', 0, 0, '', 'Teleporter Used (Not Own)', '1', '0', '0', '0'),
('tf', 'teleport_used_again', 0, 0, '', 'Teleporter Used Again (Past 10 Seconds) (Not Own)', '1', '0', '0', '0'),
('tf', 'dalokohs', 0, 0, '', 'Ate a Dalokohs Bar', '1', '', '', ''),
('tf', 'dalokohs_healself', 0, 0, '', 'Ate Dalokohs Bar for Health', '1', '0', '0', '0'),
('tf', 'steak', 0, 0, '', 'Ate a Buffalo Steak Sandvich', '1', '0', '0', '0'),
('tf', 'madmilk', 0, 0, '', 'Mad Milking a player', '0', '1', '0', '0'),
('tf', 'scout_extinguish', 1, 0, '', 'Extinguished Teammate (Scout)', '1', '', '', ''),
('tf', 'player_penetration', 4, 0, '', 'Player Penetration', '1', '', '', ''),
('css','Begin_Bomb_Defuse_Without_Kit',0,0,'CT','Start Defusing the Bomb Without a Defuse Kit','1','','',''),
('css','Begin_Bomb_Defuse_With_Kit',0,0,'CT','Start Defusing the Bomb With a Defuse Kit','1','','',''),
('css','Planted_The_Bomb',10,2,'TERRORIST','Plant the Bomb','1','','',''),
('css','Defused_The_Bomb',10,0,'CT','Defuse the Bomb','1','','',''),
('css','Touched_A_Hostage',0,0,'CT','Touch a Hostage','1','','',''),
('css','Rescued_A_Hostage',5,1,'CT','Rescue a Hostage','1','','',''),
('css','Killed_A_Hostage',-15,1,'CT','Kill a Hostage','1','','',''),
('css','Spawned_With_The_Bomb',2,0,'TERRORIST','Spawn with the Bomb','1','','',''),
('css','Got_The_Bomb',2,0,'TERRORIST','Pick up the Bomb','1','','',''),
('css','Dropped_The_Bomb',-2,0,'TERRORIST','Drop the Bomb','1','','',''),
('css','CTs_Win',0,2,'CT','All Terrorists eliminated','','','1',''),
('css','Terrorists_Win',0,2,'TERRORIST','All Counter-Terrorists eliminated','','','1',''),
('css','All_Hostages_Rescued',0,10,'CT','Counter-Terrorists rescued all the hostages','','','1',''),
('css','Target_Bombed',0,5,'TERRORIST','Terrorists bombed the target','','','1',''),
('css','Bomb_Defused',0,5,'CT','Counter-Terrorists defused the bomb','','','1',''),
('css','Escaped_As_VIP',0,10,'CT','VIP escaped','','','1',''),
('css','Assassinated_The_VIP',0,6,'TERRORIST','Terrorists assassinated the VIP','','','1',''),
('css','Became_VIP',1,0,'CT','Become the VIP','1','','',''),
('css','headshot',1,0,'','Headshot','1','','',''),
('css','round_mvp',0,0,'','Round MVP','1','','',''),
('css', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('css', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('css', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('css', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('css', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('css', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('css', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('css', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('css', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('css', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('css', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('css', 'domination', 5, 0, '', 'Domination', '', '1', '', ''),
('css', 'revenge', 3, 0, '', 'Revenge', '', '1', '', ''),
('hl2ctf','ctf_flag_capture',15,0,'','Captured Enemy Flag','1','','',''),
('hl2ctf','ctf_flag_defend',2,0,'','Defended the Flag','1','','',''),
('hl2ctf','ctf_kill_carrier',5,0,'','Killed Enemy Flag Carrier','1','','',''),
('hl2ctf','ctf_flag_return',5,0,'','Returned Flag','1','','',''),
('hl2ctf','ctf_flag_stolen',1,0,'','Stole Enemy Flag','1','','',''),
('hl2ctf','ctf_protect_carrier',5,0,'','Protected Flag Carrier','1','','',''),
('hl2ctf', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('hl2ctf', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('hl2ctf', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('hl2ctf', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('hl2ctf', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('hl2ctf', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('hl2ctf', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('hl2ctf', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('hl2ctf', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('hl2ctf', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('hl2ctf', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('dods','capblock',6,1,'','Capture Blocked','1','','1',''),
('dods','captured_loc',6,1,'','Area Captured','1','','1',''),
('dods','kill_planter',2,0,'','Bomb Planter Killed','1','','',''),
('dods','bomb_defuse',6,1,'','Bomb Defused','1','','1',''),
('dods','bomb_plant',6,1,'','Bomb Planted','1','','1',''),
('dods','round_win',0,5,'','Round Win','','','1',''),
('dods', 'domination', 5, 0, '', 'Domination', '', '1', '', ''),
('dods', 'revenge', 3, 0, '', 'Revenge', '', '1', '', ''),
('dods', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('dods', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('dods', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('dods', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('dods', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('dods', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('dods', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('dods', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('dods', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('dods', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('dods', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('hl2mp', 'headshot', 0, 0, '', 'Headshot Kill', '1', '0', '0', '0'),
('insmod', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('insmod', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('insmod', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('insmod', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('insmod', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('insmod', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('insmod', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('insmod', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('insmod', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('insmod', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('insmod', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('insmod', 'headshot', 1, 0, '', 'Headshot Kill', '1', '', '', ''),
('insmod', 'Round_Win', 0, 10, '', 'Round Win', '', '', '1', ''),
('insmod', 'captured_a', 0, 5, '', 'Captured Objective A', '', '', '1', ''),
('insmod', 'captured_b', 0, 5, '', 'Captured Objective B', '', '', '1', ''),
('insmod', 'captured_c', 0, 5, '', 'Captured Objective C', '', '', '1', ''),
('insmod', 'captured_d', 0, 5, '', 'Captured Objective D', '', '', '1', ''),
('insmod', 'captured_e', 0, 5, '', 'Captured Objective E', '', '', '1', ''),
('ff', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('ff', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('ff', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('ff', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('ff', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('ff', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('ff', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('ff', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('ff', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('ff', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('ff', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('ff', 'headshot', 1, 0, '', 'Headshot kill', '1', '', '', ''),
('ff', 'sentrygun_upgraded', 1, 0, '', 'Upgraded Sentry Gun', '1', '', '', ''),
('ff', 'build_sentrygun', 1, 0, '', 'Built Sentry Gun', '1', '', '', ''),
('ff', 'build_dispenser', 1, 0, '', 'Built Dispenser', '1', '', '', ''),
('ff', 'dispenser_detonated', -1, 0, '', 'Dispenser Detonated', '1', '', '', ''),
('ff', 'sentry_detonated', -1, 0, '', 'Sentry Gun Detonated', '1', '', '', ''),
('ff', 'sentry_dismantled', -1, 0, '', 'Sentry Gun Dismantled', '1', '', '', ''),
('ff', 'dispenser_dismantled', -1, 0, '', 'Dispenser Dismantled', '1', '', '', ''),
('ff', 'build_mancannon', 1, 0, '', 'Built Jump Pad', '1', '', '', ''),
('ff', 'mancannon_detonated', -1, 0, '', 'Detonated Jump Pad', '1', '', '', ''),
('ff', 'build_detpack', 1, 0, '', 'Placed Detpack', '1', '', '', ''),
('ff', 'flag_touch', 3, 0, '', 'Flag Picked Up', '1', '', '', ''),
('ff', 'flag_capture', 3, 0, '', 'Flag Captured', '1', '', '', ''),
('ff', 'flag_dropped', -3, 0, '', 'Flag Dropped', '1', '', '', ''),
('ff', 'flag_thrown', -3, 0, '', 'Flag Thrown', '1', '', '', ''),
('ff', 'disguise_lost', 1, 0, '', 'Uncovered Enemy', '', '1', '', ''),
('hidden', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('hidden', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('hidden', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('hidden', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('hidden', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('hidden', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('hidden', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('hidden', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('hidden', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('hidden', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('hidden', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('zps', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('zps', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('zps', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('zps', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('zps', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('zps', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('zps', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('zps', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('zps', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('zps', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('zps', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('zps', 'headshot', 1, 0, '', 'Headshot Kill', '1', '0', '0', '0'),
('aoc', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('aoc', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('aoc', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('aoc', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('aoc', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('aoc', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('aoc', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('aoc', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('aoc', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('aoc', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('aoc', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('aoc', 'headshot', 2, 0, '', 'Headshot/Decapitate Kill', '1', '', '', ''),
('aoc', 'Round_Win', 0, 2, '', 'Round Win', '', '', '1', ''),
('cstrike','Begin_Bomb_Defuse_Without_Kit',0,0,'CT','Start Defusing the Bomb Without a Defuse Kit','1','0','0','0'),
('cstrike','Begin_Bomb_Defuse_With_Kit',0,0,'CT','Start Defusing the Bomb With a Defuse Kit','1','0','0','0'),
('cstrike','Assassinated_The_VIP',10,0,'TERRORIST','Assassinate the VIP','1','0','0','0'),
('cstrike','Planted_The_Bomb',15,2,'TERRORIST','Plant the Bomb','1','0','0','0'),
('cstrike','Defused_The_Bomb',15,0,'CT','Defuse the Bomb','1','0','0','0'),
('cstrike','Touched_A_Hostage',2,0,'CT','Touch a Hostage','1','0','0','0'),
('cstrike','Rescued_A_Hostage',5,1,'CT','Rescue a Hostage','1','0','0','0'),
('cstrike','Killed_A_Hostage',-25,1,'CT','Kill a Hostage','1','0','0','0'),
('cstrike','Became_VIP',1,0,'CT','Become the VIP','1','0','0','0'),
('cstrike','Spawned_With_The_Bomb',2,0,'TERRORIST','Spawn with the Bomb','1','0','0','0'),
('cstrike','Got_The_Bomb',2,0,'TERRORIST','Pick up the Bomb','1','0','0','0'),
('cstrike','Dropped_The_Bomb',-2,0,'TERRORIST','Drop the Bomb','1','0','0','0'),
('cstrike','CTs_Win',0,2,'CT','All Terrorists eliminated','0','0','1','0'),
('cstrike','Terrorists_Win',0,2,'TERRORIST','All Counter-Terrorists eliminated','0','0','1','0'),
('cstrike','All_Hostages_Rescued',0,10,'CT','Counter-Terrorists rescued all the hostages','0','0','1','0'),
('cstrike','Target_Bombed',0,10,'TERRORIST','Terrorists bombed the target','0','0','1','0'),
('cstrike','VIP_Assassinated',0,6,'TERRORIST','Terrorists assassinated the VIP','0','0','1','0'),
('cstrike','Bomb_Defused',0,6,'CT','Counter-Terrorists defused the bomb','0','0','1','0'),
('cstrike','VIP_Escaped',0,10,'CT','VIP escaped','0','0','1','0'),
('cstrike', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('cstrike', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('cstrike', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('cstrike', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('cstrike', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('cstrike', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('cstrike', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('cstrike', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('cstrike', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('cstrike', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('cstrike', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('cstrike', 'headshot', 1, 0, '', 'Headshot', '1', '', '', ''),
('tfc','rock2_bcave1',2,3,'','(rock2) Blow Red Cave','1','0','0','0'),
('tfc','rock2_rcave1',2,3,'','(rock2) Blow Blue Cave','1','0','0','0'),
('tfc','rock2_rholedet',2,3,'','(rock2) Blow Blue Yard','1','0','0','0'),
('tfc','rock2_bholedet',2,3,'','(rock2) Blow Red Yard','1','0','0','0'),
('tfc','Team 2 dropoff',7,0,'','Captured Blue Flag','1','0','0','0'),
('tfc','Team 1 dropoff',7,0,'','Captured Red Flag','1','0','0','0'),
('tfc','Capture Point 1',2,5,'','Captured Point 1','1','0','0','0'),
('tfc','Capture Point 2',2,5,'','Captured Point 2','1','0','0','0'),
('tfc','Capture Point 3',2,5,'','Captured Point 3','1','0','0','0'),
('tfc','Medic_Infection',2,0,'','Infected Enemy','0','1','0','0'),
('tfc','Medic_Cured_Infection',2,0,'','Cured Infection','1','0','0','0'),
('tfc','Hallucination_Grenade',1,0,'','Hallucination','0','1','0','0'),
('tfc','Concussion_Grenade',1,0,'','Concussion','0','1','0','0'),
('tfc','Teleporter_Entrance_Dismantle',-2,0,'','Teleporter Entrance Dismantled','1','0','0','0'),
('tfc','Teleporter_Entrance_Destroyed',1,0,'','Teleporter Entrance Destroyed','0','1','0','0'),
('tfc','Teleporter_Entrance_Finished',2,0,'','Teleporter Entrance Build','1','0','0','0'),
('tfc','Teleporter_Exit_Dismantle',-2,0,'','Teleporter Exit Dismantled','1','0','0','0'),
('tfc','Teleporter_Exit_Destroyed',1,0,'','Teleporter Exit Destroyed','0','1','0','0'),
('tfc','Teleporter_Exit_Finished',2,0,'','Teleporter Exit Build','1','0','0','0'),
('tfc','Sentry_Built_Level_1',2,0,'','Built Sentry','1','0','0','0'),
('tfc','Sentry_Upgrade_Level_2',1,0,'','Upgraded Sentry to Lvl 2','1','0','0','0'),
('tfc','Sentry_Upgrade_Level_3',1,0,'','Upgraded Sentry to Lvl 3','1','0','0','0'),
('tfc','Sentry_Destroyed',3,0,'','Destroyed Sentry Gun','0','1','0','0'),
('tfc','Sentry_Dismantle',3,0,'','Dismantled Sentry Gun','0','1','0','0'),
('tfc','Dispenser_Dismantle',-2,0,'','Dismantled Dispenser','0','1','0','0'),
('tfc','Discovered_Spy',2,0,'','Discovered a Spy','1','0','0','0'),
('tfc','Dispenser_Destroyed',5,0,'','Dispenser Destroyed','1','0','0','0'),
('tfc','Built_Dispenser',2,0,'','Built Dispenser','1','0','0','0'),
('tfc','headshot',1,0,'','Headshot Kill','1','0','0','0'),
('tfc', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('tfc', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('tfc', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('tfc', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('tfc', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('tfc', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('tfc', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('tfc', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('tfc', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('tfc', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('tfc', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('dod','dod_control_point',6,1,'','Control Points Captured','1','0','1','0'),
('dod','dod_capture_area',6,1,'','Areas Captured','1','0','1','0'),
('dod','dod_object_goal',4,0,'','Objectives Achieved','1','0','0','0'),
('dod', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('dod', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('dod', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('dod', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('dod', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('dod', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('dod', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('dod', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('dod', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('dod', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('dod', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('ns','structure_built',1,0,'','Structures Built','1','0','0','0'),
('ns','structure_destroyed',2,0,'','Structures Destroyed','1','0','0','0'),
('ns','research_start',1,0,'','Researches Performed','1','0','0','0'),
('ns','recycle',-3,0,'','Structures Recycled','1','0','0','0'),
('ns','structure_built_alienresourcetower',1,0,'','Built Alien Resource Tower','1','0','0','0'),
('ns','structure_destroyed_alienresourcetower',2,0,'','Destroyed Alien Resource Tower','1','0','0','0'),
('ns','structure_built_phasegate',1,0,'','Built Phasegate','1','0','0','0'),
('ns','structure_destroyed_phasegate',2,0,'','Destroyed Phasegate','1','0','0','0'),
('ns','structure_built_resourcetower',1,0,'','Built Resource Tower','1','0','0','0'),
('ns','structure_destroyed_resourcetower',2,0,'','Destroyed Resource Tower','1','0','0','0'),
('ns','structure_built_siegeturret',1,0,'','Built Siege Turret','1','0','0','0'),
('ns','structure_destroyed_siegeturret',2,0,'','Destroyed Siege Turret','1','0','0','0'),
('ns','structure_built_team_advturretfactory',1,0,'','Built Advanced Turret Factory','1','0','0','0'),
('ns','structure_destroyed_team_advturretfactory',2,0,'','Destroyed Advanced Turret Factory','1','0','0','0'),
('ns','structure_built_team_armory',1,0,'','Built Armory','1','0','0','0'),
('ns','structure_destroyed_team_armory',2,0,'','Destroyed Armory','1','0','0','0'),
('ns','structure_built_team_turretfactory',1,0,'','Built Turret Factory','1','0','0','0'),
('ns','structure_destroyed_team_turretfactory',2,0,'','Destroyed Turret Factory','1','0','0','0'),
('ns','structure_built_turret',1,0,'','Built Turret','1','0','0','0'),
('ns','structure_destroyed_turret',2,0,'','Destroyed Turret','1','0','0','0'),
('ns','structure_built_team_infportal',1,0,'','Built INF Portal','1','0','0','0'),
('ns','structure_destroyed_team_infportal',2,0,'','Destroyed INF Portal','1','0','0','0'),
('ns','structure_built_defensechamber',1,0,'','Built Defense Chamber','1','0','0','0'),
('ns','structure_destroyed_defensechamber',2,0,'','Destroyed Defense Chamber','1','0','0','0'),
('ns','structure_built_offensechamber',1,0,'','Built Offense Chamber','1','0','0','0'),
('ns','structure_destroyed_offensechamber',2,0,'','Destroyed Offense Chamber','1','0','0','0'),
('ns','structure_built_movementchamber',1,0,'','Built Movement Chamber','1','0','0','0'),
('ns','structure_destroyed_movementchamber',2,0,'','Destroyed Movement Chamber','1','0','0','0'),
('ns','structure_built_team_hive',1,0,'','Built Alien Hive','1','0','0','0'),
('ns','structure_destroyed_team_hive',2,0,'','Destroyed Alien Hive','1','0','0','0'),
('ns','structure_built_team_armslab',1,0,'','Built Arms Lab','1','0','0','0'),
('ns','structure_destroyed_team_armslab',2,0,'','Destroyed Arms Lab','1','0','0','0'),
('ns','structure_built_sensorychamber',1,0,'','Built Sensory Chamber','1','0','0','0'),
('ns','structure_destroyed_sensorychamber',2,0,'','Destroyed Sensory Chamber','1','0','0','0'),
('ns','structure_built_team_prototypelab',1,0,'','Built Prototype Lab','1','0','0','0'),
('ns','structure_destroyed_team_prototypelab',2,0,'','Destroyed Prototype Lab','1','0','0','0'),
('ns','structure_built_team_command',1,0,'','Built Command Unit','1','0','0','0'),
('ns','structure_destroyed_team_command',2,0,'','Destroyed Command Unit','1','0','0','0'),
('ns','structure_built_team_observatory',1,0,'','Built Observatory','1','0','0','0'),
('ns','structure_destroyed_team_observatory',1,0,'','Destroyed Observatory','1','0','0','0'),
('ns','structure_built_team_advarmory',1,0,'','Built Advanced Armory','1','0','0','0'),
('ns','structure_destroyed_team_advarmory',1,0,'','Destroyed Advanced Armory','1','0','0','0'),
('ns','structure_built_scan',1,0,'','Built Scanner','1','0','0','0'),
('ns','structure_destroyed_scan',1,0,'','Destroyed Scanner','1','0','0','0'),
('ns','structure_built_weapon_grenadegun',1,0,'','Created a Grenade Gun','1','0','0','0'),
('ns','structure_built_weapon_heavymachinegun',1,0,'','Created a Heavy Machine Gun','1','0','0','0'),
('ns','structure_built_weapon_shotgun',1,0,'','Created a Shotgun','1','0','0','0'),
('ns','structure_built_weapon_welder',1,0,'','Created a Welder','1','0','0','0'),
('ns','structure_built_weapon_mine',1,0,'','Created a Mine','1','0','0','0'),
('ns','structure_built_item_heavyarmour',1,0,'','Created Heavy Armour','1','0','0','0'),
('ns','structure_built_item_catalyst',1,0,'','Created a Catalyst','1','0','0','0'),
('ns','structure_built_item_genericammo',1,0,'','Created Generic Ammo','1','0','0','0'),
('ns','structure_built_item_health',1,0,'','Created a Healthpack','1','0','0','0'),
('ns','structure_built_item_jetpack',1,0,'','Created a Jetpack','1','0','0','0'),
('ns','research_cancel',-1,0,'','Stopped Researching ','1','0','0','0'),
('ns', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('ns', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('ns', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('ns', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('ns', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('ns', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('ns', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('ns', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('ns', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('ns', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('ns', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('l4d', 'headshot', 0, 0, '', 'Headshot Kill', '1', '', '', ''),
('l4d', 'rescued_survivor', 2, 0, '', 'Rescued Teammate', '1', '0', '0', '0'),
('l4d', 'healed_teammate', 5, 0, '', 'Healed Teammate', '1', '0', '0', '0'),
('l4d', 'revived_teammate', 3, 0, '', 'Revived Teammate', '1', '0', '0', '0'),
('l4d', 'startled_witch', -5, 0, '', 'Startled the Witch', '1', '0', '0', '0'),
('l4d', 'pounce', 6, 0, '', '(Hunter) Pounced on Survivor', '0', '1', '0', '0'),
('l4d', 'tongue_grab', 6, 0, '', '(Smoker) Tongue Grabbed Survivor', '0', '1', '0', '0'),
('l4d', 'vomit', 6, 0, '', '(Boomer) Vomited on Survivor', '0', '1', '0', '0'),
('l4d', 'killed_gas', 1, 0, '', 'Killed a Smoker', '1', '0', '0', '0'),
('l4d', 'killed_exploding', 1, 0, '', 'Killed a Boomer', '1', '0', '0', '0'),
('l4d', 'killed_hunter', 1, 0, '', 'Killed a Hunter', '1', '0', '0', '0'),
('l4d', 'killed_tank', 3, 0, '', 'Killed a Tank', '1', '0', '0', '0'),
('l4d', 'killed_witch', 3, 0, '', 'Killed a Witch', '1', '0', '0', '0'),
('l4d', 'killed_survivor', 25, 0, '', 'Incapacitated/Killed Survivor', '0', '1', '0', '0'),
('l4d', 'friendly_fire', -10, 0, '', 'Friendly Fire', '1', '0', '0', '0'),
('l4d', 'cr0wned', 0, 0, '', 'Cr0wned (killed witch with single headshot)', '1', '', '', ''),
('l4d', 'hunter_punter', 0, 0, '', 'Hunter Punter (melee a Hunter mid-jump)', '1', '', '', ''),
('l4d', 'tounge_twister', 0, 0, '', 'Tounge Twister (kill a Smoker while he is dragging you)', '1', '', '', ''),
('l4d', 'protect_teammate', 0, 0, '', 'Protected Teammate', '1', '', '', ''),
('l4d', 'no_death_on_tank', 0, 0, '', 'No survivors died/incapped from tank', '1', '', '', ''),
('l4d', 'killed_all_survivors', 0, 0, '', 'Killed all survivors', '1', '', '', ''),
('l4d2', 'headshot', 0, 0, '', 'Headshot Kill', '1', '', '', ''),
('l4d2', 'killed_smoker', 1, 0, '', 'Killed a Smoker', '1', '', '', ''),
('l4d2', 'killed_boomer', 1, 0, '', 'Killed a Boomer', '1', '', '', ''),
('l4d2', 'killed_hunter', 1, 0, '', 'Killed a Hunter', '1', '', '', ''),
('l4d2', 'killed_tank', 3, 0, '', 'Killed a Tank', '1', '', '', ''),
('l4d2', 'killed_witch', 3, 0, '', 'Killed a Witch', '1', '', '', ''),
('l4d2', 'killed_spitter', 3, 0, '', 'Killed a Spitter', '1', '', '', ''),
('l4d2', 'killed_jockey', 3, 0, '', 'Killed a Jockey', '1', '', '', ''),
('l4d2', 'killed_charger', 3, 0, '', 'Killed a Charger', '1', '', '', ''),
('l4d2', 'killed_survivor', 25, 0, '', 'Incapacitated/Killed Survivor', '', '1', '', ''),
('l4d2', 'tongue_grab', 6, 0, '', '(Smoker) Tongue Grabbed Survivor', '', '1', '', ''),
('l4d2', 'scavenge_win', 0, 5, '', 'Scavenge Team Win', '', '', '1', ''),
('l4d2', 'versus_win', 0, 5, '', 'Versus Team Win', '', '', '1', ''),
('l4d2', 'defibrillated_teammate', 5, 0, '', 'Defibrillated Teammate', '1', '', '', ''),
('l4d2', 'used_adrenaline', 0, 0, '', 'Used Adrenaline', '1', '', '', ''),
('l4d2', 'jockey_ride', 5, 0, '', 'Going for a ride', '1', '', '', ''),
('l4d2', 'charger_pummel', 5, 0, '', 'Charger Pummeling', '1', '', '', ''),
('l4d2', 'bilebomb_tank', 5, 0, '', 'Tank Bilebombed', '1', '', '', ''),
('l4d2', 'spitter_acidbath', 5, 0, '', 'Spitter Acid', '1', '', '', ''),
('l4d2', 'rescued_survivor', 2, 0, '', 'Rescued Teammate', '1', '0', '0', '0'),
('l4d2', 'healed_teammate', 5, 0, '', 'Healed Teammate', '1', '0', '0', '0'),
('l4d2', 'revived_teammate', 3, 0, '', 'Revived Teammate', '1', '0', '0', '0'),
('l4d2', 'startled_witch', -5, 0, '', 'Startled the Witch', '1', '0', '0', '0'),
('l4d2', 'pounce', 6, 0, '', '(Hunter) Pounced on Survivor', '0', '1', '0', '0'),
('l4d2', 'vomit', 6, 0, '', '(Boomer) Vomited on Survivor', '0', '1', '0', '0'),
('l4d2', 'friendly_fire', -3, 0, '', 'Friendly Fire', '1', '0', '0', '0'),
('l4d2', 'cr0wned', 0, 0, '', 'Cr0wned (killed witch with single headshot)', '1', '', '', ''),
('l4d2', 'hunter_punter', 0, 0, '', 'Hunter Punter (melee a Hunter mid-jump)', '1', '', '', ''),
('l4d2', 'tounge_twister', 0, 0, '', 'Tounge Twister (kill a Smoker while he is dragging you)', '1', '', '', ''),
('l4d2', 'protect_teammate', 0, 0, '', 'Protected Teammate', '1', '', '', ''),
('l4d2', 'no_death_on_tank', 0, 0, '', 'No survivors died/incapped from tank', '1', '', '', ''),
('l4d2', 'killed_all_survivors', 0, 0, '', 'Killed all survivors', '1', '', '', ''),
('fof', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('fof', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('fof', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('fof', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('fof', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('fof', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('fof', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('fof', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('fof', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('fof', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('fof', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('fof', 'loot_drop', -2, 0, '', 'Dropped the loot', '1', '', '', ''),
('fof', 'loot_capture', 8, 0, '', 'Captured the loot', '1', '', '', ''),
('fof', 'carrier_protect', 5, 0, '', 'Protected the carrier', '1', '', '', ''),
('fof', 'headshot', 1, 0, '', 'Headshot Kill', '1', '', '', ''),
('ges', 'headshot', 1, 0, '', 'Headshot Kill', '1', '', '', ''),
('ges', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('ges', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('ges', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('ges', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('ges', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('ges', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('ges', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('ges', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('ges', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('ges', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('ges', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('ges', 'Round_Win', 5, 0, '', 'Round Win', '1', '', '', ''),
('ges', 'Round_Win_Team', 0, 3, '', 'Team Round Win', '', '', '1', ''),
('ges', 'GE_AWARD_DEADLY', 10, 0, '', 'Most Deadly', '1', '', '', ''),
('ges', 'GE_AWARD_HONORABLE', 5, 0, '', 'Most Honorable', '1', '', '', ''),
('ges', 'GE_AWARD_PROFESSIONAL', 10, 0, '', 'Most Professional', '1', '', '', ''),
('ges', 'GE_AWARD_MARKSMANSHIP', 1, 0, '', 'Marksmanship Award', '1', '', '', ''),
('ges', 'GE_AWARD_AC10', 2, 0, '', 'AC-10 Award', '1', '', '', ''),
('ges', 'GE_AWARD_FRANTIC', 2, 0, '', 'Most Frantic', '1', '', '', ''),
('ges', 'GE_AWARD_WTA', 1, 0, '', 'Where''s the Ammo?', '1', '', '', ''),
('ges', 'GE_AWARD_LEMMING', -1, 0, '', 'Lemming (suicide)', '1', '', '', ''),
('ges', 'GE_AWARD_LONGIN', 1, 0, '', 'Longest Innings', '1', '', '', ''),
('ges', 'GE_AWARD_SHORTIN', -1, 0, '', 'Shortest Innings', '1', '', '', ''),
('ges', 'GE_AWARD_DISHONORABLE', -10, 0, '', 'Most Dishonorable', '1', '', '', ''),
('ges', 'GE_AWARD_NOTAC10', 4, 0, '', 'Where''s the Armor?', '1', '', '', ''),
('ges', 'GE_AWARD_MOSTLYHARMLESS', -1, 0, '', 'Mostly Harmless', '1', '', '', ''),
('bg2', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('bg2', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('bg2', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('bg2', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('bg2', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('bg2', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('bg2', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('bg2', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('bg2', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('bg2', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('bg2', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('sgtls', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('sgtls', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('sgtls', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('sgtls', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('sgtls', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('sgtls', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('sgtls', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('sgtls', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('sgtls', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('sgtls', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('sgtls', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('sgtls', 'Goa''uld_Win', 5, 0, '', 'Goa''uld Won Round', '', '', '1', ''),
('sgtls', 'Tau''ri_Win', 5, 0, '', 'Tau''ri Won Round', '', '', '1', ''),
('dystopia', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('dystopia', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('dystopia', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('dystopia', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('dystopia', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('dystopia', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('dystopia', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('dystopia', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('dystopia', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('dystopia', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('dystopia', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('dystopia', 'Capture Guard Post', 2, 0, '', 'Capture Guard Post', '1', '', '', ''),
('dystopia', 'Capture Interior Spawn', 2, 0, '', 'Capture Interior Spawn', '1', '', '', ''),
('dystopia', 'Capture Internal Spawn', 2, 0, '', 'Capture Internal Spawn', '1', '', '', ''),
('dystopia', 'Capture The Docks', 2, 0, '', 'Capture The Docks', '1', '', '', ''),
('dystopia', 'Capture the Inner Base', 2, 0, '', 'Capture the Inner Base', '1', '', '', ''),
('dystopia', 'Capture the Spawn', 2, 0, '', 'Capture the Spawn', '1', '', '', ''),
('dystopia', 'Cut Entrance Spawn Power', 2, 0, '', 'Cut Entrance Spawn Power', '1', '', '', ''),
('dystopia', 'Defend Interior Spawn', 2, 0, '', 'Defend Interior Spawn', '1', '', '', ''),
('dystopia', 'Defend Middle Spawn', 2, 0, '', 'Defend Middle Spawn', '1', '', '', ''),
('dystopia', 'Defend Security JIP', 2, 0, '', 'Defend Security JIP', '1', '', '', ''),
('dystopia', 'Destroy Broadcast Server', 2, 0, '', 'Destroy Broadcast Server', '1', '', '', ''),
('dystopia', 'Destroy Cooling Access Door', 2, 0, '', 'Destroy Cooling Access Door', '1', '', '', ''),
('dystopia', 'Destroy Cooling Tank', 2, 0, '', 'Destroy Cooling Tank', '1', '', '', ''),
('dystopia', 'Destroy The Bulkhead', 2, 0, '', 'Destroy The Bulkhead', '1', '', '', ''),
('dystopia', 'Destroy The Core', 2, 0, '', 'Destroy The Core', '1', '', '', ''),
('dystopia', 'Destroy the Firewall', 2, 0, '', 'Destroy the Firewall', '1', '', '', ''),
('dystopia', 'Destroy the Reactor', 2, 0, '', 'Destroy the Reactor', '1', '', '', ''),
('dystopia', 'Destroy Transformer', 2, 0, '', 'Destroy Transformer', '1', '', '', ''),
('dystopia', 'Enable Auxilary Power Feed', 2, 0, '', 'Enable Auxilary Power Feed', '1', '', '', ''),
('dystopia', 'Enable The 4-Point Override', 2, 0, '', 'Enable The 4-Point Override', '1', '', '', ''),
('dystopia', 'Escort Hostage', 2, 0, '', 'Escort Hostage', '1', '', '', ''),
('dystopia', 'Hack Middle Spawn', 2, 0, '', 'Hack Middle Spawn', '1', '', '', ''),
('dystopia', 'Hack Spawn Controls', 2, 0, '', 'Hack Spawn Controls', '1', '', '', ''),
('dystopia', 'Hack the Perimeter', 2, 0, '', 'Hack the Perimeter', '1', '', '', ''),
('dystopia', 'Inject The Virus', 2, 0, '', 'Inject The Virus', '1', '', '', ''),
('dystopia', 'Launch Missile', 2, 0, '', 'Launch Missile', '1', '', '', ''),
('dystopia', 'Locate profile', 2, 0, '', 'Locate profile', '1', '', '', ''),
('dystopia', 'Maintain Power Routing', 2, 0, '', 'Maintain Power Routing', '1', '', '', ''),
('dystopia', 'Open And Destroy Data Stores / Establish An Uplink', 2, 0, '', 'Open And Destroy Data Stores / Establish An Uplink', '1', '', '', ''),
('dystopia', 'Redirect Laser', 2, 0, '', 'Redirect Laser', '1', '', '', ''),
('dystopia', 'Reroute Power To Control Room', 2, 0, '', 'Reroute Power To Control Room', '1', '', '', ''),
('dystopia', 'Shut Down Security', 2, 0, '', 'Shut Down Security', '1', '', '', ''),
('dystopia', 'Shutdown The Production Line', 2, 0, '', 'hutdown The Production Line', '1', '', '', ''),
('dystopia', 'Smash Data Storage', 2, 0, '', 'Smash Data Storage', '1', '', '', ''),
('dystopia', 'Turn Power Offline', 2, 0, '', 'Turn Power Offline', '1', '', '', ''),
('nts', 'headshot', 5, 0, '', 'Headshot Kill', '1', '0', '0', '0'),
('nts', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '0', '0', '0'),
('nts', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '0', '0', '0'),
('nts', 'kill_streak_12', 15, 0, '', 'God Like (12+ kills)', '1', '0', '0', '0'),
('nts', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '0', '0', '0'),
('nts', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '0', '0', '0'),
('nts', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '0', '0', '0'),
('nts', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '0', '0', '0'),
('nts', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '0', '0', '0'),
('nts', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '0', '0', '0'),
('nts', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '0', '0', '0'),
('nts', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '0', '0', '0'),
('nts', 'Round_Win', 0, 20, '', 'Team Round Win', '0', '0', '1', '0'),
('pvkii', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('pvkii', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('pvkii', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('pvkii', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('pvkii', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('pvkii', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('pvkii', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('pvkii', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('pvkii', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('pvkii', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('pvkii', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('pvkii', 'kill assist', 2, 0, '', 'Kill Assist', '1', '0', '0', '0'),
('pvkii', 'mvp1', 5, 0, '', 'Most Valuable Player #1', '1', '0', '0', '0'),
('pvkii', 'mvp2', 0, 0, '', 'Most Valuable Player #2', '1', '0', '0', '0'),
('pvkii', 'mvp3', 0, 0, '', 'Most Valuable Player #3', '1', '0', '0', '0'),
('pvkii', 'chest_capture', 3, 0, '', 'Chest Capture', '1', '0', '0', '0'),
('pvkii', 'chest_defend', 2, 0, '', 'Chest Defend', '1', '0', '0', '0'),
('pvkii', 'obj_complete', 3, 0, '', 'Complted Objective', '1', '0', '0', '0'),
('pvkii', 'grail_defend', 2, 0, '', 'Defended Grail', '1', '0', '0', '0'),
('pvkii', 'killed_parrot', 1, 0, '', 'Killed Parrot', '1', '0', '0', '0'),
('pvkii', 'domination', 5, 0, '', 'Domination', '0', '1', '0', '0'),
('pvkii', 'revenge', 3, 0, '', 'Revenge', '0', '1', '0', '0'),
('csp', 'headshot', 1, 0, '', 'Headshot', '1', '', '', ''),
('csp', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('csp', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('csp', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('csp', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('csp', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('csp', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('csp', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('csp', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('csp', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('csp', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('csp', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('valve', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('valve', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('valve', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('valve', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('valve', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('valve', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('valve', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('valve', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('valve', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('valve', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('valve', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('valve', 'headshot', 1, 0, '', 'Headshot Kill', '1', '0', '0', '0'),
('nd', 'headshot', 1, 0, '', 'Headshot', '1', '0', '0', '0'),
('nd', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '0', '0', '0'),
('nd', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '0', '0', '0'),
('nd', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '0', '0', '0'),
('nd', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '0', '0', '0'),
('nd', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '0', '0', '0'),
('nd', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '0', '0', '0'),
('nd', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '0', '0', '0'),
('nd', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '0', '0', '0'),
('nd', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '0', '0', '0'),
('nd', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '0', '0', '0'),
('nd', 'kill_streak_12', 11, 0, '', 'God Like (12 kills)', '1', '0', '0', '0'),
('nd', 'round_win', 0, 20, 'Consortium', 'Consortium Win Round', '0', '0', '1', '0'),
('nd', 'round_win', 0, 20, 'Empire', 'Empire Win Round', '0', '0', '1', '0'),
('nd', 'round_lose', 0, -20, 'Consortium', 'Consortium Lose Round', '0', '0', '1', '0'),
('nd', 'round_lose', 0, -20, 'Empire', 'Empire Lose Round', '0', '0', '1', '0'),
('nd', 'structure_kill', 0, 20, 'Consortium', 'Empire Structure Destroyed', '1', '0', '1', '0'),
('nd', 'structure_kill', 0, 20, 'Empire', 'Consortium Structure Destroyed', '1', '0', '1', '0'),
('nd', 'killed_commander', 5, 0, '', 'Killed the enemy commander', '1', '0', '0', '0'),
('nd', 'promoted_to_commander', 10, 0, '', 'Promoted to commander', '1', '0', '0', '0'),
('nd', 'damaged_opposite_bunker', 0, 1, '', '500dmg at enemy bunker', '0', '0', '1', '0'),
('nd', 'resource_captured', 0, 1, '', 'Captured resource', '0', '0', '1', '0'),
('nd', 'armoury_destroyed', 10, 0, '', 'Destroyed Armory', '1', '0', '0', '0'),
('nd', 'artillery_destroyed', 10, 0, '', 'Destroyed Artillery', '1', '0', '0', '0'),
('nd', 'assembler_destroyed', 10, 0, '', 'Destroyed Assembler', '1', '0', '0', '0'),
('nd', 'flamethrowerturret_destroyed', 10, 0, '', 'Destroyed Empire Flamethrower Turret', '1', '0', '0', '0'),
('nd', 'wirelessrepeater_destroyed', 10, 0, '', 'Destroyed Consortium Wireless Repeater', '1', '0', '0', '0'),
('nd', 'powerstation_destroyed', 10, 0, '', 'Destroyed Power Station', '1', '0', '0', '0'),
('nd', 'radar_destroyed', 10, 0, '', 'Destroyed Radar Station', '1', '0', '0', '0'),
('nd', 'powerrelay_destroyed', 10, 0, '', 'Destroyed Empire Relay Tower', '1', '0', '0', '0'),
('nd', 'rocketturret_destroyed', 10, 0, '', 'Destroyed Rocket Turret', '1', '0', '0', '0'),
('nd', 'sonicturret_destroyed', 10, 0, '', 'Destroyed Consortium Sonic Turret', '1', '0', '0', '0'),
('nd', 'supply_destroyed', 10, 0, '', 'Destroyed Supply Station', '1', '0', '0', '0'),
('nd', 'transportgate_destroyed', 10, 0, '', 'Destroyed Transport Gate', '1', '0', '0', '0'),
('nd', 'machineguneturret_destroyed', 10, 0, '', 'Destroyed Machinegun Turret', '1', '0', '0', '0'),
('csgo', 'Begin_Bomb_Defuse_Without_Kit', 0, 0, 'CT', 'Start Defusing the Bomb Without a Defuse Kit', '1', '0', '0', '0'),
('csgo', 'Begin_Bomb_Defuse_With_Kit', 0, 0, 'CT', 'Start Defusing the Bomb With a Defuse Kit', '1', '0', '0', '0'),
('csgo', 'Planted_The_Bomb', 10, 2, 'TERRORIST', 'Plant the Bomb', '1', '0', '0', '0'),
('csgo', 'Defused_The_Bomb', 10, 0, 'CT', 'Defuse the Bomb', '1', '0', '0', '0'),
('csgo', 'Touched_A_Hostage', 0, 0, 'CT', 'Touch a Hostage', '1', '0', '0', '0'),
('csgo', 'Rescued_A_Hostage', 5, 1, 'CT', 'Rescue a Hostage', '1', '0', '0', '0'),
('csgo', 'Killed_A_Hostage', -15, 1, 'CT', 'Kill a Hostage', '1', '0', '0', '0'),
('csgo', 'Spawned_With_The_Bomb', 2, 0, 'TERRORIST', 'Spawn with the Bomb', '1', '0', '0', '0'),
('csgo', 'Got_The_Bomb', 2, 0, 'TERRORIST', 'Pick up the Bomb', '1', '0', '0', '0'),
('csgo', 'Dropped_The_Bomb', -2, 0, 'TERRORIST', 'Drop the Bomb', '1', '0', '0', '0'),
('csgo', 'SFUI_Notice_CTs_Win', 0, 2, 'CT', 'All Terrorists eliminated', '0', '0', '1', '0'),
('csgo', 'SFUI_Notice_Terrorists_Win', 0, 2, 'TERRORIST', 'All Counter-Terrorists eliminated', '0', '0', '1', '0'),
('csgo', 'SFUI_Notice_All_Hostages_Rescued', 0, 10, 'CT', 'Counter-Terrorists rescued all the hostages', '0', '0', '1', '0'),
('csgo', 'SFUI_Notice_Target_Bombed', 0, 5, 'TERRORIST', 'Terrorists bombed the target', '0', '0', '1', '0'),
('csgo', 'SFUI_Notice_Bomb_Defused', 0, 5, 'CT', 'Counter-Terrorists defused the bomb', '0', '0', '1', '0'),
('csgo', 'Escaped_As_VIP', 0, 10, 'CT', 'VIP escaped', '0', '0', '1', '0'),
('csgo', 'Assassinated_The_VIP', 0, 6, 'TERRORIST', 'Terrorists assassinated the VIP', '0', '0', '1', '0'),
('csgo', 'Became_VIP', 1, 0, 'CT', 'Become the VIP', '1', '0', '0', '0'),
('csgo', 'headshot', 1, 0, '', 'Headshot', '1', '0', '0', '0'),
('csgo', 'round_mvp', 0, 0, '', 'Round MVP', '1', '0', '0', '0'),
('csgo', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '0', '0', '0'),
('csgo', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '0', '0', '0'),
('csgo', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '0', '0', '0'),
('csgo', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '0', '0', '0'),
('csgo', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '0', '0', '0'),
('csgo', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '0', '0', '0'),
('csgo', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '0', '0', '0'),
('csgo', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '0', '0', '0'),
('csgo', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '0', '0', '0'),
('csgo', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '0', '0', '0'),
('csgo', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '0', '0', '0'),
('csgo', 'domination', 5, 0, '', 'Domination', '0', '1', '0', '0'),
('csgo', 'revenge', 3, 0, '', 'Revenge', '0', '1', '0', '0'),
('dinodday', 'headshot', 3, 0, '', 'Boom! Headshot!', '1', '0', '0', '0'),
('dinodday', 'kill_goat', -10, 0, '', 'Defenseless Goat murdered', '1', '0', '0', '0'),
('dinodday', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '0', '0', '0'),
('dinodday', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '0', '0', '0'),
('dinodday', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '0', '0', '0'),
('dinodday', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '0', '0', '0'),
('dinodday', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '0', '0', '0'),
('dinodday', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '0', '0', '0'),
('dinodday', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '0', '0', '0'),
('dinodday', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '0', '0', '0'),
('dinodday', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '0', '0', '0'),
('dinodday', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '0', '0', '0'),
('dinodday', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '0', '0', '0');


-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Awards`
--

CREATE TABLE IF NOT EXISTS `hlstats_Awards` (
  `awardId` int(10) unsigned NOT NULL auto_increment,
  `awardType` CHAR( 1 ) NOT NULL DEFAULT 'W',
  `game` varchar(32) NOT NULL default 'valve',
  `code` varchar(128) NOT NULL default '',
  `name` varchar(128) NOT NULL default '',
  `verb` varchar(128) NOT NULL default '',
  `d_winner_id` int(10) unsigned default NULL,
  `d_winner_count` int(10) unsigned default NULL,
  `g_winner_id` int(10) unsigned default NULL,
  `g_winner_count` int(10) unsigned default NULL,  
  PRIMARY KEY  (`awardId`),
  UNIQUE KEY `code` (`game`,`awardType`,`code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Awards`
--

INSERT INTO `hlstats_Awards` (`awardType`, `game`, `code`, `name`, `verb`) VALUES
('P','tf','domination','Dominator','dominations'),
('V','tf','domination','Most dominated','times dominated'),
('P','tf','revenge','King of vengence','revenges'),
('W','tf','tf_projectile_pipe_remote','Remote Demolition Man','pipe bomb kills'),
('W','tf','tf_projectile_pipe','Demolition Man','pipe bomb kills'),
('W','tf','sniperrifle','Top Sniper','snipings'),
('W','tf','smg','Submachine gun','smg kills'),
('W','tf','shotgun_soldier','Shotgun Soldier','shotgun kills'),
('W','tf','shotgun_pyro','Shotgun Pyro','shotgun kills'),
('W','tf','shotgun_primary','Shotgun','shotgun kills'),
('W','tf','scattergun','Fast and Furious','scattergun kills'),
('W','tf','revolver','Wayne','revolver kills'),
('W','tf','pistol','Pistol','pistol kills'),
('W','tf','allsentrykills','Engineer','sentry kills'),
('W','tf','minigun','Terminator','minigun kills'),
('W','tf','knife','Stabber','knifings'),
('W','tf','flamethrower','Pyro','flame burnings'),
('W','tf','bat','Baseball freak','bat kills'),
('O','tf','pointcaptured','Capturer','checkpoint captures'),
('O','tf','kill assist','Assistance','kill assists'),
('O','tf','captureblocked','Blocker','checkpoint blockings'),
('O','tf','chargedeployed','Ubermedic','deployed charges'),
('W','tf','latency','Best Latency','ms average connection'),
('W','tf','tf_projectile_rocket','Soldier','rocket kills'),
('W','tf','wrench','Engineer on Rage','wrench kills'),
('W','tf','shovel','Grave Digger','shovel kills'),
('W','tf','fireaxe','Axe-O-Mania','axe kills'),
('W','tf','bottle','Drunken Demoman','bottle kills'),
('W','tf','bonesaw','The Saw','sawed bones'),
('W','tf','fists','Fisting king','fistings'),
('W','tf','club','Now that''s a knife','machete kills'),
('W','tf','pistol_scout','Scout Pistol','pistol kills'),
('W','tf','shotgun_hwg','Shotgun Heavy','shotgun kills'),
('W','tf','syringegun_medic','The Injector','syringe kills'),
('W','tf','axtinguisher', 'Axtinguisher', 'kills with the axtinguisher'),
('W','tf','backburner', 'Backburner', 'burned backs'),
('W','tf','blutsauger', 'Blutsauger', 'times sucked blood'),
('W','tf','flaregun', 'Flare Gun', 'flare gun kills'),
('W','tf','gloves', 'Heavy surgery', 'KGB kills'),
('W','tf','natascha', 'Nataschas Friend', 'Natascha kills'),
('W','tf','ubersaw', 'Ubersaw', 'kills with ubersaw'),
('W','tf','deflect_flare', 'Deflected Flare', 'kills with deflected flare'),
('W','tf','telefrag', 'Lucky Duck', 'kills by telefrag'),
('W','tf','deflect_promode', 'Deflected Grenade', 'kills with deflected grenade'),
('W','tf','deflect_rocket', 'On the Rebound', 'kills with deflected rocket'),
('W','tf','deflect_sticky', 'Deflected Sticky', 'kills with deflected sticky'),
('W','tf','deflect_arrow', 'Deflected Arrow', 'kills with deflected arrow'),
('W','tf','taunt_heavy', 'POW! Ha Ha', 'kills with heavy taunt'),
('W','tf','taunt_pyro', 'Hadouken', 'kills with Hadouken'),
('W','tf','mostkills','Most Kills','kills'),
('W','tf','bonuspoints','Most Bonus Points','bonus points'),
('O','tf', 'sandvich', 'Hungry Hungry Heavy', 'sandviches eaten'),
('O','tf', 'backstab', 'Backstabber', 'backstabs'),
('O','tf','flagevent_defended','Defender of the Flag','flag defenses'),
('O','tf','flagevent_captured','The Mad Capper','flag captures'),
('O','tf','killedobject_obj_dispenser','NO METAL FOR YOU!','dispensers destroyed'),
('O','tf','killedobject_obj_sentrygun','Say no to sentries','sentry guns destroyed'),
('O','tf','killedobject_obj_sentrygun_mini','Say no to mini sentries','mini sentry guns destroyed'),
('O','tf','builtobject_obj_sentrygun','Bob the Builder','sentry guns built'),
('O','tf','builtobject_obj_sentrygun_mini','Mini Bob the Builder','mini sentry guns built'),
('O','tf','builtobject_obj_attachment_sapper','Super Sapper','sappers placed'),
('O','tf','kill_assist_medic','Medic Assistance','medic assists'),
('P','tf','stun','Absolutely Stunning','stuns'),
('O','tf','pyro_extinguish', 'Give It a Little Blow', 'extinguishes with Flamethrower'),
('O','tf','sniper_extinguish', 'Douser', 'extinguishes with Jarate'),
('O','tf','medic_extinguish', 'Medic Extinguish', 'extinguishes with Heal Gun'),
('O','tf','engineer_extinguish', 'Engineer Extinguish', 'extinguishes with Dispenser'),
('W','tf','force_a_nature', 'Who wants some of this?', 'kills with the Force-A-Nature'),
('W','tf','ambassador', 'Diplomatic Immunity', 'kills with the Ambassador'),
('W','tf','tf_projectile_arrow', 'Quivering Fool', 'kills with the Huntsman'),
('W','tf','taunt_spy', 'Dangerous Crab', 'spy taunt kills'),
('W','tf','taunt_sniper', 'Robin Hood', 'sniper taunt kills'),
('P','tf','shield_blocked', 'Razor Breakin', 'razorbacks broken'),
('V','tf','shield_blocked','Broken Back','razorbacks broken (sniper)'),
('P','tf','jarate', 'Urine'' For A Surprise', 'jarates'),
('V','tf','jarate','Yellow Bellied Spies','victims jarated'),
('W','tf','tf_pumpkin_bomb', 'Pumpkin Bomber', 'kills with a pumpkin bomb'),
('O','tf', 'mvp1', 'Most Valuable Player', 'wins as Most Valuable Player'),
('W','tf','taunt_scout', 'Not even winded', 'scout taunt kills'),
('W','tf','sandman', 'Batter Up!', 'kills with the Sandman'),
('W','tf','rocketlauncher_directhit', 'Skill Rockets', 'kills with the Direct Hit'),
('W','tf','unique_pickaxe', 'Prospectors Piercings', 'kills with the Equalizer'),
('W','tf','sword', 'Swords a Slicing', 'kills with the Eyelander'),
('W','tf','sticky_resistance', 'Skill Stickies', 'kills with the Scottish Resistance'),
('W','tf','taunt_demoman', 'Sword Swallowers', 'Demoman taunt kills'),
('W','tf','taunt_soldier', 'Good-bye Cruel Worlds', 'Soldier taunt kills'),
('O','tf','buff_deployed', 'Rootin Tootin Shootin', 'Buffs deployed'),
('O','tf','defended_medic', 'Get behind me doctor!', 'Medics defended'),
('W','tf','demoshield', 'Got something for ya!', 'kills with the Chargin'' Targe'),
('O','tf','builtobject_obj_dispenser', 'Dispenser Here!', 'Dispensers built'),
('P','tf','steal_sandvich', 'Mmm, Ham', 'stolen Sandviches'),
('O','tf','teleport', 'One to beam up!', 'players Teleported'),
('W','tf','tf_projectile_arrow_fire', 'Fire Flight', 'kills with the Flaming Huntsman'),
('O','tf','killed_charged_medic', 'Juice Loosener', 'Charged Medics killed'),
('W','tf','ball', 'Fly Ball', 'kills with the Baseball'),
('W','tf','taunt_medic', 'Oktoberfest!', 'medic taunt kills'),
('W','tf','paintrain', 'Come on ride THE PAIN TRAIN', 'kills with The Pain Train'),
('W','tf','sledgehammer', 'Homewreckin', 'kills with The Homewrecker'),
('W','tf','tribalkukri', 'The Tribalman''s Shiv', 'kills with The Tribalman''s Shiv'),
('W','tf','battleaxe', 'Scotsman''s Skullcutter', 'kills with The Scotsman''s Skullcutter'),
('W','tf','frontier_justice', 'Justified Kills', 'kills with the Frontier Justice'),
('W','tf','obj_minisentry', 'It''s Little and Cute and Ben''s Sister Likes It', 'Mini Sentry Gun kills'),
('W','tf','robot_arm', 'Slings Slung', 'kills with the Gunslinger'),
('W','tf','robot_arm_combo_kill', 'One, Two, Punch!', 'Gunslinger Combo Kills'),
('W','tf','robot_arm_blender_kill', 'Mixed ya right up!', 'Engineer taunt kills (Gunslinger)'),
('W','tf','bleed_kill', 'We''ve got a bleeder', 'bleed kills'),
('W','tf','southern_hospitality', 'Southern This!', 'kills with the Southern Hospitality'),
('W','tf','taunt_guitar_kill', 'Despite all my rage there''s a Guitar on your head', 'Engineer taunt kills (Guitar)'),
('W','tf','wrangler_kill', 'Rustlers Wrangled', 'kills with the Wrangler'),
('W','tf','battleneedle', 'Take your Vita-Saws', 'kills with The Vita-Saw'),
('W','tf','powerjack', 'Powerjacking', 'kills with The Powerjack'),
('W','tf','degreaser', 'Degreased', 'kills with The Degreaser'),
('W','tf','short_stop', 'Stopping Short', 'kills with The Shortstop'),
('W','tf','holy_mackerel', 'Something''s Fishy', 'kills with The Holy Mackerel'),
('W','tf','letranger', 'Ranged', 'kills with the L''Etranger'),
('W','tf','eternal_reward', 'It goes on and on...', 'kills with Your Eternal Reward'),
('W','tf','fryingpan', 'Fried Egg', 'kills with the Frying Pan'),
('W','tf','bushwacka', 'George Bushwacka', 'kills with The Bushwacka'),
('W','tf','gloves_running_urgently', 'It''s Urgent', 'kills with the Gloves of Running Urgently'),
('W','tf','blackbox', 'What''s in the box?', 'kills with The Black Box'),
('W','tf','sydney_sleeper', 'Down Under', 'kills with The Sydney Sleeper'),
('O','tf','dalokohs', 'Dalokohs is delicious!', 'Dalokohs eaten'),
('O','tf','hit_by_train', 'Flattened', 'deaths from train'),
('O','tf','headshot', 'Headache', 'headshots'),
('W','tf','suicide', 'Doctor Assited Suicide', 'suicides'),
('O', 'tf', 'steak', 'Don''t Run, Its Just Steak', 'Buffalo Steak Sandviches eaten'),
('W', 'tf', 'claidheamohmor', 'Claidheamohmor', 'Claidheamohmor kills'),
('W', 'tf', 'back_scratcher', 'Rakes Wrecked', 'Back Scratcher kills'),
('W', 'tf', 'boston_basher', 'Boston Basher', 'Boston Basher kills'),
('W', 'tf', 'steel_fists', 'My Fists They Are Made Of Steel!', 'kills with the Fists of Steel'),
('W', 'tf', 'amputator', 'Amputator', 'Amputator kills'),
('W', 'tf', 'crusaders_crossbow', 'Bolts Blown', 'Crusader''s Crossbow kills'),
('W', 'tf', 'ullapool_caber', 'Caber''s Clubbed', 'Caber bash kills'),
('W', 'tf', 'ullapool_caber_explosion', 'Boom Sticka', 'Caber BOOM kills'),
('W', 'tf', 'loch_n_load', 'Loch-n-Load''d', 'Loch-n-Load kills'),
('W', 'tf', 'brass_beast', 'Brass Beast', 'Brass Beast kills'),
('W', 'tf', 'warrior_spirit', 'Clawed Candyasses', 'Warrior''s Spirit kills'),
('W', 'tf', 'candy_cane', 'Canes Cracked', 'Candy Cane kills'),
('W', 'tf', 'wrench_jag', 'Jag''d Off', 'Jag kills'),
('W', 'tf', 'iron_curtain', 'In Soviet Russia Iron Curtain Owns You', 'Iron Curtain kills'),
('W', 'tf', 'headtaker', 'Horseless Headless Horseman''s Headtaker', 'Horseless Headless Horseman''s Headtaker kills'),
('P', 'tf', 'madmilk', 'Creamed', 'Mad Milk hits'),
('W', 'tf', 'atomizer', 'Atoms Split', 'Atomizer kills'),
('W', 'tf', 'bazaar_bargain', 'Bargins Earned', 'Bazaar Bargain kills'),
('W', 'tf', 'demokatana', 'Samurai Swipes', 'Half-Zatoichi kills'),
('W', 'tf', 'detonator', 'Detonations Served', 'Detonator kills'),
('W', 'tf', 'disciplinary_action', 'Disciplined to Death', 'Disciplinary Action kills'),
('W', 'tf', 'enforcer', 'Deaths Enforced', 'Enforcer kills'),
('W', 'tf', 'eviction_notice', 'Souls Evicted', 'Eviction Notice kills'),
('W', 'tf', 'family_business', 'Cement Shoes Dispensed', 'Family Business kills'),
('W', 'tf', 'kunai', 'Spikes Implanted', 'Conniver\'s Kunai kills'),
('W', 'tf', 'lava_axe', 'Fragments Fragged', 'Sharpened Volcano Fragment kills'),
('W', 'tf', 'lava_bat', 'Afterlives Brightened', 'Sun-on-a-Stick kills'),
('W', 'tf', 'liberty_launcher', 'Lives Liberated', 'Liberty Launcher kills'),
('W', 'tf', 'mantreads', 'Goombas Stomped', 'Mantreads kills'),
('W', 'tf', 'market_gardener', 'Garden Graves Dug', 'Market Gardener kills'),
('W', 'tf', 'persian_persuader', 'Persons Persuaded', 'Persian Persuader kills'),
('W', 'tf', 'proto_syringe', 'Patients Overdosed', 'Overdose kills'),
('W', 'tf', 'reserve_shooter', 'Reservations Made', 'Reserve Shooter kills'),
('W', 'tf', 'scout_sword', 'Rune Slices Served', 'Three-Rune Blade kills'),
('W', 'tf', 'shahanshah', 'Shahaha UR Dead', 'Shahanshah kills'),
('W', 'tf', 'soda_popper', 'Souls Popped', 'Soda Popper kills'),
('W', 'tf', 'solemn_vow', 'Busts Busted', 'Solemn Vow kills'),
('W', 'tf', 'the_maul', 'Men Mauled', 'Maul kills'),
('W', 'tf', 'the_winger', 'Warriors Winged', 'Winger kills'),
('W', 'tf', 'tomislav', 'Tomis Tapped', 'Tomislav kills'),
('W', 'tf', 'warfan', 'Fans Made', 'Fan O\'War kills'),
('W', 'tf', 'big_earner', 'Suckers Stuck', 'Big Earner kills'),
('W', 'tf', 'saxxy', 'Hale No', 'Saxxy kills'),
('W', 'tf', 'splendid_screen', 'Full Speed Ahead', 'Splendid Screen kills'),
('W', 'tf', 'taunt_soldier_lumbricus', 'Hallelujah!', 'Kamikaze (Lumbricus Lid) kills'),
('W', 'tf', 'nessieclub', 'Hole in One', 'Nessie\'s Nine Iron kills'),
('W', 'tf', 'mailbox', 'Mail\'s Here', 'Postal Pummeler kills'),
('O', 'tf', 'scout_extinguish', 'Milk - does a body good', 'extinguishes with Mad Milk'),
('W', 'tf', 'cow_mangler', 'Cows Mangled', 'Cow Mangler 5000 kills'),
('W', 'tf', 'righteous_bison', 'Bisons Blasted', 'Righteous Bison kills'),
('W', 'tf', 'tf_projectile_energy_ball', 'Save A Cow, Eat mor Chikin', 'Deflected Cow Mangler Shot kills'),
('W', 'tf', 'machina', 'Problems Solved', 'Machina kills'),
('W', 'tf', 'diamondback', 'Souls Rattled', 'Diamondback kills'),
('W', 'tf', 'widowmaker', 'Widows Made', 'Widowmaker kills'),
('W', 'tf', 'short_circuit', 'Circuits Shorted', 'Short Circuit kills'),
('W', 'tf', 'quake_rl', 'Boots Quaked', 'Original kills'),
('W', 'tf', 'scotland_shard', 'Hands Shook', 'Scottish Handshake kills'),
('W', 'tf', 'nonnonviolent_protest', 'Signed Petitioners', 'Conscientious Objector kills'),
('W', 'tf', 'deflect_flare_detonator', 'Reflected Detonation', 'Defected Flare (Detonator) kills'),
('W', 'tf', 'deflect_huntsman_flyingburn', 'Reflected Burn', 'Defected Huntsman Burning Arrow kills'),
('W', 'tf', 'unarmed_combat', 'Armed Robbery', 'Unarmed Combat kills'),
('O', 'tf', 'player_penetration', 'In and Out', 'players penetrated'),
('O', 'tf', 'builtobject_obj_teleporter', 'Proceed to android hell', 'teleporters built'),
('O', 'tf', 'death_sawblade', 'Blades of Glory', 'deaths to a sawblade'),
('O', 'tf', 'killedobject_obj_attachment_sapper', 'Sap This!', 'sappers removed'),
('O', 'tf', 'killedobject_obj_teleporter', 'Take a walk!', 'teleporters killed'),
('W', 'tf', 'eureka_effect', 'Eureka!', 'Eureka Effect kills'),
('W', 'tf', 'holiday_punch', 'The Gift of Punch', 'Holiday Punch kills'),
('W', 'tf', 'manmelter', 'Melted Men', 'Manmelter kills'),
('W', 'tf', 'phlogistinator', 'Phlogged', 'Phlogistinator kills'),
('W', 'tf', 'pomson', 'Convenient Radiation', 'Pomson 6000 kills'),
('W', 'tf', 'spy_cicle', 'Cold as ice', 'Spy-cicle kills'),
('W', 'tf', 'thirddegree', 'Ooooh burn!', 'Third Degree kills'),
('W', 'tf', 'wrap_assassin', 'Wrapping Machine', 'Wrap Assassin kills'),
('W', 'tf', 'pep_pistol', 'Lookin Good', 'Pretty Boy\'s Pocket Pistol kills'),
('W', 'tf', 'pep_brawlerblaster', 'Baby Face', 'Baby Face\'s Blaster kills'),
('W', 'tf', 'dumpster_device', 'Don\'t Beg', 'Beggar\'s Bazooka kills'),
('W', 'tf', 'pro_smg', 'Cleaning Time', 'The Cleaner\'s Carbine kills'),
('W', 'tf', 'pro_rifle', 'Making Heat', 'The Hitman\'s Heatmaker kills'),
('W', 'tf', 'rainblower', 'The Rainman', 'The Rainblower kills'),
('W', 'tf', 'lollichop', 'Free Candy', 'The Lollichop kills'),
('W', 'tf', 'scorchshot', 'Scorcher', 'The Scorch Shot kills'),
('W', 'tf', 'unique_pickaxe_escape', 'The Great Escape', 'The Escape Plan kills'),
('O','hl2mp','headshot','Headshot King','headshot kills'),
('W','hl2mp','crowbar','01. (Crowbar) Rebel for Life','guys slaughtered and some more fleshwounds'),
('W','hl2mp','physics','04. (Physics) Bummsmaster','kills with the Zeropoint Energyfield Manipulator'),
('W','hl2mp','physbox','05. (Physbox) Baffmaster','hits with this and that'),
('W','hl2mp','stunstick','02. (Stunstick) Stockmaster','guys beatn up'),
('W','hl2mp','pistol','03. (Pistol) Freakin Pistol Freak','times freaked out'),
('W','hl2mp','shotgun','09. (Pumpgun) Duckmaster','kills with the Duckmaster2k'),
('W','hl2mp','357','08. (.357) Peacemaker','Killshots'),
('W','hl2mp','smg1','14. (SMG) SMG Killer','kills with the SMGay'),
('W','hl2mp','ar2','11. (AR2) Rattertante','kills with the assault rifle'),
('W','hl2mp','crossbow_bolt','10. (Crossbow) Robin Hood','guys killed instantly'),
('W','hl2mp','slam','12. (Slam) Trapmaster','guys trapped and killed'),
('W','hl2mp','grenade_frag','06. (Grenade) Nadethrower 2k','guys nuked'),
('W','hl2mp','rpg_missile','16. (RPG) Clumsy Smurf found the RPG!','times pissed in the pants'),
('W','hl2mp','combine_ball','07. (Combine Balls) Ball Player','guys set on fire'),
('W','hl2mp','smg1_grenade','13. (SMG Nade) SMG Nader','guys exploded by him'),
('W','hl2mp','latency','15. (Latency) Lowpinger','ms average'),
('W','hl2mp','mostkills','17. Most Kills','kills'),
('W','hl2mp','suicide','18. Most Suicides','suicides'),
('W', 'css', 'awp', 'AWP', 'kills with awp'),
('W', 'css', 'latency', 'Best Latency', 'ms average connection'),
('W', 'css', 'galil', 'Galil', 'kills with galil'),
('W', 'css', 'famas', 'Fusil Automatique', 'kills with famas'),
('W', 'css', 'ak47', 'AK47', 'kills with ak47'),
('W', 'css', 'glock', 'Glock', 'kills with glock'),
('W', 'css', 'm4a1', 'Colt M4A1 Carbine', 'kills with m4a1'),
('W', 'css', 'usp', 'USP Master', 'kills with usp'),
('W', 'css', 'm3', 'M3 Shotgun', 'kills with m3 shotgun'),
('W', 'css', 'deagle', 'Desert Eagle', 'kills with deagle'),
('W', 'css', 'p90', 'P 90', 'kills with p90'),
('W', 'css', 'knife', 'Knife Maniac', 'knifings'),
('W', 'css', 'elite', 'Dual Berretta Elites', 'kills with elite'),
('O', 'css', 'Rescued_A_Hostage', 'Top Hostage Rescuer', 'hostages rescued'),
('O', 'css', 'Planted_The_Bomb', 'Top Demolitionist', 'bomb plantings'),
('O', 'css', 'Defused_The_Bomb', 'Top Defuser', 'bomb defusions'),
('W', 'css', 'aug', 'Steyr Aug', 'kills with aug'),
('W', 'css', 'fiveseven', 'Five Seven', 'kills with fiveseven'),
('W', 'css', 'g3sg1', 'G3 SG1', 'kills with g3sg1'),
('W', 'css', 'm249', 'Para', 'kills with m249'),
('W', 'css', 'mac10', 'Mac 10', 'kills with mac10'),
('W', 'css', 'mp5navy', 'MP5 Navy', 'kills with mp5'),
('W', 'css', 'p228', 'P 228', 'kills with p228'),
('W', 'css', 'sg550', 'SG 550', 'kills with sg550'),
('W', 'css', 'sg552', 'SG 552', 'kills with sg552'),
('W', 'css', 'tmp', 'TMP', 'kills with tmp'),
('W', 'css', 'ump45', 'UMP 45', 'kills with ump45'),
('W', 'css', 'xm1014', 'XM automatic Shotgun', 'kills with xm1014'),
('O', 'css', 'headshot', 'Headshot King', 'shots in the head'),
('O', 'css', 'round_mvp', 'Most Valuable Player', 'times earning Round MVP'),
('W', 'css', 'scout', 'Scout Elite', 'kills with scout'),
('W', 'css', 'hegrenade', 'Top grenadier', 'kills with grenade'),
('O', 'css', 'Killed_A_Hostage', 'Top Hostage Killer', 'hostages killed'),
('W', 'css', 'mostkills', 'Most Kills', 'kills'),
('W', 'css', 'suicide', 'Suicides', 'suicides'),
('W', 'css', 'teamkills', 'Team Killer', 'team kills'),
('W','hl2ctf','crowbar','Crowbar','bludgeonings with ole red'),
('W','hl2ctf','physcannon','Anger Issues','kills with physics'),
('W','hl2ctf','stunstick','Stun Stick','kills with stunstick'),
('W','hl2ctf','pistol','Pistol','kills with pistol'),
('W','hl2ctf','shotgun','A freakin 12 gague!','kills with shotgun'),
('W','hl2ctf','357','Clint','kills with .357'),
('W','hl2ctf','smg1','SMG','kills with the smg'),
('W','hl2ctf','ar2','Assault','kills with the assault rifle'),
('W','hl2ctf','crossbow_bolt','Sniper','snipings with crossbow'),
('W','hl2ctf','slam','SLAMMED!','kills with the slam'),
('W','hl2ctf','grenade_frag','Grenade Fiend','kills with nades'),
('W','hl2ctf','rpg_missile','Role Player','kills with RPG'),
('W','hl2ctf','latency','Best Latency','ms average connection'),
('O','dods','bomb_defuse','Top Defuser','bomb defusions'),
('O','dods','bomb_plant','Top Demolitionist','bomb plantings'),
('O','dods','capblock','Capture Blocked','flags blocked'),
('O','dods','captured_loc','Area Captured','flags captured'),
('O','dods','kill_planter','Bomb Planter Killer','kills'),
('W','dods','30cal','.30 Caliber Machine Gun','kills with .30 Caliber Machine Gun'),
('W','dods','amerknife','Backstabbing Beotch','kills with the American Knife'),
('W','dods','mp40','MP40 Hor','kills with the MP40 Machine Pistol'),
('W','dods','spade','Shovel God','kills with the spade'),
('W','dods','mp44','MP44 Hor','kills with the MP44 Assault Rifle'),
('W','dods','c96','Pistol c96','kills with Pistol c96'),
('W','dods','colt','Colt Freak','kills with the Colt .45 model 1911'),
('W','dods','garand','GarandMeister','kills with the M1 Garand Rifle'),
('W','dods','k98','Mauser Kar 98k','kills with Mauser Kar 98k'),
('W','dods','k98_scoped','Mauser Karbiner k98 Sniper Rifle','kills with Mauser Karbiner k98 Sniper Rifle'),
('W','dods','latency','Best Latency','ms average connection'),
('W','dods','m1carbine','M1 Carbine','kills with M1 Carbine'),
('W','dods','p38','Pistol 38','kills with Pistol 38'),
('W','dods','riflegren_ger','German Rifle Grenade','kills with German Rifle Grenade'),
('W','dods','riflegren_us','M1 Garand Rifle','kills with M1 Garand Rifle'),
('W','dods','thompson','Thompson Hor','kills with the Thompson Submachine Gun'),
('W','dods','spring','Spring Sniper','snipings with the Springfield 03 Rifle'),
('W','dods','bar','Bar Browning Hor','kills with the BAR Browning Automatic Rifle'),
('W','dods','frag_us','McVeigh Alert','bombings with the U.S. Grenade'),
('W','dods','frag_ger','Grenade Freak','bombings with the German Grenade'),
('W','dods','bazooka','Bazooka Joe','kills with the Bazooka'),
('W','dods','pschreck','Panzerschreck Hans','kills with the Panzerschreck'),
('W','dods','punch','Puncher','knock-outs'),
('W','dods','mg42','German Machine Hor','kills with the MG42'),
('W','dods','smoke_us','U.S. Smoke Grenade','kills with the U.S. Smoke Grenade'),
('W','dods','smoke_ger','German Smoke Grenade','kills with the German Smoke Grenade'),
('W','insmod','latency','Best Latency','ms average connection'),
('W','insmod','weapon_makarov','Soviet Makarov Combat Pistol','kills with Soviet Makarov Combat Pistol'),
('W','insmod','weapon_m9','9mm Beretta Pistol','kills with 9mm Beretta Pistol'),
('W','insmod','weapon_sks','Simonov SKS carbine','kills with Simonov SKS carbine'),
('W','insmod','world','RPG or Grenade','kills with RPG or Grenade'),
('W','insmod','weapon_m1014','M1014 Service Combat Shotgun','kills with M1014 Service Combat Shotgun'),
('W','insmod','weapon_toz','TOZ Rifle','kills with TOZ Rifle'),
('W','insmod','weapon_svd','Dragunov Sniper Rifle','kills with Dragunov Sniper Rifle'),
('W','insmod','weapon_rpk','RPK Ruchnoy Pulemyot Kalashnikova','kills with RPK Ruchnoy Pulemyot Kalashnikova'),
('W','insmod','weapon_m249','M249 SAW (Squad Automatic Weapon)','kills with M249 SAW (Squad Automatic Weapon)'),
('W','insmod','weapon_m16m203','M16 carbine M203 Grenade Launcher','kills with M16 carbine M203 Grenade Launcher'),
('W','insmod','weapon_l42a1','Enfield L42A1 Military Sniper Rifle','kills with Enfield L42A1 Military Sniper Rifle'),
('W','insmod','weapon_m4med','M4 Medium Range Rifle','kills with M4 Medium Range Rifle'),
('W','insmod','weapon_m4','M4 Carbine Rifle','kills with M4 Carbine Rifle'),
('W','insmod','weapon_m16a4','M16A4 Infantry Rifle','kills with M16A4 Infantry Rifle'),
('W','insmod','weapon_m14','Colt M14 Carbine','kills with Colt M14 Carbine'),
('W','insmod','weapon_fnfal','FN FAL Automatic Rifle','kills with FN FAL Automatic Rifle'),
('W','insmod','weapon_aks74u','AKS-74U Awtomat Kalaschnikowa Ukorochennyj','kills with AKS-74U'),
('W','insmod','weapon_ak47','AK-47 Awtomat Kalaschnikowa','kills with AK-47 Awtomat Kalaschnikowa'),
('W', 'ff', 'weapon_tranq', 'Drug Dealer', 'kills with tranq gun'),
('W', 'ff', 'weapon_supershotgun', 'Super Shots', 'kills with super shotgun'),
('W', 'ff', 'weapon_supernailgun', 'Super Nails', 'kills with super nailgun'),
('W', 'ff', 'weapon_spanner', 'Whack-A-Mole', 'kills with spanner'),
('W', 'ff', 'weapon_sniperrifle', 'Snipes-A-Holic', 'kills with sniper rifle'),
('W', 'ff', 'weapon_rpg', 'ROCKET MAN', 'kills with rpg'),
('W', 'ff', 'weapon_shotgun', 'N00b shotwhore', 'kills with normal shotgun'),
('W', 'ff', 'weapon_railgun', 'Pew pew laz0r beams', 'kills with railgun'),
('W', 'ff', 'weapon_pipelauncher', 'Bouncy pipe whore', 'kills with blues'),
('W', 'ff', 'weapon_medkit', 'Aids Monger', 'kills with aids'),
('W', 'ff', 'weapon_knife', 'My name is Skanky Butterpuss(e)', 'kills with knife'),
('W', 'ff', 'weapon_grenadelauncher', 'Click BOOM', 'kills with grellows'),
('W', 'ff', 'weapon_flamethrower', 'I like fire!', 'kills with flamethrower'),
('W', 'ff', 'weapon_autorifle', 'Gay Sniper', 'kills with AR'),
('W', 'ff', 'weapon_dispenser', 'Remote Control GOD', 'kills with dispenser'),
('W', 'ff', 'weapon_assaultcannon', 'Best Fatty Ever!', 'kills with ass cannon'),
('W', 'ff', 'SentryGun', 'Robocop', 'kills with SG'),
('W', 'ff', 'grenade_normal', 'Flying chicken!', 'kills with frag grenade'),
('W', 'ff', 'grenade_mirv', 'Look I can kill SGs!', 'kills with mirv grenade'),
('W', 'ff', 'grenade_emp', 'Wheres all my ammo!', 'kills with emp grenade'),
('W', 'ff', 'BOOM_HEADSHOT', 'Sharp Eye', 'headshots'),
('W', 'ff', 'DETPACK', 'Earthquake Machine', 'kills with detpack'),
('W', 'ff', 'backstab', 'Backstabber', 'backstab kills'),
('W', 'ff','latency','Best Latency','ms average connection'),
('W', 'hidden', 'fn2000', 'FN2000 Assault Rifle', 'kills with FN2000 Assault Rifle'),
('W', 'hidden', 'p90', 'FN P90 Sub Machine Gun', 'kills with FN P90 Sub Machine Gun'),
('W', 'hidden', 'shotgun', 'Remington 870 MCS Shotgun', 'kills with Remington 870 MCS Shotgun'),
('W', 'hidden', 'fn303', 'FN303 Less Lethal Launcher', 'kills with FN303 Less Lethal Launcher'),
('W', 'hidden', 'pistol', 'FN FiveSeven Pistol', 'kills with FN FiveSeven Pistol'),
('W', 'hidden', 'pistol2', 'FNP-9 Pistol', 'kills with FNP-9 Pistol'),
('W', 'hidden', 'knife', 'Kabar D2 Knife', 'kills with Kabar D2 Knife'),
('W', 'hidden', 'grenade_projectile', 'Pipe Bomb', 'kills with Pipe Bomb'),
('W', 'hidden', 'physics', 'Physics', 'kills with Physics'),
('W', 'hidden','latency','Best Latency','ms average connection'),
('W', 'zps', 'arms', 'Armed and Dangerous', 'kills with Zombie Arms'),
('W', 'zps', 'carrierarms', 'Carry on...', 'kills with Carrier Arms'),
('W', 'zps', 'ak47', 'AK-47', 'kills with AK-47'),
('W', 'zps', 'mp5', 'MP5', 'kills with MP5'),
('W', 'zps', 'revolver', 'Revolver', 'kills with Revolver'),
('W', 'zps', 'glock', 'Glock 17', 'kills with Glock 17'),
('W', 'zps', 'glock18c', 'Glock 18c', 'kills with Glock 18c'),
('W', 'zps', 'ppk', 'PPK', 'kills with PPK'),
('W', 'zps', 'usp', 'H & K USP', 'kills with H & K USP'),
('W', 'zps', '870', 'Rem. 870', 'kills with Rem. 870'),
('W', 'zps', 'supershorty', 'Super Shorty', 'kills with Super Shorty'),
('W', 'zps', 'grenade_frag', 'Grenade', 'kills with Grenades'),
('W', 'zps', 'sledgehammer', 'Sledgehammer', 'kills with Sledgehammer'),
('W', 'zps', 'crowbar', 'Hello, I''m Gordon Freeman', 'kills with Crowbar'),
('W', 'zps', 'chair', 'Sorry, I thought this was pro wrestling', 'kills with Chair'),
('W', 'zps', 'keyboard', 'Keyboard', 'kills with Keyboard'),
('W', 'zps', 'plank', 'Plank', 'kills with Plank'),
('W', 'zps', 'shovel', 'Grave Digger', 'kills with Shovel'),
('W', 'zps', 'golf', 'Fore!', 'kills with Golf Club'),
('W', 'zps', 'machete', 'Cuttin'' em Down', 'kills with Machete'),
('W', 'zps', 'fryingpan', 'Frying Pan', 'kills with Frying Pan'),
('W', 'zps', 'spanner', 'Wrench', 'kills with Wrench'),
('W', 'zps', 'axe', 'Axe', 'kills with Axe'),
('W', 'zps', 'tireiron', 'Tire Iron', 'kills with Tire Iron'),
('W', 'zps', 'hammer', 'Hammer', 'kills with Hammer'),
('W', 'zps', 'broom', 'Broom', 'kills with Broom'),
('W', 'zps', 'pot', 'Pot', 'kills with Pot'),
('W', 'zps', 'racket', 'Tennis Racket', 'kills with Tennis Racket'),
('W', 'zps', 'latency','Best Latency','ms average connection'),
('W', 'zps', 'bat_aluminum','Out of the park!','kills with Bat (Aluminum)'),
('W', 'zps', 'bat_wood','Corked','kills with Bat (Wood)'),
('W', 'zps', 'm4','M4','kills with M4'),
('W', 'zps', 'pipe','Piping hot','kills with Pipe'),
('W', 'zps', 'slam','IEDs','kills with IED'),
('O', 'zps', 'headshot', 'Headshot King', 'headshot kills'),
('W', 'aoc', 'Flamberge', 'Flamberge', 'kills with Flamberge'),
('W', 'aoc', 'Longsword', 'Longsword', 'kills with Longsword'),
('W', 'aoc', 'Glaive', 'Glaive', 'kills with Glaive'),
('W', 'aoc', 'Dual Daggers', 'Dual Daggers', 'kills with Dual Daggers'),
('W', 'aoc', 'Flamberge & Kite Shield', 'Flamberge & Kite Shield', 'kills with Flamberge & Kite Shield'),
('W', 'aoc', 'Shortsword', 'Shortsword', 'kills with Shortsword'),
('W', 'aoc', 'Warhammer', 'Warhammer', 'kills with Warhammer'),
('W', 'aoc', 'Mace', 'Mace', 'kills with Mace'),
('W', 'aoc', 'Mace & Buckler', 'Mace & Buckler', 'kills with Mace & Buckler'),
('W', 'aoc', 'Broadsword & Evil Shield', 'Mason Broadsword & Shield', 'kills with Mason Broadsword & Shield'),
('W', 'aoc', 'Crossbow', 'Crossbow', 'kills with Crossbow'),
('W', 'aoc', 'Longbow', 'Longbow', 'kills with Longbow'),
('W', 'aoc', 'Longsword & Kite Shield', 'Longsword & Kite Shield', 'kills with Longsword & Kite Shield'),
('W', 'aoc', 'Broadsword & Good Shield', 'Knights Broadsword & Shield', 'kills with Knights Broadsword & Shield'),
('W', 'aoc', 'Hatchet', 'Hatchet', 'kills with Hatchet'),
('W', 'aoc', 'Double Axe', 'Battle Axe', 'kills with Battle Axe'),
('W', 'aoc', 'Flail & Evil Shield', 'Mason Flail & Shield', 'kills with Mason Flail & Shield'),
('W', 'aoc', 'Flail & Good Shield', 'Knights Flail & Shield', 'kills with Knights Flail & Shield'),
('W', 'aoc', 'Javelin', 'Javelin', 'kills with Javelin'),
('W', 'aoc', 'Spiked Mace', 'Spiked Mace', 'kills with Spiked Mace'),
('W', 'aoc', 'Spear & Buckler', 'Spear & Buckler', 'kills with Spear & Buckler'),
('W', 'aoc', 'Spiked Mace & Buckler', 'Spiked Mace & Buckler', 'kills with Spiked Mace & Buckler'),
('W', 'aoc', 'Dagger', 'Dagger', 'kills with Dagger'),
('W', 'aoc', 'Broadsword', 'Broadsword', 'kills with Broadsword'),
('W', 'aoc', 'Throwing Knife', 'Throwing Knife', 'kills with Throwing Knives'),
('W', 'aoc', 'Halberd', 'Halberd', 'kills with Halberd'),
('W', 'aoc', 'chivalry', 'Fire', 'kills with Fire'),
('W', 'aoc', 'Oil Pot', 'Oil Pot', 'kills with Oil Pot'),
('O', 'aoc', 'headshot', 'Headshot/Decapitation', 'Headshots and Decapitations'),
('W', 'aoc','latency','Best Latency','ms average connection'),
('W', 'aoc', 'Fists','Fists','kills with fists'),
('W', 'aoc', 'Throwing Axe','Throwing Axe','kills with throwing axes'),
('O','cstrike','headshot','Headshot King','headshots'),
('O','cstrike','Defused_The_Bomb','Top Defuser','bomb defusions'),
('O','cstrike','Planted_The_Bomb','Top Demolitionist','bomb plantings'),
('O','cstrike','Rescued_A_Hostage','Top Hostage Rescuer','hostages rescued'),
('O','cstrike','Assassinated_The_VIP','Top Assassin','assassinations'),
('W','cstrike','elite','Dual Berretta Elites','kills with elite'),
('W','cstrike','knife','Knife Maniac','knifings'),
('W','cstrike','awp','AWP','snipings with awp'),
('W','cstrike','p90','P90','kills with p90'),
('W','cstrike','deagle','Desert Eagle','kills with deagle'),
('W','cstrike','m3','Shotgun','kills with m3 shotgun'),
('W','cstrike','usp','USP Master','kills with usp'),
('W','cstrike','m4a1','Colt M4A1 Carbine','kills with m4a1'),
('W','cstrike','glock18','Glock','kills with glock18'),
('W','cstrike','ak47','AK47','kills with ak47'),
('W','cstrike','famas','Fusil Automatique','kills with famas'),
('W','cstrike','galil','Galil','kills with galil'),
('W','cstrike','latency','Best Latency','ms average connection'),
('W','cstrike','grenade','Grenadier','kills with grenade'),
('W','tfc','axe','Crowbar Maniac','murders with crowbar'),
('W','tfc','spanner','Evil Engie','bludgeonings with spanner'),
('W','tfc','rocket','Rocketeer','kills with rocket'),
('W','tfc','ac','HWGuy Extraordinaire','ownings with ac'),
('W','tfc','sniperrifle','Red Dot Special','snipings'),
('W','tfc','flames','Fire Man','roastings'),
('W','tfc','latency','Best Latency','ms average connection'),
('W','dod','amerknife','Backstabbing Beotch','kills with the American Knife'),
('W','dod','luger','Luger Freak','kills with the Luger 08 Pistol'),
('W','dod','kar','KarMeister','kills with the Mauser Kar 98k'),
('W','dod','mp40','MP40 Hor','kills with the MP40 Machine Pistol'),
('W','dod','spade','Shovel God','kills with the spade'),
('W','dod','mp44','MP44 Hor','kills with the MP44 Assault Rifle'),
('W','dod','colt','Colt Freak','kills with the Colt .45 model 1911'),
('W','dod','garand','GarandMeister','kills with the M1 Garand Rifle'),
('W','dod','thompson','Thompson Hor','kills with the Thompson Submachine Gun'),
('W','dod','spring','Spring Sniper','snipings with the Springfield 03 Rifle'),
('W','dod','bar','Bar Browning Hor','kills with the BAR Browning Automatic Rifle'),
('W','dod','grenade','McVeigh Alert','bombings with the Grenade'),
('W','dod','garandbutt','Headsmasher','kills with Garand Butt Stock'),
('W','dod','bazooka','Bazooka Joe','kills with the Bazooka'),
('W','dod','pschreck','Panzerschreck Hans','kills with the Panzerschreck'),
('W','dod','latency','Best Latency','ms average connection'),
('W','ns','slash','Vicious Kitty','killings by le Swipe'),
('W','ns','shotgun','Buckshot Masta','killings with the shotty'),
('W','ns','pistol','Harold Handgun Alert','asskickings by pistola'),
('W','ns','knife','Iron Chef Alert','vicious stabbings'),
('W','ns','grenade','absolute n00b','pathetic killings by n00b grenades'),
('W','ns','bitegun','Teething Tommy','killings with le jaw'),
('W','ns','bite2gun','Mouth Full','killings with le big jaw'),
('W','ns','leap','Tigger Alert','crushings by leap'),
('W','ns','divinewind','Silent but Violent','slayings by recal relief'),
('W','ns','sporegunprojectile','Left Feet Larry','killings with Lerk'),
('W','ns','devour','Hungry Hungry Hippo','killings by Ingestion'),
('W','ns','spitgunspit','Masta Fatty','Marines too dumb to kill a gorge'),
('W','ns','latency','Best Latency','ms average connection'),
('O', 'l4d', 'headshot', 'Brain Salad', 'headshot kills'),
('O', 'l4d', 'healed_teammate', 'Field Medic', 'healed Survivors'),
('O', 'l4d', 'killed_exploding', 'Stomach Upset', 'killed Boomers'),
('O', 'l4d', 'killed_gas', 'No Smoking Section', 'killed Smokers'),
('O', 'l4d', 'killed_hunter', 'Hunter Punter', 'killed Hunters'),
('P', 'l4d', 'killed_survivor', 'Dead Wreckening', 'downed Survivors'),
('O', 'l4d', 'killed_tank', 'Tankbuster', 'killed Tanks'),
('O', 'l4d', 'killed_witch', 'Inquisitor', 'killed Witches'),
('P', 'l4d', 'pounce', 'Free to Fly', 'pounced Survivors'),
('O', 'l4d', 'rescued_survivor', 'Ground Cover', 'rescued Survivors'),
('O', 'l4d', 'revived_teammate', 'Helping Hand', 'revived Survivors'),
('P', 'l4d', 'tongue_grab', 'Drag &amp; Drop', 'constricted Survivors'),
('P', 'l4d', 'vomit', 'Barf Bagged', 'vomited on Survivors'),
('W', 'l4d', 'autoshotgun', 'Automation', 'kills with Auto Shotgun'),
('W', 'l4d', 'boomer_claw', 'Boom!', 'kills with Boomer''s Claws'),
('W', 'l4d', 'dual_pistols', 'Akimbo Assassin', 'kills with Dual Pistols'),
('W', 'l4d', 'hunter_claw', 'Open Season', 'kills with Hunter''s Claws'),
('W', 'l4d', 'hunting_rifle', 'Hawk Eye', 'kills with Hunting Rifle'),
('W', 'l4d', 'inferno', 'Pyromaniac', 'cremated Infected'),
('W', 'l4d', 'pipe_bomb', 'Pyrotechnician', 'blown up Infected'),
('W', 'l4d', 'pistol', 'Ammo Saver', 'kills with Pistol'),
('W', 'l4d', 'prop_minigun', 'No-One Left Behind', 'kills with Mounted Machine Gun'),
('W', 'l4d', 'pumpshotgun', 'Pump It!', 'kills with Pump Shotgun'),
('W', 'l4d', 'rifle', 'Commando', 'kills with M16 Assault Rifle'),
('W', 'l4d', 'smg', 'Safety First', 'kills with Uzi'),
('W', 'l4d', 'smoker_claw', 'Chain Smoker', 'kills with Smoker''s Claws'),
('W', 'l4d', 'tank_claw', 'Burger Tank', 'kills with Tank''s Claws'),
('W', 'l4d', 'tank_rock', 'Rock Star', 'kills with Tank''s Rock'),
('O', 'l4d', 'hunter_punter', 'Hunter Punter', 'hunter punts'),
('O', 'l4d', 'protect_teammate', 'Protector', 'teammate protections'),
('W', 'l4d', 'latency', 'Lowest Ping', 'ms average connection'),
('O', 'l4d2', 'headshot', 'Brain Salad', 'headshot kills'),
('O', 'l4d2', 'killed_boomer', 'Stomach Upset', 'killed Boomers'),
('O', 'l4d2', 'killed_smoker', 'No Smoking Section', 'killed Smokers'),
('O', 'l4d2', 'killed_hunter', 'Hunter Punter', 'killed Hunters'),
('O', 'l4d2', 'killed_spitter', 'Spittle Splatter', 'Spitters Splated'),
('O', 'l4d2', 'killed_charger', 'Bumrush Thwarter', 'killed Chargers'),
('O', 'l4d2', 'killed_jockey', 'Hunter Punter', 'killed Jockeys'),
('P', 'l4d2', 'killed_survivor', 'Dead Wreckening', 'downed Survivors'),
('O', 'l4d2', 'killed_tank', 'Tankbuster', 'killed Tanks'),
('O', 'l4d2', 'killed_witch', 'Inquisitor', 'killed Witches'),
('P', 'l4d2', 'tongue_grab', 'Drag &amp; Drop', 'constricted Survivors'),
('O', 'l4d2', 'healed_teammate', 'Field Medic', 'healed Survivors'),
('P', 'l4d2', 'pounce', 'Free to Fly', 'pounced Survivors'),
('O', 'l4d2', 'rescued_survivor', 'Ground Cover', 'rescued Survivors'),
('O', 'l4d2', 'revived_teammate', 'Helping Hand', 'revived Survivors'),
('P', 'l4d2', 'vomit', 'Barf Bagged', 'vomited on Survivors'),
('W', 'l4d2', 'autoshotgun', 'Automation', 'kills with Auto Shotgun'),
('W', 'l4d2', 'boomer_claw', 'Boom!', 'kills with Boomer''s Claws'),
('W', 'l4d2', 'dual_pistols', 'Akimbo Assassin', 'kills with Dual Pistols'),
('W', 'l4d2', 'hunter_claw', 'Open Season', 'kills with Hunter''s Claws'),
('W', 'l4d2', 'hunting_rifle', 'Hawk Eye', 'kills with Hunting Rifle'),
('W', 'l4d2', 'inferno', 'Pyromaniac', 'cremated Infected'),
('W', 'l4d2', 'pipe_bomb', 'Pyrotechnician', 'blown up Infected'),
('W', 'l4d2', 'pistol', 'Ammo Saver', 'kills with Pistol'),
('W', 'l4d2', 'prop_minigun', 'No One Left Behind', 'kills with Mounted Machine Gun'),
('W', 'l4d2', 'pumpshotgun', 'Pump It!', 'kills with Pump Shotgun'),
('W', 'l4d2', 'rifle', 'Commando', 'kills with M16 Assault Rifle'),
('W', 'l4d2', 'smg', 'Safety First', 'kills with Uzi'),
('W', 'l4d2', 'smoker_claw', 'Chain Smoker', 'kills with Smoker''s Claws'),
('W', 'l4d2', 'tank_claw', 'Burger Tank', 'kills with Tank''s Claws'),
('W', 'l4d2', 'tank_rock', 'Rock Star', 'kills with Tank''s Rock'),
('O', 'l4d2', 'hunter_punter', 'Hunter Punter', 'hunter punts'),
('O', 'l4d2', 'protect_teammate', 'Protector', 'hunter punts'),
('W', 'l4d2', 'latency', 'Lowest Ping', 'ms average connection'),
('O', 'l4d2', 'defibrillated_teammate', 'Dr. Shocker', 'teammates defibrillated'),
('O', 'l4d2', 'used_adrenaline', 'Adrenaline Junkie', 'adrenaline shots used'),
('O', 'l4d2', 'jockey_ride', 'Going for a ride!', 'jockey rides'),
('O', 'l4d2', 'charger_pummel', 'Hulk Smash!', 'pummelings as a charger'),
('O', 'l4d2', 'bilebomb_tank', 'Green can''t be healthy..', 'tank bilebombs'),
('O', 'l4d2', 'spitter_acidbath', 'Spit shine', 'spitter acid attacks'),
('W', 'l4d2', 'jockey_claw', 'Little Man Claws', 'kills with Jockey''s Claws'),
('W', 'l4d2', 'spitter_claw', 'Those nails could kill', 'kills with Spitter''s Claws'),
('W', 'l4d2', 'charger_claw', 'TAAN... What is this?!', 'kills with Charger''s Claws'),
('W', 'l4d2', 'first_aid_kit', 'Hi Dr. Nick!', 'kills with a First Aid Kit'),
('W', 'l4d2', 'grenade_launcher_projectile', 'Black Scottish Psyclops', 'kills with the Grenade Launcher'),
('W', 'l4d2', 'chainsaw', 'Slice and Dice', 'kills with the Chainsaw'),
('W', 'l4d2', 'fire_cracker_blast', 'Snap Crackle Pop', 'kills with fire crackers'),
('W', 'l4d2', 'pistol_magnum', 'Magnum', 'kills with the Magnum'),
('W', 'l4d2', 'rifle_ak47', 'AK-47', 'kills with the AK-47'),
('W', 'l4d2', 'rifle_desert', 'Combat Rifle', 'kills with the Combat Rifle'),
('W', 'l4d2', 'shotgun_chrome', 'Chrome Shotgun', 'kills with the Chrome Shotgun'),
('W', 'l4d2', 'shotgun_spas', 'Combat Shotgun', 'kills with the Combat Shotgun'),
('W', 'l4d2', 'smg_silenced', 'Uzi (Silenced)', 'kills with the Uzi (silenced)'),
('W', 'l4d2', 'sniper_military', 'Sniper Rifle', 'kills with the Sniper Rifle'),
('W', 'l4d2', 'baseball_bat', 'Batter Up!', 'kills with the Baseball Bat'),
('W', 'l4d2', 'cricket_bat', 'Cheerio.', 'kills with the Cricket Bat'),
('W', 'l4d2', 'crowbar', 'Crowbar', 'kills with the Crowbar'),
('W', 'l4d2', 'electric_guitar', 'Wayne''s world party on!', 'kills with the Electric Guitar'),
('W', 'l4d2', 'fireaxe', 'Fight fire with an axe', 'kills with the Fireaxe'),
('W', 'l4d2', 'frying_pan', 'BANG Headshot.', 'kills with the Frying Pan'),
('W', 'l4d2', 'katana', 'Katana', 'kills with the Katana'),
('W', 'l4d2', 'knife', 'Knife', 'kills with the Knife'),
('W', 'l4d2', 'machete', 'Machete', 'kills with the Machete'),
('W', 'l4d2', 'tonfa', 'Tonfa', 'kills with the Tonfa'),
('W', 'l4d2', 'melee', 'Fists of RAGGEE', 'melee kills'),
('W', 'l4d2', 'sniper_awp','AWP','kills with awp'),
('W', 'l4d2', 'smg_mp5','MP5 Navy','kills with mp5'),
('W', 'l4d2', 'sniper_scout','Scout Elite','kills with scout'),
('W', 'l4d2', 'rifle_sg552','SG 552','kills with sg552'),
('W', 'l4d2', 'gnome', 'GET OFF MY LAWN', 'gnome smash kills'),
('W', 'l4d2', 'golfclub', 'Golf Club', 'kills with the Golf Club'),
('W', 'l4d2', 'rifle_m60', 'M60', 'kills with M60'),
('W', 'fof', 'deringer', 'Deringer', 'kills with Deringer'),
('W', 'fof', 'carbine', 'Carbine', 'kills with Carbine'),
('W', 'fof', 'coltnavy', 'Colt Navy', 'kills with Colt Navy'),
('W', 'fof', 'bow', 'Bow', 'kills with Bow'),
('W', 'fof', 'arrow', 'Arrow', 'kills with Arrow'),
('W', 'fof', 'sharps', 'Sharps', 'kills with Sharps'),
('W', 'fof', 'coachgun', 'Coach Gun', 'kills with Coach Gun'),
('W', 'fof', 'peacemaker', 'Peacemaker', 'kills with Peacemaker'),
('W', 'fof', 'knife', 'Knife', 'kills with Knife'),
('W', 'fof', 'thrown_axe', 'Thrown Axe', 'kills with Thrown Axe'),
('W', 'fof', 'arrow_fiery', 'Fire Arrow', 'kills with Fire Arrow'),
('W', 'fof', 'thrown_knife', 'Thrown Knife', 'kills with Thrown Knife'),
('W', 'fof', 'dualnavy', 'Dual Colt Navys', 'kills with Dual Colt Navys'),
('W', 'fof', 'dynamite', 'Dynamite', 'kills with Dynamite'),
('W', 'fof', 'fists', 'Fists', 'kills with Fists'),
('W', 'fof', 'axe', 'Axe', 'kills with Axe'),
('W', 'fof', 'dualpeacemaker', 'Dual Peacemakers', 'kills with Dual Peacemakers'),
('W', 'fof', 'henryrifle', 'Henry Rifle', 'kills with Henry Rifle'),
('W', 'fof', 'shotgun', 'Winchester Shotgun', 'kills with the Winchester'),
('O', 'fof', 'loot_drop', 'Butter Fingers', 'Loot Drops'),
('O', 'fof', 'loot_capture', 'Gimme all yo loot', 'Loot Captures'),
('O', 'fof', 'carrier_protect', 'Grand Protector', 'carrier protections'),
('O', 'fof', 'headshot', 'BOOM HEADSHOT','headshot kills'),
('W', 'fof', 'latency', 'Lowest Ping','ms average connection'),
('W', 'ges', '#GE_ProximityMine', 'Proximity Pulvarizer', 'kills with Proximity Mines'),
('W', 'ges', '#GE_AutoShotgun', 'Automatic Shotgun', 'kills with Automatic Shotgun'),
('W', 'ges', '#GE_Phantom', 'Phantastic Phantom', 'kills with Phantom'),
('W', 'ges', '#GE_Knife', 'Silent Assassin', 'kills with Hunting Knife'),
('W', 'ges', '#GE_D5K', 'D5K', 'kills with D5K Deutsche'),
('W', 'ges', '#GE_SilverPP7', 'Silver PP7', 'kills with Silver PP7'),
('W', 'ges', '#GE_DD44', 'DD44', 'kills with DD44'),
('W', 'ges', '#GE_Grenade', 'Grenade', 'kills with Grenades'),
('W', 'ges', '#GE_CougarMagnum', 'Cougar Magnum', 'kills with Cougar Magnum'),
('W', 'ges', '#GE_D5K_SILENCED', 'Silenced D5K', 'kills with D5K (Silenced)'),
('W', 'ges', '#GE_Shotgun', 'Shotgun', 'kills with Shotgun'),
('W', 'ges', '#GE_Klobb', 'Klobbering Time', 'kills with Klobb'),
('W', 'ges', '#GE_RCP90', 'RCP 4 Death', 'kills with RC-P90'),
('W', 'ges', '#GE_RemoteMine', 'Remotely Remove', 'kills with Remote Mines'),
('W', 'ges', '#GE_KF7Soviet', 'KF7 Soviet', 'kills with KF7 Soviet'),
('W', 'ges', '#GE_ZMG', 'ZMG', 'kills with ZMG'),
('W', 'ges', '#GE_SniperRifle', 'A View To A Kill', 'kills with Sniper Rifle'),
('W', 'ges', '#GE_GoldPP7', 'Golden PP7', 'kills with Golden PP7'),
('W', 'ges', '#GE_AR33', 'ARYOU33?', 'kills with US AR33 Assault'),
('W', 'ges', '#GE_GoldenGun', 'Unknown Pain', 'kills with Golden Gun'),
('W', 'ges', '#GE_ThrowingKnife', 'Thorwing Knives', 'kills with Throwing Knives'),
('W', 'ges', '#GE_PP7', 'PKing Soup', 'kills with PP7'),
('W', 'ges', '#GE_PP7_SILENCED', 'Silenced PP7', 'kills with PP7 (Silenced)'),
('W', 'ges', '#GE_TimedMine', 'Timed Termination', 'kills with Timed Mines'),
('W', 'ges', '#GE_MilitaryLaser', 'Military Laser', 'kills with Military Laser'),
('W', 'ges', '#GE_GrenadeLauncher', 'Grenade Launcher', 'kills with Grenade Launcher'),
('W', 'ges', '#GE_Rocket', 'Rocket Launcher', 'kills with Rocket Launcher'),
('W', 'ges', '#GE_Taser', 'Taser', 'kills with Taser'),
('W', 'ges', '#GE_SniperButt', 'Sniper Butt', 'kills with Sniper Butt'),
('W', 'ges', '#GE_Slapper', 'Bitch Fighter', 'kills with Slappers'),
('W', 'ges', '#GE_RocketLauncher', ', Rocket Launcher', 'kills with Rocket Launcher'),
('W', 'ges', 'latency', 'Lowest Ping','ms average connection'),
('W', 'ges', 'mostkills', 'Bond, James Bond', 'kills'),
('W', 'bg2', 'brownbess', 'Brown Bess', 'kills with Brown Bess'),
('W', 'bg2', 'brownbess_bayonet', 'Brown Bess - Bayonet', 'kills with Brown Bess Bayonet'),
('W', 'bg2', 'charleville', 'Charleville', 'kills with Charleville'),
('W', 'bg2', 'charleville_bayonet', 'Charleville - Bayonet', 'kills with Charleville Bayonet'),
('W', 'bg2', 'hirschf', 'Hirschfaenger', 'kills with Hirschfaenger'),
('W', 'bg2', 'jaeger', 'Jaeger Rifle', 'kills with Jaeger Rifle'),
('W', 'bg2', 'knife', 'Knife', 'kills with Knife'),
('W', 'bg2', 'pennsylvania', 'Pennsylvania', 'kills with Pennsylvania'),
('W', 'bg2', 'pistol_a', 'British Pistol', 'kills with British Pistol'),
('W', 'bg2', 'pistol_b', 'American Pistol', 'kills with American Pistol'),
('W', 'bg2', 'sabre_a', 'British Sabre', 'kills with British Sabre'),
('W', 'bg2', 'sabre_b', 'American Sabre', 'kills with American Sabre'),
('W', 'bg2', 'mostkills', 'Most Kills', 'kills'),
('W', 'bg2', 'latency', 'Best Latency', 'ms average connection'),
('W', 'sgtls', 'mostkills', 'Most Kills', 'kills'),
('W', 'sgtls', 'latency', 'Best Latency', 'ms average connection'),
('W', 'sgtls', 'p90', 'FN Herstal P-90 Red Dot / FN-H P-90RD', 'kills'),
('W', 'sgtls', 'pistol', 'Beretta M92F-s', 'kills'),
('W', 'sgtls', 'knife', 'Combat Knife', 'kills'),
('W', 'sgtls', 'staff_blast', 'Staff Weapon', 'kills'),
('W', 'sgtls', 'p90D', 'FN Herstal P-90 w/ Disruptor', 'kills'),
('W', 'sgtls', 'hdevice', 'Hand Device / Ribbon Device', 'kills'),
('W', 'sgtls', 'tac_pulse', 'Tac (turrent)', 'kills'),
('W', 'sgtls', 'tac_projectile', 'Tac (bomb)', 'kills'),
('W', 'sgtls', 'c4_charge', 'C4', 'kills'),
('W', 'sgtls', 'grenade_projectile', 'M67 Frag Grenade', 'kills'),
('W', 'sgtls', 'g36', 'H&K G-36', 'kills'),
('W', 'sgtls', 'kull_blast', 'Kull Warrior Staff Device', 'kills'),
('W', 'sgtls', 'suicide_bomb', 'Goa''uld Suicide Bomb', 'kills'),
('W', 'sgtls', 'kullblaster', 'Kull Warrior Staff Device (blast)', 'kills'),
('W', 'sgtls', 'staff', 'Staff Weapon Melee', 'kills'),
('W', 'sgtls', 'zat_blast', 'Zat', 'kills'),
('W', 'sgtls', 'awp', 'AWP Rifle', 'kills'),
('W', 'sgtls', 'grenade', 'M67 Frag Grenade', 'kills'),
('W', 'sgtls', 'zat', 'Zat (splash)', 'kills'),
('W', 'sgtls', 'tac', 'Tac (splash)', 'kills'),
('O', 'dystopia', 'Capture Guard Post', 'Capture Guard Post', 'captures'),
('O', 'dystopia', 'Capture Interior Spawn', 'Capture Interior Spawn', 'captures'),
('O', 'dystopia', 'Capture Internal Spawn', 'Capture Internal Spawn', 'captures'),
('O', 'dystopia', 'Capture The Docks', 'Capture The Docks', 'captures'),
('O', 'dystopia', 'Capture the Inner Base', 'Capture the Inner Base', 'captures'),
('O', 'dystopia', 'Capture the Spawn', 'Capture the Spawn', 'captures'),
('O', 'dystopia', 'Cut Entrance Spawn Power', 'Cut Entrance Spawn Power', 'power cuts'),
('O', 'dystopia', 'Defend Interior Spawn', 'Defend Interior Spawn', 'defenses'),
('O', 'dystopia', 'Defend Middle Spawn', 'Defend Middle Spawn', 'defenses'),
('O', 'dystopia', 'Defend Security JIP', 'Defend Security JIP', 'defenses'),
('O', 'dystopia', 'Destroy Broadcast Server', 'Destroy Broadcast Server', 'destructions'),
('O', 'dystopia', 'Destroy Cooling Access Door', 'Destroy Cooling Access Door', 'destructions'),
('O', 'dystopia', 'Destroy Cooling Tank', 'Destroy Cooling Tank', 'destructions'),
('O', 'dystopia', 'Destroy The Bulkhead', 'Destroy The Bulkhead', 'destructions'),
('O', 'dystopia', 'Destroy The Core', 'Destroy The Core', 'destructions'),
('O', 'dystopia', 'Destroy the Firewall', 'Destroy the Firewall', 'destructions'),
('O', 'dystopia', 'Destroy the Reactor', 'Destroy the Reactor', 'destructions'),
('O', 'dystopia', 'Destroy Transformer', 'Destroy Transformer', 'destructions'),
('O', 'dystopia', 'Enable Auxilary Power Feed', 'Enable Auxilary Power Feed', 'power feed enablings'),
('O', 'dystopia', 'Enable The 4-Point Override', 'Enable The 4-Point Override', '4-point override enablings'),
('O', 'dystopia', 'Escort Hostage', 'Escort Hostage', 'escorts'),
('O', 'dystopia', 'Hack Middle Spawn', 'Hack Middle Spawn', 'hacks'),
('O', 'dystopia', 'Hack Spawn Controls', 'Hack Spawn Controls', 'hacks'),
('O', 'dystopia', 'Hack the Perimeter', 'Hack the Perimeter', 'hacks'),
('O', 'dystopia', 'Inject The Virus', 'Inject The Virus', 'injections'),
('O', 'dystopia', 'Launch Missile', 'Launch Missile', 'launches'),
('O', 'dystopia', 'Locate profile', 'Locate profile', 'locations'),
('O', 'dystopia', 'Maintain Power Routing', 'Maintain Power Routing', 'maintenances'),
('O', 'dystopia', 'Open And Destroy Data Stores / Establish An Uplink', 'Open And Destroy Data Stores / Establish An Uplink', 'times'),
('O', 'dystopia', 'Redirect Laser', 'Redirect Laser', 'redirections'),
('O', 'dystopia', 'Reroute Power To Control Room', 'Reroute Power To Control Room', 'reroutings'),
('O', 'dystopia', 'Shut Down Security', 'Shut Down Security', 'shutdowns'),
('O', 'dystopia', 'Shutdown The Production Line', 'hutdown The Production Line', 'shutdowns'),
('O', 'dystopia', 'Smash Data Storage', 'Smash Data Storage', 'smashings'),
('O', 'dystopia', 'Turn Power Offline', 'Turn Power Offline', 'times'),
('W', 'dystopia', 'bonuspoints', 'Most Bonus Points', 'bonus points'),
('W', 'dystopia', 'latency', 'Best Latency', 'ms average connection'),
('W', 'dystopia', 'Light Katana', 'Light Katana', 'kills'),
('W', 'dystopia', 'Medium Katana', 'Medium Katana', 'kills'),
('W', 'dystopia', 'Fatman Fist', 'Fatman Fist', 'kills'),
('W', 'dystopia', 'Machine Pistol', 'Machine Pistol', 'kills'),
('W', 'dystopia', 'Shotgun', 'Shotgun', 'kills'),
('W', 'dystopia', 'Laser Rifle', 'Laser Rifle', 'kills'),
('W', 'dystopia', 'BoltGun', 'Bolt Gun', 'kills'),
('W', 'dystopia', 'SmartLock Pistols', 'Smartlock Pistols', 'kills'),
('W', 'dystopia', 'Assault Rifle', 'Assault Rifle', 'kills'),
('W', 'dystopia', 'Grenade Launcher', 'Grenade Launcher', 'kills'),
('W', 'dystopia', 'MK-808 Rifle', 'MK-808 Rifle', 'kills'),
('W', 'dystopia', 'Tesla Rifle', 'Tesla Rifle', 'kills'),
('W', 'dystopia', 'Rocket Launcher', 'Rocket Launcher', 'kills'),
('W', 'dystopia', 'Minigun', 'Minigun', 'kills'),
('W', 'dystopia', 'Ion Cannon', 'Ion Cannon', 'kills'),
('W', 'dystopia', 'Basilisk', 'Basilisk', 'kills'),
('W', 'dystopia', 'Frag Grenade', 'Frag Grenade', 'kills'),
('W', 'dystopia', 'EMP Grenade', 'EMP Grenade', 'kills'),
('W', 'dystopia', 'Spider Grenade', 'Spider Grenade', 'kills'),
('W', 'dystopia', 'Cortex Bomb', 'Cortex Bomb', 'kills'),
('W', 'dystopia', 'Leg Boosters', 'Leg Boosters', 'kills'),
('W', 'dystopia', 'Trap', 'Trap', 'kills'),
('W', 'dystopia', 'Turret', 'Turret', 'kills'),
('O', 'nts', 'headshot', 'Headshot King', 'headshot kills'),
('W', 'nts', 'aa13', 'AA13', 'kills with AA13'),
('W', 'nts', 'grenade_projectile', 'Frag Grenade', 'kills with Frag Grenade'),
('W', 'nts', 'jitte', 'Jitte', 'kills with Jitte'),
('W', 'nts', 'jittescoped', 'Jitte (Scoped)', 'kills with Jitte (Scoped)'),
('W', 'nts', 'knife', 'Knife', 'kills with Knife'),
('W', 'nts', 'kyla', 'KYLA', 'kills with KYLA'),
('W', 'nts', 'm41', 'M41', 'kills with M41'),
('W', 'nts', 'm41s', 'M41S', 'kills with M41S'),
('W', 'nts', 'milso', 'MilSO', 'kills with MilSO'),
('W', 'nts', 'mpn', 'MPN45', 'kills with MPN45'),
('W', 'nts', 'mx', 'MX', 'kills with MX'),
('W', 'nts', 'mx_silenced', 'MX Silenced', 'kills with MX Silenced'),
('W', 'nts', 'pz', 'PZ252', 'kills with PZ252'),
('W', 'nts', 'grenade_detapack', 'Detpack', 'kills with Detpack'),
('W', 'nts', 'srm', 'SRM', 'kills with SRM'),
('W', 'nts', 'srm_s', 'SRM-S', 'kills with SRM-S'),
('W', 'nts', 'srs', 'SRS', 'kills with SRS'),
('W', 'nts', 'supa7', 'MURATA SUPA 7', 'kills with MURATA SUPA 7'),
('W', 'nts', 'tachi', 'TACHI', 'kills with TACHI'),
('W', 'nts', 'zr68c', 'ZR68C', 'kills with ZR68C'),
('W', 'nts', 'zr68l', 'ZR68L', 'kills with ZR68L'),
('W', 'nts', 'zr68s', 'ZR68S', 'kills with ZR68S'),
('W', 'nts', 'mostkills', 'Most Kills', 'kills'),
('W', 'nts', 'latency', 'Best Latency', 'ms average connection'),
('W', 'pvkii', 'latency', 'Best Latency', 'ms average connection'),
('W', 'pvkii', 'mostkills', 'Most Kills', 'kills'),
('W', 'pvkii', 'teamkills', 'Most Team Kills', 'team kills'),
('W', 'pvkii', 'bonuspoints', 'Most bonus points', 'bonus points'),
('W', 'pvkii', 'zerking', 'Zerking', 'kills with Zerking'),
('W', 'pvkii', 'slidingdoor', 'Sliding Door', 'kills with Sliding Door'),
('W', 'pvkii', 'seaxshield', 'Langseax & Shield', 'kills with Langseax & Shield'),
('W', 'pvkii', 'longbow', 'Long Bow', 'kills with Long Bow'),
('W', 'pvkii', 'chest', 'Chest', 'kills with Chest'),
('W', 'pvkii', 'parrot', 'Parrot', 'kills with Parrot'),
('W', 'pvkii', 'rocks', 'Rocks', 'kills with Rocks'),
('W', 'pvkii', 'bigaxe', 'Berserker Axe', 'kills with Berserker Axe'),
('W', 'pvkii', 'gatecrush', 'Gate Crush', 'kills with Gate Crush'),
('W', 'pvkii', 'cutlass', 'Cutlass', 'kills with Cutlass'),
('W', 'pvkii', 'twoaxe', 'Huscarl Axe', 'kills with Huscarl Axe'),
('W', 'pvkii', 'spear', 'Spear', 'kills with Spear'),
('W', 'pvkii', 'freeze', 'Freeze', 'kills with Freeze'),
('W', 'pvkii', 'plfall', 'Falling', 'kills with Falling'),
('W', 'pvkii', 'steam', 'Steam', 'kills with Steam'),
('W', 'pvkii', 'vulture', 'Vultures', 'kills with Vultures'),
('W', 'pvkii', 'shuriken', 'shuriken', 'kills with shuriken'),
('W', 'pvkii', 'huscshieldbash', 'Huscarl Shield Bash', 'kills with Huscarl Shield Bash'),
('W', 'pvkii', 'spike', 'Spike', 'kills with Spike'),
('W', 'pvkii', 'blunderbuss', 'Blunderbuss', 'kills with Blunderbuss'),
('W', 'pvkii', 'punch_cpt', 'Punch', 'kills with Punch'),
('W', 'pvkii', 'crossbow', 'Crossbow', 'kills with Crossbow'),
('W', 'pvkii', 'env_explosion', 'Explosion', 'kills with Explosion '),
('W', 'pvkii', 'flintlock', 'Flintlock Pistols', 'kills with Flintlock Pistols'),
('W', 'pvkii', 'throwaxe', 'Throwing Axes', 'kills with Throwing Axes'),
('W', 'pvkii', 'powderkeg', 'Powderkeg', 'kills with Powderkeg'),
('W', 'pvkii', 'physics', 'Physics', 'kills with Physics'),
('W', 'pvkii', 'boulder', 'Boulder', 'kills with Boulder'),
('W', 'pvkii', 'drowned', 'Drowned', 'kills with Drowned'),
('W', 'pvkii', 'barrel', 'Barrel', 'kills with Barrel'),
('W', 'pvkii', 'axesword', 'Sword & Axe', 'kills with Sword & Axe'),
('W', 'pvkii', 'cutlass2', 'Captain''s Cutlass', 'kills with Captain''s Cutlass'),
('W', 'pvkii', 'flames', 'Flames', 'kills with Flames'),
('W', 'pvkii', 'vikingshield', 'Huscarl Sword & Shield', 'kills with Huscarl Sword & Shield '),
('W', 'pvkii', 'thrownkeg', 'Thrown Powderkeg', 'kills with Thrown Powderkeg '),
('W', 'pvkii', 'archersword', 'Short Sword', 'kills with Short Sword'),
('W', 'pvkii', 'player', 'Player', 'kills with Player'),
('W', 'pvkii', 'worldspawn', 'World', 'kills with World'),
('W', 'pvkii', 'twosword', '2 Handed Sword', 'kills with 2 Handed Sword'),
('W', 'pvkii', 'hook', 'Hook', 'kills with Hook'),
('W', 'pvkii', 'hkshieldbash', 'Heavy Knight Bash', 'kills with Heavy Knight Bash'),
('W', 'pvkii', 'javelin', 'Javelins', 'kills with Javelins'),
('W', 'pvkii', 'swordshield', 'Heavy Knight Sword/Shield', 'kills with Heavy Knight Sword/Shield'),
('W', 'pvkii', 'crusher', 'Crusher', 'kills with Crusher'),
('O', 'pvkii', 'kill assist', 'Kill Assists', 'kill assists'),
('O', 'pvkii', 'mvp1', 'Most Valuable Player', 'times MVP'),
('O', 'pvkii', 'chest_capture', 'Chest Captures', 'chest captures'),
('O', 'pvkii', 'obj_complete', 'Completed Objectives', 'completed objectives'),
('O', 'pvkii', 'chest_defend', 'Chest Defends', 'chests defends'),
('O', 'pvkii', 'grail_defend', 'Grail Defends', 'grail defends'),
('O', 'pvkii', 'killed_parrot', 'Parrot Killer', 'parrots killed'),
('P', 'pvkii', 'domination', 'Dominations', 'dominations'),
('P', 'pvkii', 'revenge', 'Revenge', 'revenges'),
('W', 'csp', 'awp', 'AWP', 'kills with awp'),
('W', 'csp', 'galil', 'Galil', 'kills with galil'),
('W', 'csp', 'famas', 'Fusil Automatique', 'kills with famas'),
('W', 'csp', 'ak47', 'AK47', 'kills with ak47'),
('W', 'csp', 'glock', 'Glock', 'kills with glock'),
('W', 'csp', 'm4a1', 'Colt M4A1 Carbine', 'kills with m4a1'),
('W', 'csp', 'usp', 'USP Master', 'kills with usp'),
('W', 'csp', 'deagle', 'Desert Eagle', 'kills with deagle'),
('W', 'csp', 'knife', 'Knife Maniac', 'knifings'),
('W', 'csp', 'mp5navy', 'MP5 Navy', 'kills with mp5'),
('W', 'csp', 'hegrenade', 'Top grenadier', 'kills with grenade'),
('O', 'csp', 'headshot', 'Headshot King', 'shots in the head'),
('W', 'csp', 'latency', 'Best Latency', 'ms average connection'),
('W', 'csp', 'mostkills', 'Most Kills', 'kills'),
('W', 'csp', 'suicide', 'Suicides', 'suicides'),
('W', 'csp', 'teamkills', 'Team Killer', 'team kills'),
('W', 'valve', '357', '357', 'kills with 357'),
('W', 'valve', '9mmAR', 'MP5', 'kills with 9mmAR'),
('W', 'valve', '9mmhandgun', 'Glock', 'kills with 9mmhandgun'),
('W', 'valve', 'crossbow', 'Crossbow Sniper', 'kills with crossbow'),
('W', 'valve', 'crowbar', 'Crowbar Maniac', 'murders with crowbar'),
('W', 'valve', 'gluon gun', 'Gauss King', 'kills with gluon gun'),
('W', 'valve', 'tau_cannon', 'Egon', 'kills with tau_cannon'),
('W', 'valve', 'grenade', 'Grenadier', 'kills with grenade'),
('W', 'valve', 'hornet', 'Hornet Master', 'kills with hornet'),
('W', 'valve', 'rpg_rocket', 'Rocketeer', 'kills with rocket'),
('W', 'valve', 'satchel', 'Lord Satchel', 'kills with satchel'),
('W', 'valve', 'shotgun', 'Redneck', 'kills with shotgun'),
('W', 'valve', 'snark', 'Snark Master', 'kills with snark'),
('W', 'valve', 'tripmine', 'Shady Assassin', 'kills with tripmine'),
('O', 'valve', 'headshot', 'Headshot King', 'shots in the head'),
('W', 'valve', 'latency', 'Latency', 'ms average connection'),
('W', 'valve', 'mostkills', 'Most Kills', 'kills'),
('W', 'valve', 'suicide', 'Suicides', 'suicides'),
('W', 'csgo', 'ak47', 'AK47', 'kills with ak47'), 
('W', 'csgo', 'AUG', 'Aug', 'kills with aug'), 
('W', 'csgo', 'awp', 'AWP', 'kills with awp'),
('W', 'csgo', 'deagle', 'Desert Eagle', 'kills with deagle'), 
('W', 'csgo', 'elite', 'Dual Berretta Elites', 'kills with elite'),
('W', 'csgo', 'famas', 'Fusil Automatique', 'kills with famas'),
('W', 'csgo', 'fiveseven', 'Five Seven', 'kills with fiveseven'),
('W', 'csgo', 'g3sg1', 'G3 SG1', 'kills with g3sg1'),
('W', 'csgo', 'galilar', 'Galil', 'kills with galil'),
('W', 'csgo', 'glock', 'Glock', 'kills with glock'),
('W', 'csgo', 'hegrenade', 'High Explosive Grenade', 'kills with grenade'),
('W', 'csgo', 'firebomb', 'Incendiary Grenade', 'kills with inferno'),
('W', 'csgo', 'knife', 'Knife Maniac', 'knifings'),
('W', 'csgo', 'm249', 'M249', 'kills with m249'),
('W', 'csgo', 'm4a1', 'M4A4', 'kills with m4a4'),
('W', 'csgo', 'mac10', 'MAC-10', 'kills with mac10'),
('W', 'csgo', 'mag7', 'MAG-7', 'kills with mag7'),
('O', 'csgo', 'headshot', 'Headshot King', 'shots in the head'),
('W', 'csgo', 'latency', 'Best Latency', 'ms average connection'),
('O', 'csgo', 'round_mvp', 'Most Valuable Player', 'times earning Round MVP'),
('W', 'csgo', 'mostkills', 'Most Kills', 'kills'),
('W', 'csgo', 'suicide', 'Suicides', 'suicides'),
('W', 'csgo', 'teamkills', 'Team Killer', 'team kills'),
('W', 'csgo', 'mp7', 'MP7', 'kills with mp7'),
('W', 'csgo', 'mp9', 'MP9', 'kills with mp9'),
('W', 'csgo', 'negev', 'Negev', 'kills with negev'),
('W', 'csgo', 'nova', 'Nova', 'kills with nova'),
('W', 'csgo', 'hkp2000', 'P2000', 'kills with p2000'),
('W', 'csgo', 'p250', 'P250', 'kills with p250'),
('W', 'csgo', 'p90', 'P90', 'kills with p90'),
('W', 'csgo', 'bizon', 'PP-Bizon', 'kills with pp-bizon'),
('W', 'csgo', 'sawedoff', 'Sawed-Off', 'kills with sawed-off'),
('W', 'csgo', 'scar20', 'SCAR-20', 'kills with scar-20'),
('W', 'csgo', 'sg553', 'SG 553', 'kills with sg553'),
('W', 'csgo', 'ssg08', 'SSG 08', 'kills with ssg08'),
('W', 'csgo', 'tec9', 'Tec-9', 'kills with Tec-9'),
('O', 'csgo', 'Defused_The_Bomb', 'Top Defuser', 'bomb defusions'),
('O', 'csgo', 'Planted_The_Bomb', 'Top Demolitionist', 'bomb plantings'),
('O', 'csgo', 'Killed_A_Hostage', 'Top Hostage Killer', 'hostages killed'),
('O', 'csgo', 'Rescued_A_Hostage', 'Top Hostage Rescuer', 'hostages rescued'),
('W', 'csgo', 'ump45', 'UMP-45', 'kills with ump45'),
('W', 'csgo', 'xm1014', 'XM automatic Shotgun', 'kills with xm1014'),
('W', 'csgo', 'taser', 'Zeus x27', 'kills with taser'),
('O', 'nd', 'headshot', 'Headshot King', 'shots in the head'),
('O', 'nd', 'structure_kill', 'Destroyer', 'destroyed structures'),
('O', 'nd', 'killed_commander', 'Commander Killer', 'enemy commander kills'),
('O', 'nd', 'promoted_to_commander', 'Master Commander', 'times commander'),
('O', 'nd', 'armoury_destroyed', 'Armoury Destroyer', 'destroyed armouries'),
('O', 'nd', 'artillery_destroyed', 'Armoury Destroyer', 'destroyed artilleries'),
('O', 'nd', 'assembler_destroyed', 'Armoury Destroyer', 'destroyed assemblers'),
('O', 'nd', 'flamethrowerturret_destroyed', 'Armoury Destroyer', 'destroyed flameghrower turrets'),
('O', 'nd', 'wirelessrepeater_destroyed', 'Armoury Destroyer', 'destroyed wireless repeaters'),
('O', 'nd', 'powerstation_destroyed', 'Armoury Destroyer', 'destroyed power stations'),
('O', 'nd', 'radar_destroyed','Armoury Destroyer', 'destroyed radars'),
('O', 'nd', 'powerrelay_destroyed', 'Armoury Destroyer', 'destroyed relay towers'),
('O', 'nd', 'rocketturret_destroyed', 'Armoury Destroyer', 'destroyed rocket turrets'),
('O', 'nd', 'sonicturret_destroyed', 'Armoury Destroyer', 'destroyed sonic turrets'),
('O', 'nd', 'supply_destroyed', 'Armoury Destroyer', 'destroyed supplies'),
('O', 'nd', 'transportgate_destroyed', 'Armoury Destroyer', 'destroyed transport gates'),
('O', 'nd', 'machineguneturret_destroyed', 'Armoury Destroyer', 'destroyed machinegun turrets'),
('W', 'nd', 'armblade', 'BLADES', 'kills with BLADES'),
('W', 'nd', 'armknives', 'KNIVES', 'kills with KNIVES'),
('W', 'nd', 'artillery', 'Artillerist', 'kills with Artillery'),
('W', 'nd', 'avenger', 'C1 AVENGER', 'kills with C1 AVENGER'),
('W', 'nd', 'bag90', 'BAG-90', 'kills with BAG-90'),
('W', 'nd', 'bonuspoints', 'Improved Player', 'bonus points'),
('W', 'nd', 'chaingun', 'GAU-20P', 'kills with GAU-20P'),
('W', 'nd', 'commander damage', 'Damage Commander', 'kills with Commander Damage Ability'),
('W', 'nd', 'commander poison', 'Poison Commander', 'kills with Commander Poison Ability'),
('W', 'nd', 'connectiontime', 'Play Time', 's in game'),
('W', 'nd', 'daisy cutter', 'DAISYCUTTER', 'kills with DAISYCUTTER'),
('W', 'nd', 'deathstreak', 'Victim', 'death streak'),
('W', 'nd', 'env_explosion', 'Blaster', 'kills with Environment Explosion'),
('W', 'nd', 'f2000', 'FN-H F2100 TR', 'kills with FN-H F2100 TR'),
('W', 'nd', 'flamethrower turret', 'Flamethrower Turret', 'kills with Flamethrower Turret'),
('W', 'nd', 'frag grenade', 'M-87 FRAG', 'kills with M-87 FRAG'),
('W', 'nd', 'grenade launcher', 'M52 HYDRA', 'kills with M52 HYDRA'),
('W', 'nd', 'killstreak', 'Slayer', 'kill streak'),
('W', 'nd', 'latency', 'Lowpinger', 'ms average connection'),
('W', 'nd', 'm95', 'M-95 L.A.W.S.', 'kills with M-95 L.A.W.S.'),
('W', 'nd', 'mg turret', 'Machine-gun Turret', 'kills with Machine-gun Turret'),
('W', 'nd', 'mostkills', 'Killer', 'kills'),
('W', 'nd', 'mp500', 'MP-500', 'kills with MP-500'),
('W', 'nd', 'mp7', 'MP-7', 'kills with MP-7'),
('W', 'nd', 'nx300', 'NX-300', 'kills with NX-300'),
('W', 'nd', 'p12 grenade', 'P12 POISON', 'kills with P12 POISON'),
('W', 'nd', 'p900', 'P-900', 'kills with P-900'),
('W', 'nd', 'paladin', 'PALADIN PLR-5', 'kills with PALADIN PLR-5'),
('W', 'nd', 'pp22', 'PP-22', 'kills with PP-22'),
('W', 'nd', 'psg', 'PSG-L', 'kills with PSG-L'),
('W', 'nd', 'R.E.D.', 'R.E.D.', 'kills with R.E.D.'),
('W', 'nd', 'repair tool', 'Engineer', 'kills with BLOWTORCH'),
('W', 'nd', 'rocket turret', 'Rocket Turret', 'kills with Rocket Turret'),
('W', 'nd', 'shotgun', 'SPETZ-9', 'kills with SPETZ-9'),
('W', 'nd', 'sonic turret', 'SONIC TURRET', 'kills with Sonic Turret'),
('W', 'nd', 'sp5', 'SP-5 K1', 'kills with SP-5 K1'),
('W', 'nd', 'suicide', 'Self-murderer', 'suicides'),
('W', 'nd', 'teamkills', 'Betrayer', 'team kills'),
('W', 'nd', 'u23 grenade', 'U23 POISON', 'kills with U23 POISON'),
('W', 'nd', 'x01', 'X-01', 'kills with X-01');


-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Clans`
--

CREATE TABLE IF NOT EXISTS `hlstats_Clans` (
  `clanId` int(10) unsigned NOT NULL auto_increment,
  `tag` varchar(64) NOT NULL default '',
  `name` varchar(128) NOT NULL default '',
  `homepage` varchar(64) NOT NULL default '',
  `game` varchar(32) NOT NULL default '',
  `hidden` tinyint(3) unsigned NOT NULL default '0',
  `mapregion` varchar(128) NOT NULL default '',
  PRIMARY KEY  (`clanId`),
  UNIQUE KEY `tag` (`game`,`tag`),
  KEY `game` (`game`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_ClanTags`
--

CREATE TABLE IF NOT EXISTS `hlstats_ClanTags` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `pattern` varchar(64) NOT NULL,
  `position` enum('EITHER','START','END') NOT NULL default 'EITHER',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `pattern` (`pattern`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_ClanTags`
--

INSERT INTO `hlstats_ClanTags` (`pattern`, `position`) VALUES
('[AXXXXX]', 'EITHER'),
('|AXXXXX|', 'EITHER'),
('(AXXXXX)', 'EITHER'),
('{AXXXXX}', 'EITHER'),
('-=AXXX=-', 'START'),
('=AXXXXX=', 'START'),
('-AXXXXX-', 'START'),
('=[AXXXX]=', 'START'),
('-=|AXXXXXX|=-', 'EITHER'),
('-=[AXXXXXX]=-', 'EITHER'),
('-=]AXXXXXX[=-', 'EITHER'),
('~{|AXXXXXX|}~', 'EITHER'),
('-|-AXXXXXX-|-', 'EITHER'),
('-(AXXXXXX)-', 'EITHER'),
('::AXXXXXX::', 'EITHER'),
('<<AXXXXXX>>', 'EITHER'),
('{{AXXXXXX}}', 'EITHER'),
('((AXXXXXX))', 'EITHER'),
('.|AXXXXXX|.', 'EITHER'),
('--AXXXXXX--', 'EITHER'),
('\AXXXXXX/', 'EITHER'),
('-)AXXXXXX(-', 'EITHER'),
('/AXXXXXX', 'EITHER'),
('//AXXXXXX', 'EITHER'),
('_AXXXXXX_', 'EITHER'),
('_=|AXXXXXX|=_', 'EITHER'),
('*AXXXXXX*', 'EITHER'),
('.:AXXXXXX:', 'START'),
('[(AXXXXXX)]', 'EITHER');

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Countries`
--

CREATE TABLE IF NOT EXISTS `hlstats_Countries` (
  `flag` varchar(16) NOT NULL,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY  (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Countries`
--

INSERT INTO `hlstats_Countries` (`flag`, `name`) VALUES
('AD', 'Andorra'),
('AE', 'United Arab Emirates'),
('AF', 'Afghanistan'),
('AG', 'Antigua & Barbuda'),
('AI', 'Anguilla'),
('AL', 'Albania'),
('AM', 'Armenia'),
('AN', 'Netherlands Antilles'),
('AO', 'Angola'),
('AQ', 'Antarctica'),
('AR', 'Argentina'),
('AS', 'American Samoa'),
('AT', 'Austria'),
('AU', 'Australia'),
('AW', 'Aruba'),
('AZ', 'Azerbaijan'),
('BA', 'Bosnia and Herzegovina'),
('BB', 'Barbados'),
('BD', 'Bangladesh'),
('BE', 'Belgium'),
('BF', 'Burkina Faso'),
('BG', 'Bulgaria'),
('BH', 'Bahrain'),
('BI', 'Burundi'),
('BJ', 'Benin'),
('BM', 'Bermuda'),
('BN', 'Brunei Darussalam'),
('BO', 'Bolivia'),
('BR', 'Brazil'),
('BS', 'Bahama'),
('BT', 'Bhutan'),
('BU', 'Burma (no longer exists)'),
('BV', 'Bouvet Island'),
('BW', 'Botswana'),
('BY', 'Belarus'),
('BZ', 'Belize'),
('CA', 'Canada'),
('CC', 'Cocos (Keeling) Islands'),
('CF', 'Central African Republic'),
('CG', 'Congo'),
('CH', 'Switzerland'),
('CI', 'Côte D''ivoire (Ivory Coast)'),
('CK', 'Cook Iislands'),
('CL', 'Chile'),
('CM', 'Cameroon'),
('CN', 'China'),
('CO', 'Colombia'),
('CR', 'Costa Rica'),
('CS', 'Czechoslovakia (no longer exists)'),
('CU', 'Cuba'),
('CV', 'Cape Verde'),
('CX', 'Christmas Island'),
('CY', 'Cyprus'),
('CZ', 'Czech Republic'),
('DD', 'German Democratic Republic (no longer exists)'),
('DE', 'Germany'),
('DJ', 'Djibouti'),
('DK', 'Denmark'),
('DM', 'Dominica'),
('DO', 'Dominican Republic'),
('DZ', 'Algeria'),
('EC', 'Ecuador'),
('EE', 'Estonia'),
('EG', 'Egypt'),
('EH', 'Western Sahara'),
('ER', 'Eritrea'),
('ES', 'Spain'),
('ET', 'Ethiopia'),
('FI', 'Finland'),
('FJ', 'Fiji'),
('FK', 'Falkland Islands (Malvinas)'),
('FM', 'Micronesia'),
('FO', 'Faroe Islands'),
('FR', 'France'),
('FX', 'France, Metropolitan'),
('GA', 'Gabon'),
('GB', 'United Kingdom (Great Britain)'),
('GD', 'Grenada'),
('GE', 'Georgia'),
('GF', 'French Guiana'),
('GH', 'Ghana'),
('GI', 'Gibraltar'),
('GL', 'Greenland'),
('GM', 'Gambia'),
('GN', 'Guinea'),
('GP', 'Guadeloupe'),
('GQ', 'Equatorial Guinea'),
('GR', 'Greece'),
('GS', 'South Georgia and the South Sandwich Islands'),
('GT', 'Guatemala'),
('GU', 'Guam'),
('GW', 'Guinea-Bissau'),
('GY', 'Guyana'),
('HK', 'Hong Kong'),
('HM', 'Heard & McDonald Islands'),
('HN', 'Honduras'),
('HR', 'Croatia'),
('HT', 'Haiti'),
('HU', 'Hungary'),
('ID', 'Indonesia'),
('IE', 'Ireland'),
('IL', 'Israel'),
('IN', 'India'),
('IO', 'British Indian Ocean Territory'),
('IQ', 'Iraq'),
('IR', 'Islamic Republic of Iran'),
('IS', 'Iceland'),
('IT', 'Italy'),
('JM', 'Jamaica'),
('JO', 'Jordan'),
('JP', 'Japan'),
('KE', 'Kenya'),
('KG', 'Kyrgyzstan'),
('KH', 'Cambodia'),
('KI', 'Kiribati'),
('KM', 'Comoros'),
('KN', 'St. Kitts and Nevis'),
('KP', 'Korea, Democratic People''s Republic of'),
('KR', 'Korea, Republic of'),
('KW', 'Kuwait'),
('KY', 'Cayman Islands'),
('KZ', 'Kazakhstan'),
('LA', 'Lao People''s Democratic Republic'),
('LB', 'Lebanon'),
('LC', 'Saint Lucia'),
('LI', 'Liechtenstein'),
('LK', 'Sri Lanka'),
('LR', 'Liberia'),
('LS', 'Lesotho'),
('LT', 'Lithuania'),
('LU', 'Luxembourg'),
('LV', 'Latvia'),
('LY', 'Libyan Arab Jamahiriya'),
('MA', 'Morocco'),
('MC', 'Monaco'),
('MD', 'Moldova, Republic of '),
('MG', 'Madagascar'),
('MH', 'Marshall Islands'),
('ML', 'Mali'),
('MM', 'Myanmar'),
('MN', 'Mongolia'),
('MO', 'Macau'),
('MP', 'Northern Mariana Islands'),
('MQ', 'Martinique'),
('MR', 'Mauritania'),
('MS', 'Monserrat'),
('MT', 'Malta'),
('MU', 'Mauritius'),
('MV', 'Maldives'),
('MW', 'Malawi'),
('MX', 'Mexico'),
('MY', 'Malaysia'),
('MZ', 'Mozambique'),
('NA', 'Namibia'),
('NC', 'New Caledonia'),
('NE', 'Niger'),
('NF', 'Norfolk Island'),
('NG', 'Nigeria'),
('NI', 'Nicaragua'),
('NL', 'Netherlands'),
('NO', 'Norway'),
('NP', 'Nepal'),
('NR', 'Nauru'),
('NT', 'Neutral Zone (no longer exists)'),
('NU', 'Niue'),
('NZ', 'New Zealand'),
('OM', 'Oman'),
('PA', 'Panama'),
('PE', 'Peru'),
('PF', 'French Polynesia'),
('PG', 'Papua New Guinea'),
('PH', 'Philippines'),
('PK', 'Pakistan'),
('PL', 'Poland'),
('PM', 'St. Pierre & Miquelon'),
('PN', 'Pitcairn'),
('PR', 'Puerto Rico'),
('PT', 'Portugal'),
('PW', 'Palau'),
('PY', 'Paraguay'),
('QA', 'Qatar'),
('RE', 'Réunion'),
('RO', 'Romania'),
('RU', 'Russian Federation'),
('RW', 'Rwanda'),
('SA', 'Saudi Arabia'),
('SB', 'Solomon Islands'),
('SC', 'Seychelles'),
('SD', 'Sudan'),
('SE', 'Sweden'),
('SG', 'Singapore'),
('SH', 'St. Helena'),
('SI', 'Slovenia'),
('SJ', 'Svalbard & Jan Mayen Islands'),
('SK', 'Slovakia'),
('SL', 'Sierra Leone'),
('SM', 'San Marino'),
('SN', 'Senegal'),
('SO', 'Somalia'),
('SR', 'Suriname'),
('ST', 'Sao Tome & Principe'),
('SU', 'Union of Soviet Socialist Republics (no longer exi'),
('SV', 'El Salvador'),
('SY', 'Syrian Arab Republic'),
('SZ', 'Swaziland'),
('TC', 'Turks & Caicos Islands'),
('TD', 'Chad'),
('TF', 'French Southern Territories'),
('TG', 'Togo'),
('TH', 'Thailand'),
('TJ', 'Tajikistan'),
('TK', 'Tokelau'),
('TM', 'Turkmenistan'),
('TN', 'Tunisia'),
('TO', 'Tonga'),
('TP', 'East Timor'),
('TR', 'Turkey'),
('TT', 'Trinidad & Tobago'),
('TV', 'Tuvalu'),
('TW', 'Taiwan, Province of China'),
('TZ', 'Tanzania, United Republic of'),
('UA', 'Ukraine'),
('UG', 'Uganda'),
('UM', 'United States Minor Outlying Islands'),
('US', 'United States of America'),
('UY', 'Uruguay'),
('UZ', 'Uzbekistan'),
('VA', 'Vatican City State (Holy See)'),
('VC', 'St. Vincent & the Grenadines'),
('VE', 'Venezuela'),
('VG', 'British Virgin Islands'),
('VI', 'United States Virgin Islands'),
('VN', 'Viet Nam'),
('VU', 'Vanuatu'),
('WF', 'Wallis & Futuna Islands'),
('WS', 'Samoa'),
('YD', 'Democratic Yemen (no longer exists)'),
('YE', 'Yemen'),
('YT', 'Mayotte'),
('YU', 'Yugoslavia'),
('ZA', 'South Africa'),
('ZM', 'Zambia'),
('ZR', 'Zaire'),
('ZW', 'Zimbabwe'),
('ZZ', 'Unknown or unspecified country');

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Events_Admin`
--

CREATE TABLE IF NOT EXISTS `hlstats_Events_Admin` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(64) NOT NULL default '',
  `type` varchar(64) NOT NULL default 'Unknown',
  `message` varchar(255) NOT NULL default '',
  `playerName` varchar(64) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Events_ChangeName`
--

CREATE TABLE IF NOT EXISTS `hlstats_Events_ChangeName` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(64) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `oldName` varchar(64) NOT NULL default '',
  `newName` varchar(64) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Events_ChangeRole`
--

CREATE TABLE IF NOT EXISTS `hlstats_Events_ChangeRole` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(64) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `role` varchar(64) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Events_ChangeTeam`
--

CREATE TABLE IF NOT EXISTS `hlstats_Events_ChangeTeam` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(64) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `team` varchar(64) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Events_Chat`
--

CREATE TABLE IF NOT EXISTS `hlstats_Events_Chat` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(64) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `message_mode` tinyint(2) NOT NULL default '0',
  `message` varchar(128) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`),
  KEY `serverId` (`serverId`),
  FULLTEXT KEY `message` (`message`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Events_Connects`
--

CREATE TABLE IF NOT EXISTS `hlstats_Events_Connects` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(64) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `ipAddress` varchar(32) NOT NULL default '',
  `hostname` varchar(255) NOT NULL default '',
  `hostgroup` varchar(255) NOT NULL default '',
  `eventTime_Disconnect` datetime default NULL,
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Events_Disconnects`
--

CREATE TABLE IF NOT EXISTS `hlstats_Events_Disconnects` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(64) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Events_Entries`
--

CREATE TABLE IF NOT EXISTS `hlstats_Events_Entries` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(64) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Events_Frags`
--

CREATE TABLE IF NOT EXISTS `hlstats_Events_Frags` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(64) NOT NULL default '',
  `killerId` int(10) unsigned NOT NULL default '0',
  `victimId` int(10) unsigned NOT NULL default '0',
  `weapon` varchar(64) NOT NULL default '',
  `headshot` tinyint(1) NOT NULL default '0',
  `killerRole` varchar(64) NOT NULL default '',
  `victimRole` varchar(64) NOT NULL default '',
  `pos_x` MEDIUMINT default NULL,
  `pos_y` MEDIUMINT default NULL,
  `pos_z` MEDIUMINT default NULL,
  `pos_victim_x` MEDIUMINT default NULL,
  `pos_victim_y` MEDIUMINT default NULL,
  `pos_victim_z` MEDIUMINT default NULL,
  PRIMARY KEY  (`id`),
  KEY `killerId` (`killerId`),
  KEY `victimId` (`victimId`),
  KEY `serverId` (`serverId`),
  KEY `headshot` (`headshot`),
  KEY `map` (`map`(5)),
  KEY `weapon16` (`weapon`(16)),
  KEY `killerRole` (`killerRole`(8))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Events_Latency`
--

CREATE TABLE IF NOT EXISTS `hlstats_Events_Latency` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(64) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `ping` int(32) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Events_PlayerActions`
--

CREATE TABLE IF NOT EXISTS `hlstats_Events_PlayerActions` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(64) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `actionId` int(10) unsigned NOT NULL default '0',
  `bonus` int(11) NOT NULL default '0',
  `pos_x` MEDIUMINT default NULL,
  `pos_y` MEDIUMINT default NULL,
  `pos_z` MEDIUMINT default NULL,
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`),
  KEY `actionId` (`actionId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Events_PlayerPlayerActions`
--

CREATE TABLE IF NOT EXISTS `hlstats_Events_PlayerPlayerActions` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(64) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `victimId` int(10) unsigned NOT NULL default '0',
  `actionId` int(10) unsigned NOT NULL default '0',
  `bonus` int(11) NOT NULL default '0',
  `pos_x` MEDIUMINT default NULL,
  `pos_y` MEDIUMINT default NULL,
  `pos_z` MEDIUMINT default NULL,
  `pos_victim_x` MEDIUMINT default NULL,
  `pos_victim_y` MEDIUMINT default NULL,
  `pos_victim_z` MEDIUMINT default NULL,
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`),
  KEY `actionId` (`actionId`),
	KEY `victimId` (`victimId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Events_Rcon`
--

CREATE TABLE IF NOT EXISTS `hlstats_Events_Rcon` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(64) NOT NULL default '',
  `type` varchar(6) NOT NULL default 'UNK',
  `remoteIp` varchar(32) NOT NULL default '',
  `password` varchar(128) NOT NULL default '',
  `command` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Events_Statsme`
--

CREATE TABLE IF NOT EXISTS `hlstats_Events_Statsme` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(64) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `weapon` varchar(64) NOT NULL default '',
  `shots` int(6) unsigned NOT NULL default '0',
  `hits` int(6) unsigned NOT NULL default '0',
  `headshots` int(6) unsigned NOT NULL default '0',
  `damage` int(6) unsigned NOT NULL default '0',
  `kills` int(6) unsigned NOT NULL default '0',
  `deaths` int(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`),
  KEY `weapon` (`weapon`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Events_Statsme2`
--

CREATE TABLE IF NOT EXISTS `hlstats_Events_Statsme2` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(64) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `weapon` varchar(64) NOT NULL default '',
  `head` int(6) unsigned NOT NULL default '0',
  `chest` int(6) unsigned NOT NULL default '0',
  `stomach` int(6) unsigned NOT NULL default '0',
  `leftarm` int(6) unsigned NOT NULL default '0',
  `rightarm` int(6) unsigned NOT NULL default '0',
  `leftleg` int(6) unsigned NOT NULL default '0',
  `rightleg` int(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`),
  KEY `weapon` (`weapon`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Events_StatsmeLatency`
--

CREATE TABLE IF NOT EXISTS `hlstats_Events_StatsmeLatency` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(64) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `ping` int(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Events_StatsmeTime`
--

CREATE TABLE IF NOT EXISTS `hlstats_Events_StatsmeTime` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(64) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `time` time NOT NULL default '00:00:00',
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Events_Suicides`
--

CREATE TABLE IF NOT EXISTS `hlstats_Events_Suicides` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(64) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `weapon` varchar(64) NOT NULL default '',
  `pos_x` MEDIUMINT default NULL,
  `pos_y` MEDIUMINT default NULL,
  `pos_z` MEDIUMINT default NULL,
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Events_TeamBonuses`
--

CREATE TABLE IF NOT EXISTS `hlstats_Events_TeamBonuses` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(64) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `actionId` int(10) unsigned NOT NULL default '0',
  `bonus` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`),
  KEY `actionId` (`actionId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Events_Teamkills`
--

CREATE TABLE IF NOT EXISTS `hlstats_Events_Teamkills` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(64) NOT NULL default '',
  `killerId` int(10) unsigned NOT NULL default '0',
  `victimId` int(10) unsigned NOT NULL default '0',
  `weapon` varchar(64) NOT NULL default '',
  `pos_x` MEDIUMINT default NULL,
  `pos_y` MEDIUMINT default NULL,
  `pos_z` MEDIUMINT default NULL,
  `pos_victim_x` MEDIUMINT default NULL,
  `pos_victim_y` MEDIUMINT default NULL,
  `pos_victim_z` MEDIUMINT default NULL,
  PRIMARY KEY  (`id`),
  KEY `killerId` (`killerId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Games`
--

CREATE TABLE IF NOT EXISTS `hlstats_Games` (
  `code` varchar(32) NOT NULL default '',
  `name` varchar(128) NOT NULL default '',
  `hidden` enum('0','1') NOT NULL default '0',
  `realgame` varchar(32) NOT NULL default 'hl2mp',
  PRIMARY KEY  (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Games`
--

INSERT INTO `hlstats_Games` (`code`, `name`, `realgame`, `hidden`) VALUES
('css','Counter-Strike: Source','css','1'),
('hl2mp','Half-Life 2 Multiplayer','hl2mp','1'),
('tf','Team Fortress 2','tf','0'),
('hl2ctf','Half-Life 2 Capture the flag','hl2mp','1'),
('dods','Day of Defeat: Source','dods','1'),
('insmod','Insurgency: Modern Infantry Combat','insmod','1'),
('ff', 'Fortress Forever','ff','1'),
('hidden','The Hidden: Source','hidden','1'),
('zps','Zombie Panic! Source','zps','1'),
('aoc','Age of Chivalry','aoc','1'),
('cstrike','Counter-Strike','cstrike','1'),
('tfc','Team Fortress Classic','tfc','1'),
('dod','Day of Defeat','dod','1'),
('ns','Natural Selection','ns','1'),
('l4d', 'Left 4 Dead', 'l4d', '1'),
('l4d2', 'Left 4 Dead 2', 'l4d', '1'),
('fof', 'Fistful of Frags', 'fof', '1'),
('ges', 'GoldenEye: Source', 'ges', '1'),
('bg2', 'Battle Grounds 2', 'bg2', '1'),
('sgtls', 'Stargate: The Last Stand', 'sgtls', '1'),
('dystopia', 'Dystopia', 'dystopia', '1'),
('nts','NeoTokyo','nts','1'),
('pvkii', 'Pirates, Vikings, & Knights II', 'pvkii', '1'),
('csp', 'CSPromod', 'csp', '1'),
('valve', 'Half-Life 1 Multiplayer', 'valve', '1'),
('nd', 'Nuclear Dawn', 'nd', '1'),
('csgo', 'Counter-Strike: Global Offensive', 'csgo', '1'),
('dinodday', 'Dino D-Day', 'dinodday', '1');

-- --------------------------------------------------------
CREATE TABLE IF NOT EXISTS `hlstats_Games_Defaults` (
  `code` varchar(32) NOT NULL,
  `parameter` varchar(50) NOT NULL,
  `value` varchar(128) NOT NULL,
  PRIMARY KEY  (`code`,`parameter`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Games_Defaults`
--

INSERT INTO `hlstats_Games_Defaults` (`code`, `parameter`, `value`) VALUES
('aoc', 'Admins', ''),
('aoc', 'AutoBanRetry', '0'),
('aoc', 'AutoTeamBalance', '0'),
('aoc', 'BonusRoundIgnore', '0'),
('aoc', 'BonusRoundTime', '0'),
('aoc', 'BroadCastEvents', '1'),
('aoc', 'BroadCastPlayerActions', '1'),
('aoc', 'ConnectAnnounce', '1'),
('aoc', 'DefaultDisplayEvents', '1'),
('aoc', 'DisplayResultsInBrowser', '1'),
('aoc', 'EnablePublicCommands', '1'),
('aoc', 'GameEngine', '3'),
('aoc', 'GameType', '0'),
('aoc', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('aoc', 'IgnoreBots', '1'),
('aoc', 'MinimumPlayersRank', '0'),
('aoc', 'MinPlayers', '4'),
('aoc', 'PlayerEvents', '1'),
('aoc', 'PlayerEventsCommandOSD', ''),
('aoc', 'ShowStats', '1'),
('aoc', 'SkillMode', '0'),
('aoc', 'SuicidePenalty', '5'),
('aoc', 'SwitchAdmins', '0'),
('aoc', 'TKPenalty', '25'),
('aoc', 'TrackServerLoad', '1'),
('aoc', 'UpdateHostname', '1'),
('bg2', 'Admins', ''),
('bg2', 'AutoBanRetry', '0'),
('bg2', 'AutoTeamBalance', '0'),
('bg2', 'BonusRoundIgnore', '0'),
('bg2', 'BonusRoundTime', '0'),
('bg2', 'BroadCastEvents', '1'),
('bg2', 'BroadCastPlayerActions', '1'),
('bg2', 'ConnectAnnounce', '1'),
('bg2', 'DefaultDisplayEvents', '1'),
('bg2', 'DisplayResultsInBrowser', '1'),
('bg2', 'EnablePublicCommands', '1'),
('bg2', 'GameEngine', '3'),
('bg2', 'GameType', '0'),
('bg2', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('bg2', 'IgnoreBots', '1'),
('bg2', 'MinimumPlayersRank', '0'),
('bg2', 'MinPlayers', '4'),
('bg2', 'PlayerEvents', '1'),
('bg2', 'PlayerEventsCommandHint', ''),
('bg2', 'ShowStats', '1'),
('bg2', 'SkillMode', '0'),
('bg2', 'SuicidePenalty', '5'),
('bg2', 'SwitchAdmins', '0'),
('bg2', 'TKPenalty', '25'),
('bg2', 'TrackServerLoad', '1'),
('bg2', 'UpdateHostname', '1'),
('csp', 'Admins', ''),
('csp', 'AutoBanRetry', '0'),
('csp', 'AutoTeamBalance', '0'),
('csp', 'BonusRoundIgnore', '0'),
('csp', 'BonusRoundTime', '0'),
('csp', 'BroadCastEvents', '1'),
('csp', 'BroadCastPlayerActions', '1'),
('csp', 'ConnectAnnounce', '1'),
('csp', 'DefaultDisplayEvents', '1'),
('csp', 'DisplayResultsInBrowser', '1'),
('csp', 'EnablePublicCommands', '1'),
('csp', 'GameEngine', '2'),
('csp', 'GameType', '0'),
('csp', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('csp', 'IgnoreBots', '1'),
('csp', 'MinimumPlayersRank', '0'),
('csp', 'MinPlayers', '4'),
('csp', 'PlayerEvents', '1'),
('csp', 'ShowStats', '1'),
('csp', 'SkillMode', '0'),
('csp', 'SuicidePenalty', '5'),
('csp', 'SwitchAdmins', '0'),
('csp', 'TKPenalty', '25'),
('csp', 'TrackServerLoad', '1'),
('csp', 'UpdateHostname', '1'),
('css', 'Admins', ''),
('css', 'AutoBanRetry', '0'),
('css', 'AutoTeamBalance', '0'),
('css', 'BonusRoundIgnore', '0'),
('css', 'BonusRoundTime', '0'),
('css', 'BroadCastEvents', '1'),
('css', 'BroadCastPlayerActions', '1'),
('css', 'ConnectAnnounce', '1'),
('css', 'DefaultDisplayEvents', '1'),
('css', 'DisplayResultsInBrowser', '1'),
('css', 'EnablePublicCommands', '1'),
('css', 'GameEngine', '3'),
('css', 'GameType', '0'),
('css', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('css', 'IgnoreBots', '1'),
('css', 'MinimumPlayersRank', '0'),
('css', 'MinPlayers', '4'),
('css', 'PlayerEvents', '1'),
('css', 'ShowStats', '1'),
('css', 'SkillMode', '0'),
('css', 'SuicidePenalty', '5'),
('css', 'SwitchAdmins', '0'),
('css', 'TKPenalty', '25'),
('css', 'TrackServerLoad', '1'),
('css', 'UpdateHostname', '1'),
('cstrike', 'Admins', ''),
('cstrike', 'AutoBanRetry', '0'),
('cstrike', 'AutoTeamBalance', '0'),
('cstrike', 'BonusRoundIgnore', '0'),
('cstrike', 'BonusRoundTime', '0'),
('cstrike', 'BroadCastEvents', '1'),
('cstrike', 'BroadCastPlayerActions', '1'),
('cstrike', 'ConnectAnnounce', '1'),
('cstrike', 'DefaultDisplayEvents', '1'),
('cstrike', 'DisplayResultsInBrowser', '1'),
('cstrike', 'EnablePublicCommands', '1'),
('cstrike', 'GameEngine', '1'),
('cstrike', 'GameType', '0'),
('cstrike', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('cstrike', 'IgnoreBots', '1'),
('cstrike', 'MinimumPlayersRank', '0'),
('cstrike', 'MinPlayers', '4'),
('cstrike', 'PlayerEvents', '1'),
('cstrike', 'ShowStats', '1'),
('cstrike', 'SkillMode', '0'),
('cstrike', 'SuicidePenalty', '5'),
('cstrike', 'SwitchAdmins', '0'),
('cstrike', 'TKPenalty', '25'),
('cstrike', 'TrackServerLoad', '1'),
('cstrike', 'UpdateHostname', '1'),
('dod', 'Admins', ''),
('dod', 'AutoBanRetry', '0'),
('dod', 'AutoTeamBalance', '0'),
('dod', 'BonusRoundIgnore', '0'),
('dod', 'BonusRoundTime', '0'),
('dod', 'BroadCastEvents', '1'),
('dod', 'BroadCastPlayerActions', '1'),
('dod', 'ConnectAnnounce', '1'),
('dod', 'DefaultDisplayEvents', '1'),
('dod', 'DisplayResultsInBrowser', '1'),
('dod', 'EnablePublicCommands', '1'),
('dod', 'GameEngine', '2'),
('dod', 'GameType', '0'),
('dod', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('dod', 'IgnoreBots', '1'),
('dod', 'MinimumPlayersRank', '0'),
('dod', 'MinPlayers', '4'),
('dod', 'PlayerEvents', '1'),
('dod', 'ShowStats', '1'),
('dod', 'SkillMode', '0'),
('dod', 'SuicidePenalty', '5'),
('dod', 'SwitchAdmins', '0'),
('dod', 'TKPenalty', '25'),
('dod', 'TrackServerLoad', '1'),
('dod', 'UpdateHostname', '1'),
('dods', 'Admins', ''),
('dods', 'AutoBanRetry', '0'),
('dods', 'AutoTeamBalance', '0'),
('dods', 'BonusRoundIgnore', '0'),
('dods', 'BonusRoundTime', '0'),
('dods', 'BroadCastEvents', '1'),
('dods', 'BroadCastPlayerActions', '1'),
('dods', 'ConnectAnnounce', '1'),
('dods', 'DefaultDisplayEvents', '1'),
('dods', 'DisplayResultsInBrowser', '1'),
('dods', 'EnablePublicCommands', '1'),
('dods', 'GameEngine', '3'),
('dods', 'GameType', '0'),
('dods', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('dods', 'IgnoreBots', '1'),
('dods', 'MinimumPlayersRank', '0'),
('dods', 'MinPlayers', '4'),
('dods', 'PlayerEvents', '1'),
('dods', 'ShowStats', '1'),
('dods', 'SkillMode', '0'),
('dods', 'SuicidePenalty', '5'),
('dods', 'SwitchAdmins', '0'),
('dods', 'TKPenalty', '25'),
('dods', 'TrackServerLoad', '1'),
('dods', 'UpdateHostname', '1'),
('dystopia', 'Admins', ''),
('dystopia', 'AutoBanRetry', '0'),
('dystopia', 'AutoTeamBalance', '0'),
('dystopia', 'BonusRoundIgnore', '0'),
('dystopia', 'BonusRoundTime', '0'),
('dystopia', 'BroadCastEvents', '1'),
('dystopia', 'BroadCastPlayerActions', '1'),
('dystopia', 'ConnectAnnounce', '1'),
('dystopia', 'DefaultDisplayEvents', '1'),
('dystopia', 'DisplayResultsInBrowser', '1'),
('dystopia', 'EnablePublicCommands', '1'),
('dystopia', 'GameEngine', '3'),
('dystopia', 'GameType', '0'),
('dystopia', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('dystopia', 'IgnoreBots', '1'),
('dystopia', 'MinimumPlayersRank', '0'),
('dystopia', 'MinPlayers', '4'),
('dystopia', 'PlayerEvents', '1'),
('dystopia', 'PlayerEventsCommandHint', ''),
('dystopia', 'ShowStats', '1'),
('dystopia', 'SkillMode', '0'),
('dystopia', 'SuicidePenalty', '5'),
('dystopia', 'SwitchAdmins', '0'),
('dystopia', 'TKPenalty', '25'),
('dystopia', 'TrackServerLoad', '1'),
('dystopia', 'UpdateHostname', '1'),
('ff', 'Admins', ''),
('ff', 'AutoBanRetry', '0'),
('ff', 'AutoTeamBalance', '0'),
('ff', 'BonusRoundIgnore', '0'),
('ff', 'BonusRoundTime', '0'),
('ff', 'BroadCastEvents', '1'),
('ff', 'BroadCastPlayerActions', '1'),
('ff', 'ConnectAnnounce', '1'),
('ff', 'DefaultDisplayEvents', '1'),
('ff', 'DisplayResultsInBrowser', '1'),
('ff', 'EnablePublicCommands', '1'),
('ff', 'GameEngine', '2'),
('ff', 'GameType', '0'),
('ff', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('ff', 'IgnoreBots', '1'),
('ff', 'MinimumPlayersRank', '0'),
('ff', 'MinPlayers', '4'),
('ff', 'PlayerEvents', '1'),
('ff', 'PlayerEventsCommandHint', ''),
('ff', 'ShowStats', '1'),
('ff', 'SkillMode', '0'),
('ff', 'SuicidePenalty', '5'),
('ff', 'SwitchAdmins', '0'),
('ff', 'TKPenalty', '25'),
('ff', 'TrackServerLoad', '1'),
('ff', 'UpdateHostname', '1'),
('fof', 'Admins', ''),
('fof', 'AutoBanRetry', '0'),
('fof', 'AutoTeamBalance', '0'),
('fof', 'BonusRoundIgnore', '0'),
('fof', 'BonusRoundTime', '0'),
('fof', 'BroadCastEvents', '1'),
('fof', 'BroadCastPlayerActions', '1'),
('fof', 'ConnectAnnounce', '1'),
('fof', 'DefaultDisplayEvents', '1'),
('fof', 'DisplayResultsInBrowser', '1'),
('fof', 'EnablePublicCommands', '1'),
('fof', 'GameEngine', '3'),
('fof', 'GameType', '0'),
('fof', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('fof', 'IgnoreBots', '1'),
('fof', 'MinimumPlayersRank', '0'),
('fof', 'MinPlayers', '4'),
('fof', 'PlayerEvents', '1'),
('fof', 'PlayerEventsCommandHint', ''),
('fof', 'ShowStats', '1'),
('fof', 'SkillMode', '0'),
('fof', 'SuicidePenalty', '5'),
('fof', 'SwitchAdmins', '0'),
('fof', 'TKPenalty', '25'),
('fof', 'TrackServerLoad', '1'),
('fof', 'UpdateHostname', '1'),
('ges', 'Admins', ''),
('ges', 'AutoBanRetry', '0'),
('ges', 'AutoTeamBalance', '0'),
('ges', 'BonusRoundIgnore', '0'),
('ges', 'BonusRoundTime', '0'),
('ges', 'BroadCastEvents', '1'),
('ges', 'BroadCastPlayerActions', '1'),
('ges', 'ConnectAnnounce', '1'),
('ges', 'DefaultDisplayEvents', '1'),
('ges', 'DisplayResultsInBrowser', '0'),
('ges', 'EnablePublicCommands', '1'),
('ges', 'GameEngine', '3'),
('ges', 'GameType', '0'),
('ges', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('ges', 'IgnoreBots', '1'),
('ges', 'MinimumPlayersRank', '0'),
('ges', 'MinPlayers', '4'),
('ges', 'PlayerEvents', '1'),
('ges', 'PlayerEventsCommandHint', ''),
('ges', 'ShowStats', '1'),
('ges', 'SkillMode', '0'),
('ges', 'SuicidePenalty', '5'),
('ges', 'SwitchAdmins', '0'),
('ges', 'TKPenalty', '25'),
('ges', 'TrackServerLoad', '1'),
('ges', 'UpdateHostname', '1'),
('hidden', 'Admins', ''),
('hidden', 'AutoBanRetry', '0'),
('hidden', 'AutoTeamBalance', '0'),
('hidden', 'BonusRoundIgnore', '0'),
('hidden', 'BonusRoundTime', '0'),
('hidden', 'BroadCastEvents', '1'),
('hidden', 'BroadCastPlayerActions', '1'),
('hidden', 'ConnectAnnounce', '1'),
('hidden', 'DefaultDisplayEvents', '1'),
('hidden', 'DisplayResultsInBrowser', '1'),
('hidden', 'EnablePublicCommands', '1'),
('hidden', 'GameEngine', '2'),
('hidden', 'GameType', '0'),
('hidden', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('hidden', 'IgnoreBots', '1'),
('hidden', 'MinimumPlayersRank', '0'),
('hidden', 'MinPlayers', '4'),
('hidden', 'PlayerEvents', '1'),
('hidden', 'PlayerEventsCommandHint', ''),
('hidden', 'ShowStats', '1'),
('hidden', 'SkillMode', '0'),
('hidden', 'SuicidePenalty', '5'),
('hidden', 'SwitchAdmins', '0'),
('hidden', 'TKPenalty', '25'),
('hidden', 'TrackServerLoad', '1'),
('hidden', 'UpdateHostname', '1'),
('hl2mp', 'Admins', ''),
('hl2mp', 'AutoBanRetry', '0'),
('hl2mp', 'AutoTeamBalance', '0'),
('hl2mp', 'BonusRoundIgnore', '0'),
('hl2mp', 'BonusRoundTime', '0'),
('hl2mp', 'BroadCastEvents', '1'),
('hl2mp', 'BroadCastPlayerActions', '1'),
('hl2mp', 'ConnectAnnounce', '1'),
('hl2mp', 'DefaultDisplayEvents', '1'),
('hl2mp', 'DisplayResultsInBrowser', '1'),
('hl2mp', 'EnablePublicCommands', '1'),
('hl2mp', 'GameEngine', '3'),
('hl2mp', 'GameType', '0'),
('hl2mp', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('hl2mp', 'IgnoreBots', '1'),
('hl2mp', 'MinimumPlayersRank', '0'),
('hl2mp', 'MinPlayers', '4'),
('hl2mp', 'PlayerEvents', '1'),
('hl2mp', 'PlayerEventsCommandOSD', ''),
('hl2mp', 'ShowStats', '1'),
('hl2mp', 'SkillMode', '0'),
('hl2mp', 'SuicidePenalty', '5'),
('hl2mp', 'SwitchAdmins', '0'),
('hl2mp', 'TKPenalty', '25'),
('hl2mp', 'TrackServerLoad', '1'),
('hl2mp', 'UpdateHostname', '1'),
('insmod', 'Admins', ''),
('insmod', 'AutoBanRetry', '0'),
('insmod', 'AutoTeamBalance', '0'),
('insmod', 'BonusRoundIgnore', '0'),
('insmod', 'BonusRoundTime', '0'),
('insmod', 'BroadCastEvents', '1'),
('insmod', 'BroadCastPlayerActions', '1'),
('insmod', 'ConnectAnnounce', '1'),
('insmod', 'DefaultDisplayEvents', '1'),
('insmod', 'DisplayResultsInBrowser', '0'),
('insmod', 'EnablePublicCommands', '1'),
('insmod', 'GameEngine', '2'),
('insmod', 'GameType', '0'),
('insmod', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('insmod', 'IgnoreBots', '1'),
('insmod', 'MinimumPlayersRank', '0'),
('insmod', 'MinPlayers', '4'),
('insmod', 'PlayerEvents', '1'),
('insmod', 'PlayerEventsCommandHint', ''),
('insmod', 'ShowStats', '1'),
('insmod', 'SkillMode', '0'),
('insmod', 'SuicidePenalty', '5'),
('insmod', 'SwitchAdmins', '0'),
('insmod', 'TKPenalty', '25'),
('insmod', 'TrackServerLoad', '1'),
('insmod', 'UpdateHostname', '1'),
('l4d', 'Admins', ''),
('l4d', 'AutoBanRetry', '0'),
('l4d', 'AutoTeamBalance', '0'),
('l4d', 'BonusRoundIgnore', '0'),
('l4d', 'BonusRoundTime', '0'),
('l4d', 'BroadCastEvents', '0'),
('l4d', 'BroadCastPlayerActions', '0'),
('l4d', 'ConnectAnnounce', '1'),
('l4d', 'DefaultDisplayEvents', '0'),
('l4d', 'DisplayResultsInBrowser', '0'),
('l4d', 'EnablePublicCommands', '0'),
('l4d', 'GameEngine', '3'),
('l4d', 'GameType', '0'),
('l4d', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('l4d', 'IgnoreBots', '0'),
('l4d', 'MinimumPlayersRank', '0'),
('l4d', 'MinPlayers', '1'),
('l4d', 'PlayerEvents', '1'),
('l4d', 'PlayerEventsCommandHint', ''),
('l4d', 'ShowStats', '1'),
('l4d', 'SkillMode', '0'),
('l4d', 'SuicidePenalty', '5'),
('l4d', 'SwitchAdmins', '0'),
('l4d', 'TKPenalty', '25'),
('l4d', 'TrackServerLoad', '1'),
('l4d', 'UpdateHostname', '1'),
('ns', 'Admins', ''),
('ns', 'AutoBanRetry', '0'),
('ns', 'AutoTeamBalance', '0'),
('ns', 'BonusRoundIgnore', '0'),
('ns', 'BonusRoundTime', '0'),
('ns', 'BroadCastEvents', '1'),
('ns', 'BroadCastPlayerActions', '1'),
('ns', 'ConnectAnnounce', '1'),
('ns', 'DefaultDisplayEvents', '1'),
('ns', 'DisplayResultsInBrowser', '0'),
('ns', 'EnablePublicCommands', '1'),
('ns', 'GameEngine', '1'),
('ns', 'GameType', '0'),
('ns', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('ns', 'IgnoreBots', '1'),
('ns', 'MinimumPlayersRank', '0'),
('ns', 'MinPlayers', '4'),
('ns', 'PlayerEvents', '1'),
('ns', 'ShowStats', '1'),
('ns', 'SkillMode', '0'),
('ns', 'SuicidePenalty', '5'),
('ns', 'SwitchAdmins', '0'),
('ns', 'TKPenalty', '25'),
('ns', 'TrackServerLoad', '1'),
('ns', 'UpdateHostname', '1'),
('pvkii', 'Admins', ''),
('pvkii', 'AutoBanRetry', '0'),
('pvkii', 'AutoTeamBalance', '0'),
('pvkii', 'BonusRoundIgnore', '0'),
('pvkii', 'BonusRoundTime', '0'),
('pvkii', 'BroadCastEvents', '1'),
('pvkii', 'BroadCastPlayerActions', '1'),
('pvkii', 'ConnectAnnounce', '1'),
('pvkii', 'DefaultDisplayEvents', '1'),
('pvkii', 'DisplayResultsInBrowser', '1'),
('pvkii', 'EnablePublicCommands', '1'),
('pvkii', 'GameEngine', '3'),
('pvkii', 'GameType', '0'),
('pvkii', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('pvkii', 'IgnoreBots', '1'),
('pvkii', 'MinimumPlayersRank', '0'),
('pvkii', 'MinPlayers', '4'),
('pvkii', 'PlayerEvents', '1'),
('pvkii', 'ShowStats', '1'),
('pvkii', 'SkillMode', '0'),
('pvkii', 'SuicidePenalty', '5'),
('pvkii', 'SwitchAdmins', '0'),
('pvkii', 'TKPenalty', '25'),
('pvkii', 'TrackServerLoad', '1'),
('pvkii', 'UpdateHostname', '1'),
('sgtls', 'Admins', ''),
('sgtls', 'AutoBanRetry', '0'),
('sgtls', 'AutoTeamBalance', '0'),
('sgtls', 'BonusRoundIgnore', '0'),
('sgtls', 'BonusRoundTime', '0'),
('sgtls', 'BroadCastEvents', '1'),
('sgtls', 'BroadCastPlayerActions', '1'),
('sgtls', 'ConnectAnnounce', '1'),
('sgtls', 'DefaultDisplayEvents', '1'),
('sgtls', 'DisplayResultsInBrowser', '1'),
('sgtls', 'EnablePublicCommands', '1'),
('sgtls', 'GameEngine', '3'),
('sgtls', 'GameType', '0'),
('sgtls', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('sgtls', 'IgnoreBots', '1'),
('sgtls', 'MinimumPlayersRank', '0'),
('sgtls', 'MinPlayers', '4'),
('sgtls', 'PlayerEvents', '1'),
('sgtls', 'PlayerEventsCommandHint', ''),
('sgtls', 'ShowStats', '1'),
('sgtls', 'SkillMode', '0'),
('sgtls', 'SuicidePenalty', '5'),
('sgtls', 'SwitchAdmins', '0'),
('sgtls', 'TKPenalty', '25'),
('sgtls', 'TrackServerLoad', '1'),
('sgtls', 'UpdateHostname', '1'),
('tf', 'Admins', ''),
('tf', 'AutoBanRetry', '0'),
('tf', 'AutoTeamBalance', '0'),
('tf', 'BonusRoundIgnore', '1'),
('tf', 'BonusRoundTime', '0'),
('tf', 'BroadCastEvents', '1'),
('tf', 'BroadCastPlayerActions', '1'),
('tf', 'ConnectAnnounce', '1'),
('tf', 'DefaultDisplayEvents', '1'),
('tf', 'DisplayResultsInBrowser', '1'),
('tf', 'EnablePublicCommands', '1'),
('tf', 'GameEngine', '3'),
('tf', 'GameType', '0'),
('tf', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('tf', 'IgnoreBots', '1'),
('tf', 'MinimumPlayersRank', '0'),
('tf', 'MinPlayers', '4'),
('tf', 'PlayerEvents', '1'),
('tf', 'ShowStats', '1'),
('tf', 'SkillMode', '0'),
('tf', 'SuicidePenalty', '5'),
('tf', 'SwitchAdmins', '0'),
('tf', 'TKPenalty', '0'),
('tf', 'TrackServerLoad', '1'),
('tf', 'UpdateHostname', '1'),
('tfc', 'Admins', ''),
('tfc', 'AutoBanRetry', '0'),
('tfc', 'AutoTeamBalance', '0'),
('tfc', 'BonusRoundIgnore', '0'),
('tfc', 'BonusRoundTime', '0'),
('tfc', 'BroadCastEvents', '1'),
('tfc', 'BroadCastPlayerActions', '1'),
('tfc', 'ConnectAnnounce', '1'),
('tfc', 'DefaultDisplayEvents', '1'),
('tfc', 'DisplayResultsInBrowser', '0'),
('tfc', 'EnablePublicCommands', '1'),
('tfc', 'GameEngine', '1'),
('tfc', 'GameType', '0'),
('tfc', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('tfc', 'IgnoreBots', '1'),
('tfc', 'MinimumPlayersRank', '0'),
('tfc', 'MinPlayers', '4'),
('tfc', 'PlayerEvents', '1'),
('tfc', 'ShowStats', '1'),
('tfc', 'SkillMode', '0'),
('tfc', 'SuicidePenalty', '5'),
('tfc', 'SwitchAdmins', '0'),
('tfc', 'TKPenalty', '25'),
('tfc', 'TrackServerLoad', '1'),
('tfc', 'UpdateHostname', '1'),
('zps', 'Admins', ''),
('zps', 'AutoBanRetry', '0'),
('zps', 'AutoTeamBalance', '0'),
('zps', 'BonusRoundIgnore', '0'),
('zps', 'BonusRoundTime', '0'),
('zps', 'BroadCastEvents', '1'),
('zps', 'BroadCastPlayerActions', '1'),
('zps', 'ConnectAnnounce', '1'),
('zps', 'DefaultDisplayEvents', '1'),
('zps', 'DisplayResultsInBrowser', '1'),
('zps', 'EnablePublicCommands', '1'),
('zps', 'GameEngine', '3'),
('zps', 'GameType', '0'),
('zps', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('zps', 'IgnoreBots', '1'),
('zps', 'MinimumPlayersRank', '0'),
('zps', 'MinPlayers', '4'),
('zps', 'PlayerEvents', '1'),
('zps', 'PlayerEventsCommandHint', ''),
('zps', 'ShowStats', '1'),
('zps', 'SkillMode', '0'),
('zps', 'SuicidePenalty', '5'),
('zps', 'SwitchAdmins', '0'),
('zps', 'TKPenalty', '25'),
('zps', 'TrackServerLoad', '1'),
('zps', 'UpdateHostname', '1'),
('nts', 'Admins', ''),
('nts', 'AutoBanRetry', '0'),
('nts', 'AutoTeamBalance', '0'),
('nts', 'BonusRoundIgnore', '0'),
('nts', 'BonusRoundTime', '0'),
('nts', 'BroadCastEvents', '1'),
('nts', 'BroadCastPlayerActions', '1'),
('nts', 'ConnectAnnounce', '1'),
('nts', 'DefaultDisplayEvents', '1'),
('nts', 'DisplayResultsInBrowser', '1'),
('nts', 'EnablePublicCommands', '1'),
('nts', 'GameEngine', '2'),
('nts', 'GameType', '0'),
('nts', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('nts', 'IgnoreBots', '1'),
('nts', 'MinimumPlayersRank', '0'),
('nts', 'MinPlayers', '4'),
('nts', 'PlayerEvents', '1'),
('nts', 'ShowStats', '1'),
('nts', 'SkillMode', '0'),
('nts', 'SuicidePenalty', '5'),
('nts', 'SwitchAdmins', '0'),
('nts', 'TKPenalty', '25'),
('nts', 'TrackServerLoad', '1'),
('nts', 'UpdateHostname', '1'),
('valve', 'Admins', ''),
('valve', 'AutoBanRetry', '0'),
('valve', 'AutoTeamBalance', '0'),
('valve', 'BonusRoundIgnore', '0'),
('valve', 'BonusRoundTime', '0'),
('valve', 'BroadCastEvents', '1'),
('valve', 'BroadCastPlayerActions', '1'),
('valve', 'ConnectAnnounce', '1'),
('valve', 'DefaultDisplayEvents', '1'),
('valve', 'DisplayResultsInBrowser', '1'),
('valve', 'EnablePublicCommands', '1'),
('valve', 'GameEngine', '1'),
('valve', 'GameType', '0'),
('valve', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('valve', 'IgnoreBots', '1'),
('valve', 'MinimumPlayersRank', '0'),
('valve', 'MinPlayers', '4'),
('valve', 'PlayerEvents', '1'),
('valve', 'ShowStats', '1'),
('valve', 'SkillMode', '0'),
('valve', 'SuicidePenalty', '5'),
('valve', 'SwitchAdmins', '0'),
('valve', 'TKPenalty', '25'),
('valve', 'TrackServerLoad', '1'),
('valve', 'UpdateHostname', '1'),
('nd', 'Admins', ''),
('nd', 'AutoBanRetry', '0'),
('nd', 'AutoTeamBalance', '0'),
('nd', 'BonusRoundIgnore', '1'),
('nd', 'BonusRoundTime', '0'),
('nd', 'BroadCastEvents', '1'),
('nd', 'BroadCastEventsCommand', 'hlx_sm_psay'),
('nd', 'BroadCastEventsCommandAnnounce', 'hlx_sm_psay'),
('nd', 'BroadCastPlayerActions', '1'),
('nd', 'ConnectAnnounce', '1'),
('nd', 'DefaultDisplayEvents', '1'),
('nd', 'DisplayResultsInBrowser', '0'),
('nd', 'EnablePublicCommands', '1'),
('nd', 'GameEngine', '3'),
('nd', 'GameType', '0'),
('nd', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('nd', 'IgnoreBots', '1'),
('nd', 'MinimumPlayersRank', '0'),
('nd', 'MinPlayers', '4'),
('nd', 'PlayerEvents', '1'),
('nd', 'PlayerEventsCommand', 'hlx_sm_psay'),
('nd', 'PlayerEventsCommandHint', 'hlx_sm_hint'),
('nd', 'PlayerEventsCommandOSD', 'hlx_sm_msay'),
('nd', 'ShowStats', '1'),
('nd', 'SkillMode', '0'),
('nd', 'SuicidePenalty', '5'),
('nd', 'SwitchAdmins', '0'),
('nd', 'TKPenalty', '0'),
('nd', 'TrackServerLoad', '1'),
('nd', 'UpdateHostname', '1'),
('csgo', 'Admins', ''),
('csgo', 'AutoBanRetry', '0'),
('csgo', 'AutoTeamBalance', '0'),
('csgo', 'BonusRoundIgnore', '0'),
('csgo', 'BonusRoundTime', '0'),
('csgo', 'BroadCastEvents', '1'),
('csgo', 'BroadCastPlayerActions', '1'),
('csgo', 'ConnectAnnounce', '1'),
('csgo', 'DefaultDisplayEvents', '1'),
('csgo', 'DisplayResultsInBrowser', '0'),
('csgo', 'EnablePublicCommands', '1'),
('csgo', 'GameEngine', '3'),
('csgo', 'GameType', '0'),
('csgo', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('csgo', 'IgnoreBots', '1'),
('csgo', 'MinimumPlayersRank', '0'),
('csgo', 'MinPlayers', '4'),
('csgo', 'PlayerEvents', '1'),
('csgo', 'ShowStats', '1'),
('csgo', 'SkillMode', '0'),
('csgo', 'SuicidePenalty', '5'),
('csgo', 'SwitchAdmins', '0'),
('csgo', 'TKPenalty', '25'),
('csgo', 'TrackServerLoad', '1'),
('csgo', 'UpdateHostname', '1'),
('dinodday', 'Admins', ''),
('dinodday', 'AutoBanRetry', '0'),
('dinodday', 'AutoTeamBalance', '0'),
('dinodday', 'BonusRoundIgnore', '1'),
('dinodday', 'BonusRoundTime', '0'),
('dinodday', 'BroadCastEvents', '1'),
('dinodday', 'BroadCastPlayerActions', '1'),
('dinodday', 'ConnectAnnounce', '1'),
('dinodday', 'DefaultDisplayEvents', '1'),
('dinodday', 'DisplayResultsInBrowser', '1'),
('dinodday', 'EnablePublicCommands', '1'),
('dinodday', 'GameEngine', '3'),
('dinodday', 'GameType', '0'),
('dinodday', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('dinodday', 'IgnoreBots', '1'),
('dinodday', 'MinimumPlayersRank', '0'),
('dinodday', 'MinPlayers', '4'),
('dinodday', 'PlayerEvents', '1'),
('dinodday', 'ShowStats', '1'),
('dinodday', 'SkillMode', '0'),
('dinodday', 'SuicidePenalty', '5'),
('dinodday', 'SwitchAdmins', '0'),
('dinodday', 'TKPenalty', '0'),
('dinodday', 'TrackServerLoad', '1'),
('dinodday', 'UpdateHostname', '1');


CREATE TABLE IF NOT EXISTS `hlstats_Games_Supported` (
  `code` varchar(32) NOT NULL,
  `name` varchar(128) NOT NULL,
  PRIMARY KEY  (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Games_Supported`
--

INSERT INTO `hlstats_Games_Supported` (`code`, `name`) VALUES
('csp', 'CSPromod'),
('css', 'Counter-Strike: Source'),
('hl2mp', 'Half-Life 2 Multiplayer'),
('tf', 'Team Fortress 2'),
('dods', 'Day of Defeat: Source'),
('insmod', 'Insurgency'),
('ff', 'Fortress Forever'),
('hidden', 'Hidden: Source'),
('zps', 'Zombie Panic: Source'),
('aoc', 'Age of Chivalry'),
('cstrike', 'Counter-Strike 1.6'),
('tfc', 'Team Fortress Classic'),
('dod', 'Day of Defeat'),
('ns', 'Natural Selection'),
('l4d', 'Left 4 Dead (Orig. & 2)'),
('fof', 'Fistful of Frags'),
('ges', 'GoldenEye: Source'),
('bg2', 'Battle Grounds 2'),
('sgtls', 'Stargate: The Last Stand'),
('dystopia', 'Dystopia'),
('nts','NeoTokyo'),
('pvkii', 'Pirates, Vikings, & Knights II'),
('valve', 'Half-Life 1 Multiplayer'),
('nd', 'Nuclear Dawn'),
('csgo', 'Counter-Strike: Global Offensive'),
('dinodday', 'Dino D-Day');

CREATE TABLE IF NOT EXISTS `hlstats_Heatmap_Config` (
  `id` int(255) NOT NULL auto_increment,
  `map` varchar(64) NOT NULL,
  `game` varchar(32) NOT NULL,
  `xoffset` float NOT NULL,
  `yoffset` float NOT NULL,
  `flipx` tinyint(1) NOT NULL default '0',
  `flipy` tinyint(1) NOT NULL default '1',
  `rotate` tinyint(1) NOT NULL default '0',
  `days` tinyint(4) NOT NULL default '30',
  `brush` varchar(5) NOT NULL default 'small',
  `scale` float NOT NULL,
  `font` tinyint(2) NOT NULL default '10',
  `thumbw` float NOT NULL default '0.170312',
  `thumbh` float NOT NULL default '0.170312',
  `cropx1` int(11) NOT NULL default '0',
  `cropy1` int(11) NOT NULL default '0',
  `cropx2` int(11) NOT NULL default '0',
  `cropy2` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `gamemap` (`map`, `game`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Heatmap_Config`
--

INSERT INTO `hlstats_Heatmap_Config` (`map`, `game`, `xoffset`, `yoffset`, `flipx`, `flipy`, `days`, `brush`, `scale`, `font`, `thumbw`, `thumbh`, `cropx1`, `cropy1`, `cropx2`, `cropy2`) VALUES
('de_dust2', 'css', 5290, 4259, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('plr_pipeline', 'tf', 8006, 9236, 0, 1, 30, 'small', 13, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('pl_hoodoo_final', 'tf', 9564, 5592, 0, 1, 30, 'small', 14, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_dustbowl', 'tf', 5109, 4821, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ctf_2fort', 'tf', 5112, 4079, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('pl_goldrush', 'tf', 10669, 4221, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_egypt_final', 'tf', 9844, 9241, 0, 1, 30, 'small', 16, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_junction_final', 'tf', 4077, 5145, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_fastlane', 'tf', 7692, 5622, 0, 1, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('pl_badwater', 'tf', 4269, 3237, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_steel', 'tf', 4069, 2637, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_badlands', 'tf', 6205, 5059, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_granary', 'tf', 9274, 6088, 0, 1, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_gravelpit', 'tf', 5735, 5645, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('pl_cashworks_b3a', 'tf', 5500, 4635, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_office', 'css', 2357, 1766, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_ambush', 'bg2', 5592, 1159, 0, 1, 30, 'small', 8.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_townguard', 'bg2', 4489, 2670, 0, 1, 30, 'small', 5.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_dust', 'css', 3425, 4022, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_anzio', 'dods', 4031, 3979, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_argentan', 'dods', 4773, 2963, 0, 1, 30, 'small', 6.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_avalanche', 'dods', 3204, 2885, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_colmar', 'dods', 5915, 5373, 0, 1, 30, 'small', 9.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_donner', 'dods', 4013, 1743, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_flash', 'dods', 3895, 2330, 0, 1, 30, 'small', 5.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_jagd', 'dods', 3592, 3082, 0, 1, 30, 'small', 6.6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_kalt', 'dods', 777, 6987, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_palermo', 'dods', 2494, 3797, 0, 1, 30, 'small', 6.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_abdallah', 'insmod', 7508, 2723, 0, 1, 30, 'small', 9.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_almaden', 'insmod', 2881, 3200, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_bagdad', 'insmod', 9166, 4578, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_buhriz', 'insmod', 11943, 8220, 0, 1, 30, 'small', 16, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_haditha', 'insmod', 5582, 2630, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_haditha_night', 'insmod', 5582, 2630, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_hillah', 'insmod', 6755, 3550, 0, 1, 30, 'small', 11.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_karkar', 'insmod', 10355, 1306, 0, 1, 30, 'small', 13, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_ramadi', 'insmod', 5069, 1430, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_samawah', 'insmod', 2947, 2112, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_sinjar', 'insmod', 7427, 6887, 0, 1, 30, 'small', 11, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ins_samawah_day', 'insmod', 2809, 2152, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('arena_badlands', 'tf', 5125, 4119, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('arena_granary', 'tf', 6759, 4013, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('arena_lumberyard', 'tf', 6616, 5421, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('arena_nucleus', 'tf', 2562, 1940, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('arena_ravine', 'tf', 2647, 3547, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('arena_sawmill', 'tf', 4551, 4259, 0, 1, 30, 'small', 8.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('arena_watchtower', 'tf', 3789, 3075, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('arena_well', 'tf', 5331, 3389, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ctf_turbine', 'tf', 4496, 3593, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ctf_well', 'tf', 6437, 5123, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('tc_hydro', 'tf', 6038, 4348, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_castle4', 'tf', 4120, 7826, 0, 1, 30, 'small', 11, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_follower', 'tf', 8871, 6631, 0, 1, 30, 'small', 13, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_labor', 'tf', 5788, 3873, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_stag', 'tf', 5099, 4021, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ctf_chaos', 'tf', 3899, 3214, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dom_canalzone', 'tf', 4044, 3664, 0, 1, 30, 'small', 6.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('pl_frontier', 'tf', 6094, 4051, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('pl_halfacre', 'tf', 5098, 5920, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('pl_jungle_a1c', 'tf', 3024, 5391, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('pl_strider_v1', 'tf', 7109, 4078, 0, 1, 30, 'small', 7.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_warpath_v3', 'tf', 3995, 3298, 0, 1, 30, 'small', 6.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('grubas_nabijacz!_v6', 'tf', 2004, 2478, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_boulder_v5', 'tf', 9562, 12307, 0, 1, 30, 'small', 16, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_broma', 'tf', 5261, 3192, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_busytown', 'tf', 6413, 5961, 0, 1, 30, 'small', 11, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_roswell', 'tf', 2809, 4448, 0, 1, 30, 'small', 6.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_vertigo_beta3', 'tf', 3584, 3108, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_wolf2_b1', 'tf', 2182, 3838, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ctf_convoy_v2', 'tf', 3732, 2694, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_well', 'tf', 10371, 7681, 0, 1, 30, 'small', 15, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_furnace_b2', 'tf', 4667, 4823, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('pl_borax_b2', 'tf', 5252, 593, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_jailbreak_b3', 'tf', 8570, -702, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_desertfortress', 'tf', 3675, 3269, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('koth_viaduct','tf', 7074, 3773, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('koth_sawmill','tf', 4604, 4094, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('koth_nucleus','tf', 3156, 2520, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ctf_sawmill','tf', 4603, 4073, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('arena_offblast_final','tf', 1920, 1536, 0, 1, 30, 'small', 3, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_yukon_final','tf', 6602, 5123, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('2tpl_mine_alpine','tf', 1238, 1462, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_blackmesa','tf', 4110, 1755, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_bloodstained','tf', 7182, 5447, 0, 1, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_corporation_b2','tf', 5272, 3113, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_frontline_a1','tf', 6534, 6439, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_furnace_b3','tf', 6114, 5236, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_freight','tf', 4470, 3520, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_freight_final','tf', 4477, 3517, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fy_iceworld','tf', 1600, 1279, 0, 1, 30, 'small', 2.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cp_orange_x3','tf', 5321, 7321, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_train', 'css', 2616, 2619, 0, 1, 30, 'small', 4.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_tides', 'css', 2385, 1589, 0, 1, 30, 'small', 3.7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_prodigy', 'css', 1025, 2198, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_port', 'css', 4189, 4131, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_piranesi', 'css', 3082, 3239, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_nuke', 'css', 3541, 1856, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_inferno', 'css', 3336, 4252, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_chateau', 'css', 2121, 3074, 0, 1, 30, 'small', 4.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_cbble', 'css', 4704, 3587, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_aztec', 'css', 4235, 3430, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_militia', 'css', 2838, 2745, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_italy', 'css', 3071, 2920, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_havana', 'css', 2958, 2678, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_compound', 'css', 1734, 3943, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_assault', 'css', 2467, 8268, 0, 0, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_alberta', 'css', 4187, 2071, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_alivemetal', 'css', 1158, 1221, 0, 1, 30, 'small', 2.9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_boston', 'css', 3116, 1189, 0, 1, 30, 'small', 4.4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_carpediem_arena', 'css', 1961, 1262, 0, 1, 30, 'small', 3.2, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_deltamill2', 'css', 2388, 652, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_gristmill', 'css', 1724, -72, 0, 1, 30, 'small', 2.7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_losttemple_pro', 'css', 2495, 1838, 0, 1, 30, 'small', 5.1, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_nightfever', 'css', 3262, 4871, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_pira_legos', 'css', 2964, 3027, 0, 1, 30, 'small', 4.3, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_rumpeldust2', 'css', 3678, 3925, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_sandland', 'css', 2795, 2344, 0, 1, 30, 'small', 4.6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_snowcapped', 'css', 2248, 2633, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_toxin', 'css', 3394, 2023, 0, 1, 30, 'small', 5.4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_winery_final', 'css', 2911, 2014, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fy_twotowers','css',591,1561,1,1,30,'small',2.5,10,0.170312,0.170312,0,0,0,0),
('fy_twotowers32','css',591,1561,1,1,30,'small',2.5,10,0.170312,0.170312,0,0,0,0),
('fy_twotowers2009','css',591,1561,1,1,30,'small',2.5,10,0.170312,0.170312,0,0,0,0),
('dm_lockdown', 'hl2mp', 7301, 7172, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dm_overwatch', 'hl2mp', 1997, 8416, 0, 0, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dm_powerhouse', 'hl2mp', 2558, 762, 0, 1, 30, 'small', 3.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dm_resistance', 'hl2mp', 2606, 2129, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dm_runoff', 'hl2mp', 5116, 5210, 0, 0, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dm_steamlab', 'hl2mp', 3854, 3471, 0, 1, 30, 'small', 2.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dm_underpass', 'hl2mp', 1611, 364, 0, 1, 30, 'small', 2.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('coop_elpaso', 'fof', 7369, 4167, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('coop_peligro', 'fof', 10378, 4070, 0, 1, 30, 'small', 13, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('coop_revenge', 'fof', 1687, 2560, 0, 1, 30, 'small', 3.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('coop_sweetwater', 'fof', 2289, 1565, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_canyonland', 'fof', 6026, 6913, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_desert', 'fof', 5996, 2255, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_desperados', 'fof', 613, -645, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_eliminator', 'fof', 5944, 7040, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_eliminator_lite', 'fof', 3306, 4981, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_elpaso', 'fof', 7031, 4138, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_loothill', 'fof', 6196, 5624, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_monumentvalley', 'fof', 2563, 6738, 0, 1, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_nowhere', 'fof', 4977, 1796, 0, 1, 30, 'small', 5.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_peligro', 'fof', 4913, 4044, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_peligro_lite', 'fof', 3983, 3030, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_presidio', 'fof', 3149, 1539, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_revenge', 'fof', 1685, 2584, 0, 1, 30, 'small', 3.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_sweetwater', 'fof', 2289, 1565, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_tijuana', 'fof', 3692, 3638, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_tramonto', 'fof', 4743, 2026, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fof_tramonto_lite', 'fof', 3465, 1094, 0, 1, 30, 'small', 3, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('as_oilrig', 'cstrike', 588.81, -730.75, 0, 0, 30, 'small', 2.48, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_747', 'cstrike', 64, -608, 0, 1, 30, 'small', 1.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_assault', 'cstrike', 720, 1024, 0, 1, 30, 'small', 1.54, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_backalley', 'cstrike', 148, 1360, 0, 0, 30, 'small', 2.08, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_estate', 'cstrike', 144, -928, 0, 1, 30, 'small', 2.04, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_havana', 'cstrike', 256, 56, 0, 0, 30, 'small', 1.38, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_italy', 'cstrike', 248, 16, 0, 1, 30, 'small', 1.57, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_militia', 'cstrike', 621, -534, 0, 0, 30, 'small', 1.69, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_office', 'cstrike', 64, -260, 0, 1, 30, 'small', 1.47, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_siege', 'cstrike', 564, 1252, 0, 0, 30, 'small', 1.15, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_airstrip', 'cstrike', 1116, -368, 0, 1, 30, 'small', 1.21, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_aztec', 'cstrike', 447.31, -62.94, 0, 1, 30, 'small', 1.12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_cbble', 'cstrike', 832, 576, 0, 1, 30, 'small', 1.07, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_chateau', 'cstrike', 1032, 688.5, 0, 0, 30, 'small', 1.46, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_dust', 'cstrike', 96, 960, 0, 1, 30, 'small', 1.1, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_dust2', 'cstrike', 384, 1120, 0, 1, 30, 'small', 1.26, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_inferno', 'cstrike', 404, 1312, 0, 0, 30, 'small', 1.39, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_nuke', 'cstrike', 244, -936, 0, 0, 30, 'small', 1.14, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_piranesi', 'cstrike', 48, 864, 0, 0, 30, 'small', 1.37, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_prodigy', 'cstrike', 1476, -264, 0, 0, 30, 'small', 1.94, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_storm', 'cstrike', 191, -104, 0, 0, 30, 'small', 1.42, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_survivor', 'cstrike', 832, 880, 0, 0, 30, 'small', 1.38, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_torn', 'cstrike', 112, 664, 0, 0, 30, 'small', 1.24, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_train', 'cstrike', 49.19, 156, 0, 0, 30, 'small', 1.58, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_vertigo', 'cstrike', 1280, -256, 0, 1, 30, 'small', 2.13, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_dusk_patrol', 'bg2', 6504, 4690, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_fall', 'bg2', 1198, 2503, 0, 1, 30, 'small', 4.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_foothills', 'bg2', 5440, 5115, 0, 1, 30, 'small', 8.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_freemans_farm', 'bg2', 6648, 5275, 0, 1, 30, 'small', 10.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_maricopa', 'bg2', 6398, 2313, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_pillage', 'bg2', 3746, 6363, 0, 1, 30, 'small', 9.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_pinebarrens', 'bg2', 257, 6121, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_plateau', 'bg2', 3840, 3085, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_road', 'bg2', 5149, 3755, 0, 1, 30, 'small', 8.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_snowlake', 'bg2', 6194, 7018, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_woodland', 'bg2', 4924, 3236, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('bg_harbourtown', 'bg2', 2123, 4443, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_battleground', 'aoc', 4969, 2889, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_darkforest', 'aoc', 5984, 9812, 0, 1, 30, 'small', 13, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_firecrag', 'aoc', 3585, 10952, 0, 1, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_helms_deep', 'aoc', 5672, 2522, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_invasion', 'aoc', 3979, 3593, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_monastery', 'aoc', 5549, 3561, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_overlook', 'aoc', 3711, 2781, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_siege', 'aoc', 3186, 4274, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_sorrow', 'aoc', 4128, 6654, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_stoneshill', 'aoc', 7175, 5685, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_theshore', 'aoc', 540, 7698, 0, 0, 30, 'small', 14, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_tombs', 'aoc', 1287, 995, 0, 1, 30, 'small', 2, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_tournament', 'aoc', 1353, 1750, 0, 1, 30, 'small', 2.2, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_valley', 'aoc', 4573, 3442, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('aoc_westerlyn', 'aoc', 7166, 6094, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_2fort', 'ff', 5582, 4318, 0, 1, 30, 'small', 8.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_2morforever', 'ff', 3458, 2582, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_aardvark', 'ff', 5725, 3384, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_anticitizen', 'ff', 9919, 5646, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_attrition', 'ff', 3086, 2571, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_bases', 'ff', 5084, 4099, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_cornfield', 'ff', 4987, 3476, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_crossover', 'ff', 5996, 4577, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_cz2', 'ff', 4672, 3836, 0, 1, 30, 'small', 7.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_destroy', 'ff', 4945, 4018, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_dm', 'ff', 1917, 1501, 0, 1, 30, 'small', 3, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_dropdown', 'ff', 4529, 3539, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_dustbowl', 'ff', 5457, 4520, 0, 1, 30, 'small', 8.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_epicenter', 'ff', 3781, 3037, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_hunted', 'ff', 6151, 5125, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_impact', 'ff', 4096, 2190, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_monkey', 'ff', 4989, 4082, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_openfire', 'ff', 3173, 2504, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_palermo', 'ff', 6191, 3333, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_pitfall', 'ff', 4485, 3633, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_push', 'ff', 4744, 3849, 0, 1, 30, 'small', 7.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_schtop', 'ff', 4802, 3837, 0, 1, 30, 'small', 7.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_shutdown2', 'ff', 4703, 3825, 0, 1, 30, 'small', 7.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_tiger', 'ff', 2686, 1858, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_vertigo', 'ff', 2010, 1500, 0, 1, 30, 'small', 3, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_waterpolo', 'ff', 3209, 2608, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ff_well', 'ff', 4482, 3423, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_airport01_greenhouse', 'l4d', 175, 5272, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_airport02_offices', 'l4d', -1723, 8693, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_airport03_garage', 'l4d', 11413, 6781, 0, 1, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_airport04_terminal', 'l4d', 2659, 6795, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_airport05_runway', 'l4d', 8197, 12894, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_farm01_hilltop', 'l4d', 16423, -3193, 0, 1, 30, 'small', 13, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_farm02_traintunnel', 'l4d', 12106, -2749, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_farm03_bridge', 'l4d', 2307, -5227, 0, 1, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_farm04_barn', 'l4d', 1584, 2778, 0, 1, 30, 'small', 17, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_farm05_cornfield', 'l4d', -1851, 7619, 0, 1, 30, 'small', 13, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_hospital01_apartment', 'l4d', 662, 5571, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_hospital02_subway', 'l4d', -1621, 8552, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_hospital03_sewers', 'l4d', -7045, 14101, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_hospital04_interior', 'l4d', -9513, 16235, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_hospital05_rooftop', 'l4d', -4450, 10005, 0, 1, 30, 'small', 3, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_smalltown01_caves', 'l4d', 20542, -3156, 0, 1, 30, 'small', 13, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_smalltown03_ranchhouse', 'l4d', 16026, 2930, 0, 1, 30, 'small', 14, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_smalltown05_houseboat', 'l4d', 6554, 5155, 0, 1, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_sv_lighthouse', 'l4d', 4681, 2143, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_airport01_greenhouse', 'l4d', 175, 5272, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_airport02_offices', 'l4d', -1723, 8693, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_airport03_garage', 'l4d', 11413, 6781, 0, 1, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_airport04_terminal', 'l4d', 2659, 6795, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_airport05_runway', 'l4d', 8197, 12894, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_farm01_hilltop', 'l4d', 16423, -3193, 0, 1, 30, 'small', 13, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_farm02_traintunnel', 'l4d', 12106, -2749, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_farm03_bridge', 'l4d', 2307, -5227, 0, 1, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_farm04_barn', 'l4d', 1584, 2778, 0, 1, 30, 'small', 17, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_farm05_cornfield', 'l4d', -1851, 7619, 0, 1, 30, 'small', 13, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_hospital01_apartment', 'l4d', 662, 5571, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_hospital02_subway', 'l4d', -1621, 8552, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_hospital03_sewers', 'l4d', -7045, 14101, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_hospital04_interior', 'l4d', -9513, 16235, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_hospital05_rooftop', 'l4d', -4450, 10005, 0, 1, 30, 'small', 3, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_smalltown01_caves', 'l4d', 20542, -3156, 0, 1, 30, 'small', 13, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_smalltown03_ranchhouse', 'l4d', 16026, 2930, 0, 1, 30, 'small', 14, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('l4d_vs_smalltown05_houseboat', 'l4d', 6554, 5155, 0, 1, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_dawn_ctg', 'nts', 3447, 5426, 0, 1, 30, 'small', 5.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_engage_ctg', 'nts', 4112, 4024, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_ghost_ctg', 'nts', 4951, 6131, 0, 1, 30, 'small', 7.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_isolation_ctg', 'nts', 5357, 3549, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_rise_ctg', 'nts', 2205, 2044, 0, 1, 30, 'small', 3.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_shrine_ctg', 'nts', 4976, 6388, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_skyline_ctg', 'nts', 4516, 2141, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_subsurface_ctg', 'nts', 3319, 1552, 0, 1, 30, 'small', 6.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_tarmac_ctg', 'nts', 2359, 3388, 0, 1, 30, 'small', 5.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_transit_ctg', 'nts', 2749, 1879, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_anzio', 'dod', 50.97, -82.75, 0, 1, 30, 'small', 1.01, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_avalanche', 'dod', 424, 160, 0, 1, 30, 'small', 1.58, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_charlie', 'dod', 32, 0, 1, 1, 30, 'small', 0.77, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_chemille', 'dod', 692, -568, 1, 1, 30, 'small', 1.19, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_donner', 'dod', 192, -1248, 1, 1, 30, 'small', 1.11, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_escape', 'dod', 176, 410, 1, 1, 30, 'small', 1.26, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_falaise', 'dod', 36.5, 227, 0, 1, 30, 'small', 0.82, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_flash', 'dod', 295.99, -504, 1, 1, 30, 'small', 1.19, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_flugplatz', 'dod', 199.5, -33, 0, 1, 30, 'small', 0.85, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_forest', 'dod', 492.5, 361, 1, 1, 30, 'small', 0.9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_glider', 'dod', 426, 308, 0, 1, 30, 'small', 1.14, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_jagd', 'dod', 64, 40, 0, 1, 30, 'small', 0.86, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_kalt', 'dod', 0, -504, 0, 1, 30, 'small', 1.22, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_kraftstoff', 'dod', 656, -308, 0, 1, 30, 'small', 1.1, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_merderet', 'dod', 532, 409, 1, 1, 30, 'small', 0.93, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_northbound', 'dod', 83.5, -10.5, 1, 1, 30, 'small', 1.01, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_saints', 'dod', 704, 196, 1, 1, 30, 'small', 1.25, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_sturm', 'dod', 210, 546, 1, 1, 30, 'small', 1.06, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_switch', 'dod', 1146, 582.5, 0, 1, 30, 'small', 1.19, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_vicenza', 'dod', 48, -48, 1, 1, 30, 'small', 1.05, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_zalec', 'dod', 8, -48, 1, 1, 30, 'small', 0.77, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dod_cean', 'dod', 540, 259, 0, 1, 30, 'small', 0.87, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('co_angst', 'ns', 828, 376, 1, 1, 30, 'small', 1.42, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('co_core', 'ns', 146, -472, 1, 1, 30, 'small', 2.25, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('co_daimos', 'ns', 968, -128, 1, 1, 30, 'small', 1.17, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('co_faceoff', 'ns', 1184, -368, 0, 1, 30, 'small', 1.48, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('co_kestrel', 'ns', 962, 1648, 1, 1, 30, 'small', 1.42, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('co_niveus', 'ns', 384, 1728, 0, 1, 30, 'small', 1.27, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('co_pulse', 'ns', 764, -268, 1, 1, 30, 'small', 1.83, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('co_sava', 'ns', 310, 974, 0, 1, 30, 'small', 1.09, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('co_ulysses', 'ns', 688, -1056, 1, 1, 30, 'small', 1.64, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('co_umbra', 'ns', 1760, 192, 0, 1, 30, 'small', 1.21, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ns_altair', 'ns', 360, 24, 1, 1, 30, 'small', 0.92, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ns_ayumi', 'ns', 260, -512, 0, 1, 30, 'small', 1.21, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ns_bast', 'ns', 152.5, 63, 1, 1, 30, 'small', 0.9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ns_caged', 'ns', 256, 456, 1, 1, 30, 'small', 0.95, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ns_eclipse', 'ns', 164, -40, 1, 1, 30, 'small', 0.91, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ns_eon', 'ns', 23, 91.5, 1, 1, 30, 'small', 0.92, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ns_hera', 'ns', 180, -24, 1, 1, 30, 'small', 0.83, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ns_lost', 'ns', 12, 256, 0, 1, 30, 'small', 1.28, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ns_lucid', 'ns', 380, -632, 1, 1, 30, 'small', 1.04, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ns_machina', 'ns', 112, -404, 0, 1, 30, 'small', 0.86, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ns_metal', 'ns', 164, 388, 0, 1, 30, 'small', 0.91, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ns_nancy', 'ns', 170, 0, 1, 1, 30, 'small', 0.84, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ns_nothing', 'ns', 212, 176, 1, 1, 30, 'small', 0.88, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ns_origin', 'ns', 20, -344, 0, 1, 30, 'small', 0.97, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ns_shiva', 'ns', 40, 480, 0, 1, 30, 'small', 0.88, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ns_tanith', 'ns', 44, -4, 0, 1, 30, 'small', 1.03, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ns_veil', 'ns', 160, 144, 0, 1, 30, 'small', 0.91, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('tls_abydos', 'sgtls', 13395, 7390, 1, 1, 30, 'small', 16, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('tls_erebus', 'sgtls', 17564, 11518, 1, 1, 30, 'small', 24, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('tls_lockdown', 'sgtls', 989, 1517, 1, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('2fort', 'tfc', 90.63, 0, 0, 1, 30, 'small', 1.03, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('avanti', 'tfc', 304, 192, 0, 1, 30, 'small', 1.17, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('badlands', 'tfc', 8, 0, 1, 1, 30, 'small', 0.95, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('casbah', 'tfc', 552, -124, 0, 1, 30, 'small', 1.1, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('crossover2', 'tfc', 0, 0, 0, 1, 30, 'small', 1.11, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cz2', 'tfc', 144, 256, 0, 1, 30, 'small', 1.15, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('dustbowl', 'tfc', 448, 288, 1, 1, 30, 'small', 0.98, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('epicenter', 'tfc', 416, 0, 0, 1, 30, 'small', 1.32, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('flagrun', 'tfc', 0, 704, 0, 1, 30, 'small', 1.07, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('hunted', 'tfc', 432, 76, 1, 1, 30, 'small', 1.42, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('push', 'tfc', 0, 0, 0, 1, 30, 'small', 1.11, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ravelin', 'tfc', 0, 0, 0, 1, 30, 'small', 1.04, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('rock2', 'tfc', 0, 0, 0, 1, 30, 'small', 0.98, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('warpath', 'tfc', 112, 0, 0, 1, 30, 'small', 1.02, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('well', 'tfc', 0, 0, 0, 1, 30, 'small', 0.94, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_bullet_tdm', 'nts', 4279, 2090, 0, 1, 30, 'small', 4.3, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_dusk_ctg', 'nts', 3805, 5832, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_oilstain_ctg', 'nts', 1953, 2544, 0, 1, 30, 'small', 3, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_pissalley_ctg', 'nts', 3629, 3788, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('nt_vtol_ctg', 'nts', 6278, 4861, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_dust2_unlimited', 'css', 4238, 4440, 0, 1, 30, 'small', 6.10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_mediterrano', 'css', -3446, 3391, 0, 1, 30, 'small', 4.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_middleages', 'css', -3068, 2137, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_newportbeach', 'css', -2405, 2317, 0, 1, 30, 'small', 3.6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_pariah', 'css', -2675, 1906, 0, 1, 30, 'small', 5.25, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_residentevil', 'css', -3629, 1910, 0, 1, 30, 'small', 3.75, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_rimini', 'css', -11146, 11378, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_roma_aimstyle', 'css', -3766, 4159, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_losttemple2', 'css', -3205, 3312, 0, 1, 30, 'small', 5.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_keidas', 'css', -3607, 2473, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_hiddencity', 'css', -2488, 2344, 0, 1, 30, 'small', 3.75, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_gallery', 'css', -2931, 2470, 0, 1, 30, 'small', 4.75, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_dustanesi', 'css', -1477, 1113, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_dust2_mariostyle', 'css', -3910, 3788, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_cross_strike', 'css', -3740, 3799, 0, 1, 30, 'small', 5.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_cpl_fire', 'css', -2841, 4296, 0, 1, 30, 'small', 7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_corse', 'css', -2231, 1216, 0, 1, 30, 'small', 4.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_coldfire', 'css', -2776, 3783, 0, 1, 30, 'small', 7.25, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_cefalu', 'css', -5556, 3045, 0, 1, 30, 'small', 5.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_asia', 'css', -4408, 4349, 0, 1, 30, 'small', 6.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_office2008pro', 'css', -2270, 1640, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_office07', 'css', -3938, 1579, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_occupation', 'css', -3857, 2621, 0, 1, 30, 'small', 5.8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_meatlight', 'css', -2143, 1768, 0, 1, 30, 'small', 3.7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_italy_reloaded_final', 'css', -3463, 2775, 0, 1, 30, 'small', 3.75, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_classified', 'css', -2988, 3396, 0, 1, 30, 'small', 4.9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('fy_pool_day_reloaded', 'css', -1204, 838, 0, 1, 30, 'small', 1.75, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_westcoast', 'css', -3162, 2684, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_wanda', 'css', -3284, 5861, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_vine2', 'css', -3929, 1482, 0, 1, 30, 'small', 6.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_vegas_css', 'css', -5085, 1646, 0, 1, 30, 'small', 7.25, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_varasto_v2', 'css', -3520, 2665, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_strata', 'css', -14440, 9998, 0, 1, 30, 'small', 15, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_spirits', 'css', -4494, 3157, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_siena', 'css', -4234, 4210, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_season', 'css', -1772, 3421, 0, 1, 30, 'small', 5.75, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_scud', 'css', -5001, 3479, 0, 1, 30, 'small', 4.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_scorch_rc1', 'css', -7897, 3704, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_rush_v2', 'css', -2365, 2391, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('clocktower', 'nd', 12330, 8013, 0, 1, 30, 'small', 16.50, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('downtown', 'nd', 9377, 10471,  0, 1, 30, 'small', 19.00, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('hydro', 'nd', 8560, 6600, 0, 1, 30, 'small', 12.50, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('metro', 'nd', 5908, 4819, 0, 1, 30, 'small', 11.20, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('oasis', 'nd', 5904, 6969, 0, 1, 30, 'small', 12.50, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('silo', 'nd', 10865, 7962, 0, 1, 30, 'small', 18.00, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('oilfield_beta', 'nd', 10659, 11345, 0, 1, 30, 'small', 22.00, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_dust2', 'csgo', 3102, 3164, 0, 1, 30, 'small', 4.2, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_dust', 'csgo', 3798, 3947, 0, 1, 30, 'small', 6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_train', 'csgo', 2212, 2193, 0, 1, 30, 'small', 4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_italy', 'csgo', 3156, 2632, 0, 1, 30, 'small', 4.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_aztec', 'csgo', 3226, 2861, 0, 1, 30, 'small', 4.7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_nuke', 'csgo', 2803, 1309, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_inferno', 'csgo', 2577, 4184, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_office', 'csgo', 1931, 1183, 0, 1, 30, 'small', 3, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_dust2_se', 'csgo', 3121, 3551, 0, 1, 30, 'small', 4.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_dust_se', 'csgo', 3359, 3773, 0, 1, 30, 'small', 5.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_train_se', 'csgo', 2074, 1950, 0, 1, 30, 'small', 3.9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_italy_se', 'csgo', 2585, 2648, 0, 1, 30, 'small', 4.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_aztec_se', 'csgo', 3226, 2861, 0, 1, 30, 'small', 4.7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_nuke_se', 'csgo', 3023, 1493, 0, 1, 30, 'small', 5.3, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_inferno_se', 'csgo', 3173, 2682, 0, 1, 30, 'small', 4.8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('cs_office_se', 'csgo', 1930, 1389, 0, 1, 30, 'small', 3.6, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ar_baggage', 'csgo', 1913, 1701, 0, 1, 30, 'small', 3, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('ar_shoots', 'csgo', 1511, 1801, 0, 1, 30, 'small', 2.5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_lake', 'csgo', 1478, 1115, 0, 1, 30, 'small', 3.7, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_bank', 'csgo', 2064, 1148, 0, 1, 30, 'small', 3.4, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_safehouse', 'csgo', 348, 2360, 0, 1, 30, 'small', 3.8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_shorttrain', 'csgo', 2226, 2618, 0, 1, 30, 'small', 4.1, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_stmarc', 'csgo', 9206, 8383, 0, 1, 30, 'small', 3, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('de_sugarcane', 'csgo', 4204, 1359, 0, 1, 30, 'small', 4.3, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c1m1_hotel', 'l4d', 1829, 8518, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c1m2_streets', 'l4d', 13470, 7954, 0, 1, 30, 'small', 14, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c1m3_mall', 'l4d', 2976, 1695, 0, 1, 30, 'small', 8, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c1m4_atrium', 'l4d', 7604, -416, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c2m1_highway', 'l4d', 8585, 13642, 0, 1, 30, 'small', 20, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c2m2_fairgrounds', 'l4d', 8423, 5363, 0, 1, 30, 'small', 14, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c2m3_coaster', 'l4d', 8935, 6928, 0, 1, 30, 'small', 11, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c2m4_barns', 'l4d', 7466, 8596, 0, 1, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c2m5_concert', 'l4d', 5267, 5568, 0, 1, 30, 'small', 5, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c3m1_plankcountry', 'l4d', 13418, 12468, 0, 1, 30, 'small', 12, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c3m2_swamp', 'l4d', 12741, 13698, 0, 1, 30, 'small', 20, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c3m3_shantytown', 'l4d', 7582, 3647, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c3m4_plantation', 'l4d', 6625, 4589, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c4m1_milltown_a', 'l4d', 9457, 10870, 0, 1, 30, 'small', 14, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c4m2_sugarmill_a', 'l4d', 10459, 2124, 0, 1, 30, 'small', 18, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c4m3_sugarmill_b', 'l4d', 10156, 1946, 0, 1, 30, 'small', 18, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c4m4_milltown_b', 'l4d', 11414, 11943, 0, 1, 30, 'small', 16, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c4m5_milltown_escape', 'l4d', 11073, 11978, 0, 1, 30, 'small', 16, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c5m1_waterfront', 'l4d', 7786, 4019, 0, 1, 30, 'small', 9, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c5m2_park', 'l4d', 15435, 2762, 0, 1, 30, 'small', 15, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c5m3_cemetery', 'l4d', 7513, 11200, 0, 1, 30, 'small', 22, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c5m4_quarter', 'l4d', 7494, 5735, 0, 1, 30, 'small', 10, 10, 0.170312, 0.170312, 0, 0, 0, 0),
('c5m5_bridge', 'l4d', 14466, 16658, 0, 1, 30, 'small', 22, 10, 0.170312, 0.170312, 0, 0, 0, 0);

--
-- Table structure for table `hlstats_HostGroups`
--

CREATE TABLE IF NOT EXISTS `hlstats_HostGroups` (
  `id` int(11) NOT NULL auto_increment,
  `pattern` varchar(255) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Livestats`
--

CREATE TABLE IF NOT EXISTS `hlstats_Livestats` (
  `player_id` int(10) NOT NULL default '0',
  `server_id` int(10) NOT NULL default '0',
  `cli_address` varchar(32) NOT NULL default '',
  `cli_city` varchar(64) NOT NULL default '',
  `cli_country` varchar(64) NOT NULL default '',
  `cli_flag` varchar(16) NOT NULL default '',
  `cli_state` varchar(64) NOT NULL default '',
  `cli_lat` FLOAT(7,4) NULL,
  `cli_lng` FLOAT(7,4) NULL,
  `steam_id` varchar(64) NOT NULL default '',
  `name` varchar(64) NOT NULL,
  `team` varchar(64) NOT NULL default '',
  `kills` int(6) NOT NULL default '0',
  `deaths` int(6) NOT NULL default '0',
  `suicides` int(6) NOT NULL default '0',
  `headshots` int(6) NOT NULL default '0',
  `shots` int(11) NOT NULL default '0',
  `hits` int(11) NOT NULL default '0',
  `is_dead` tinyint(1) NOT NULL default '0',
  `has_bomb` int(1) NOT NULL default '0',
  `ping` int(6) NOT NULL default '0',
  `connected` int(10) NOT NULL default '0',
  `skill_change` int(10) NOT NULL default '0',
  `skill` int(10) NOT NULL default '0',
  PRIMARY KEY  (`player_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;

CREATE TABLE `hlstats_Maps_Counts` (
  `rowId` int(11) NOT NULL auto_increment,
  `game` varchar(32) character set utf8 NOT NULL,
  `map` varchar(64) character set utf8 NOT NULL,
  `kills` int(11) NOT NULL,
  `headshots` int(11) NOT NULL,
  PRIMARY KEY  (`game`,`map`),
  INDEX ( `rowId` )
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `hlstats_Mods_Defaults` (
  `code` varchar(32) NOT NULL,
  `parameter` varchar(50) NOT NULL,
  `value` varchar(128) NOT NULL,
  PRIMARY KEY  (`code`,`parameter`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Mods_Defaults`
--

INSERT INTO `hlstats_Mods_Defaults` (`code`, `parameter`, `value`) VALUES
('', 'BroadCastEventsCommand', ''),
('AMXX', 'BroadCastEventsCommand', 'hlx_amx_psay'),
('BEETLE', 'BroadCastEventsCommand', 'hlx_psay'),
('MANI', 'BroadCastEventsCommand', 'ma_hlx_psay'),
('MINISTATS', 'BroadCastEventsCommand', 'ms_psay'),
('SOURCEMOD', 'BroadCastEventsCommand', 'hlx_sm_psay'),
('', 'BroadCastEventsCommandAnnounce', 'say'),
('AMXX', 'BroadCastEventsCommandAnnounce', 'hlx_amx_csay'),
('BEETLE', 'BroadCastEventsCommandAnnounce', 'hlx_csay'),
('MANI', 'BroadCastEventsCommandAnnounce', 'ma_hlx_csay'),
('MINISTATS', 'BroadCastEventsCommandAnnounce', 'ms_csay'),
('SOURCEMOD', 'BroadCastEventsCommandAnnounce', 'hlx_sm_csay'),
('', 'PlayerEventsAdminCommand', ''),
('AMXX', 'PlayerEventsAdminCommand', 'amx_chat'),
('BEETLE', 'PlayerEventsAdminCommand', 'admin_chat'),
('MANI', 'PlayerEventsAdminCommand', 'ma_chat'),
('MINISTATS', 'PlayerEventsAdminCommand', ''),
('SOURCEMOD', 'PlayerEventsAdminCommand', 'sm_chat'),
('', 'PlayerEventsCommand', ''),
('AMXX', 'PlayerEventsCommand', 'hlx_amx_psay'),
('BEETLE', 'PlayerEventsCommand', 'hlx_psay'),
('MANI', 'PlayerEventsCommand', 'ma_hlx_psay'),
('MINISTATS', 'PlayerEventsCommand', 'ms_psay'),
('SOURCEMOD', 'PlayerEventsCommand', 'hlx_sm_psay'),
('', 'PlayerEventsCommandOSD', ''),
('AMXX', 'PlayerEventsCommandOSD', 'hlx_amx_msay'),
('BEETLE', 'PlayerEventsCommandOSD', 'hlx_msay'),
('MANI', 'PlayerEventsCommandOSD', 'ma_hlx_msay'),
('MINISTATS', 'PlayerEventsCommandOSD', 'ms_msay'),
('SOURCEMOD', 'PlayerEventsCommandOSD', 'hlx_sm_msay'),
('', 'PlayerEventsCommandHint', ''),
('AMXX', 'PlayerEventsCommandHint', 'hlx_amx_hint'),
('BEETLE', 'PlayerEventsCommandHint', ''),
('MANI', 'PlayerEventsCommandHint', 'ma_hlx_hint'),
('MINISTATS', 'PlayerEventsCommandHint', ''),
('SOURCEMOD', 'PlayerEventsCommandHint', 'hlx_sm_hint');


CREATE TABLE IF NOT EXISTS `hlstats_Mods_Supported` (
  `code` varchar(32) NOT NULL,
  `name` varchar(128) NOT NULL,
  PRIMARY KEY  (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Mods_Supported`
--

INSERT INTO `hlstats_Mods_Supported` (`code`, `name`) VALUES
('', '(none)'),
('SOURCEMOD', 'Sourcemod'),
('MANI', 'Mani Admin Mod >= 1.2'),
('BEETLE', 'BeetlesMod'),
('MINISTATS', 'MiniStats'),
('AMXX', 'AMX Mod X');
-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Options`
--

CREATE TABLE IF NOT EXISTS `hlstats_Options` (
  `keyname` varchar(32) NOT NULL default '',
  `value` varchar(128) NOT NULL default '',
  `opttype` TINYINT NOT NULL DEFAULT '1',
  PRIMARY KEY  (`keyname`),
  INDEX ( `opttype` )
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Options`
--

INSERT INTO `hlstats_Options` (`keyname`, `value`, `opttype`) VALUES
('dbversion', @DBVERSION, 2),
('version', @VERSION, 1),
('DNSResolveIP', '1',0),
('DNSTimeout', '3',0),
('Rcon', '1',0),
('RconIgnoreSelf', '1',0),
('RconRecord', '0',0),
('MailTo', '',0),
('MailPath', '/usr/sbin/sendmail',0),
('Mode', 'Normal',1),
('SkillMaxChange', '25',0),
('SkillMinChange', '2',0),
('PlayerMinKills', '50',0),
('DeleteDays', '28',1),
('UseTimestamp', '0',0),
('MinActivity', '28',2),
('AllowOnlyConfigServers', '1',0),
('TrackStatsTrend', '1',0),
('GlobalBanning', '0',0),
('LogChat', '1',0),
('LogChatAdmins', '0',0),
('GlobalChat', '0',0),
('SkillRatioCap', '0',0),
('UseGeoIPBinary', '1',0),
('contact', 'your@email.address',2),
('sitename', 'HLstatsX Community Edition',2),
('siteurl', 'http://www.yoursite.com/stats/',2),
('style', 'sourcebans.css',2),
('imgpath', 'hlstatsimg',2),
('map_dlurl', 'http://www.yoursite.com/fastdownload/%GAME%/%MAP%.bsp.bz2',2),
('awards_d_date', '2008-08-30',2),
('awards_numdays', '1',2),
('graphbg_trend', '282828',2),
('graphbg_load', '282828',2),
('graphtxt_trend', 'FFFFFF',2),
('graphtxt_load', 'FFFFFF',2),
('rankingtype', 'skill',1),
('bannerfile', 'hlxcebanner.jpg',2),
('bannerdisplay', '0',2),
('awarddailycols', '5',2),
('awardglobalcols', '5',2),
('awardrankscols', '5',2),
('awardribbonscols', '5',2),
('sigbackground', 'random',2),
('playerinfo_tabs', '1',2),
('counter_hits', '0',2),
('counter_visits', '0',2),
('counter_visit_timeout', '5',2),
('nav_globalchat', '1',2),
('nav_cheaters', '0',2),
('show_weapon_target_flash', '1',2),
('show_server_load_image', '1',2),
('countrydata', '1',2),
('gamehome_show_awards', '0',2),
('show_google_map', '1',2),
('google_map_region', 'NORTH AMERICA',2),
('google_map_type', 'HYBRID',2),
('slider', '1',2),
('modrewrite','0',2),
('showqueries','0',2),
('Proxy_Key', SUBSTRING(MD5(RAND()) FROM 1 FOR 24), 1),
('Proxy_Daemons', '', 2),
('sourcebans_address', '', 2),
('forum_address', '', 2),
('display_gamelist', '1', 2),
('display_style_selector', '0', 2);


CREATE TABLE IF NOT EXISTS `hlstats_Options_Choices` (
  `keyname` varchar(32) NOT NULL,
  `value` varchar(128) NOT NULL,
  `text` varchar(128) NOT NULL default '',
  `isDefault` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`keyname`,`value`),
  KEY `keyname` (`keyname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


INSERT INTO `hlstats_Options_Choices` (`keyname`, `value`, `text`, `isDefault`) VALUES
('rankingtype', 'skill', 'Skill', 1),
('rankingtype', 'kills', 'Kills', 0),
('bannerdisplay', '0', 'None', 1),
('bannerdisplay', '1', 'All Pages', 0),
('bannerdisplay', '2', 'Contents Page Only', 0),
('playerinfo_tabs', '1', 'New Style (hide sections by default)', 1),
('playerinfo_tabs', '0', 'Old Style (show all at once)', 0),
('nav_globalchat', '1', 'Show', 1),
('nav_globalchat', '0', 'Hide', 0),
('nav_cheaters', '0', 'Hide', 1),
('nav_cheaters', '1', 'Show', 0),
('show_weapon_target_flash', '1', 'Flash hitbox', 1),
('show_weapon_target_flash', '0', 'HTML Table', 0),
('show_server_load_image', '1', 'Show', 0),
('show_server_load_image', '0', 'Hide', 1),
('countrydata', '1', 'Show', 1),
('countrydata', '0', 'Hide', 0),
('gamehome_show_awards', '1', 'Show', 0),
('gamehome_show_awards', '0', 'Hide', 1),
('show_google_map', '0', 'Hide', 0),
('show_google_map', '1', 'Show', 1),
('google_map_region', 'EUROPE', 'Europe', 0),
('google_map_region', 'NORTH AMERICA', 'North America', 1),
('google_map_region', 'SOUTH AMERICA', 'South America', 0),
('google_map_region', 'NORTH AFRICA', 'North Africa', 0),
('google_map_region', 'SOUTH AFRICA', 'South Africa', 0),
('google_map_region', 'NORTH EUROPE', 'North Europe', 0),
('google_map_region', 'EAST EUROPE', 'East Europe', 0),
('google_map_region', 'GERMANY', 'Germany', 0),
('google_map_region', 'FRANCE', 'France', 0),
('google_map_region', 'SPAIN', 'Spain', 0),
('google_map_region', 'UNITED KINGDOM', 'United Kingdom', 0),
('google_map_region', 'DENMARK', 'Denmark', 0),
('google_map_region', 'SWEDEN', 'Sweden', 0),
('google_map_region', 'NORWAY', 'Norway', 0),
('google_map_region', 'FINLAND', 'Finland', 0),
('google_map_region', 'NETHERLANDS', 'Netherlands', 0),
('google_map_region', 'BELGIUM', 'Belgium', 0),
('google_map_region', 'POLAND', 'Poland', 0),
('google_map_region', 'SUISSE', 'Suisse', 0),
('google_map_region', 'AUSTRIA', 'Austria', 0),
('google_map_region', 'ITALY', 'Italy', 0),
('google_map_region', 'TURKEY', 'Turkey', 0),
('google_map_region', 'ROMANIA', 'Romania', 0),
('google_map_region', 'BRAZIL', 'Brazil', 0),
('google_map_region', 'ARGENTINA', 'Argentina', 0),
('google_map_region', 'RUSSIA', 'Russia', 0),
('google_map_region', 'ASIA', 'Asia', 0),
('google_map_region', 'CHINA', 'China', 0),
('google_map_region', 'JAPAN', 'Japan', 0),
('google_map_region', 'TAIWAN', 'Taiwan', 0),
('google_map_region', 'SOUTH KOREA', 'South Korea', 0),
('google_map_region', 'AUSTRALIA', 'Australia', 0),
('google_map_region', 'WORLD', 'World', 0),
('google_map_type', 'HYBRID', 'Hybrid', 1),
('google_map_type', 'SATELLITE', 'Satellite', 0),
('google_map_type', 'MAP', 'Normal', 0),
('google_map_type', 'PHYSICAL', 'Physical', 0),
('slider', '1', 'Enabled', 1),
('slider', '0', 'Disabled', 0),
('modrewrite', '1', 'Enabled', 0),
('modrewrite', '0', 'Disabled', 1),
('DNSResolveIP', '1', 'Yes', 1),
('DNSResolveIP', '0', 'No', 0),
('Rcon', '1', 'Yes', 1),
('Rcon', '0', 'No', 0),
('RconIgnoreSelf', '0', 'No', 1),
('RconIgnoreSelf', '1', 'Yes', 0),
('RconRecord', '0', 'No', 1),
('RconRecord', '1', 'Yes', 0),
('Mode', 'Normal', 'Steam ID (recommended)', 1),
('Mode', 'NameTrack', 'Player Name', 0),
('Mode', 'LAN', 'IP Address', 0),
('UseTimestamp', '0', 'No', 1),
('UseTimestamp', '1', 'Yes', 0),
('AllowOnlyConfigServers', '0', 'No', 0),
('AllowOnlyConfigServers', '1', 'Yes', 1),
('TrackStatsTrend', '0', 'No', 0),
('TrackStatsTrend', '1', 'Yes', 1),
('GlobalBanning', '0', 'No', 1),
('GlobalBanning', '1', 'Yes', 0),
('LogChat', '0', 'No', 0),
('LogChat', '1', 'Yes', 1),
('LogChatAdmins', '0', 'No', 0),
('LogChatAdmins', '1', 'Yes', 1),
('GlobalChat', '0', 'None', 1),
('GlobalChat', '1', 'Broadcast to all', 0),
('GlobalChat', '2', 'Broadcast to admins', 0),
('SkillRatioCap', '0', 'No', 1),
('SkillRatioCap', '1', 'Yes', 0),
('UseGeoIPBinary', '0', 'GeoIP lookup via database', 1),
('UseGeoIPBinary', '1', 'GeoIP lookup via binary file', 0),
('showqueries', '0', 'No', 1),
('showqueries', '1', 'Yes', 0),
('display_gamelist', '1', 'Yes', 1),
('display_gamelist', '0', 'No', 0),
('display_style_selector', '1', 'Yes', 0),
('display_style_selector', '0', 'No', 1);
-- --------------------------------------------------------

--
-- Table structure for table `hlstats_PlayerNames`
--

CREATE TABLE IF NOT EXISTS `hlstats_PlayerNames` (
  `playerId` int(10) unsigned NOT NULL default '0',
  `name` varchar(64) NOT NULL default '',
  `lastuse` datetime NOT NULL default '0000-00-00 00:00:00',
  `connection_time` int(11) unsigned NOT NULL default '0',
  `numuses` int(10) unsigned NOT NULL default '0',
  `kills` int(11) unsigned NOT NULL default '0',
  `deaths` int(11) unsigned NOT NULL default '0',
  `suicides` int(11) unsigned NOT NULL default '0',
  `headshots` int(11) unsigned NOT NULL default '0',
  `shots` int(11) unsigned NOT NULL default '0',
  `hits` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`playerId`,`name`),
  KEY `name16` (`name`(16))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `hlstats_Players`
--

CREATE TABLE IF NOT EXISTS `hlstats_Players` (
  `playerId` int(10) unsigned NOT NULL auto_increment,
  `last_event` int(11) NOT NULL default '0',
  `connection_time` int(11) unsigned NOT NULL default '0',
  `lastName` varchar(64) NOT NULL default '',
  `lastAddress` varchar(32) NOT NULL default '',
  `city` varchar(64) NOT NULL default '',
  `state` varchar(64) NOT NULL default '',
  `country` varchar(64) NOT NULL default '',
  `flag` varchar(16) NOT NULL default '',
  `lat` FLOAT(7,4) NULL,
  `lng` FLOAT(7,4) NULL,
  `clan` int(10) unsigned NOT NULL default '0',
  `kills` int(11) unsigned NOT NULL default '0',
  `deaths` int(11) unsigned NOT NULL default '0',
  `suicides` int(11) unsigned NOT NULL default '0',
  `skill` int(11) unsigned NOT NULL default '1000',
  `shots` int(11) unsigned NOT NULL default '0',
  `hits` int(11) unsigned NOT NULL default '0',
  `teamkills` int(11) unsigned NOT NULL default '0',
  `fullName` varchar(128) default NULL,
  `email` varchar(64) default NULL,
  `homepage` varchar(64) default NULL,
  `icq` int(10) unsigned default NULL,
  `game` varchar(32) NOT NULL,
  `hideranking` int(1) unsigned NOT NULL default '0',
  `headshots` int(10) unsigned NOT NULL default '0',
  `last_skill_change` int(11) NOT NULL default '0',
  `displayEvents` int(1) unsigned NOT NULL default '1',
  `kill_streak` int(6) NOT NULL default '0',
  `death_streak` int(6) NOT NULL default '0',
  `blockavatar` int(1) unsigned NOT NULL default '0',
  `activity` int(11) NOT NULL default '100',
  `createdate` int(11) NOT NULL default'0',
  PRIMARY KEY  (`playerId`),
  KEY `playerclan` (`clan`,`playerId`),
  KEY `skill` (`skill`),
  KEY `game` (`game`),
  KEY `kills` (`kills`),
  KEY `hideranking` (`hideranking`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Players_Awards`
--

CREATE TABLE IF NOT EXISTS `hlstats_Players_Awards` (
  `awardTime` date NOT NULL,
  `awardId` int(11) unsigned NOT NULL default '0',
  `playerId` int(11) unsigned NOT NULL default '0',
  `count` int(11) unsigned NOT NULL default '0',
  `game` varchar(32) NOT NULL,
  PRIMARY KEY  (`awardTime`,`awardId`,`playerId`,`game`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Players_History`
--

CREATE TABLE IF NOT EXISTS `hlstats_Players_History` (
  `playerId` int(10) unsigned NOT NULL default '0',
  `eventTime` date NOT NULL default '0000-00-00',
  `connection_time` int(10) unsigned NOT NULL default '0',
  `kills` int(11) unsigned NOT NULL default '0',
  `deaths` int(11) unsigned NOT NULL default '0',
  `suicides` int(11) unsigned NOT NULL default '0',
  `skill` int(11) unsigned NOT NULL default '1000',
  `shots` int(11) unsigned NOT NULL default '0',
  `hits` int(11) unsigned NOT NULL default '0',
  `game` varchar(32) NOT NULL default '',
  `headshots` int(11) unsigned NOT NULL default '0',
  `teamkills` int(11) unsigned NOT NULL default '0',
  `kill_streak` int(6) NOT NULL default '0',
  `death_streak` int(6) NOT NULL default '0',
  `skill_change` int(11) NOT NULL default '0',
  UNIQUE KEY `eventTime` (`eventTime`,`playerId`,`game`),
  KEY `playerId` (`playerId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Players_Ribbons`
--

CREATE TABLE IF NOT EXISTS `hlstats_Players_Ribbons` (
  `playerId` int(11) unsigned NOT NULL default '0',
  `ribbonId` int(11) unsigned NOT NULL default '0',
  `game` varchar(32) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_PlayerUniqueIds`
--

CREATE TABLE IF NOT EXISTS `hlstats_PlayerUniqueIds` (
  `playerId` int(10) unsigned NOT NULL default '0',
  `uniqueId` varchar(64) NOT NULL default '',
  `game` varchar(32) NOT NULL default '',
  `merge` int(10) unsigned default NULL,
  PRIMARY KEY  (`uniqueId`,`game`),
  KEY `playerId` (`playerId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Ranks`
--

CREATE TABLE IF NOT EXISTS `hlstats_Ranks` (
  `rankId` int(11) unsigned NOT NULL auto_increment,
  `image` varchar(30) NOT NULL,
  `minKills` int(11) unsigned NOT NULL default '0',
  `maxKills` int(11) NOT NULL default '0',
  `rankName` varchar(50) NOT NULL,
  `game` varchar(32) NOT NULL,
  PRIMARY KEY  (`rankId`),
  UNIQUE KEY `rankgame` (`image`,`game`),
  KEY `game` (`game`(8))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `hlstats_Ranks`
--

INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'recruit', 0, 49, 'Recruit' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'private', 50, 99, 'Private' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'private-first-class', 100, 199, 'Private First Class' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'lance-corporal', 200, 299, 'Lance Corporal' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'corporal', 300, 399, 'Corporal' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'sergeant', 400, 499, 'Sergeant' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'staff-sergeant', 500, 599, 'Staff Sergeant' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'gunnery-sergeant', 600, 699, 'Gunnery Sergeant' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'master-sergeant', 700, 799, 'Master Sergeant' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'first-sergeant', 800, 899, 'First Sergeant' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'master-chief', 900, 999, 'Master Chief' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'sergeant-major', 1000, 1199, 'Sergeant Major' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'ensign', 1200, 1399, 'Ensign' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'third-lieutenant', 1400, 1599, 'Third Lieutenant' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'second-lieutenant', 1600, 1799, 'Second Lieutenant' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'first-lieutenant', 1800, 1999, 'First Lieutenant' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'captain', 2000, 2249, 'Captain' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'group-captain', 2250, 2499, 'Group Captain' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'senior-captain', 2500, 2749, 'Senior Captain' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'lieutenant-major', 2750, 2999, 'Lieutenant Major' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'major', 3000, 3499, 'Major' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'group-major', 3500, 3999, 'Group Major' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'lieutenant-commander', 4000, 4499, 'Lieutenant Commander' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'commander', 4500, 4999, 'Commander' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'group-commander', 5000, 5749, 'Group Commander' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'lieutenant-colonel', 5750, 6499, 'Lieutenant Colonel' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'colonel', 6500, 7249, 'Colonel' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'brigadier', 7250, 7999, 'Brigadier' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'brigadier-general', 8000, 8999, 'Brigadier General' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'major-general', 9000, 9999, 'Major General' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'lieutenant-general', 10000, 12499, 'Lieutenant General' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'general', 12500, 14999, 'General' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'commander-general', 15000, 17499, 'Commander General' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'field-vice-marshal', 17500, 19999, 'Field Vice Marshal' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'field-marshal', 20000, 22499, 'Field Marshal' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'vice-commander-of-the-army', 22500, 24999, 'Vice Commander of the Army' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'commander-of-the-army', 25000, 27499, 'Commander of the Army' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'high-commander', 27500, 29999, 'High Commander' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'supreme-commander', 30000, 34999, 'Supreme Commander' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'terminator', 35000, 9999999, 'Terminator' FROM `hlstats_Games`);

DELETE FROM `hlstats_Ranks` WHERE `game` = 'nd';
OPTIMIZE TABLE `hlstats_Ranks`;

INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`) VALUES
('nd', 'nd_01', 0, 40, 'Survivor'),
('nd', 'nd_02', 41, 131, 'Private I'),
('nd', 'nd_03', 132, 272, 'Private II'),
('nd', 'nd_04', 273, 483, 'Private III'),
('nd', 'nd_05', 484, 764, 'Private First Class I'),
('nd', 'nd_06', 765, 1125, 'Private First Class II'),
('nd', 'nd_07', 1126, 1576, 'Private First Class III'),
('nd', 'nd_08', 1577, 2117, 'Lance Corporal I'),
('nd', 'nd_09', 2118, 2768, 'Lance Corporal II'),
('nd', 'nd_10', 2769, 3529, 'Lance Corporal III'),
('nd', 'nd_11', 3530, 4410, 'Corporal I'),
('nd', 'nd_12', 4411, 5421, 'Corporal II'),
('nd', 'nd_13', 5422, 6562, 'Corporal III'),
('nd', 'nd_14', 6563, 7853, 'Sergeant I'),
('nd', 'nd_15', 7854, 9294, 'Sergeant II'),
('nd', 'nd_16', 9295, 10895, 'Sergeant III'),
('nd', 'nd_17', 10896, 12666, 'Staff Sergeant I'),
('nd', 'nd_18', 12667, 14607, 'Staff Sergeant II'),
('nd', 'nd_19', 14608, 16738, 'Staff Sergeant III'),
('nd', 'nd_20', 16739, 19059, 'Gunnery Sergeant I'),
('nd', 'nd_21', 19060, 21580, 'Gunnery Sergeant II'),
('nd', 'nd_22', 21581, 24311, 'Gunnery Sergeant III'),
('nd', 'nd_23', 24312, 27252, 'Master Sergeant I'),
('nd', 'nd_24', 27253, 30423, 'Master Sergeant II'),
('nd', 'nd_25', 30424, 33824, 'Master Sergeant III'),
('nd', 'nd_26', 33825, 37465, 'First Sergeant I'),
('nd', 'nd_27', 37466, 41356, 'First Sergeant II'),
('nd', 'nd_28', 41357, 45497, 'First Sergeant III'),
('nd', 'nd_29', 45498, 49928, 'Master Gunnery Sergeant I'),
('nd', 'nd_30', 49929, 54669, 'Master Gunnery Sergeant II'),
('nd', 'nd_31', 54670, 59750, 'Master Gunnery Sergeant III'),
('nd', 'nd_32', 59751, 65201, 'Sergeant Major I'),
('nd', 'nd_33', 65202, 71062, 'Sergeant Major II'),
('nd', 'nd_34', 71063, 77343, 'Sergeant Major III'),
('nd', 'nd_35', 77344, 84054, 'Elite Sergeant Major'),
('nd', 'nd_36', 84055, 91215, 'Field Lieutenant'),
('nd', 'nd_37', 91216, 98826, 'Second Lieutenant'),
('nd', 'nd_38', 98827, 106907, 'First Lieutenant'),
('nd', 'nd_39', 106908, 115478, 'Field Captain'),
('nd', 'nd_40', 115479, 124549, 'Captain'),
('nd', 'nd_41', 124550, 134130, 'Vanguard Captain'),
('nd', 'nd_42', 134131, 144231, 'Field Major'),
('nd', 'nd_43', 144232, 154862, 'Major'),
('nd', 'nd_44', 154863, 166043, 'Lieutenant Colonel'),
('nd', 'nd_45', 166044, 177794, 'Colonel'),
('nd', 'nd_46', 177795, 190115, 'Vanguard Colonel'),
('nd', 'nd_47', 190116, 203026, 'Commander'),
('nd', 'nd_48', 203027, 216537, 'Vanguard Commander'),
('nd', 'nd_49', 216538, 230658, 'Elite Commander'),
('nd', 'nd_50', 230659, 245409, 'Brigadier General Third Class'),
('nd', 'nd_51', 245410, 260800, 'Brigadier General Second Class'),
('nd', 'nd_52', 260801, 276841, 'Brigadier General First Class'),
('nd', 'nd_53', 276842, 293552, 'Major General Third Class'),
('nd', 'nd_54', 293553, 310943, 'Major General Second Class'),
('nd', 'nd_55', 310944, 329024, 'Major General First Class'),
('nd', 'nd_56', 329025, 347815, 'Lieutenant General Third Class'),
('nd', 'nd_57', 347816, 367316, 'Lieutenant General Second Class'),
('nd', 'nd_58', 367317, 387547, 'Lieutenant General First Class'),
('nd', 'nd_59', 387548, 408528, 'General'),
('nd', 'nd_60', 408529, 9999999, 'Vanguard General');


-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Ribbons`
--

CREATE TABLE IF NOT EXISTS `hlstats_Ribbons` (
  `ribbonId` int(11) unsigned NOT NULL auto_increment,
  `awardCode` varchar(50) NOT NULL,
  `awardCount` int(11) NOT NULL default '0',
  `special` tinyint(3) NOT NULL default '0',
  `game` varchar(32) NOT NULL,
  `image` varchar(50) NOT NULL,
  `ribbonName` varchar(50) NOT NULL,
  PRIMARY KEY  (`ribbonId`),
  UNIQUE KEY `award` (`awardCode`,`awardCount`,`game`, `special`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Ribbons`
--

INSERT INTO `hlstats_Ribbons` (`awardCode`, `awardCount`, `special`, `game`, `image`, `ribbonName`) VALUES
('*Headshots*',2500,1,'css','ribbon_of_silver_star.gif','Sharpshooter'),
('*total connection hours*',25,2,'css','1_connect.png','Connection Time 25 Hours'),
('*total connection hours*',50,2,'css','2_connect.png','Connection Time 50 Hours'),
('*total connection hours*',75,2,'css','3_connect.png','Connection Time 75 Hours'),
('*total connection hours*',100,2,'css','4_connect.png','Connection Time 100 Hours'),
('*total connection hours*',125,2,'css','5_connect.png','Connection Time 125 Hours'),
('*total connection hours*',150,2,'css','6_connect.png','Connection Time 150 Hours'),
('*total connection hours*',168,2,'hl2mp','1waward.png','Connection Time 1 Week '),
('crowbar',3,0,'hl2mp','1_crowbaraward.png','Award of Crowbar'),
('crossbow_bolt',3,0,'hl2mp','1_crossbow_boltaward.png','Award of Xbow'),
('combine_ball',3,0,'hl2mp','1_combine_ballaward.png','Award of Combine Ball'),
('ar2',3,0,'hl2mp','1_ar2award.png','Award of AR2'),
('357',3,0,'hl2mp','1_357award.png','Award of 357'),
('*total connection hours*',336,2,'hl2mp','2waward.png','Connection Time 2 Weeks '),
('grenade_frag',3,0,'hl2mp','1_grenade_fragaward.png','Award of Grenade'),
('physbox',3,0,'hl2mp','1_physboxaward.png','Award of Physbox'),
('physics',3,0,'hl2mp','1_physicsaward.png','Award of Physics'),
('pistol',3,0,'hl2mp','1_pistolaward.png','Award of Pistol'),
('rpg_missile',3,0,'hl2mp','1_rpg_missileaward.png','Award of RPG'),
('shotgun',3,0,'hl2mp','1_shotgunaward.png','Award of Shotgun'),
('slam',3,0,'hl2mp','1_slamaward.png','Award of Slam'),
('smg1_grenade',3,0,'hl2mp','1_smg1_grenadeaward.png','Award of SMG Grenade'),
('smg1',3,0,'hl2mp','1_smg1award.png','Award of SMG'),
('stunstick',3,0,'hl2mp','1_stunstickaward.png','Award of Stunstick'),
('latency',3,0,'hl2mp','1_latency.png','Award of Lowpinger'),
('mostkills',3,0,'hl2mp','1_mostkills.png','Award of Most Kills'),
('suicide',3,0,'hl2mp','1_suicide.png','Award of Most Suicides'),
('headshot',3,0,'hl2mp','1_headshotaward.png','Award of Most Headshots'),
('357',7,0,'hl2mp','2_357award.png','Bronze 357'),
('ar2',7,0,'hl2mp','2_ar2award.png','Bronze AR2'),
('combine_ball',7,0,'hl2mp','2_combine_ballaward.png','Bronze Combine Ball'),
('crowbar',7,0,'hl2mp','2_crowbaraward.png','Bronze Crowbar'),
('grenade_frag',7,0,'hl2mp','2_grenade_fragaward.png','Bronze Grenade'),
('physbox',7,0,'hl2mp','2_physboxaward.png','Bronze Physbox'),
('physics',7,0,'hl2mp','2_physicsaward.png','Bronze Physics'),
('pistol',7,0,'hl2mp','2_pistolaward.png','Bronze Pistol'),
('rpg_missile',7,0,'hl2mp','2_rpg_missileaward.png','Bronze RPG'),
('shotgun',7,0,'hl2mp','2_shotgunaward.png','Bronze Shotgun'),
('slam',7,0,'hl2mp','2_slamaward.png','Bronze Slam'),
('smg1',7,0,'hl2mp','2_smg1award.png','Bronze SMG'),
('smg1_grenade',7,0,'hl2mp','2_smg1_grenadeaward.png','Bronze SMG Grenade'),
('stunstick',7,0,'hl2mp','2_stunstickaward.png','Bronze Stunstick'),
('crossbow_bolt',7,0,'hl2mp','2_crossbow_boltaward.png','Bronze Xbow'),
('latency',7,0,'hl2mp','2_latency.png','Bronze Lowpinger'),
('mostkills',7,0,'hl2mp','2_mostkills.png','Most Kills - Bronze'),
('suicide',7,0,'hl2mp','2_suicide.png','Most Suicides - Bronze'),
('headshot',7,0,'hl2mp','2_headshotaward.png','Most Headshots - Bronze'),
('ar2',12,0,'hl2mp','3_ar2award.png','Silver AR2'),
('357',12,0,'hl2mp','3_357award.png','Silver 357'),
('combine_ball',12,0,'hl2mp','3_combine_ballaward.png','Silver Combine Ball'),
('crossbow_bolt',12,0,'hl2mp','3_crossbow_boltaward.png','Silver Xbow'),
('crowbar',12,0,'hl2mp','3_crowbaraward.png','Silver Crowbar'),
('grenade_frag',12,0,'hl2mp','3_grenade_fragaward.png','Silver Grenade'),
('physbox',12,0,'hl2mp','3_physboxaward.png','Silver Physbox'),
('physics',12,0,'hl2mp','3_physicsaward.png','Silver Physics'),
('pistol',12,0,'hl2mp','3_pistolaward.png','Silver Pistol'),
('rpg_missile',12,0,'hl2mp','3_rpg_missileaward.png','Silver RPG'),
('shotgun',12,0,'hl2mp','3_shotgunaward.png','Silver Shotgun'),
('slam',12,0,'hl2mp','3_slamaward.png','Silver Slam'),
('smg1_grenade',12,0,'hl2mp','3_smg1_grenadeaward.png','Silver SMG Grenade'),
('smg1',12,0,'hl2mp','3_smg1award.png','Silver SMG'),
('stunstick',12,0,'hl2mp','3_stunstickaward.png','Silver Stunstick'),
('latency',12,0,'hl2mp','3_latency.png','Silver Lowpinger'),
('mostkills',12,0,'hl2mp','3_mostkills.png','Most Kills - Silver'),
('suicide',12,0,'hl2mp','3_suicide.png','Most Suicdes - Silver'),
('headshot',12,0,'hl2mp','3_headshotaward.png','Most Headshots - Silver'),
('357',17,0,'hl2mp','x_357supreme.png','Supreme 357'),
('ar2',17,0,'hl2mp','x_ar2supreme.png','Supreme AR2'),
('combine_ball',17,0,'hl2mp','x_combine_ballsupreme.png','Supreme Combine Ball'),
('crossbow_bolt',17,0,'hl2mp','x_crossbow_boltsupreme.png','Supreme Xbow'),
('crowbar',17,0,'hl2mp','x_crowbarsupreme.png','Supreme Crowbar'),
('grenade_frag',17,0,'hl2mp','x_grenade_fragsupreme.png','Supreme Grenade'),
('physbox',17,0,'hl2mp','x_physboxsupreme.png','Supreme Physbox'),
('physics',17,0,'hl2mp','x_physicssupreme.png','Supreme Physics'),
('pistol',17,0,'hl2mp','x_pistolsupreme.png','Supreme Pistol'),
('rpg_missile',17,0,'hl2mp','x_rpg_missilesupreme.png','Supreme RPG'),
('shotgun',17,0,'hl2mp','x_shotgunsupreme.png','Supreme Shotgun'),
('slam',17,0,'hl2mp','x_slamsupreme.png','Supreme Slam'),
('smg1_grenade',17,0,'hl2mp','x_smg1_grenadesupreme.png','Supreme SMG Grenade'),
('smg1',17,0,'hl2mp','x_smg1supreme.png','Supreme SMG'),
('stunstick',17,0,'hl2mp','x_stunsticksupreme.png','Supreme Stunstick'),
('headshot',17,0,'hl2mp','x_headshotaward.png','Supreme Headshotter'),
('*total connection hours*',504,2,'hl2mp','3waward.png','Connection Time 3 Weeks '),
('*total connection hours*',672,2,'hl2mp','x_swaward.png','Connection Time - Supreme'),
('latency',17,0,'hl2mp','x_latency.png','Supreme Lowpinger'),
('mostkills',17,0,'hl2mp','x_mostkills.png','Most Kills - Supreme'),
('suicide',17,0,'hl2mp','x_suicide.png','Most Suicides - Supreme'),
('ak47', 1, 0, 'css', '1_ak47.png', 'Award of AK47'),
('awp', 1, 0, 'css', '1_awp.png', 'Award of AWP Sniper'),
('deagle', 1, 0, 'css', '1_deagle.png', 'Award of Desert Eagle'),
('elite', 1, 0, 'css', '1_elite.png', 'Award of Dual Beretta Elites'),
('glock', 1, 0, 'css', '1_glock.png', 'Award of Glock'),
('hegrenade', 1, 0, 'css', '1_hegrenade.png', 'Award of HE Grenades'),
('knife', 1, 0, 'css', '1_knife.png', 'Award of Combat Knife'),
('p90', 1, 0, 'css', '1_p90.png', 'Award of P90'),
('scout', 1, 0, 'css', '1_scout.png', 'Award of Scout Elite'),
('usp', 1, 0, 'css', '1_usp.png', 'Award of USP'),
('aug', 1, 0, 'css', '1_aug.png', 'Award of Steyr Aug'),
('fiveseven', 1, 0, 'css', '1_fiveseven.png', 'Award of Five-Seven'),
('g3sg1', 1, 0, 'css', '1_g3sg1.png', 'Award of G3 SG1'),
('m3', 1, 0, 'css', '1_m3.png', 'Award of M3 Shotgun'),
('m4a1', 1, 0, 'css', '1_m4a1.png', 'Award of Colt M4A1'),
('mac10', 1, 0, 'css', '1_mac10.png', 'Award of MAC 10'),
('mp5navy', 1, 0, 'css', '1_mp5navy.png', 'Award of MP5 Navy'),
('m249', 1, 0, 'css', '1_m249.png', 'Award of M249 Para'),
('sg550', 1, 0, 'css', '1_sg550.png', 'Award of SG 550'),
('sg552', 1, 0, 'css', '1_sg552.png', 'Award of SG 552'),
('p228', 1, 0, 'css', '1_p228.png', 'Award of Sig P228'),
('tmp', 1, 0, 'css', '1_tmp.png', 'Award of TMP'),
('ump45', 1, 0, 'css', '1_ump45.png', 'Award of UMP 45'),
('xm1014', 1, 0, 'css', '1_xm1014.png', 'Award of XM Shotgun'),
('galil', 1, 0, 'css', '1_galil.png', 'Award of Galil'),
('ak47', 5, 0, 'css', '2_ak47.png', 'Bronze AK47'),
('awp', 5, 0, 'css', '2_awp.png', 'Bronze AWP Sniper'),
('deagle', 5, 0, 'css', '2_deagle.png', 'Bronze Desert Eagle'),
('elite', 5, 0, 'css', '2_elite.png', 'Bronze Dual Beretta Elites'),
('glock', 5, 0, 'css', '2_glock.png', 'Bronze Glock'),
('hegrenade', 5, 0, 'css', '2_hegrenade.png', 'Bronze HE Grenades'),
('knife', 5, 0, 'css', '2_knife.png', 'Bronze Combat Knife'),
('p90', 5, 0, 'css', '2_p90.png', 'Bronze P90'),
('scout', 5, 0, 'css', '2_scout.png', 'Bronze Scout Elite'),
('usp', 5, 0, 'css', '2_usp.png', 'Bronze USP'),
('aug', 5, 0, 'css', '2_aug.png', 'Bronze Steyr Aug'),
('fiveseven', 5, 0, 'css', '2_fiveseven.png', 'Bronze Five-Seven'),
('g3sg1', 5, 0, 'css', '2_g3sg1.png', 'Bronze G3 SG1'),
('m3', 5, 0, 'css', '2_m3.png', 'Bronze M3 Shotgun'),
('m4a1', 5, 0, 'css', '2_m4a1.png', 'Bronze Colt M4A1'),
('mac10', 5, 0, 'css', '2_mac10.png', 'Bronze MAC 10'),
('mp5navy', 5, 0, 'css', '2_mp5navy.png', 'Bronze MP5 Navy'),
('m249', 5, 0, 'css', '2_m249.png', 'Bronze M249 Para'),
('sg550', 5, 0, 'css', '2_sg550.png', 'Bronze SG 550'),
('sg552', 5, 0, 'css', '2_sg552.png', 'Bronze SG 552'),
('p228', 5, 0, 'css', '2_p228.png', 'Bronze Sig P228'),
('tmp', 5, 0, 'css', '2_tmp.png', 'Bronze TMP'),
('ump45', 5, 0, 'css', '2_ump45.png', 'Bronze UMP 45'),
('xm1014', 5, 0, 'css', '2_xm1014.png', 'Bronze XM Shotgun'),
('galil', 5, 0, 'css', '2_galil.png', 'Bronze Galil'),
('ak47', 12, 0, 'css', '3_ak47.png', 'Silver AK47'),
('awp', 12, 0, 'css', '3_awp.png', 'Silver AWP Sniper'),
('deagle', 12, 0, 'css', '3_deagle.png', 'Silver Desert Eagle'),
('elite', 12, 0, 'css', '3_elite.png', 'Silver Dual Beretta Elites'),
('glock', 12, 0, 'css', '3_glock.png', 'Silver Glock'),
('hegrenade', 12, 0, 'css', '3_hegrenade.png', 'Silver HE Grenades'),
('knife', 12, 0, 'css', '3_knife.png', 'Silver Combat Knife'),
('p90', 12, 0, 'css', '3_p90.png', 'Silver P90'),
('scout', 12, 0, 'css', '3_scout.png', 'Silver Scout Elite'),
('usp', 12, 0, 'css', '3_usp.png', 'Silver USP'),
('aug', 12, 0, 'css', '3_aug.png', 'Silver Steyr Aug'),
('fiveseven', 12, 0, 'css', '3_fiveseven.png', 'Silver Five-Seven'),
('g3sg1', 12, 0, 'css', '3_g3sg1.png', 'Silver G3 SG1'),
('m3', 12, 0, 'css', '3_m3.png', 'Silver M3 Shotgun'),
('m4a1', 12, 0, 'css', '3_m4a1.png', 'Silver Colt M4A1'),
('mac10', 12, 0, 'css', '3_mac10.png', 'Silver MAC 10'),
('mp5navy', 12, 0, 'css', '3_mp5navy.png', 'Silver MP5 Navy'),
('m249', 12, 0, 'css', '3_m249.png', 'Silver M249 Para'),
('sg550', 12, 0, 'css', '3_sg550.png', 'Silver SG 550'),
('sg552', 12, 0, 'css', '3_sg552.png', 'Silver SG 552'),
('p228', 12, 0, 'css', '3_p228.png', 'Silver Sig P228'),
('tmp', 12, 0, 'css', '3_tmp.png', 'Silver TMP'),
('ump45', 12, 0, 'css', '3_ump45.png', 'Silver UMP 45'),
('xm1014', 12, 0, 'css', '3_xm1014.png', 'Silver XM Shotgun'),
('galil', 12, 0, 'css', '3_galil.png', 'Silver Galil'),
('ak47', 20, 0, 'css', '4_ak47.png', 'Gold AK47'),
('awp', 20, 0, 'css', '4_awp.png', 'Gold AWP Sniper'),
('deagle', 20, 0, 'css', '4_deagle.png', 'Gold Desert Eagle'),
('elite', 20, 0, 'css', '4_elite.png', 'Gold Dual Beretta Elites'),
('glock', 20, 0, 'css', '4_glock.png', 'Gold Glock'),
('hegrenade', 20, 0, 'css', '4_hegrenade.png', 'Gold HE Grenades'),
('knife', 20, 0, 'css', '4_knife.png', 'Gold Combat Knife'),
('p90', 20, 0, 'css', '4_p90.png', 'Gold P90'),
('scout', 20, 0, 'css', '4_scout.png', 'Gold Scout Elite'),
('usp', 20, 0, 'css', '4_usp.png', 'Gold USP'),
('aug', 20, 0, 'css', '4_aug.png', 'Gold Steyr Aug'),
('fiveseven', 20, 0, 'css', '4_fiveseven.png', 'Gold Five-Seven'),
('g3sg1', 20, 0, 'css', '4_g3sg1.png', 'Gold G3 SG1'),
('m3', 20, 0, 'css', '4_m3.png', 'Gold M3 Shotgun'),
('m4a1', 20, 0, 'css', '4_m4a1.png', 'Gold Colt M4A1'),
('mac10', 20, 0, 'css', '4_mac10.png', 'Gold MAC 10'),
('mp5navy', 20, 0, 'css', '4_mp5navy.png', 'Gold MP5 Navy'),
('m249', 20, 0, 'css', '4_m249.png', 'Gold M249 Para'),
('sg550', 20, 0, 'css', '4_sg550.png', 'Gold SG 550'),
('sg552', 20, 0, 'css', '4_sg552.png', 'Gold SG 552'),
('p228', 20, 0, 'css', '4_p228.png', 'Gold Sig P228'),
('tmp', 20, 0, 'css', '4_tmp.png', 'Gold TMP'),
('ump45', 20, 0, 'css', '4_ump45.png', 'Gold UMP 45'),
('xm1014', 20, 0, 'css', '4_xm1014.png', 'Gold XM Shotgun'),
('galil', 20, 0, 'css', '4_galil.png', 'Gold Galil'),
('ak47', 30, 0, 'css', '5_ak47.png', 'Platinum AK47'),
('awp', 30, 0, 'css', '5_awp.png', 'Platinum AWP Sniper'),
('deagle', 30, 0, 'css', '5_deagle.png', 'Platinum Desert Eagle'),
('elite', 30, 0, 'css', '5_elite.png', 'Platinum Dual Beretta Elites'),
('glock', 30, 0, 'css', '5_glock.png', 'Platinum Glock'),
('hegrenade', 30, 0, 'css', '5_hegrenade.png', 'Platinum HE Grenades'),
('knife', 30, 0, 'css', '5_knife.png', 'Platinum Combat Knife'),
('p90', 30, 0, 'css', '5_p90.png', 'Platinum P90'),
('scout', 30, 0, 'css', '5_scout.png', 'Platinum Scout Elite'),
('usp', 30, 0, 'css', '5_usp.png', 'Platinum USP'),
('aug', 30, 0, 'css', '5_aug.png', 'Platinum Steyr Aug'),
('fiveseven', 30, 0, 'css', '5_fiveseven.png', 'Platinum Five-Seven'),
('g3sg1', 30, 0, 'css', '5_g3sg1.png', 'Platinum G3 SG1'),
('m3', 30, 0, 'css', '5_m3.png', 'Platinum M3 Shotgun'),
('m4a1', 30, 0, 'css', '5_m4a1.png', 'Platinum Colt M4A1'),
('mac10', 30, 0, 'css', '5_mac10.png', 'Platinum MAC 10'),
('mp5navy', 30, 0, 'css', '5_mp5navy.png', 'Platinum MP5 Navy'),
('m249', 30, 0, 'css', '5_m249.png', 'Platinum M249 Para'),
('sg550', 30, 0, 'css', '5_sg550.png', 'Platinum SG 550'),
('sg552', 30, 0, 'css', '5_sg552.png', 'Platinum SG 552'),
('p228', 30, 0, 'css', '5_p228.png', 'Platinum Sig P228'),
('tmp', 30, 0, 'css', '5_tmp.png', 'Platinum TMP'),
('ump45', 30, 0, 'css', '5_ump45.png', 'Platinum UMP 45'),
('xm1014', 30, 0, 'css', '5_xm1014.png', 'Platinum XM Shotgun'),
('galil', 30, 0, 'css', '5_galil.png', 'Platinum Galil'),
('ak47', 50, 0, 'css', '6_ak47.png', 'Supreme AK47'),
('awp', 50, 0, 'css', '6_awp.png', 'Supreme AWP Sniper'),
('deagle', 50, 0, 'css', '6_deagle.png', 'Supreme Desert Eagle'),
('elite', 50, 0, 'css', '6_elite.png', 'Supreme Dual Beretta Elites'),
('glock', 50, 0, 'css', '6_glock.png', 'Supreme Glock'),
('hegrenade', 50, 0, 'css', '6_hegrenade.png', 'Supreme HE Grenades'),
('knife', 50, 0, 'css', '6_knife.png', 'Supreme Combat Knife'),
('p90', 50, 0, 'css', '6_p90.png', 'Supreme P90'),
('scout', 50, 0, 'css', '6_scout.png', 'Supreme Scout Elite'),
('usp', 50, 0, 'css', '6_usp.png', 'Supreme USP'),
('aug', 50, 0, 'css', '6_aug.png', 'Supreme Steyr Aug'),
('fiveseven', 50, 0, 'css', '6_fiveseven.png', 'Supreme Five-Seven'),
('g3sg1', 50, 0, 'css', '6_g3sg1.png', 'Supreme G3 SG1'),
('m3', 50, 0, 'css', '6_m3.png', 'Supreme M3 Shotgun'),
('m4a1', 50, 0, 'css', '6_m4a1.png', 'Supreme Colt M4A1'),
('mac10', 50, 0, 'css', '6_mac10.png', 'Supreme MAC 10'),
('mp5navy', 50, 0, 'css', '6_mp5navy.png', 'Supreme MP5 Navy'),
('m249', 50, 0, 'css', '6_m249.png', 'Supreme M249 Para'),
('sg550', 50, 0, 'css', '6_sg550.png', 'Supreme SG 550'),
('sg552', 50, 0, 'css', '6_sg552.png', 'Supreme SG 552'),
('p228', 50, 0, 'css', '6_p228.png', 'Supreme Sig P228'),
('tmp', 50, 0, 'css', '6_tmp.png', 'Supreme TMP'),
('ump45', 50, 0, 'css', '6_ump45.png', 'Supreme UMP 45'),
('xm1014', 50, 0, 'css', '6_xm1014.png', 'Supreme XM Shotgun'),
('galil', 50, 0, 'css', '6_galil.png', 'Supreme Galil'),
('Defused_The_Bomb', 1, 0, 'css', '1_defused_the_bomb.png', 'Award of Bomb Defuser'),
('Planted_The_Bomb', 1, 0, 'css', '1_planted_the_bomb.png', 'Award of Bomb Planter'),
('Rescued_A_Hostage', 1, 0, 'css', '1_rescued_a_hostage.png', 'Award of Hostage Rescuer'),
('Killed_A_Hostage', 1, 0, 'css', '1_killed_a_hostage.png', 'Award of Hostage Killer'),
('latency', 1, 0, 'css', '1_latency.png', 'Award of Lowpinger'),
('headshot', 1, 0, 'css', '1_headshot.png', 'Award of Headshots'),
('Defused_The_Bomb', 5, 0, 'css', '2_defused_the_bomb.png', 'Bronze Bomb Defuser'),
('Planted_The_Bomb', 5, 0, 'css', '2_planted_the_bomb.png', 'Bronze Bomb Planter'),
('Rescued_A_Hostage', 5, 0, 'css', '2_rescued_a_hostage.png', 'Bronze Hostage Rescuer'),
('Killed_A_Hostage', 5, 0, 'css', '2_killed_a_hostage.png', 'Bronze Hostage Killer'),
('latency', 5, 0, 'css', '2_latency.png', 'Bronze Lowpinger'),
('headshot', 5, 0, 'css', '2_headshot.png', 'Bronze Headshots'),
('Defused_The_Bomb', 12, 0, 'css', '3_defused_the_bomb.png', 'Silver Bomb Defuser'),
('Planted_The_Bomb', 12, 0, 'css', '3_planted_the_bomb.png', 'Silver Bomb Planter'),
('Rescued_A_Hostage', 12, 0, 'css', '3_rescued_a_hostage.png', 'Silver Hostage Rescuer'),
('Killed_A_Hostage', 12, 0, 'css', '3_killed_a_hostage.png', 'Silver Hostage Killer'),
('latency', 12, 0, 'css', '3_latency.png', 'Silver Lowpinger'),
('headshot', 12, 0, 'css', '3_headshot.png', 'Silver Headshots'),
('Defused_The_Bomb', 20, 0, 'css', '4_defused_the_bomb.png', 'Gold Bomb Defuser'),
('Planted_The_Bomb', 20, 0, 'css', '4_planted_the_bomb.png', 'Gold Bomb Planter'),
('Rescued_A_Hostage', 20, 0, 'css', '4_rescued_a_hostage.png', 'Gold Hostage Rescuer'),
('Killed_A_Hostage', 20, 0, 'css', '4_killed_a_hostage.png', 'Gold Hostage Killer'),
('latency', 20, 0, 'css', '4_latency.png', 'Gold Lowpinger'),
('headshot', 20, 0, 'css', '4_headshot.png', 'Gold Headshots'),
('Defused_The_Bomb', 30, 0, 'css', '5_defused_the_bomb.png', 'Platinum Bomb Defuser'),
('Planted_The_Bomb', 30, 0, 'css', '5_planted_the_bomb.png', 'Platinum Bomb Planter'),
('Rescued_A_Hostage', 30, 0, 'css', '5_rescued_a_hostage.png', 'Platinum Hostage Rescuer'),
('Killed_A_Hostage', 30, 0, 'css', '5_killed_a_hostage.png', 'Platinum Hostage Killer'),
('latency', 30, 0, 'css', '5_latency.png', 'Platinum Lowpinger'),
('headshot', 30, 0, 'css', '5_headshot.png', 'Platinum Headshots'),
('Defused_The_Bomb', 50, 0, 'css', '6_defused_the_bomb.png', 'Supreme Bomb Defuser'),
('Planted_The_Bomb', 50, 0, 'css', '6_planted_the_bomb.png', 'Supreme Bomb Planter'),
('Rescued_A_Hostage', 50, 0, 'css', '6_rescued_a_hostage.png', 'Supreme Hostage Rescuer'),
('Killed_A_Hostage', 50, 0, 'css', '6_killed_a_hostage.png', 'Supreme Hostage Killer'),
('latency', 50, 0, 'css', '6_latency.png', 'Supreme Lowpinger'),
('headshot', 50, 0, 'css', '6_headshot.png', 'Supreme Headshots'),
('teamkills', 1, 0, 'css', '1_teamkills.png', 'Award of Team Kills'),
('teamkills', 5, 0, 'css', '2_teamkills.png', 'Bronze Team Kills'),
('teamkills', 12, 0, 'css', '3_teamkills.png', 'Silver Team Kills'),
('teamkills', 20, 0, 'css', '4_teamkills.png', 'Gold Team Kills'),
('teamkills', 30, 0, 'css', '5_teamkills.png', 'Platinum Team Kills'),
('teamkills', 50, 0, 'css', '6_teamkills.png', 'Supreme Team Kills'),
('mostkills', 1, 0, 'css', '1_mostkills.png', 'Award of Most Kills'),
('mostkills', 5, 0, 'css', '2_mostkills.png', 'Bronze Most Kills'),
('mostkills', 12, 0, 'css', '3_mostkills.png', 'Silver Most Kills'),
('mostkills', 20, 0, 'css', '4_mostkills.png', 'Gold Most Kills'),
('mostkills', 30, 0, 'css', '5_mostkills.png', 'Platinum Most Kills'),
('mostkills', 50, 0, 'css', '6_mostkills.png', 'Supreme Most Kills'),
('suicide', 1, 0, 'css', '1_suicide.png', 'Award of Suicides'),
('suicide', 5, 0, 'css', '2_suicide.png', 'Bronze Suicides'),
('suicide', 12, 0, 'css', '3_suicide.png', 'Silver Suicides'),
('suicide', 20, 0, 'css', '4_suicide.png', 'Gold Suicides'),
('suicide', 30, 0, 'css', '5_suicide.png', 'Platinum Suicides'),
('suicide', 50, 0, 'css', '6_suicide.png', 'Supreme Suicides'),
('famas', 1, 0, 'css', '1_famas.png', 'Award of Famas'),
('famas', 5, 0, 'css', '2_famas.png', 'Award of Famas'),
('famas', 12, 0, 'css', '3_famas.png', 'Award of Famas'),
('famas', 20, 0, 'css', '4_famas.png', 'Award of Famas'),
('famas', 30, 0, 'css', '5_famas.png', 'Award of Famas'),
('famas', 50, 0, 'css', '6_famas.png', 'Award of Famas'),
('tf_projectile_rocket',1,0,'tf','1_tf_projectile_rocket.png','Bronze Rocket Launcher'),
('tf_projectile_rocket',5,0,'tf','2_tf_projectile_rocket.png','Silver Rocket Launcher'),
('tf_projectile_rocket',10,0,'tf','3_tf_projectile_rocket.png','Gold Rocket Launcher'),
('sniperrifle',1,0,'tf','1_sniperrifle.png','Bronze Sniper Rifle'),
('sniperrifle',5,0,'tf','2_sniperrifle.png','Silver Sniper Rifle'),
('sniperrifle',10,0,'tf','3_sniperrifle.png','Gold Sniper Rifle'),
('minigun',1,0,'tf','1_minigun.png','Bronze Minigun'),
('minigun',5,0,'tf','2_minigun.png','Silver Minigun'),
('minigun',10,0,'tf','3_minigun.png','Gold Minigun'),
('obj_sentrygun',1,0,'tf','1_obj_sentrygun.png','Bronze Sentry Gun'),
('obj_sentrygun',5,0,'tf','2_obj_sentrygun.png','Silver Sentry Gun'),
('obj_sentrygun',10,0,'tf','3_obj_sentrygun.png','Gold Sentry Gun'),
('knife',1,0,'tf','1_knife.png','Bronze Knife'),
('knife',5,0,'tf','2_knife.png','Silver Knife'),
('knife',10,0,'tf','3_knife.png','Gold Knife'),
('scattergun',1,0,'tf','1_scattergun.png','Bronze Scatter Gun'),
('scattergun',5,0,'tf','2_scattergun.png','Silver Scatter Gun'),
('scattergun',10,0,'tf','3_scattergun.png','Gold Scatter Gun'),
('tf_projectile_pipe',1,0,'tf','1_tf_projectile_pipe.png','Bronze Grenade Launcher'),
('tf_projectile_pipe',5,0,'tf','2_tf_projectile_pipe.png','Silver Grenade Launcher'),
('tf_projectile_pipe',10,0,'tf','3_tf_projectile_pipe.png','Gold Grenade Launcher'),
('flamethrower',1,0,'tf','1_flamethrower.png','Bronze Flamethrower'),
('flamethrower',5,0,'tf','2_flamethrower.png','Silver Flamethrower'),
('flamethrower',10,0,'tf','3_flamethrower.png','Gold Flamethrower'),
('backburner',1,0,'tf','1_backburner.png','Bronze Backburner'),
('backburner',5,0,'tf','2_backburner.png','Silver Backburner'),
('backburner',10,0,'tf','3_backburner.png','Gold Backburner'),
('tf_projectile_pipe_remote',1,0,'tf','1_tf_projectile_pipe_remote.png','Bronze Sticky Launcher'),
('tf_projectile_pipe_remote',5,0,'tf','2_tf_projectile_pipe_remote.png','Silver Sticky Launcher'),
('tf_projectile_pipe_remote',10,0,'tf','3_tf_projectile_pipe_remote.png','Gold Sticky Launcher'),
('shotgun_primary',1,0,'tf','1_shotgun_primary.png','Bronze Engy Shotgun'),
('shotgun_primary',5,0,'tf','2_shotgun_primary.png','Silver Engy Shotgun'),
('shotgun_primary',10,0,'tf','3_shotgun_primary.png','Gold Engy Shotgun'),
('smg',1,0,'tf','1_smg.png','Bronze Submachine Gun'),
('smg',5,0,'tf','2_smg.png','Silver Submachine Gun'),
('smg',10,0,'tf','3_smg.png','Gold Submachine Gun'),
('shotgun_soldier',1,0,'tf','1_shotgun_soldier.png','Bronze Soldier Shotgun'),
('shotgun_soldier',5,0,'tf','2_shotgun_soldier.png','Silver Soldier Shotgun'),
('shotgun_soldier',10,0,'tf','3_shotgun_soldier.png','Gold Soldier Shotgun'),
('revolver',1,0,'tf','1_revolver.png','Bronze Revolver'),
('revolver',5,0,'tf','2_revolver.png','Silver Revolver'),
('revolver',10,0,'tf','3_revolver.png','Gold Revolver'),
('shotgun_pyro',1,0,'tf','1_shotgun_pyro.png','Bronze Pyro Shotgun'),
('shotgun_pyro',5,0,'tf','2_shotgun_pyro.png','Silver Pyro Shotgun'),
('shotgun_pyro',10,0,'tf','3_shotgun_pyro.png','Gold Pyro Shotgun'),
('bat',1,0,'tf','1_bat.png','Bronze Bat'),
('bat',5,0,'tf','2_bat.png','Silver Bat'),
('bat',10,0,'tf','3_bat.png','Gold Bat'),
('wrench',1,0,'tf','1_wrench.png','Bronze Wrench'),
('wrench',5,0,'tf','2_wrench.png','Silver Wrench'),
('wrench',10,0,'tf','3_wrench.png','Gold Wrench'),
('shotgun_hwg',1,0,'tf','1_shotgun_hwg.png','Bronze Heavy Shotgun'),
('shotgun_hwg',5,0,'tf','2_shotgun_hwg.png','Silver Heavy Shotgun'),
('shotgun_hwg',10,0,'tf','3_shotgun_hwg.png','Gold Heavy Shotgun'),
('club',1,0,'tf','1_club.png','Bronze Machete'),
('club',5,0,'tf','2_club.png','Silver Machete'),
('club',10,0,'tf','3_club.png','Gold Machete'),
('pistol_scout',1,0,'tf','1_pistol_scout.png','Bronze Scout Pistol'),
('pistol_scout',5,0,'tf','2_pistol_scout.png','Silver Scout Pistol'),
('pistol_scout',10,0,'tf','3_pistol_scout.png','Gold Scout Pistol'),
('pistol',1,0,'tf','1_pistol.png','Bronze Engy Pistol'),
('pistol',5,0,'tf','2_pistol.png','Silver Engy Pistol'),
('pistol',10,0,'tf','3_pistol.png','Gold Engy Pistol'),
('bottle',1,0,'tf','1_bottle.png','Bronze Bottle'),
('bottle',5,0,'tf','2_bottle.png','Silver Bottle'),
('bottle',10,0,'tf','3_bottle.png','Gold Bottle'),
('shovel',1,0,'tf','1_shovel.png','Bronze Shovel'),
('shovel',5,0,'tf','2_shovel.png','Silver Shovel'),
('shovel',10,0,'tf','3_shovel.png','Gold Shovel'),
('fireaxe',1,0,'tf','1_fireaxe.png','Bronze Fire Axe'),
('fireaxe',5,0,'tf','2_fireaxe.png','Silver Fire Axe'),
('fireaxe',10,0,'tf','3_fireaxe.png','Gold Fire Axe'),
('fists',1,0,'tf','1_fists.png','Bronze Fists'),
('fists',5,0,'tf','2_fists.png','Silver Fists'),
('fists',10,0,'tf','3_fists.png','Gold Fists'),
('ubersaw',1,0,'tf','1_ubersaw.png','Bronze Ubersaw'),
('ubersaw',5,0,'tf','2_ubersaw.png','Silver Ubersaw'),
('ubersaw',10,0,'tf','3_ubersaw.png','Gold Ubersaw'),
('blutsauger',1,0,'tf','1_blutsauger.png','Bronze Blutsauger'),
('blutsauger',5,0,'tf','2_blutsauger.png','Silver Blutsauger'),
('blutsauger',10,0,'tf','3_blutsauger.png','Gold Blutsauger'),
('axtinguisher',1,0,'tf','1_axtinguisher.png','Bronze Axtinguisher'),
('axtinguisher',5,0,'tf','2_axtinguisher.png','Silver Axtinguisher'),
('axtinguisher',10,0,'tf','3_axtinguisher.png','Gold Axtinguisher'),
('deflect_flare',1,0,'tf','1_deflect_flare.png','Bronze Deflected Flare'),
('deflect_flare',5,0,'tf','2_deflect_flare.png','Silver Deflected Flare'),
('deflect_flare',10,0,'tf','3_deflect_flare.png','Gold Deflected Flare'),
('syringegun_medic',1,0,'tf','1_syringegun_medic.png','Bronze Syringe Gun'),
('syringegun_medic',5,0,'tf','2_syringegun_medic.png','Silver Syringe Gun'),
('syringegun_medic',10,0,'tf','3_syringegun_medic.png','Gold Syringe Gun'),
('bonesaw',1,0,'tf','1_bonesaw.png','Bronze Bonesaw'),
('bonesaw',5,0,'tf','2_bonesaw.png','Silver Bonesaw'),
('bonesaw',10,0,'tf','3_bonesaw.png','Gold Bonesaw'),
('deflect_promode',1,0,'tf','1_deflect_promode.png','Bronze Deflected Grenade'),
('deflect_promode',5,0,'tf','2_deflect_promode.png','Silver Deflected Grenade'),
('deflect_promode',10,0,'tf','3_deflect_promode.png','Gold Deflected Grenade'),
('deflect_rocket',1,0,'tf','1_deflect_rocket.png','Bronze Deflected Rocket'),
('deflect_rocket',5,0,'tf','2_deflect_rocket.png','Silver Deflected Rocket'),
('deflect_rocket',10,0,'tf','3_deflect_rocket.png','Gold Deflected Rocket'),
('deflect_sticky',1,0,'tf','1_deflect_sticky.png','Bronze Deflected Sticky'),
('deflect_sticky',5,0,'tf','2_deflect_sticky.png','Silver Deflected Sticky'),
('deflect_sticky',10,0,'tf','3_deflect_sticky.png','Gold Deflected Sticky'),
('flaregun',1,0,'tf','1_flaregun.png','Bronze Flare Gun'),
('flaregun',5,0,'tf','2_flaregun.png','Silver Flare Gun'),
('flaregun',10,0,'tf','3_flaregun.png','Gold Flare Gun'),
('natascha',1,0,'tf','1_natascha.png','Bronze Natascha'),
('natascha',5,0,'tf','2_natascha.png','Silver Natascha'),
('natascha',10,0,'tf','3_natascha.png','Gold Natascha'),
('gloves',1,0,'tf','1_gloves.png','Bronze K.G.B.'),
('gloves',5,0,'tf','2_gloves.png','Silver K.G.B.'),
('gloves',10,0,'tf','3_gloves.png','Gold K.G.B.'),
('taunt_heavy',1,0,'tf','1_taunt_heavy.png','Bronze Heavy Taunt'),
('taunt_heavy',5,0,'tf','2_taunt_heavy.png','Silver Heavy Taunt'),
('taunt_heavy',10,0,'tf','3_taunt_heavy.png','Gold Heavy Taunt'),
('taunt_pyro',1,0,'tf','1_taunt_pyro.png','Bronze Hadouken'),
('taunt_pyro',5,0,'tf','2_taunt_pyro.png','Silver Hadouken'),
('taunt_pyro',10,0,'tf','3_taunt_pyro.png','Gold Hadouken'),
('chargedeployed',1,0,'tf','1_chargedeployed.png','Bronze Uber'),
('chargedeployed',5,0,'tf','2_chargedeployed.png','Silver Uber'),
('chargedeployed',10,0,'tf','3_chargedeployed.png','Gold Uber'),
('sandvich',1,0,'tf','1_sandvich.png','Bronze Sandvich'),
('sandvich',5,0,'tf','2_sandvich.png','Silver Sandvich'),
('sandvich',10,0,'tf','3_sandvich.png','Gold Sandvich'),
('domination',1,0,'tf','1_domination.png','Bronze Dominator'),
('domination',5,0,'tf','2_domination.png','Silver Dominator'),
('domination',10,0,'tf','3_domination.png','Gold Dominator'),
('revenge',1,0,'tf','1_revenge.png','Bronze Revenger'),
('revenge',5,0,'tf','2_revenge.png','Silver Revenger'),
('revenge',10,0,'tf','3_revenge.png','Gold Revenger'),
('mostkills',1,0,'tf','1_mostkills.png','Bronze Kill Award'),
('mostkills',5,0,'tf','2_mostkills.png','Silver Kill Award'),
('mostkills',10,0,'tf','3_mostkills.png','Gold Kill Award'),
('backstab',1,0,'tf','1_backstab.png','Bronze Backstabber'),
('backstab',5,0,'tf','2_backstab.png','Silver Backstabber'),
('backstab',10,0,'tf','3_backstab.png','Gold Backstabber'),
('pointcaptured',1,0,'tf','1_pointcaptured.png','Bronze Capture Point'),
('pointcaptured',5,0,'tf','2_pointcaptured.png','Silver Capture Point'),
('pointcaptured',10,0,'tf','3_pointcaptured.png','Gold Capture Point'),
('captureblocked',1,0,'tf','1_captureblocked.png','Bronze Blocker'),
('captureblocked',5,0,'tf','2_captureblocked.png','Silver Blocker'),
('captureblocked',10,0,'tf','3_captureblocked.png','Gold Blocker'),
('flagevent_defended',1,0,'tf','1_flagevent_defended.png','Bronze Defender'),
('flagevent_defended',5,0,'tf','2_flagevent_defended.png','Silver Defender'),
('flagevent_defended',10,0,'tf','3_flagevent_defended.png','Gold Defender'),
('flagevent_captured',1,0,'tf','1_flagevent_captured.png','Bronze Intelligence'),
('flagevent_captured',5,0,'tf','2_flagevent_captured.png','Silver Intelligence'),
('flagevent_captured',10,0,'tf','3_flagevent_captured.png','Gold Intelligence'),
('kill assist',1,0,'tf','1_kill assist.png','Bronze Assister'),
('kill assist',5,0,'tf','2_kill assist.png','Silver Assister'),
('kill assist',10,0,'tf','3_kill assist.png','Gold Assister'),
('bonuspoints',1,0,'tf','1_bonuspoints.png','Bronze Healer'),
('bonuspoints',5,0,'tf','2_bonuspoints.png','Silver Healer'),
('bonuspoints',10,0,'tf','3_bonuspoints.png','Gold Healer'),
('kill_assist_medic',1,0,'tf','1_kill_assist_medic.png','Bronze Healer'),
('kill_assist_medic',5,0,'tf','2_kill_assist_medic.png','Silver Healer'),
('kill_assist_medic',10,0,'tf','3_kill_assist_medic.png','Gold Healer'),
('builtobject_obj_attachment_sapper',1,0,'tf','1_builtobject_obj_attachment_sapper.png','Bronze Sapper'),
('builtobject_obj_attachment_sapper',5,0,'tf','2_builtobject_obj_attachment_sapper.png','Silver Sapper'),
('builtobject_obj_attachment_sapper',10,0,'tf','3_builtobject_obj_attachment_sapper.png','Gold Sapper'),
('deflect_arrow',1,0,'tf','1_deflect_arrow.png','Bronze Deflected Arrow'),
('deflect_arrow',5,0,'tf','2_deflect_arrow.png','Silver Deflected Arrow'),
('deflect_arrow',10,0,'tf','3_deflect_arrow.png','Gold Deflected Arrow'),
('ambassador', 1, 0, 'tf', '1_ambassador.png', 'Bronze Ambassador'),
('ambassador', 5, 0, 'tf', '2_ambassador.png', 'Silver Ambassador'),
('ambassador', 10, 0, 'tf', '3_ambassador.png', 'Gold Ambassador'),
('buff_deployed', 1, 0, 'tf', '1_buff_deployed.png', 'Bronze Buff Deploy'),
('buff_deployed', 5, 0, 'tf', '2_buff_deployed.png', 'Silver Buff Deploy'),
('buff_deployed', 10, 0, 'tf', '3_buff_deployed.png', 'Gold Buff Deploy'),
('builtobject_obj_dispenser', 1, 0, 'tf', '1_builtobject_obj_dispenser.png', 'Bronze Built Dispenser'),
('builtobject_obj_dispenser', 5, 0, 'tf', '2_builtobject_obj_dispenser.png', 'Silver Built Dispenser'),
('builtobject_obj_dispenser', 10, 0, 'tf', '3_builtobject_obj_dispenser.png', 'Gold Built Dispenser'),
('builtobject_obj_sentrygun', 1, 0, 'tf', '1_builtobject_obj_sentrygun.png', 'Bronze Built Sentry Gun'),
('builtobject_obj_sentrygun', 5, 0, 'tf', '2_builtobject_obj_sentrygun.png', 'Silver Built Sentry Gun'),
('builtobject_obj_sentrygun', 10, 0, 'tf', '3_builtobject_obj_sentrygun.png', 'Gold Built Sentry Gun'),
('builtobject_obj_sentrygun_mini', 1, 0, 'tf', '1_builtobject_obj_sentrygun_mini.png', 'Bronze Built Mini Sentry Gun'),
('builtobject_obj_sentrygun_mini', 5, 0, 'tf', '2_builtobject_obj_sentrygun_mini.png', 'Silver Built Mini Sentry Gun'),
('builtobject_obj_sentrygun_mini', 10, 0, 'tf', '3_builtobject_obj_sentrygun_mini.png', 'Gold Built Mini Sentry Gun'),
('defended_medic', 5, 0, 'tf', '2_defended_medic.png', 'Silver Defended Medic'),
('defended_medic', 1, 0, 'tf', '1_defended_medic.png', 'Bronze Defended Medic'),
('defended_medic', 10, 0, 'tf', '3_defended_medic.png', 'Gold Defended Medic'),
('demoshield', 5, 0, 'tf', '2_demoshield.png', 'Silver Chargin'' Targe'),
('demoshield', 10, 0, 'tf', '3_demoshield.png', 'Gold Chargin'' Targe'),
('demoshield', 1, 0, 'tf', '1_demoshield.png', 'Bronze Chargin'' Targe'),
('jarate', 10, 0, 'tf', '3_jarate.png', 'Gold Jarate'),
('jarate', 5, 0, 'tf', '2_jarate.png', 'Silver Jarate'),
('jarate', 1, 0, 'tf', '1_jarate.png', 'Bronze Jarate'),
('latency', 10, 0, 'tf', '3_latency.png', 'Gold Latency'),
('latency', 5, 0, 'tf', '2_latency.png', 'Silver Latency'),
('latency', 1, 0, 'tf', '1_latency.png', 'Bronze Latency'),
('unique_pickaxe', 5, 0, 'tf', '2_pickaxe.png', 'Silver Equalizer'),
('unique_pickaxe', 1, 0, 'tf', '1_pickaxe.png', 'Bronze Equalizer'),
('unique_pickaxe', 10, 0, 'tf', '3_pickaxe.png', 'Gold Equalizer'),
('rocketlauncher_directhit', 1, 0, 'tf', '1_rocketlauncher_directhit.png', 'Bronze Direct Hit'),
('rocketlauncher_directhit', 10, 0, 'tf', '3_rocketlauncher_directhit.png', 'Gold Direct Hit'),
('rocketlauncher_directhit', 5, 0, 'tf', '2_rocketlauncher_directhit.png', 'Silver Direct Hit'),
('sandman', 1, 0, 'tf', '1_sandman.png', 'Bronze Sandman'),
('sandman', 10, 0, 'tf', '3_sandman.png', 'Gold Sandman'),
('sandman', 5, 0, 'tf', '2_sandman.png', 'Silver Sandman'),
('steal_sandvich', 10, 0, 'tf', '3_steal_sandvich.png', 'Gold Steal Sandvich'),
('steal_sandvich', 5, 0, 'tf', '2_steal_sandvich.png', 'Silver Steal Sandvich'),
('steal_sandvich', 1, 0, 'tf', '1_steal_sandvich.png', 'Bronze Steal Sandvich'),
('sticky_resistance', 5, 0, 'tf', '2_sticky_resistance.png', 'Silver Scottish Resistance'),
('sticky_resistance', 1, 0, 'tf', '1_sticky_resistance.png', 'Bronze Scottish Resistance'),
('sticky_resistance', 10, 0, 'tf', '3_sticky_resistance.png', 'Gold Scottish Resistance'),
('stun', 1, 0, 'tf', '1_stun.png', 'Bronze Stun'),
('stun', 10, 0, 'tf', '3_stun.png', 'Gold Stun'),
('stun', 5, 0, 'tf', '2_stun.png', 'Silver Stun'),
('sword', 10, 0, 'tf', '3_sword.png', 'Gold Eyelander'),
('sword', 5, 0, 'tf', '2_sword.png', 'Silver Eyelander'),
('sword', 1, 0, 'tf', '1_sword.png', 'Bronze Eyelander'),
('taunt_demoman', 10, 0, 'tf', '3_taunt_demoman.png', 'Gold Demoman Taunt'),
('taunt_demoman', 5, 0, 'tf', '2_taunt_demoman.png', 'Silver Demoman Taunt'),
('taunt_demoman', 1, 0, 'tf', '1_taunt_demoman.png', 'Bronze Demoman Taunt'),
('taunt_scout', 10, 0, 'tf', '3_taunt_scout.png', 'Gold Scout Taunt'),
('taunt_scout', 1, 0, 'tf', '1_taunt_scout.png', 'Bronze Scout Taunt'),
('taunt_scout', 5, 0, 'tf', '2_taunt_scout.png', 'Silver Scout Taunt'),
('taunt_sniper', 1, 0, 'tf', '1_taunt_sniper.png', 'Bronze Sniper Taunt'),
('taunt_sniper', 10, 0, 'tf', '3_taunt_sniper.png', 'Gold Sniper Taunt'),
('taunt_sniper', 5, 0, 'tf', '2_taunt_sniper.png', 'Silver Sniper Taunt'),
('taunt_soldier', 1, 0, 'tf', '1_taunt_soldier.png', 'Bronze Soldier Taunt'),
('taunt_soldier', 10, 0, 'tf', '3_taunt_soldier.png', 'Gold Soldier Taunt'),
('taunt_soldier', 5, 0, 'tf', '2_taunt_soldier.png', 'Silver Soldier Taunt'),
('taunt_spy', 10, 0, 'tf', '3_taunt_spy.png', 'Gold Spy Taunt'),
('taunt_spy', 5, 0, 'tf', '2_taunt_spy.png', 'Silver Spy Taunt'),
('taunt_spy', 1, 0, 'tf', '1_taunt_spy.png', 'Bronze Spy Taunt'),
('teleport', 5, 0, 'tf', '2_teleport.png', 'Silver Teleport'),
('teleport', 10, 0, 'tf', '3_teleport.png', 'Gold Teleport'),
('teleport', 1, 0, 'tf', '1_teleport.png', 'Bronze Teleport'),
('tf_projectile_arrow', 1, 0, 'tf', '1_tf_projectile_arrow.png', 'Bronze Huntsman'),
('tf_projectile_arrow', 5, 0, 'tf', '2_tf_projectile_arrow.png', 'Silver Huntsman'),
('tf_projectile_arrow', 10, 0, 'tf', '3_tf_projectile_arrow.png', 'Gold Huntsman'),
('tf_projectile_arrow_fire', 1, 0, 'tf', '1_tf_projectile_arrow_fire.png', 'Bronze Flaming Hunstman'),
('tf_projectile_arrow_fire', 5, 0, 'tf', '2_tf_projectile_arrow_fire.png', 'Silver Flaming Hunstman'),
('tf_projectile_arrow_fire', 10, 0, 'tf', '3_tf_projectile_arrow_fire.png', 'Gold Flaming Hunstman'),
('killed_charged_medic', 1, 0, 'tf', '1_killed_charged_medic.png', 'Bronze Charged Medic Kills'),
('killed_charged_medic', 5, 0, 'tf', '2_killed_charged_medic.png', 'Silver Charged Medic Kills'),
('killed_charged_medic', 10, 0, 'tf', '3_killed_charged_medic.png', 'Gold Charged Medic Kills'),
('escort_score', 1, 0, 'tf', '1_escort_score.png', 'Bronze Cart Escort'),
('escort_score', 5, 0, 'tf', '2_escort_score.png', 'Silver Cart Escort'),
('escort_score', 10, 0, 'tf', '3_escort_score.png', 'Gold Cart Escort'),
('shield_blocked', 1, 0, 'tf', '1_shield_blocked.png', 'Bronze Broken Razorbacks'),
('shield_blocked', 5, 0, 'tf', '2_shield_blocked.png', 'Silver Broken Razorbacks'),
('shield_blocked', 10, 0, 'tf', '3_shield_blocked.png', 'Gold Broken Razorbacks'),
('taunt_medic', 1, 0, 'tf', '1_taunt_medic.png', 'Bronze Medic Taunt'),
('taunt_medic', 5, 0, 'tf', '2_taunt_medic.png', 'Silver Medic Taunt'),
('taunt_medic', 10, 0, 'tf', '3_taunt_medic.png', 'Gold Medic Taunt'),
('tribalkukri', 1, 0, 'tf', '1_tribalkukri.png', 'Bronze Tribalman''s Shiv'),
('tribalkukri', 5, 0, 'tf', '2_tribalkukri.png', 'Silver Tribalman''s Shiv'),
('tribalkukri', 10, 0, 'tf', '3_tribalkukri.png', 'Gold Tribalman''s Shiv'),
('battleaxe', 1, 0, 'tf', '1_battleaxe.png', 'Bronze Scotsman''s Skullcutter'),
('battleaxe', 5, 0, 'tf', '2_battleaxe.png', 'Silver Scotsman''s Skullcutter'),
('battleaxe', 10, 0, 'tf', '3_battleaxe.png', 'Gold Scotsman''s Skullcutter'),
('allsentrykills', 1, 0, 'tf', '1_allsentrykills.png', 'Bronze Sentry Kills'),
('allsentrykills', 5, 0, 'tf', '2_allsentrykills.png', 'Silver Sentry Kills'),
('allsentrykills', 10, 0, 'tf', '3_allsentrykills.png', 'Gold Sentry Kills'),
('ball', 1, 0, 'tf', '1_ball.png', 'Bronze Baseball'),
('ball', 5, 0, 'tf', '2_ball.png', 'Silver Baseball'),
('ball', 10, 0, 'tf', '3_ball.png', 'Gold Baseball'),
('engineer_extinguish', 1, 0, 'tf', '1_engineer_extinguish.png', 'Bronze Engineer Extinguish'),
('engineer_extinguish', 5, 0, 'tf', '2_engineer_extinguish.png', 'Silver Engineer Extinguish'),
('engineer_extinguish', 10, 0, 'tf', '3_engineer_extinguish.png', 'Gold Engineer Extinguish'),
('force_a_nature', 1, 0, 'tf', '1_force_a_nature.png', 'Bronze Force-A-Nature'),
('force_a_nature', 5, 0, 'tf', '2_force_a_nature.png', 'Silver Force-A-Nature'),
('force_a_nature', 10, 0, 'tf', '3_force_a_nature.png', 'Gold Force-A-Nature'),
('frontier_justice', 1, 0, 'tf', '1_frontier_justice.png', 'Bronze Frontier Justice'),
('frontier_justice', 5, 0, 'tf', '2_frontier_justice.png', 'Silver Frontier Justice'),
('frontier_justice', 10, 0, 'tf', '3_frontier_justice.png', 'Gold Frontier Justice'),
('killedobject_obj_dispenser', 1, 0, 'tf', '1_killedobject_obj_dispenser.png', 'Bronze Dispensers Destroyed'),
('killedobject_obj_dispenser', 5, 0, 'tf', '2_killedobject_obj_dispenser.png', 'Silver Dispensers Destroyed'),
('killedobject_obj_dispenser', 10, 0, 'tf', '3_killedobject_obj_dispenser.png', 'Gold Dispensers Destroyed'),
('killedobject_obj_sentrygun', 1, 0, 'tf', '1_killedobject_obj_sentrygun.png', 'Bronze Sentry Guns Destroyed'),
('killedobject_obj_sentrygun', 5, 0, 'tf', '2_killedobject_obj_sentrygun.png', 'Silver Sentry Guns Destroyed'),
('killedobject_obj_sentrygun', 10, 0, 'tf', '3_killedobject_obj_sentrygun.png', 'Gold Sentry Guns Destroyed'),
('killedobject_obj_sentrygun_mini', 1, 0, 'tf', '1_killedobject_obj_sentrygun_mini.png', 'Bronze Mini Sentry Guns Destroyed'),
('killedobject_obj_sentrygun_mini', 5, 0, 'tf', '2_killedobject_obj_sentrygun_mini.png', 'Silver Mini Sentry Guns Destroyed'),
('killedobject_obj_sentrygun_mini', 10, 0, 'tf', '3_killedobject_obj_sentrygun_mini.png', 'Gold Mini Sentry Guns Destroyed'),
('medic_extinguish', 1, 0, 'tf', '1_medic_extinguish.png', 'Bronze Medic Entinguish'),
('medic_extinguish', 5, 0, 'tf', '2_medic_extinguish.png', 'Silver Medic Entinguish'),
('medic_extinguish', 10, 0, 'tf', '3_medic_extinguish.png', 'Gold Medic Entinguish'),
('mvp1', 1, 0, 'tf', '1_mvp1.png', 'Bronze Most Valuable Player'),
('mvp1', 5, 0, 'tf', '2_mvp1.png', 'Silver Most Valuable Player'),
('mvp1', 10, 0, 'tf', '3_mvp1.png', 'Gold Most Valuable Player'),
('obj_minisentry', 1, 0, 'tf', '1_obj_sentrygun_mini.png', 'Bronze Mini Sentrygun'),
('obj_minisentry', 5, 0, 'tf', '2_obj_sentrygun_mini.png', 'Silver Mini Sentrygun'),
('obj_minisentry', 10, 0, 'tf', '3_obj_sentrygun_mini.png', 'Gold Mini Sentrygun'),
('paintrain', 1, 0, 'tf', '1_paintrain.png', 'Bronze Paintrain'),
('paintrain', 5, 0, 'tf', '2_paintrain.png', 'Silver Paintrain'),
('paintrain', 10, 0, 'tf', '3_paintrain.png', 'Gold Paintrain'),
('pyro_extinguish', 1, 0, 'tf', '1_pyro_extinguish.png', 'Bronze Pyro Extinguish'),
('pyro_extinguish', 5, 0, 'tf', '2_pyro_extinguish.png', 'Silver Pyro Extinguish'),
('pyro_extinguish', 10, 0, 'tf', '3_pyro_extinguish.png', 'Gold Pyro Extinguish'),
('robot_arm', 1, 0, 'tf', '1_robot_arm.png', 'Bronze Gunslinger'),
('robot_arm', 5, 0, 'tf', '2_robot_arm.png', 'Silver Gunslinger'),
('robot_arm', 10, 0, 'tf', '3_robot_arm.png', 'Gold Gunslinger'),
('robot_arm_blender_kill', 1, 0, 'tf', '1_robot_arm_blender_kill.png', 'Bronze Engineer Taunt (Gunslinger)'),
('robot_arm_blender_kill', 5, 0, 'tf', '2_robot_arm_blender_kill.png', 'Silver Engineer Taunt (Gunslinger)'),
('robot_arm_blender_kill', 10, 0, 'tf', '3_robot_arm_blender_kill.png', 'Gold Engineer Taunt (Gunslinger)'),
('robot_arm_combo_kill', 1, 0, 'tf', '1_robot_arm_combo_kill.png', 'Bronze Gunslinger Combo Kill'),
('robot_arm_combo_kill', 5, 0, 'tf', '2_robot_arm_combo_kill.png', 'Silver Gunslinger Combo Kill'),
('robot_arm_combo_kill', 10, 0, 'tf', '3_robot_arm_combo_kill.png', 'Gold Gunslinger Combo Kill'),
('sledgehammer', 1, 0, 'tf', '1_sledgehammer.png', 'Bronze Homewrecker'),
('sledgehammer', 5, 0, 'tf', '2_sledgehammer.png', 'Silver Homewrecker'),
('sledgehammer', 10, 0, 'tf', '3_sledgehammer.png', 'Gold Homewrecker'),
('sniper_extinguish', 1, 0, 'tf', '1_sniper_extinguish.png', 'Bronze Sniper Extinguish'),
('sniper_extinguish', 5, 0, 'tf', '2_sniper_extinguish.png', 'Silver Sniper Extinguish'),
('sniper_extinguish', 10, 0, 'tf', '3_sniper_extinguish.png', 'Gold Sniper Extinguish'),
('southern_hospitality', 1, 0, 'tf', '1_southern_hospitality.png', 'Bronze Southern Hospitality'),
('southern_hospitality', 5, 0, 'tf', '2_southern_hospitality.png', 'Silver Southern Hospitality'),
('southern_hospitality', 10, 0, 'tf', '3_southern_hospitality.png', 'Gold Southern Hospitality'),
('taunt_guitar_kill', 1, 0, 'tf', '1_taunt_guitar_kill.png', 'Bronze Engineer Taunt (Guitar)'),
('taunt_guitar_kill', 5, 0, 'tf', '2_taunt_guitar_kill.png', 'Silver Engineer Taunt (Guitar)'),
('taunt_guitar_kill', 10, 0, 'tf', '3_taunt_guitar_kill.png', 'Gold Engineer Taunt (Guitar)'),
('bleed_kill', 1, 0, 'tf', '1_bleed_kill.png', 'Bronze Bleed Kills'),
('bleed_kill', 5, 0, 'tf', '2_bleed_kill.png', 'Silver Bleed Kills'),
('bleed_kill', 10, 0, 'tf', '3_bleed_kill.png', 'Gold Bleed Kills'),
('telefrag', 1, 0, 'tf', '1_telefrag.png', 'Bronze Telefrags'),
('telefrag', 5, 0, 'tf', '2_telefrag.png', 'Silver Telefrags'),
('telefrag', 10, 0, 'tf', '3_telefrag.png', 'Gold Telefrags'),
('wrangler_kill', 1, 0, 'tf', '1_wrangler_kill.png', 'Bronze Wrangler'),
('wrangler_kill', 5, 0, 'tf', '2_wrangler_kill.png', 'Silver Wrangler'),
('wrangler_kill', 10, 0, 'tf', '3_wrangler_kill.png', 'Gold Wrangler'),
('battleneedle', 1, 0, 'tf', '1_battleneedle.png', 'Bronze Vita-Saw'),
('battleneedle', 5, 0, 'tf', '2_battleneedle.png', 'Silver Vita-Saw'),
('battleneedle', 10, 0, 'tf', '3_battleneedle.png', 'Gold Vita-Saw'),
('powerjack', 1, 0, 'tf', '1_powerjack.png', 'Bronze Powerjack'),
('powerjack', 5, 0, 'tf', '2_powerjack.png', 'Silver Powerjack'),
('powerjack', 10, 0, 'tf', '3_powerjack.png', 'Gold Powerjack'),
('degreaser', 1, 0, 'tf', '1_degreaser.png', 'Bronze Degreaser'),
('degreaser', 5, 0, 'tf', '2_degreaser.png', 'Silver Degreaser'),
('degreaser', 10, 0, 'tf', '3_degreaser.png', 'Gold Degreaser'),
('short_stop', 1, 0, 'tf', '1_short_stop.png', 'Bronze Short Stop'),
('short_stop', 5, 0, 'tf', '2_short_stop.png', 'Silver Short Stop'),
('short_stop', 10, 0, 'tf', '3_short_stop.png', 'Gold Short Stop'),
('holy_mackerel', 1, 0, 'tf', '1_holy_mackerel.png', 'Bronze Holy Mackerel'),
('holy_mackerel', 5, 0, 'tf', '2_holy_mackerel.png', 'Silver Holy Mackerel'),
('holy_mackerel', 10, 0, 'tf', '3_holy_mackerel.png', 'Gold Holy Mackerel'),
('letranger', 1, 0, 'tf', '1_letranger.png', 'Bronze L''Etranger'),
('letranger', 5, 0, 'tf', '2_letranger.png', 'Silver L''Etranger'),
('letranger', 10, 0, 'tf', '3_letranger.png', 'Gold L''Etranger'),
('eternal_reward', 1, 0, 'tf', '1_eternal_reward.png', 'Bronze Your Eternal Reward'),
('eternal_reward', 5, 0, 'tf', '2_eternal_reward.png', 'Silver Your Eternal Reward'),
('eternal_reward', 10, 0, 'tf', '3_eternal_reward.png', 'Gold Your Eternal Reward'),
('fryingpan', 1, 0, 'tf', '1_fryingpan.png', 'Bronze Frying Pan'),
('fryingpan', 5, 0, 'tf', '2_fryingpan.png', 'Silver Frying Pan'),
('fryingpan', 10, 0, 'tf', '3_fryingpan.png', 'Gold Frying Pan'),
('bushwacka', 1, 0, 'tf', '1_bushwacka.png', 'Bronze Bushwacka'),
('bushwacka', 5, 0, 'tf', '2_bushwacka.png', 'Silver Bushwacka'),
('bushwacka', 10, 0, 'tf', '3_bushwacka.png', 'Gold Bushwacka'),
('gloves_running_urgently', 1, 0, 'tf', '1_glovesurgent.png', 'Bronze Gloves of Running Urgently'),
('gloves_running_urgently', 5, 0, 'tf', '2_glovesurgent.png', 'Silver Gloves of Running Urgently'),
('gloves_running_urgently', 10, 0, 'tf', '3_glovesurgent.png', 'Gold Gloves of Running Urgently'),
('blackbox', 1, 0, 'tf', '1_blackbox.png', 'Bronze Black Box'),
('blackbox', 5, 0, 'tf', '2_blackbox.png', 'Silver Black Box'),
('blackbox', 10, 0, 'tf', '3_blackbox.png', 'Gold Black Box'),
('sydney_sleeper', 1, 0, 'tf', '1_sydneysleeper.png', 'Bronze Sydney Sleeper'),
('sydney_sleeper', 5, 0, 'tf', '2_sydneysleeper.png', 'Silver Sydney Sleeper'),
('sydney_sleeper', 10, 0, 'tf', '3_sydneysleeper.png', 'Gold Sydney Sleeper'),
('dalokohs', 1, 0, 'tf', '1_dalokohs.png', 'Bronze Dalokohs'),
('dalokohs', 5, 0, 'tf', '2_dalokohs.png', 'Silver Dalokohs'),
('dalokohs', 10, 0, 'tf', '3_dalokohs.png', 'Gold Dalokohs'),
('steak', 1, 0, 'tf', '1_steak.png', 'Bronze Buffalo Steak Sandvich'),
('steak', 5, 0, 'tf', '2_steak.png', 'Silver Buffalo Steak Sandvich'),
('steak', 10, 0, 'tf', '3_steak.png', 'Gold Buffalo Steak Sandvich'),
('claidheamohmor', 1, 0, 'tf', '1_claidheamohmor.png', 'Bronze Claidheamohmor'),
('claidheamohmor', 5, 0, 'tf', '2_claidheamohmor.png', 'Silver Claidheamohmor'),
('claidheamohmor', 10, 0, 'tf', '3_claidheamohmor.png', 'Gold Claidheamohmor'),
('back_scratcher', 1, 0, 'tf', '1_back_scratcher.png', 'Bronze Back Scratcher'),
('back_scratcher', 5, 0, 'tf', '2_back_scratcher.png', 'Silver Back Scratcher'),
('back_scratcher', 10, 0, 'tf', '3_back_scratcher.png', 'Gold Back Scratcher'),
('boston_basher', 1, 0, 'tf', '1_boston_basher.png', 'Bronze Boston Basher'),
('boston_basher', 5, 0, 'tf', '2_boston_basher.png', 'Silver Boston Basher'),
('boston_basher', 10, 0, 'tf', '3_boston_basher.png', 'Gold Boston Basher'),
('steel_fists', 1, 0, 'tf', '1_steel_fists.png', 'Bronze Steel Fists'),
('steel_fists', 5, 0, 'tf', '2_steel_fists.png', 'Silver Steel Fists'),
('steel_fists', 10, 0, 'tf', '3_steel_fists.png', 'Gold Steel Fists'),
('amputator', 1, 0, 'tf', '1_amputator.png', 'Bronze Amputator'),
('amputator', 5, 0, 'tf', '2_amputator.png', 'Silver Amputator'),
('amputator', 10, 0, 'tf', '3_amputator.png', 'Gold Amputator'),
('crusaders_crossbow', 1, 0, 'tf', '1_tf_projectile_healing_bolt.png', 'Bronze Crusader''s Crossbow'),
('crusaders_crossbow', 5, 0, 'tf', '2_tf_projectile_healing_bolt.png', 'Silver Crusader''s Crossbow'),
('crusaders_crossbow', 10, 0, 'tf', '3_tf_projectile_healing_bolt.png', 'Gold Crusader''s Crossbow'),
('ullapool_caber', 1, 0, 'tf', '1_ullapool_caber.png', 'Bronze Ullapool Caber'),
('ullapool_caber', 5, 0, 'tf', '2_ullapool_caber.png', 'Silver Ullapool Caber'),
('ullapool_caber', 10, 0, 'tf', '3_ullapool_caber.png', 'Gold Ullapool Caber'),
('ullapool_caber_explosion', 1, 0, 'tf', '1_ullapool_caber_explosion.png', 'Bronze Ullapool Caber BOOM'),
('ullapool_caber_explosion', 5, 0, 'tf', '2_ullapool_caber_explosion.png', 'Silver Ullapool Caber BOOM'),
('ullapool_caber_explosion', 10, 0, 'tf', '3_ullapool_caber_explosion.png', 'Gold Ullapool Caber BOOM'),
('loch_n_load', 1, 0, 'tf', '1_lochnload.png', 'Bronze Loch-n-Load'),
('loch_n_load', 5, 0, 'tf', '2_lochnload.png', 'Silver Loch-n-Load'),
('loch_n_load', 10, 0, 'tf', '3_lochnload.png', 'Gold Loch-n-Load'),
('brass_beast', 1, 0, 'tf', '1_brassbeast.png', 'Bronze Brass Beast'),
('brass_beast', 5, 0, 'tf', '2_brassbeast.png', 'Silver Brass Beast'),
('brass_beast', 10, 0, 'tf', '3_brassbeast.png', 'Gold Brass Beast'),
('warrior_spirit', 1, 0, 'tf', '1_bear_claws.png', 'Bronze Warrior''s Spirit'),
('warrior_spirit', 5, 0, 'tf', '2_bear_claws.png', 'Silver Warrior''s Spirit'),
('warrior_spirit', 10, 0, 'tf', '3_bear_claws.png', 'Gold Warrior''s Spirit'),
('candy_cane', 1, 0, 'tf', '1_candy_cane.png', 'Bronze Candy Cane'),
('candy_cane', 5, 0, 'tf', '2_candy_cane.png', 'Silver Candy Cane'),
('candy_cane', 10, 0, 'tf', '3_candy_cane.png', 'Gold Candy Cane'),
('wrench_jag', 1, 0, 'tf', '1_wrench_jag.png', 'Bronze Jag'),
('wrench_jag', 5, 0, 'tf', '2_wrench_jag.png', 'Silver Jag'),
('wrench_jag', 10, 0, 'tf', '3_wrench_jag.png', 'Gold Jag'),
('headtaker', 1, 0, 'tf', '1_headtaker.png', 'Bronze Horseless Headless Horseman''s Headtaker'),
('headtaker', 5, 0, 'tf', '2_headtaker.png', 'Silver Horseless Headless Horseman''s Headtaker'),
('headtaker', 10, 0, 'tf', '3_headtaker.png', 'Gold Horseless Headless Horseman''s Headtaker'),
('iron_curtain', 1, 0, 'tf', '1_iron_curtain.png', 'Bronze Iron Curtain'),
('iron_curtain', 5, 0, 'tf', '2_iron_curtain.png', 'Silver Iron Curtain'),
('iron_curtain', 10, 0, 'tf', '3_iron_curtain.png', 'Gold Iron Curtain'),
('madmilk', 1, 0, 'tf', '1_madmilk.png', 'Bronze Mad Milk'),
('madmilk', 5, 0, 'tf', '2_madmilk.png', 'Silver Mad Milk'),
('madmilk', 10, 0, 'tf', '3_madmilk.png', 'Gold Mad Milk'),
('atomizer', 1, 0, 'tf', '1_atomizer.png', 'Bronze Atomizer'),
('atomizer', 5, 0, 'tf', '2_atomizer.png', 'Silver Atomizer'),
('atomizer', 10, 0, 'tf', '3_atomizer.png', 'Gold Atomizer'),
('bazaar_bargain', 1, 0, 'tf', '1_bazaar_bargain.png', 'Bronze Bazaar Bargain'),
('bazaar_bargain', 5, 0, 'tf', '2_bazaar_bargain.png', 'Silver Bazaar Bargain'),
('bazaar_bargain', 10, 0, 'tf', '3_bazaar_bargain.png', 'Gold Bazaar Bargain'),
('demokatana', 1, 0, 'tf', '1_demokatana.png', 'Bronze Half-Zatoichi'),
('demokatana', 5, 0, 'tf', '2_demokatana.png', 'Silver Half-Zatoichi'),
('demokatana', 10, 0, 'tf', '3_demokatana.png', 'Gold Half-Zatoichi'),
('detonator', 1, 0, 'tf', '1_detonator.png', 'Bronze Detonator'),
('detonator', 5, 0, 'tf', '2_detonator.png', 'Silver Detonator'),
('detonator', 10, 0, 'tf', '3_detonator.png', 'Gold Detonator'),
('disciplinary_action', 1, 0, 'tf', '1_disciplinary_action.png', 'Bronze Disciplinary Action'),
('disciplinary_action', 5, 0, 'tf', '2_disciplinary_action.png', 'Silver Disciplinary Action'),
('disciplinary_action', 10, 0, 'tf', '3_disciplinary_action.png', 'Gold Disciplinary Action'),
('enforcer', 1, 0, 'tf', '1_enforcer.png', 'Bronze Enforcer'),
('enforcer', 5, 0, 'tf', '2_enforcer.png', 'Silver Enforcer'),
('enforcer', 10, 0, 'tf', '3_enforcer.png', 'Gold Enforcer'),
('eviction_notice', 1, 0, 'tf', '1_eviction_notice.png', 'Bronze Eviction Notice'),
('eviction_notice', 5, 0, 'tf', '2_eviction_notice.png', 'Silver Eviction Notice'),
('eviction_notice', 10, 0, 'tf', '3_eviction_notice.png', 'Gold Eviction Notice'),
('family_business', 1, 0, 'tf', '1_family_business.png', 'Bronze Family Business'),
('family_business', 5, 0, 'tf', '2_family_business.png', 'Silver Family Business'),
('family_business', 10, 0, 'tf', '3_family_business.png', 'Gold Family Business'),
('kunai', 1, 0, 'tf', '1_kunai.png', 'Bronze Conniver''s Kunai'),
('kunai', 5, 0, 'tf', '2_kunai.png', 'Silver Conniver''s Kunai'),
('kunai', 10, 0, 'tf', '3_kunai.png', 'Gold Conniver''s Kunai'),
('lava_axe', 1, 0, 'tf', '1_lava_axe.png', 'Bronze Sharpened Volcano Fragment'),
('lava_axe', 5, 0, 'tf', '2_lava_axe.png', 'Silver Sharpened Volcano Fragment'),
('lava_axe', 10, 0, 'tf', '3_lava_axe.png', 'Gold Sharpened Volcano Fragment'),
('lava_bat', 1, 0, 'tf', '1_lava_bat.png', 'Bronze Sun-on-a-Stick'),
('lava_bat', 5, 0, 'tf', '2_lava_bat.png', 'Silver Sun-on-a-Stick'),
('lava_bat', 10, 0, 'tf', '3_lava_bat.png', 'Gold Sun-on-a-Stick'),
('liberty_launcher', 1, 0, 'tf', '1_liberty_launcher.png', 'Bronze Liberty Launcher'),
('liberty_launcher', 5, 0, 'tf', '2_liberty_launcher.png', 'Silver Liberty Launcher'),
('liberty_launcher', 10, 0, 'tf', '3_liberty_launcher.png', 'Gold Liberty Launcher'),
('mantreads', 1, 0, 'tf', '1_mantreads.png', 'Bronze Mantreads'),
('mantreads', 5, 0, 'tf', '2_mantreads.png', 'Silver Mantreads'),
('mantreads', 10, 0, 'tf', '3_mantreads.png', 'Gold Mantreads'),
('market_gardener', 1, 0, 'tf', '1_market_gardener.png', 'Bronze Market Gardener'),
('market_gardener', 5, 0, 'tf', '2_market_gardener.png', 'Silver Market Gardener'),
('market_gardener', 10, 0, 'tf', '3_market_gardener.png', 'Gold Market Gardener'),
('persian_persuader', 1, 0, 'tf', '1_persian_persuader.png', 'Bronze Persian Persuader'),
('persian_persuader', 5, 0, 'tf', '2_persian_persuader.png', 'Silver Persian Persuader'),
('persian_persuader', 10, 0, 'tf', '3_persian_persuader.png', 'Gold Persian Persuader'),
('proto_syringe', 1, 0, 'tf', '1_proto_syringe.png', 'Bronze Overdose'),
('proto_syringe', 5, 0, 'tf', '2_proto_syringe.png', 'Silver Overdose'),
('proto_syringe', 10, 0, 'tf', '3_proto_syringe.png', 'Gold Overdose'),
('reserve_shooter', 1, 0, 'tf', '1_reserve_shooter.png', 'Bronze Reserve Shooter'),
('reserve_shooter', 5, 0, 'tf', '2_reserve_shooter.png', 'Silver Reserve Shooter'),
('reserve_shooter', 10, 0, 'tf', '3_reserve_shooter.png', 'Gold Reserve Shooter'),
('scout_sword', 1, 0, 'tf', '1_scout_sword.png', 'Bronze Three-Rune Blade'),
('scout_sword', 5, 0, 'tf', '2_scout_sword.png', 'Silver Three-Rune Blade'),
('scout_sword', 10, 0, 'tf', '3_scout_sword.png', 'Gold Three-Rune Blade'),
('shahanshah', 1, 0, 'tf', '1_shahanshah.png', 'Bronze Shahanshah'),
('shahanshah', 5, 0, 'tf', '2_shahanshah.png', 'Silver Shahanshah'),
('shahanshah', 10, 0, 'tf', '3_shahanshah.png', 'Gold Shahanshah'),
('soda_popper', 1, 0, 'tf', '1_soda_popper.png', 'Bronze Soda Popper'),
('soda_popper', 5, 0, 'tf', '2_soda_popper.png', 'Silver Soda Popper'),
('soda_popper', 10, 0, 'tf', '3_soda_popper.png', 'Gold Soda Popper'),
('solemn_vow', 1, 0, 'tf', '1_solemn_vow.png', 'Bronze Solemn Vow'),
('solemn_vow', 5, 0, 'tf', '2_solemn_vow.png', 'Silver Solemn Vow'),
('solemn_vow', 10, 0, 'tf', '3_solemn_vow.png', 'Gold Solemn Vow'),
('the_maul', 1, 0, 'tf', '1_the_maul.png', 'Bronze Maul'),
('the_maul', 5, 0, 'tf', '2_the_maul.png', 'Silver Maul'),
('the_maul', 10, 0, 'tf', '3_the_maul.png', 'Gold Maul'),
('the_winger', 1, 0, 'tf', '1_the_winger.png', 'Bronze Winger'),
('the_winger', 5, 0, 'tf', '2_the_winger.png', 'Silver Winger'),
('the_winger', 10, 0, 'tf', '3_the_winger.png', 'Gold Winger'),
('tomislav', 1, 0, 'tf', '1_tomislav.png', 'Bronze Tomislav'),
('tomislav', 5, 0, 'tf', '2_tomislav.png', 'Silver Tomislav'),
('tomislav', 10, 0, 'tf', '3_tomislav.png', 'Gold Tomislav'),
('warfan', 1, 0, 'tf', '1_warfan.png', 'Bronze Fan O''War'),
('warfan', 5, 0, 'tf', '2_warfan.png', 'Silver Fan O''War'),
('warfan', 10, 0, 'tf', '3_warfan.png', 'Gold Fan O''War'),
('big_earner', 1, 0, 'tf', '1_big_earner.png', 'Bronze Big Earner'),
('big_earner', 5, 0, 'tf', '2_big_earner.png', 'Silver Big Earner'),
('big_earner', 10, 0, 'tf', '3_big_earner.png', 'Gold Big Earner'),
('saxxy', 1, 0, 'tf', '1_saxxy.png', 'Bronze Saxxy'),
('saxxy', 5, 0, 'tf', '2_saxxy.png', 'Silver Saxxy'),
('saxxy', 10, 0, 'tf', '3_saxxy.png', 'Gold Saxxy'),
('splendid_screen', 1, 0, 'tf', '1_splendid_screen.png', 'Bronze Splendid Screen'),
('splendid_screen', 5, 0, 'tf', '2_splendid_screen.png', 'Silver Splendid Screen'),
('splendid_screen', 10, 0, 'tf', '3_splendid_screen.png', 'Gold Splendid Screen'),
('taunt_soldier_lumbricus', 1, 0, 'tf', '1_taunt_soldier_lumbricus.png', 'Bronze Kamikaze (Lumbricus Lid)'),
('taunt_soldier_lumbricus', 5, 0, 'tf', '2_taunt_soldier_lumbricus.png', 'Silver Kamikaze (Lumbricus Lid)'),
('taunt_soldier_lumbricus', 10, 0, 'tf', '3_taunt_soldier_lumbricus.png', 'Gold Kamikaze (Lumbricus Lid)'),
('nessieclub', 1, 0, 'tf', '1_nessieclub.png', 'Bronze Nessie\'s Nine Iron'),
('nessieclub', 5, 0, 'tf', '2_nessieclub.png', 'Silver Nessie\'s Nine Iron'),
('nessieclub', 10, 0, 'tf', '3_nessieclub.png', 'Gold Nessie\'s Nine Iron'),
('mailbox', 1, 0, 'tf', '1_mailbox.png', 'Bronze Postal Pummeler'),
('mailbox', 5, 0, 'tf', '2_mailbox.png', 'Silver Postal Pummeler'),
('mailbox', 10, 0, 'tf', '3_mailbox.png', 'Gold Postal Pummeler'),
('scout_extinguish', 1, 0, 'tf', '1_scout_extinguish.png', 'Bronze Scout Extinguish'),
('scout_extinguish', 5, 0, 'tf', '2_scout_extinguish.png', 'Silver Scout Extinguish'),
('scout_extinguish', 10, 0, 'tf', '3_scout_extinguish.png', 'Gold Scout Extinguish'),
('cow_mangler', 1, 0, 'tf', '1_cow_mangler.png', 'Bronze Cow Mangler 5000'),
('cow_mangler', 5, 0, 'tf', '2_cow_mangler.png', 'Silver Cow Mangler 5000'),
('cow_mangler', 10, 0, 'tf', '3_cow_mangler.png', 'Gold Cow Mangler 5000'),
('righteous_bison', 1, 0, 'tf', '1_righteous_bison.png', 'Bronze Righteous Bison'),
('righteous_bison', 5, 0, 'tf', '2_righteous_bison.png', 'Silver Righteous Bison'),
('righteous_bison', 10, 0, 'tf', '3_righteous_bison.png', 'Gold Righteous Bison'),
('tf_projectile_energy_ball', 1, 0, 'tf', '1_tf_projectile_energy_ball.png', 'Bronze Deflected Cow Mangler Shot'),
('tf_projectile_energy_ball', 5, 0, 'tf', '2_tf_projectile_energy_ball.png', 'Silver Deflected Cow Mangler Shot'),
('tf_projectile_energy_ball', 10, 0, 'tf', '3_tf_projectile_energy_ball.png', 'Gold Deflected Cow Mangler Shot'),
('machina', 1, 0, 'tf', '1_machina.png', 'Bronze Machina'),
('machina', 5, 0, 'tf', '2_machina.png', 'Silver Machina'),
('machina', 10, 0, 'tf', '3_machina.png', 'Gold Machina'),
('diamondback', 1, 0, 'tf', '1_diamondback.png', 'Bronze The Diamondback'),
('diamondback', 5, 0, 'tf', '2_diamondback.png', 'Silver The Diamondback'),
('diamondback', 10, 0, 'tf', '3_diamondback.png', 'Gold The Diamondback'),
('widowmaker', 1, 0, 'tf', '1_widowmaker.png', 'Bronze The Widowmaker'),
('widowmaker', 5, 0, 'tf', '2_widowmaker.png', 'Silver The Widowmaker'),
('widowmaker', 10, 0, 'tf', '3_widowmaker.png', 'Gold The Widowmaker'),
('short_circuit', 1, 0, 'tf', '1_short_circuit.png', 'Bronze The Short Circuit'),
('short_circuit', 5, 0, 'tf', '2_short_circuit.png', 'Silver The Short Circuit'),
('short_circuit', 10, 0, 'tf', '3_short_circuit.png', 'Gold The Short Circuit'),
('quake_rl', 1, 0, 'tf', '1_quake_rl.png', 'Bronze Original'),
('quake_rl', 5, 0, 'tf', '2_quake_rl.png', 'Silver Original'),
('quake_rl', 10, 0, 'tf', '3_quake_rl.png', 'Gold Original'),
('scotland_shard', 1, 0, 'tf', '1_scotland_shard.png', 'Bronze Scottish Handshake'),
('scotland_shard', 5, 0, 'tf', '2_scotland_shard.png', 'Silver Scottish Handshake'),
('scotland_shard', 10, 0, 'tf', '3_scotland_shard.png', 'Gold Scottish Handshake'),
('nonnonviolent_protest', 1, 0, 'tf', '1_nonnonviolent_protest.png', 'Bronze Conscientious Objector'),
('nonnonviolent_protest', 5, 0, 'tf', '2_nonnonviolent_protest.png', 'Silver Conscientious Objector'),
('nonnonviolent_protest', 10, 0, 'tf', '3_nonnonviolent_protest.png', 'Gold Conscientious Objector'),
('deflect_flare_detonator', 1, 0, 'tf', '1_deflect_flare_detonator.png', 'Bronze Deflected Flare (Detonator)'),
('deflect_flare_detonator', 5, 0, 'tf', '2_deflect_flare_detonator.png', 'Silver Deflected Flare (Detonator)'),
('deflect_flare_detonator', 10, 0, 'tf', '3_deflect_flare_detonator.png', 'Gold Deflected Flare (Detonator)'),
('deflect_huntsman_flyingburn', 1, 0, 'tf', '1_deflect_huntsman_flyingburn.png', 'Bronze Deflected Huntsman Burning Arrow'),
('deflect_huntsman_flyingburn', 5, 0, 'tf', '2_deflect_huntsman_flyingburn.png', 'Silver Deflected Huntsman Burning Arrow'),
('deflect_huntsman_flyingburn', 10, 0, 'tf', '3_deflect_huntsman_flyingburn.png', 'Gold Deflected Huntsman Burning Arrow'),
('unarmed_combat', 1, 0, 'tf', '1_unarmed_combat.png', 'Bronze Unarmed Combat'),
('unarmed_combat', 5, 0, 'tf', '2_unarmed_combat.png', 'Silver Unarmed Combat'),
('unarmed_combat', 10, 0, 'tf', '3_unarmed_combat.png', 'Gold Unarmed Combat'),
('player_penetration', 1, 0, 'tf', '1_player_penetration.png', 'Bronze Player Penetration'),
('player_penetration', 5, 0, 'tf', '2_player_penetration.png', 'Silver Player Penetration'),
('player_penetration', 10, 0, 'tf', '3_player_penetration.png', 'Gold Player Penetration'),
('builtobject_obj_teleporter', 1, 0, 'tf', '1_builtobject_obj_teleporter.png', 'Bronze Teleporters Built'),
('builtobject_obj_teleporter', 5, 0, 'tf', '2_builtobject_obj_teleporter.png', 'Silver Teleporters Built'),
('builtobject_obj_teleporter', 10, 0, 'tf', '3_builtobject_obj_teleporter.png', 'Gold Teleporters Built'),
('death_sawblade', 1, 0, 'tf', '1_death_sawblade.png', 'Bronze Deaths to Sawblade'),
('death_sawblade', 5, 0, 'tf', '2_death_sawblade.png', 'Silver Deaths to Sawblade'),
('death_sawblade', 10, 0, 'tf', '3_death_sawblade.png', 'Gold Deaths to Sawblade'),
('killedobject_obj_attachment_sapper', 1, 0, 'tf', '1_killedobject_obj_attachment_sapper.png', 'Bronze Sappers Removed'),
('killedobject_obj_attachment_sapper', 5, 0, 'tf', '2_killedobject_obj_attachment_sapper.png', 'Silver Sappers Removed'),
('killedobject_obj_attachment_sapper', 10, 0, 'tf', '3_killedobject_obj_attachment_sapper.png', 'Gold Sappers Removed'),
('killedobject_obj_teleporter', 1, 0, 'tf', '1_killedobject_obj_teleporter.png', 'Bronze Teleporters Killed'),
('killedobject_obj_teleporter', 5, 0, 'tf', '2_killedobject_obj_teleporter.png', 'Silver Teleporters Killed'),
('killedobject_obj_teleporter', 10, 0, 'tf', '3_killedobject_obj_teleporter.png', 'Gold Teleporters Killed'),
('eureka_effect', 1, 0, 'tf', '1_eureka_effect.png', 'Bronze Eureka Effect'),
('eureka_effect', 5, 0, 'tf', '2_eureka_effect.png', 'Silver Eureka Effect'),
('eureka_effect', 10, 0, 'tf', '3_eureka_effect.png', 'Gold Eureka Effect'),
('holiday_punch', 1, 0, 'tf', '1_holiday_punch.png', 'Bronze Holiday Punch'),
('holiday_punch', 5, 0, 'tf', '2_holiday_punch.png', 'Silver Holiday Punch'),
('holiday_punch', 10, 0, 'tf', '3_holiday_punch.png', 'Gold Holiday Punch'),
('manmelter', 1, 0, 'tf', '1_manmelter.png', 'Bronze Manmelter'),
('manmelter', 5, 0, 'tf', '2_manmelter.png', 'Silver Manmelter'),
('manmelter', 10, 0, 'tf', '3_manmelter.png', 'Gold Manmelter'),
('phlogistinator', 1, 0, 'tf', '1_phlogistinator.png', 'Bronze Phlogistinator'),
('phlogistinator', 5, 0, 'tf', '2_phlogistinator.png', 'Silver Phlogistinator'),
('phlogistinator', 10, 0, 'tf', '3_phlogistinator.png', 'Gold Phlogistinator'),
('pomson', 1, 0, 'tf', '1_pomson.png', 'Bronze Pomson 6000'),
('pomson', 5, 0, 'tf', '2_pomson.png', 'Silver Pomson 6000'),
('pomson', 10, 0, 'tf', '3_pomson.png', 'Gold Pomson 6000'),
('spy_cicle', 1, 0, 'tf', '1_spy_cicle.png', 'Bronze Spy-cicle'),
('spy_cicle', 5, 0, 'tf', '2_spy_cicle.png', 'Silver Spy-cicle'),
('spy_cicle', 10, 0, 'tf', '3_spy_cicle.png', 'Gold Spy-cicle'),
('thirddegree', 1, 0, 'tf', '1_thirddegree.png', 'Bronze Third Degree'),
('thirddegree', 5, 0, 'tf', '2_thirddegree.png', 'Silver Third Degree'),
('thirddegree', 10, 0, 'tf', '3_thirddegree.png', 'Gold Third Degree'),
('wrap_assassin', 1, 0, 'tf', '1_wrap_assassin.png', 'Bronze Wrap Assassin'),
('wrap_assassin', 5, 0, 'tf', '2_wrap_assassin.png', 'Silver Wrap Assassin'),
('wrap_assassin', 10, 0, 'tf', '3_wrap_assassin.png', 'Gold Wrap Assassin'),
('pep_pistol', 1, 0, 'tf', '1_pep_pistol.png', 'Bronze Pretty Boy\'s Pocket Pistol '),
('pep_pistol', 5, 0, 'tf', '2_pep_pistol.png', 'Silver Pretty Boy\'s Pocket Pistol '),
('pep_pistol', 10, 0, 'tf', '3_pep_pistol.png', 'Gold Pretty Boy\'s Pocket Pistol '),
('pep_brawlerblaster', 1, 0, 'tf', '1_pep_brawlerblaster.png', 'Bronze Baby Face\'s Blaster'),
('pep_brawlerblaster', 5, 0, 'tf', '2_pep_brawlerblaster.png', 'Silver Baby Face\'s Blaster'),
('pep_brawlerblaster', 10, 0, 'tf', '3_pep_brawlerblaster.png', 'Gold Baby Face\'s Blaster'),
('dumpster_device', 1, 0, 'tf', '1_dumpster_device.png', 'Bronze Beggar\'s Bazooka'),
('dumpster_device', 5, 0, 'tf', '2_dumpster_device.png', 'Silver Beggar\'s Bazooka'),
('dumpster_device', 10, 0, 'tf', '3_dumpster_device.png', 'Gold Beggar\'s Bazooka'),
('pro_smg', 1, 0, 'tf', '1_pro_smg.png', 'Bronze The Cleaner\'s Carbine'),
('pro_smg', 5, 0, 'tf', '2_pro_smg.png', 'Silver The Cleaner\'s Carbine'),
('pro_smg', 10, 0, 'tf', '3_pro_smg.png', 'Gold The Cleaner\'s Carbine'),
('pro_rifle', 1, 0, 'tf', '1_pro_rifle.png', 'Bronze The Hitman\'s Heatmaker'),
('pro_rifle', 5, 0, 'tf', '2_pro_rifle.png', 'Silver The Hitman\'s Heatmaker'),
('pro_rifle', 10, 0, 'tf', '3_pro_rifle.png', 'Gold The Hitman\'s Heatmaker'),
('rainblower', 1, 0, 'tf', '1_rainblower.png', 'Bronze The Rainblower'),
('rainblower', 5, 0, 'tf', '2_rainblower.png', 'Silver The Rainblower'),
('rainblower', 10, 0, 'tf', '3_rainblower.png', 'Gold The Rainblower'),
('lollichop', 1, 0, 'tf', '1_lollichop.png', 'Bronze The Lollichop'),
('lollichop', 5, 0, 'tf', '2_lollichop.png', 'Silver The Lollichop'),
('lollichop', 10, 0, 'tf', '3_lollichop.png', 'Gold The Lollichop'),
('scorchshot', 1, 0, 'tf', '1_scorchshot.png', 'Bronze The Scorch Shot'),
('scorchshot', 5, 0, 'tf', '2_scorchshot.png', 'Silver The Scorch Shot'),
('scorchshot', 10, 0, 'tf', '3_scorchshot.png', 'Gold The Scorch Shot'),
('unique_pickaxe_escape', 1, 0, 'tf', '1_unique_pickaxe_escape.png', 'Bronze The Escape Plan'),
('unique_pickaxe_escape', 5, 0, 'tf', '2_unique_pickaxe_escape.png', 'Silver The Escape Plan'),
('unique_pickaxe_escape', 10, 0, 'tf', '3_unique_pickaxe_escape.png', 'Gold The Escape Plan'),
('*total connection hours*',168,2,'insmod','1waward.png','Connection Time 1 Week '),
('weapon_makarov',5,0,'insmod','rs_makarov.png','Silver Makarov'),
('weapon_m9',5,0,'insmod','rs_m9.png','Silver 9mm Beretta'),
('world',5,0,'insmod','rs_world.png','Silver RPG or Grenade'),
('weapon_sks',5,0,'insmod','rs_sks.png','Silver Simonov SKS carbine'),
('weapon_m1014',5,0,'insmod','rs_m1014.png','Silver M1014 Shotgun'),
('weapon_toz',5,0,'insmod','rs_toz.png','Silver TOZ Rifle'),
('weapon_svd',5,0,'insmod','rs_svd.png','Silver Dragunov Sniper Rifle'),
('weapon_rpk',5,0,'insmod','rs_rpk.png','Silver RPK'),
('weapon_m249',5,0,'insmod','rs_m249.png','Silver M249 SAW'),
('weapon_m16m203',5,0,'insmod','rs_m16m203.png','Silver M16 & M203'),
('weapon_l42a1',5,0,'insmod','rs_l42a1.png','Silver Enfield L42A1 Sniper Rifle'),
('weapon_m4med',5,0,'insmod','rs_m4med.png','Silver M4 Medium Range Rifle'),
('weapon_m4',5,0,'insmod','rs_m4.png','Silver M4 Carbine Rifle'),
('weapon_m16a4',5,0,'insmod','rs_m16a4.png','Silver M16A4 Infantry Rifle'),
('weapon_m14',5,0,'insmod','rs_m14.png','Silver M14 Infantry Rifle'),
('weapon_fnfal',5,0,'insmod','rs_fnfal.png','Silver FN FAL Automatic Rifle'),
('weapon_aks74u',5,0,'insmod','rs_aks74u.png','Silver AKS-74U'),
('weapon_ak47',5,0,'insmod','rs_ak47.png','Silver AK-47'),
('weapon_makarov',10,0,'insmod','rg_makarov.png','Gold Makarov'),
('weapon_m9',10,0,'insmod','rg_m9.png','Gold 9mm Beretta'),
('world',10,0,'insmod','rg_world.png','Gold RPG or Grenade'),
('weapon_sks',10,0,'insmod','rg_sks.png','Gold Simonov SKS carbine'),
('weapon_m1014',10,0,'insmod','rg_m1014.png','Gold M1014 Shotgun'),
('weapon_toz',10,0,'insmod','rg_toz.png','Gold TOZ Rifle'),
('weapon_svd',10,0,'insmod','rg_svd.png','Gold Dragunov Sniper Rifle'),
('weapon_rpk',10,0,'insmod','rg_rpk.png','Gold RPK'),
('weapon_m249',10,0,'insmod','rg_m249.png','Gold M249 SAW'),
('weapon_m16m203',10,0,'insmod','rg_m16m203.png','Gold M16 & M203'),
('weapon_l42a1',10,0,'insmod','rg_l42a1.png','Gold Enfield L42A1 Sniper Rifle'),
('weapon_m4med',10,0,'insmod','rg_m4med.png','Gold M4 Medium Range Rifle'),
('weapon_m4',10,0,'insmod','rg_m4.png','Gold M4 Carbine Rifle'),
('weapon_m16a4',10,0,'insmod','rg_m16a4.png','Gold M16A4 Infantry Rifle'),
('weapon_m14',10,0,'insmod','rg_m14.png','Gold M14 Infantry Rifle'),
('weapon_fnfal',10,0,'insmod','rg_fnfal.png','Gold FN FAL Automatic Rifle'),
('weapon_aks74u',10,0,'insmod','rg_aks74u.png','Gold AKS-74U'),
('weapon_ak47',10,0,'insmod','rg_ak47.png','Gold AK-47'),
('boomer_claw', '5', '0', 'l4d', '1_boomer_claw.png', 'Bronze Boom!'),
('headshot', '5', '0', 'l4d', '1_headshot.png', 'Bronze Brain Salad'),
('healed_teammate', '5', '0', 'l4d', '1_healed_teammate.png', 'Bronze Field Medic'),
('hunter_claw', '5', '0', 'l4d', '1_hunter_claw.png', 'Bronze Grim Reaper'),
('inferno', '5', '0', 'l4d', '1_inferno.png', 'Bronze Cremator'),
('killed_exploding', '5', '0', 'l4d', '1_killed_exploding.png', 'Bronze Stomach Upset'),
('killed_gas', '5', '0', 'l4d', '1_killed_gas.png', 'Bronze Tongue Twister'),
('killed_hunter', '5', '0', 'l4d', '1_killed_hunter.png', 'Bronze Hunter Punter'),
('killed_survivor', '5', '0', 'l4d', '1_killed_survivor.png', 'Bronze Dead Wreckening'),
('killed_tank', '5', '0', 'l4d', '1_killed_tank.png', 'Bronze Tankbuster'),
('killed_witch', '5', '0', 'l4d', '1_killed_witch.png', 'Bronze Inquisitor'),
('latency', '5', '0', 'l4d', '1_latency.png', 'Bronze Nothing Special'),
('pipe_bomb', '5', '0', 'l4d', '1_pipe_bomb.png', 'Bronze Pyrotechnician'),
('pounce', '5', '0', 'l4d', '1_pounce.png', 'Bronze Free 2 Fly'),
('rescued_survivor', '5', '0', 'l4d', '1_rescued_survivor.png', 'Bronze Ground Cover'),
('revived_teammate', '5', '0', 'l4d', '1_revived_teammate.png', 'Bronze Helping Hand'),
('smoker_claw', '5', '0', 'l4d', '1_smoker_claw.png', 'Bronze Chain Smoker'),
('tank_claw', '5', '0', 'l4d', '1_tank_claw.png', 'Bronze Lambs 2 Slaughter'),
('tongue_grab', '5', '0', 'l4d', '1_tongue_grab.png', 'Bronze Drag &amp; Drop'),
('vomit', '5', '0', 'l4d', '1_vomit.png', 'Bronze Barf Bagged'),
('boomer_claw', '15', '0', 'l4d', '2_boomer_claw.png', 'Silver Boom!'),
('headshot', '15', '0', 'l4d', '2_headshot.png', 'Silver Brain Salad'),
('healed_teammate', '15', '0', 'l4d', '2_healed_teammate.png', 'Silver Field Medic'),
('hunter_claw', '15', '0', 'l4d', '2_hunter_claw.png', 'Silver Grim Reaper'),
('inferno', '15', '0', 'l4d', '2_inferno.png', 'Silver Cremator'),
('killed_exploding', '15', '0', 'l4d', '2_killed_exploding.png', 'Silver Stomach Upset'),
('killed_gas', '15', '0', 'l4d', '2_killed_gas.png', 'Silver Tongue Twister'),
('killed_hunter', '15', '0', 'l4d', '2_killed_hunter.png', 'Silver Hunter Punter'),
('killed_survivor', '15', '0', 'l4d', '2_killed_survivor.png', 'Silver Dead Wreckening'),
('killed_tank', '15', '0', 'l4d', '2_killed_tank.png', 'Silver Tankbuster'),
('killed_witch', '15', '0', 'l4d', '2_killed_witch.png', 'Silver Inquisitor'),
('latency', '15', '0', 'l4d', '2_latency.png', 'Silver Nothing Special'),
('pipe_bomb', '15', '0', 'l4d', '2_pipe_bomb.png', 'Silver Pyrotechnician'),
('pounce', '15', '0', 'l4d', '2_pounce.png', 'Silver Free 2 Fly'),
('rescued_survivor', '15', '0', 'l4d', '2_rescued_survivor.png', 'Silver Ground Cover'),
('revived_teammate', '15', '0', 'l4d', '2_revived_teammate.png', 'Silver Helping Hand'),
('smoker_claw', '15', '0', 'l4d', '2_smoker_claw.png', 'Silver Chain Smoker'),
('tank_claw', '15', '0', 'l4d', '2_tank_claw.png', 'Silver Lambs 2 Slaughter'),
('tongue_grab', '15', '0', 'l4d', '2_tongue_grab.png', 'Silver Drag &amp; Drop'),
('vomit', '15', '0', 'l4d', '2_vomit.png', 'Silver Barf Bagged'),
('boomer_claw', '30', '0', 'l4d', '3_boomer_claw.png', 'Golden Boom!'),
('headshot', '30', '0', 'l4d', '3_headshot.png', 'Golden Brain Salad'),
('healed_teammate', '30', '0', 'l4d', '3_healed_teammate.png', 'Golden Field Medic'),
('hunter_claw', '30', '0', 'l4d', '3_hunter_claw.png', 'Golden Grim Reaper'),
('inferno', '30', '0', 'l4d', '3_inferno.png', 'Golden Cremator'),
('killed_exploding', '30', '0', 'l4d', '3_killed_exploding.png', 'Golden Stomach Upset'),
('killed_gas', '30', '0', 'l4d', '3_killed_gas.png', 'Golden Tongue Twister'),
('killed_hunter', '30', '0', 'l4d', '3_killed_hunter.png', 'Golden Hunter Punter'),
('killed_survivor', '30', '0', 'l4d', '3_killed_survivor.png', 'Golden Dead Wreckening'),
('killed_tank', '30', '0', 'l4d', '3_killed_tank.png', 'Golden Tankbuster'),
('killed_witch', '30', '0', 'l4d', '3_killed_witch.png', 'Golden Inquisitor'),
('latency', '30', '0', 'l4d', '3_latency.png', 'Golden Nothing Special'),
('pipe_bomb', '30', '0', 'l4d', '3_pipe_bomb.png', 'Golden Pyrotechnician'),
('pounce', '30', '0', 'l4d', '3_pounce.png', 'Golden Free 2 Fly'),
('rescued_survivor', '30', '0', 'l4d', '3_rescued_survivor.png', 'Golden Ground Cover'),
('revived_teammate', '30', '0', 'l4d', '3_revived_teammate.png', 'Golden Helping Hand'),
('smoker_claw', '30', '0', 'l4d', '3_smoker_claw.png', 'Golden Chain Smoker'),
('tank_claw', '30', '0', 'l4d', '3_tank_claw.png', 'Golden Lambs 2 Slaughter'),
('tongue_grab', '30', '0', 'l4d', '3_tongue_grab.png', 'Golden Drag &amp; Drop'),
('vomit', '30', '0', 'l4d', '3_vomit.png', 'Golden Barf Bagged'),
('boomer_claw', '50', '0', 'l4d', '4_boomer_claw.png', 'Bloody Boom!'),
('headshot', '50', '0', 'l4d', '4_headshot.png', 'Bloody Brain Salad'),
('healed_teammate', '50', '0', 'l4d', '4_healed_teammate.png', 'Bloody Field Medic'),
('hunter_claw', '50', '0', 'l4d', '4_hunter_claw.png', 'Bloody Grim Reaper'),
('inferno', '50', '0', 'l4d', '4_inferno.png', 'Bloody Cremator'),
('killed_exploding', '50', '0', 'l4d', '4_killed_exploding.png', 'Bloody Stomach Upset'),
('killed_gas', '50', '0', 'l4d', '4_killed_gas.png', 'Bloody Tongue Twister'),
('killed_hunter', '50', '0', 'l4d', '4_killed_hunter.png', 'Bloody Hunter Punter'),
('killed_survivor', '50', '0', 'l4d', '4_killed_survivor.png', 'Bloody Dead Wreckening'),
('killed_tank', '50', '0', 'l4d', '4_killed_tank.png', 'Bloody Tankbuster'),
('killed_witch', '50', '0', 'l4d', '4_killed_witch.png', 'Bloody Inquisitor'),
('latency', '50', '0', 'l4d', '4_latency.png', 'Bloody Nothing Special'),
('pipe_bomb', '50', '0', 'l4d', '4_pipe_bomb.png', 'Bloody Pyrotechnician'),
('pounce', '50', '0', 'l4d', '4_pounce.png', 'Bloody Free 2 Fly'),
('rescued_survivor', '50', '0', 'l4d', '4_rescued_survivor.png', 'Bloody Ground Cover'),
('revived_teammate', '50', '0', 'l4d', '4_revived_teammate.png', 'Bloody Helping Hand'),
('smoker_claw', '50', '0', 'l4d', '4_smoker_claw.png', 'Bloody Chain Smoker'),
('tank_claw', '50', '0', 'l4d', '4_tank_claw.png', 'Bloody Lambs 2 Slaughter'),
('tongue_grab', '50', '0', 'l4d', '4_tongue_grab.png', 'Bloody Drag &amp; Drop'),
('vomit', '50', '0', 'l4d', '4_vomit.png', 'Bloody Barf Bagged'),
('ak47',1,0,'cstrike','1_ak47.png','Award of AK47'),
('awp',1,0,'cstrike','1_awp.png','Award of AWP Sniper'),
('deagle',1,0,'cstrike','1_deagle.png','Award of Desert Eagle'),
('elite',1,0,'cstrike','1_elite.png','Award of Dual Beretta Elites'),
('famas',1,0,'cstrike','1_famas.png','Award of Fusil Automatique'),
('galil',1,0,'cstrike','1_galil.png','Award of Galil'),
('glock18',1,0,'cstrike','1_glock.png','Award of Glock'),
('grenade',1,0,'cstrike','1_hegrenade.png','Award of Grenade'),
('knife',1,0,'cstrike','1_knife.png','Award of Combat Knife'),
('latency',1,0,'cstrike','1_latency.png','Award of Lowpinger'),
('m3',1,0,'cstrike','1_m3.png','Award of M3 Super'),
('m4a1',1,0,'cstrike','1_m4a1.png','Award of Colt M4A1'),
('p90',1,0,'cstrike','1_p90.png','Award of P90'),
('scout',1,0,'cstrike','1_scout.png','Award of Scout Elite'),
('usp',1,0,'cstrike','1_usp.png','Award of USP'),
('Defused_The_Bomb',1,0,'cstrike','1_defused_the_bomb.png','Award of Bomb Defuser'),
('Planted_The_Bomb',1,0,'cstrike','1_planted_the_bomb.png','Award of Bomb Planter'),
('Rescued_A_Hostage',1,0,'cstrike','1_rescued_a_hostage.png','Award of Hostage Rescuer'),
('Assassinated_The_VIP',1,0,'cstrike','1_killed_a_hostage.png','Award of Top Assassin'),
('ak47',5,0,'cstrike','2_ak47.png','Bronze AK47'),
('awp',5,0,'cstrike','2_awp.png','Bronze AWP Sniper'),
('deagle',5,0,'cstrike','2_deagle.png','Bronze Desert Eagle'),
('elite',5,0,'cstrike','2_elite.png','Bronze Dual Beretta Elites'),
('famas',5,0,'cstrike','2_famas.png','Bronze Fusil Automatique'),
('galil',5,0,'cstrike','2_galil.png','Bronze Galil'),
('glock18',5,0,'cstrike','2_glock.png','Bronze Glock'),
('grenade',5,0,'cstrike','2_hegrenade.png','Bronze Grenade'),
('knife',5,0,'cstrike','2_knife.png','Bronze Combat Knife'),
('latency',5,0,'cstrike','2_latency.png','Bronze Lowpinger'),
('m3',5,0,'cstrike','2_m3.png','Bronze Award M3 Super'),
('m4a1',5,0,'cstrike','2_m4a1.png','Bronze AColt M4A1'),
('p90',5,0,'cstrike','2_p90.png','Bronze P90'),
('scout',5,0,'cstrike','2_scout.png','Bronze Scout Elite'),
('usp',5,0,'cstrike','2_usp.png','Bronze USP'),
('Defused_The_Bomb',5,0,'cstrike','2_defused_the_bomb.png','Bronze Bomb Defuser'),
('Planted_The_Bomb',5,0,'cstrike','2_planted_the_bomb.png','Bronze Bomb Planter'),
('Rescued_A_Hostage',5,0,'cstrike','2_rescued_a_hostage.png','Bronze Hostage Rescuer'),
('Assassinated_The_VIP',5,0,'cstrike','2_killed_a_hostage.png','Bronze Top Assassin'),
('ak47',12,0,'cstrike','3_ak47.png','Silver AK47'),
('awp',12,0,'cstrike','3_awp.png','Silver Sniper'),
('deagle',12,0,'cstrike','3_deagle.png','Silver Desert Eagle'),
('elite',12,0,'cstrike','3_elite.png','Silver Dual Beretta Elites'),
('famas',12,0,'cstrike','3_famas.png','Silver Fusil Automatique'),
('galil',12,0,'cstrike','3_galil.png','Silver Galil'),
('glock18',12,0,'cstrike','3_glock.png','Silver Glock'),
('grenade',12,0,'cstrike','3_hegrenade.png','Silver Grenade'),
('knife',12,0,'cstrike','3_knife.png','Silver Combat Knife'),
('latency',12,0,'cstrike','3_latency.png','Silver Lowpinger'),
('m3',12,0,'cstrike','3_m3.png','Silver M3 Super'),
('m4a1',12,0,'cstrike','3_m4a1.png','Silver Colt M4A1'),
('p90',12,0,'cstrike','3_p90.png','Silver P90'),
('scout',12,0,'cstrike','3_scout.png','Silver Scout Elite'),
('usp',12,0,'cstrike','3_usp.png','Silver USP'),
('Defused_The_Bomb',12,0,'cstrike','3_defused_the_bomb.png','Silver Bomb Defuser'),
('Planted_The_Bomb',12,0,'cstrike','3_planted_the_bomb.png','Silver Bomb Planter'),
('Rescued_A_Hostage',12,0,'cstrike','3_rescued_a_hostage.png','Silver Hostage Rescuer'),
('Assassinated_The_VIP',12,0,'cstrike','3_killed_a_hostage.png','Silver Top Assassin'),
('ak47',20,0,'cstrike','4_ak47.png','Gold AK47'),
('awp',20,0,'cstrike','4_awp.png','Gold AWP Sniper'),
('deagle',20,0,'cstrike','4_deagle.png','Gold Desert Eagle'),
('elite',20,0,'cstrike','4_elite.png','Gold Dual Beretta Elites'),
('famas',20,0,'cstrike','4_famas.png','Gold Fusil Automatique'),
('galil',20,0,'cstrike','4_galil.png','GoldGalil'),
('glock18',20,0,'cstrike','4_glock.png','Gold Glock'),
('grenade',20,0,'cstrike','4_hegrenade.png','Gold Grenade'),
('knife',20,0,'cstrike','4_knife.png','Gold Combat Knife'),
('latency',20,0,'cstrike','4_latency.png','Gold Lowpinger'),
('m3',20,0,'cstrike','4_m3.png','Gold M3 Super'),
('m4a1',20,0,'cstrike','4_m4a1.png','Gold Colt M4A1'),
('p90',20,0,'cstrike','4_p90.png','Gold P90'),
('scout',20,0,'cstrike','4_scout.png','Gold Scout Elite'),
('usp',20,0,'cstrike','4_usp.png','Gold USP'),
('Defused_The_Bomb',20,0,'cstrike','4_defused_the_bomb.png','Gold Bomb Defuser'),
('Planted_The_Bomb',20,0,'cstrike','4_planted_the_bomb.png','Gold Bomb Planter'),
('Rescued_A_Hostage',20,0,'cstrike','4_rescued_a_hostage.png','Gold Hostage Rescuer'),
('Assassinated_The_VIP',20,0,'cstrike','4_killed_a_hostage.png','Gold Top Assassin'),
('ak47',30,0,'cstrike','5_ak47.png','Platinum AK47'),
('awp',30,0,'cstrike','5_awp.png','Platinum AWP Sniper'),
('deagle',30,0,'cstrike','5_deagle.png','Platinum Desert Eagle'),
('elite',30,0,'cstrike','5_elite.png','Platinum Dual Beretta Elites'),
('famas',30,0,'cstrike','5_famas.png','Platinum Fusil Automatique'),
('galil',30,0,'cstrike','5_galil.png','Platinum Galil'),
('glock18',30,0,'cstrike','5_glock.png','Platinum Glock'),
('grenade',30,0,'cstrike','5_hegrenade.png','Platinum Grenade'),
('knife',30,0,'cstrike','5_knife.png','PlatinumCombat Knife'),
('latency',30,0,'cstrike','5_latency.png','PlatinumLowpinger'),
('m3',30,0,'cstrike','5_m3.png','Platinum M3 Super'),
('m4a1',30,0,'cstrike','5_m4a1.png','Platinum Colt M4A1'),
('p90',30,0,'cstrike','5_p90.png','Platinum P90'),
('scout',30,0,'cstrike','5_scout.png','Platinum Scout Elite'),
('usp',30,0,'cstrike','5_usp.png','Platinum USP'),
('Defused_The_Bomb',30,0,'cstrike','5_defused_the_bomb.png','Platinum Bomb Defuser'),
('Planted_The_Bomb',30,0,'cstrike','5_planted_the_bomb.png','Platinum Bomb Planter'),
('Rescued_A_Hostage',30,0,'cstrike','5_rescued_a_hostage.png','Platinum Hostage Rescuer'),
('Assassinated_The_VIP',30,0,'cstrike','5_killed_a_hostage.png','Platinum Top Assassin'),
('ak47',50,0,'cstrike','6_ak47.png','Supreme AK47'),
('awp',50,0,'cstrike','6_awp.png','Supreme AWP Sniper'),
('deagle',50,0,'cstrike','6_deagle.png','Supremef Desert Eagle'),
('elite',50,0,'cstrike','6_elite.png','Supreme Dual Beretta Elites'),
('famas',50,0,'cstrike','6_famas.png','Supreme Fusil Automatique'),
('galil',50,0,'cstrike','6_galil.png','Supreme Galil'),
('glock18',50,0,'cstrike','6_glock.png','Supreme Glock'),
('grenade',50,0,'cstrike','6_hegrenade.png','Supreme Grenade'),
('knife',50,0,'cstrike','6_knife.png','Supreme Combat Knife'),
('latency',50,0,'cstrike','6_latency.png','Supreme Lowpinger'),
('m3',50,0,'cstrike','6_m3.png','Supreme M3 Super'),
('m4a1',50,0,'cstrike','6_m4a1.png','Supreme Colt M4A1'),
('p90',50,0,'cstrike','6_p90.png','Supremef P90'),
('scout',50,0,'cstrike','6_scout.png','Supreme Scout Elite'),
('usp',50,0,'cstrike','6_usp.png','Supreme USP'),
('Defused_The_Bomb',50,0,'cstrike','6_defused_the_bomb.png','Supreme Bomb Defuser'),
('Planted_The_Bomb',50,0,'cstrike','6_planted_the_bomb.png','Supreme Bomb Planter'),
('Rescued_A_Hostage',50,0,'cstrike','6_rescued_a_hostage.png','Supreme Hostage Rescuer'),
('Assassinated_The_VIP',50,0,'cstrike','6_killed_a_hostage.png','Supreme Top Assassin'),
('aa13', 1, 0, 'nts', '1_aa13.png', 'Bronze AA13'),
('aa13', 5, 0, 'nts', '2_aa13.png', 'Silver AA13'),
('aa13', 10, 0, 'nts', '3_aa13.png', 'Gold AA13'),
('grenade_projectile', 1, 0, 'nts', '1_grenade.png', 'Bronze Frag Grenade'),
('grenade_projectile', 5, 0, 'nts', '2_grenade.png', 'Silver Frag Grenade'),
('grenade_projectile', 10, 0, 'nts', '3_grenade.png', 'Gold Frag Grenade'),
('headshot', 1, 0, 'nts', '1_headshot.png', 'Bronze Headshot'),
('headshot', 5, 0, 'nts', '2_headshot.png', 'Silver Headshot'),
('headshot', 10, 0, 'nts', '3_headshot.png', 'Gold Headshot'),
('knife', 1, 0, 'nts', '1_knife.png', 'Bronze Knife'),
('knife', 5, 0, 'nts', '2_knife.png', 'Silver Knife '),
('knife', 10, 0, 'nts', '3_knife.png', 'Gold Knife '),
('kyla', 1, 0, 'nts', '1_kyla9.png', 'Bronze Kyla-9'),
('kyla', 5, 0, 'nts', '2_kyla9.png', 'Silver Kyla-9'),
('kyla', 10, 0, 'nts', '3_kyla9.png', 'Gold Kyla-9'),
('latency', 1, 0, 'nts', '1_latency.png', 'Bronze Best Latency'),
('latency', 5, 0, 'nts', '2_latency.png', 'Silver Best Latency'),
('latency', 10, 0, 'nts', '3_latency.png', 'Gold Best Latency'),
('m41', 1, 0, 'nts', '1_m41.png', 'Bronze M41'),
('m41', 5, 0, 'nts', '2_m41.png', 'Silver M41'),
('m41', 10, 0, 'nts', '3_m41.png', 'Gold M41'),
('m41s', 1, 0, 'nts', '1_m41s.png', 'Bronze M41S'),
('m41s', 5, 0, 'nts', '2_m41s.png', 'Silver M41S'),
('m41s', 10, 0, 'nts', '3_m41s.png', 'Gold M41S'),
('milso', 1, 0, 'nts', '1_milso.png', 'Bronze MilSO'),
('milso', 5, 0, 'nts', '2_milso.png', 'Silver MilSO'),
('milso', 10, 0, 'nts', '3_milso.png', 'Gold MilSO'),
('mostkills', 1, 0, 'nts', '1_mostkills.png', 'Bronze Most Kills'),
('mostkills', 5, 0, 'nts', '2_mostkills.png', 'Silver Most Kills'),
('mostkills', 10, 0, 'nts', '3_mostkills.png', 'Gold Most Kills'),
('mpn', 1, 0, 'nts', '1_mpn45.png', 'Bronze MPN45'),
('mpn', 5, 0, 'nts', '2_mpn45.png', 'Silver MPN45'),
('mpn', 10, 0, 'nts', '3_mpn45.png', 'Gold MPN45'),
('mx', 1, 0, 'nts', '1_mx-5.png', 'Bronze MX'),
('mx', 5, 0, 'nts', '2_mx-5.png', 'Silver MX'),
('mx', 10, 0, 'nts', '3_mx-5.png', 'Gold MX'),
('mx_silenced', 1, 0, 'nts', '1_mxs-5.png', 'Bronze MX Silenced'),
('mx_silenced', 5, 0, 'nts', '2_mxs-5.png', 'Silver MX Silenced'),
('mx_silenced', 10, 0, 'nts', '3_mxs-5.png', 'Gold MX Silenced'),
('supa7', 1, 0, 'nts', '1_supa7.png', 'Bronze MURATA SUPA 7'),
('supa7', 5, 0, 'nts', '2_supa7.png', 'Silver MURATA SUPA 7'),
('supa7', 10, 0, 'nts', '3_supa7.png', 'Gold MURATA SUPA 7'),
('tachi', 1, 0, 'nts', '1_tachi.png', 'Bronze TACHI'),
('tachi', 5, 0, 'nts', '2_tachi.png', 'Silver TACHI'),
('tachi', 10, 0, 'nts', '3_tachi.png', 'Gold TACHI'),
('zr68c', 1, 0, 'nts', '1_zr68c.png', 'Bronze ZR68C'),
('zr68c', 5, 0, 'nts', '2_zr68c.png', 'Silver ZR68C'),
('zr68c', 10, 0, 'nts', '3_zr68c.png', 'Gold ZR68C'),
('zr68l', 1, 0, 'nts', '1_zr68l.png', 'Bronze ZR68L'),
('zr68l', 5, 0, 'nts', '2_zr68l.png', 'Silver ZR68L'),
('zr68l', 10, 0, 'nts', '3_zr68l.png', 'Gold ZR68L'),
('zr68s', 1, 0, 'nts', '1_zr68s.png', 'Bronze ZR68S'),
('zr68s', 5, 0, 'nts', '2_zr68s.png', 'Silver ZR68S'),
('zr68s', 10, 0, 'nts', '3_zr68s.png', 'Gold ZR68S'),
('grenade_detapack', 1, 0, 'nts', '1_rdp.png', 'Bronze Detpack'),
('grenade_detapack', 5, 0, 'nts', '2_rdp.png', 'Silver Detpack'),
('grenade_detapack', 10, 0, 'nts', '3_rdp.png', 'Gold Detpack'),
('pz', 1, 0, 'nts', '1_pz252.png', 'Bronze PZ252'),
('pz', 5, 0, 'nts', '2_pz252.png', 'Silver PZ252'),
('pz', 10, 0, 'nts', '3_pz252.png', 'Gold PZ252'),
('srm', 1, 0, 'nts', '1_srm7.png', 'Bronze SRM'),
('srm', 5, 0, 'nts', '2_srm7.png', 'Silver SRM'),
('srm', 10, 0, 'nts', '3_srm7.png', 'Gold SRM'),
('srm_s', 1, 0, 'nts', '1_srms7.png', 'Bronze SRM-S'),
('srm_s', 5, 0, 'nts', '2_srms7.png', 'Silver SRM-S'),
('srm_s', 10, 0, 'nts', '3_srms7.png', 'Gold SRM-S'),
('srs', 1, 0, 'nts', '1_srs.png', 'Bronze SRS'),
('srs', 5, 0, 'nts', '2_srs.png', 'Silver SRS'),
('srs', 10, 0, 'nts', '3_srs.png', 'Gold SRS'),
('jitte', 1, 0, 'nts', '1_np-721.png', 'Bronze Jitte'),
('jitte', 5, 0, 'nts', '2_np-721.png', 'Silver Jitte'),
('jitte', 10, 0, 'nts', '3_np-721.png', 'Gold Jitte'),
('jittescoped', 1, 0, 'nts', '1_np-721s.png', 'Bronze Jitte (Scoped)'),
('jittescoped', 5, 0, 'nts', '2_np-721s.png', 'Silver Jitte (Scoped)'),
('jittescoped', 10, 0, 'nts', '3_np-721s.png', 'Gold Jitte (Scoped)'),
('*total connection hours*', 25, 2, 'csp', '1_connect.png', 'Connection Time 25 Hours'),
('*total connection hours*', 50, 2, 'csp', '2_connect.png', 'Connection Time 50 Hours'),
('*total connection hours*', 75, 2, 'csp', '3_connect.png', 'Connection Time 75 Hours'),
('*total connection hours*', 100, 2, 'csp', '4_connect.png', 'Connection Time 100 Hours'),
('*total connection hours*', 125, 2, 'csp', '5_connect.png', 'Connection Time 125 Hours'),
('*total connection hours*', 150, 2, 'csp', '6_connect.png', 'Connection Time 150 Hours'),
('ak47', 1, 0, 'csp', '1_ak47.png', 'Award of AK47'),
('ak47', 5, 0, 'csp', '2_ak47.png', 'Bronze AK47'),
('ak47', 12, 0, 'csp', '3_ak47.png', 'Silver AK47'),
('ak47', 20, 0, 'csp', '4_ak47.png', 'Gold AK47'),
('ak47', 30, 0, 'csp', '5_ak47.png', 'Platinum AK47'),
('ak47', 50, 0, 'csp', '6_ak47.png', 'Supreme AK47'),
('awp', 1, 0, 'csp', '1_awp.png', 'Award of AWP Sniper'),
('awp', 5, 0, 'csp', '2_awp.png', 'Bronze AWP Sniper'),
('awp', 12, 0, 'csp', '3_awp.png', 'Silver AWP Sniper'),
('awp', 20, 0, 'csp', '4_awp.png', 'Gold AWP Sniper'),
('awp', 30, 0, 'csp', '5_awp.png', 'Platinum AWP Sniper'),
('awp', 50, 0, 'csp', '6_awp.png', 'Supreme AWP Sniper'),
('deagle', 1, 0, 'csp', '1_deagle.png', 'Award of Desert Eagle'),
('deagle', 5, 0, 'csp', '2_deagle.png', 'Bronze Desert Eagle'),
('deagle', 12, 0, 'csp', '3_deagle.png', 'Silver Desert Eagle'),
('deagle', 20, 0, 'csp', '4_deagle.png', 'Gold Desert Eagle'),
('deagle', 30, 0, 'csp', '5_deagle.png', 'Platinum Desert Eagle'),
('deagle', 50, 0, 'csp', '6_deagle.png', 'Supreme Desert Eagle'),
('glock', 1, 0, 'csp', '1_glock.png', 'Award of Glock'),
('glock', 5, 0, 'csp', '2_glock.png', 'Bronze Glock'),
('glock', 12, 0, 'csp', '3_glock.png', 'Silver Glock'),
('glock', 20, 0, 'csp', '4_glock.png', 'Gold Glock'),
('glock', 30, 0, 'csp', '5_glock.png', 'Platinum Glock'),
('glock', 50, 0, 'csp', '6_glock.png', 'Supreme Glock'),
('hegrenade', 1, 0, 'csp', '1_hegrenade.png', 'Award of HE Grenades'),
('hegrenade', 5, 0, 'csp', '2_hegrenade.png', 'Bronze HE Grenades'),
('hegrenade', 12, 0, 'csp', '3_hegrenade.png', 'Silver HE Grenades'),
('hegrenade', 20, 0, 'csp', '4_hegrenade.png', 'Gold HE Grenades'),
('hegrenade', 30, 0, 'csp', '5_hegrenade.png', 'Platinum HE Grenades'),
('hegrenade', 50, 0, 'csp', '6_hegrenade.png', 'Supreme HE Grenades'),
('knife', 1, 0, 'csp', '1_knife.png', 'Award of Combat Knife'),
('knife', 5, 0, 'csp', '2_knife.png', 'Bronze Combat Knife'),
('knife', 12, 0, 'csp', '3_knife.png', 'Silver Combat Knife'),
('knife', 20, 0, 'csp', '4_knife.png', 'Gold Combat Knife'),
('knife', 30, 0, 'csp', '5_knife.png', 'Platinum Combat Knife'),
('knife', 50, 0, 'csp', '6_knife.png', 'Supreme Combat Knife'),
('usp', 1, 0, 'csp', '1_usp.png', 'Award of USP'),
('usp', 5, 0, 'csp', '2_usp.png', 'Bronze USP'),
('usp', 12, 0, 'csp', '3_usp.png', 'Silver USP'),
('usp', 20, 0, 'csp', '4_usp.png', 'Gold USP'),
('usp', 30, 0, 'csp', '5_usp.png', 'Platinum USP'),
('usp', 50, 0, 'csp', '6_usp.png', 'Supreme USP'),
('m4a1', 1, 0, 'csp', '1_m4a1.png', 'Award of Colt M4A1'),
('m4a1', 5, 0, 'csp', '2_m4a1.png', 'Bronze Colt M4A1'),
('m4a1', 12, 0, 'csp', '3_m4a1.png', 'Silver Colt M4A1'),
('m4a1', 20, 0, 'csp', '4_m4a1.png', 'Gold Colt M4A1'),
('m4a1', 30, 0, 'csp', '5_m4a1.png', 'Platinum Colt M4A1'),
('m4a1', 50, 0, 'csp', '6_m4a1.png', 'Supreme Colt M4A1'),
('mp5navy', 1, 0, 'csp', '1_mp5navy.png', 'Award of MP5 Navy'),
('mp5navy', 5, 0, 'csp', '2_mp5navy.png', 'Bronze MP5 Navy'),
('mp5navy', 12, 0, 'csp', '3_mp5navy.png', 'Silver MP5 Navy'),
('mp5navy', 20, 0, 'csp', '4_mp5navy.png', 'Gold MP5 Navy'),
('mp5navy', 30, 0, 'csp', '5_mp5navy.png', 'Platinum MP5 Navy'),
('mp5navy', 50, 0, 'csp', '6_mp5navy.png', 'Supreme MP5 Navy'),
('galil', 1, 0, 'csp', '1_galil.png', 'Award of Galil'),
('galil', 5, 0, 'csp', '2_galil.png', 'Bronze Galil'),
('galil', 12, 0, 'csp', '3_galil.png', 'Silver Galil'),
('galil', 20, 0, 'csp', '4_galil.png', 'Gold Galil'),
('galil', 30, 0, 'csp', '5_galil.png', 'Platinum Galil'),
('galil', 50, 0, 'csp', '6_galil.png', 'Supreme Galil'),
('famas', 1, 0, 'csp', '1_famas.png', 'Award of Famas'),
('famas', 5, 0, 'csp', '2_famas.png', 'Award of Famas'),
('famas', 12, 0, 'csp', '3_famas.png', 'Award of Famas'),
('famas', 20, 0, 'csp', '4_famas.png', 'Award of Famas'),
('famas', 30, 0, 'csp', '5_famas.png', 'Award of Famas'),
('famas', 50, 0, 'csp', '6_famas.png', 'Award of Famas'),
('latency', 1, 0, 'csp', '1_latency.png', 'Award of Lowpinger'),
('latency', 5, 0, 'csp', '2_latency.png', 'Bronze Lowpinger'),
('latency', 12, 0, 'csp', '3_latency.png', 'Silver Lowpinger'),
('latency', 20, 0, 'csp', '4_latency.png', 'Gold Lowpinger'),
('latency', 30, 0, 'csp', '5_latency.png', 'Platinum Lowpinger'),
('latency', 50, 0, 'csp', '6_latency.png', 'Supreme Lowpinger'),
('headshot', 1, 0, 'csp', '1_headshot.png', 'Award of Headshots'),
('headshot', 5, 0, 'csp', '2_headshot.png', 'Bronze Headshots'),
('headshot', 12, 0, 'csp', '3_headshot.png', 'Silver Headshots'),
('headshot', 20, 0, 'csp', '4_headshot.png', 'Gold Headshots'),
('headshot', 30, 0, 'csp', '5_headshot.png', 'Platinum Headshots'),
('headshot', 50, 0, 'csp', '6_headshot.png', 'Supreme Headshots'),
('*total connection hours*', 25, 2, 'nd', '1_connectiontime.png', 'Connection Time: 25 Hours'),
('armblade', 1, 0, 'nd', '1_armblade.png', 'Young: BLADES'),
('armknives', 1, 0, 'nd', '1_armknives.png', 'Young: KNIVES'),
('artillery', 1, 0, 'nd', '1_artillery.png', 'Young: Artillerist'),
('avenger', 1, 0, 'nd', '1_avenger.png', 'Young: C1 AVENGER'),
('bag90', 1, 0, 'nd', '1_bag90.png', 'Young: BAG-90'),
('bonuspoints', 1, 0, 'nd', '1_bonuspoints.png', 'Young: Improved Player'),
('chaingun', 1, 0, 'nd', '1_chaingun.png', 'Young: GAU-20P'),
('commander damage', 1, 0, 'nd', '1_commander ability.png', 'Young: Damage Commander'),
('commander poison', 1, 0, 'nd', '1_commander ability.png', 'Young: Poison Commander'),
('daisy cutter', 1, 0, 'nd', '1_daisy cutter.png', 'Young: DAISYCUTTER'),
('deathstreak', 1, 0, 'nd', '1_deathstreak.png', 'Young: Victim'),
('env_explosion', 1, 0, 'nd', '1_latency.png', 'Young: Blaster'),
('f2000', 1, 0, 'nd', '1_f2000.png', 'Young: FN-H F2100 TR'),
('flamethrower turret', 1, 0, 'nd', '1_flamethrower turret.png', 'Young: Flamethrower Turret'),
('frag grenade', 1, 0, 'nd', '1_frag grenade.png', 'Young: M-87 FRAG'),
('grenade launcher', 1, 0, 'nd', '1_grenade launcher.png', 'Young: M52 HYDRA'),
('headshot', 1, 0, 'nd', '1_headshot.png', 'Young: Headshot King'),
('killstreak', 1, 0, 'nd', '1_killstreak.png', 'Young: Slayer'),
('latency', 1, 0, 'nd', '1_latency.png', 'Young: Lowpinger'),
('m95', 1, 0, 'nd', '1_m95.png', 'Young: M-95 L.A.W.S.'),
('mg turret', 1, 0, 'nd', '1_mg turret.png', 'Young: Machine-gun Turret'),
('mostkills', 1, 0, 'nd', '1_mostkills.png', 'Young: Killer'),
('mp500', 1, 0, 'nd', '1_mp500.png', 'Young: MP-500'),
('mp7', 1, 0, 'nd', '1_mp7.png', 'Young: MP-7'),
('nx300', 1, 0, 'nd', '1_nx300.png', 'Young: NX-300'),
('p12 grenade', 1, 0, 'nd', '1_p12 grenade.png', 'Young: P12 POISON'),
('p900', 1, 0, 'nd', '1_latency.png', 'Young: P-900'),
('paladin', 1, 0, 'nd', '1_paladin.png', 'Young: PALADIN PLR-5'),
('pp22', 1, 0, 'nd', '1_pp22.png', 'Young: PP-22'),
('psg', 1, 0, 'nd', '1_psg.png', 'Young: PSG-L'),
('R.E.D.', 1, 0, 'nd', '1_latency.png', 'Young: R.E.D.'),
('repair tool', 1, 0, 'nd', '1_repair tool.png', 'Young: Engineer'),
('rocket turret', 1, 0, 'nd', '1_rocket turret.png', 'Young: Rocket Turret'),
('shotgun', 1, 0, 'nd', '1_shotgun.png', 'Young: SPETZ-9'),
('sonic turret', 1, 0, 'nd', '1_sonic turret.png', 'Young: Sonic Turret'),
('sp5', 1, 0, 'nd', '1_sp5.png', 'Young: SP-5 K1'),
('structure_kill', 1, 0, 'nd', '1_structure_kill.png', 'Young: Destroyer'),
('suicide', 1, 0, 'nd', '1_suicide.png', 'Young: Self-murderer'),
('teamkills', 1, 0, 'nd', '1_teamkills.png', 'Young: Betrayer'),
('u23 grenade', 1, 0, 'nd', '1_u23 grenade.png', 'Young: U23 POISON'),
('x01', 1, 0, 'nd', '1_x01.png', 'Young: X-01'),
('*total connection hours*', 50, 2, 'nd', '2_connectiontime.png', 'Connection Time: 50 Hours'),
('armblade', 5, 0, 'nd', '2_armblade.png', 'Bronze: BLADES'),
('armknives', 5, 0, 'nd', '2_armknives.png', 'Bronze: KNIVES'),
('artillery', 5, 0, 'nd', '2_artillery.png', 'Bronze: Artillerist'),
('avenger', 5, 0, 'nd', '2_avenger.png', 'Bronze: C1 AVENGER'),
('bag90', 5, 0, 'nd', '2_bag90.png', 'Bronze: BAG-90'),
('bonuspoints', 5, 0, 'nd', '2_bonuspoints.png', 'Bronze: Improved Player'),
('chaingun', 5, 0, 'nd', '2_chaingun.png', 'Bronze: GAU-20P'),
('commander damage', 5, 0, 'nd', '2_commander ability.png', 'Bronze: Damage Commander'),
('commander poison', 5, 0, 'nd', '2_commander ability.png', 'Bronze: Poison Commander'),
('daisy cutter', 5, 0, 'nd', '2_daisy cutter.png', 'Bronze: DAISYCUTTER'),
('deathstreak', 5, 0, 'nd', '2_deathstreak.png', 'Bronze: Victim'),
('env_explosion', 5, 0, 'nd', '2_latency.png', 'Bronze: Blaster'),
('f2000', 5, 0, 'nd', '2_f2000.png', 'Bronze: FN-H F2100 TR'),
('flamethrower turret', 5, 0, 'nd', '2_flamethrower turret.png', 'Bronze: Flamethrower Turret'),
('frag grenade', 5, 0, 'nd', '2_frag grenade.png', 'Bronze: M-87 FRAG'),
('grenade launcher', 5, 0, 'nd', '2_grenade launcher.png', 'Bronze: M52 HYDRA'),
('headshot', 5, 0, 'nd', '2_headshot.png', 'Bronze: Headshot King'),
('killstreak', 5, 0, 'nd', '2_killstreak.png', 'Bronze: Slayer'),
('latency', 5, 0, 'nd', '2_latency.png', 'Bronze: Lowpinger'),
('m95', 5, 0, 'nd', '2_m95.png', 'Bronze: M-95 L.A.W.S.'),
('mg turret', 5, 0, 'nd', '2_mg turret.png', 'Bronze: Machine-gun Turret'),
('mostkills', 5, 0, 'nd', '2_mostkills.png', 'Bronze: Killer'),
('mp500', 5, 0, 'nd', '2_mp500.png', 'Bronze: MP-500'),
('mp7', 5, 0, 'nd', '2_mp7.png', 'Bronze: MP-7'),
('nx300', 5, 0, 'nd', '2_nx300.png', 'Bronze: NX-300'),
('p12 grenade', 5, 0, 'nd', '2_p12 grenade.png', 'Bronze: P12 POISON'),
('p900', 5, 0, 'nd', '2_latency.png', 'Bronze: P-900'),
('paladin', 5, 0, 'nd', '2_paladin.png', 'Bronze: PALADIN PLR-5'),
('pp22', 5, 0, 'nd', '2_pp22.png', 'Bronze: PP-22'),
('psg', 5, 0, 'nd', '2_psg.png', 'Bronze: PSG-L'),
('R.E.D.', 5, 0, 'nd', '2_latency.png', 'Bronze: R.E.D.'),
('repair tool', 5, 0, 'nd', '2_repair tool.png', 'Bronze: Engineer'),
('rocket turret', 5, 0, 'nd', '2_rocket turret.png', 'Bronze: Rocket Turret'),
('shotgun', 5, 0, 'nd', '2_shotgun.png', 'Bronze: SPETZ-9'),
('sonic turret', 5, 0, 'nd', '2_sonic turret.png', 'Bronze: Sonic Turret'),
('sp5', 5, 0, 'nd', '2_sp5.png', 'Bronze: SP-5 K1'),
('structure_kill', 5, 0, 'nd', '2_structure_kill.png', 'Bronze: Destroyer'),
('suicide', 5, 0, 'nd', '2_suicide.png', 'Bronze: Self-murderer'),
('teamkills', 5, 0, 'nd', '2_teamkills.png', 'Bronze: Betrayer'),
('u23 grenade', 5, 0, 'nd', '2_u23 grenade.png', 'Bronze: U23 POISON'),
('x01', 5, 0, 'nd', '2_x01.png', 'Bronze: X-01'),
('*total connection hours*', 75, 2, 'nd', '3_connectiontime.png', 'Connection Time: 75 Hours'),
('armblade', 15, 0, 'nd', '3_armblade.png', 'Silver: BLADES'),
('armknives', 15, 0, 'nd', '3_armknives.png', 'Silver: KNIVES'),
('artillery', 15, 0, 'nd', '3_artillery.png', 'Silver: Artillerist'),
('avenger', 15, 0, 'nd', '3_avenger.png', 'Silver: C1 AVENGER'),
('bag90', 15, 0, 'nd', '3_bag90.png', 'Silver: BAG-90'),
('bonuspoints', 15, 0, 'nd', '3_bonuspoints.png', 'Silver: Improved Player'),
('chaingun', 15, 0, 'nd', '3_chaingun.png', 'Silver: GAU-20P'),
('commander damage', 15, 0, 'nd', '3_commander ability.png', 'Silver: Damage Commander'),
('commander poison', 15, 0, 'nd', '3_commander ability.png', 'Silver: Poison Commander'),
('daisy cutter', 15, 0, 'nd', '3_daisy cutter.png', 'Silver: DAISYCUTTER'),
('deathstreak', 15, 0, 'nd', '3_deathstreak.png', 'Silver: Victim'),
('env_explosion', 15, 0, 'nd', '3_latency.png', 'Silver: Blaster'),
('f2000', 15, 0, 'nd', '3_f2000.png', 'Silver: FN-H F2100 TR'),
('flamethrower turret', 15, 0, 'nd', '3_flamethrower turret.png', 'Silver: Flamethrower Turret'),
('frag grenade', 15, 0, 'nd', '3_frag grenade.png', 'Silver: M-87 FRAG'),
('grenade launcher', 15, 0, 'nd', '3_grenade launcher.png', 'Silver: M52 HYDRA'),
('headshot', 15, 0, 'nd', '3_headshot.png', 'Silver: Headshot King'),
('killstreak', 15, 0, 'nd', '3_killstreak.png', 'Silver: Slayer'),
('latency', 15, 0, 'nd', '3_latency.png', 'Silver: Lowpinger'),
('m95', 15, 0, 'nd', '3_m95.png', 'Silver: M-95 L.A.W.S.'),
('mg turret', 15, 0, 'nd', '3_mg turret.png', 'Silver: Machine-gun Turret'),
('mostkills', 15, 0, 'nd', '3_mostkills.png', 'Silver: Killer'),
('mp500', 15, 0, 'nd', '3_mp500.png', 'Silver: MP-500'),
('mp7', 15, 0, 'nd', '3_mp7.png', 'Silver: MP-7'),
('nx300', 15, 0, 'nd', '3_nx300.png', 'Silver: NX-300'),
('p12 grenade', 15, 0, 'nd', '3_p12 grenade.png', 'Silver: P12 POISON'),
('p900', 15, 0, 'nd', '3_latency.png', 'Silver: P-900'),
('paladin', 15, 0, 'nd', '3_paladin.png', 'Silver: PALADIN PLR-5'),
('pp22', 15, 0, 'nd', '3_pp22.png', 'Silver: PP-22'),
('psg', 15, 0, 'nd', '3_psg.png', 'Silver: PSG-L'),
('R.E.D.', 15, 0, 'nd', '3_latency.png', 'Silver: R.E.D.'),
('repair tool', 15, 0, 'nd', '3_repair tool.png', 'Silver: Engineer'),
('rocket turret', 15, 0, 'nd', '3_rocket turret.png', 'Silver: Rocket Turret'),
('shotgun', 15, 0, 'nd', '3_shotgun.png', 'Silver: SPETZ-9'),
('sonic turret', 15, 0, 'nd', '3_sonic turret.png', 'Silver: Sonic Turret'),
('sp5', 15, 0, 'nd', '3_sp5.png', 'Silver: SP-5 K1'),
('structure_kill', 15, 0, 'nd', '3_structure_kill.png', 'Silver: Destroyer'),
('suicide', 15, 0, 'nd', '3_suicide.png', 'Silver: Self-murderer'),
('teamkills', 15, 0, 'nd', '3_teamkills.png', 'Silver: Betrayer'),
('u23 grenade', 15, 0, 'nd', '3_u23 grenade.png', 'Silver: U23 POISON'),
('x01', 15, 0, 'nd', '3_x01.png', 'Silver: X-01'),
('*total connection hours*', 100, 2, 'nd', '4_connectiontime.png', 'Connection Time: 100 Hours'),
('armblade', 30, 0, 'nd', '4_armblade.png', 'Golden: BLADES'),
('armknives', 30, 0, 'nd', '4_armknives.png', 'Golden: KNIVES'),
('artillery', 30, 0, 'nd', '4_artillery.png', 'Golden: Artillerist'),
('avenger', 30, 0, 'nd', '4_avenger.png', 'Golden: C1 AVENGER'),
('bag90', 30, 0, 'nd', '4_bag90.png', 'Golden: BAG-90'),
('bonuspoints', 30, 0, 'nd', '4_bonuspoints.png', 'Golden: Improved Player'),
('chaingun', 30, 0, 'nd', '4_chaingun.png', 'Golden: GAU-20P'),
('commander damage', 30, 0, 'nd', '4_commander ability.png', 'Golden: Damage Commander'),
('commander poison', 30, 0, 'nd', '4_commander ability.png', 'Golden: Poison Commander'),
('daisy cutter', 30, 0, 'nd', '4_daisy cutter.png', 'Golden: DAISYCUTTER'),
('deathstreak', 30, 0, 'nd', '4_deathstreak.png', 'Golden: Victim'),
('env_explosion', 30, 0, 'nd', '4_latency.png', 'Golden: Blaster'),
('f2000', 30, 0, 'nd', '4_f2000.png', 'Golden: FN-H F2100 TR'),
('flamethrower turret', 30, 0, 'nd', '4_flamethrower turret.png', 'Golden: Flamethrower Turret'),
('frag grenade', 30, 0, 'nd', '4_frag grenade.png', 'Golden: M-87 FRAG'),
('grenade launcher', 30, 0, 'nd', '4_grenade launcher.png', 'Golden: M52 HYDRA'),
('headshot', 30, 0, 'nd', '4_headshot.png', 'Golden: Headshot King'),
('killstreak', 30, 0, 'nd', '4_killstreak.png', 'Golden: Slayer'),
('latency', 30, 0, 'nd', '4_latency.png', 'Golden: Lowpinger'),
('m95', 30, 0, 'nd', '4_m95.png', 'Golden: M-95 L.A.W.S.'),
('mg turret', 30, 0, 'nd', '4_mg turret.png', 'Golden: Machine-gun Turret'),
('mostkills', 30, 0, 'nd', '4_mostkills.png', 'Golden: Killer'),
('mp500', 30, 0, 'nd', '4_mp500.png', 'Golden: MP-500'),
('mp7', 30, 0, 'nd', '4_mp7.png', 'Golden: MP-7'),
('nx300', 30, 0, 'nd', '4_nx300.png', 'Golden: NX-300'),
('p12 grenade', 30, 0, 'nd', '4_p12 grenade.png', 'Golden: P12 POISON'),
('p900', 30, 0, 'nd', '4_latency.png', 'Golden: P-900'),
('paladin', 30, 0, 'nd', '4_paladin.png', 'Golden: PALADIN PLR-5'),
('pp22', 30, 0, 'nd', '4_pp22.png', 'Golden: PP-22'),
('psg', 30, 0, 'nd', '4_psg.png', 'Golden: PSG-L'),
('R.E.D.', 30, 0, 'nd', '4_latency.png', 'Golden: R.E.D.'),
('repair tool', 30, 0, 'nd', '4_repair tool.png', 'Golden: Engineer'),
('rocket turret', 30, 0, 'nd', '4_rocket turret.png', 'Golden: Rocket Turret'),
('shotgun', 30, 0, 'nd', '4_shotgun.png', 'Golden: SPETZ-9'),
('sonic turret', 30, 0, 'nd', '4_sonic turret.png', 'Golden: Sonic Turret'),
('sp5', 30, 0, 'nd', '4_sp5.png', 'Golden: SP-5 K1'),
('structure_kill', 30, 0, 'nd', '4_structure_kill.png', 'Golden: Destroyer'),
('suicide', 30, 0, 'nd', '4_suicide.png', 'Golden: Self-murderer'),
('teamkills', 30, 0, 'nd', '4_teamkills.png', 'Golden: Betrayer'),
('u23 grenade', 30, 0, 'nd', '4_u23 grenade.png', 'Golden: U23 POISON'),
('x01', 30, 0, 'nd', '4_x01.png', 'Golden: X-01'),
('*total connection hours*', 125, 2, 'nd', '5_connectiontime.png', 'Connection Time: 125 Hours'),
('armblade', 50, 0, 'nd', '5_armblade.png', 'Platinum: BLADES'),
('armknives', 50, 0, 'nd', '5_armknives.png', 'Platinum: KNIVES'),
('artillery', 50, 0, 'nd', '5_artillery.png', 'Platinum: Artillerist'),
('avenger', 50, 0, 'nd', '5_avenger.png', 'Platinum: C1 AVENGER'),
('bag90', 50, 0, 'nd', '5_bag90.png', 'Platinum: BAG-90'),
('bonuspoints', 50, 0, 'nd', '5_bonuspoints.png', 'Platinum: Improved Player'),
('chaingun', 50, 0, 'nd', '5_chaingun.png', 'Platinum: GAU-20P'),
('commander damage', 50, 0, 'nd', '5_commander ability.png', 'Platinum: Damage Commander'),
('commander poison', 50, 0, 'nd', '5_commander ability.png', 'Platinum: Poison Commander'),
('daisy cutter', 50, 0, 'nd', '5_daisy cutter.png', 'Platinum: DAISYCUTTER'),
('deathstreak', 50, 0, 'nd', '5_deathstreak.png', 'Platinum: Victim'),
('env_explosion', 50, 0, 'nd', '5_latency.png', 'Platinum: Blaster'),
('f2000', 50, 0, 'nd', '5_f2000.png', 'Platinum: FN-H F2100 TR'),
('flamethrower turret', 50, 0, 'nd', '5_flamethrower turret.png', 'Platinum: Flamethrower Turret'),
('frag grenade', 50, 0, 'nd', '5_frag grenade.png', 'Platinum: M-87 FRAG'),
('grenade launcher', 50, 0, 'nd', '5_grenade launcher.png', 'Platinum: M52 HYDRA'),
('headshot', 50, 0, 'nd', '5_headshot.png', 'Platinum: Headshot King'),
('killstreak', 50, 0, 'nd', '5_killstreak.png', 'Platinum: Slayer'),
('latency', 50, 0, 'nd', '5_latency.png', 'Platinum: Lowpinger'),
('m95', 50, 0, 'nd', '5_m95.png', 'Platinum: M-95 L.A.W.S.'),
('mg turret', 50, 0, 'nd', '5_mg turret.png', 'Platinum: Machine-gun Turret'),
('mostkills', 50, 0, 'nd', '5_mostkills.png', 'Platinum: Killer'),
('mp500', 50, 0, 'nd', '5_mp500.png', 'Platinum: MP-500'),
('mp7', 50, 0, 'nd', '5_mp7.png', 'Platinum: MP-7'),
('nx300', 50, 0, 'nd', '5_nx300.png', 'Platinum: NX-300'),
('p12 grenade', 50, 0, 'nd', '5_p12 grenade.png', 'Platinum: P12 POISON'),
('p900', 50, 0, 'nd', '5_latency.png', 'Platinum: P-900'),
('paladin', 50, 0, 'nd', '5_paladin.png', 'Platinum: PALADIN PLR-5'),
('pp22', 50, 0, 'nd', '5_pp22.png', 'Platinum: PP-22'),
('psg', 50, 0, 'nd', '5_psg.png', 'Platinum: PSG-L'),
('R.E.D.', 50, 0, 'nd', '5_latency.png', 'Platinum: R.E.D.'),
('repair tool', 50, 0, 'nd', '5_repair tool.png', 'Platinum: Engineer'),
('rocket turret', 50, 0, 'nd', '5_rocket turret.png', 'Platinum: Rocket Turret'),
('shotgun', 50, 0, 'nd', '5_shotgun.png', 'Platinum: SPETZ-9'),
('sonic turret', 50, 0, 'nd', '5_sonic turret.png', 'Platinum: Sonic Turret'),
('sp5', 50, 0, 'nd', '5_sp5.png', 'Platinum: SP-5 K1'),
('structure_kill', 50, 0, 'nd', '5_structure_kill.png', 'Platinum: Destroyer'),
('suicide', 50, 0, 'nd', '5_suicide.png', 'Platinum: Self-murderer'),
('teamkills', 50, 0, 'nd', '5_teamkills.png', 'Platinum: Betrayer'),
('u23 grenade', 50, 0, 'nd', '5_u23 grenade.png', 'Platinum: U23 POISON'),
('x01', 50, 0, 'nd', '5_x01.png', 'Platinum: X-01'),
('*total connection hours*', 150, 2, 'nd', '6_connectiontime.png', 'Connection Time: 150 Hours'),
('armblade', 75, 0, 'nd', '6_armblade.png', 'Bloody: BLADES'),
('armknives', 75, 0, 'nd', '6_armknives.png', 'Bloody: KNIVES'),
('artillery', 75, 0, 'nd', '6_artillery.png', 'Bloody: Artillerist'),
('avenger', 75, 0, 'nd', '6_avenger.png', 'Bloody: C1 AVENGER'),
('bag90', 75, 0, 'nd', '6_bag90.png', 'Bloody: BAG-90'),
('bonuspoints', 75, 0, 'nd', '6_bonuspoints.png', 'Bloody: Improved Player'),
('chaingun', 75, 0, 'nd', '6_chaingun.png', 'Bloody: GAU-20P'),
('commander damage', 75, 0, 'nd', '6_commander ability.png', 'Bloody: Damage Commander'),
('commander poison', 75, 0, 'nd', '6_commander ability.png', 'Bloody: Poison Commander'),
('daisy cutter', 75, 0, 'nd', '6_daisy cutter.png', 'Bloody: DAISYCUTTER'),
('deathstreak', 75, 0, 'nd', '6_deathstreak.png', 'Bloody: Victim'),
('env_explosion', 75, 0, 'nd', '6_latency.png', 'Bloody: Blaster'),
('f2000', 75, 0, 'nd', '6_f2000.png', 'Bloody: FN-H F2100 TR'),
('flamethrower turret', 75, 0, 'nd', '6_flamethrower turret.png', 'Bloody: Flamethrower Turret'),
('frag grenade', 75, 0, 'nd', '6_frag grenade.png', 'Bloody: M-87 FRAG'),
('grenade launcher', 75, 0, 'nd', '6_grenade launcher.png', 'Bloody: M52 HYDRA'),
('headshot', 75, 0, 'nd', '6_headshot.png', 'Bloody: Headshot King'),
('killstreak', 75, 0, 'nd', '6_killstreak.png', 'Bloody: Slayer'),
('latency', 75, 0, 'nd', '6_latency.png', 'Bloody: Lowpinger'),
('m95', 75, 0, 'nd', '6_m95.png', 'Bloody: M-95 L.A.W.S.'),
('mg turret', 75, 0, 'nd', '6_mg turret.png', 'Bloody: Machine-gun Turret'),
('mostkills', 75, 0, 'nd', '6_mostkills.png', 'Bloody: Killer'),
('mp500', 75, 0, 'nd', '6_mp500.png', 'Bloody: MP-500'),
('mp7', 75, 0, 'nd', '6_mp7.png', 'Bloody: MP-7'),
('nx300', 75, 0, 'nd', '6_nx300.png', 'Bloody: NX-300'),
('p12 grenade', 75, 0, 'nd', '6_p12 grenade.png', 'Bloody: P12 POISON'),
('p900', 75, 0, 'nd', '6_latency.png', 'Bloody: P-900'),
('paladin', 75, 0, 'nd', '6_paladin.png', 'Bloody: PALADIN PLR-5'),
('pp22', 75, 0, 'nd', '6_pp22.png', 'Bloody: PP-22'),
('psg', 75, 0, 'nd', '6_psg.png', 'Bloody: PSG-L'),
('R.E.D.', 75, 0, 'nd', '6_latency.png', 'Bloody: R.E.D.'),
('repair tool', 75, 0, 'nd', '6_repair tool.png', 'Bloody: Engineer'),
('rocket turret', 75, 0, 'nd', '6_rocket turret.png', 'Bloody: Rocket Turret'),
('shotgun', 75, 0, 'nd', '6_shotgun.png', 'Bloody: SPETZ-9'),
('sonic turret', 75, 0, 'nd', '6_sonic turret.png', 'Bloody: Sonic Turret'),
('sp5', 75, 0, 'nd', '6_sp5.png', 'Bloody: SP-5 K1'),
('structure_kill', 75, 0, 'nd', '6_structure_kill.png', 'Bloody: Destroyer'),
('suicide', 75, 0, 'nd', '6_suicide.png', 'Bloody: Self-murderer'),
('teamkills', 75, 0, 'nd', '6_teamkills.png', 'Bloody: Betrayer'),
('u23 grenade', 75, 0, 'nd', '6_u23 grenade.png', 'Bloody: U23 POISON'),
('x01', 75, 0, 'nd', '6_x01.png', 'Bloody: X-01'),
('ak47', 1, 0, 'csgo', '1_ak47.png', 'Award of AK47'),
('awp', 1, 0, 'csgo', '1_awp.png', 'Award of AWP Sniper'),
('bizon', 1, 0, 'csgo', '1_bizon.png', 'Award of PP Bizon'),
('deagle', 1, 0, 'csgo', '1_deagle.png', 'Award of Desert Eagle'),
('elite', 1, 0, 'csgo', '1_elite.png', 'Award of Dual Beretta Elites'),
('firebomb', 1, 0, 'csgo', '1_firebomb.png', 'Award of Inferno'),
('fiveseven', 1, 0, 'csgo', '1_fiveseven.png', 'Award of Five-Seven'),
('g3sg1', 1, 0, 'csgo', '1_g3sg1.png', 'Award of G3 SG1'),
('galilar', 1, 0, 'csgo', '1_galilar.png', 'Award of Galilar'),
('glock', 1, 0, 'csgo', '1_glock.png', 'Award of Glock'),
('hegrenade', 1, 0, 'csgo', '1_hegrenade.png', 'Award of HE Grenades'),
('P2000', 1, 0, 'csgo', '1_hkp2000.png', 'Award of P2000'),
('knife', 1, 0, 'csgo', '1_knife.png', 'Award of Combat Knife'),
('m4a1', 1, 0, 'csgo', '1_m4a1.png', 'Award of M4A4'),
('m249', 1, 0, 'csgo', '1_m249.png', 'Award of M249'),
('mac10', 1, 0, 'csgo', '1_mac10.png', 'Award of MAC-10'),
('mag7', 1, 0, 'csgo', '1_mag7.png', 'Award of MAG-7'),
('mp7', 1, 0, 'csgo', '1_mp7.png', 'Award of MP7'),
('mp9', 1, 0, 'csgo', '1_mp9.png', 'Award of MP9'),
('negev', 1, 0, 'csgo', '1_negev.png', 'Award of Negev'),
('nova', 1, 0, 'csgo', '1_nova.png', 'Award of Nova'),
('p90', 1, 0, 'csgo', '1_p90.png', 'Award of P90'),
('p250', 1, 0, 'csgo', '1_p250.png', 'Award of P250'),
('sawedoff', 1, 0, 'csgo', '1_sawedoff.png', 'Award of Sawed-Off'),
('scar20', 1, 0, 'csgo', '1_scar20.png', 'Award of SCAR-20'),
('sg553', 1, 0, 'csgo', '1_sg553.png', 'Award of SG 553'),
('sg08', 1, 0, 'csgo', '1_sg08.png', 'Award of SG 08'),
('taser', 1, 0, 'csgo', '1_taser.png', 'Award of Zeus x27'),
('tec9', 1, 0, 'csgo', '1_tec9.png', 'Award of Tec9'),
('ump45', 1, 0, 'csgo', '1_ump45.png', 'Award of UMP-45'),
('xm1014', 1, 0, 'csgo', '1_xm1014.png', 'Award of XM Shotgun'),
('ak47', 5, 0, 'csgo', '2_ak47.png', 'Bronze AK47'),
('awp', 5, 0, 'csgo', '2_awp.png', 'Bronze AWP Sniper'),
('bizon', 5, 0, 'csgo', '2_bizon.png', 'Bronze PP Bizon'),
('deagle', 5, 0, 'csgo', '2_deagle.png', 'Bronze Desert Eagle'),
('elite', 5, 0, 'csgo', '2_elite.png', 'Bronze Dual Beretta Elites'),
('firebomb', 5, 0, 'csgo', '2_firebomb.png', 'Bronze Inferno'),
('fiveseven', 5, 0, 'csgo', '2_fiveseven.png', 'Bronze Five-Seven'),
('g3sg1', 5, 0, 'csgo', '2_g3sg1.png', 'Bronze G3 SG1'),
('galilar', 5, 0, 'csgo', '2_galilar.png', 'Bronze Galilar'),
('glock', 5, 0, 'csgo', '2_glock.png', 'Bronze Glock'),
('hegrenade', 5, 0, 'csgo', '2_hegrenade.png', 'Bronze HE Grenades'),
('P2000', 5, 0, 'csgo', '2_hkp2000.png', 'Bronze P2000'),
('knife', 5, 0, 'csgo', '2_knife.png', 'Bronze Combat Knife'),
('m4a1', 5, 0, 'csgo', '2_m4a1.png', 'Bronze M4A4'),
('m249', 5, 0, 'csgo', '2_m249.png', 'Bronze M249'),
('mac10', 5, 0, 'csgo', '2_mac10.png', 'Bronze MAC-10'),
('mag7', 5, 0, 'csgo', '2_mag7.png', 'Bronze MAG-7'),
('mp7', 5, 0, 'csgo', '2_mp7.png', 'Bronze MP7'),
('mp9', 5, 0, 'csgo', '2_mp9.png', 'Bronze MP9'),
('negev', 5, 0, 'csgo', '2_negev.png', 'Bronze Negev'),
('nova', 5, 0, 'csgo', '2_nova.png', 'Bronze Nova'),
('p90', 5, 0, 'csgo', '2_p90.png', 'Bronze P90'),
('p250', 5, 0, 'csgo', '2_p250.png', 'Bronze P250'),
('sawedoff', 5, 0, 'csgo', '2_sawedoff.png', 'Bronze Sawed-Off'),
('scar20', 5, 0, 'csgo', '2_scar20.png', 'Bronze SCAR-20'),
('sg553', 5, 0, 'csgo', '2_sg553.png', 'Bronze SG 553'),
('sg08', 5, 0, 'csgo', '2_sg08.png', 'Bronze SG 08'),
('taser', 5, 0, 'csgo', '2_taser.png', 'Bronze Zeus x27'),
('tec9', 5, 0, 'csgo', '2_tec9.png', 'Bronze Tec9'),
('ump45', 5, 0, 'csgo', '2_ump45.png', 'Bronze UMP-45'),
('xm1014', 5, 0, 'csgo', '2_xm1014.png', 'Bronze XM Shotgun'),
('ak47', 12, 0, 'csgo', '3_ak47.png', 'Silver AK47'),
('awp', 12, 0, 'csgo', '3_awp.png', 'Silver AWP Sniper'),
('bizon', 12, 0, 'csgo', '3_bizon.png', 'Silver PP Bizon'),
('deagle', 12, 0, 'csgo', '3_deagle.png', 'Silver Desert Eagle'),
('elite', 12, 0, 'csgo', '3_elite.png', 'Silver Dual Beretta Elites'),
('firebomb', 12, 0, 'csgo', '3_firebomb.png', 'Silver Inferno'),
('fiveseven', 12, 0, 'csgo', '3_fiveseven.png', 'Silver Five-Seven'),
('g3sg1', 12, 0, 'csgo', '3_g3sg1.png', 'Silver G3 SG1'),
('galilar', 12, 0, 'csgo', '3_galilar.png', 'Silver Galilar'),
('glock', 12, 0, 'csgo', '3_glock.png', 'Silver Glock'),
('hegrenade', 12, 0, 'csgo', '3_hegrenade.png', 'Silver HE Grenades'),
('P2000', 12, 0, 'csgo', '3_hkp2000.png', 'Silver P2000'),
('knife', 12, 0, 'csgo', '3_knife.png', 'Silver Combat Knife'),
('m4a1', 12, 0, 'csgo', '3_m4a1.png', 'Silver M4A4'),
('m249', 12, 0, 'csgo', '3_m249.png', 'Silver M249'),
('mac10', 12, 0, 'csgo', '3_mac10.png', 'Silver MAC-10'),
('mag7', 12, 0, 'csgo', '3_mag7.png', 'Silver MAG-7'),
('mp7', 12, 0, 'csgo', '3_mp7.png', 'Silver MP7'),
('mp9', 12, 0, 'csgo', '3_mp9.png', 'Silver MP9'),
('negev', 12, 0, 'csgo', '3_negev.png', 'Silver Negev'),
('nova', 12, 0, 'csgo', '3_nova.png', 'Silver Nova'),
('p90', 12, 0, 'csgo', '3_p90.png', 'Silver P90'),
('p250', 12, 0, 'csgo', '3_p250.png', 'Silver P250'),
('sawedoff', 12, 0, 'csgo', '3_sawedoff.png', 'Silver Sawed-Off'),
('scar20', 12, 0, 'csgo', '3_scar20.png', 'Silver SCAR-20'),
('sg553', 12, 0, 'csgo', '3_sg553.png', 'Silver SG 553'),
('sg08', 12, 0, 'csgo', '3_sg08.png', 'Silver SG 08'),
('taser', 12, 0, 'csgo', '3_taser.png', 'Silver Zeus x27'),
('tec9', 12, 0, 'csgo', '3_tec9.png', 'Silver Tec9'),
('ump45', 12, 0, 'csgo', '3_ump45.png', 'Silver UMP-45'),
('xm1014', 12, 0, 'csgo', '3_xm1014.png', 'Silver XM Shotgun'),
('ak47', 20, 0, 'csgo', '4_ak47.png', 'Gold AK47'),
('awp', 20, 0, 'csgo', '4_awp.png', 'Gold AWP Sniper'),
('bizon', 20, 0, 'csgo', '4_bizon.png', 'Gold PP Bizon'),
('deagle', 20, 0, 'csgo', '4_deagle.png', 'Gold Desert Eagle'),
('elite', 20, 0, 'csgo', '4_elite.png', 'Gold Dual Beretta Elites'),
('firebomb', 20, 0, 'csgo', '4_firebomb.png', 'Gold Inferno'),
('fiveseven', 20, 0, 'csgo', '4_fiveseven.png', 'Gold Five-Seven'),
('g3sg1', 20, 0, 'csgo', '4_g3sg1.png', 'Gold G3 SG1'),
('galilar', 20, 0, 'csgo', '4_galilar.png', 'Gold Galilar'),
('glock', 20, 0, 'csgo', '4_glock.png', 'Gold Glock'),
('hegrenade', 20, 0, 'csgo', '4_hegrenade.png', 'Gold HE Grenades'),
('P2000', 20, 0, 'csgo', '4_hkp2000.png', 'Gold P2000'),
('knife', 20, 0, 'csgo', '4_knife.png', 'Gold Combat Knife'),
('m4a1', 20, 0, 'csgo', '4_m4a1.png', 'Gold M4A4'),
('m249', 20, 0, 'csgo', '4_m249.png', 'Gold M249'),
('mac10', 20, 0, 'csgo', '4_mac10.png', 'Gold MAC-10'),
('mag7', 20, 0, 'csgo', '4_mag7.png', 'Gold MAG-7'),
('mp7', 20, 0, 'csgo', '4_mp7.png', 'Gold MP7'),
('mp9', 20, 0, 'csgo', '4_mp9.png', 'Gold MP9'),
('negev', 20, 0, 'csgo', '4_negev.png', 'Gold Negev'),
('nova', 20, 0, 'csgo', '4_nova.png', 'Gold Nova'),
('p90', 20, 0, 'csgo', '4_p90.png', 'Gold P90'),
('p250', 20, 0, 'csgo', '4_p250.png', 'Gold P250'),
('sawedoff', 20, 0, 'csgo', '4_sawedoff.png', 'Gold Sawed-Off'),
('scar20', 20, 0, 'csgo', '4_scar20.png', 'Gold SCAR-20'),
('sg553', 20, 0, 'csgo', '4_sg553.png', 'Gold SG 553'),
('sg08', 20, 0, 'csgo', '4_sg08.png', 'Gold SG 08'),
('taser', 20, 0, 'csgo', '4_taser.png', 'Gold Zeus x27'),
('tec9', 20, 0, 'csgo', '4_tec9.png', 'Gold Tec9'),
('ump45', 20, 0, 'csgo', '4_ump45.png', 'Gold UMP-45'),
('xm1014', 20, 0, 'csgo', '4_xm1014.png', 'Gold XM Shotgun'),
('ak47', 30, 0, 'csgo', '5_ak47.png', 'Platinum AK47'),
('awp', 30, 0, 'csgo', '5_awp.png', 'Platinum AWP Sniper'),
('bizon', 30, 0, 'csgo', '5_bizon.png', 'Platinum PP Bizon'),
('deagle', 30, 0, 'csgo', '5_deagle.png', 'Platinum Desert Eagle'),
('elite', 30, 0, 'csgo', '5_elite.png', 'Platinum Dual Beretta Elites'),
('firebomb', 30, 0, 'csgo', '5_firebomb.png', 'Platinum Inferno'),
('fiveseven', 30, 0, 'csgo', '5_fiveseven.png', 'Platinum Five-Seven'),
('g3sg1', 30, 0, 'csgo', '5_g3sg1.png', 'Platinum G3 SG1'),
('galilar', 30, 0, 'csgo', '5_galilar.png', 'Platinum Galilar'),
('glock', 30, 0, 'csgo', '5_glock.png', 'Platinum Glock'),
('hegrenade', 30, 0, 'csgo', '5_hegrenade.png', 'Platinum HE Grenades'),
('P2000', 30, 0, 'csgo', '5_hkp2000.png', 'Platinum P2000'),
('knife', 30, 0, 'csgo', '5_knife.png', 'Platinum Combat Knife'),
('m4a1', 30, 0, 'csgo', '5_m4a1.png', 'Platinum M4A4'),
('m249', 30, 0, 'csgo', '5_m249.png', 'Platinum M249'),
('mac10', 30, 0, 'csgo', '5_mac10.png', 'Platinum MAC-10'),
('mag7', 30, 0, 'csgo', '5_mag7.png', 'Platinum MAG-7'),
('mp7', 30, 0, 'csgo', '5_mp7.png', 'Platinum MP7'),
('mp9', 30, 0, 'csgo', '5_mp9.png', 'Platinum MP9'),
('negev', 30, 0, 'csgo', '5_negev.png', 'Platinum Negev'),
('nova', 30, 0, 'csgo', '5_nova.png', 'Platinum Nova'),
('p90', 30, 0, 'csgo', '5_p90.png', 'Platinum P90'),
('p250', 30, 0, 'csgo', '5_p250.png', 'Platinum P250'),
('sawedoff', 30, 0, 'csgo', '5_sawedoff.png', 'Platinum Sawed-Off'),
('scar20', 30, 0, 'csgo', '5_scar20.png', 'Platinum SCAR-20'),
('sg553', 30, 0, 'csgo', '5_sg553.png', 'Platinum SG 553'),
('sg08', 30, 0, 'csgo', '5_sg08.png', 'Platinum SG 08'),
('taser', 30, 0, 'csgo', '5_taser.png', 'Platinum Zeus x27'),
('tec9', 30, 0, 'csgo', '5_tec9.png', 'Platinum Tec9'),
('ump45', 30, 0, 'csgo', '5_ump45.png', 'Platinum UMP-45'),
('xm1014', 30, 0, 'csgo', '5_xm1014.png', 'Platinum XM Shotgun'),
('ak47', 50, 0, 'csgo', '6_ak47.png', 'Supreme AK47'),
('awp', 50, 0, 'csgo', '6_awp.png', 'Supreme AWP Sniper'),
('bizon', 50, 0, 'csgo', '6_bizon.png', 'Supreme PP Bizon'),
('deagle', 50, 0, 'csgo', '6_deagle.png', 'Supreme Desert Eagle'),
('elite', 50, 0, 'csgo', '6_elite.png', 'Supreme Dual Beretta Elites'),
('firebomb', 50, 0, 'csgo', '6_firebomb.png', 'Supreme Inferno'),
('fiveseven', 50, 0, 'csgo', '6_fiveseven.png', 'Supreme Five-Seven'),
('g3sg1', 50, 0, 'csgo', '6_g3sg1.png', 'Supreme G3 SG1'),
('galilar', 50, 0, 'csgo', '6_galilar.png', 'Supreme Galilar'),
('glock', 50, 0, 'csgo', '6_glock.png', 'Supreme Glock'),
('hegrenade', 50, 0, 'csgo', '6_hegrenade.png', 'Supreme HE Grenades'),
('P2000', 50, 0, 'csgo', '6_hkp2000.png', 'Supreme P2000'),
('knife', 50, 0, 'csgo', '6_knife.png', 'Supreme Combat Knife'),
('m4a1', 50, 0, 'csgo', '6_m4a1.png', 'Supreme M4A4'),
('m249', 50, 0, 'csgo', '6_m249.png', 'Supreme M249'),
('mac10', 50, 0, 'csgo', '6_mac10.png', 'Supreme MAC-10'),
('mag7', 50, 0, 'csgo', '6_mag7.png', 'Supreme MAG-7'),
('mp7', 50, 0, 'csgo', '6_mp7.png', 'Supreme MP7'),
('mp9', 50, 0, 'csgo', '6_mp9.png', 'Supreme MP9'),
('negev', 50, 0, 'csgo', '6_negev.png', 'Supreme Negev'),
('nova', 50, 0, 'csgo', '6_nova.png', 'Supreme Nova'),
('p90', 50, 0, 'csgo', '6_p90.png', 'Supreme P90'),
('p250', 50, 0, 'csgo', '6_p250.png', 'Supreme P250'),
('sawedoff', 50, 0, 'csgo', '6_sawedoff.png', 'Supreme Sawed-Off'),
('scar20', 50, 0, 'csgo', '6_scar20.png', 'Supreme SCAR-20'),
('sg553', 50, 0, 'csgo', '6_sg553.png', 'Supreme SG 553'),
('sg08', 50, 0, 'csgo', '6_sg08.png', 'Supreme SG 08'),
('taser', 50, 0, 'csgo', '6_taser.png', 'Supreme Zeus x27'),
('tec9', 50, 0, 'csgo', '6_tec9.png', 'Supreme Tec9'),
('ump45', 50, 0, 'csgo', '6_ump45.png', 'Supreme UMP-45'),
('xm1014', 50, 0, 'csgo', '6_xm1014.png', 'Supreme XM Shotgun'),
('Defused_The_Bomb', 1, 0, 'csgo', '1_defused_the_bomb.png', 'Award of Bomb Defuser'),
('Planted_The_Bomb', 1, 0, 'csgo', '1_planted_the_bomb.png', 'Award of Bomb Planter'),
('Rescued_A_Hostage', 1, 0, 'csgo', '1_rescued_a_hostage.png', 'Award of Hostage Rescuer'),
('Killed_A_Hostage', 1, 0, 'csgo', '1_killed_a_hostage.png', 'Award of Hostage Killer'),
('latency', 1, 0, 'csgo', '1_latency.png', 'Award of Lowpinger'),
('headshot', 1, 0, 'csgo', '1_headshot.png', 'Award of Headshots'),
('Defused_The_Bomb', 5, 0, 'csgo', '2_defused_the_bomb.png', 'Bronze Bomb Defuser'),
('Planted_The_Bomb', 5, 0, 'csgo', '2_planted_the_bomb.png', 'Bronze Bomb Planter'),
('Rescued_A_Hostage', 5, 0, 'csgo', '2_rescued_a_hostage.png', 'Bronze Hostage Rescuer'),
('Killed_A_Hostage', 5, 0, 'csgo', '2_killed_a_hostage.png', 'Bronze Hostage Killer'),
('latency', 5, 0, 'csgo', '2_latency.png', 'Bronze Lowpinger'),
('headshot', 5, 0, 'csgo', '2_headshot.png', 'Bronze Headshots'),
('Defused_The_Bomb', 12, 0, 'csgo', '3_defused_the_bomb.png', 'Silver Bomb Defuser'),
('Planted_The_Bomb', 12, 0, 'csgo', '3_planted_the_bomb.png', 'Silver Bomb Planter'),
('Rescued_A_Hostage', 12, 0, 'csgo', '3_rescued_a_hostage.png', 'Silver Hostage Rescuer'),
('Killed_A_Hostage', 12, 0, 'csgo', '3_killed_a_hostage.png', 'Silver Hostage Killer'),
('latency', 12, 0, 'csgo', '3_latency.png', 'Silver Lowpinger'),
('headshot', 12, 0, 'csgo', '3_headshot.png', 'Silver Headshots'),
('Defused_The_Bomb', 20, 0, 'csgo', '4_defused_the_bomb.png', 'Gold Bomb Defuser'),
('Planted_The_Bomb', 20, 0, 'csgo', '4_planted_the_bomb.png', 'Gold Bomb Planter'),
('Rescued_A_Hostage', 20, 0, 'csgo', '4_rescued_a_hostage.png', 'Gold Hostage Rescuer'),
('Killed_A_Hostage', 20, 0, 'csgo', '4_killed_a_hostage.png', 'Gold Hostage Killer'),
('latency', 20, 0, 'csgo', '4_latency.png', 'Gold Lowpinger'),
('headshot', 20, 0, 'csgo', '4_headshot.png', 'Gold Headshots'),
('Defused_The_Bomb', 30, 0, 'csgo', '5_defused_the_bomb.png', 'Platinum Bomb Defuser'),
('Planted_The_Bomb', 30, 0, 'csgo', '5_planted_the_bomb.png', 'Platinum Bomb Planter'),
('Rescued_A_Hostage', 30, 0, 'csgo', '5_rescued_a_hostage.png', 'Platinum Hostage Rescuer'),
('Killed_A_Hostage', 30, 0, 'csgo', '5_killed_a_hostage.png', 'Platinum Hostage Killer'),
('latency', 30, 0, 'csgo', '5_latency.png', 'Platinum Lowpinger'),
('headshot', 30, 0, 'csgo', '5_headshot.png', 'Platinum Headshots'),
('Defused_The_Bomb', 50, 0, 'csgo', '6_defused_the_bomb.png', 'Supreme Bomb Defuser'),
('Planted_The_Bomb', 50, 0, 'csgo', '6_planted_the_bomb.png', 'Supreme Bomb Planter'),
('Rescued_A_Hostage', 50, 0, 'csgo', '6_rescued_a_hostage.png', 'Supreme Hostage Rescuer'),
('Killed_A_Hostage', 50, 0, 'csgo', '6_killed_a_hostage.png', 'Supreme Hostage Killer'),
('latency', 50, 0, 'csgo', '6_latency.png', 'Supreme Lowpinger'),
('headshot', 50, 0, 'csgo', '6_headshot.png', 'Supreme Headshots'),
('teamkills', 1, 0, 'csgo', '1_teamkills.png', 'Award of Team Kills'),
('teamkills', 5, 0, 'csgo', '2_teamkills.png', 'Bronze Team Kills'),
('teamkills', 12, 0, 'csgo', '3_teamkills.png', 'Silver Team Kills'),
('teamkills', 20, 0, 'csgo', '4_teamkills.png', 'Gold Team Kills'),
('teamkills', 30, 0, 'csgo', '5_teamkills.png', 'Platinum Team Kills'),
('teamkills', 50, 0, 'csgo', '6_teamkills.png', 'Supreme Team Kills'),
('mostkills', 1, 0, 'csgo', '1_mostkills.png', 'Award of Most Kills'),
('mostkills', 5, 0, 'csgo', '2_mostkills.png', 'Bronze Most Kills'),
('mostkills', 12, 0, 'csgo', '3_mostkills.png', 'Silver Most Kills'),
('mostkills', 20, 0, 'csgo', '4_mostkills.png', 'Gold Most Kills'),
('mostkills', 30, 0, 'csgo', '5_mostkills.png', 'Platinum Most Kills'),
('mostkills', 50, 0, 'csgo', '6_mostkills.png', 'Supreme Most Kills'),
('round_mvp', 1, 0, 'csgo', '1_round_mvp.png', 'Most Valuable Player'),
('round_mvp', 5, 0, 'csgo', '2_round_mvp.png', 'Bronze Most Valuable Player'),
('round_mvp', 12, 0, 'csgo', '3_round_mvp.png', 'Silver Most Valuable Player'),
('round_mvp', 20, 0, 'csgo', '4_round_mvp.png', 'Gold Most Valuable Player'),
('round_mvp', 30, 0, 'csgo', '5_round_mvp.png', 'Platinum Most Valuable Player'),
('round_mvp', 50, 0, 'csgo', '6_round_mvp.png', 'Supreme Most Valuable Player'),
('suicide', 1, 0, 'csgo', '1_suicide.png', 'Award of Most Suicides'),
('suicide', 5, 0, 'csgo', '2_suicide.png', 'Bronze Suicides'),
('suicide', 12, 0, 'csgo', '3_suicide.png', 'Silver Suicides'),
('suicide', 20, 0, 'csgo', '4_suicide.png', 'Gold Suicides'),
('suicide', 30, 0, 'csgo', '5_suicide.png', 'Platinum Suicides'),
('suicide', 50, 0, 'csgo', '6_suicide.png', 'Supreme Suicides');


-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Roles`
--

CREATE TABLE IF NOT EXISTS `hlstats_Roles` (
  `roleId` int(10) unsigned NOT NULL auto_increment,
  `game` varchar(32) NOT NULL default 'valve',
  `code` varchar(64) NOT NULL default '',
  `name` varchar(64) NOT NULL default '',
  `hidden` enum('0','1') NOT NULL default '0',
  `picked` int(6) unsigned NOT NULL default '0',
  `kills` int(6) unsigned NOT NULL default '0',
  `deaths` int(6) unsigned NOT NULL default '0',
  PRIMARY KEY  (`roleId`),
  UNIQUE KEY `gamecode` (`game`,`code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Roles`
--

INSERT INTO `hlstats_Roles` (`game`, `code`, `name`, `hidden`) VALUES
('tf','engineer','Engineer','0'),
('tf','spy','Spy','0'),
('tf','soldier','Soldier','0'),
('tf','scout','Scout','0'),
('tf','demoman','Demo Man','0'),
('tf','sniper','Sniper','0'),
('tf','medic','Medic','0'),
('tf','pyro','Pyro','0'),
('tf','heavyweapons','Heavy','0'),
('dods','Random','Random','0'),
('dods','#class_allied_garand','American Rifleman','0'),
('dods','#class_allied_thompson','American Master Sergeant','0'),
('dods','#class_allied_heavy','American Support Infantry','0'),
('dods','#class_allied_sniper','American Sniper','0'),
('dods','#class_allied_mg','American Machine Gunner','0'),
('dods','#class_allied_bazooka','American Bazooka ','0'),
('dods','#class_axis_kar98','Axis Grenadier','0'),
('dods','#class_axis_mp40','Axis Unteroffizier','0'),
('dods','#class_axis_mp44','Axis Sturmtruppe','0'),
('dods','#class_axis_sniper','Axis Scharfschütze','0'),
('dods','#class_axis_mg42','Axis MG42-Schütze','0'),
('dods','#class_axis_pschreck','Axis Panzerschreck','0'),
('ff','engineer','Engineer','0'),
('ff','spy','Spy','0'),
('ff','soldier','Soldier','0'),
('ff','scout','Scout','0'),
('ff','demoman','Demo Man','0'),
('ff','sniper','Sniper','0'),
('ff','medic','Medic','0'),
('ff','pyro','Pyro','0'),
('ff','hwguy','HWGuy','0'),
('ff','civilian','Civilian','0'),
('tfc','Scout','Scout','0'),
('tfc','Sniper','Sniper','0'),
('tfc','Soldier','Soldier','0'),
('tfc','Demoman','Demoman','0'),
('tfc','Medic','Medic','0'),
('tfc','HWGuy','HWGuy','0'),
('tfc','Pyro','Pyro','0'),
('tfc','Spy','Spy','0'),
('tfc','Engineer','Engineer','0'),
('tfc','Civilian','The Hunted','0'),
('dod','Random','Random','0'),
('dod','#class_allied_garand','American Rifleman','0'),
('dod','#class_allied_carbine','American Staff Sergeant','0'),
('dod','#class_allied_thompson','American Master Sergeant','0'),
('dod','#class_allied_grease','American Sergeant','0'),
('dod','#class_allied_sniper','American Sniper','0'),
('dod','#class_allied_heavy','American Support Infantry','0'),
('dod','#class_allied_mg','American Machine Gunner','0'),
('dod','#class_alliedpara_garand','American Para Rifleman','0'),
('dod','#class_alliedpara_carbine','American Para Staff Sergeant','0'),
('dod','#class_alliedpara_thompson','American Para Master Sergeant','0'),
('dod','#class_alliedpara_grease','American Para Sergeant','0'),
('dod','#class_alliedpara_spring','American Para Sniper','0'),
('dod','#class_alliedpara_bar','American Para Support Infantry','0'),
('dod','#class_alliedpara_30cal','American Para Machine Gunner','0'),
('dod','#class_brit_light','British Rifleman','0'),
('dod','#class_brit_medium','British Sergeant Major','0'),
('dod','#class_brit_sniper','British Marksman','0'),
('dod','#class_brit_heavy','British Gunner','0'),
('dod','#class_axis_kar98','Axis Grenadier','0'),
('dod','#class_axis_k43','Axis Stosstruppe','0'),
('dod','#class_axis_mp40','Axis Unteroffizier','0'),
('dod','#class_axis_mp44','Axis Sturmtruppe','0'),
('dod','#class_axis_sniper','Axis Scharfschütze','0'),
('dod','#class_axis_mg34','Axis MG34-Schütze','0'),
('dod','#class_axis_mg42','Axis MG42-Schütze','0'),
('dod','#class_axispara_kar98','Axis Para Grenadier','0'),
('dod','#class_axispara_k43','Axis Para Stosstruppe','0'),
('dod','#class_axispara_mp40','Axis Para Unteroffizier','0'),
('dod','#class_axispara_mp44','Axis Para Sturmtruppe','0'),
('dod','#class_axispara_scopedkar','Axis Para Scharfschütze','0'),
('dod','#class_axispara_fg42bipod','Axis Para Fg42-Zweinbein','0'),
('dod','#class_axispara_fg42scope','Axis Para Fg42-Zielfernrohr','0'),
('dod','#class_axispara_mg34','Axis Para MG34-Schütze','0'),
('dod','#class_axispara_mg42','Axis Para MG42-Schütze','0'),
('ns','soldier','Soldier','0'),
('ns','commander','Commander','0'),
('ns','skulk','Skulk','0'),
('ns','gorge','Gorge','0'),
('ns','lerk','Lerk','0'),
('ns','fade','Fade','0'),
('ns','onos','Onos','0'),
('ns','gestate','Gestate','1'),
('l4d', 'NamVet', 'Bill', '0'),
('l4d', 'TeenGirl', 'Zoey', '0'),
('l4d', 'Biker', 'Francis', '0'),
('l4d', 'Manager', 'Louis', '0'),
('l4d', 'GAS', 'Smoker', '0'),
('l4d', 'EXPLODING', 'Boomer', '0'),
('l4d', 'HUNTER', 'Hunter', '0'),
('l4d', 'TANK', 'Tank', '0'),
('l4d', 'infected', 'Infected Horde', '0'),
('l4d', 'witch', 'Witch', '0'),
('l4d2', 'NamVet', 'Bill', '0'),
('l4d2', 'TeenGirl', 'Zoey', '0'),
('l4d2', 'Biker', 'Francis', '0'),
('l4d2', 'Manager', 'Louis', '0'),
('l4d2', 'Producer', 'Rochelle', '0'),
('l4d2', 'Mechanic', 'Ellis', '0'),
('l4d2', 'Coach', 'Coach', '0'),
('l4d2', 'Gambler', 'Nick', '0'),
('l4d2', 'SMOKER', 'Smoker', '0'),
('l4d2', 'BOOMER', 'Boomer', '0'),
('l4d2', 'HUNTER', 'Hunter', '0'),
('l4d2', 'TANK', 'Tank', '0'),
('l4d2', 'CHARGER', 'Charger', '0'),
('l4d2', 'SPITTER', 'Spitter', '0'),
('l4d2', 'JOCKEY', 'Jockey', '0'),
('l4d2', 'infected', 'Infected Horde', '0'),
('l4d2', 'witch', 'Witch', '0'),
('ges', 'jaws', 'Jaws', '0'),
('ges', 'bond', 'Bond', '0'),
('ges', 'boris', 'Boris', '0'),
('ges', 'Mayday', 'May Day', '0'),
('ges', 'Mishkin', 'Mishkin', '0'),
('ges', 'oddjob', 'Oddjob', '0'),
('ges', 'ourumov', 'Ourumov', '0'),
('ges', 'samedi', 'Samedi', '0'),
('ges', 'valentin', 'Valentin', '0'),
('dystopia','1','Light','0'),
('dystopia','2','Medium','0'),
('dystopia','3','Heavy','0'),
('aoc', 'Longbowman', 'Longbowman', '0'),
('aoc', 'Crossbowman', 'Crossbowman', '0'),
('aoc', 'Javelineer', 'Javelineer', '0'),
('aoc', 'Man at Arms', 'Man at Arms', '0'),
('aoc', 'Sergeant', 'Sergeant', '0'),
('aoc', 'Guardsman', 'Guardsman', '0'),
('aoc', 'Crusader', 'Crusader', '0'),
('aoc', 'Knight', 'Knight', '0'),
('aoc', 'Heavy Knight', 'Heavy Knight', '0'),
('pvkii', 'Berserker', 'Berserker', '0'),
('pvkii', 'Gestir', 'Gestir', '0'),
('pvkii', 'Huscarl', 'Huscarl', '0'),
('pvkii', 'Captain', 'Captain', '0'),
('pvkii', 'Skirmisher', 'Skirmisher', '0'),
('pvkii', 'Archer', 'Archer', '0'),
('pvkii', 'Heavy Knight', 'Heavy Knight', '0'),
('nd', 'ASSAULT', 'Assault', '0'),
('nd', 'EXO', 'Exo', '0'),
('nd', 'STEALTH', 'Stealth', '0'),
('nd', 'SUPPORT', 'Support', '0'),
('dinodday', '#class_blue_class2', 'Cpl. Joe Spencer', '0'),
('dinodday', '#class_blue_class1', 'Cpt. Jack Hardgrave', '0'),
('dinodday', '#class_red_class11', 'Microraptor', '0'),
('dinodday', '#class_red_class10', 'Compsognathus', '0'),
('dinodday', '#class_red_class7', 'Stygimoloch', '0'),
('dinodday', '#class_red_class6', 'Dilophosaurus', '0'),
('dinodday', '#class_red_class5', 'Desmatosuchus', '0'),
('dinodday', '#class_red_class4', 'Velociraptor', '0'),
('dinodday', '#class_red_class3', 'Hpt.Fw. Wolfgang von Graff', '0'),
('dinodday', '#class_red_class2', 'OLt. Karl Hissmann', '0'),
('dinodday', '#class_red_class1', 'Hptm. Kurt Streicher', '0'),
('dinodday', '#class_blue_class3', 'Cpt. Nigel Blithe-Crossley', '0'),
('dinodday', '#class_blue_class4', 'Ilona Vike', '0'),
('dinodday', '#class_blue_class5', 'Camille Brun', '0'),
('dinodday', '#class_blue_class6', 'Jakob Frank', '0'),
('dinodday', '#class_blue_class7', 'Trigger', '0');

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Servers`
--

CREATE TABLE IF NOT EXISTS `hlstats_Servers` (
  `serverId` int(10) unsigned NOT NULL auto_increment,
  `address` varchar(32) NOT NULL default '',
  `port` int(5) unsigned NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  `sortorder` tinyint NOT NULL default '0',
  `game` varchar(32) NOT NULL default 'valve',
  `publicaddress` varchar(128) NOT NULL default '',
  `statusurl` varchar(255) default NULL,
  `rcon_password` varchar(128) NOT NULL default '',
  `kills` int(10) NOT NULL default '0',
  `players` int(11) NOT NULL default '0',
  `rounds` int(10) NOT NULL default '0',
  `suicides` int(10) NOT NULL default '0',
  `headshots` int(10) NOT NULL default '0',
  `bombs_planted` int(10) NOT NULL default '0',
  `bombs_defused` int(10) NOT NULL default '0',
  `ct_wins` int(10) NOT NULL default '0',
  `ts_wins` int(10) NOT NULL default '0',
  `act_players` int(4) NOT NULL default '0',
  `max_players` int(4) NOT NULL default '0',
  `act_map` varchar(64) NOT NULL default '',
  `map_rounds` int(6) NOT NULL default '0',
  `map_ct_wins` int(10) NOT NULL default '0',
  `map_ts_wins` int(10) NOT NULL default '0',
  `map_started` int(10) NOT NULL default '0',
  `map_changes` int(10) NOT NULL default '0',
  `ct_shots` int(11) NOT NULL default '0',
  `ct_hits` int(11) NOT NULL default '0',
  `ts_shots` int(11) NOT NULL default '0',
  `ts_hits` int(11) NOT NULL default '0',
  `map_ct_shots` int(11) NOT NULL default '0',
  `map_ct_hits` int(11) NOT NULL default '0',
  `map_ts_shots` int(11) NOT NULL default '0',
  `map_ts_hits` int(11) NOT NULL default '0',
  `lat` FLOAT(7,4) NULL,
  `lng` FLOAT(7,4) NULL,
  `city` varchar(64) NOT NULL default '',
  `country` varchar(64) NOT NULL default '',
  `last_event` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`serverId`),
  UNIQUE KEY `addressport` (`address`,`port`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 PACK_KEYS=0;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Servers_Config`
--

CREATE TABLE IF NOT EXISTS `hlstats_Servers_Config` (
  `serverId` int(11) unsigned NOT NULL default '0',
  `parameter` varchar(50) NOT NULL,
  `value` varchar(128) NOT NULL,
  `serverConfigId` int(11) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`serverId`,`parameter`),
  KEY `serverConfigId` (`serverConfigId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Servers_Config_Default`
--

CREATE TABLE IF NOT EXISTS `hlstats_Servers_Config_Default` (
  `parameter` varchar(50) NOT NULL,
  `value` varchar(128) NOT NULL,
  `description` mediumtext character set utf8 collate utf8_unicode_ci,
  PRIMARY KEY  (`parameter`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Servers_Config_Default`
--

INSERT INTO `hlstats_Servers_Config_Default` (`parameter`, `value`, `description`) VALUES
('Admins', '', 'Steamids seperated by "," ("STEAM_0:1:XXX,STEAM_0:0:XXX,STEAM_0:1:XXX").'),
('AutoBanRetry', '0', 'Auto-bans player for 5 minutes if the disconnect from the server. Prevent players from reconnecting until the have a good team and won''t loose many points. 1=on 0=off(default)'),
('AutoTeamBalance', '0', 'If rcon is enabled hlstats automatically analyzed teams and balance players for fair teams. It will make teams numerical even and also swap players based on there skill to balance teams. 1=on, 0=off(default)'),
('BonusRoundIgnore', '0', 'Ignore frags and actions after round has ended (for applicable games). 1=on, 0=off(default)'),
('BonusRoundTime', '0', 'Length (in seconds) of mp_bonusroundtime (as failsafe in case round_start event is not detected).'),
('BroadCastEvents', '1', 'Nearly all Events will be directly broadcasted through rcon on the server. You will directly see, how many points you got for a kill or bomb plating etc. 1=on 0=off(default)'),
('BroadCastEventsCommand', 'hlx_sm_psay', 'The command to broadcast the events. Default is the "say"-command'),
('BroadCastEventsCommandAnnounce', 'hlx_sm_csay', 'Command to announce ingame summary stats and admin email etc. Default is "say".'),
('BroadCastPlayerActions', '1', 'Toggle broadcasting PlayerActions ingame. (f.e Touched a hostage or dropped the Bomb). 1=on(default) 0=off'),
('ConnectAnnounce', '1', 'Toggle display of message upon each player connect showing player points/kills, rank, and country of origin. 1=on(default) 0=off'),
('DefaultDisplayEvents', '1', 'Toggle players default option to see kill/event messages on server. 1=on(default) 0=off'),
('DisplayResultsInBrowser', '1', 'If enabled (1=on 0=off(default)) the player queries will displayed in the valve browser as small html files. (Not support in all game and admin mod combinations)'),
('EnablePublicCommands', '1', 'If activated players can report their statistics to all players in the chat area.'),
('GameEngine', '3', 'Game engine of game on this server:<UL>\r\n<LI>1 = HL1 (GoldSource).\r\n<LI>2 = HL2 (Source original).\r\n<LI>3 = HL2ep2 (Source OrangeBox)(default).</UL>'),
('GameType', '0', 'Mode of the current gametype:<UL>\r\n<LI>0 = Normal mod standard (default).\r\n<LI>1 = Deathmatch (only need to set if team names are NOT "Unassigned" during deathmatch (ie. in CSS Deathmatch).</UL>'),
('HLStatsURL', 'http://yoursite.com/hlstats', 'URL to your HLStats. This is broadcasted to master server and displays ingame.'),
('IgnoreBots', '1', 'If enabled, bots are not tracked 1=on(default) 0=off.'),
('MinimumPlayersRank', '0', 'Required players position to be allowed playing on the server (e.g Top500-Server).'),
('MinPlayers', '4', 'Specifies the minimum number of players required in the server for most player events (objectives, frags, etc.) to be recorded.\r\nThis prevents players from hopping on an empty server and boosting their skill rating by capturing the flag, etc., with no opposition.'),
('Mod', 'SOURCEMOD', 'Valid values are SOURCEMOD, MINISTATS, BEETLE, MANI, and AMXX if one of such plugins are installed.'),
('PlayerEvents', '1', 'Determine if players can get player-specific display ingame (f.e. /skill)'),
('PlayerEventsAdminCommand', '', 'Some messages (f.e. team-balancer) are only for admins. here you can specify a admin-command. Default is "".'),
('PlayerEventsCommand', 'hlx_sm_psay', 'The command to display player events. Default is the "say"-command.'),
('PlayerEventsCommandOSD', 'hlx_sm_msay', 'The command to display amx style menu for "/rank", "/session", "/kpd" commands. Default is "".'),
('ShowStats', '1', 'If set to 1 (default) periodically stats are shown ingame with the broadcast-command.'),
('SkillMode', '2', 'Mode of skill changes on frags with following options:\r\n<UL>\r\n<LI>0 = Normal (Victims lose all the points which the killer gains).\r\n<LI>1 = Victims lose 3/4 the points which the killer gains.\r\n<LI>2 = Victims lose 1/2 the points which the killer gains.\r\n<LI>3 = Victims lose 1/4 the points which the killer gains.\r\n<LI>4 = Victims lose no points.\r\n<LI>5 = ZPS-only. Survivor victims lose 1/2, Zombie victims lose 1/4\r\n</UL>'),
('SuicidePenalty', '5', 'Penalty for a suicide (Default: 5 points).'),
('SwitchAdmins', '0', 'Defines if admins are switched from auto-team balancer 1=on 0=off(default).'),
('TKPenalty', '50', 'Penalty for a team kill (Default: 50 points).'),
('TrackServerLoad', '1', 'Saves every 5 min how much players are playing on the server.'),
('UpdateHostname', '1', 'Toggles auto-update of server name from hostname cvar 1=on(default) 0=off'),
('PlayerEventsCommandHint', 'hlx_sm_hint', 'The command to display "hint" style messages for ATB switches. Default is "".');
-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Servers_VoiceComm`
--

CREATE TABLE IF NOT EXISTS `hlstats_Servers_VoiceComm` (
  `serverId` int(11) unsigned NOT NULL auto_increment,
  `name` varchar(128) NOT NULL,
  `addr` varchar(128) NOT NULL,
  `password` varchar(128) default NULL,
  `descr` varchar(255) default NULL,
  `queryPort` int(11) unsigned NOT NULL default '51234',
  `UDPPort` int(11) unsigned NOT NULL default '8767',
  `serverType` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`serverId`),
  UNIQUE KEY `address` (`addr`,`UDPPort`,`queryPort`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_server_load`
--

CREATE TABLE IF NOT EXISTS `hlstats_server_load` (
  `server_id` int(10) NOT NULL default '0',
  `timestamp` int(11) NOT NULL default '0',
  `act_players` tinyint(2) NOT NULL default '0',
  `min_players` tinyint(2) NOT NULL default '0',
  `max_players` tinyint(2) NOT NULL default '0',
  `map` varchar(64) default NULL,
  `uptime` varchar(10) NOT NULL default '0',
  `fps` varchar(10) NOT NULL default '0',
  KEY `server_id` (`server_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Teams`
--

CREATE TABLE IF NOT EXISTS `hlstats_Teams` (
  `teamId` int(10) unsigned NOT NULL auto_increment,
  `game` varchar(32) NOT NULL default 'valve',
  `code` varchar(64) NOT NULL default '',
  `name` varchar(64) NOT NULL default '',
  `hidden` enum('0','1') NOT NULL default '0',
  `playerlist_bgcolor` varchar(7) default NULL,
  `playerlist_color` varchar(7) default NULL,
  `playerlist_index` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`teamId`),
  UNIQUE KEY `gamecode` (`game`,`code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Teams`
--

INSERT INTO `hlstats_Teams` (`game`, `code`, `name`, `hidden`, `playerlist_bgcolor`, `playerlist_color`, `playerlist_index`) VALUES
('csp','Terrorists','Terrorists','0','#FFD5D5','#FF2D2D',1),
('csp','Counter-Terrorists','Counter-Terrorists','0','#D2E8F7','#0080C0',2),
('css','TERRORIST','Terrorist','0','#FFD5D5','#FF2D2D',1),
('css','CT','Counter-Terrorist','0','#D2E8F7','#0080C0',2),
('hl2mp','Combine','The Combine','0','#D2E8F7','#0080C0',1),
('hl2mp','Rebels','Rebel Forces','0','#FFD5D5','#FF2D2D',2),
('tf','Red','The RED','','#FFD5D5','#FF2D2D',2),
('tf','Blue','The BLU','','#D2E8F7','#0080C0',1),
('hl2ctf','Combine','Combine','0','#D2E8F7','#0080C0',1),
('hl2ctf','Rebels','Rebels','0','#FFD5D5','#FF2D2D',2),
('dods','Allies','Allies','0','#C1FFC1','#006600',2),
('dods','Axis','Axis','0','#FFD5D5','#FF2D2D',1),
('insmod','U.S. Marines','U.S. Marines','0','#D2E8F7','#0080C0',2),
('insmod','Iraqi Insurgents','Iraqi Insurgents','0','#FFD5D5','#FF2D2D',1),
('ff', '#FF_TEAM_YELLOW', 'Yellow Team', '0', '#F7FF89', '#808700', 3),
('ff', '#FF_TEAM_GREEN', 'Green Team', '0', '#93FF89', '#4B8246', 4),
('ff', 'Defenders', 'Defenders', '0', '#D2E8F7','#0080C0', 5),
('ff', 'Attackers', 'Attackers', '0', '#FFD5D5', '#FF2D2D', 6),
('ff', '#FF_TEAM_RED', 'Red Team', '0', '#FFD5D5', '#FF2D2D', 1),
('ff', '#FF_TEAM_BLUE', 'Blue Team', '0', '#D2E8F7','#0080C0', 2),
('hidden','Hidden','Subject 617', '0', '#F7FF89', '#808700', 1),
('hidden','IRIS','I.R.I.S.', '0', '#D2E8F7','#0080C0', 2),
('zps','Undead','Undead', '0', '#F7FF89', '#808700', 1),
('zps','Survivor','Survivors', '0', '#D2E8F7','#0080C0', 2),
('aoc','The Mason Order','The Mason Order','','#FFD5D5','#FF2D2D',2),
('aoc','Agathia Knights','Agathia Knights','','#D2E8F7','#0080C0',1),
('cstrike','TERRORIST','Terrorist','0','#FFD5D5','#FF2D2D',1),
('cstrike','CT','Counter-Terrorist','0','#D2E8F7','#0080C0',2),
('tfc','Blue','Blue','0','#D2E8F7','#0080C0',1),
('tfc','Red','Red','0','#FFD5D5','#FF2D2D',2),
('tfc','#Hunted_team1','(Hunted) VIP','0','#FFD5D5','#FF2D2D',5),
('tfc','#Hunted_team2','(Hunted) Bodyguards','0','#FFD5D5','#FF2D2D',6),
('tfc','#Hunted_team3','(Hunted) Assassins','0','#D2E8F7','#0080C0',7),
('tfc','#Dustbowl_team1','Attackers','0','#D2E8F7','#0080C0',8),
('tfc','#Dustbowl_team2','Defenders','0','#FFD5D5','#FF2D2D',9),
('dod','Allies','Allies','0','#C1FFC1','#006600',2),
('dod','Axis','Axis','0','#FFD5D5','#FF2D2D',1),
('ns','alien1team','Aliens','0','#F5D295','#C0851D',2),
('ns','marine1team','Marines','0','#D2E8F7','#0080C0',1),
('l4d', 'Survivor', 'Survivors', '0', '#E0E4E5', '#4B6168', 1),
('l4d', 'Infected', 'Infected', '0', '#E5D5D5', '#68090B', 2),
('l4d2', 'Survivor', 'Survivors', '0', '#E0E4E5', '#4B6168', 1),
('l4d2', 'Infected', 'Infected', '0', '#E5D5D5', '#68090B', 2),
('fof', 'DESPERADOS', 'Desperados', '0', '#D2E8F7','#0080C0', 1),
('fof', 'VIGILANTES', 'Vigilantes', '0', '#FFD5D5','#FF2D2D', 2),
('ges', 'MI6', 'MI6', '0', '#D2E8F7','#0080C0', 1),
('ges', 'Janus', 'Janus', '0', '#FFD5D5','#FF2D2D', 2),
('bg2','British','The British','','#FFD5D5','#FF2D2D',2),
('bg2','Americans','The Americans','','#D2E8F7','#0080C0',1),
('sgtls','Goa''uld','Goa''uld','','#FFD5D5','#FF2D2D',2),
('sgtls','Tau''ri','Tau''ri','','#D2E8F7','#0080C0',1),
('dystopia','Punks','Punks','','#FFD5D5','#FF2D2D',2),
('dystopia','Corps','Corps','','#D2E8F7','#0080C0',1),
('nts','Jinrai','Jinrai','0','#9AFF9A','#447044',1),
('nts','NSF','NSF','0','#7EA5CC','#4F677F',2),
('pvkii', 'Pirates', 'Pirates', '0', '#FFD5D5', '#FF2D2D', 1),
('pvkii', 'Vikings', 'Vikings', '0', '#93FF89', '#4B8246', 2),
('pvkii', 'Knights', 'Knights', '0', '#D2E8F7', '#0080C0', 3),
('valve', 'scientist', 'Team robo', '0', '#D2E8F7', '#0080C0',1),
('valve', 'hgrunt', 'Team hgrunt', '0', '#FFD5D5', '#FF2D2D',2),
('nd', 'Consortium', 'Consortium', '0', '#63B6EF', '#072D52', 1),
('nd', 'Empire', 'Empire', '0', '#FA3232', '#680E10', 2),
('csgo', 'TERRORIST', 'Terrorist', '0', '#FFD5D5', '#FF2D2D', 1),
('csgo', 'CT', 'Counter-Terrorist', '0', '#D2E8F7', '#0080C0', 2),
('dinodday', '#DDD_Team_Blue', 'Allies', '0', '#C1FFC1', '#006600', 2),
('dinodday', '#DDD_Team_Red', 'Axis', '0', '#FFD5D5', '#FF2D2D', 1);

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Trend`
--

CREATE TABLE IF NOT EXISTS `hlstats_Trend` (
  `timestamp` int(11) NOT NULL default '0',
  `game` varchar(32) NOT NULL default '',
  `players` int(11) NOT NULL default '0',
  `kills` int(11) NOT NULL default '0',
  `headshots` int(11) NOT NULL default '0',
  `servers` int(11) NOT NULL default '0',
  `act_slots` int(11) NOT NULL default '0',
  `max_slots` int(11) NOT NULL default '0',
  KEY `game` (`game`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Users`
--

CREATE TABLE IF NOT EXISTS `hlstats_Users` (
  `username` varchar(16) NOT NULL default '',
  `password` varchar(32) NOT NULL default '',
  `acclevel` int(11) NOT NULL default '0',
  `playerId` int(11) NOT NULL default '0',
  PRIMARY KEY  (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Users`
--

INSERT INTO `hlstats_Users` VALUES ('admin','e10adc3949ba59abbe56e057f20f883e',100,0);

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Weapons`
--

CREATE TABLE IF NOT EXISTS `hlstats_Weapons` (
  `weaponId` int(10) unsigned NOT NULL auto_increment,
  `game` varchar(32) NOT NULL default 'valve',
  `code` varchar(64) NOT NULL default '',
  `name` varchar(128) NOT NULL default '',
  `modifier` float(10,2) NOT NULL default '1.00',
  `kills` int(10) unsigned NOT NULL default '0',
  `headshots` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`weaponId`),
  UNIQUE KEY `gamecode` (`game`,`code`),
  KEY `code` (`code`),
  KEY `modifier` (`modifier`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Weapons`
--

INSERT INTO `hlstats_Weapons` (`game`, `code`, `name`, `modifier`) VALUES
('tf', 'tf_projectile_rocket', 'Rocket Launcher', 1.00),
('tf', 'sniperrifle', 'Sniper Rifle', 1.00),
('tf', 'minigun', 'Minigun (Sasha)', 1.00),
('tf', 'obj_sentrygun', 'Sentry Gun (Level 1)', 1),
('tf', 'knife', 'Knife', 2.00),
('tf', 'scattergun', 'Scatter Gun', 1.25),
('tf', 'tf_projectile_pipe', 'Grenade Launcher', 1.00),
('tf', 'flamethrower', 'Flamethrower', 1.00),
('tf', 'tf_projectile_pipe_remote', 'Stickybomb Launcher', 1.00),
('tf', 'shotgun_primary', 'Engy Shotgun', 1.00),
('tf', 'smg', 'Submachine Gun', 1.00),
('tf', 'shotgun_soldier', 'Soldier Shotgun', 1.00),
('tf', 'syringegun_medic', 'Syringe Gun', 1.00),
('tf', 'revolver', 'Revolver', 1.00),
('tf', 'samrevolver', 'Big Kill', 1.00),
('tf', 'shotgun_pyro', 'Pyro Shotgun', 1.00),
('tf', 'world', 'World', 1.00),
('tf', 'bat', 'Bat', 2.00),
('tf', 'wrench', 'Wrench', 2.00),
('tf', 'wrench_golden', 'Golden Wrench', 2.00),
('tf', 'bonesaw', 'Bone Saw', 2.00),
('tf', 'shotgun_hwg', 'Heavy Shotgun', 1.00),
('tf', 'club', 'Kukri', 2.00),
('tf', 'pistol_scout', 'Scout Pistol', 1.50),
('tf', 'maxgun', 'Lugermorph', 1.50),
('tf', 'pistol', 'Engy Pistol', 1.00),
('tf', 'bottle', 'Bottle', 2.00),
('tf', 'shovel', 'Shovel', 2.00),
('tf', 'fireaxe', 'Fire Axe', 2.00),
('tf', 'fists', 'Fists', 2.00),
('tf', 'axtinguisher', 'Axtinguisher', 2.00),
('tf', 'backburner', 'Backburner', 1.00),
('tf', 'blutsauger', 'Blutsauger', 1.50),
('tf', 'deflect_flare', 'Deflected Flare', 20.00),
('tf', 'deflect_promode', 'Deflected Grenade', 2.00),
('tf', 'deflect_rocket', 'Deflected Rocket', 2.00),
('tf', 'deflect_sticky', 'Deflected Sticky', 2.00),
('tf', 'deflect_arrow', 'Deflected Arrow', 2.00),
('tf', 'flaregun', 'Flaregun', 2.00),
('tf', 'natascha', 'Minigun (Natascha)', 1.00),
('tf', 'gloves', 'K.G.B.', 2.00),
('tf', 'taunt_heavy', 'Showdown', 5.00),
('tf', 'taunt_pyro', 'Hadouken', 5.00),
('tf', 'ubersaw', 'Ubersaw', 2.00),
('tf', 'taunt_scout', 'Home Run', 3.00),
('tf', 'sandman', 'The Sandman', 1.75),
('tf', 'obj_sentrygun2', 'Sentry Gun (Level 2)', 1),
('tf', 'obj_sentrygun3', 'Sentry Gun (Level 3)', 1),
('tf', 'taunt_sniper', 'Skewer', 3),
('tf', 'taunt_spy', 'Fencing', 3),
('tf', 'tf_projectile_arrow', 'Huntsman', 1),
('tf', 'ambassador', 'Ambassador', 1),
('tf', 'tf_pumpkin_bomb', 'Pumpkin Bomb', 2),
('tf', 'force_a_nature', 'Force-A-Nature', 1),
('tf', 'tf_projectile_arrow_fire', 'Huntsman (Fire arrow)', 1),
('tf', 'telefrag', 'Telefrag', 2),
('tf', 'rocketlauncher_directhit', 'Direct Hit', 1.0),
('tf', 'unique_pickaxe', 'Equalizer', 2.0),
('tf', 'sword', 'Eyelander', 2.0),
('tf', 'sticky_resistance', 'Scottish Resistance', 1.0),
('tf', 'taunt_demoman', 'Decapitation', 5.0),				
('tf', 'taunt_soldier', 'Kamikaze', 5.0),
('tf', 'demoshield', 'Chargin'' Targe', 2.0),
('tf', 'ball', 'Baseball', 2.5),
('tf', 'taunt_medic', 'Spinal Tap', 5.0),
('tf', 'paintrain', 'The Pain Train', 2.00),
('tf', 'sledgehammer', 'The Homewrecker', 2.00),
('tf', 'tribalkukri', 'Tribalman''s Shiv', 2.00),
('tf', 'battleaxe', 'Scotsman''s Skullcutter', 2.00),
('tf', 'frontier_justice', 'Frontier Justice', 1.00),
('tf', 'obj_minisentry', 'Sentry Gun (Mini)', 1.00),
('tf', 'robot_arm', 'Gunslinger', 2.00),
('tf', 'robot_arm_combo_kill', 'Gunslinger Combo', 2.00),
('tf', 'bleed_kill', 'Bleed Kill', 1.80),
('tf', 'robot_arm_blender_kill', 'Organ Grinder', 5.00),
('tf', 'southern_hospitality', 'Southern Hospitality', 2.00),
('tf', 'taunt_guitar_kill', 'Dischord', 2.00),
('tf', 'wrangler_kill', 'Wrangler', 1.00),
('tf', 'battleneedle', 'The Vita-Saw', 2.00),
('tf', 'powerjack', 'The Powerjack', 2.00),
('tf', 'degreaser', 'The Degreaser', 1.00),
('tf', 'short_stop', 'The Shortstop', 1.00),
('tf', 'holy_mackerel', 'The Holy Mackerel', 2.00),
('tf', 'letranger', 'L''Etranger', 1.00),
('tf', 'eternal_reward', 'Your Eternal Reward', 2.00),
('tf', 'fryingpan', 'Frying Pan', 2.00),
('tf', 'bushwacka', 'The Bushwacka', 2.00),
('tf', 'gloves_running_urgently', 'Gloves of Running Urgently', 2.00),
('tf', 'blackbox', 'The Black Box', 1.00),
('tf', 'sydney_sleeper', 'The Sydney Sleeper', 1.00),
('tf', 'headtaker', 'Horseless Headless Horsemann''s Headtaker', 2.0),
('tf', 'claidheamohmor', 'The Claidheamohmor', 2.0),
('tf', 'back_scratcher', 'The Back Scratcher', 2.0),
('tf', 'boston_basher', 'The Boston Basher', 2.0),
('tf', 'steel_fists', 'The Fists of Steel', 2.0),
('tf', 'amputator', 'The Amputator', 1.0),
('tf', 'crusaders_crossbow', 'The Crusader''s Crossbow', 1.0),
('tf', 'ullapool_caber', 'The Ullapool Caber', 2.0),
('tf', 'ullapool_caber_explosion', 'The Ullapool Caber BOOM', 1.2),
('tf', 'loch_n_load', 'The Loch-n-Load', 1.0),
('tf', 'brass_beast', 'The Brass Beast', 1.0),
('tf', 'warrior_spirit', 'The Warrior''s Spirit', 2.0),
('tf', 'candy_cane', 'The Candy Cane', 2.0),
('tf', 'wrench_jag', 'The Jag', 2.0),
('tf', 'iron_curtain', 'The Iron Curtain', 1.0),
('tf', 'atomizer', 'Atomizer', 2.00),
('tf', 'bazaar_bargain', 'Bazaar Bargain', 1.00),
('tf', 'demokatana', 'Half-Zatoichi', 2.00),
('tf', 'detonator', 'Detonator', 2.00),
('tf', 'disciplinary_action', 'Disciplinary Action', 2.00),
('tf', 'enforcer', 'Enforcer', 2.00),
('tf', 'eviction_notice', 'Eviction Notice', 2.00),
('tf', 'family_business', 'Family Business', 1.00),
('tf', 'kunai', 'Conniver''s Kunai', 2.00),
('tf', 'liberty_launcher', 'Liberty Launcher', 1.00),
('tf', 'mantreads', 'Mantreads', 2.00),
('tf', 'market_gardener', 'Market Gardener', 2.00),
('tf', 'persian_persuader', 'Persian Persuader', 2.00),
('tf', 'proto_syringe', 'Overdose', 2.00),
('tf', 'reserve_shooter', 'Reserve Shooter', 2.00),
('tf', 'scout_sword', 'Three-Rune Blade', 2.00),
('tf', 'shahanshah', 'Shahanshah', 2.00),
('tf', 'soda_popper', 'Soda Popper', 1.25),
('tf', 'solemn_vow', 'Solemn Vow', 2.00),
('tf', 'the_maul', 'Maul', 2.00),
('tf', 'the_winger', 'Winger', 1.00),
('tf', 'tomislav', 'Tomislav', 1.00),
('tf', 'warfan', 'Fan O''War', 2.00),
('tf', 'big_earner', 'Big Earner', 2.00),
('tf', 'saxxy', 'Saxxy', 2.00),
('tf', 'splendid_screen', 'Splendid Screen', 2.00),
('tf', 'taunt_soldier_lumbricus', 'Kamikaze (Lumbricus Lid)', 5.00),
('tf', 'nessieclub', 'Nessie\'s Nine Iron', 2.00),
('tf', 'mailbox', 'Postal Pummeler', 2.00),
('tf', 'lava_axe', 'Sharpened Volcano Fragment', 2.00),
('tf', 'lava_bat', 'Sun-on-a-Stick', 2.00),
('tf', 'cow_mangler', 'Cow Mangler 5000', 1.00),
('tf', 'righteous_bison', 'Righteous Bison', 2.00),
('tf', 'tf_projectile_energy_ball', 'Deflected Cow Mangler Shot', 5.00),
('tf', 'machina', 'Machina', 2.00),
('tf', 'diamondback', 'The Diamondback', 2.00),
('tf', 'widowmaker', 'The Widowmaker', 2.00),
('tf', 'short_circuit', 'The Short Circuit', 2.00),
('tf', 'quake_rl', 'Original', 2.00),
('tf', 'scotland_shard', 'Scottish Handshake', 2.00),
('tf', 'nonnonviolent_protest', 'Conscientious Objector', 2.00),
('tf', 'deflect_flare_detonator', 'Deflected Flare (Detonator)', 2.00),
('tf', 'deflect_huntsman_flyingburn', 'Deflect Huntsman Burning Arrow', 2.00),
('tf', 'unarmed_combat', 'Unarmed Combat', 2.00),
('tf', 'eureka_effect', 'Eureka Effect', 2.00),
('tf', 'holiday_punch', 'Holiday Punch', 2.00),
('tf', 'manmelter', 'Manmelter', 2.00),
('tf', 'phlogistinator', 'Phlogistinator', 2.00),
('tf', 'pomson', 'Pomson 6000', 2.00),
('tf', 'spy_cicle', 'Spy-cicle', 2.00),
('tf', 'thirddegree', 'Third Degree', 2.00),
('tf', 'wrap_assassin', 'Wrap Assassin', 2.00),
('tf', 'pep_pistol', 'Pretty Boy\'s Pocket Pistol ', 1.50),
('tf', 'pep_brawlerblaster', 'Baby Face\'s Blaster', 1.00),
('tf', 'dumpster_device', 'Beggar\'s Bazooka', 1.00),
('tf', 'pro_smg', 'The Cleaner\'s Carbine', 1.00),
('tf', 'pro_rifle', 'The Hitman\'s Heatmaker', 1.00),
('tf', 'rainblower', 'The Rainblower', 1.00),
('tf', 'lollichop', 'The Lollichop', 2.00),
('tf', 'scorchshot', 'The Scorch Shot', 2.00),
('tf', 'unique_pickaxe_escape', 'The Escape Plan', 1.00),
('csp', 'knife', 'Bundeswehr Advanced Combat Knife', 2.00),
('csp', 'usp', 'H&K USP .45 Tactical', 1.40),
('csp', 'glock', 'Glock 18 Select Fire', 1.40),
('csp', 'deagle', 'Desert Eagle .50AE', 1.20),
('csp', 'mp5navy', 'H&K MP5-Navy', 1.20),
('csp', 'm4a1', 'Colt M4A1 Carbine', 1.00),
('csp', 'ak47', 'Kalashnikov AK-47', 1.00),
('csp', 'awp', 'Arctic Warfare Magnum (Police)', 1.00),
('csp', 'hegrenade', 'High Explosive Grenade', 1.80),
('csp', 'famas', 'Fusil Automatique', 1.00),
('csp', 'galil', 'Galil', 1.10),
('css','knife','Bundeswehr Advanced Combat Knife',2.00),
('css','usp','H&K USP .45 Tactical',1.40),
('css','glock','Glock 18 Select Fire',1.40),
('css','deagle','Desert Eagle .50AE',1.20),
('css','p228','Sig Sauer P-228',1.50),
('css','m3','Benelli M3 Super 90 Combat',1.20),
('css','xm1014','Benelli/H&K M4 Super 90 XM1014',1.10),
('css','mp5navy','H&K MP5-Navy',1.20),
('css','tmp','Steyr Tactical Machine Pistol',1.50),
('css','p90','FN P90',1.20),
('css','m4a1','Colt M4A1 Carbine',1.00),
('css','ak47','Kalashnikov AK-47',1.00),
('css','sg552','Sig Sauer SG-552 Commando',1.00),
('css','scout','Steyr Scout',1.10),
('css','awp','Arctic Warfare Magnum (Police)',1.00),
('css','g3sg1','H&K G3/SG1 Sniper Rifle',0.80),
('css','m249','M249 PARA Light Machine Gun',1.20),
('css','hegrenade','High Explosive Grenade',1.80),
('css','flashbang','Flashbang',5.00),
('css','elite','Dual Beretta 96G Elite',1.40),
('css','aug','Steyr Aug',1.00),
('css','mac10','Ingram MAC-10',1.50),
('css','fiveseven','FN Five-Seven',1.50),
('css','ump45','H&K UMP45',1.20),
('css','sg550','Sig SG-550 Sniper',0.80),
('css','famas','Fusil Automatique',1.00),
('css','galil','Galil',1.10),
('css','smokegrenade_projectile','Smoke Grenade',5.00),
('css','PROP_PHYSICS','Rare Physics kill',10.00),
('hl2mp','env_explosion','Explosion',2.70),
('hl2mp','player','pTelefrag',10.00),
('hl2mp','physbox','bTelefrag',7.20),
('hl2mp','physics','Physics',7.00),
('hl2mp','crowbar','Crowbar',15.00),
('hl2mp','stunstick','Stun Stick',15.00),
('hl2mp','pistol','USP Match',10.00),
('hl2mp','357','.357 Magnum',4.30),
('hl2mp','smg1','Sub Machine Gun',0.00),
('hl2mp','smg1_grenade','Impact Grenade',2.50),
('hl2mp','ar2','Combine Assault Rifle',1.00),
('hl2mp','combine_ball','Combine Ball',2.40),
('hl2mp','shotgun','Shotgun',3.80),
('hl2mp','crossbow_bolt','Crossbow',7.30),
('hl2mp','rpg_missile','Rocket Propelled Grenade',0.00),
('hl2mp','grenade_frag','Frag Grenade',3.70),
('hl2mp','slam','Slam',4.60),
('hl2mp','physcannon','Physics Cannon',2.70),
('hl2ctf','stunstick','Stun Stick',2.50),
('hl2ctf','Crowbar','Crowbar',2.50),
('hl2ctf','crossbow_bolt','Crossbow',1.75),
('hl2ctf','Slam','S.L.A.M',1.80),
('hl2ctf','Pistol','USP Match',1.75),
('hl2ctf','grenade_frag','Grenade',1.75),
('hl2ctf','combine_ball','Combine Ball',1.50),
('hl2ctf','physcannon','Gravity Gun',1.15),
('hl2ctf','Shotgun','Shotgun',1.10),
('hl2ctf','357','.357 Magnum',1.10),
('hl2ctf','rpg_missile','Rocket Propelled Grenade',1.00),
('hl2ctf','ar2','Combine Assault Rifle',1.00),
('hl2ctf','smg1','Sub Machine Gun',1.00),
('hl2ctf','env_explosion','Explosion',1.00),
('hl2ctf','ctf_combine_turret','Combine Turret',1.25),
('hl2ctf','ctf_rebel_turret','Rebel Turret',1.25),
('hl2ctf','ctf_oicw','OICW Rifle',1.00),
('hl2ctf','ctf_sniper','Sniper Rifle',1.10),
('hl2ctf','grenade_ctf_oicw_airburst','OICW Grenade',1.20),
('hl2ctf','ctf_alyxgun','Alyx Gun',1.15),
('hl2ctf','smg1_grenade','SMG Grenade',1.10),
('dods','k98','Mauser Kar 98k',1.30),
('dods','mp40','MP40 Machine Pistol',1.25),
('dods','k98_scoped','Mauser Karbiner k98 Sniper Rifle',1.50),
('dods','mp44','MP44 Assault Rifle',1.35),
('dods','colt','Colt .45 model 1911',1.60),
('dods','riflegren_us','M1 Garand Rifle',1.30),
('dods','thompson','Thompson Submachine Gun',1.25),
('dods','spring','Springfield Rifle with Scope',1.50),
('dods','bar','BAR Browning Automatic Rifle',1.20),
('dods','frag_us','U.S. Grenade',1.00),
('dods','m1carbine','M1 Carbine',1.20),
('dods','30cal','.30 Caliber Machine Gun',1.25),
('dods','frag_ger','German Grenade',1.00),
('dods','spade','Spade Entrenchment Tool',3.00),
('dods','amerknife','U.S. Issue Knife',3.00),
('dods','bazooka','Bazooka',2.25),
('dods','pschreck','Panzerschreck',2.25),
('dods','riflegren_ger','German Rifle Grenade',1.30),
('dods','garand','M1 Garand Rifle',1.30),
('dods','p38','Pistol 38',1.50),
('dods','c96','Pistol c96',1.50),
('dods','punch','Butt Stock Hit',3.00),
('dods','mg42','MG42 Machine Gun',1.20),
('dods','smoke_ger','German Smoke Grenade',5.00),
('dods','smoke_us','U.S. Smoke Grenade',5.00),
('dods','dod_bomb_target','TNT Bomb',1.00),
('insmod','weapon_makarov','Soviet Makarov Combat Pistol',1.5),
('insmod','weapon_m9','9mm Beretta Pistol',1.5),
('insmod','world','RPG or Grenade',1.4),
('insmod','weapon_sks','Simonov SKS carbine',1.3),
('insmod','weapon_m1014','M1014 Service Combat Shotgun',1.2),
('insmod','weapon_toz','TOZ Rifle',1.1),
('insmod','weapon_svd','Dragunov Sniper Rifle',1.1),
('insmod','weapon_rpk','RPK Ruchnoy Pulemyot Kalashnikova',1.1),
('insmod','weapon_m249','M249 SAW (Squad Automatic Weapon)',1.1),
('insmod','weapon_m16m203','M16 carbine M203 Grenade Launcher',1.1),
('insmod','weapon_l42a1','Enfield L42A1 Military Sniper Rifle',1.1),
('insmod','weapon_m4med','M4 Medium Range Rifle',1),
('insmod','weapon_m4','M4 Carbine Rifle',1),
('insmod','weapon_m16a4','M16A4 Infantry Rifle',1),
('insmod','weapon_m14','Colt M14 Carbine',1),
('insmod','weapon_fnfal','FN FAL Automatic Rifle',1),
('insmod','weapon_aks74u','AKS-74U Awtomat Kalaschnikowa Ukorochennyj',1),
('insmod','weapon_ak47','AK-47 Awtomat Kalaschnikowa',1),
('ff', 'weapon_railgun', 'Railgun', 1.00),
('ff', 'weapon_tranq', 'Tranq Gun', 1.00),
('ff', 'weapon_medkit', 'Medkit', 1.00),
('ff', 'weapon_spanner', 'Spanner', 1.00),
('ff', 'weapon_crowbar', 'Crowbar', 1.00),
('ff', 'weapon_shotgun', 'Shotgun', 1.00),
('ff', 'grenade_napalm', 'Napalm Grenade', 1.00),
('ff', 'weapon_ic', 'IC', 1.00),
('ff', 'grenade_nail', 'Nail Grenade', 1.00),
('ff', 'weapon_supershotgun', 'Super Shotgun', 1.00),
('ff', 'weapon_supernailgun', 'Super Nailgun', 1.00),
('ff', 'weapon_sniperrifle', 'Sniper Rifle', 1.00),
('ff', 'weapon_rpg', 'Rocket Launcher', 1.00),
('ff', 'weapon_pipelauncher', 'Pipe Launcher', 1.00),
('ff', 'weapon_knife', 'Knife', 1.00),
('ff', 'weapon_grenadelauncher', 'Grenade Launcher', 1.00),
('ff', 'weapon_flamethrower', 'Flamethrower', 1.00),
('ff', 'Dispenser', 'Dispenser', 1.00),
('ff', 'weapon_autorifle', 'Auto Rifle', 1.00),
('ff', 'weapon_assaultcannon', 'Assault Cannon', 1.00),
('ff', 'SentryGun', 'Sentry Gun', 1.00),
('ff', 'grenade_normal', 'Frag Grenade', 1.00),
('ff', 'grenade_mirv', 'Mirv Grenade', 1.00),
('ff', 'grenade_emp', 'Emp Grenade', 1.00),
('ff', 'DETPACK', 'Detpack', 1.00),
('ff', 'weapon_umbrella','Umbrella', 10.00),
('ff', 'grenade_gas','Gas Grenade', 1.00),
('ff', 'weapon_tommygun', 'Tommygun', 1.00),
('ff', 'weapon_nailgun', 'Nailgun', 1.00),
('ff', 'backstab', 'Backstab', 1.00),
('hidden', 'fn2000','FN2000 Assault Rifle',1.50),
('hidden', 'p90','FN P90 Sub Machine Gun',2.00),
('hidden', 'shotgun','Remington 870 MCS Shotgun',2.00),
('hidden', 'fn303','FN303 Less Lethal Launcher',2.00),
('hidden', 'pistol','FN FiveSeven Pistol',3.00),
('hidden', 'pistol2','FNP-9 Pistol',3.00),
('hidden', 'knife','Kabar D2 Knife',2.50),
('hidden', 'grenade_projectile','Pipe Bomb',2.00),
('hidden', 'physics','Physics',3.00),
('zps', 'arms','Zombie',1),
('zps', 'carrierarms','Carrier',1),
('zps', 'ak47','AK-47',1),
('zps', 'mp5','MP5',1),
('zps', 'revolver','Revolver',1),
('zps', 'glock','Glock 17',1),
('zps', 'glock18c','Glock 18c',1),
('zps', 'ppk','Walther PPK',1),
('zps', 'usp','Heckler & Kock USP',1),
('zps', '870','Remington 870',1),
('zps', 'supershorty','Mossberg Super Shorty',1),
('zps', 'grenade_frag','Grenade',1),
('zps', 'sledgehammer','Sledgehammer',1.5),
('zps', 'crowbar','Crowbar',1.5),
('zps', 'chair','Chair',1.5),
('zps', 'keyboard','Keyboard',1.5),
('zps', 'plank','Wooden Plank',1.5),
('zps', 'shovel','Shovel',1.5),
('zps', 'golf','Golf Club',1.5),
('zps', 'machete','Machete',1.5),
('zps', 'fryingpan','Frying Pan',1.5),
('zps', 'spanner','Wrench',1.5),
('zps', 'axe','Axe',1.5),
('zps', 'tireiron','Tire Iron',1.5),
('zps', 'hammer','Hammer',1.5),
('zps', 'pot','Pot',1.5),
('zps', 'world','World',1.5),
('zps', 'physics','Physics',1.5),
('zps', 'torque','Torque',1.0),
('zps', 'winchester','Winchester Double Barreled Shotgun',1),
('zps', 'bat_aluminum', 'Bat (Aluminum)', 1.5 ),
('zps', 'bat_wood', 'Bat (Wood)', 1.5 ),
('zps', 'm4', 'M4', 1 ),
('zps', 'pipe', 'Pipe', 1 ),
('zps', 'slam', 'IED', 1 ),
('aoc', 'Flamberge','Flamberge',1),
('aoc', 'Longsword','Longsword',1),
('aoc', 'Glaive','Glaive',1),
('aoc', 'Dual Daggers','Dual Daggers',1),
('aoc', 'Flamberge & Kite Shield', 'Flamberge & Kite Shield', 1),
('aoc', 'world','World',1),
('aoc', 'chivalry','Chivalry',1),
('aoc', 'Shortsword','Shortsword',1),
('aoc', 'Warhammer','Warhammer',1),
('aoc', 'Mace','Mace',1),
('aoc', 'Mace & Buckler','Mace & Buckler',1),
('aoc', 'Broadsword & Evil Shield', 'Mason Broadsword & Shield', 1),
('aoc', 'Crossbow','Crossbow',1),
('aoc', 'Longbow','Longbow',1),
('aoc', 'Longsword & Kite Shield', 'Longsword & Kite Shield', 1),
('aoc', 'Broadsword & Good Shield', 'Knights Broadsword & Shield', 1),
('aoc', 'Hatchet', 'Hatchet', 1),
('aoc', 'Double Axe','Battle Axe',1),
('aoc', 'Flail & Evil Shield','Mason Flail & Shield',1),
('aoc', 'Flail & Good Shield','Knights Flail & Shield',1),
('aoc', 'Javelin', 'Javelin', 1),
('aoc', 'Spear & Buckler', 'Spear & Buckler', 1),
('aoc', 'Dagger', 'Dagger', 1),
('aoc', 'Broadsword', 'Broadsword', 1),
('aoc', 'Throwing Knife', 'Throwing Knife', 1),
('aoc', 'Spiked Mace', 'Spiked Mace', 1),
('aoc', 'Spiked Mace & Buckler','Spiked Mace & Buckler',1),
('aoc', 'Halberd', 'Halberd', 1),
('aoc', 'Oil Pot', 'Oil Pot', 1),
('aoc', 'Fists', 'Fists',2),
('aoc', 'Throwing Axe', 'Throwing Axe',1),
('cstrike','knife','Bundeswehr Advanced Combat Knife',1.80),
('cstrike','usp','H&K USP .45 Tactical',1.50),
('cstrike','glock18','Glock 18 Select Fire',1.50),
('cstrike','deagle','Desert Eagle .50AE',1.50),
('cstrike','p228','Sig Sauer P-228',1.50),
('cstrike','m3','Benelli M3 Super 90 Combat',1.40),
('cstrike','xm1014','Benelli/H&K M4 Super 90 XM1014',1.40),
('cstrike','mp5navy','H&K MP5-Navy',1.25),
('cstrike','tmp','Steyr Tactical Machine Pistol',1.25),
('cstrike','p90','FN P90',1.25),
('cstrike','m4a1','Colt M4A1 Carbine',1.00),
('cstrike','ak47','Kalashnikov AK-47',1.00),
('cstrike','sg552','Sig Sauer SG-552 Commando',1.00),
('cstrike','scout','Steyr Scout',1.60),
('cstrike','awp','Arctic Warfare Magnum (Police)',1.40),
('cstrike','g3sg1','H&K G3/SG1 Sniper Rifle',1.40),
('cstrike','m249','M249 PARA Light Machine Gun',0.80),
('cstrike','grenade','High Explosive Grenade',1.80),
('cstrike','elite','Dual Beretta 96G Elite',1.50),
('cstrike','aug','Steyr Aug',1.00),
('cstrike','mac10','Ingram MAC-10',1.25),
('cstrike','fiveseven','FN Five-Seven',1.50),
('cstrike','ump45','H&K UMP45',1.25),
('cstrike','sg550','Sig SG-550 Sniper',1.70),
('cstrike','famas','Fusil Automatique',1.00),
('cstrike','galil','Galil',1.00),
('tfc','sniperrifle','Sniper Rifle',1.00),
('tfc','normalgrenade','Normal Grenade',1.10),
('tfc','ac','Autocannon',1.00),
('tfc','rocket','Rocket Launcher',1.00),
('tfc','sentrygun','Sentry Gun',1.00),
('tfc','supershotgun','Super Shotgun',1.15),
('tfc','autorifle','Sniper Rifle (Auto Mode)',1.20),
('tfc','empgrenade','EMP Grenade',1.25),
('tfc','mirvgrenade','MIRV Grenade',1.25),
('tfc','gl_grenade','Grenade Launcher',1.35),
('tfc','pipebomb','Pipebomb',1.35),
('tfc','timer','Infection Timer',0.00),
('tfc','infection','Infection',1.50),
('tfc','flames','Flame Thrower',1.60),
('tfc','shotgun','Shotgun',1.60),
('tfc','nails','Nail Gun',1.70),
('tfc','nailgrenade','Nail Grenade',1.70),
('tfc','supernails','Super Nail Gun',1.65),
('tfc','axe','Crowbar',1.80),
('tfc','medikit','Medikit',1.85),
('tfc','napalmgrenade','Napalm Grenade',1.70),
('tfc','detpack','Detpack',1.80),
('tfc','gasgrenade','Gas Grenade',1.90),
('tfc','spanner','Spanner',2.00),
('tfc','caltrop','Caltrops',2.00),
('tfc','railgun','Rail Gun',1.85),
('tfc','building_dispenser','Dispenser',2.00),
('dod', 'k43', 'Karbiner 43', '1.50'),
('dod', 'luger', 'Luger 08 Pistol', '1.50'),
('dod', 'kar', 'Mauser Kar 98k', '1.30'),
('dod', 'mp40', 'MP40 Machine Pistol', '1.25'),
('dod', 'scopedkar', 'Mauser Karbiner 98k Sniper Rifle', '1.50'),
('dod', 'mp44', 'MP44 Assault Rifle', '1.35'),
('dod', 'colt', 'Colt .45 model 1911', '1.60'),
('dod', 'garand', 'M1 Garand Rifle', '1.30'),
('dod', 'thompson', 'Thompson Submachine Gun', '1.25'),
('dod', 'spring', 'Springfield Rifle with Scope', '1.50'),
('dod', 'bar', 'BAR Browning Automatic Rifle', '1.20'),
('dod', 'grenade', 'U.S. Grenade', '1.00'),
('dod', 'enf_bayonet', 'Enfield Bayonet', '2.50'),
('dod', 'bren', 'Bren Machine Gun', '1.25'),
('dod', 'm1carbine', 'M1 Carbine', '1.20'),
('dod', 'greasegun', 'Greasegun', '1.30'),
('dod', '30cal', '.30 Caliber Machine Gun', '1.25'),
('dod', 'mg42', 'MG42 Machine Gun', '1.20'),
('dod', 'grenade2', 'German Grenade', '1.00'),
('dod', 'spade', 'Spade Entrenchment Tool', '3.00'),
('dod', 'gerknife', 'German Knife', '3.00'),
('dod', 'fg42', 'FG42 Paratroop Rifle', '1.25'),
('dod', 'world', 'worldspawn', '0.00'),
('dod', 'amerknife', 'U.S. Issue Knife', '3.00'),
('dod', 'bayonet', 'Karbiner Bayonet', '2.40'),
('dod', 'mg34', 'MG34 Machine Gun', '1.20'),
('dod', 'brit_knife', 'British Knife', '3.00'),
('dod', 'mortar', 'Mortar', '1.00'),
('dod', 'fcarbine', 'F1 Carbine', '1.35'),
('dod', 'scoped_fg42', 'Scoped FG42', '1.30'),
('dod', 'bazooka', 'Bazooka', '2.25'),
('dod', 'enfield', 'Enfield Rifle', '1.35'),
('dod', 'garandbutt', 'Butt Stock Hit', '3.00'),
('dod', 'mills_bomb', 'British Grenade', '1.00'),
('dod', 'piat', 'Piat', '2.25'),
('dod', 'pschreck', 'Panzerschreck', '2.25'),
('dod', 'scoped_enfield', 'Scoped Enfield', '1.50'),
('dod', 'sten', 'Sten Submachine Gun', '1.25'),
('dod', 'webley', 'Webley Revolver', '1.60'),
('ns','welder','Marine Welder','3.00'),
('ns','item_mine','Marine Mine','1.00'),
('ns','handgrenade','Marine Hand Grenade','1.00'),
('ns','grenade','Marine Grenade Launcher','1.00'),
('ns','knife','Marine Knife','4.00'),
('ns','pistol','Marine Pistol','2.00'),
('ns','machinegun','Marine Light Machine Gun','1.25'),
('ns','shotgun','Marine Shotgun','1.00'),
('ns','heavymachinegun','Marine Heavy Machine Gun','1.00'),
('ns','turret','Marine Turret','.75'),
('ns','siegeturret','Marine Siege Turret','1.00'),
('ns','resourcetower','Electrified Marine Resource Tower','2.00'),
('ns','team_turretfactor','Electric Marine Turret Factory','2.00'),
('ns','team_advturretfactor','Electrified Marine Advance Turret Factory','2.00'),
('ns','acidrocket','Fade Acid Rocket','1.00'),
('ns','bitegun','Skulk Bite','1.25'),
('ns','charge','Onos Charge','1.00'),
('ns','claws','Onos Gore','1.00'),
('ns','divinewind','Skulk Xenocide','1.00'),
('ns','leap','Skulk Leap','2.00'),
('ns','bite2gun','Lerk Bite','2.00'),
('ns','spitgunspit','Gorge Spit','2.00'),
('ns','sporegunprojectile','Lerk Spores','1.00'),
('ns','swipe','Fade Slash','1.00'),
('ns','healingspray','Gorge Health Spray','3.00'),
('ns','parasite','Skulk Parasite','3.00'),
('ns','devour','Onos Devour','2.00'),
('ns','offensechamber','Offense Chamber','1.00'),
('l4d', 'rifle', 'M16 Assault Rifle', 1.00),
('l4d', 'autoshotgun', 'Auto Shotgun', 1.00),
('l4d', 'pumpshotgun', 'Pump Shotgun', 1.30),
('l4d', 'smg', 'Uzi', 1.20),
('l4d', 'dual_pistols', 'Dual Pistols', 1.60),
('l4d', 'pipe_bomb', 'Pipe Bomb', 1.00),
('l4d', 'hunting_rifle', 'Hunting Rifle', 1.00),
('l4d', 'pistol', 'Pistol', 2.00),
('l4d', 'prop_minigun', 'Mounted Machine Gun', 1.20),
('l4d', 'tank_claw', 'Tank''s Claws', 3.00),
('l4d', 'hunter_claw', 'Hunter''s Claws', 3.00),
('l4d', 'smoker_claw', 'Smoker''s Claws', 3.00),
('l4d', 'boomer_claw', 'Boomer''s Claws', 3.00),
('l4d', 'inferno', 'Molotov/Gas Can Fire', 1.20),
('l4d', 'infected', 'Infected Horde', 1.00),
('l4d', 'witch', 'Witch''s Claws', 1.00),
('l4d', 'entityflame', 'Blaze', 3),
('l4d', 'first_aid_kit', 'First Aid Kit Smash', 1.5),
('l4d', 'gascan', 'Gas Can Smash', 1.5),
('l4d', 'molotov', 'Molotov Smash', 1.5),
('l4d', 'pain_pills', 'Pain Pills Smash', 1.5),
('l4d', 'player', 'Player', 1),
('l4d', 'propanetank', 'Propane Tank Smash', 1.5),
('l4d', 'tank_rock', 'Tank''s Rock', 1.5),
('l4d', 'oxygentank', 'Oxygen Tank Smash', 1.5),
('l4d', 'world', 'World', 1),
('l4d', 'prop_physics', 'Prop Physics', 1),
('fof', 'deringer', 'Deringer', 1),
('fof', 'carbine', 'Carbine', 1),
('fof', 'coltnavy', 'Colt Navy', 1),
('fof', 'bow', 'Bow', 1),
('fof', 'arrow', 'Arrow', 1),
('fof', 'sharps', 'Sharps', 1),
('fof', 'coachgun', 'Coach Gun', 1),
('fof', 'peacemaker', 'Peacemaker', 1),
('fof', 'knife', 'Knife', 2),
('fof', 'physics', 'Exploding Barrel', 1),
('fof', 'thrown_axe', 'Thrown Axe', 3),
('fof', 'arrow_fiery', 'Fire Arrow', 2),
('fof', 'thrown_knife', 'Thrown Knife', 3),
('fof', 'dualnavy', 'Dual Colt Navys', 1),
('fof', 'dynamite', 'Dynamite', 3),
('fof', 'explosive_arrow', 'Explosive Arrow', 2),
('fof', 'fists', 'Fists', 2),
('fof', 'axe', 'Axe', 2),
('fof', 'dualpeacemaker', 'Dual Peacemakers', 1),
('fof', 'henryrifle', 'Henry Rifle', 1),
('fof', 'shotgun', 'Winchester Shotgun', 1),
('ges', '#GE_ProximityMine', 'Proximity Mines', 1),
('ges', '#GE_AutoShotgun', 'Automatic Shotgun', 1),
('ges', '#GE_Phantom', 'Phantom', 1),
('ges', '#GE_Knife', 'Hunting Knife', 1),
('ges', '#GE_D5K', 'D5K Deutsche', 1),
('ges', '#GE_SilverPP7', 'Silver PP7', 1),
('ges', '#GE_DD44', 'DD44', 1),
('ges', '#GE_Grenade', 'Grenade', 1),
('ges', '#GE_CougarMagnum', 'Cougar Magnum', 1),
('ges', '#GE_D5K_SILENCED', 'D5K (Silenced)', 1),
('ges', '#GE_Shotgun', 'Shotgun', 1),
('ges', '#GE_Klobb', 'Klobb', 1),
('ges', '#GE_RCP90', 'RC-P90', 1),
('ges', '#GE_RemoteMine', 'Remote Mines', 1),
('ges', '#GE_KF7Soviet', 'KF7 Soviet', 1),
('ges', '#GE_ZMG', 'ZMG', 1),
('ges', '#GE_SniperRifle', 'Sniper Rifle', 1),
('ges', '#GE_GoldPP7', 'Golden PP7', 1),
('ges', '#GE_AR33', 'US AR33 Assault', 1),
('ges', '#GE_GoldenGun', 'Golden Gun', 1),
('ges', '#GE_ThrowingKnife', 'Throwing Knives', 1),
('ges', '#GE_PP7', 'PP7', 1),
('ges', '#GE_PP7_SILENCED', 'PP7 (Silenced)', 1),
('ges', '#GE_TimedMine', 'Timed Mines', 1),
('ges', '#GE_MilitaryLaser', 'Military Laser', 1),
('ges', '#GE_GrenadeLauncher', 'Grenade Launcher', 1),
('ges', '#GE_Rocket', 'Rocket Launcher', 1),
('ges', '#GE_Taser', 'Taser', 1),
('ges', '#GE_SniperButt', 'Sniper Butt', 1),
('ges', '#GE_Slapper', 'Slappers', 1),
('ges', '#GE_RocketLauncher', 'Rocket Launcher', 1),
('bg2', 'brownbess', 'Brown Bess', 1),
('bg2', 'brownbess_bayonet', 'Brown Bess - Bayonet', 1),
('bg2', 'charleville', 'Charleville', 1),
('bg2', 'charleville_bayonet', 'Charleville - Bayonet', 1),
('bg2', 'hirschf', 'Hirschfaenger', 1),
('bg2', 'jaeger', 'Jaeger Rifle', 1),
('bg2', 'knife', 'Knife', 2),
('bg2', 'pennsylvania', 'Pennsylvania', 1),
('bg2', 'pistol_a', 'British Pistol', 1.5),
('bg2', 'pistol_b', 'American Pistol', 1.5),
('bg2', 'sabre_a', 'British Sabre', 1),
('bg2', 'sabre_b', 'American Sabre', 1),
('sgtls', 'p90', 'FN Herstal P-90 Red Dot / FN-H P-90RD', 1),
('sgtls', 'pistol', 'Beretta M92F-s', 1),
('sgtls', 'knife', 'Combat Knife', 1),
('sgtls', 'staff_blast', 'Staff Weapon', 1),
('sgtls', 'p90D', 'FN Herstal P-90 w/ Disruptor', 1),
('sgtls', 'hdevice', 'Hand Device / Ribbon Device', 1),
('sgtls', 'tac_pulse', 'Tac (turrent)', 1),
('sgtls', 'tac_projectile', 'Tac (bomb)', 1),
('sgtls', 'c4_charge', 'C4', 1),
('sgtls', 'grenade_projectile', 'M67 Frag Grenade', 1),
('sgtls', 'g36', 'H&K G-36', 1),
('sgtls', 'kull_blast', 'Kull Warrior Staff Device', 1),
('sgtls', 'suicide_bomb', 'Goa''uld Suicide Bomb', 1),
('sgtls', 'kullblaster', 'Kull Warrior Staff Device (blast)', 1),
('sgtls', 'staff', 'Staff Weapon Melee', 1),
('sgtls', 'zat_blast', 'Zat', 1),
('sgtls', 'awp', 'AWP Rifle', 1),
('sgtls', 'grenade', 'M67 Frag Grenade', 1),
('sgtls', 'zat', 'Zat (splash)', 1),
('sgtls', 'tac', 'Tac (splash)', 1),
('dystopia', 'Light Katana', 'Light Katana', 1),
('dystopia', 'Medium Katana', 'Medium Katana', 1),
('dystopia', 'Fatman Fist', 'Fatman Fist', 1),
('dystopia', 'Machine Pistol', 'Machine Pistol', 1),
('dystopia', 'Shotgun', 'Shotgun', 1),
('dystopia', 'Laser Rifle', 'Laser Rifle', 1),
('dystopia', 'BoltGun', 'Bolt Gun', 1),
('dystopia', 'SmartLock Pistols', 'Smartlock Pistols', 1),
('dystopia', 'Assault Rifle', 'Assault Rifle', 1),
('dystopia', 'Grenade Launcher', 'Grenade Launcher', 1),
('dystopia', 'MK-808 Rifle', 'MK-808 Rifle', 1),
('dystopia', 'Tesla Rifle', 'Tesla Rifle', 1),
('dystopia', 'Rocket Launcher', 'Rocket Launcher', 1),
('dystopia', 'Minigun', 'Minigun', 1),
('dystopia', 'Ion Cannon', 'Ion Cannon', 1),
('dystopia', 'Basilisk', 'Basilisk', 1),
('dystopia', 'Frag Grenade', 'Frag Grenade', 1),
('dystopia', 'EMP Grenade', 'EMP Grenade', 1),
('dystopia', 'Spider Grenade', 'Spider Grenade', 1),
('dystopia', 'Cortex Bomb', 'Cortex Bomb', 1),
('dystopia', 'Leg Boosters', 'Leg Boosters', 1),
('dystopia', 'Trap', 'Trap', 1),
('dystopia', 'Turret', 'Turret', 1),
('nts', 'aa13', 'AA13', 1.00),
('nts', 'grenade_projectile', 'Frag Grenade', 1.00),
('nts', 'jitte', 'Jitte', 1.00),
('nts', 'jittescoped', 'Jitte (Scoped)', 1.00),
('nts', 'knife', 'Knife', 1.50),
('nts', 'kyla', 'KYLA', 1.00),
('nts', 'm41', 'M41', 1.00),
('nts', 'm41s', 'M41S', 1.00),
('nts', 'milso', 'MilSO', 1.00),
('nts', 'mpn', 'MPN45', 1.00),
('nts', 'mx', 'MX', 1.00),
('nts', 'mx_silenced', 'MX Silenced', 1.00),
('nts', 'pz', 'PZ252', 1.00),
('nts', 'grenade_detapack', 'Detpack', 1.00),
('nts', 'srm', 'SRM', 1.00),
('nts', 'srm_s', 'SRM-S', 1.00),
('nts', 'srs', 'SRS', 1.00),
('nts', 'supa7', 'MURATA SUPA 7', 1.00),
('nts', 'tachi', 'TACHI', 1.00),
('nts', 'zr68c', 'ZR68C', 1.00),
('nts', 'zr68l', 'ZR68L', 1.00),
('nts', 'zr68s', 'ZR68S', 1.00),
('l4d2', 'rifle', 'M16 Assault Rifle', 1.00),
('l4d2', 'autoshotgun', 'Auto Shotgun', 1.00),
('l4d2', 'pumpshotgun', 'Pump Shotgun', 1.30),
('l4d2', 'smg', 'Uzi', 1.20),
('l4d2', 'dual_pistols', 'Dual Pistols', 1.60),
('l4d2', 'pipe_bomb', 'Pipe Bomb', 1.00),
('l4d2', 'hunting_rifle', 'Hunting Rifle', 1.00),
('l4d2', 'pistol', 'Pistol', 2.00),
('l4d2', 'prop_minigun', 'Mounted Machine Gun', 1.20),
('l4d2', 'tank_claw', 'Tank''s Claws', 2.00),
('l4d2', 'hunter_claw', 'Hunter''s Claws', 3.00),
('l4d2', 'smoker_claw', 'Smoker''s Claws', 3.00),
('l4d2', 'boomer_claw', 'Boomer''s Claws', 3.00),
('l4d2', 'jockey_claw', 'Jockey''s Claws', 3.00),
('l4d2', 'spitter_claw', 'Spitter''s Claws', 3.00),
('l4d2', 'charger_claw', 'Charger''s Claws', 3.00),
('l4d2', 'inferno', 'Molotov/Gas Can Fire', 1.20),
('l4d2', 'infected', 'Infected Horde', 1.00),
('l4d2', 'witch', 'Witch''s Claws', 1.00),
('l4d2', 'entityflame', 'Blaze', 3),
('l4d2', 'first_aid_kit', 'First Aid Kit Smash', 1.5),
('l4d2', 'gascan', 'Gas Can Smash', 1.5),
('l4d2', 'molotov', 'Molotov Smash', 1.5),
('l4d2', 'pain_pills', 'Pain Pills Smash', 1.5),
('l4d2', 'player', 'Player', 1),
('l4d2', 'propanetank', 'Propane Tank Smash', 1.5),
('l4d2', 'tank_rock', 'Tank''s Rock', 1.5),
('l4d2', 'oxygentank', 'Oxygen Tank Smash', 1.5),
('l4d2', 'prop_physics', 'Prop Physics', 1),
('l4d2', 'defibrillator', 'Defibrillator', 1.5),
('l4d2', 'chainsaw', 'Chainsaw', 1),
('l4d2', 'grenade_launcher', 'Grenade Launcher Smash', 1.5),
('l4d2', 'fire_cracker_blast', 'Fire Cracker', 1),
('l4d2', 'grenade_launcher_projectile', 'Grenade Launcher', 0.75),
('l4d2', 'pistol_magnum', 'Magnum', 1),
('l4d2', 'rifle_ak47', 'AK-47', 1),
('l4d2', 'rifle_desert', 'Combat Rifle', 1),
('l4d2', 'shotgun_chrome', 'Chrome Shotgun', 1),
('l4d2', 'shotgun_spas', 'Combat Shotgun', 1),
('l4d2', 'smg_silenced', 'Uzi (silenced)', 1),
('l4d2', 'sniper_military', 'Sniper Rifle', 1),
('l4d2', 'vomitjar', 'Vomit Jar Smash', 1.5),
('l4d2', 'baseball_bat', 'Baseball Bat', 1.5),
('l4d2', 'cricket_bat', 'Cricket Bat', 1.5),
('l4d2', 'crowbar', 'Crowbar', 1.5),
('l4d2', 'electric_guitar', 'Electric Guitar', 1.5),
('l4d2', 'fireaxe', 'Fireaxe', 1.5),
('l4d2', 'upgradepack_incendiary', 'Incendiary Pack Smash', 1.5),
('l4d2', 'frying_pan', 'Frying Pan', 1.5),
('l4d2', 'katana', 'Katana', 1.5),
('l4d2', 'knife', 'Knife', 1.5),
('l4d2', 'machete', 'Machete', 1.5),
('l4d2', 'tonfa', 'Tonfa', 1.5),
('l4d2', 'insect_swarm', 'Insect Swarm', 1.5),
('l4d2', 'melee', 'Melee', 1.5),
('l4d2', 'adrenaline', 'Adrenaline Smash', 1.5),
('l4d2', 'cola_bottles', 'Cola Bottles Smash', 1.5),
('l4d2', 'env_explosion', 'Explosion', 1.5),
('l4d2', 'env_fire', 'Fire', 1.5),
('l4d2', 'fireworkcrate', 'Fireworks Crate Smash', 1.5),
('l4d2', 'gnome', 'Gnome Smash', 1.5),
('l4d2', 'rifle_sg552', 'Sig Sauer SG-552 Commando', 1),
('l4d2', 'smg_mp5', 'H&K MP5-Navy', 1),
('l4d2', 'sniper_awp', 'Arctic Warfare Magnum (Police)', 1),
('l4d2', 'sniper_scout', 'Steyr Scout', 1),
('l4d2', 'upgradepack_explosive', 'Explosive Pack', 1.5),
('l4d2', 'world', 'World', 1),
('l4d2', 'golfclub', 'Golf Club', 1.50),
('l4d2', 'rifle_m60', 'M60', 1.00),
('pvkii', 'zerking', 'Zerking', 1.00),
('pvkii', 'slidingdoor', 'Sliding Door', 1.00),
('pvkii', 'seaxshield', 'Langseax & Shield', 1.00),
('pvkii', 'longbow', 'Long Bow', 1.00),
('pvkii', 'chest', 'Chest', 1.00),
('pvkii', 'parrot', 'Parrot', 1.00),
('pvkii', 'rocks', 'Rocks', 1.00),
('pvkii', 'bigaxe', 'Berserker Axe', 1.00),
('pvkii', 'gatecrush', 'Gate Crush', 1.00),
('pvkii', 'cutlass', 'Cutlass', 1.00),
('pvkii', 'twoaxe', 'Huscarl Axe', 1.00),
('pvkii', 'spear', 'Spear', 1.00),
('pvkii', 'freeze', 'Freeze', 1.00),
('pvkii', 'plfall', 'Falling', 1.00),
('pvkii', 'steam', 'Steam', 1.00),
('pvkii', 'vulture', 'Vultures', 1.00),
('pvkii', 'shuriken', 'shuriken', 1.00),
('pvkii', 'huscshieldbash', 'Huscarl Shield Bash', 1.00),
('pvkii', 'spike', 'Spike', 1.00),
('pvkii', 'blunderbuss', 'Blunderbuss', 1.00),
('pvkii', 'punch_cpt', 'Punch', 1.00),
('pvkii', 'crossbow', 'Crossbow', 1.00),
('pvkii', 'env_explosion', 'Explosion', 1.00),
('pvkii', 'flintlock', 'Flintlock Pistols', 1.00),
('pvkii', 'throwaxe', 'Throwing Axes', 1.00),
('pvkii', 'powderkeg', 'Powderkeg', 1.00),
('pvkii', 'physics', 'Physics', 1.00),
('pvkii', 'boulder', 'Boulder', 1.00),
('pvkii', 'drowned', 'Drowned', 1.00),
('pvkii', 'barrel', 'Barrel', 1.00),
('pvkii', 'axesword', 'Sword & Axe', 1.00),
('pvkii', 'cutlass2', 'Captain''s Cutlass', 1.00),
('pvkii', 'flames', 'Flames', 1.00),
('pvkii', 'vikingshield', 'Huscarl Sword & Shield', 1.00),
('pvkii', 'thrownkeg', 'Thrown Powderkeg', 1.00),
('pvkii', 'archersword', 'Short Sword', 1.00),
('pvkii', 'player', 'Player', 1.00),
('pvkii', 'worldspawn', 'World', 1.00),
('pvkii', 'twosword', '2 Handed Sword', 1.00),
('pvkii', 'hook', 'Hook', 1.00),
('pvkii', 'hkshieldbash', 'Heavy Knight Bash', 1.00),
('pvkii', 'javelin', 'Javelins', 1.00),
('pvkii', 'swordshield', 'Heavy Knight Sword/Shield', 1.00),
('pvkii', 'crusher', 'Crusher', 1.00),
('valve', '357', '357 Revolver', '1.60'),
('valve', '9mmAR', '9mm Automatic Rifle', 1.00),
('valve', '9mmhandgun', '9mm Handgun', 1.50),
('valve', 'bolt', 'Crossbow Bolt', 1.70),
('valve', 'crossbow', 'Crossbow', 1.40),
('valve', 'crowbar', 'Crowbar', 1.90),
('valve', 'tau_cannon', 'Egon Tau Cannon / Rail Gun', 1.00),
('valve', 'gluon gun', 'Gluon / Gauss Gun', 1.00),
('valve', 'grenade', 'Grenade', 1.00),
('valve', 'hornet', 'Hornet', 1.30),
('valve', 'rpg_rocket', 'Rocket Propelled Grenade', 1.00),
('valve', 'satchel', 'Satchel Charge', 1.50),
('valve', 'shotgun', 'Shotgun', 1.20),
('valve', 'snark', 'Snark', 1.80),
('valve', 'tripmine', 'Trip Mine', 1.60),
('nd', 'armblade', 'BLADES', 1.00),
('nd', 'armknives', 'KNIVES', 1.00),
('nd', 'artillery', 'Artillery', 0.70),
('nd', 'avenger', 'C1 AVENGER', 1.00),
('nd', 'bag90', 'BAG-90', 2.00),
('nd', 'chaingun', 'GAU-20P', 1.00),
('nd', 'commander damage', 'Commander Damage Ability', 0.60),
('nd', 'commander poison', 'Commander Poison Ability', 1.00),
('nd', 'daisy cutter', 'DAISYCUTTER', 2.00),
('nd', 'f2000', 'FN-H F2100 TR', 1.00),
('nd', 'env_explosion', 'Environment Explosion', 1.50),
('nd', 'flamethrower turret', 'Flamethrower Turret', 0.40),
('nd', 'frag grenade', 'M-87 FRAG', 1.50),
('nd', 'grenade launcher', 'M52 HYDRA', 1.50),
('nd', 'm95', 'M-95 L.A.W.S.', 1.00),
('nd', 'mg turret', 'Machine-gun Turret', 0.40),
('nd', 'mp500', 'MP-500', 1.20),
('nd', 'mp7', 'MP-7', 1.20),
('nd', 'nx300', 'NX-300', 1.50),
('nd', 'p12 grenade', 'P12 POISON', 2.00),
('nd', 'p900', 'P-900', 2.00),
('nd', 'paladin', 'PALADIN PLR-5', 1.00),
('nd', 'pp22', 'PP-22', 1.20),
('nd', 'psg', 'PSG-L', 1.00),
('nd', 'R.E.D.', 'R.E.D', 1.50),
('nd', 'repair tool', 'BLOWTORCH', 5.00),
('nd', 'rocket turret', 'Rocket Turret', 0.40),
('nd', 'shotgun', 'SPETZ-9', 1.40),
('nd', 'sonic turret', 'Sonic Turret', 0.40),
('nd', 'sp5', 'SP-5 K1', 1.30),
('nd', 'u23 grenade', 'U23 POISON', 2.00),
('nd', 'world', 'World', 1.00),
('nd', 'x01', 'X-01', 1.00),
('csgo', 'ak47', 'Kalashnikov AK-47', 1.00),
('csgo', 'm4a1', 'M4A4', 1.00),
('csgo', 'awp', 'AWP', 1.00),
('csgo', 'deagle', 'Desert Eagle', 1.20),
('csgo', 'hkp2000', 'P2000', 1.40),
('csgo', 'galilar', 'Galil', 1.10),
('csgo', 'glock', 'Glock-18', 1.40),
('csgo', 'bizon', 'PP-Bizon', 1.30),
('csgo', 'galil', 'Galil', 1.10),
('csgo', 'p90', 'FN P90', 1.20),
('csgo', 'aug', 'Steyr Aug', 1.00),
('csgo', 'mp7', 'MP7', 1.30),
('csgo', 'elite', 'Dual Berretta Elites', 1.40),
('csgo', 'ssg08', 'SSG 08', 1.10),
('csgo', 'sg553', 'SG 553', 1.00),
('csgo', 'nova', 'Nova', 1.30),
('csgo', 'p250', 'P250', 1.50),
('csgo', 'knife', 'Knife', 2.00),
('csgo', 'ump45', 'H&K UMP45', 1.20),
('csgo', 'sawedoff', 'Sawed-Off', 1.30),
('csgo', 'mag7', 'MAG-7', 1.30),
('csgo', 'hegrenade', 'High Explosive Grenade', 1.80),
('csgo', 'mp9', 'MP9', 1.40),
('csgo', 'tec9', 'Tec-9', 1.20),
('csgo', 'scar20', 'Scar-20', 0.80),
('csgo', 'xm1014', 'XM1014', 1.10),
('csgo', 'fiveseven', 'FN Five-Seven', 1.50),
('csgo', 'negev', 'Negev', 1.00),
('csgo', 'mac10', 'MAC-10', 1.50),
('csgo', 'g3sg1', 'H&K G3/SG1 Sniper Rifle', 0.80),
('csgo', 'm249', 'M249 PARA Light Machine Gun', 1.00),
('csgo', 'inferno', 'Incendiary Grenade', 1.80),
('csgo', 'taser', 'Zeus x27', 1.00),
('dinodday', 'fists', 'Berserk Punch', 1.30),
('dinodday', 'flechette', 'Flechette Gun', 1.40),
('dinodday', 'jackrabbit', 'Jackrabbit', 1.40),
('dinodday', 'flak30', 'Desmatosuchus Flak 30', 1.30),
('dinodday', 'k98sniper', 'Karabiner 98 Sniper', 1.50),
('dinodday', 'mg42', 'Maschinengewehr 42', 1.20),
('dinodday', 'pterosaur', 'Pterosaur Strike', 1.30),
('dinodday', 'claws', 'Claw Attack', 1.70),
('dinodday', 'k98', 'Karabiner 98', 1.70),
('dinodday', 'mosin', 'Mosin Nagant', 1.50),
('dinodday', 'artillery', 'Artillery Strike', 1.20),
('dinodday', 'piat', 'PIAT Mk I', 1.20),
('dinodday', 'stickgrenade', 'Stielhandgranate 43', 1.40),
('dinodday', 'luger', 'P08 Luger', 1.60),
('dinodday', 'bar', 'Browning Automatic Rifle M1918', 1.20),
('dinodday', 'garand', 'M1 Garand', 1.30),
('dinodday', 'trenchknife', 'Kampfmesser', 1.70),
('dinodday', 'kabar', 'KA-BAR Combat Knife', 1.70),
('dinodday', 'pistol', 'Colt M1911', 1.60),
('dinodday', 'grenade', 'Hand Grenade MKII', 1.40),
('dinodday', 'shotgun', 'Trench Gun M1897', 1.40),
('dinodday', 'thompson', 'M1 Thompson', 1.20),
('dinodday', 'mp40', 'Maschinenpistole 40', 1.20),
('dinodday', 'sticky', 'Sticky Bomb', 1.40),
('dinodday', 'mp44', 'Sturmgewehr 44', 1.20),
('dinodday', 'dilophosaurus', 'Dilophosaurus Claws', 1.70),
('dinodday', 'satchel', 'Satchel Charge', 1.30),
('dinodday', 'sten', 'Sten Mk II', 1.20),
('dinodday', 'p38', 'Pistole 38', 1.60),
('dinodday', 'nagant', 'Nagant M1894', 1.60),
('dinodday', 'fistsregular', 'Fists', 1.70),
('dinodday', 'styracosaur', 'Styracosaur', 1.30),
('dinodday', 'trex', 'T-Rex Dual-MG42', 1.20),
('dinodday', 'trexbomb', 'T-Rex Bomb Throw', 1.50),
('dinodday', 'tankmine', 'Tankmine', 1.30),
('dinodday', 'trigger', 'Trigger .30cal', 1.20),
('dinodday', 'stygimoloch', 'Stygimoloch MG34', 1.20),
('dinodday', 'compy', 'Compsognathus', 1.70),
('dinodday', 'flamethrower', 'Flamethrower', 1.40),
('dinodday', 'microraptor', 'Microraptor Claws', 1.70),
('dinodday', 'carbine', 'M1 Carbine', 1.25),
('dinodday', 'greasegun', 'M3 Grease Gun', 1.20),
('dinodday', 'pounce', 'Velociraptor Pounce', 1.70),
('dinodday', 'desmamelee', 'Desmatosuchus Melee', 1.70),
('dinodday', 'body', 'Dilophosaurus Body Throw', 1.30),
('dinodday', 'stygihead', 'Stygimoloch Headbutt', 1.70),
('dinodday', 'suicide', 'Compsognathus Suicidebomb', 1.70),
('dinodday', 'spit', 'Microraptor Acidspit', 1.70),
('dinodday', 'triggerhead', 'Trigger Headbutt', 1.70),
('dinodday', 'dinner', 'T-Rex Dinner', 1.70),
('dinodday', 'stomp', 'T-Rex Stomp', 1.70),
('dinodday', 'goat', 'Dilophosaurus Goat Throw', 1.90);