CREATE TABLE IF NOT EXISTS `geoLiteCity_Blocks` (
  `startIpNum` bigint(11) unsigned NOT NULL default '0',
  `endIpNum` bigint(11) unsigned NOT NULL default '0',
  `locId` bigint(11) unsigned NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `geoLiteCity_Location` (
  `locId` bigint(11) unsigned NOT NULL default '0',
  `country` varchar(2) NOT NULL,
  `region` varchar(50) default NULL,
  `city` varchar(50) default NULL,
  `postalCode` varchar(10) default NULL,
  `latitude` decimal(14,4) default NULL,
  `longitude` decimal(14,4) default NULL,
  PRIMARY KEY  (`locId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


ALTER TABLE `hlstats_Actions`
CHANGE `game` `game` varchar(32) NOT NULL default 'valve',
CHANGE `team` `team` varchar(64) NOT NULL default '',
ADD COLUMN `count` int(10) unsigned NOT NULL default '0',
DROP KEY `gamecode`,
ADD UNIQUE KEY `gamecode` (`code`,`game`,`team`);

INSERT IGNORE INTO `hlstats_Actions` (`game`, `code`, `reward_player`, `reward_team`, `team`, `description`, `for_PlayerActions`, `for_PlayerPlayerActions`, `for_TeamActions`, `for_WorldActions`) VALUES
('tf', 'flagevent_defended', 1, 0, '', 'Defended the flag', '1', '', '', ''),
('tf', 'flagevent_captured', 5, 1, '', 'Captured the flag', '1', '', '', ''),
('tf', 'flagevent_dropped', -2, 0, '', 'Dropped the flag (while alive)', '1', '', '', ''),
('tf', 'flagevent_dropped_death', 0, 0, '', 'Dropped the flag (on death)', '1', '', '', ''),
('tf', 'flagevent_picked_up', 2, 0, '', 'Picked up the flag', '1', '', '', ''),
('tf', 'killedobject_obj_teleporter_exit', 2, 0, '', 'Destroyed a teleporter exit', '1', '', '', ''),
('tf', 'killedobject_obj_teleporter_entrance', 2, 0, '', 'Destroyed a teleporter entrance', '1', '', '', ''),
('tf', 'killedobject_obj_dispenser', 3, 0, '', 'Destroyed a dispenser', '1', '', '', ''),
('tf', 'killedobject_obj_sentrygun', 4, 0, '', 'Destroyed a sentry gun', '1', '', '', ''),
('tf', 'builtobject_obj_teleporter_exit', 2, 0, '', 'Built a teleporter exit', '1', '', '', ''),
('tf', 'builtobject_obj_teleporter_entrance', 2, 0, '', 'Built a teleporter entrance', '1', '', '', ''),
('tf', 'builtobject_obj_dispenser', 3, 0, '', 'Built a dispenser', '1', '', '', ''),
('tf', 'builtobject_obj_sentrygun', 3, 0, '', 'Built a sentry gun', '1', '', '', ''),
('tf', 'captureblocked', 1, 0, '', 'Capture Blocked', '1', '', '', ''),
('tf', 'pointcaptured', 5, 5, '', 'Point Captured', '1', '', '1', ''),
('tf', 'kill assist', 2, 0, '', 'Kill Assist', '1', '', '', ''),
('tf', 'builtobject_obj_attachment_sapper', 2, 0, '', 'Attached a Sapper', '1', '', '', ''),
('tf', 'killedobject_obj_attachment_sapper', 1, 0, '', 'Removed a Sapper', '1', '', '', ''),
('tf', 'chargedeployed', 1, 0, '', 'Ubercharge', '1', '', '', ''),
('tf', 'domination', 5, 0, '', 'Domination', '', '1', '', ''),
('tf', 'revenge', 3, 0, '', 'Revenge', '', '1', '', ''),
('tf', 'Round_Win', 0, 10, '', 'Round Win', '', '', '1', ''),
('tf', 'Mini_Round_Win', 0, 5, '', 'Mini-Round Win', '', '', '1', ''),
('tf', 'owner_killedobject_obj_sentrygun', -3, 0, '', 'Disassembled a sentry gun', '1', '', '', ''),
('tf', 'owner_killedobject_obj_dispenser', -3, 0, '', 'Disassembled a dispenser', '1', '', '', ''),
('tf', 'owner_killedobject_obj_teleporter_entrance', -2, 0, '', 'Disassembled a teleporter entrance', '1', '', '', ''),
('tf', 'owner_killedobject_obj_teleporter_exit', -2, 0, '', 'Disassembled a teleporter exit', '1', '', '', ''),
('tf', 'owner_killedobject_obj_attachment_sapper', -2, 0, '', 'Console-killed sapper', '1', '', '', ''),
('tf', 'backstab', 2, 0, '', 'Backstab Kill', '1', '', '', ''),
('tf', 'headshot', 2, 0, '', 'Headshot Kill', '1', '', '', ''),
('tf', 'kill_assist_medic', 3, 0, '', 'Kill Assist - Medic', '1', '0', '0', '0'),
('tf', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('tf', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('tf', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('tf', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('tf', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('tf', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('tf', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('tf', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('tf', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('tf', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('tf', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('tf', 'sandvich', 0, 0, '', 'Ate a Sandvich', '1', '', '', ''),
('tf', 'crit_kill', -1, 0, '', 'Critical Kill', '1', '', '', ''),
('tf', 'force_suicide', 0, 0, '', 'Force Suicide', '1', '', '', ''),
('tf', 'hit_by_train', 0, 0, '', 'LOL TRAIN\'D', '1', '', '', ''),
('tf', 'drowned', 0, 0, '', 'Drowned', '1', '', '', ''),
('css','Begin_Bomb_Defuse_Without_Kit',0,0,'CT','Start Defusing the Bomb Without a Defuse Kit','1','','',''),
('css','Begin_Bomb_Defuse_With_Kit',0,0,'CT','Start Defusing the Bomb With a Defuse Kit','1','','',''),
('css','Planted_The_Bomb',10,2,'TERRORIST','Plant the Bomb','1','','',''),
('css','Defused_The_Bomb',10,0,'CT','Defuse the Bomb','1','','',''),
('css','Touched_A_Hostage',0,0,'CT','Touch a Hostage','1','','',''),
('css','Rescued_A_Hostage',5,1,'CT','Rescue a Hostage','1','','',''),
('css','Killed_A_Hostage',-15,1,'CT','Kill a Hostage','1','','',''),
('css','Spawned_With_The_Bomb',2,0,'TERRORIST','Spawn with the Bomb','1','','',''),
('css','Got_The_Bomb',2,0,'TERRORIST','Pick up the Bomb','1','','',''),
('css','Dropped_The_Bomb',-2,0,'TERRORIST','Drop the Bomb','1','','',''),
('css','CTs_Win',0,2,'CT','All Terrorists eliminated','','','1',''),
('css','Terrorists_Win',0,2,'TERRORIST','All Counter-Terrorists eliminated','','','1',''),
('css','All_Hostages_Rescued',0,10,'CT','Counter-Terrorists rescued all the hostages','','','1',''),
('css','Target_Bombed',0,5,'TERRORIST','Terrorists bombed the target','','','1',''),
('css','Bomb_Defused',0,5,'CT','Counter-Terrorists defused the bomb','','','1',''),
('css','Escaped_As_VIP',0,10,'CT','VIP escaped','','','1',''),
('css','Assassinated_The_VIP',0,6,'TERRORIST','Terrorists assassinated the VIP','','','1',''),
('css','Became_VIP',1,0,'CT','Become the VIP','1','','',''),
('css','headshot',1,0,'','Headshot','1','','',''),
('css', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('css', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('css', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('css', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('css', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('css', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('css', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('css', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('css', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('css', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('css', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('hl2ctf','ctf_flag_capture',15,0,'','Captured Enemy Flag','1','','',''),
('hl2ctf','ctf_flag_defend',2,0,'','Defended the Flag','1','','',''),
('hl2ctf','ctf_kill_carrier',5,0,'','Killed Enemy Flag Carrier','1','','',''),
('hl2ctf','ctf_flag_return',5,0,'','Returned Flag','1','','',''),
('hl2ctf','ctf_flag_stolen',1,0,'','Stole Enemy Flag','1','','',''),
('hl2ctf','ctf_protect_carrier',5,0,'','Protected Flag Carrier','1','','',''),
('hl2ctf', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('hl2ctf', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('hl2ctf', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('hl2ctf', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('hl2ctf', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('hl2ctf', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('hl2ctf', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('hl2ctf', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('hl2ctf', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('hl2ctf', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('hl2ctf', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('dods','capblock',6,1,'','Capture Blocked','1','','1',''),
('dods','captured_loc',6,1,'','Area Captured','1','','1',''),
('dods','kill_planter',2,0,'','Bomb Planter Killed','1','','',''),
('dods','bomb_defuse',6,1,'','Bomb Defused','1','','1',''),
('dods','bomb_plant',6,1,'','Bomb Planted','1','','1',''),
('dods','round_win',0,5,'','Round Win','','','1',''),
('dods', 'domination', 5, 0, '', 'Domination', '', '1', '', ''),
('dods', 'revenge', 3, 0, '', 'Revenge', '', '1', '', ''),
('dods', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('dods', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('dods', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('dods', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('dods', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('dods', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('dods', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('dods', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('dods', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('dods', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('dods', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('hl2mp', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('insmod', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('insmod', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('insmod', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('insmod', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('insmod', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('insmod', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('insmod', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('insmod', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('insmod', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('insmod', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('insmod', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('ff', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('ff', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('ff', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('ff', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('ff', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('ff', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('ff', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('ff', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('ff', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('ff', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('ff', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('ff', 'headshot', 1, 0, '', 'Headshot kill', '1', '', '', ''),
('ff', 'sentrygun_upgraded', 1, 0, '', 'Upgraded Sentry Gun', '1', '', '', ''),
('ff', 'build_sentrygun', 1, 0, '', 'Built Sentry Gun', '1', '', '', ''),
('ff', 'build_dispenser', 1, 0, '', 'Built Dispenser', '1', '', '', ''),
('ff', 'dispenser_detonated', -1, 0, '', 'Dispenser Detonated', '1', '', '', ''),
('ff', 'sentry_detonated', -1, 0, '', 'Sentry Gun Detonated', '1', '', '', ''),
('ff', 'sentry_dismantled', -1, 0, '', 'Sentry Gun Dismantled', '1', '', '', ''),
('ff', 'dispenser_dismantled', -1, 0, '', 'Dispenser Dismantled', '1', '', '', ''),
('ff', 'build_mancannon', 1, 0, '', 'Built Jump Pad', '1', '', '', ''),
('ff', 'mancannon_detonated', -1, 0, '', 'Detonated Jump Pad', '1', '', '', ''),
('ff', 'build_detpack', 1, 0, '', 'Placed Detpack', '1', '', '', ''),
('ff', 'flag_touch', 3, 0, '', 'Flag Picked Up', '1', '', '', ''),
('ff', 'flag_capture', 3, 0, '', 'Flag Captured', '1', '', '', ''),
('ff', 'flag_dropped', -3, 0, '', 'Flag Dropped', '1', '', '', ''),
('ff', 'flag_thrown', -3, 0, '', 'Flag Thrown', '1', '', '', ''),
('ff', 'disguise_lost', 1, 0, '', 'Uncovered Enemy', '', '1', '', ''),
('hidden', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('hidden', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('hidden', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('hidden', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('hidden', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('hidden', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('hidden', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('hidden', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('hidden', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('hidden', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('hidden', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('zps', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('zps', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('zps', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('zps', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('zps', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('zps', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('zps', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('zps', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('zps', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('zps', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('zps', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('aoc', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('aoc', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('aoc', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('aoc', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('aoc', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('aoc', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('aoc', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('aoc', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('aoc', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('aoc', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('aoc', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('aoc', 'headshot', 2, 0, '', 'Headshot/Decapitate Kill', '1', '', '', ''),
('aoc', 'Round_Win', 0, 2, '', 'Round Win', '', '', '1', ''),
('cstrike','Begin_Bomb_Defuse_Without_Kit',0,0,'CT','Start Defusing the Bomb Without a Defuse Kit','1','0','0','0'),
('cstrike','Begin_Bomb_Defuse_With_Kit',0,0,'CT','Start Defusing the Bomb With a Defuse Kit','1','0','0','0'),
('cstrike','Assassinated_The_VIP',10,0,'TERRORIST','Assassinate the VIP','1','0','0','0'),
('cstrike','Planted_The_Bomb',15,2,'TERRORIST','Plant the Bomb','1','0','0','0'),
('cstrike','Defused_The_Bomb',15,0,'CT','Defuse the Bomb','1','0','0','0'),
('cstrike','Touched_A_Hostage',2,0,'CT','Touch a Hostage','1','0','0','0'),
('cstrike','Rescued_A_Hostage',5,1,'CT','Rescue a Hostage','1','0','0','0'),
('cstrike','Killed_A_Hostage',-25,1,'CT','Kill a Hostage','1','0','0','0'),
('cstrike','Became_VIP',1,0,'CT','Become the VIP','1','0','0','0'),
('cstrike','Spawned_With_The_Bomb',2,0,'TERRORIST','Spawn with the Bomb','1','0','0','0'),
('cstrike','Got_The_Bomb',2,0,'TERRORIST','Pick up the Bomb','1','0','0','0'),
('cstrike','Dropped_The_Bomb',-2,0,'TERRORIST','Drop the Bomb','1','0','0','0'),
('cstrike','CTs_Win',0,2,'CT','All Terrorists eliminated','0','0','1','0'),
('cstrike','Terrorists_Win',0,2,'TERRORIST','All Counter-Terrorists eliminated','0','0','1','0'),
('cstrike','All_Hostages_Rescued',0,10,'CT','Counter-Terrorists rescued all the hostages','0','0','1','0'),
('cstrike','Target_Bombed',0,10,'TERRORIST','Terrorists bombed the target','0','0','1','0'),
('cstrike','VIP_Assassinated',0,6,'TERRORIST','Terrorists assassinated the VIP','0','0','1','0'),
('cstrike','Bomb_Defused',0,6,'CT','Counter-Terrorists defused the bomb','0','0','1','0'),
('cstrike','VIP_Escaped',0,10,'CT','VIP escaped','0','0','1','0'),
('cstrike', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('cstrike', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('cstrike', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('cstrike', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('cstrike', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('cstrike', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('cstrike', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('cstrike', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('cstrike', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('cstrike', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('cstrike', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('tfc','rock2_bcave1',2,3,'0','(rock2) Blow Red Cave','1','0','0','0'),
('tfc','rock2_rcave1',2,3,'0','(rock2) Blow Blue Cave','1','0','0','0'),
('tfc','rock2_rholedet',2,3,'0','(rock2) Blow Blue Yard','1','0','0','0'),
('tfc','rock2_bholedet',2,3,'0','(rock2) Blow Red Yard','1','0','0','0'),
('tfc','Team 2 dropoff',7,0,'2','Captured Blue Flag','1','0','0','0'),
('tfc','Team 1 dropoff',7,0,'1','Captured Red Flag','1','0','0','0'),
('tfc','Medic_Infection',2,0,'2','Infected Enemy','0','1','0','0'),
('tfc','Medic_Cured_Infection',2,0,'2','Cured Infection','0','1','0','0'),
('tfc','Hallucination_Grenade',1,0,'0','Hallucination','0','1','0','0'),
('tfc','Concussion_Grenade',1,0,'0','Concussion','0','1','0','0'),
('tfc','Teleporter_Entrance_Dismantle',-2,0,'0','Teleporter Entrance Dismantled','1','0','0','0'),
('tfc','Teleporter_Entrance_Destroyed',1,0,'0','Teleporter Entrance Destroyed','0','1','0','0'),
('tfc','Teleporter_Entrance_Finished',2,0,'0','Teleporter Entrance Build','1','0','0','0'),
('tfc','Teleporter_Exit_Dismantle',-2,0,'0','Teleporter Exit Dismantled','1','0','0','0'),
('tfc','Teleporter_Exit_Destroyed',1,0,'0','Teleporter Exit Destroyed','0','1','0','0'),
('tfc','Teleporter_Exit_Finished',2,0,'0','Teleporter Exit Build','1','0','0','0'),
('tfc','Sentry_Built_Level_1',2,0,'0','Built Sentry','1','0','0','0'),
('tfc','Sentry_Upgrade_Level_2',1,0,'0','Upgraded Sentry to Lvl 2','1','0','0','0'),
('tfc','Sentry_Upgrade_Level_3',1,0,'0','Upgraded Sentry to Lvl 3','1','0','0','0'),
('tfc','Sentry_Destroyed',3,0,'0','Upgraded Sentry to Lvl 3','0','1','0','0'),
('tfc','Sentry_Dismantle',3,0,'0','Dismantled Sentry Gun','0','1','0','0'),
('tfc','Dispenser_Dismantle',3,0,'0','Dismantled Dispenser','0','1','0','0'),
('tfc','Discovered_Spy',2,0,'0','Discovered a Spy','1','0','0','0'),
('tfc','Dispenser_Destroyed',5,0,'0','Dispenser Destroyed','1','0','0','0'),
('tfc','Built_Dispenser',8,0,'0','Built Dispenser','1','0','0','0'),
('tfc', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('tfc', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('tfc', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('tfc', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('tfc', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('tfc', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('tfc', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('tfc', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('tfc', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('tfc', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('tfc', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('dod','dod_control_point',6,1,'','Control Points Captured','1','0','1','0'),
('dod','dod_capture_area',6,1,'','Areas Captured','1','0','1','0'),
('dod','dod_object_goal',4,0,'','Objectives Achieved','1','0','0','0'),
('dod', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('dod', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('dod', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('dod', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('dod', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('dod', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('dod', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('dod', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('dod', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('dod', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('dod', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('ns','structure_built',1,0,'','Structures Built','1','0','0','0'),
('ns','structure_destroyed',2,0,'','Structures Destroyed','1','0','0','0'),
('ns','research_start',1,0,'','Researches Performed','1','0','0','0'),
('ns','recycle',-3,0,'','Structures Recycled','1','0','0','0'),
('ns','structure_built_alienresourcetower',1,0,'','Built Alien Resource Tower','1','0','0','0'),
('ns','structure_destroyed_alienresourcetower',2,0,'','Destroyed Alien Resource Tower','1','0','0','0'),
('ns','structure_built_phasegate',1,0,'','Built Phasegate','1','0','0','0'),
('ns','structure_destroyed_phasegate',2,0,'','Destroyed Phasegate','1','0','0','0'),
('ns','structure_built_resourcetower',1,0,'','Built Resource Tower','1','0','0','0'),
('ns','structure_destroyed_resourcetower',2,0,'','Destroyed Resource Tower','1','0','0','0'),
('ns','structure_built_siegeturret',1,0,'','Built Siege Turret','1','0','0','0'),
('ns','structure_destroyed_siegeturret',2,0,'','Destroyed Siege Turret','1','0','0','0'),
('ns','structure_built_team_advturretfactory',1,0,'','Built Advanced Turret Factory','1','0','0','0'),
('ns','structure_destroyed_team_advturretfactory',2,0,'','Destroyed Advanced Turret Factory','1','0','0','0'),
('ns','structure_built_team_armory',1,0,'','Built Armory','1','0','0','0'),
('ns','structure_destroyed_team_armory',2,0,'','Destroyed Armory','1','0','0','0'),
('ns','structure_built_team_turretfactory',1,0,'','Built Turret Factory','1','0','0','0'),
('ns','structure_destroyed_team_turretfactory',2,0,'','Destroyed Turret Factory','1','0','0','0'),
('ns','structure_built_turret',1,0,'','Built Turret','1','0','0','0'),
('ns','structure_destroyed_turret',2,0,'','Destroyed Turret','1','0','0','0'),
('ns','structure_built_team_infportal',1,0,'','Built INF Portal','1','0','0','0'),
('ns','structure_destroyed_team_infportal',2,0,'','Destroyed INF Portal','1','0','0','0'),
('ns','structure_built_defensechamber',1,0,'','Built Defense Chamber','1','0','0','0'),
('ns','structure_destroyed_defensechamber',2,0,'','Destroyed Defense Chamber','1','0','0','0'),
('ns','structure_built_offensechamber',1,0,'','Built Offense Chamber','1','0','0','0'),
('ns','structure_destroyed_offensechamber',2,0,'','Destroyed Offense Chamber','1','0','0','0'),
('ns','structure_built_movementchamber',1,0,'','Built Movement Chamber','1','0','0','0'),
('ns','structure_destroyed_movementchamber',2,0,'','Destroyed Movement Chamber','1','0','0','0'),
('ns','structure_built_team_hive',1,0,'','Built Alien Hive','1','0','0','0'),
('ns','structure_destroyed_team_hive',2,0,'','Destroyed Alien Hive','1','0','0','0'),
('ns','structure_built_team_armslab',1,0,'','Built Arms Lab','1','0','0','0'),
('ns','structure_destroyed_team_armslab',2,0,'','Destroyed Arms Lab','1','0','0','0'),
('ns','structure_built_sensorychamber',1,0,'','Built Sensory Chamber','1','0','0','0'),
('ns','structure_destroyed_sensorychamber',2,0,'','Destroyed Sensory Chamber','1','0','0','0'),
('ns','structure_built_team_prototypelab',1,0,'','Built Prototype Lab','1','0','0','0'),
('ns','structure_destroyed_team_prototypelab',2,0,'','Destroyed Prototype Lab','1','0','0','0'),
('ns','structure_built_team_command',1,0,'','Built Command Unit','1','0','0','0'),
('ns','structure_destroyed_team_command',2,0,'','Destroyed Command Unit','1','0','0','0'),
('ns','structure_built_team_observatory',1,0,'','Built Observatory','1','0','0','0'),
('ns','structure_destroyed_team_observatory',1,0,'','Destroyed Observatory','1','0','0','0'),
('ns','structure_built_team_advarmory',1,0,'','Built Advanced Armory','1','0','0','0'),
('ns','structure_destroyed_team_advarmory',1,0,'','Destroyed Advanced Armory','1','0','0','0'),
('ns','structure_built_scan',1,0,'','Built Scanner','1','0','0','0'),
('ns','structure_destroyed_scan',1,0,'','Destroyed Scanner','1','0','0','0'),
('ns','structure_built_weapon_grenadegun',1,0,'','Created a Grenade Gun','1','0','0','0'),
('ns','structure_built_weapon_heavymachinegun',1,0,'','Created a Heavy Machine Gun','1','0','0','0'),
('ns','structure_built_weapon_shotgun',1,0,'','Created a Shotgun','1','0','0','0'),
('ns','structure_built_weapon_welder',1,0,'','Created a Welder','1','0','0','0'),
('ns','structure_built_weapon_mine',1,0,'','Created a Mine','1','0','0','0'),
('ns','structure_built_item_heavyarmour',1,0,'','Created Heavy Armour','1','0','0','0'),
('ns','structure_built_item_catalyst',1,0,'','Created a Catalyst','1','0','0','0'),
('ns','structure_built_item_genericammo',1,0,'','Created Generic Ammo','1','0','0','0'),
('ns','structure_built_item_health',1,0,'','Created a Healthpack','1','0','0','0'),
('ns','structure_built_item_jetpack',1,0,'','Created a Jetpack','1','0','0','0'),
('ns','research_cancel',-1,0,'','Stopped Researching ','1','0','0','0'),
('ns', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('ns', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('ns', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('ns', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('ns', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('ns', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('ns', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('ns', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('ns', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('ns', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('ns', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('l4d', 'headshot', 0, 0, '', 'Headshot Kill', '1', '', '', ''),
('l4d', 'rescued_survivor', 2, 0, '', 'Rescued Teammate', '1', '0', '0', '0'),
('l4d', 'healed_teammate', 5, 0, '', 'Healed Teammate', '1', '0', '0', '0'),
('l4d', 'revived_teammate', 3, 0, '', 'Revived Teammate', '1', '0', '0', '0'),
('l4d', 'startled_witch', -5, 0, '', 'Startled the Witch', '1', '0', '0', '0'),
('l4d', 'pounce', 6, 0, '', '(Hunter) Pounced on Survivor', '0', '1', '0', '0'),
('l4d', 'tongue_grab', 6, 0, '', '(Smoker) Tongue Grabbed Survivor', '0', '1', '0', '0'),
('l4d', 'vomit', 6, 0, '', '(Boomer) Vomited on Survivor', '0', '1', '0', '0'),
('l4d', 'killed_gas', 1, 0, '', 'Killed a Smoker', '1', '0', '0', '0'),
('l4d', 'killed_exploding', 1, 0, '', 'Killed a Boomer', '1', '0', '0', '0'),
('l4d', 'killed_hunter', 1, 0, '', 'Killed a Hunter', '1', '0', '0', '0'),
('l4d', 'killed_tank', 3, 0, '', 'Killed a Tank', '1', '0', '0', '0'),
('l4d', 'killed_witch', 3, 0, '', 'Killed a Witch', '1', '0', '0', '0'),
('l4d', 'killed_survivor', 25, 0, '', 'Incapacitated/Killed Survivor', '0', '1', '0', '0'),
('l4d', 'friendly_fire', -10, 0, '', 'Friendly Fire', '1', '0', '0', '0'),
('fof', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('fof', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('fof', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('fof', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('fof', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('fof', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('fof', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('fof', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('fof', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('fof', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('fof', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('fof', 'loot_drop', -2, 0, '', 'Dropped the loot', '1', '', '', ''),
('fof', 'loot_capture', 8, 0, '', 'Captured the loot', '1', '', '', ''),
('fof', 'carrier_protect', 5, 0, '', 'Protected the carrier', '1', '', '', ''),
('fof', 'headshot', 1, 0, '', 'Headshot Kill', '1', '', '', ''),
('ges', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', ''),
('ges', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', ''),
('ges', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', ''),
('ges', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', ''),
('ges', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', ''),
('ges', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', ''),
('ges', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', ''),
('ges', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', ''),
('ges', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', ''),
('ges', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', ''),
('ges', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', ''),
('ges', 'Round_Win', 5, 0, '', 'Round Win', '1', '', '', ''),
('ges', 'Round_Win_Team', 0, 3, '', 'Team Round Win', '', '', '1', '');


ALTER TABLE `hlstats_Awards`
CHANGE `awardType` `awardType` CHAR( 1 ) NOT NULL DEFAULT 'W',
CHANGE `verb` `verb` varchar(128) NOT NULL default '',
ADD COLUMN `g_winner_id` int(10) unsigned default NULL,
ADD COLUMN `g_winner_count` int(10) unsigned default NULL;

INSERT IGNORE INTO `hlstats_Awards` (`awardType`, `game`, `code`, `name`, `verb`) VALUES
('W','tf','tf_projectile_pipe_remote','Remote Demolition Man','pipe bomb kills'),
('W','tf','tf_projectile_pipe','Demolition Man','pipe bomb kills'),
('W','tf','sniperrifle','Top Sniper','snipings'),
('W','tf','smg','Submachine gun','smg kills'),
('W','tf','shotgun_soldier','Shotgun Soldier','shotgun kills'),
('W','tf','shotgun_pyro','Shotgun Pyro','shotgun kills'),
('W','tf','shotgun_primary','Shotgun','shotgun kills'),
('W','tf','scattergun','Fast and Furious','scattergun kills'),
('W','tf','revolver','Wayne','revolver kills'),
('W','tf','pistol','Pistol','pistol kills'),
('W','tf','obj_sentrygun','Engineer','sentry kills'),
('W','tf','minigun','Terminator','minigun kills'),
('W','tf','knife','Stabber','knifings'),
('W','tf','flamethrower','Pyro','flame burnings'),
('W','tf','bat','Baseball freak','bat kills'),
('O','tf','pointcaptured','Capturer','checkpoint captures'),
('O','tf','kill assist','Assistance','kill assists'),
('O','tf','captureblocked','Blocker','checkpoint blockings'),
('O','tf','chargedeployed','Ubermedic','deployed charges'),
('P','tf','domination','Dominator','dominations'),
('V','tf','domination','Most dominated','times dominated'),
('P','tf','revenge','King of vengence','revenges'),
('W','tf','latency','Best Latency','ms average connection'),
('W','tf','tf_projectile_rocket','Soldier','rocket kills'),
('W','tf','wrench','Engineer on Rage','wrench kills'),
('W','tf','shovel','Grave Digger','shovel kills'),
('W','tf','fireaxe','Axe-O-Mania','axe kills'),
('W','tf','bottle','Drunken Demoman','bottle kills'),
('W','tf','bonesaw','The Saw','sawed bones'),
('W','tf','fists','Fisting king','fistings'),
('W','tf','club','Now that\'s a knife','machete kills'),
('W','tf','pistol_scout','Scout Pistol','pistol kills'),
('W','tf','shotgun_hwg','Shotgun Heavy','shotgun kills'),
('W','tf','syringegun_medic','The Injector','syringe kills'),
('W','tf','axtinguisher', 'Axtinguisher', 'kills with the axtinguisher'),
('W','tf','backburner', 'Backburner', 'burned backs'),
('W','tf','blutsauger', 'Blutsauger', 'times sucked blood'),
('W','tf','flaregun', 'Flare Gun', 'flare gun kills'),
('W','tf','gloves', 'Heavy surgery', 'KGB kills'),
('W','tf','natascha', 'Nataschas Friend', 'Natascha kills'),
('W','tf','ubersaw', 'Ubersaw', 'kills with ubersaw'),
('O','tf', 'sandvich', 'Hungry Hungry Heavy', 'sandviches eaten.'),
('O','tf','flagevent_defended','Defender of the Flag','flag defenses'),
('O','tf','flagevent_captured','The Mad Capper','flag captures'),
('O','tf','killedobject_obj_dispenser','NO METAL FOR YOU!','dispensers destroyed'),
('O','tf','killedobject_obj_sentrygun','Say no to sentries','sentry guns destroyed'),
('O','tf','builtobject_obj_sentrygun','Bob the Builder','sentry guns built'),
('W','hl2mp','crowbar','01. (Crowbar) Rebel for Life','guys slaughtered and some more fleshwounds'),
('W','hl2mp','physics','04. (Physics) Bummsmaster','kills with the Zeropoint Energyfield Manipulator'),
('W','hl2mp','physbox','05. (Physbox) Baffmaster','hits with this and that'),
('W','hl2mp','stunstick','02. (Stunstick) Stockmaster','guys beatn up'),
('W','hl2mp','pistol','03. (Pistol) Freakin Pistol Freak','times freaked out'),
('W','hl2mp','shotgun','09. (Pumpgun) Duckmaster','kills with the Duckmaster2k'),
('W','hl2mp','357','08. (.357) Peacemaker','Killshots'),
('W','hl2mp','smg1','14. (SMG) SMG Killer','kills with the SMGay'),
('W','hl2mp','ar2','11. (AR2) Rattertante','kills with the assault rifle'),
('W','hl2mp','crossbow_bolt','10. (Crossbow) Robin Hood','guys killed instantly'),
('W','hl2mp','slam','12. (Slam) Trapmaster','guys trapped and killed'),
('W','hl2mp','grenade_frag','06. (Grenade) Nadethrower 2k','guys nuked'),
('W','hl2mp','rpg_missile','16. (RPG) Clumsy Smurf found the RPG!','times pissed in the pants'),
('W','hl2mp','combine_ball','07. (Combine Balls) Ball Player','guys set on fire'),
('W','hl2mp','smg1_grenade','13. (SMG Nade) SMG Nader','guys exploded by him'),
('W','hl2mp','latency','15. (Latency) Lowpinger','ms average'),
('W','css','awp','AWP','kills with awp'),
('W','css','latency','Best Latency','ms average connection'),
('W','css','galil','Galil','kills with galil'),
('W','css','famas','Fusil Automatique','kills with famas'),
('W','css','ak47','AK47','kills with ak47'),
('W','css','glock','Glock','kills with glock'),
('W','css','m4a1','Colt M4A1 Carbine','kills with m4a1'),
('W','css','usp','USP Master','kills with usp'),
('W','css','m3','M3 Shotgun','kills with m3 shotgun'),
('W','css','deagle','Desert Eagle','kills with deagle'),
('W','css','p90','P 90','kills with p90'),
('W','css','knife','Knife Maniac','knifings'),
('W','css','elite','Dual Berretta Elites','kills with elite'),
('O','css','Rescued_A_Hostage','Top Hostage Rescuer','hostages rescued'),
('O','css','Planted_The_Bomb','Top Demolitionist','bomb plantings'),
('O','css','Defused_The_Bomb','Top Defuser','bomb defusions'),
('W','css','aug','Steyr Aug','kills with aug'),
('W','css','fiveseven','Five Seven','kills with fiveseven'),
('W','css','g3sg1','G3 SG1','kills with g3sg1'),
('W','css','m249','Para','kills with m249'),
('W','css','mac10','Mac 10','kills with mac10'),
('W','css','mp5navy','MP5 Navy','kills with mp5'),
('W','css','p228','P 228','kills with p228'),
('W','css','sg550','SG 550','kills with sg550'),
('W','css','sg552','SG 552','kills with sg552'),
('W','css','tmp','TMP','kills with tmp'),
('W','css','ump45','UMP 45','kills with ump45'),
('W','css','xm1014','XM automatic Shotgun','kills with xm1014'),
('O','css','headshot','Headshot King','shots in the head'),
('W','css','scout','Scout Elite','kills with scout'),
('W','css','hegrenade','Top grenadier','kills with grenade'),
('O','css','Killed_A_Hostage','Top Hostage Killer','hostages killed'),
('W','hl2ctf','crowbar','Crowbar','bludgeonings with ole red'),
('W','hl2ctf','physcannon','Anger Issues','kills with physics' ),
('W','hl2ctf','stunstick','Stun Stick','kills with stunstick'),
('W','hl2ctf','pistol','Pistol','kills with pistol'),
('W','hl2ctf','shotgun','A freakin 12 gague!','kills with shotgun'),
('W','hl2ctf','357','Clint','kills with .357'),
('W','hl2ctf','smg1','SMG','kills with the smg'),
('W','hl2ctf','ar2','Assault','kills with the assault rifle'),
('W','hl2ctf','crossbow_bolt','Sniper','snipings with crossbow'),
('W','hl2ctf','slam','SLAMMED!','kills with the slam'),
('W','hl2ctf','grenade_frag','Grenade Fiend','kills with nades'),
('W','hl2ctf','rpg_missile','Role Player','kills with RPG'),
('W','hl2ctf','latency','Best Latency','ms average connection'),
('O','dods','bomb_defuse','Top Defuser','bomb defusions'),
('O','dods','bomb_plant','Top Demolitionist','bomb plantings'),
('O','dods','kill_planter','Bomb Planter Killer','kills'),
('W','dods','amerknife','Backstabbing Beotch','kills with the American Knife'),
('W','dods','mp40','MP40 Hor','kills with the MP40 Machine Pistol'),
('W','dods','spade','Shovel God','kills with the spade'),
('W','dods','mp44','MP44 Hor','kills with the MP44 Assault Rifle'),
('W','dods','colt','Colt Freak','kills with the Colt .45 model 1911'),
('W','dods','garand','GarandMeister','kills with the M1 Garand Rifle'),
('W','dods','thompson','Thompson Hor','kills with the Thompson Submachine Gun'),
('W','dods','spring','Spring Sniper','snipings with the Springfield 03 Rifle'),
('W','dods','bar','Bar Browning Hor','kills with the BAR Browning Automatic Rifle'),
('W','dods','frag_us','McVeigh Alert','bombings with the U.S. Grenade'),
('W','dods','frag_ger','Grenade Freak','bombings with the German Grenade'),
('W','dods','bazooka','Bazooka Joe','kills with the Bazooka'),
('W','dods','pschreck','Panzerschreck Hans','kills with the Panzerschreck'),
('W','dods','latency','Best Latency','ms average connection'),
('W','dods','punch','Puncher','knock-outs'),
('W','dods','mg42','German Machine Hor','kills with the MG42'),
('O','dods','captured_loc','Area Captured','flags captured'),
('W','insmod','latency','Best Latency','ms average connection'),
('W','insmod','weapon_makarov','Soviet Makarov Combat Pistol','kills with Soviet Makarov Combat Pistol'),
('W','insmod','weapon_m9','9mm Beretta Pistol','kills with 9mm Beretta Pistol'),
('W','insmod','weapon_sks','Simonov SKS carbine','kills with Simonov SKS carbine'),
('W','insmod','world','RPG or Grenade','kills with RPG or Grenade'),
('W','insmod','weapon_m1014','M1014 Service Combat Shotgun','kills with M1014 Service Combat Shotgun'),
('W','insmod','weapon_toz','TOZ Rifle','kills with TOZ Rifle'),
('W','insmod','weapon_svd','Dragunov Sniper Rifle','kills with Dragunov Sniper Rifle'),
('W','insmod','weapon_rpk','RPK Ruchnoy Pulemyot Kalashnikova','kills with RPK Ruchnoy Pulemyot Kalashnikova'),
('W','insmod','weapon_m249','M249 SAW (Squad Automatic Weapon)','kills with M249 SAW (Squad Automatic Weapon)'),
('W','insmod','weapon_m16m203','M16 carbine M203 Grenade Launcher','kills with M16 carbine M203 Grenade Launcher'),
('W','insmod','weapon_l42a1','Enfield L42A1 Military Sniper Rifle','kills with Enfield L42A1 Military Sniper Rifle'),
('W','insmod','weapon_m4med','M4 Medium Range Rifle','kills with M4 Medium Range Rifle'),
('W','insmod','weapon_m4','M4 Carbine Rifle','kills with M4 Carbine Rifle'),
('W','insmod','weapon_m16a4','M16A4 Infantry Rifle','kills with M16A4 Infantry Rifle'),
('W','insmod','weapon_m14','Colt M14 Carbine','kills with Colt M14 Carbine'),
('W','insmod','weapon_fnfal','FN FAL Automatic Rifle','kills with FN FAL Automatic Rifle'),
('W','insmod','weapon_aks74u','AKS-74U Awtomat Kalaschnikowa Ukorochennyj','kills with AKS-74U'),
('W','insmod','weapon_ak47','AK-47 Awtomat Kalaschnikowa','kills with AK-47 Awtomat Kalaschnikowa'),
('W', 'ff', 'weapon_tranq', 'Drug Dealer', 'kills with tranq gun'),
('W', 'ff', 'weapon_supershotgun', 'Super Shots', 'kills with super shotgun'),
('W', 'ff', 'weapon_supernailgun', 'Super Nails', 'kills with super nailgun'),
('W', 'ff', 'weapon_spanner', 'Whack-A-Mole', 'kills with spanner'),
('W', 'ff', 'weapon_sniperrifle', 'Snipes-A-Holic', 'kills with sniper rifle'),
('W', 'ff', 'weapon_rpg', 'ROCKET MAN', 'kills with rpg'),
('W', 'ff', 'weapon_shotgun', 'N00b shotwhore', 'kills with normal shotgun'),
('W', 'ff', 'weapon_railgun', 'Pew pew laz0r beams', 'kills with railgun'),
('W', 'ff', 'weapon_pipelauncher', 'Bouncy pipe whore', 'kills with blues'),
('W', 'ff', 'weapon_medkit', 'Aids Monger', 'kills with aids'),
('W', 'ff', 'weapon_knife', 'My name is Skanky Butterpuss(e)', 'kills with knife'),
('W', 'ff', 'weapon_grenadelauncher', 'Click BOOM', 'kills with grellows'),
('W', 'ff', 'weapon_flamethrower', 'I like fire!', 'kills with flamethrower'),
('W', 'ff', 'weapon_autorifle', 'Gay Sniper', 'kills with AR'),
('W', 'ff', 'weapon_dispenser', 'Remote Control GOD', 'kills with dispenser'),
('W', 'ff', 'weapon_assaultcannon', 'Best Fatty Ever!', 'kills with ass cannon'),
('W', 'ff', 'SentryGun', 'Robocop', 'kills with SG'),
('W', 'ff', 'grenade_normal', 'Flying chicken!', 'kills with frag grenade'),
('W', 'ff', 'grenade_mirv', 'Look I can kill SGs!', 'kills with mirv grenade'),
('W', 'ff', 'grenade_emp', 'Wheres all my ammo!', 'kills with emp grenade'),
('W', 'ff', 'BOOM_HEADSHOT', 'Sharp Eye', 'headshots'),
('W', 'ff', 'DETPACK', 'Earthquake Machine', 'kills with detpack'),
('W', 'ff','latency','Best Latency','ms average connection'),
('W', 'hidden', 'fn2000', 'FN2000 Assault Rifle', 'kills with FN2000 Assault Rifle'),
('W', 'hidden', 'p90', 'FN P90 Sub Machine Gun', 'kills with FN P90 Sub Machine Gun'),
('W', 'hidden', 'shotgun', 'Remington 870 MCS Shotgun', 'kills with Remington 870 MCS Shotgun'),
('W', 'hidden', 'fn303', 'FN303 Less Lethal Launcher', 'kills with FN303 Less Lethal Launcher'),
('W', 'hidden', 'pistol', 'FN FiveSeven Pistol', 'kills with FN FiveSeven Pistol'),
('W', 'hidden', 'pistol2', 'FNP-9 Pistol', 'kills with FNP-9 Pistol'),
('W', 'hidden', 'knife', 'Kabar D2 Knife', 'kills with Kabar D2 Knife'),
('W', 'hidden', 'grenade_projectile', 'Pipe Bomb', 'kills with Pipe Bomb'),
('W', 'hidden', 'physics', 'Physics', 'kills with Physics'),
('W', 'hidden','latency','Best Latency','ms average connection'),
('W', 'zps', 'arms', 'Armed and Dangerous', 'kills with Zombie Arms'),
('W', 'zps', 'carrierarms', 'Carry on...', 'kills with Carrier Arms'),
('W', 'zps', 'ak47', 'AK-47', 'kills with AK-47'),
('W', 'zps', 'mp5', 'MP5', 'kills with MP5'),
('W', 'zps', 'revolver', 'Revolver', 'kills with Revolver'),
('W', 'zps', 'glock', 'Glock 17', 'kills with Glock 17'),
('W', 'zps', 'glock18c', 'Glock 18c', 'kills with Glock 18c'),
('W', 'zps', 'ppk', 'PPK', 'kills with PPK'),
('W', 'zps', 'usp', 'H & K USP', 'kills with H & K USP'),
('W', 'zps', '870', 'Rem. 870', 'kills with Rem. 870'),
('W', 'zps', 'supershorty', 'Super Shorty', 'kills with Super Shorty'),
('W', 'zps', 'grenade_frag', 'Grenade', 'kills with Grenades'),
('W', 'zps', 'sledgehammer', 'Sledgehammer', 'kills with Sledgehammer'),
('W', 'zps', 'crowbar', 'Hello, I\'m Gordon Freeman', 'kills with Crowbar'),
('W', 'zps', 'chair', 'Sorry, I thought this was pro wrestling', 'kills with Chair'),
('W', 'zps', 'keyboard', 'Keyboard', 'kills with Keyboard'),
('W', 'zps', 'plank', 'Plank', 'kills with Plank'),
('W', 'zps', 'shovel', 'Grave Digger', 'kills with Shovel'),
('W', 'zps', 'golf', 'Fore!', 'kills with Golf Club'),
('W', 'zps', 'machete', 'Cuttin\' em Down', 'kills with Machete'),
('W', 'zps', 'fryingpan', 'Frying Pan', 'kills with Frying Pan'),
('W', 'zps', 'spanner', 'Wrench', 'kills with Wrench'),
('W', 'zps', 'axe', 'Axe', 'kills with Axe'),
('W', 'zps', 'tireiron', 'Tire Iron', 'kills with Tire Iron'),
('W', 'zps', 'hammer', 'Hammer', 'kills with Hammer'),
('W', 'zps', 'broom', 'Broom', 'kills with Broom'),
('W', 'zps', 'pot', 'Pot', 'kills with Pot'),
('W', 'zps', 'racket', 'Tennis Racket', 'kills with Tennis Racket'),
('W', 'zps', 'latency','Best Latency','ms average connection'),
('W', 'aoc', 'Flamberge', 'Flamberge', 'kills with Flamberge'),
('W', 'aoc', 'Longsword', 'Longsword', 'kills with Longsword'),
('W', 'aoc', 'Glaive', 'Glaive', 'kills with Glaive'),
('W', 'aoc', 'Dual Daggers', 'Dual Daggers', 'kills with Dual Daggers'),
('W', 'aoc', 'Flamberge & Kite Shield', 'Flamberge & Kite Shield', 'kills with Flamberge & Kite Shield'),
('W', 'aoc', 'Shortsword', 'Shortsword', 'kills with Shortsword'),
('W', 'aoc', 'Warhammer', 'Warhammer', 'kills with Warhammer'),
('W', 'aoc', 'Mace', 'Mace', 'kills with Mace'),
('W', 'aoc', 'Mace & Buckler', 'Mace & Buckler', 'kills with Mace & Buckler'),
('W', 'aoc', 'Broadsword & Evil Shield', 'Mason Broadsword & Shield', 'kills with Mason Broadsword & Shield'),
('W', 'aoc', 'Crossbow', 'Crossbow', 'kills with Crossbow'),
('W', 'aoc', 'Longbow', 'Longbow', 'kills with Longbow'),
('W', 'aoc', 'Longsword & Kite Shield', 'Longsword & Kite Shield', 'kills with Longsword & Kite Shield'),
('W', 'aoc', 'Broadsword & Good Shield', 'Knights Broadsword & Shield', 'kills with Knights Broadsword & Shield'),
('W', 'aoc', 'Hatchet', 'Hatchet', 'kills with Hatchet'),
('W', 'aoc', 'Double Axe', 'Battle Axe', 'kills with Battle Axe'),
('W', 'aoc', 'Flail & Evil Shield', 'Mason Flail & Shield', 'kills with Mason Flail & Shield'),
('W', 'aoc', 'Flail & Good Shield', 'Knights Flail & Shield', 'kills with Knights Flail & Shield'),
('W', 'aoc', 'Javelin', 'Javelin', 'kills with Javelin'),
('W', 'aoc', 'Spiked Mace', 'Spiked Mace', 'kills with Spiked Mace'),
('W', 'aoc', 'Spear & Buckler', 'Spear & Buckler', 'kills with Spear & Buckler'),
('W', 'aoc', 'Spiked Mace & Buckler', 'Spiked Mace & Buckler', 'kills with Spiked Mace & Buckler'),
('W', 'aoc', 'Dagger', 'Dagger', 'kills with Dagger'),
('W', 'aoc', 'Broadsword', 'Broadsword', 'kills with Broadsword'),
('W', 'aoc', 'Throwing Knife', 'Throwing Knife', 'kills with Throwing Knives'),
('W', 'aoc', 'Halberd', 'Halberd', 'kills with Halberd'),
('W', 'aoc', 'env_explosion', 'Fire', 'kills with Fire'),
('W', 'aoc', 'Oilpot', 'Oil Pot', 'kills with Oil Pot'),
('O', 'aoc', 'headshot', 'Headshot/Decapitation', 'Headshots and Decapitations'),
('W', 'aoc','latency','Best Latency','ms average connection'),
('O','cstrike','Defused_The_Bomb','Top Defuser','bomb defusions'),
('O','cstrike','Planted_The_Bomb','Top Demolitionist','bomb plantings'),
('O','cstrike','Rescued_A_Hostage','Top Hostage Rescuer','hostages rescued'),
('O','cstrike','Assassinated_The_VIP','Top Assassin','assassinations'),
('W','cstrike','elite','Dual Berretta Elites','kills with elite'),
('W','cstrike','knife','Knife Maniac','knifings'),
('W','cstrike','awp','AWP','snipings with awp'),
('W','cstrike','p90','P90','kills with p90'),
('W','cstrike','deagle','Desert Eagle','kills with deagle'),
('W','cstrike','m3','Shotgun','kills with m3 shotgun'),
('W','cstrike','usp','USP Master','kills with usp'),
('W','cstrike','m4a1','Colt M4A1 Carbine','kills with m4a1'),
('W','cstrike','glock18','Glock','kills with glock18'),
('W','cstrike','ak47','AK47','kills with ak47'),
('W','cstrike','famas','Fusil Automatique','kills with famas'),
('W','cstrike','galil','Galil','kills with galil'),
('W','cstrike','latency','Best Latency','ms average connection'),
('W','tfc','axe','Crowbar Maniac','murders with crowbar'),
('W','tfc','spanner','Evil Engie','bludgeonings with spanner'),
('W','tfc','rocket','Rocketeer','kills with rocket'),
('W','tfc','ac','HWGuy Extraordinaire','ownings with ac'),
('W','tfc','sniperrifle','Red Dot Special','snipings'),
('W','tfc','flames','Fire Man','roastings'),
('W','tfc','latency','Best Latency','ms average connection'),
('W','dod','amerknife','Backstabbing Beotch','kills with the American Knife'),
('W','dod','luger','Luger Freak','kills with the Luger 08 Pistol'),
('W','dod','kar','KarMeister','kills with the Mauser Kar 98k'),
('W','dod','mp40','MP40 Hor','kills with the MP40 Machine Pistol'),
('W','dod','spade','Shovel God','kills with the spade'),
('W','dod','mp44','MP44 Hor','kills with the MP44 Assault Rifle'),
('W','dod','colt','Colt Freak','kills with the Colt .45 model 1911'),
('W','dod','garand','GarandMeister','kills with the M1 Garand Rifle'),
('W','dod','thompson','Thompson Hor','kills with the Thompson Submachine Gun'),
('W','dod','spring','Spring Sniper','snipings with the Springfield 03 Rifle'),
('W','dod','bar','Bar Browning Hor','kills with the BAR Browning Automatic Rifle'),
('W','dod','grenade','McVeigh Alert','bombings with the Grenade'),
('W','dod','garandbutt','Headsmasher','kills with Garand Butt Stock'),
('W','dod','bazooka','Bazooka Joe','kills with the Bazooka'),
('W','dod','pschreck','Panzerschreck Hans','kills with the Panzerschreck'),
('W','dod','latency','Best Latency','ms average connection'),
('W','ns','slash','Vicious Kitty','killings by le Swipe'),
('W','ns','shotgun','Buckshot Masta','killings with the shotty'),
('W','ns','pistol','Harold Handgun Alert','asskickings by pistola'),
('W','ns','knife','Iron Chef Alert','vicious stabbings'),
('W','ns','grenade','absolute n00b','pathetic killings by n00b grenades'),
('W','ns','bitegun','Teething Tommy','killings with le jaw'),
('W','ns','bite2gun','Mouth Full','killings with le big jaw'),
('W','ns','leap','Tigger Alert','crushings by leap'),
('W','ns','divinewind','Silent but Violent','slayings by recal relief'),
('W','ns','sporegunprojectile','Left Feet Larry','killings with Lerk'),
('W','ns','devour','Hungry Hungry Hippo','killings by Ingestion'),
('W','ns','spitgunspit','Masta Fatty','Marines too dumb to kill a gorge'),
('W','ns','latency','Best Latency','ms average connection'),
('O', 'l4d', 'headshot', 'Brain Salad', 'headshot kills'),
('O', 'l4d', 'healed_teammate', 'Field Medic', 'healed Survivors'),
('O', 'l4d', 'killed_exploding', 'Stomach Upset', 'killed Boomers'),
('O', 'l4d', 'killed_gas', 'No Smoking Section', 'killed Smokers'),
('O', 'l4d', 'killed_hunter', 'Hunter Punter', 'killed Hunters'),
('P', 'l4d', 'killed_survivor', 'Dead Wreckening', 'downed Survivors'),
('O', 'l4d', 'killed_tank', 'Tankbuster', 'killed Tanks'),
('O', 'l4d', 'killed_witch', 'Inquisitor', 'killed Witches'),
('P', 'l4d', 'pounce', 'Free to Fly', 'pounced Survivors'),
('O', 'l4d', 'rescued_survivor', 'Ground Cover', 'rescued Survivors'),
('O', 'l4d', 'revived_teammate', 'Helping Hand', 'revived Survivors'),
('P', 'l4d', 'tongue_grab', 'Drag &amp; Drop', 'constricted Survivors'),
('P', 'l4d', 'vomit', 'Barf Bagged', 'vomited on Survivors'),
('W', 'l4d', 'autoshotgun', 'Automation', 'kills with Auto Shotgun'),
('W', 'l4d', 'boomer_claw', 'Boom!', 'kills with Boomer\'s Claws'),
('W', 'l4d', 'dual_pistols', 'Akimbo Assassin', 'kills with Dual Pistols'),
('W', 'l4d', 'hunter_claw', 'Open Season', 'kills with Hunter\'s Claws'),
('W', 'l4d', 'hunting_rifle', 'Hawk Eye', 'kills with Hunting Rifle'),
('W', 'l4d', 'inferno', 'Pyromaniac', 'cremated Infected'),
('W', 'l4d', 'pipe_bomb', 'Pyrotechnician', 'blown up Infected'),
('W', 'l4d', 'pistol', 'Ammo Saver', 'kills with Pistol'),
('W', 'l4d', 'prop_minigun', 'No-One Left Behind', 'kills with Mounted Machine Gun'),
('W', 'l4d', 'pumpshotgun', 'Pump It!', 'kills with Pump Shotgun'),
('W', 'l4d', 'rifle', 'Commando', 'kills with M16 Assault Rifle'),
('W', 'l4d', 'smg', 'Safety First', 'kills with Uzi'),
('W', 'l4d', 'smoker_claw', 'Chain Smoker', 'kills with Smoker\'s Claws'),
('W', 'l4d', 'tank_claw', 'Burger Tank', 'kills with Tank\'s Claws'),
('W', 'l4d', 'tank_rock', 'Rock Star', 'kills with Tank\'s Rock'),
('W', 'l4d', 'latency', 'Lowest Ping', 'ms average connection'),
('W', 'fof', 'deringer', 'Deringer', 'kills with Deringer'),
('W', 'fof', 'carbine', 'Carbine', 'kills with Carbine'),
('W', 'fof', 'coltnavy', 'Colt Navy', 'kills with Colt Navy'),
('W', 'fof', 'bow', 'Bow', 'kills with Bow'),
('W', 'fof', 'arrow', 'Arrow', 'kills with Arrow'),
('W', 'fof', 'sharps', 'Sharps', 'kills with Sharps'),
('W', 'fof', 'coachgun', 'Coach Gun', 'kills with Coach Gun'),
('W', 'fof', 'peacemaker', 'Peacemaker', 'kills with Peacemaker'),
('W', 'fof', 'knife', 'Knife', 'kills with Knife'),
('W', 'fof', 'dualderinger', 'Dual Deringers', 'kills with Dual Deringers'),
('W', 'fof', 'thrown_axe', 'Thrown Axe', 'kills with Thrown Axe'),
('W', 'fof', 'arrow_fiery', 'Fire Arrow', 'kills with Fire Arrow'),
('W', 'fof', 'thrown_knife', 'Thrown Knife', 'kills with Thrown Knife'),
('W', 'fof', 'dualnavy', 'Dual Colt Navys', 'kills with Dual Colt Navys'),
('W', 'fof', 'dynamite', 'Dynamite', 'kills with Dynamite'),
('W', 'fof', 'explosive_arrow', 'Explosive Arrow', 'kills with Explosive Arrows'),
('W', 'fof', 'fists', 'Fists', 'kills with Fists'),
('W', 'fof', 'axe', 'Axe', 'kills with Axe'),
('W', 'fof', 'dualpeacemaker', 'Dual Peacemakers', 'kills with Dual Peacemakers'),
('W', 'fof', 'henryrifle', 'Henry Rifle', 'kills with Henry Rifle'),
('W', 'fof', 'whiskey', 'Whiskey', 'kills with Whiskey'),
('O', 'fof', 'loot_drop', 'Butter Fingers', 'Loot Drops'),
('O', 'fof', 'loot_capture', 'Gimme all yo loot', 'Loot Captures'),
('O', 'fof', 'carrier_protect', 'Grand Protector', 'carrier protections'),
('O', 'fof', 'headshot', 'BOOM HEADSHOT','headshot kills'),
('W', 'fof', 'latency', 'Lowest Ping','ms average connection'),
('W', 'ges', '#GE_ProximityMine', 'Proximity Mines', 'kills with Proximity Mines'),
('W', 'ges', '#GE_AutoShotgun', 'Automatic Shotgun', 'kills with Automatic Shotgun'),
('W', 'ges', '#GE_Phantom', 'Phantom', 'kills with Phantom'),
('W', 'ges', '#GE_Knife', 'Knife', 'kills with Hunting Knife'),
('W', 'ges', '#GE_D5K', 'D5K', 'kills with D5K Deutsche'),
('W', 'ges', '#GE_SilverPP7', 'Silver PP7', 'kills with Silver PP7'),
('W', 'ges', '#GE_DD44', 'DD44', 'kills with DD44'),
('W', 'ges', '#GE_Grenade', 'Grenade', 'kills with Grenades'),
('W', 'ges', '#GE_CougarMagnum', 'Cougar Magnum', 'kills with Cougar Magnum'),
('W', 'ges', '#GE_D5K_SILENCED', 'Silenced D5K', 'kills with D5K (Silenced)'),
('W', 'ges', '#GE_Shotgun', 'Shotgun', 'kills with Shotgun'),
('W', 'ges', '#GE_Klobb', 'Klobb', 'kills with Klobb'),
('W', 'ges', '#GE_RCP90', 'RC-P90', 'kills with RC-P90'),
('W', 'ges', '#GE_RemoteMine', 'Remote Mines', 'kills with Remote Mines'),
('W', 'ges', '#GE_KF7Soviet', 'KF7 Soviet', 'kills with KF7 Soviet'),
('W', 'ges', '#GE_ZMG', 'ZMG', 'kills with ZMG'),
('W', 'ges', '#GE_SniperRifle', 'Sniper Rifle', 'kills with Sniper Rifle'),
('W', 'ges', '#GE_GoldPP7', 'Golden PP7', 'kills with Golden PP7'),
('W', 'ges', '#GE_AR33', 'AR33', 'kills with US AR33 Assault'),
('W', 'ges', '#GE_GoldenGun', 'Golden Gun', 'kills with Golden Gun'),
('W', 'ges', '#GE_ThrowingKnife', 'Thorwing Knives', 'kills with Throwing Knives'),
('W', 'ges', '#GE_PP7', 'PP7', 'kills with PP7'),
('W', 'ges', '#GE_PP7_SILENCED', 'Silenced PP7', 'kills with PP7 (Silenced)'),
('W', 'ges', '#GE_TimedMine', 'Timed Mines', 'kills with Timed Mines'),
('W', 'ges', '#GE_MilitaryLaser', 'Military Laser', 'kills with Military Laser'),
('W', 'ges', '#GE_GrenadeLauncher', 'Grenade Launcher', 'kills with Grenade Launcher'),
('W', 'ges', '#GE_Rocket', 'Rocket Launcher', 'kills with Rocket Launcher'),
('W', 'ges', '#GE_Taser', 'Taser', 'kills with Taser'),
('W', 'ges', '#GE_SniperButt', 'Sniper Butt', 'kills with Sniper Butt'),
('W', 'ges', '#GE_Slapper', 'Slapper', 'kills with Slappers'),
('W', 'ges', '#GE_RocketLauncher', ', Rocket Launcher', 'kills with Rocket Launcher'),
('W', 'ges', 'latency', 'Lowest Ping','ms average connection');


ALTER TABLE `hlstats_Clans`
CHANGE `tag` `tag` varchar(64) NOT NULL default '',
CHANGE `game` `game` varchar(32) NOT NULL default '',
ADD COLUMN `hidden` tinyint(3) unsigned NOT NULL default '0';


CREATE TABLE IF NOT EXISTS `hlstats_Countries` (
  `flag` varchar(16) NOT NULL,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY  (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `hlstats_Countries` (`flag`, `name`) VALUES
('AD', 'Andorra'),
('AE', 'United Arab Emirates'),
('AF', 'Afghanistan'),
('AG', 'Antigua & Barbuda'),
('AI', 'Anguilla'),
('AL', 'Albania'),
('AM', 'Armenia'),
('AN', 'Netherlands Antilles'),
('AO', 'Angola'),
('AQ', 'Antarctica'),
('AR', 'Argentina'),
('AS', 'American Samoa'),
('AT', 'Austria'),
('AU', 'Australia'),
('AW', 'Aruba'),
('AZ', 'Azerbaijan'),
('BA', 'Bosnia and Herzegovina'),
('BB', 'Barbados'),
('BD', 'Bangladesh'),
('BE', 'Belgium'),
('BF', 'Burkina Faso'),
('BG', 'Bulgaria'),
('BH', 'Bahrain'),
('BI', 'Burundi'),
('BJ', 'Benin'),
('BM', 'Bermuda'),
('BN', 'Brunei Darussalam'),
('BO', 'Bolivia'),
('BR', 'Brazil'),
('BS', 'Bahama'),
('BT', 'Bhutan'),
('BU', 'Burma (no longer exists)'),
('BV', 'Bouvet Island'),
('BW', 'Botswana'),
('BY', 'Belarus'),
('BZ', 'Belize'),
('CA', 'Canada'),
('CC', 'Cocos (Keeling) Islands'),
('CF', 'Central African Republic'),
('CG', 'Congo'),
('CH', 'Switzerland'),
('CI', 'Cte D''ivoire (Ivory Coast)'),
('CK', 'Cook Iislands'),
('CL', 'Chile'),
('CM', 'Cameroon'),
('CN', 'China'),
('CO', 'Colombia'),
('CR', 'Costa Rica'),
('CS', 'Czechoslovakia (no longer exists)'),
('CU', 'Cuba'),
('CV', 'Cape Verde'),
('CX', 'Christmas Island'),
('CY', 'Cyprus'),
('CZ', 'Czech Republic'),
('DD', 'German Democratic Republic (no longer exists)'),
('DE', 'Germany'),
('DJ', 'Djibouti'),
('DK', 'Denmark'),
('DM', 'Dominica'),
('DO', 'Dominican Republic'),
('DZ', 'Algeria'),
('EC', 'Ecuador'),
('EE', 'Estonia'),
('EG', 'Egypt'),
('EH', 'Western Sahara'),
('ER', 'Eritrea'),
('ES', 'Spain'),
('ET', 'Ethiopia'),
('FI', 'Finland'),
('FJ', 'Fiji'),
('FK', 'Falkland Islands (Malvinas)'),
('FM', 'Micronesia'),
('FO', 'Faroe Islands'),
('FR', 'France'),
('FX', 'France, Metropolitan'),
('GA', 'Gabon'),
('GB', 'United Kingdom (Great Britain)'),
('GD', 'Grenada'),
('GE', 'Georgia'),
('GF', 'French Guiana'),
('GH', 'Ghana'),
('GI', 'Gibraltar'),
('GL', 'Greenland'),
('GM', 'Gambia'),
('GN', 'Guinea'),
('GP', 'Guadeloupe'),
('GQ', 'Equatorial Guinea'),
('GR', 'Greece'),
('GS', 'South Georgia and the South Sandwich Islands'),
('GT', 'Guatemala'),
('GU', 'Guam'),
('GW', 'Guinea-Bissau'),
('GY', 'Guyana'),
('HK', 'Hong Kong'),
('HM', 'Heard & McDonald Islands'),
('HN', 'Honduras'),
('HR', 'Croatia'),
('HT', 'Haiti'),
('HU', 'Hungary'),
('ID', 'Indonesia'),
('IE', 'Ireland'),
('IL', 'Israel'),
('IN', 'India'),
('IO', 'British Indian Ocean Territory'),
('IQ', 'Iraq'),
('IR', 'Islamic Republic of Iran'),
('IS', 'Iceland'),
('IT', 'Italy'),
('JM', 'Jamaica'),
('JO', 'Jordan'),
('JP', 'Japan'),
('KE', 'Kenya'),
('KG', 'Kyrgyzstan'),
('KH', 'Cambodia'),
('KI', 'Kiribati'),
('KM', 'Comoros'),
('KN', 'St. Kitts and Nevis'),
('KP', 'Korea, Democratic People''s Republic of'),
('KR', 'Korea, Republic of'),
('KW', 'Kuwait'),
('KY', 'Cayman Islands'),
('KZ', 'Kazakhstan'),
('LA', 'Lao People''s Democratic Republic'),
('LB', 'Lebanon'),
('LC', 'Saint Lucia'),
('LI', 'Liechtenstein'),
('LK', 'Sri Lanka'),
('LR', 'Liberia'),
('LS', 'Lesotho'),
('LT', 'Lithuania'),
('LU', 'Luxembourg'),
('LV', 'Latvia'),
('LY', 'Libyan Arab Jamahiriya'),
('MA', 'Morocco'),
('MC', 'Monaco'),
('MD', 'Moldova, Republic of '),
('MG', 'Madagascar'),
('MH', 'Marshall Islands'),
('ML', 'Mali'),
('MM', 'Myanmar'),
('MN', 'Mongolia'),
('MO', 'Macau'),
('MP', 'Northern Mariana Islands'),
('MQ', 'Martinique'),
('MR', 'Mauritania'),
('MS', 'Monserrat'),
('MT', 'Malta'),
('MU', 'Mauritius'),
('MV', 'Maldives'),
('MW', 'Malawi'),
('MX', 'Mexico'),
('MY', 'Malaysia'),
('MZ', 'Mozambique'),
('NA', 'Namibia'),
('NC', 'New Caledonia'),
('NE', 'Niger'),
('NF', 'Norfolk Island'),
('NG', 'Nigeria'),
('NI', 'Nicaragua'),
('NL', 'Netherlands'),
('NO', 'Norway'),
('NP', 'Nepal'),
('NR', 'Nauru'),
('NT', 'Neutral Zone (no longer exists)'),
('NU', 'Niue'),
('NZ', 'New Zealand'),
('OM', 'Oman'),
('PA', 'Panama'),
('PE', 'Peru'),
('PF', 'French Polynesia'),
('PG', 'Papua New Guinea'),
('PH', 'Philippines'),
('PK', 'Pakistan'),
('PL', 'Poland'),
('PM', 'St. Pierre & Miquelon'),
('PN', 'Pitcairn'),
('PR', 'Puerto Rico'),
('PT', 'Portugal'),
('PW', 'Palau'),
('PY', 'Paraguay'),
('QA', 'Qatar'),
('RE', 'Runion'),
('RO', 'Romania'),
('RU', 'Russian Federation'),
('RW', 'Rwanda'),
('SA', 'Saudi Arabia'),
('SB', 'Solomon Islands'),
('SC', 'Seychelles'),
('SD', 'Sudan'),
('SE', 'Sweden'),
('SG', 'Singapore'),
('SH', 'St. Helena'),
('SI', 'Slovenia'),
('SJ', 'Svalbard & Jan Mayen Islands'),
('SK', 'Slovakia'),
('SL', 'Sierra Leone'),
('SM', 'San Marino'),
('SN', 'Senegal'),
('SO', 'Somalia'),
('SR', 'Suriname'),
('ST', 'Sao Tome & Principe'),
('SU', 'Union of Soviet Socialist Republics (no longer exi'),
('SV', 'El Salvador'),
('SY', 'Syrian Arab Republic'),
('SZ', 'Swaziland'),
('TC', 'Turks & Caicos Islands'),
('TD', 'Chad'),
('TF', 'French Southern Territories'),
('TG', 'Togo'),
('TH', 'Thailand'),
('TJ', 'Tajikistan'),
('TK', 'Tokelau'),
('TM', 'Turkmenistan'),
('TN', 'Tunisia'),
('TO', 'Tonga'),
('TP', 'East Timor'),
('TR', 'Turkey'),
('TT', 'Trinidad & Tobago'),
('TV', 'Tuvalu'),
('TW', 'Taiwan, Province of China'),
('TZ', 'Tanzania, United Republic of'),
('UA', 'Ukraine'),
('UG', 'Uganda'),
('UM', 'United States Minor Outlying Islands'),
('US', 'United States of America'),
('UY', 'Uruguay'),
('UZ', 'Uzbekistan'),
('VA', 'Vatican City State (Holy See)'),
('VC', 'St. Vincent & the Grenadines'),
('VE', 'Venezuela'),
('VG', 'British Virgin Islands'),
('VI', 'United States Virgin Islands'),
('VN', 'Viet Nam'),
('VU', 'Vanuatu'),
('WF', 'Wallis & Futuna Islands'),
('WS', 'Samoa'),
('YD', 'Democratic Yemen (no longer exists)'),
('YE', 'Yemen'),
('YT', 'Mayotte'),
('YU', 'Yugoslavia'),
('ZA', 'South Africa'),
('ZM', 'Zambia'),
('ZR', 'Zaire'),
('ZW', 'Zimbabwe'),
('ZZ', 'Unknown or unspecified country');


ALTER TABLE `hlstats_Events_Admin`
CHANGE `type` `type` varchar(64) NOT NULL default 'Unknown',
CHANGE `playerName` `playerName` varchar(64) NOT NULL default '';


ALTER TABLE `hlstats_Events_ChangeName`
ADD KEY `playerId` (`playerId`);


ALTER TABLE `hlstats_Events_ChangeRole`
CHANGE `role` `role` varchar(64) NOT NULL default '',
ADD KEY `playerId` (`playerId`);


ALTER TABLE `hlstats_Events_ChangeTeam`
CHANGE `team` `team` varchar(64) NOT NULL default '',
ADD KEY `playerId` (`playerId`);


ALTER TABLE `hlstats_Events_Chat`
CHANGE `playerId` `playerId` int(10) unsigned NOT NULL default '0',
ADD COLUMN `message_mode` tinyint(1) NOT NULL default '0',
DROP `type`,
CHANGE `message` `message` varchar(128) NOT NULL default '';



ALTER TABLE `hlstats_Events_Connects`
CHANGE `ipAddress` `ipAddress` varchar(32) NOT NULL default '',
ADD COLUMN `eventTime_Disconnect` datetime default NULL,
ADD KEY `playerId` (`playerId`);


ALTER TABLE `hlstats_Events_Frags`
ADD COLUMN `headshot` tinyint(1) NOT NULL default '0',
ADD COLUMN `killerRole` varchar(64) NOT NULL default '',
ADD COLUMN `victimRole` varchar(64) NOT NULL default '',
ADD COLUMN `pos_x` varchar(10) default NULL,
ADD COLUMN `pos_y` varchar(10) default NULL,
ADD COLUMN `pos_z` varchar(10) default NULL,
ADD KEY `killerId` (`killerId`),
ADD KEY `victimId` (`victimId`),
ADD KEY `serverId` (`serverId`),
ADD KEY `headshot` (`headshot`),
ADD KEY `map` (`map`(5));


CREATE TABLE IF NOT EXISTS `hlstats_Events_Latency` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `eventTime` datetime NOT NULL default '0000-00-00 00:00:00',
  `serverId` int(10) unsigned NOT NULL default '0',
  `map` varchar(64) NOT NULL default '',
  `playerId` int(10) unsigned NOT NULL default '0',
  `ping` int(32) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `playerId` (`playerId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;



ALTER TABLE `hlstats_Events_PlayerActions`
ADD COLUMN `pos_x` varchar(10) default NULL,
ADD COLUMN `pos_y` varchar(10) default NULL,
ADD COLUMN `pos_z` varchar(10) default NULL,
ADD KEY `playerId` (`playerId`),
ADD KEY `actionId` (`actionId`);



ALTER TABLE `hlstats_Events_PlayerPlayerActions`
ADD COLUMN `pos_x` varchar(10) default NULL,
ADD COLUMN `pos_y` varchar(10) default NULL,
ADD COLUMN `pos_z` varchar(10) default NULL,
ADD KEY `playerId` (`playerId`);


ALTER TABLE `hlstats_Events_Statsme`
ADD KEY `weapon` (`weapon`);


ALTER TABLE `hlstats_Events_Statsme2`
ADD KEY `weapon` (`weapon`);


ALTER TABLE `hlstats_Events_Suicides`
ADD COLUMN `pos_x` varchar(10) default NULL,
ADD COLUMN `pos_y` varchar(10) default NULL,
ADD COLUMN `pos_z` varchar(10) default NULL,
ADD KEY `playerId` (`playerId`);


ALTER TABLE `hlstats_Events_TeamBonuses`
ADD KEY `playerId` (`playerId`),
ADD KEY `actionId` (`actionId`);


ALTER TABLE `hlstats_Events_Teamkills`
ADD COLUMN `pos_x` varchar(10) default NULL,
ADD COLUMN `pos_y` varchar(10) default NULL,
ADD COLUMN `pos_z` varchar(10) default NULL,
ADD KEY `killerId` (`killerId`);

ALTER TABLE `hlstats_Games`
DROP `source`,
ADD COLUMN `realgame` varchar(32) NOT NULL default 'hl2mp';

UPDATE `hlstats_Games` SET `realgame` = 'css' WHERE `code` LIKE 'css%';
UPDATE `hlstats_Games` SET `realgame` = 'hl2mp' WHERE `code` LIKE 'hl2mp%';
UPDATE `hlstats_Games` SET `realgame` = 'tf' WHERE `code` LIKE 'tf%';
UPDATE `hlstats_Games` SET `realgame` = 'hl2mp' WHERE `code` LIKE 'hl2ctf%';
UPDATE `hlstats_Games` SET `realgame` = 'dods' WHERE `code` LIKE 'dods%';
UPDATE `hlstats_Games` SET `realgame` = 'insmod' WHERE `code` LIKE 'ins%';
UPDATE `hlstats_Games` SET `realgame` = 'ff' WHERE `code` LIKE 'ff%';
UPDATE `hlstats_Games` SET `realgame` = 'hidden' WHERE `code` LIKE 'hidden%';
UPDATE `hlstats_Games` SET `realgame` = 'zps' WHERE `code` LIKE 'zps%';
UPDATE `hlstats_Games` SET `realgame` = 'aoc' WHERE `code` LIKE 'aoc%';

INSERT IGNORE INTO `hlstats_Games` (`code`, `name`, `realgame`, `hidden`) VALUES
('css','Counter-Strike: Source','css','1'),
('hl2mp','Half-Life 2 Multiplayer','hl2mp','1'),
('tf','Team Fortress 2','tf','0'),
('hl2ctf','Half-Life 2 Capture the flag','hl2mp','1'),
('dods','Day of Defeat: Source','dods','1'),
('insmod','Insurgency: Modern Infantry Combat','insmod','1'),
('ff', 'Fortress Forever','ff','1'),
('hidden','The Hidden: Source','hidden','1'),
('zps','Zombie Panic! Source','zps','1'),
('aoc','Age of Chivalry','aoc','1'),
('cstrike','Counter-Strike','cstrike','1'),
('tfc','Team Fortress Classic','tfc','1'),
('dod','Day of Defeat','dod','1'),
('ns','Natural Selection','ns','1'),
('l4d', 'Left 4 Dead', 'l4d', '1'),
('fof', 'Fistful of Frags', 'fof', '1'),
('ges', 'GoldenEye: Source', 'ges', '1');


CREATE TABLE IF NOT EXISTS `hlstats_Games_Defaults` (
  `code` varchar(32) NOT NULL,
  `parameter` varchar(50) NOT NULL,
  `value` varchar(128) NOT NULL,
  PRIMARY KEY  (`code`,`parameter`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


INSERT INTO `hlstats_Games_Defaults` (`code`, `parameter`, `value`) VALUES
('aoc', 'DisplayResultsInBrowser', '1'),
('css', 'DisplayResultsInBrowser', '1'),
('cstrike', 'DisplayResultsInBrowser', '1'),
('dod', 'DisplayResultsInBrowser', '1'),
('dods', 'DisplayResultsInBrowser', '1'),
('ff', 'DisplayResultsInBrowser', '1'),
('hidden', 'DisplayResultsInBrowser', '1'),
('hl2mp', 'DisplayResultsInBrowser', '1'),
('insmod', 'DisplayResultsInBrowser', '1'),
('ns', 'DisplayResultsInBrowser', '0'),
('tf', 'DisplayResultsInBrowser', '1'),
('tfc', 'DisplayResultsInBrowser', '0'),
('zps', 'DisplayResultsInBrowser', '1'),
('aoc', 'GameEngine', '3'),
('css', 'GameEngine', '2'),
('cstrike', 'GameEngine', '1'),
('dod', 'GameEngine', '2'),
('dods', 'GameEngine', '3'),
('ff', 'GameEngine', '2'),
('hidden', 'GameEngine', '2'),
('hl2mp', 'GameEngine', '2'),
('insmod', 'GameEngine', '2'),
('ns', 'GameEngine', '1'),
('tf', 'GameEngine', '3'),
('tfc', 'GameEngine', '1'),
('zps', 'GameEngine', '3'),
('aoc', 'AddressPort', '0.0.0.0:27015'),
('css', 'AddressPort', '0.0.0.0:27015'),
('cstrike', 'AddressPort', '0.0.0.0:27015'),
('dod', 'AddressPort', '0.0.0.0:27015'),
('dods', 'AddressPort', '0.0.0.0:27015'),
('ff', 'AddressPort', '0.0.0.0:27015'),
('hidden', 'AddressPort', '0.0.0.0:27015'),
('hl2mp', 'AddressPort', '0.0.0.0:27015'),
('insmod', 'AddressPort', '0.0.0.0:27015'),
('ns', 'AddressPort', '0.0.0.0:27015'),
('tf', 'AddressPort', '0.0.0.0:27015'),
('tfc', 'AddressPort', '0.0.0.0:27015'),
('zps', 'AddressPort', '0.0.0.0:27015'),
('aoc', 'Admins', ''),
('css', 'Admins', ''),
('cstrike', 'Admins', ''),
('dod', 'Admins', ''),
('dods', 'Admins', ''),
('ff', 'Admins', ''),
('hidden', 'Admins', ''),
('hl2mp', 'Admins', ''),
('insmod', 'Admins', ''),
('ns', 'Admins', ''),
('tf', 'Admins', ''),
('tfc', 'Admins', ''),
('zps', 'Admins', ''),
('aoc', 'AutoBanRetry', '0'),
('css', 'AutoBanRetry', '0'),
('cstrike', 'AutoBanRetry', '0'),
('dod', 'AutoBanRetry', '0'),
('dods', 'AutoBanRetry', '0'),
('ff', 'AutoBanRetry', '0'),
('hidden', 'AutoBanRetry', '0'),
('hl2mp', 'AutoBanRetry', '0'),
('insmod', 'AutoBanRetry', '0'),
('ns', 'AutoBanRetry', '0'),
('tf', 'AutoBanRetry', '0'),
('tfc', 'AutoBanRetry', '0'),
('zps', 'AutoBanRetry', '0'),
('aoc', 'AutoTeamBalance', '0'),
('css', 'AutoTeamBalance', '0'),
('cstrike', 'AutoTeamBalance', '0'),
('dod', 'AutoTeamBalance', '0'),
('dods', 'AutoTeamBalance', '0'),
('ff', 'AutoTeamBalance', '0'),
('hidden', 'AutoTeamBalance', '0'),
('hl2mp', 'AutoTeamBalance', '0'),
('insmod', 'AutoTeamBalance', '0'),
('ns', 'AutoTeamBalance', '0'),
('tf', 'AutoTeamBalance', '0'),
('tfc', 'AutoTeamBalance', '0'),
('zps', 'AutoTeamBalance', '0'),
('aoc', 'BonusRoundIgnore', '0'),
('css', 'BonusRoundIgnore', '0'),
('cstrike', 'BonusRoundIgnore', '0'),
('dod', 'BonusRoundIgnore', '0'),
('dods', 'BonusRoundIgnore', '0'),
('ff', 'BonusRoundIgnore', '0'),
('hidden', 'BonusRoundIgnore', '0'),
('hl2mp', 'BonusRoundIgnore', '0'),
('insmod', 'BonusRoundIgnore', '0'),
('ns', 'BonusRoundIgnore', '0'),
('tf', 'BonusRoundIgnore', '0'),
('tfc', 'BonusRoundIgnore', '0'),
('zps', 'BonusRoundIgnore', '0'),
('aoc', 'BonusRoundTime', '0'),
('css', 'BonusRoundTime', '0'),
('cstrike', 'BonusRoundTime', '0'),
('dod', 'BonusRoundTime', '0'),
('dods', 'BonusRoundTime', '0'),
('ff', 'BonusRoundTime', '0'),
('hidden', 'BonusRoundTime', '0'),
('hl2mp', 'BonusRoundTime', '0'),
('insmod', 'BonusRoundTime', '0'),
('ns', 'BonusRoundTime', '0'),
('tf', 'BonusRoundTime', '0'),
('tfc', 'BonusRoundTime', '0'),
('zps', 'BonusRoundTime', '0'),
('aoc', 'BroadCastEvents', '1'),
('css', 'BroadCastEvents', '1'),
('cstrike', 'BroadCastEvents', '1'),
('dod', 'BroadCastEvents', '1'),
('dods', 'BroadCastEvents', '1'),
('ff', 'BroadCastEvents', '1'),
('hidden', 'BroadCastEvents', '1'),
('hl2mp', 'BroadCastEvents', '1'),
('insmod', 'BroadCastEvents', '1'),
('ns', 'BroadCastEvents', '1'),
('tf', 'BroadCastEvents', '1'),
('tfc', 'BroadCastEvents', '1'),
('zps', 'BroadCastEvents', '1'),
('aoc', 'BroadCastPlayerActions', '1'),
('css', 'BroadCastPlayerActions', '1'),
('cstrike', 'BroadCastPlayerActions', '1'),
('dod', 'BroadCastPlayerActions', '1'),
('dods', 'BroadCastPlayerActions', '1'),
('ff', 'BroadCastPlayerActions', '1'),
('hidden', 'BroadCastPlayerActions', '1'),
('hl2mp', 'BroadCastPlayerActions', '1'),
('insmod', 'BroadCastPlayerActions', '1'),
('ns', 'BroadCastPlayerActions', '1'),
('tf', 'BroadCastPlayerActions', '1'),
('tfc', 'BroadCastPlayerActions', '1'),
('zps', 'BroadCastPlayerActions', '1'),
('aoc', 'EnablePublicCommands', '1'),
('css', 'EnablePublicCommands', '1'),
('cstrike', 'EnablePublicCommands', '1'),
('dod', 'EnablePublicCommands', '1'),
('dods', 'EnablePublicCommands', '1'),
('ff', 'EnablePublicCommands', '1'),
('hidden', 'EnablePublicCommands', '1'),
('hl2mp', 'EnablePublicCommands', '1'),
('insmod', 'EnablePublicCommands', '1'),
('ns', 'EnablePublicCommands', '1'),
('tf', 'EnablePublicCommands', '1'),
('tfc', 'EnablePublicCommands', '1'),
('zps', 'EnablePublicCommands', '1'),
('aoc', 'GameType', '0'),
('css', 'GameType', '0'),
('cstrike', 'GameType', '0'),
('dod', 'GameType', '0'),
('dods', 'GameType', '0'),
('ff', 'GameType', '0'),
('hidden', 'GameType', '0'),
('hl2mp', 'GameType', '0'),
('insmod', 'GameType', '0'),
('ns', 'GameType', '0'),
('tf', 'GameType', '0'),
('tfc', 'GameType', '0'),
('zps', 'GameType', '0'),
('aoc', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('css', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('cstrike', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('dod', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('dods', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('ff', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('hidden', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('hl2mp', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('insmod', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('ns', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('tf', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('tfc', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('zps', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('aoc', 'IgnoreBots', '1'),
('css', 'IgnoreBots', '1'),
('cstrike', 'IgnoreBots', '1'),
('dod', 'IgnoreBots', '1'),
('dods', 'IgnoreBots', '1'),
('ff', 'IgnoreBots', '1'),
('hidden', 'IgnoreBots', '1'),
('hl2mp', 'IgnoreBots', '1'),
('insmod', 'IgnoreBots', '1'),
('ns', 'IgnoreBots', '1'),
('tf', 'IgnoreBots', '1'),
('tfc', 'IgnoreBots', '1'),
('zps', 'IgnoreBots', '1'),
('aoc', 'MinimumPlayersRank', '0'),
('css', 'MinimumPlayersRank', '0'),
('cstrike', 'MinimumPlayersRank', '0'),
('dod', 'MinimumPlayersRank', '0'),
('dods', 'MinimumPlayersRank', '0'),
('ff', 'MinimumPlayersRank', '0'),
('hidden', 'MinimumPlayersRank', '0'),
('hl2mp', 'MinimumPlayersRank', '0'),
('insmod', 'MinimumPlayersRank', '0'),
('ns', 'MinimumPlayersRank', '0'),
('tf', 'MinimumPlayersRank', '0'),
('tfc', 'MinimumPlayersRank', '0'),
('zps', 'MinimumPlayersRank', '0'),
('aoc', 'MinPlayers', '4'),
('css', 'MinPlayers', '4'),
('cstrike', 'MinPlayers', '4'),
('dod', 'MinPlayers', '4'),
('dods', 'MinPlayers', '4'),
('ff', 'MinPlayers', '4'),
('hidden', 'MinPlayers', '4'),
('hl2mp', 'MinPlayers', '4'),
('insmod', 'MinPlayers', '4'),
('ns', 'MinPlayers', '4'),
('tf', 'MinPlayers', '4'),
('tfc', 'MinPlayers', '4'),
('zps', 'MinPlayers', '4'),
('aoc', 'PlayerEvents', '1'),
('css', 'PlayerEvents', '1'),
('cstrike', 'PlayerEvents', '1'),
('dod', 'PlayerEvents', '1'),
('dods', 'PlayerEvents', '1'),
('ff', 'PlayerEvents', '1'),
('hidden', 'PlayerEvents', '1'),
('hl2mp', 'PlayerEvents', '1'),
('insmod', 'PlayerEvents', '1'),
('ns', 'PlayerEvents', '1'),
('tf', 'PlayerEvents', '1'),
('tfc', 'PlayerEvents', '1'),
('zps', 'PlayerEvents', '1'),
('aoc', 'ShowStats', '1'),
('css', 'ShowStats', '1'),
('cstrike', 'ShowStats', '1'),
('dod', 'ShowStats', '1'),
('dods', 'ShowStats', '1'),
('ff', 'ShowStats', '1'),
('hidden', 'ShowStats', '1'),
('hl2mp', 'ShowStats', '1'),
('insmod', 'ShowStats', '1'),
('ns', 'ShowStats', '1'),
('tf', 'ShowStats', '1'),
('tfc', 'ShowStats', '1'),
('zps', 'ShowStats', '1'),
('aoc', 'SkillMode', '0'),
('css', 'SkillMode', '0'),
('cstrike', 'SkillMode', '0'),
('dod', 'SkillMode', '0'),
('dods', 'SkillMode', '0'),
('ff', 'SkillMode', '0'),
('hidden', 'SkillMode', '0'),
('hl2mp', 'SkillMode', '0'),
('insmod', 'SkillMode', '0'),
('ns', 'SkillMode', '0'),
('tf', 'SkillMode', '0'),
('tfc', 'SkillMode', '0'),
('zps', 'SkillMode', '0'),
('aoc', 'SuicidePenalty', '5'),
('css', 'SuicidePenalty', '5'),
('cstrike', 'SuicidePenalty', '5'),
('dod', 'SuicidePenalty', '5'),
('dods', 'SuicidePenalty', '5'),
('ff', 'SuicidePenalty', '5'),
('hidden', 'SuicidePenalty', '5'),
('hl2mp', 'SuicidePenalty', '5'),
('insmod', 'SuicidePenalty', '5'),
('ns', 'SuicidePenalty', '5'),
('tf', 'SuicidePenalty', '5'),
('tfc', 'SuicidePenalty', '5'),
('zps', 'SuicidePenalty', '5'),
('aoc', 'SwitchAdmins', '0'),
('css', 'SwitchAdmins', '0'),
('cstrike', 'SwitchAdmins', '0'),
('dod', 'SwitchAdmins', '0'),
('dods', 'SwitchAdmins', '0'),
('ff', 'SwitchAdmins', '0'),
('hidden', 'SwitchAdmins', '0'),
('hl2mp', 'SwitchAdmins', '0'),
('insmod', 'SwitchAdmins', '0'),
('ns', 'SwitchAdmins', '0'),
('tf', 'SwitchAdmins', '0'),
('tfc', 'SwitchAdmins', '0'),
('zps', 'SwitchAdmins', '0'),
('aoc', 'TKPenalty', '25'),
('css', 'TKPenalty', '25'),
('cstrike', 'TKPenalty', '25'),
('dod', 'TKPenalty', '25'),
('dods', 'TKPenalty', '25'),
('ff', 'TKPenalty', '25'),
('hidden', 'TKPenalty', '25'),
('hl2mp', 'TKPenalty', '25'),
('insmod', 'TKPenalty', '25'),
('ns', 'TKPenalty', '25'),
('tf', 'TKPenalty', '25'),
('tfc', 'TKPenalty', '25'),
('zps', 'TKPenalty', '25'),
('aoc', 'TrackServerLoad', '1'),
('css', 'TrackServerLoad', '1'),
('cstrike', 'TrackServerLoad', '1'),
('dod', 'TrackServerLoad', '1'),
('dods', 'TrackServerLoad', '1'),
('ff', 'TrackServerLoad', '1'),
('hidden', 'TrackServerLoad', '1'),
('hl2mp', 'TrackServerLoad', '1'),
('insmod', 'TrackServerLoad', '1'),
('ns', 'TrackServerLoad', '1'),
('tf', 'TrackServerLoad', '1'),
('tfc', 'TrackServerLoad', '1'),
('zps', 'TrackServerLoad', '1'),
('l4d', 'DisplayResultsInBrowser', '1'),
('l4d', 'GameEngine', '3'),
('l4d', 'AddressPort', '0.0.0.0:27015'),
('l4d', 'Admins', ''),
('l4d', 'AutoBanRetry', '0'),
('l4d', 'AutoTeamBalance', '0'),
('l4d', 'BonusRoundIgnore', '0'),
('l4d', 'BonusRoundTime', '0'),
('l4d', 'BroadCastEvents', '0'),
('l4d', 'BroadCastPlayerActions', '0'),
('l4d', 'EnablePublicCommands', '0'),
('l4d', 'GameType', '0'),
('l4d', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('l4d', 'IgnoreBots', '0'),
('l4d', 'MinimumPlayersRank', '0'),
('l4d', 'MinPlayers', '1'),
('l4d', 'PlayerEvents', '1'),
('l4d', 'ShowStats', '1'),
('l4d', 'SkillMode', '0'),
('l4d', 'SuicidePenalty', '5'),
('l4d', 'SwitchAdmins', '0'),
('l4d', 'TKPenalty', '25'),
('l4d', 'TrackServerLoad', '1'),
('fof', 'DisplayResultsInBrowser', '1'),
('fof', 'GameEngine', '3'),
('fof', 'AddressPort', '0.0.0.0:27015'),
('fof', 'Admins', ''),
('fof', 'AutoBanRetry', '0'),
('fof', 'AutoTeamBalance', '0'),
('fof', 'BonusRoundIgnore', '0'),
('fof', 'BonusRoundTime', '0'),
('fof', 'BroadCastEvents', '1'),
('fof', 'BroadCastPlayerActions', '1'),
('fof', 'EnablePublicCommands', '1'),
('fof', 'GameType', '0'),
('fof', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('fof', 'IgnoreBots', '1'),
('fof', 'MinimumPlayersRank', '0'),
('fof', 'MinPlayers', '4'),
('fof', 'PlayerEvents', '1'),
('fof', 'ShowStats', '1'),
('fof', 'SkillMode', '0'),
('fof', 'SuicidePenalty', '5'),
('fof', 'SwitchAdmins', '0'),
('fof', 'TKPenalty', '25'),
('fof', 'TrackServerLoad', '1'),
('ges', 'DisplayResultsInBrowser', '1'),
('ges', 'GameEngine', '3'),
('ges', 'AddressPort', '0.0.0.0:27015'),
('ges', 'Admins', ''),
('ges', 'AutoBanRetry', '0'),
('ges', 'AutoTeamBalance', '0'),
('ges', 'BonusRoundIgnore', '0'),
('ges', 'BonusRoundTime', '0'),
('ges', 'BroadCastEvents', '1'),
('ges', 'BroadCastPlayerActions', '1'),
('ges', 'EnablePublicCommands', '1'),
('ges', 'GameType', '0'),
('ges', 'HLStatsURL', 'http://yoursite.com/hlstats'),
('ges', 'IgnoreBots', '1'),
('ges', 'MinimumPlayersRank', '0'),
('ges', 'MinPlayers', '4'),
('ges', 'PlayerEvents', '1'),
('ges', 'ShowStats', '1'),
('ges', 'SkillMode', '0'),
('ges', 'SuicidePenalty', '5'),
('ges', 'SwitchAdmins', '0'),
('ges', 'TKPenalty', '25'),
('ges', 'TrackServerLoad', '1');


CREATE TABLE IF NOT EXISTS `hlstats_Games_Supported` (
  `code` varchar(32) NOT NULL,
  `name` varchar(128) NOT NULL,
  PRIMARY KEY  (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Games_Supported`
--

INSERT INTO `hlstats_Games_Supported` (`code`, `name`) VALUES
('css', 'Counter-Strike: Source'),
('hl2mp', 'Half-Life 2 Multiplayer'),
('tf', 'Team Fortress 2'),
('dods', 'Day of Defeat: Source'),
('insmod', 'Insurgency'),
('ff', 'Fortress Forever'),
('hidden', 'Hidden: Source'),
('zps', 'Zombie Panic: Source'),
('aoc', 'Age of Chivalry'),
('cstrike', 'Counter-Strike 1.6'),
('tfc', 'Team Fortress Classic'),
('dod', 'Day of Defeat'),
('ns', 'Natural Selection'),
('l4d', 'Left 4 Dead'),
('fof', 'Fistful of Frags'),
('ges', 'GoldenEye: Source');
--
-- Table structure for table `hlstats_HostGroups`
--

CREATE TABLE IF NOT EXISTS `hlstats_HostGroups` (
  `id` int(11) NOT NULL auto_increment,
  `pattern` varchar(255) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Livestats`
--

CREATE TABLE IF NOT EXISTS `hlstats_Livestats` (
  `player_id` int(10) NOT NULL default '0',
  `server_id` int(4) NOT NULL default '0',
  `cli_address` varchar(32) NOT NULL default '',
  `cli_city` varchar(255) NOT NULL default '',
  `cli_country` varchar(128) NOT NULL default '',
  `cli_flag` varchar(16) NOT NULL default '',
  `cli_state` varchar(255) NOT NULL default '',
  `cli_lat` varchar(32) NOT NULL default '',
  `cli_lng` varchar(32) NOT NULL default '',
  `steam_id` varchar(255) NOT NULL default '',
  `name` varchar(128) NOT NULL,
  `team` varchar(64) NOT NULL default '',
  `kills` int(6) NOT NULL default '0',
  `deaths` int(6) NOT NULL default '0',
  `suicides` int(6) NOT NULL default '0',
  `headshots` int(6) NOT NULL default '0',
  `shots` int(11) NOT NULL default '0',
  `hits` int(11) NOT NULL default '0',
  `is_dead` tinyint(1) NOT NULL default '0',
  `has_bomb` int(1) NOT NULL default '0',
  `ping` int(6) NOT NULL default '0',
  `connected` int(10) NOT NULL default '0',
  `skill_change` int(10) NOT NULL default '0',
  `skill` int(10) NOT NULL default '0',
  PRIMARY KEY  (`player_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `hlstats_Mods_Defaults` (
  `code` varchar(32) NOT NULL,
  `parameter` varchar(50) NOT NULL,
  `value` varchar(128) NOT NULL,
  PRIMARY KEY  (`code`,`parameter`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Mods_Defaults`
--

INSERT INTO `hlstats_Mods_Defaults` (`code`, `parameter`, `value`) VALUES
('', 'BroadCastEventsCommand', ''),
('AMXX', 'BroadCastEventsCommand', 'hlx_amx_psay'),
('BEETLE', 'BroadCastEventsCommand', 'hlx_psay'),
('MANI', 'BroadCastEventsCommand', 'ma_hlx_psay'),
('MINISTATS', 'BroadCastEventsCommand', 'ms_psay'),
('SOURCEMOD', 'BroadCastEventsCommand', 'hlx_sm_psay'),
('', 'BroadCastEventsCommandAnnounce', 'say'),
('AMXX', 'BroadCastEventsCommandAnnounce', 'hlx_amx_csay'),
('BEETLE', 'BroadCastEventsCommandAnnounce', 'hlx_csay'),
('MANI', 'BroadCastEventsCommandAnnounce', 'ma_hlx_csay'),
('MINISTATS', 'BroadCastEventsCommandAnnounce', 'ms_csay'),
('SOURCEMOD', 'BroadCastEventsCommandAnnounce', 'hlx_sm_csay'),
('', 'PlayerEventsAdminCommand', ''),
('AMXX', 'PlayerEventsAdminCommand', ''),
('BEETLE', 'PlayerEventsAdminCommand', ''),
('MANI', 'PlayerEventsAdminCommand', ''),
('MINISTATS', 'PlayerEventsAdminCommand', ''),
('SOURCEMOD', 'PlayerEventsAdminCommand', ''),
('', 'PlayerEventsCommand', ''),
('AMXX', 'PlayerEventsCommand', 'hlx_amx_psay'),
('BEETLE', 'PlayerEventsCommand', 'hlx_psay'),
('MANI', 'PlayerEventsCommand', 'ma_hlx_psay'),
('MINISTATS', 'PlayerEventsCommand', 'ms_psay'),
('SOURCEMOD', 'PlayerEventsCommand', 'hlx_sm_psay'),
('', 'PlayerEventsCommandOSD', ''),
('AMXX', 'PlayerEventsCommandOSD', 'hlx_amx_msay'),
('BEETLE', 'PlayerEventsCommandOSD', 'hlx_msay'),
('MANI', 'PlayerEventsCommandOSD', 'ma_hlx_msay'),
('MINISTATS', 'PlayerEventsCommandOSD', 'ms_msay'),
('SOURCEMOD', 'PlayerEventsCommandOSD', 'hlx_sm_msay');


CREATE TABLE IF NOT EXISTS `hlstats_Mods_Supported` (
  `code` varchar(32) NOT NULL,
  `name` varchar(128) NOT NULL,
  PRIMARY KEY  (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Mods_Supported`
--

INSERT INTO `hlstats_Mods_Supported` (`code`, `name`) VALUES
('', '(none)'),
('SOURCEMOD', 'Sourcemod'),
('MANI', 'Mani Admin Mod >= 1.2'),
('BEETLE', 'BeetlesMod'),
('MINISTATS', 'MiniStats'),
('AMXX', 'AMX Mod X');
-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Options`
--

ALTER TABLE `hlstats_Options`
ADD COLUMN `opttype` TINYINT NOT NULL DEFAULT '1',
ADD KEY ( `opttype` );

UPDATE `hlstats_Options` SET `opttype` = 2;
UPDATE `hlstats_Options` SET `value` = 'skill' WHERE `keyname` = 'rankingtype' AND `value`=1;
UPDATE `hlstats_Options` SET `value` = 'kills' WHERE `keyname` = 'rankingtype' AND `value`=2;
UPDATE `hlstats_Options` SET `opttype` = 1 WHERE `keyname` IN ('Mode','rankingtype','DeleteDays','MinActivity');

INSERT IGNORE INTO `hlstats_Options` (`keyname`, `value`, `opttype`) VALUES
('DNSResolveIP', '1',0),
('DNSTimeout', '3',0),
('Rcon', '1',0),
('RconIgnoreSelf', '1',0),
('RconRecord', '0',0),
('MailTo', '',0),
('MailPath', '/usr/sbin/sendmail',0),
('Mode', 'Normal',1),
('SkillMaxChange', '25',0),
('SkillMinChange', '2',0),
('PlayerMinKills', '50',0),
('DeleteDays', '28',1),
('UseTimestamp', '0',0),
('MinActivity', '28',1),
('AllowOnlyConfigServers', '1',0),
('TrackStatsTrend', '1',0),
('GlobalBanning', '0',0),
('LogChat', '1',0),
('LogChatAdmins', '0',0),
('GlobalChat', '0',0),
('SkillRatioCap', '0',0),
('UseGeoIPBinary', '0',0),
('contact', 'your@email.address',2),
('sitename', 'HLstatsX',2),
('siteurl', 'http://your.stats.url.here',2),
('style', 'psychonic.css',2),
('imgpath', 'hlstatsimg',2),
('map_dlurl', 'http://your.server.here/fastdownload/%GAME%/%MAP%.bsp.bz2',2),
('awards_d_date', '2008-08-30',2),
('awards_numdays', '1',2),
('graphbg_trend', '000000',2),
('graphbg_load', '000000',2),
('graphtxt_trend', '0066CC',2),
('graphtxt_load', '0066CC',2),
('rankingtype', 'skill',1),
('bannerfile', 'hlxbanner3.png',2),
('bannerdisplay', '0',2),
('awarddailycols', '4',2),
('awardglobalcols', '5',2),
('awardrankscols', '5',2),
('awardribbonscols', '5',2),
('sigbackground', 'random',2),
('trendgraphfile', 'trendgraph1.png',2),
('playerinfo_tabs', '1',2),
('counter_hits', '0',2),
('counter_visits', '0',2),
('counter_visit_timeout', '5',2),
('nav_globalchat', '1',2),
('nav_cheaters', '0',2),
('show_weapon_target_flash', '1',2),
('show_server_load_image', '1',2),
('countrydata', '1',2),
('gamehome_show_awards', '0',2),
('show_google_map', '1',2),
('google_map_key', '',2),
('google_map_region', 'NORTH AMERICA',2),
('google_map_type', 'HYBRID',2),
('slider', '1',2),
('modrewrite','0',2);


CREATE TABLE IF NOT EXISTS `hlstats_Options_Choices` (
  `keyname` varchar(32) NOT NULL,
  `value` varchar(128) NOT NULL,
  `text` varchar(128) NOT NULL default '',
  `isDefault` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`keyname`,`value`),
  KEY `keyname` (`keyname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


INSERT IGNORE INTO `hlstats_Options_Choices` (`keyname`, `value`, `text`, `isDefault`) VALUES
('rankingtype', 'skill', 'Skill', 1),
('rankingtype', 'kills', 'Kills', 0),
('bannerdisplay', '0', 'None', 1),
('bannerdisplay', '1', 'All Pages', 0),
('bannerdisplay', '2', 'Contents Page Only', 0),
('playerinfo_tabs', '1', 'New Style (hide sections by default)', 1),
('playerinfo_tabs', '0', 'Old Style (show all at once)', 0),
('nav_globalchat', '1', 'Show', 1),
('nav_globalchat', '0', 'Hide', 0),
('nav_cheaters', '0', 'Hide', 1),
('nav_cheaters', '1', 'Show', 0),
('show_weapon_target_flash', '1', 'Flash hitbox', 1),
('show_weapon_target_flash', '0', 'HTML Table', 0),
('show_server_load_image', '1', 'Show', 0),
('show_server_load_image', '0', 'Hide', 1),
('countrydata', '1', 'Show', 1),
('countrydata', '0', 'Hide', 0),
('gamehome_show_awards', '1', 'Show', 0),
('gamehome_show_awards', '0', 'Hide', 1),
('show_google_map', '0', 'Hide', 0),
('show_google_map', '1', 'Show', 1),
('google_map_region', 'NORTH AMERICA', 'North America', 1),
('google_map_region', 'SOUTH AMERICA', 'South America', 0),
('google_map_region', 'NORTH AFRICA', 'North Africa', 0),
('google_map_region', 'SOUTH AFRICA', 'South Africa', 0),
('google_map_region', 'NORTH EUROPE', 'North Europe', 0),
('google_map_region', 'EAST EUROPE', 'East Europe', 0),
('google_map_region', 'GERMANY', 'Germany', 0),
('google_map_region', 'FRANCE', 'France', 0),
('google_map_region', 'SPAIN', 'Spain', 0),
('google_map_region', 'UNITED KINGDOM', 'United Kingdom', 0),
('google_map_region', 'DENMARK', 'Denmark', 0),
('google_map_region', 'SWEDEN', 'Sweden', 0),
('google_map_region', 'NORWAY', 'Norway', 0),
('google_map_region', 'FINLAND', 'Finland', 0),
('google_map_region', 'NETHERLANDS', 'Netherlands', 0),
('google_map_region', 'BELGIUM', 'Belgium', 0),
('google_map_region', 'POLAND', 'Poland', 0),
('google_map_region', 'SUISSE', 'Suisse', 0),
('google_map_region', 'AUSTRIA', 'Austria', 0),
('google_map_region', 'ITALY', 'Italy', 0),
('google_map_region', 'TURKEY', 'Turkey', 0),
('google_map_region', 'BRAZIL', 'Brazil', 0),
('google_map_region', 'ARGENTINA', 'Argentina', 0),
('google_map_region', 'RUSSIA', 'Russia', 0),
('google_map_region', 'ASIA', 'Asia', 0),
('google_map_region', 'CHINA', 'China', 0),
('google_map_region', 'JAPAN', 'Japan', 0),
('google_map_region', 'SOUTH KOREA', 'South Korea', 0),
('google_map_region', 'AUSTRALIA', 'Australia', 0),
('google_map_region', 'WORLD', 'World', 0),
('google_map_type', 'HYBRID', 'Hybrid', 1),
('google_map_type', 'SATELLITE', 'Satellite', 0),
('google_map_type', 'MAP', 'Normal', 0),
('google_map_type', 'PHYSICAL', 'Physical', 0),
('slider', '1', 'Enabled', 1),
('slider', '0', 'Disabled', 0),
('modrewrite', '1', 'Enabled', 0),
('modrewrite', '0', 'Disabled', 1),
('DNSResolveIP', '1', 'Yes', 1),
('DNSResolveIP', '0', 'No', 0),
('Rcon', '1', 'Yes', 1),
('Rcon', '0', 'No', 0),
('RconIgnoreSelf', '0', 'No', 1),
('RconIgnoreSelf', '1', 'Yes', 0),
('RconRecord', '0', 'No', 1),
('RconRecord', '1', 'Yes', 0),
('Mode', 'Normal', 'Steam ID (recommended)', 1),
('Mode', 'NameTrack', 'Player Name', 0),
('Mode', 'LAN', 'IP Address', 0),
('UseTimestamp', '0', 'No', 1),
('UseTimestamp', '1', 'Yes', 0),
('AllowOnlyConfigServers', '0', 'No', 0),
('AllowOnlyConfigServers', '1', 'Yes', 1),
('TrackStatsTrend', '0', 'No', 0),
('TrackStatsTrend', '1', 'Yes', 1),
('GlobalBanning', '0', 'No', 1),
('GlobalBanning', '1', 'Yes', 0),
('LogChat', '0', 'No', 0),
('LogChat', '1', 'Yes', 1),
('LogChatAdmins', '0', 'No', 0),
('LogChatAdmins', '1', 'Yes', 1),
('GlobalChat', '0', 'None', 1),
('GlobalChat', '1', 'Broadcast to all', 0),
('GlobalChat', '2', 'Broadcast to admins', 0),
('SkillRatioCap', '0', 'No', 1),
('SkillRatioCap', '1', 'Yes', 0),
('UseGeoIPBinary', '0', 'GeoIP lookup via database', 1),
('UseGeoIPBinary', '1', 'GeoIP lookup via binary file', 0);
-- --------------------------------------------------------

--
-- Table structure for table `hlstats_PlayerNames`
--

ALTER TABLE `hlstats_PlayerNames`
CHANGE `name` `name` varchar(255) NOT NULL default '',
ADD COLUMN `connection_time` int(11) unsigned NOT NULL default '0',
CHANGE `kills` `kills` int(11) unsigned NOT NULL default '0',
CHANGE `deaths` `deaths` int(11) unsigned NOT NULL default '0',
CHANGE `suicides` `suicides` int(11) unsigned NOT NULL default '0',
ADD COLUMN `headshots` int(11) unsigned NOT NULL default '0',
ADD COLUMN `shots` int(11) unsigned NOT NULL default '0',
ADD COLUMN `hits` int(11) unsigned NOT NULL default '0';

--
-- Table structure for table `hlstats_Players`
--

ALTER TABLE `hlstats_Players`
ADD COLUMN `last_event` int(11) NOT NULL default '0',
ADD COLUMN `connection_time` int(11) unsigned NOT NULL default '0',
ADD COLUMN `lastAddress` varchar(32) NOT NULL default '',
ADD COLUMN `city` varchar(64) NOT NULL default '',
ADD COLUMN `state` varchar(64) NOT NULL default '',
ADD COLUMN `country` varchar(64) NOT NULL default '',
ADD COLUMN `flag` varchar(16) NOT NULL default '',
ADD COLUMN `lat` varchar(32) NOT NULL default '',
ADD COLUMN `lng` varchar(32) NOT NULL default '',
CHANGE `kills` `kills` int(11) unsigned NOT NULL default '0',
CHANGE `deaths` `deaths` int(11) unsigned NOT NULL default '0',
CHANGE `suicides` `suicides` int(11) unsigned NOT NULL default '0',
CHANGE `skill` `skill` int(11) unsigned NOT NULL default '1000',
ADD COLUMN `shots` int(11) unsigned NOT NULL default '0',
ADD COLUMN `hits` int(11) unsigned NOT NULL default '0',
DROP `oldskill`,
ADD COLUMN `headshots` int(10) unsigned NOT NULL default '0',
ADD COLUMN `last_skill_change` int(11) NOT NULL default '0',
ADD COLUMN `displayEvents` int(1) unsigned NOT NULL default '1',
ADD COLUMN `kill_streak` int(6) NOT NULL default '0',
ADD COLUMN `death_streak` int(6) NOT NULL default '0';



CREATE TABLE IF NOT EXISTS `hlstats_Players_Awards` (
  `awardTime` date NOT NULL,
  `awardId` int(11) unsigned NOT NULL default '0',
  `playerId` int(11) unsigned NOT NULL default '0',
  `count` int(11) unsigned NOT NULL default '0',
  `game` varchar(32) NOT NULL,
  PRIMARY KEY  (`awardTime`,`awardId`,`playerId`,`game`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Players_History`
--

CREATE TABLE IF NOT EXISTS `hlstats_Players_History` (
  `playerId` int(10) unsigned NOT NULL default '0',
  `eventTime` date NOT NULL default '0000-00-00',
  `connection_time` int(10) unsigned NOT NULL default '0',
  `kills` int(11) unsigned NOT NULL default '0',
  `deaths` int(11) unsigned NOT NULL default '0',
  `suicides` int(11) unsigned NOT NULL default '0',
  `skill` int(11) unsigned NOT NULL default '1000',
  `shots` int(11) unsigned NOT NULL default '0',
  `hits` int(11) unsigned NOT NULL default '0',
  `game` varchar(32) NOT NULL default '',
  `headshots` int(11) unsigned NOT NULL default '0',
  `skill_change` int(11) NOT NULL default '0',
  UNIQUE KEY `eventTime` (`eventTime`,`playerId`,`game`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Players_Ribbons`
--

CREATE TABLE IF NOT EXISTS `hlstats_Players_Ribbons` (
  `playerId` int(11) unsigned NOT NULL default '0',
  `ribbonId` int(11) unsigned NOT NULL default '0',
  `game` varchar(32) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------


CREATE TABLE IF NOT EXISTS `hlstats_Ranks` (
  `rankId` int(11) unsigned NOT NULL auto_increment,
  `image` varchar(30) NOT NULL,
  `minKills` int(11) unsigned NOT NULL default '0',
  `maxKills` int(11) NOT NULL default '0',
  `rankName` varchar(50) NOT NULL,
  `game` varchar(32) NOT NULL,
  PRIMARY KEY  (`rankId`),
  UNIQUE KEY `rankgame` (`image`,`game`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `hlstats_Ranks`
--

INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'recruit', 0, 49, 'Recruit' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'private', 50, 99, 'Private' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'private-first-class', 100, 199, 'Private First Class' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'lance-corporal', 200, 299, 'Lance Corporal' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'corporal', 300, 399, 'Corporal' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'sergeant', 400, 499, 'Sergeant' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'staff-sergeant', 500, 599, 'Staff Sergeant' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'gunnery-sergeant', 600, 699, 'Gunnery Sergeant' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'master-sergeant', 700, 799, 'Master Sergeant' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'first-sergeant', 800, 899, 'First Sergeant' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'master-chief', 900, 999, 'Master Chief' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'sergeant-major', 1000, 1199, 'Sergeant Major' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'ensign', 1200, 1399, 'Ensign' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'third-lieutenant', 1400, 1599, 'Third Lieutenant' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'second-lieutenant', 1600, 1799, 'Second Lieutenant' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'first-lieutenant', 1800, 1999, 'First Lieutenant' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'captain', 2000, 2249, 'Captain' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'group-captain', 2250, 2499, 'Group Captain' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'senior-captain', 2500, 2749, 'Senior Captain' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'lieutenant-major', 2750, 2999, 'Lieutenant Major' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'major', 3000, 3499, 'Major' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'group-major', 3500, 3999, 'Group Major' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'lieutenant-commander', 4000, 4499, 'Lieutenant Commander' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'commander', 4500, 4999, 'Commander' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'group-commander', 5000, 5749, 'Group Commander' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'lieutenant-colonel', 5750, 6499, 'Lieutenant Colonel' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'colonel', 6500, 7249, 'Colonel' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'brigadier', 7250, 7999, 'Brigadier' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'brigadier-general', 8000, 8999, 'Brigadier General' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'major-general', 9000, 9999, 'Major General' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'lieutenant-general', 10000, 12499, 'Lieutenant General' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'general', 12500, 14999, 'General' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'commander-general', 15000, 17499, 'Commander General' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'field-vice-marshal', 17500, 19999, 'Field Vice Marshal' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'field-marshal', 20000, 22499, 'Field Marshal' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'vice-commander-of-the-army', 22500, 24999, 'Vice Commander of the Army' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'commander-of-the-army', 25000, 27499, 'Commander of the Army' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'high-commander', 27500, 29999, 'High Commander' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'supreme-commander', 30000, 34999, 'Supreme Commander' FROM `hlstats_Games`);
INSERT INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`)
(SELECT `code`, 'terminator', 35000, 9999999, 'Terminator' FROM `hlstats_Games`);


-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Ribbons`
--

CREATE TABLE IF NOT EXISTS `hlstats_Ribbons` (
  `ribbonId` int(11) unsigned NOT NULL auto_increment,
  `awardCode` varchar(50) NOT NULL,
  `awardCount` int(11) NOT NULL default '0',
  `special` tinyint(3) NOT NULL default '0',
  `game` varchar(32) NOT NULL,
  `image` varchar(50) NOT NULL,
  `ribbonName` varchar(50) NOT NULL,
  PRIMARY KEY  (`ribbonId`),
  UNIQUE KEY `award` (`awardCode`,`awardCount`,`game`, `special`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Ribbons`
--

INSERT INTO `hlstats_Ribbons` (`awardCode`, `awardCount`, `special`, `game`, `image`, `ribbonName`) VALUES
('*Headshots*',2500,1,'css','ribbon_of_silver_star.gif','Sharpshooter'),
('*total connection hours*',48,2,'css','ribbon_of_army_service.gif','Army Service'),
('*total connection hours*',168,2,'hl2mp','1waward.png','Connection Time 1 Week '),
('crowbar',3,0,'hl2mp','1_crowbaraward.png','Award of Crowbar'),
('crossbow_bolt',3,0,'hl2mp','1_crossbow_boltaward.png','Award of Xbow'),
('combine_ball',3,0,'hl2mp','1_combine_ballaward.png','Award of Combine Ball'),
('ar2',3,0,'hl2mp','1_ar2award.png','Award of AR2'),
('357',3,0,'hl2mp','1_357award.png','Award of 357'),
('*total connection hours*',336,2,'hl2mp','2waward.png','Connection Time 2 Weeks '),
('grenade_frag',3,0,'hl2mp','1_grenade_fragaward.png','Award of Grenade'),
('physbox',3,0,'hl2mp','1_physboxaward.png','Award of Physbox'),
('physics',3,0,'hl2mp','1_physicsaward.png','Award of Physics'),
('pistol',3,0,'hl2mp','1_pistolaward.png','Award of Pistol'),
('rpg_missile',3,0,'hl2mp','1_rpg_missileaward.png','Award of RPG'),
('shotgun',3,0,'hl2mp','1_shotgunaward.png','Award of Shotgun'),
('slam',3,0,'hl2mp','1_slamaward.png','Award of Slam'),
('smg1_grenade',3,0,'hl2mp','1_smg1_grenadeaward.png','Award of SMG Grenade'),
('smg1',3,0,'hl2mp','1_smg1award.png','Award of SMG'),
('stunstick',3,0,'hl2mp','1_stunstickaward.png','Award of Stunstick'),
('357',7,0,'hl2mp','2_357award.png','Bronze 357'),
('ar2',7,0,'hl2mp','2_ar2award.png','Bronze AR2'),
('combine_ball',7,0,'hl2mp','2_combine_ballaward.png','Bronze Combine Ball'),
('crowbar',7,0,'hl2mp','2_crowbaraward.png','Bronze Crowbar'),
('grenade_frag',7,0,'hl2mp','2_grenade_fragaward.png','Bronze Grenade'),
('physbox',7,0,'hl2mp','2_physboxaward.png','Bronze Physbox'),
('physics',7,0,'hl2mp','2_physicsaward.png','Bronze Physics'),
('pistol',7,0,'hl2mp','2_pistolaward.png','Bronze Pistol'),
('rpg_missile',7,0,'hl2mp','2_rpg_missileaward.png','Bronze RPG'),
('shotgun',7,0,'hl2mp','2_shotgunaward.png','Bronze Shotgun'),
('slam',7,0,'hl2mp','2_slamaward.png','Bronze Slam'),
('smg1',7,0,'hl2mp','2_smg1award.png','Bronze SMG'),
('smg1_grenade',7,0,'hl2mp','2_smg1_grenadeaward.png','Bronze SMG Grenade'),
('stunstick',7,0,'hl2mp','2_stunstickaward.png','Bronze Stunstick'),
('crossbow_bolt',7,0,'hl2mp','2_crossbow_boltaward.png','Bronze Xbow'),
('ar2',12,0,'hl2mp','3_ar2award.png','Silver AR2'),
('357',12,0,'hl2mp','3_357award.png','Silver 357'),
('combine_ball',12,0,'hl2mp','3_combine_ballaward.png','Silver Combine Ball'),
('crossbow_bolt',12,0,'hl2mp','3_crossbow_boltaward.png','Silver Xbow'),
('crowbar',12,0,'hl2mp','3_crowbaraward.png','Silver Crowbar'),
('grenade_frag',12,0,'hl2mp','3_grenade_fragaward.png','Silver Grenade'),
('physbox',12,0,'hl2mp','3_physboxaward.png','Silver Physbox'),
('physics',12,0,'hl2mp','3_physicsaward.png','Silver Physics'),
('pistol',12,0,'hl2mp','3_pistolaward.png','Silver Pistol'),
('rpg_missile',12,0,'hl2mp','3_rpg_missileaward.png','Silver RPG'),
('shotgun',12,0,'hl2mp','3_shotgunaward.png','Silver Shotgun'),
('slam',12,0,'hl2mp','3_slamaward.png','Silver Slam'),
('smg1_grenade',12,0,'hl2mp','3_smg1_grenadeaward.png','Silver SMG Grenade'),
('smg1',12,0,'hl2mp','3_smg1award.png','Silver SMG'),
('stunstick',12,0,'hl2mp','3_stunstickaward.png','Silver Stunstick'),
('357',17,0,'hl2mp','x_357supreme.png','Supreme 357'),
('ar2',17,0,'hl2mp','x_ar2supreme.png','Supreme AR2'),
('combine_ball',17,0,'hl2mp','x_combine_ballsupreme.png','Supreme Combine Ball'),
('crossbow_bolt',17,0,'hl2mp','x_crossbow_boltsupreme.png','Supreme Xbow'),
('crowbar',17,0,'hl2mp','x_crowbarsupreme.png','Supreme Crowbar'),
('grenade_frag',17,0,'hl2mp','x_grenade_fragsupreme.png','Supreme Grenade'),
('physbox',17,0,'hl2mp','x_physboxsupreme.png','Supreme Physbox'),
('physics',17,0,'hl2mp','x_physicssupreme.png','Supreme Physics'),
('pistol',17,0,'hl2mp','x_pistolsupreme.png','Supreme Pistol'),
('rpg_missile',17,0,'hl2mp','x_rpg_missilesupreme.png','Supreme RPG'),
('shotgun',17,0,'hl2mp','x_shotgunsupreme.png','Supreme Shotgun'),
('slam',17,0,'hl2mp','x_slamsupreme.png','Supreme Slam'),
('smg1_grenade',17,0,'hl2mp','x_smg1_grenadesupreme.png','Supreme SMG Grenade'),
('smg1',17,0,'hl2mp','x_smg1supreme.png','Supreme SMG'),
('stunstick',17,0,'hl2mp','x_stunsticksupreme.png','Supreme Stunstick'),
('*total connection hours*',504,2,'hl2mp','3waward.png','Connection Time 3 Weeks '),
('*total connection hours*',672,2,'hl2mp','x_swaward.png','Connection Time - Supreme'),
('ak47',1,0,'css','1_ak47.png','Award of AK47'),
('awp',1,0,'css','1_awp.png','Award of AWP Sniper'),
('deagle',1,0,'css','1_deagle.png','Award of Desert Eagle'),
('elite',1,0,'css','1_elite.png','Award of Dual Beretta Elites'),
('glock',1,0,'css','1_glock.png','Award of Glock'),
('hegrenade',1,0,'css','1_hegrenade.png','Award of HE Grenades'),
('knife',1,0,'css','1_knife.png','Award of Combat Knife'),
('p90',1,0,'css','1_p90.png','Award of P90'),
('scout',1,0,'css','1_scout.png','Award of Scout Elite'),
('usp',1,0,'css','1_usp.png','Award of USP'),
('aug',1,0,'css','1_aug.png','Award of Steyr Aug'),
('fiveseven',1,0,'css','1_fiveseven.png','Award of Five-Seven'),
('g3sg1',1,0,'css','1_g3sg1.png','Award of G3 SG1'),
('m3',1,0,'css','1_m3.png','Award of M3 Shotgun'),
('m4a1',1,0,'css','1_m4a1.png','Award of Colt M4A1'),
('mac10',1,0,'css','1_mac10.png','Award of MAC 10'),
('mp5navy',1,0,'css','1_mp5navy.png','Award of MP5 Navy'),
('m249',1,0,'css','1_m249.png','Award of M249 Para'),
('sg550',1,0,'css','1_sg550.png','Award of SG 550'),
('sg552',1,0,'css','1_sg552.png','Award of SG 552'),
('p228',1,0,'css','1_p228.png','Award of Sig P228'),
('tmp',1,0,'css','1_tmp.png','Award of TMP'),
('ump45',1,0,'css','1_ump45.png','Award of UMP 45'),
('xm1014',1,0,'css','1_xm1014.png','Award of XM Shotgun'),
('ak47',5,0,'css','2_ak47.png','Bronze AK47'),
('awp',5,0,'css','2_awp.png','Bronze AWP Sniper'),
('deagle',5,0,'css','2_deagle.png','Bronze Desert Eagle'),
('elite',5,0,'css','2_elite.png','Bronze Dual Beretta Elites'),
('glock',5,0,'css','2_glock.png','Bronze Glock'),
('hegrenade',5,0,'css','2_hegrenade.png','Bronze HE Grenades'),
('knife',5,0,'css','2_knife.png','Bronze Combat Knife'),
('p90',5,0,'css','2_p90.png','Bronze P90'),
('scout',5,0,'css','2_scout.png','Bronze Scout Elite'),
('usp',5,0,'css','2_usp.png','Bronze USP'),
('aug',5,0,'css','2_aug.png','Bronze Steyr Aug'),
('fiveseven',5,0,'css','2_fiveseven.png','Bronze Five-Seven'),
('g3sg1',5,0,'css','2_g3sg1.png','Bronze G3 SG1'),
('m3',5,0,'css','2_m3.png','Bronze M3 Shotgun'),
('m4a1',5,0,'css','2_m4a1.png','Bronze Colt M4A1'),
('mac10',5,0,'css','2_mac10.png','Bronze MAC 10'),
('mp5navy',5,0,'css','2_mp5navy.png','Bronze MP5 Navy'),
('m249',5,0,'css','2_m249.png','Bronze M249 Para'),
('sg550',5,0,'css','2_sg550.png','Bronze SG 550'),
('sg552',5,0,'css','2_sg552.png','Bronze SG 552'),
('p228',5,0,'css','2_p228.png','Bronze Sig P228'),
('tmp',5,0,'css','2_tmp.png','Bronze TMP'),
('ump45',5,0,'css','2_ump45.png','Bronze UMP 45'),
('xm1014',5,0,'css','2_xm1014.png','Bronze XM Shotgun'),
('ak47',12,0,'css','3_ak47.png','Silver AK47'),
('awp',12,0,'css','3_awp.png','Silver AWP Sniper'),
('deagle',12,0,'css','3_deagle.png','Silver Desert Eagle'),
('elite',12,0,'css','3_elite.png','Silver Dual Beretta Elites'),
('glock',12,0,'css','3_glock.png','Silver Glock'),
('hegrenade',12,0,'css','3_hegrenade.png','Silver HE Grenades'),
('knife',12,0,'css','3_knife.png','Silver Combat Knife'),
('p90',12,0,'css','3_p90.png','Silver P90'),
('scout',12,0,'css','3_scout.png','Silver Scout Elite'),
('usp',12,0,'css','3_usp.png','Silver USP'),
('aug',12,0,'css','3_aug.png','Silver Steyr Aug'),
('fiveseven',12,0,'css','3_fiveseven.png','Silver Five-Seven'),
('g3sg1',12,0,'css','3_g3sg1.png','Silver G3 SG1'),
('m3',12,0,'css','3_m3.png','Silver M3 Shotgun'),
('m4a1',12,0,'css','3_m4a1.png','Silver Colt M4A1'),
('mac10',12,0,'css','3_mac10.png','Silver MAC 10'),
('mp5navy',12,0,'css','3_mp5navy.png','Silver MP5 Navy'),
('m249',12,0,'css','3_m249.png','Silver M249 Para'),
('sg550',12,0,'css','3_sg550.png','Silver SG 550'),
('sg552',12,0,'css','3_sg552.png','Silver SG 552'),
('p228',12,0,'css','3_p228.png','Silver Sig P228'),
('tmp',12,0,'css','3_tmp.png','Silver TMP'),
('ump45',12,0,'css','3_ump45.png','Silver UMP 45'),
('xm1014',12,0,'css','3_xm1014.png','Silver XM Shotgun'),
('ak47',20,0,'css','4_ak47.png','Gold AK47'),
('awp',20,0,'css','4_awp.png','Gold AWP Sniper'),
('deagle',20,0,'css','4_deagle.png','Gold Desert Eagle'),
('elite',20,0,'css','4_elite.png','Gold Dual Beretta Elites'),
('glock',20,0,'css','4_glock.png','Gold Glock'),
('hegrenade',20,0,'css','4_hegrenade.png','Gold HE Grenades'),
('knife',20,0,'css','4_knife.png','Gold Combat Knife'),
('p90',20,0,'css','4_p90.png','Gold P90'),
('scout',20,0,'css','4_scout.png','Gold Scout Elite'),
('usp',20,0,'css','4_usp.png','Gold USP'),
('aug',20,0,'css','4_aug.png','Gold Steyr Aug'),
('fiveseven',20,0,'css','4_fiveseven.png','Gold Five-Seven'),
('g3sg1',20,0,'css','4_g3sg1.png','Gold G3 SG1'),
('m3',20,0,'css','4_m3.png','Gold M3 Shotgun'),
('m4a1',20,0,'css','4_m4a1.png','Gold Colt M4A1'),
('mac10',20,0,'css','4_mac10.png','Gold MAC 10'),
('mp5navy',20,0,'css','4_mp5navy.png','Gold MP5 Navy'),
('m249',20,0,'css','4_m249.png','Gold M249 Para'),
('sg550',20,0,'css','4_sg550.png','Gold SG 550'),
('sg552',20,0,'css','4_sg552.png','Gold SG 552'),
('p228',20,0,'css','4_p228.png','Gold Sig P228'),
('tmp',20,0,'css','4_tmp.png','Gold TMP'),
('ump45',20,0,'css','4_ump45.png','Gold UMP 45'),
('xm1014',20,0,'css','4_xm1014.png','Gold XM Shotgun'),
('ak47',30,0,'css','5_ak47.png','Platinum AK47'),
('awp',30,0,'css','5_awp.png','Platinum AWP Sniper'),
('deagle',30,0,'css','5_deagle.png','Platinum Desert Eagle'),
('elite',30,0,'css','5_elite.png','Platinum Dual Beretta Elites'),
('glock',30,0,'css','5_glock.png','Platinum Glock'),
('hegrenade',30,0,'css','5_hegrenade.png','Platinum HE Grenades'),
('knife',30,0,'css','5_knife.png','Platinum Combat Knife'),
('p90',30,0,'css','5_p90.png','Platinum P90'),
('scout',30,0,'css','5_scout.png','Platinum Scout Elite'),
('usp',30,0,'css','5_usp.png','Platinum USP'),
('aug',30,0,'css','5_aug.png','Platinum Steyr Aug'),
('fiveseven',30,0,'css','5_fiveseven.png','Platinum Five-Seven'),
('g3sg1',30,0,'css','5_g3sg1.png','Platinum G3 SG1'),
('m3',30,0,'css','5_m3.png','Platinum M3 Shotgun'),
('m4a1',30,0,'css','5_m4a1.png','Platinum Colt M4A1'),
('mac10',30,0,'css','5_mac10.png','Platinum MAC 10'),
('mp5navy',30,0,'css','5_mp5navy.png','Platinum MP5 Navy'),
('m249',30,0,'css','5_m249.png','Platinum M249 Para'),
('sg550',30,0,'css','5_sg550.png','Platinum SG 550'),
('sg552',30,0,'css','5_sg552.png','Platinum SG 552'),
('p228',30,0,'css','5_p228.png','Platinum Sig P228'),
('tmp',30,0,'css','5_tmp.png','Platinum TMP'),
('ump45',30,0,'css','5_ump45.png','Platinum UMP 45'),
('xm1014',30,0,'css','5_xm1014.png','Platinum XM Shotgun'),
('ak47',50,0,'css','6_ak47.png','Supreme AK47'),
('awp',50,0,'css','6_awp.png','Supreme AWP Sniper'),
('deagle',50,0,'css','6_deagle.png','Supreme Desert Eagle'),
('elite',50,0,'css','6_elite.png','Supreme Dual Beretta Elites'),
('glock',50,0,'css','6_glock.png','Supreme Glock'),
('hegrenade',50,0,'css','6_hegrenade.png','Supreme HE Grenades'),
('knife',50,0,'css','6_knife.png','Supreme Combat Knife'),
('p90',50,0,'css','6_p90.png','Supreme P90'),
('scout',50,0,'css','6_scout.png','Supreme Scout Elite'),
('usp',50,0,'css','6_usp.png','Supreme USP'),
('aug',50,0,'css','6_aug.png','Supreme Steyr Aug'),
('fiveseven',50,0,'css','6_fiveseven.png','Supreme Five-Seven'),
('g3sg1',50,0,'css','6_g3sg1.png','Supreme G3 SG1'),
('m3',50,0,'css','6_m3.png','Supreme M3 Shotgun'),
('m4a1',50,0,'css','6_m4a1.png','Supreme Colt M4A1'),
('mac10',50,0,'css','6_mac10.png','Supreme MAC 10'),
('mp5navy',50,0,'css','6_mp5navy.png','Supreme MP5 Navy'),
('m249',50,0,'css','6_m249.png','Supreme M249 Para'),
('sg550',50,0,'css','6_sg550.png','Supreme SG 550'),
('sg552',50,0,'css','6_sg552.png','Supreme SG 552'),
('p228',50,0,'css','6_p228.png','Supreme Sig P228'),
('tmp',50,0,'css','6_tmp.png','Supreme TMP'),
('ump45',50,0,'css','6_ump45.png','Supreme UMP 45'),
('xm1014',50,0,'css','6_xm1014.png','Supreme XM Shotgun'),
('Defused_The_Bomb',1,0,'css','1_defused_the_bomb.png','Award of Bomb Defuser'),
('Planted_The_Bomb',1,0,'css','1_planted_the_bomb.png','Award of Bomb Planter'),
('Rescued_A_Hostage',1,0,'css','1_rescued_a_hostage.png','Award of Hostage Rescuer'),
('Killed_A_Hostage',1,0,'css','1_killed_a_hostage.png','Award of Hostage Killer'),
('latency',1,0,'css','1_latency.png','Award of Lowpinger'),
('headshot',1,0,'css','1_headshot.png','Award of Headshots'),
('Defused_The_Bomb',5,0,'css','2_defused_the_bomb.png','Bronze Bomb Defuser'),
('Planted_The_Bomb',5,0,'css','2_planted_the_bomb.png','Bronze Bomb Planter'),
('Rescued_A_Hostage',5,0,'css','2_rescued_a_hostage.png','Bronze Hostage Rescuer'),
('Killed_A_Hostage',5,0,'css','2_killed_a_hostage.png','Bronze Hostage Killer'),
('latency',5,0,'css','2_latency.png','Bronze Lowpinger'),
('headshot',5,0,'css','2_headshot.png','Bronze Headshots'),
('Defused_The_Bomb',12,0,'css','3_defused_the_bomb.png','Silver Bomb Defuser'),
('Planted_The_Bomb',12,0,'css','3_planted_the_bomb.png','Silver Bomb Planter'),
('Rescued_A_Hostage',12,0,'css','3_rescued_a_hostage.png','Silver Hostage Rescuer'),
('Killed_A_Hostage',12,0,'css','3_killed_a_hostage.png','Silver Hostage Killer'),
('latency',12,0,'css','3_latency.png','Silver Lowpinger'),
('headshot',12,0,'css','3_headshot.png','Silver Headshots'),
('Defused_The_Bomb',20,0,'css','4_defused_the_bomb.png','Gold Bomb Defuser'),
('Planted_The_Bomb',20,0,'css','4_planted_the_bomb.png','Gold Bomb Planter'),
('Rescued_A_Hostage',20,0,'css','4_rescued_a_hostage.png','Gold Hostage Rescuer'),
('Killed_A_Hostage',20,0,'css','4_killed_a_hostage.png','Gold Hostage Killer'),
('latency',20,0,'css','4_latency.png','Gold Lowpinger'),
('headshot',20,0,'css','4_headshot.png','Gold Headshots'),
('Defused_The_Bomb',30,0,'css','5_defused_the_bomb.png','Platinum Bomb Defuser'),
('Planted_The_Bomb',30,0,'css','5_planted_the_bomb.png','Platinum Bomb Planter'),
('Rescued_A_Hostage',30,0,'css','5_rescued_a_hostage.png','Platinum Hostage Rescuer'),
('Killed_A_Hostage',30,0,'css','5_killed_a_hostage.png','Platinum Hostage Killer'),
('latency',30,0,'css','5_latency.png','Platinum Lowpinger'),
('headshot',30,0,'css','5_headshot.png','Platinum Headshots'),
('Defused_The_Bomb',50,0,'css','6_defused_the_bomb.png','Supreme Bomb Defuser'),
('Planted_The_Bomb',50,0,'css','6_planted_the_bomb.png','Supreme Bomb Planter'),
('Rescued_A_Hostage',50,0,'css','6_rescued_a_hostage.png','Supreme Hostage Rescuer'),
('Killed_A_Hostage',50,0,'css','6_killed_a_hostage.png','Supreme Hostage Killer'),
('latency',50,0,'css','6_latency.png','Supreme Lowpinger'),
('headshot',50,0,'css','6_headshot.png','Supreme Headshots'),
('bat',5,0,'tf','1_bat.png','Silver Baseball Bat'),
('bonesaw',5,0,'tf','1_bonesaw.png','Silver Bone Saw'),
('bottle',5,0,'tf','1_bottle.png','Silver Whiskey Bottle'),
('club',5,0,'tf','1_club.png','Silver Club'),
('fireaxe',5,0,'tf','1_fireaxe.png','Silver Fire Axe'),
('fists',5,0,'tf','1_fists.png','Silver Fists'),
('flamethrower',5,0,'tf','1_flamethrower.png','Silver Flamethrower'),
('knife',5,0,'tf','1_knife.png','Silver Knife'),
('minigun',5,0,'tf','1_minigun.png','Silver Minigun'),
('obj_sentrygun',5,0,'tf','1_obj_sentrygun.png','Silver Sentry Gun'),
('pistol',5,0,'tf','1_pistol.png','Silver Pistol'),
('pistol_scout',5,0,'tf','1_pistol_scout.png','Silver Scout Pistol'),
('revolver',5,0,'tf','1_revolver.png','Silver Revolver'),
('scattergun',5,0,'tf','1_scattergun.png','Silver Scattergun'),
('shotgun_hwg',5,0,'tf','1_shotgun_hwg.png','Silver Shotgun HWG'),
('shotgun_primary',5,0,'tf','1_shotgun_primary.png','Silver Shotgun'),
('shotgun_pyro',5,0,'tf','1_shotgun_pyro.png','Silver Shotgun Pyro'),
('shotgun_soldier',5,0,'tf','1_shotgun_soldier.png','Silver Shotgun Soldier'),
('shovel',5,0,'tf','1_shovel.png','Silver Shovel'),
('smg',5,0,'tf','1_smg.png','Silver SMG'),
('sniperrifle',5,0,'tf','1_sniperrifle.png','Silver Sniperrifle'),
('syringegun_medic',5,0,'tf','1_syringegun_medic.png','Silver Syringe Gun'),
('tf_projectile_pipe',5,0,'tf','1_tf_projectile_pipe.png','Silver Pipe bomb'),
('tf_projectile_pipe_remote',5,0,'tf','1_tf_projectile_pipe_remote.png','Silver Sticky bomb'),
('tf_projectile_rocket',5,0,'tf','1_tf_projectile_rocket.png','Silver RPG'),
('world',5,0,'tf','1_world.png','Silver World'),
('wrench',5,0,'tf','1_wrench.png','Silver Wrench'),
('builtobject',5,0,'tf','1_builtobject.png','Silver Object Builder'),
('captureblocked',5,0,'tf','1_captureblocked.png','Silver Checkpoint Blocker'),
('chargedeployed',5,0,'tf','1_chargedeployed.png','Silver Uber-Medic'),
('domination',5,0,'tf','1_domination.png','Silver Dominator'),
('kill assist',5,0,'tf','1_kill-assist.png','Silver Assistance'),
('killedobject',5,0,'tf','1_killedobject.png','Silver Object Destroyer'),
('pointcaptured',5,0,'tf','1_pointcaptured.png','Silver Capturer'),
('revenge',5,0,'tf','1_revenge.png','Silver Revenge'),
('axtinguisher', 5, 0, 'tf', '1_axtinguisher.png', 'Silver Axtinguisher'),
('backburner', 5, 0, 'tf', '1_backburner.png', 'Silver Backburner'),
('blutsauger', 5, 0, 'tf', '1_blutsauger.png', 'Silver Blutsauger'),
('gloves', 5, 0, 'tf', '1_gloves.png', 'Silver K.G.B.'),
('natascha', 5, 0, 'tf', '1_natascha.png', 'Silver Natascha'),
('ubersaw', 5, 0, 'tf', '1_ubersaw.png', 'Silver Ubersaw'),
('*total connection hours*',168,2,'insmod','1waward.png','Connection Time 1 Week '),
('weapon_makarov',5,0,'insmod','rs_makarov.png','Silver Makarov'),
('weapon_m9',5,0,'insmod','rs_m9.png','Silver 9mm Beretta'),
('world',5,0,'insmod','rs_world.png','Silver RPG or Grenade'),
('weapon_sks',5,0,'insmod','rs_sks.png','Silver Simonov SKS carbine'),
('weapon_m1014',5,0,'insmod','rs_m1014.png','Silver M1014 Shotgun'),
('weapon_toz',5,0,'insmod','rs_toz.png','Silver TOZ Rifle'),
('weapon_svd',5,0,'insmod','rs_svd.png','Silver Dragunov Sniper Rifle'),
('weapon_rpk',5,0,'insmod','rs_rpk.png','Silver RPK'),
('weapon_m249',5,0,'insmod','rs_m249.png','Silver M249 SAW'),
('weapon_m16m203',5,0,'insmod','rs_m16m203.png','Silver M16 & M203'),
('weapon_l42a1',5,0,'insmod','rs_l42a1.png','Silver Enfield L42A1 Sniper Rifle'),
('weapon_m4med',5,0,'insmod','rs_m4med.png','Silver M4 Medium Range Rifle'),
('weapon_m4',5,0,'insmod','rs_m4.png','Silver M4 Carbine Rifle'),
('weapon_m16a4',5,0,'insmod','rs_m16a4.png','Silver M16A4 Infantry Rifle'),
('weapon_m14',5,0,'insmod','rs_m14.png','Silver M14 Infantry Rifle'),
('weapon_fnfal',5,0,'insmod','rs_fnfal.png','Silver FN FAL Automatic Rifle'),
('weapon_aks74u',5,0,'insmod','rs_aks74u.png','Silver AKS-74U'),
('weapon_ak47',5,0,'insmod','rs_ak47.png','Silver AK-47'),
('weapon_makarov',10,0,'insmod','rg_makarov.png','Gold Makarov'),
('weapon_m9',10,0,'insmod','rg_m9.png','Gold 9mm Beretta'),
('world',10,0,'insmod','rg_world.png','Gold RPG or Grenade'),
('weapon_sks',10,0,'insmod','rg_sks.png','Gold Simonov SKS carbine'),
('weapon_m1014',10,0,'insmod','rg_m1014.png','Gold M1014 Shotgun'),
('weapon_toz',10,0,'insmod','rg_toz.png','Gold TOZ Rifle'),
('weapon_svd',10,0,'insmod','rg_svd.png','Gold Dragunov Sniper Rifle'),
('weapon_rpk',10,0,'insmod','rg_rpk.png','Gold RPK'),
('weapon_m249',10,0,'insmod','rg_m249.png','Gold M249 SAW'),
('weapon_m16m203',10,0,'insmod','rg_m16m203.png','Gold M16 & M203'),
('weapon_l42a1',10,0,'insmod','rg_l42a1.png','Gold Enfield L42A1 Sniper Rifle'),
('weapon_m4med',10,0,'insmod','rg_m4med.png','Gold M4 Medium Range Rifle'),
('weapon_m4',10,0,'insmod','rg_m4.png','Gold M4 Carbine Rifle'),
('weapon_m16a4',10,0,'insmod','rg_m16a4.png','Gold M16A4 Infantry Rifle'),
('weapon_m14',10,0,'insmod','rg_m14.png','Gold M14 Infantry Rifle'),
('weapon_fnfal',10,0,'insmod','rg_fnfal.png','Gold FN FAL Automatic Rifle'),
('weapon_aks74u',10,0,'insmod','rg_aks74u.png','Gold AKS-74U'),
('weapon_ak47',10,0,'insmod','rg_ak47.png','Gold AK-47'),
('ak47',5,0,'cstrike','1_ak47.png','Award of AK47'),
('awp',5,0,'cstrike','1_awp.png','Award of AWP Sniper'),
('deagle',5,0,'cstrike','1_deagle.png','Award of Desert Eagle'),
('elite',5,0,'cstrike','1_elite.png','Award of Dual Beretta Elites'),
('famas',5,0,'cstrike','1_famas.png','Award of Fusil Automatique'),
('galil',5,0,'cstrike','1_galil.png','Award of Galil'),
('glock18',5,0,'cstrike','1_glock.png','Award of Glock'),
('knife',5,0,'cstrike','1_knife.png','Award of Combat Knife'),
('latency',5,0,'cstrike','1_latency.png','Award of Lowpinger'),
('m3',5,0,'cstrike','1_m3.png','Award of M3 Super'),
('m4a1',5,0,'cstrike','1_m4a1.png','Award of Colt M4A1'),
('p90',5,0,'cstrike','1_p90.png','Award of P90'),
('scout',5,0,'cstrike','1_scout.png','Award of Scout Elite'),
('usp',5,0,'cstrike','1_usp.png','Award of USP'),
('boomer_claw', '5', '0', 'l4d', '1_boomer_claw.png', 'Bronze Boom!'),
('headshot', '5', '0', 'l4d', '1_headshot.png', 'Bronze Brain Salad'),
('healed_teammate', '5', '0', 'l4d', '1_healed_teammate.png', 'Bronze Field Medic'),
('hunter_claw', '5', '0', 'l4d', '1_hunter_claw.png', 'Bronze Grim Reaper'),
('inferno', '5', '0', 'l4d', '1_inferno.png', 'Bronze Cremator'),
('killed_exploding', '5', '0', 'l4d', '1_killed_exploding.png', 'Bronze Stomach Upset'),
('killed_gas', '5', '0', 'l4d', '1_killed_gas.png', 'Bronze Tongue Twister'),
('killed_hunter', '5', '0', 'l4d', '1_killed_hunter.png', 'Bronze Hunter Punter'),
('killed_survivor', '5', '0', 'l4d', '1_killed_survivor.png', 'Bronze Dead Wreckening'),
('killed_tank', '5', '0', 'l4d', '1_killed_tank.png', 'Bronze Tankbuster'),
('killed_witch', '5', '0', 'l4d', '1_killed_witch.png', 'Bronze Inquisitor'),
('latency', '5', '0', 'l4d', '1_latency.png', 'Bronze Nothing Special'),
('pipe_bomb', '5', '0', 'l4d', '1_pipe_bomb.png', 'Bronze Pyrotechnician'),
('pounce', '5', '0', 'l4d', '1_pounce.png', 'Bronze Free 2 Fly'),
('rescued_survivor', '5', '0', 'l4d', '1_rescued_survivor.png', 'Bronze Ground Cover'),
('revived_teammate', '5', '0', 'l4d', '1_revived_teammate.png', 'Bronze Helping Hand'),
('smoker_claw', '5', '0', 'l4d', '1_smoker_claw.png', 'Bronze Chain Smoker'),
('tank_claw', '5', '0', 'l4d', '1_tank_claw.png', 'Bronze Lambs 2 Slaughter'),
('tongue_grab', '5', '0', 'l4d', '1_tongue_grab.png', 'Bronze Drag &amp; Drop'),
('vomit', '5', '0', 'l4d', '1_vomit.png', 'Bronze Barf Bagged'),
('boomer_claw', '15', '0', 'l4d', '2_boomer_claw.png', 'Silver Boom!'),
('headshot', '15', '0', 'l4d', '2_headshot.png', 'Silver Brain Salad'),
('healed_teammate', '15', '0', 'l4d', '2_healed_teammate.png', 'Silver Field Medic'),
('hunter_claw', '15', '0', 'l4d', '2_hunter_claw.png', 'Silver Grim Reaper'),
('inferno', '15', '0', 'l4d', '2_inferno.png', 'Silver Cremator'),
('killed_exploding', '15', '0', 'l4d', '2_killed_exploding.png', 'Silver Stomach Upset'),
('killed_gas', '15', '0', 'l4d', '2_killed_gas.png', 'Silver Tongue Twister'),
('killed_hunter', '15', '0', 'l4d', '2_killed_hunter.png', 'Silver Hunter Punter'),
('killed_survivor', '15', '0', 'l4d', '2_killed_survivor.png', 'Silver Dead Wreckening'),
('killed_tank', '15', '0', 'l4d', '2_killed_tank.png', 'Silver Tankbuster'),
('killed_witch', '15', '0', 'l4d', '2_killed_witch.png', 'Silver Inquisitor'),
('latency', '15', '0', 'l4d', '2_latency.png', 'Silver Nothing Special'),
('pipe_bomb', '15', '0', 'l4d', '2_pipe_bomb.png', 'Silver Pyrotechnician'),
('pounce', '15', '0', 'l4d', '2_pounce.png', 'Silver Free 2 Fly'),
('rescued_survivor', '15', '0', 'l4d', '2_rescued_survivor.png', 'Silver Ground Cover'),
('revived_teammate', '15', '0', 'l4d', '2_revived_teammate.png', 'Silver Helping Hand'),
('smoker_claw', '15', '0', 'l4d', '2_smoker_claw.png', 'Silver Chain Smoker'),
('tank_claw', '15', '0', 'l4d', '2_tank_claw.png', 'Silver Lambs 2 Slaughter'),
('tongue_grab', '15', '0', 'l4d', '2_tongue_grab.png', 'Silver Drag &amp; Drop'),
('vomit', '15', '0', 'l4d', '2_vomit.png', 'Silver Barf Bagged'),
('boomer_claw', '30', '0', 'l4d', '3_boomer_claw.png', 'Golden Boom!'),
('headshot', '30', '0', 'l4d', '3_headshot.png', 'Golden Brain Salad'),
('healed_teammate', '30', '0', 'l4d', '3_healed_teammate.png', 'Golden Field Medic'),
('hunter_claw', '30', '0', 'l4d', '3_hunter_claw.png', 'Golden Grim Reaper'),
('inferno', '30', '0', 'l4d', '3_inferno.png', 'Golden Cremator'),
('killed_exploding', '30', '0', 'l4d', '3_killed_exploding.png', 'Golden Stomach Upset'),
('killed_gas', '30', '0', 'l4d', '3_killed_gas.png', 'Golden Tongue Twister'),
('killed_hunter', '30', '0', 'l4d', '3_killed_hunter.png', 'Golden Hunter Punter'),
('killed_survivor', '30', '0', 'l4d', '3_killed_survivor.png', 'Golden Dead Wreckening'),
('killed_tank', '30', '0', 'l4d', '3_killed_tank.png', 'Golden Tankbuster'),
('killed_witch', '30', '0', 'l4d', '3_killed_witch.png', 'Golden Inquisitor'),
('latency', '30', '0', 'l4d', '3_latency.png', 'Golden Nothing Special'),
('pipe_bomb', '30', '0', 'l4d', '3_pipe_bomb.png', 'Golden Pyrotechnician'),
('pounce', '30', '0', 'l4d', '3_pounce.png', 'Golden Free 2 Fly'),
('rescued_survivor', '30', '0', 'l4d', '3_rescued_survivor.png', 'Golden Ground Cover'),
('revived_teammate', '30', '0', 'l4d', '3_revived_teammate.png', 'Golden Helping Hand'),
('smoker_claw', '30', '0', 'l4d', '3_smoker_claw.png', 'Golden Chain Smoker'),
('tank_claw', '30', '0', 'l4d', '3_tank_claw.png', 'Golden Lambs 2 Slaughter'),
('tongue_grab', '30', '0', 'l4d', '3_tongue_grab.png', 'Golden Drag &amp; Drop'),
('vomit', '30', '0', 'l4d', '3_vomit.png', 'Golden Barf Bagged'),
('boomer_claw', '50', '0', 'l4d', '4_boomer_claw.png', 'Bloody Boom!'),
('headshot', '50', '0', 'l4d', '4_headshot.png', 'Bloody Brain Salad'),
('healed_teammate', '50', '0', 'l4d', '4_healed_teammate.png', 'Bloody Field Medic'),
('hunter_claw', '50', '0', 'l4d', '4_hunter_claw.png', 'Bloody Grim Reaper'),
('inferno', '50', '0', 'l4d', '4_inferno.png', 'Bloody Cremator'),
('killed_exploding', '50', '0', 'l4d', '4_killed_exploding.png', 'Bloody Stomach Upset'),
('killed_gas', '50', '0', 'l4d', '4_killed_gas.png', 'Bloody Tongue Twister'),
('killed_hunter', '50', '0', 'l4d', '4_killed_hunter.png', 'Bloody Hunter Punter'),
('killed_survivor', '50', '0', 'l4d', '4_killed_survivor.png', 'Bloody Dead Wreckening'),
('killed_tank', '50', '0', 'l4d', '4_killed_tank.png', 'Bloody Tankbuster'),
('killed_witch', '50', '0', 'l4d', '4_killed_witch.png', 'Bloody Inquisitor'),
('latency', '50', '0', 'l4d', '4_latency.png', 'Bloody Nothing Special'),
('pipe_bomb', '50', '0', 'l4d', '4_pipe_bomb.png', 'Bloody Pyrotechnician'),
('pounce', '50', '0', 'l4d', '4_pounce.png', 'Bloody Free 2 Fly'),
('rescued_survivor', '50', '0', 'l4d', '4_rescued_survivor.png', 'Bloody Ground Cover'),
('revived_teammate', '50', '0', 'l4d', '4_revived_teammate.png', 'Bloody Helping Hand'),
('smoker_claw', '50', '0', 'l4d', '4_smoker_claw.png', 'Bloody Chain Smoker'),
('tank_claw', '50', '0', 'l4d', '4_tank_claw.png', 'Bloody Lambs 2 Slaughter'),
('tongue_grab', '50', '0', 'l4d', '4_tongue_grab.png', 'Bloody Drag &amp; Drop'),
('vomit', '50', '0', 'l4d', '4_vomit.png', 'Bloody Barf Bagged');

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Roles`
--

ALTER TABLE `hlstats_Roles`
ADD COLUMN `picked` int(6) unsigned NOT NULL default '0',
ADD COLUMN `kills` int(6) unsigned NOT NULL default '0',
ADD COLUMN `deaths` int(6) unsigned NOT NULL default '0';

--
-- Dumping data for table `hlstats_Roles`
--

INSERT IGNORE INTO `hlstats_Roles` (`game`, `code`, `name`, `hidden`) VALUES
('tf','engineer','Engineer','0'),
('tf','spy','Spy','0'),
('tf','soldier','Soldier','0'),
('tf','scout','Scout','0'),
('tf','demoman','Demo Man','0'),
('tf','sniper','Sniper','0'),
('tf','medic','Medic','0'),
('tf','pyro','Pyro','0'),
('tf','heavyweapons','Heavy','0'),
('dods','Random','Random','0'),
('dods','#class_allied_garand','American Rifleman','0'),
('dods','#class_allied_thompson','American Master Sergeant','0'),
('dods','#class_allied_heavy','American Support Infantry','0'),
('dods','#class_allied_sniper','American Sniper','0'),
('dods','#class_allied_mg','American Machine Gunner','0'),
('dods','#class_allied_bazooka','American Bazooka ','0'),
('dods','#class_axis_kar98','Axis Grenadier','0'),
('dods','#class_axis_mp40','Axis Unteroffizier','0'),
('dods','#class_axis_mp44','Axis Sturmtruppe','0'),
('dods','#class_axis_sniper','Axis Scharfschtze','0'),
('dods','#class_axis_mg42','Axis MG42-Schtze','0'),
('dods','#class_axis_pschreck','Axis Panzerschreck','0'),
('ff','engineer','Engineer','0'),
('ff','spy','Spy','0'),
('ff','soldier','Soldier','0'),
('ff','scout','Scout','0'),
('ff','demoman','Demo Man','0'),
('ff','sniper','Sniper','0'),
('ff','medic','Medic','0'),
('ff','pyro','Pyro','0'),
('ff','hwguy','HWGuy','0'),
('ff','civilian','Civilian','0'),
('tfc','Scout','Scout','0'),
('tfc','Sniper','Sniper','0'),
('tfc','Soldier','Soldier','0'),
('tfc','Demoman','Demoman','0'),
('tfc','Medic','Medic','0'),
('tfc','HWGuy','HWGuy','0'),
('tfc','Pyro','Pyro','0'),
('tfc','Spy','Spy','0'),
('tfc','Engineer','Engineer','0'),
('tfc','Civilian','The Hunted','0'),
('dod','Random','Random','0'),
('dod','#class_allied_garand','American Rifleman','0'),
('dod','#class_allied_carbine','American Staff Sergeant','0'),
('dod','#class_allied_thompson','American Master Sergeant','0'),
('dod','#class_allied_grease','American Sergeant','0'),
('dod','#class_allied_sniper','American Sniper','0'),
('dod','#class_allied_heavy','American Support Infantry','0'),
('dod','#class_allied_mg','American Machine Gunner','0'),
('dod','#class_alliedpara_garand','American Para Rifleman','0'),
('dod','#class_alliedpara_carbine','American Para Staff Sergeant','0'),
('dod','#class_alliedpara_thompson','American Para Master Sergeant','0'),
('dod','#class_alliedpara_grease','American Para Sergeant','0'),
('dod','#class_alliedpara_spring','American Para Sniper','0'),
('dod','#class_alliedpara_bar','American Para Support Infantry','0'),
('dod','#class_alliedpara_30cal','American Para Machine Gunner','0'),
('dod','#class_brit_light','British Rifleman','0'),
('dod','#class_brit_medium','British Sergeant Major','0'),
('dod','#class_brit_sniper','British Marksman','0'),
('dod','#class_brit_heavy','British Gunner','0'),
('dod','#class_axis_kar98','Axis Grenadier','0'),
('dod','#class_axis_k43','Axis Stosstruppe','0'),
('dod','#class_axis_mp40','Axis Unteroffizier','0'),
('dod','#class_axis_mp44','Axis Sturmtruppe','0'),
('dod','#class_axis_sniper','Axis Scharfschtze','0'),
('dod','#class_axis_mg34','Axis MG34-Schtze','0'),
('dod','#class_axis_mg42','Axis MG42-Schtze','0'),
('dod','#class_axispara_kar98','Axis Para Grenadier','0'),
('dod','#class_axispara_k43','Axis Para Stosstruppe','0'),
('dod','#class_axispara_mp40','Axis Para Unteroffizier','0'),
('dod','#class_axispara_mp44','Axis Para Sturmtruppe','0'),
('dod','#class_axispara_scopedkar','Axis Para Scharfschtze','0'),
('dod','#class_axispara_fg42bipod','Axis Para Fg42-Zweinbein','0'),
('dod','#class_axispara_fg42scope','Axis Para Fg42-Zielfernrohr','0'),
('dod','#class_axispara_mg34','Axis Para MG34-Schtze','0'),
('dod','#class_axispara_mg42','Axis Para MG42-Schtze','0'),
('ns','soldier','Soldier','0'),
('ns','commander','Commander','0'),
('ns','skulk','Skulk','0'),
('ns','gorge','Gorge','0'),
('ns','lerk','Lerk','0'),
('ns','fade','Fade','0'),
('ns','onos','Onos','0'),
('ns','gestate','Gestate','1'),
('l4d', 'NamVet', 'Bill', '0'),
('l4d', 'TeenGirl', 'Zoey', '0'),
('l4d', 'Biker', 'Francis', '0'),
('l4d', 'Manager', 'Louis', '0'),
('l4d', 'GAS', 'Smoker', '0'),
('l4d', 'EXPLODING', 'Boomer', '0'),
('l4d', 'HUNTER', 'Hunter', '0'),
('l4d', 'TANK', 'tank', '0'),
('l4d', 'infected', 'Infected Horde', '0'),
('l4d', 'witch', 'Witch', '0');

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Servers`
--

ALTER TABLE `hlstats_Servers`
CHANGE `name` `name` varchar(255) NOT NULL default '',
ADD COLUMN `sortorder` tinyint NOT NULL default '0',
ADD COLUMN `kills` int(10) NOT NULL default '0',
ADD COLUMN `players` int(11) NOT NULL default '0',
ADD COLUMN `rounds` int(10) NOT NULL default '0',
ADD COLUMN `suicides` int(10) NOT NULL default '0',
ADD COLUMN `headshots` int(10) NOT NULL default '0',
ADD COLUMN `bombs_planted` int(10) NOT NULL default '0',
ADD COLUMN `bombs_defused` int(10) NOT NULL default '0',
ADD COLUMN `ct_wins` int(10) NOT NULL default '0',
ADD COLUMN `ts_wins` int(10) NOT NULL default '0',
ADD COLUMN `act_players` int(4) NOT NULL default '0',
ADD COLUMN `max_players` int(4) NOT NULL default '0',
ADD COLUMN `act_map` varchar(64) NOT NULL default '',
ADD COLUMN `map_rounds` int(6) NOT NULL default '0',
ADD COLUMN `map_ct_wins` int(10) NOT NULL default '0',
ADD COLUMN `map_ts_wins` int(10) NOT NULL default '0',
ADD COLUMN `map_started` int(10) NOT NULL default '0',
ADD COLUMN `map_changes` int(10) NOT NULL default '0',
ADD COLUMN `ct_shots` int(11) NOT NULL default '0',
ADD COLUMN `ct_hits` int(11) NOT NULL default '0',
ADD COLUMN `ts_shots` int(11) NOT NULL default '0',
ADD COLUMN `ts_hits` int(11) NOT NULL default '0',
ADD COLUMN `map_ct_shots` int(11) NOT NULL default '0',
ADD COLUMN `map_ct_hits` int(11) NOT NULL default '0',
ADD COLUMN `map_ts_shots` int(11) NOT NULL default '0',
ADD COLUMN `map_ts_hits` int(11) NOT NULL default '0',
ADD COLUMN `lat` varchar(32) NOT NULL default '',
ADD COLUMN `lng` varchar(32) NOT NULL default '',
ADD COLUMN `city` varchar(128) NOT NULL default '',
ADD COLUMN `country` varchar(128) NOT NULL default '';

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Servers_Config`
--

CREATE TABLE IF NOT EXISTS `hlstats_Servers_Config` (
  `serverId` int(11) unsigned NOT NULL default '0',
  `parameter` varchar(50) NOT NULL,
  `value` varchar(128) NOT NULL,
  `serverConfigId` int(11) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`serverId`,`parameter`),
  KEY `serverConfigId` (`serverConfigId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Servers_Config_Default`
--

CREATE TABLE IF NOT EXISTS `hlstats_Servers_Config_Default` (
  `parameter` varchar(50) NOT NULL,
  `value` varchar(128) NOT NULL,
  `description` mediumtext character set utf8 collate utf8_unicode_ci,
  PRIMARY KEY  (`parameter`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hlstats_Servers_Config_Default`
--

INSERT INTO `hlstats_Servers_Config_Default` (`parameter`, `value`, `description`) VALUES
('AddressPort', '0.0.0.0:27015', 'Server address (IP:Port)'),
('Admins', '', 'Steamids seperated by "," ("STEAM_0:1:XXX,STEAM_0:0:XXX,STEAM_0:1:XXX").'),
('AutoBanRetry', '0', 'Auto-bans player for 5 minutes if the disconnect from the server. Prevent players from reconnecting until the have a good team and won''t loose many points. 1=on 0=off(default)'),
('AutoTeamBalance', '0', 'If rcon is enabled hlstats automatically analyzed teams and balance players for fair teams. It will make teams numerical even and also swap players based on there skill to balance teams. 1=on, 0=off(default)'),
('BonusRoundIgnore', '0', 'Ignore frags and actions after round has ended (for applicable games). 1=on, 0=off(default)'),
('BonusRoundTime', '0', 'Length (in seconds) of mp_bonusroundtime (as failsafe in case round_start event is not detected). 1=on, 0=off(default)'),
('BroadCastEvents', '1', 'Nearly all Events will be directly broadcasted through rcon on the server. You will directly see, how many points you got for a kill or bomb plating etc. 1=on 0=off(default)'),
('BroadCastEventsCommand', 'hlx_sm_psay', 'The command to broadcast the events. Default is the "say"-command'),
('BroadCastEventsCommandAnnounce', 'hlx_sm_csay', 'Command to announce ingame summary stats and admin email etc. Default is "say".'),
('BroadCastPlayerActions', '1', 'Toggle broadcasting PlayerActions ingame. (f.e Touched a hostage or dropped the Bomb). 1=on 0=off(default)'),
('DisplayResultsInBrowser', '1', 'If enabled (1=on 0=off(default)) the player queries will displayed in the valve browser as small html files. (Not support in all game and admin mod combinations)'),
('EnablePublicCommands', '1', 'If activated players can report their statistics to all players in the chat area.'),
('GameEngine', '3', 'Game engine of game on this server:<UL>\r\n<LI>1 = HL1 (GoldSource).\r\n<LI>2 = HL2 (Source original).\r\n<LI>3 = HL2ep2 (Source OrangeBox)(default).</UL>'),
('GameType', '0', 'Mode of the current gametype:<UL>\r\n<LI>0 = Normal mod standard (default).\r\n<LI>1 = Deathmatch (only need to set if team names are NOT "Unassigned" during deathmatch (ie. in CSS Deathmatch).</UL>'),
('HLStatsURL', 'http://yoursite.com/hlstats', 'URL to your HLStats. This is broadcasted to master server and displays ingame.'),
('IgnoreBots', '1', 'If enabled bots are not tracked by ELstatsNEO 1=on 0=off(default).'),
('MinimumPlayersRank', '0', 'Required players position to be allowed playing on the server (e.g Top500-Server).'),
('MinPlayers', '4', 'Specifies the minimum number of players required in the server for most player events (objectives, frags, etc.) to be recorded.\r\nThis prevents players from hopping on an empty server and boosting their skill rating by capturing the flag, etc., with no opposition.'),
('Mod', 'SOURCEMOD', 'Valid values are SOURCEMOD, MINISTATS, BEETLE or MANI if one of such plugins are installed.'),
('PlayerEvents', '1', 'Determine if players can get player-specific display ingame (f.e. /skill)'),
('PlayerEventsAdminCommand', '', 'Some messages (f.e. team-balancer) are only for admins. here you can specify a admin-command. Default is "".'),
('PlayerEventsCommand', 'hlx_sm_psay', 'The command to display player events. Default is the "say"-command.'),
('PlayerEventsCommandOSD', 'hlx_sm_msay', 'The command to display amx style menu for "/rank", "/session", "/kpd" commands. Default is "".'),
('ShowStats', '1', 'If set to 1 (default) periodically stats are shown ingame with the broadcast-command.'),
('SkillMode', '2', 'Mode of skill changes on frags with following options:\r\n<UL>\r\n<LI>0 = Normal (Victims lose all the points which the killer gains).\r\n<LI>1 = Victims lose 3/4 the points which the killer gains.\r\n<LI>2 = Victims lose 1/2 the points which the killer gains.\r\n<LI>3 = Victims lose 1/4 the points which the killer gains.\r\n<LI>4 = Victims lose no points.\r\n<LI>ZPS-only. Survivor victims lose 1/2, Zombie victims lose 1/4\r\n</UL>'),
('SuicidePenalty', '5', 'Penalty for a suicide (Default: 5 points).'),
('SwitchAdmins', '0', 'Defines if admins are switched from auto-team balancer 1=on 0=off(default).'),
('TKPenalty', '50', 'Penalty for a team kill (Default: 50 points).'),
('TrackServerLoad', '1', 'Saves every 5 min how much players are playing on the server.');
-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Servers_Teamspeak`
--

CREATE TABLE IF NOT EXISTS `hlstats_Servers_Teamspeak` (
  `tsId` int(11) unsigned NOT NULL auto_increment,
  `tsName` varchar(128) NOT NULL,
  `tsAddr` varchar(128) NOT NULL,
  `tsPassword` varchar(128) default NULL,
  `tsDesc` varchar(255) default NULL,
  `tsQueryPort` int(11) unsigned NOT NULL default '51234',
  `tsUDPPort` int(11) unsigned NOT NULL default '8767',
  PRIMARY KEY  (`tsId`),
  UNIQUE KEY `address` (`tsAddr`,`tsUDPPort`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_server_load`
--

CREATE TABLE IF NOT EXISTS `hlstats_server_load` (
  `server_id` tinyint(4) NOT NULL default '0',
  `timestamp` int(11) NOT NULL default '0',
  `act_players` tinyint(2) NOT NULL default '0',
  `min_players` tinyint(2) NOT NULL default '0',
  `max_players` tinyint(2) NOT NULL default '0',
  `map` varchar(64) default NULL,
  `uptime` varchar(10) NOT NULL default '0',
  `fps` varchar(10) NOT NULL default '0',
  KEY `server_id` (`server_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Teams`
--

ALTER TABLE `hlstats_Teams`
ADD COLUMN `playerlist_bgcolor` varchar(7) default NULL,
ADD COLUMN `playerlist_color` varchar(7) default NULL,
ADD COLUMN `playerlist_index` tinyint(3) unsigned NOT NULL default '0';

--
-- Dumping data for table `hlstats_Teams`
--

INSERT IGNORE INTO `hlstats_Teams` (`game`, `code`, `name`, `hidden`, `playerlist_bgcolor`, `playerlist_color`, `playerlist_index`) VALUES
('css','TERRORIST','Terrorist','0','#FFD5D5','#FF2D2D',1),
('css','CT','Counter-Terrorist','0','#D2E8F7','#0080C0',2),
('hl2mp','Combine','The Combine','0','#D2E8F7','#0080C0',1),
('hl2mp','Rebels','Rebel Forces','0','#FFD5D5','#FF2D2D',2),
('tf','Red','The RED','','#FFD5D5','#FF2D2D',2),
('tf','Blue','The BLU','','#D2E8F7','#0080C0',1),
('hl2ctf','Combine','Combine','0','#D2E8F7','#0080C0',1),
('hl2ctf','Rebels','Rebels','0','#FFD5D5','#FF2D2D',2),
('dods','Allies','Allies','0','#C1FFC1','#006600',2),
('dods','Axis','Axis','0','#FFD5D5','#FF2D2D',1),
('insmod','U.S. Marines','U.S. Marines','0','#D2E8F7','#0080C0',2),
('insmod','Iraqi Insurgents','Iraqi Insurgents','0','#FFD5D5','#FF2D2D',1),
('ff', '#FF_TEAM_YELLOW', 'Yellow Team', '0', '#F7FF89', '#808700', 3),
('ff', '#FF_TEAM_GREEN', 'Green Team', '0', '#93FF89', '#4B8246', 4),
('ff', 'Defenders', 'Defenders', '0', '#D2E8F7','#0080C0', 5),
('ff', 'Attackers', 'Attackers', '0', '#FFD5D5', '#FF2D2D', 6),
('ff', '#FF_TEAM_RED', 'Red Team', '0', '#FFD5D5', '#FF2D2D', 1),
('ff', '#FF_TEAM_BLUE', 'Blue Team', '0', '#D2E8F7','#0080C0', 2),
('hidden','Hidden','Subject 617', '0', '#F7FF89', '#808700', 1),
('hidden','IRIS','I.R.I.S.', '0', '#D2E8F7','#0080C0', 2),
('zps','Undead','Undead', '0', '#F7FF89', '#808700', 1),
('zps','Survivor','Survivors', '0', '#D2E8F7','#0080C0', 2),
('aoc','The Mason Order','The Mason Order','','#FFD5D5','#FF2D2D',2),
('aoc','Agathia Knights','Agathia Knights','','#D2E8F7','#0080C0',1),
('cstrike','TERRORIST','Terrorist','0','#FFD5D5','#FF2D2D',1),
('cstrike','CT','Counter-Terrorist','0','#D2E8F7','#0080C0',2),
('tfc','Blue','Blue','0','#D2E8F7','#0080C0',1),
('tfc','Red','Red','0','#FFD5D5','#FF2D2D',2),
('tfc','#Hunted_team1','(Hunted) VIP','0','#FFD5D5','#FF2D2D',5),
('tfc','#Hunted_team2','(Hunted) Bodyguards','0','#FFD5D5','#FF2D2D',6),
('tfc','#Hunted_team3','(Hunted) Assassins','0','#D2E8F7','#0080C0',7),
('tfc','#Dustbowl_team1','Attackers','0','#D2E8F7','#0080C0',8),
('tfc','#Dustbowl_team2','Defenders','0','#FFD5D5','#FF2D2D',9),
('dod','Allies','Allies','0','#C1FFC1','#006600',2),
('dod','Axis','Axis','0','#FFD5D5','#FF2D2D',1),
('ns','alien1team','Aliens','0','#F7FF89','#808700',2),
('ns','marine1team','Marines','0','#D2E8F7','#0080C0',1),
('l4d', 'Survivor', 'Survivors', '0', '#E0E4E5', '#4B6168', 1),
('l4d', 'Infected', 'Infected', '0', '#E5D5D5', '#68090B', 2),
('fof', 'DESPERADOS', 'Desparados', '0', '#D2E8F7','#0080C0', 1),
('fof', 'VIGILANTES', 'Vigilantes', '0', '#FFD5D5','#FF2D2D', 2),
('ges', 'MI6', 'MI6', '0', '#D2E8F7','#0080C0', 1),
('ges', 'Janus', 'Janus', '0', '#FFD5D5','#FF2D2D', 2);

-- --------------------------------------------------------

--
-- Table structure for table `hlstats_Trend`
--

CREATE TABLE IF NOT EXISTS `hlstats_Trend` (
  `timestamp` int(11) NOT NULL default '0',
  `game` varchar(32) NOT NULL default '',
  `players` int(11) NOT NULL default '0',
  `kills` int(11) NOT NULL default '0',
  `headshots` int(11) NOT NULL default '0',
  `servers` int(11) NOT NULL default '0',
  `act_slots` int(11) NOT NULL default '0',
  `max_slots` int(11) NOT NULL default '0',
  KEY `game` (`game`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


--
-- Table structure for table `hlstats_Weapons`
--

ALTER TABLE `hlstats_Weapons`
ADD COLUMN `kills` int(10) unsigned NOT NULL default '0',
ADD COLUMN `headshots` int(10) unsigned NOT NULL default '0',
ADD KEY `code` (`code`),
ADD KEY `modifier` (`modifier`);

--
-- Dumping data for table `hlstats_Weapons`
--

INSERT IGNORE INTO `hlstats_Weapons` (`game`, `code`, `name`, `modifier`) VALUES
('tf', 'tf_projectile_rocket', 'Rocket', 1.00),
('tf', 'sniperrifle', 'Sniper Rifle', 1.00),
('tf', 'minigun', 'Minigun (Sasha)', 1.00),
('tf', 'obj_sentrygun', 'Sentry Gun', 1.00),
('tf', 'knife', 'Knife', 2.00),
('tf', 'scattergun', 'Scatter Gun', 1.25),
('tf', 'tf_projectile_pipe', 'Pipe', 1.00),
('tf', 'flamethrower', 'Flame', 1.00),
('tf', 'tf_projectile_pipe_remote', 'Remote Pipe', 1.00),
('tf', 'shotgun_primary', 'Engy Shotgun', 1.00),
('tf', 'smg', 'Submachine Gun', 1.00),
('tf', 'shotgun_soldier', 'Soldier Shotgun', 1.00),
('tf', 'syringegun_medic', 'Syringe Gun', 1.00),
('tf', 'revolver', 'Revolver', 1.00),
('tf', 'shotgun_pyro', 'Pyro Shotgun', 1.00),
('tf', 'world', 'World', 1.00),
('tf', 'bat', 'Bat', 2.00),
('tf', 'wrench', 'Wrench', 2.00),
('tf', 'bonesaw', 'Bone Saw', 2.00),
('tf', 'shotgun_hwg', 'Heavy Shotgun', 1.00),
('tf', 'club', 'Club', 2.00),
('tf', 'pistol_scout', 'Scout Pistol', 1.50),
('tf', 'pistol', 'Engy Pistol', 1.00),
('tf', 'bottle', 'Bottle', 2.00),
('tf', 'shovel', 'Shovel', 2.00),
('tf', 'fireaxe', 'Fire Axe', 2.00),
('tf', 'fists', 'Fists', 2.00),
('tf', 'axtinguisher', 'Axtinguisher', 2.00),
('tf', 'backburner', 'Backburner', 1.00),
('tf', 'blutsauger', 'Blutsauger', 1.50),
('tf', 'deflect_flare', 'Deflected Flare', 20.00),
('tf', 'deflect_promode', 'Deflected Grenade', 2.00),
('tf', 'deflect_rocket', 'Deflected Rocket', 2.00),
('tf', 'deflect_sticky', 'Deflected Sticky', 2.00),
('tf', 'flaregun', 'Flaregun', 2.00),
('tf', 'natascha', 'Minigun (Natascha)', 1.00),
('tf', 'gloves', 'K.G.B.', 2.00),
('tf', 'taunt_heavy', 'Heavy taunt', 5.00),
('tf', 'taunt_pyro', 'Hadouken', 5.00),
('tf', 'ubersaw', 'Ubersaw', 2.00),
('css','knife','Bundeswehr Advanced Combat Knife',2.00),
('css','usp','H&K USP .45 Tactical',1.40),
('css','glock','Glock 18 Select Fire',1.40),
('css','deagle','Desert Eagle .50AE',1.20),
('css','p228','Sig Sauer P-228',1.50),
('css','m3','Benelli M3 Super 90 Combat',1.20),
('css','xm1014','Benelli/H&K M4 Super 90 XM1014',1.10),
('css','mp5navy','H&K MP5-Navy',1.20),
('css','tmp','Steyr Tactical Machine Pistol',1.50),
('css','p90','FN P90',1.20),
('css','m4a1','Colt M4A1 Carbine',1.00),
('css','ak47','Kalashnikov AK-47',1.00),
('css','sg552','Sig Sauer SG-552 Commando',1.00),
('css','scout','Steyr Scout',1.10),
('css','awp','Arctic Warfare Magnum (Police)',1.00),
('css','g3sg1','H&K G3/SG1 Sniper Rifle',0.80),
('css','m249','M249 PARA Light Machine Gun',1.20),
('css','hegrenade','High Explosive Grenade',1.80),
('css','flashbang','Flashbang',5.00),
('css','elite','Dual Beretta 96G Elite',1.40),
('css','aug','Steyr Aug',1.00),
('css','mac10','Ingram MAC-10',1.50),
('css','fiveseven','FN Five-Seven',1.50),
('css','ump45','H&K UMP45',1.20),
('css','sg550','Sig SG-550 Sniper',0.80),
('css','famas','Fusil Automatique',1.00),
('css','galil','Galil',1.10),
('css','smokegrenade_projectile','Smoke Grenade',5.00),
('css','PROP_PHYSICS','Rare Physics kill',10.00),
('hl2mp','env_explosion','Explosion',2.70),
('hl2mp','player','pTelefrag',10.00),
('hl2mp','physbox','bTelefrag',7.20),
('hl2mp','physics','Physics',7.00),
('hl2mp','crowbar','Crowbar',15.00),
('hl2mp','stunstick','Stun Stick',15.00),
('hl2mp','pistol','USP Match',10.00),
('hl2mp','357','.357 Magnum',4.30),
('hl2mp','smg1','Sub Machine Gun',0.00),
('hl2mp','smg1_grenade','Impact Grenade',2.50),
('hl2mp','ar2','Combine Assault Rifle',1.00),
('hl2mp','combine_ball','Combine Ball',2.40),
('hl2mp','shotgun','Shotgun',3.80),
('hl2mp','crossbow_bolt','Crossbow',7.30),
('hl2mp','rpg_missile','Rocket Propelled Grenade',0.00),
('hl2mp','grenade_frag','Frag Grenade',3.70),
('hl2mp','slam','Slam',4.60),
('hl2mp','physcannon','Physics Cannon',2.70),
('hl2ctf','stunstick','Stun Stick',2.50),
('hl2ctf','Crowbar','Crowbar',2.50),
('hl2ctf','crossbow_bolt','Crossbow',1.75),
('hl2ctf','Slam','S.L.A.M',1.80),
('hl2ctf','Pistol','USP Match',1.75),
('hl2ctf','grenade_frag','Grenade',1.75),
('hl2ctf','combine_ball','Combine Ball',1.50),
('hl2ctf','physcannon','Gravity Gun',1.15),
('hl2ctf','Shotgun','Shotgun',1.10),
('hl2ctf','357','.357 Magnum',1.10),
('hl2ctf','rpg_missile','Rocket Propelled Grenade',1.00),
('hl2ctf','ar2','Combine Assault Rifle',1.00),
('hl2ctf','smg1','Sub Machine Gun',1.00),
('hl2ctf','env_explosion','Explosion',1.00),
('hl2ctf','ctf_combine_turret','Combine Turret',1.25),
('hl2ctf','ctf_rebel_turret','Rebel Turret',1.25),
('hl2ctf','ctf_oicw','OICW Rifle',1.00),
('hl2ctf','ctf_sniper','Sniper Rifle',1.10),
('hl2ctf','grenade_ctf_oicw_airburst','OICW Grenade',1.20),
('hl2ctf','ctf_alyxgun','Alyx Gun',1.15),
('hl2ctf','smg1_grenade','SMG Grenade',1.10),
('dods','k98','Mauser Kar 98k',1.30),
('dods','mp40','MP40 Machine Pistol',1.25),
('dods','k98_scoped','Mauser Karbiner k98 Sniper Rifle',1.50),
('dods','mp44','MP44 Assault Rifle',1.35),
('dods','colt','Colt .45 model 1911',1.60),
('dods','riflegren_us','M1 Garand Rifle',1.30),
('dods','thompson','Thompson Submachine Gun',1.25),
('dods','spring','Springfield Rifle with Scope',1.50),
('dods','bar','BAR Browning Automatic Rifle',1.20),
('dods','frag_us','U.S. Grenade',1.00),
('dods','m1carbine','M1 Carbine',1.20),
('dods','30cal','.30 Caliber Machine Gun',1.25),
('dods','frag_ger','German Grenade',1.00),
('dods','spade','Spade Entrenchment Tool',3.00),
('dods','amerknife','U.S. Issue Knife',3.00),
('dods','bazooka','Bazooka',2.25),
('dods','pschreck','Panzerschreck',2.25),
('dods','riflegren_ger','German Rifle Grenade',1.30),
('dods','garand','M1 Garand Rifle',1.30),
('dods','p38','Pistol 38',1.50),
('dods','c96','Pistol c96',1.50),
('dods','punch','Butt Stock Hit',3.00),
('dods','mg42','MG42 Machine Gun',1.20),
('dods','smoke_ger','German Smoke Grenade',5.00),
('dods','smoke_us','U.S. Smoke Grenade',5.00),
('dods','dod_bomb_target','TNT Bomb',1.00),
('insmod','weapon_makarov','Soviet Makarov Combat Pistol',1.5),
('insmod','weapon_m9','9mm Beretta Pistol',1.5),
('insmod','world','RPG or Grenade',1.4),
('insmod','weapon_sks','Simonov SKS carbine',1.3),
('insmod','weapon_m1014','M1014 Service Combat Shotgun',1.2),
('insmod','weapon_toz','TOZ Rifle',1.1),
('insmod','weapon_svd','Dragunov Sniper Rifle',1.1),
('insmod','weapon_rpk','RPK Ruchnoy Pulemyot Kalashnikova',1.1),
('insmod','weapon_m249','M249 SAW (Squad Automatic Weapon)',1.1),
('insmod','weapon_m16m203','M16 carbine M203 Grenade Launcher',1.1),
('insmod','weapon_l42a1','Enfield L42A1 Military Sniper Rifle',1.1),
('insmod','weapon_m4med','M4 Medium Range Rifle',1),
('insmod','weapon_m4','M4 Carbine Rifle',1),
('insmod','weapon_m16a4','M16A4 Infantry Rifle',1),
('insmod','weapon_m14','Colt M14 Carbine',1),
('insmod','weapon_fnfal','FN FAL Automatic Rifle',1),
('insmod','weapon_aks74u','AKS-74U Awtomat Kalaschnikowa Ukorochennyj',1),
('insmod','weapon_ak47','AK-47 Awtomat Kalaschnikowa',1),
('ff', 'weapon_railgun', 'Railgun', 1.00),
('ff', 'weapon_tranq', 'Tranq Gun', 1.00),
('ff', 'weapon_medkit', 'Medkit', 1.00),
('ff', 'weapon_spanner', 'Spanner', 1.00),
('ff', 'weapon_crowbar', 'Crowbar', 1.00),
('ff', 'weapon_shotgun', 'Shotgun', 1.00),
('ff', 'grenade_napalm', 'Napalm Grenade', 1.00),
('ff', 'weapon_ic', 'IC', 1.00),
('ff', 'grenade_nail', 'Nail Grenade', 1.00),
('ff', 'weapon_supershotgun', 'Super Shotgun', 1.00),
('ff', 'weapon_supernailgun', 'Super Nailgun', 1.00),
('ff', 'weapon_sniperrifle', 'Sniper Rifle', 1.00),
('ff', 'weapon_rpg', 'Rocket Launcher', 1.00),
('ff', 'weapon_pipelauncher', 'Pipe Launcher', 1.00),
('ff', 'weapon_knife', 'Knife', 1.00),
('ff', 'weapon_grenadelauncher', 'Grenade Launcher', 1.00),
('ff', 'weapon_flamethrower', 'Flamethrower', 1.00),
('ff', 'Dispenser', 'Dispenser', 1.00),
('ff', 'weapon_autorifle', 'Auto Rifle', 1.00),
('ff', 'weapon_assaultcannon', 'Assault Cannon', 1.00),
('ff', 'SentryGun', 'Sentry Gun', 1.00),
('ff', 'grenade_normal', 'Frag Grenade', 1.00),
('ff', 'grenade_mirv', 'Mirv Grenade', 1.00),
('ff', 'grenade_emp', 'Emp Grenade', 1.00),
('ff', 'DETPACK', 'Detpack', 1.00),
('ff', 'weapon_umbrella','Umbrella', 10.00),
('ff', 'grenade_gas','Gas Grenade', 1.00),
('ff', 'weapon_tommygun', 'Tommygun', 1.00),
('ff', 'weapon_nailgun', 'Nailgun', 1.00),
('hidden', 'fn2000','FN2000 Assault Rifle',1.50),
('hidden', 'p90','FN P90 Sub Machine Gun',2.00),
('hidden', 'shotgun','Remington 870 MCS Shotgun',2.00),
('hidden', 'fn303','FN303 Less Lethal Launcher',2.00),
('hidden', 'pistol','FN FiveSeven Pistol',3.00),
('hidden', 'pistol2','FNP-9 Pistol',3.00),
('hidden', 'knife','Kabar D2 Knife',2.50),
('hidden', 'grenade_projectile','Pipe Bomb',2.00),
('hidden', 'physics','Physics',3.00),
('zps', 'arms','Zombie',1),
('zps', 'carrierarms','Carrier',1),
('zps', 'ak47','AK-47',1),
('zps', 'mp5','MP5',1),
('zps', 'revolver','Revolver',1),
('zps', 'glock','Glock 17',1),
('zps', 'glock18c','Glock 18c',1),
('zps', 'ppk','Walther PPK',1),
('zps', 'usp','Heckler & Kock USP',1),
('zps', '870','Remington 870',1),
('zps', 'supershorty','Mossberg Super Shorty',1),
('zps', 'grenade_frag','Grenade',1),
('zps', 'sledgehammer','Sledgehammer',1.5),
('zps', 'crowbar','Crowbar',1.5),
('zps', 'chair','Chair',1.5),
('zps', 'keyboard','Keyboard',1.5),
('zps', 'plank','Wooden Plank',1.5),
('zps', 'shovel','Shovel',1.5),
('zps', 'golf','Golf Club',1.5),
('zps', 'machete','Machete',1.5),
('zps', 'fryingpan','Frying Pan',1.5),
('zps', 'spanner','Wrench',1.5),
('zps', 'axe','Axe',1.5),
('zps', 'tireiron','Tire Iron',1.5),
('zps', 'hammer','Hammer',1.5),
('zps', 'broom','Broom',1.5),
('zps', 'pot','Pot',1.5),
('zps', 'world','World',1.5),
('zps', 'physics','Physics',1.5),
('zps', 'racket','Tennis Racket',1.5),
('zps', 'torque','Torque',1.0),
('zps', 'winchester','Winchester Double Barreled Shotgun',1),
('aoc', 'Flamberge','Flamberge',1),
('aoc', 'Longsword','Longsword',1),
('aoc', 'Glaive','Glaive',1),
('aoc', 'Dual Daggers','Dual Daggers',1),
('aoc', 'Flamberge & Kite Shield', 'Flamberge & Kite Shield', 1),
('aoc', 'world','World',1),
('aoc', 'chivalry','Chivalry',1),
('aoc', 'Shortsword','Shortsword',1),
('aoc', 'Warhammer','Warhammer',1),
('aoc', 'Mace','Mace',1),
('aoc', 'Mace & Buckler','Mace & Buckler',1),
('aoc', 'Broadsword & Evil Shield', 'Mason Broadsword & Shield', 1),
('aoc', 'Crossbow','Crossbow',1),
('aoc', 'Longbow','Longbow',1),
('aoc', 'Longsword & Kite Shield', 'Longsword & Kite Shield', 1),
('aoc', 'Broadsword & Good Shield', 'Knights Broadsword & Shield', 1),
('aoc', 'Hatchet', 'Hatchet', 1),
('aoc', 'Double Axe','Battle Axe',1),
('aoc', 'Flail & Evil Shield','Mason Flail & Shield',1),
('aoc', 'Flail & Good Shield','Knights Flail & Shield',1),
('aoc', 'Javelin', 'Javelin', 1),
('aoc', 'Spear & Buckler', 'Spear & Buckler', 1),
('aoc', 'Dagger', 'Dagger', 1),
('aoc', 'Broadsword', 'Broadsword', 1),
('aoc', 'Throwing Knife', 'Throwing Knife', 1),
('aoc', 'Spiked Mace', 'Spiked Mace', 1),
('aoc', 'Spiked Mace & Buckler','Spiked Mace & Buckler',1),
('aoc', 'Halberd', 'Halberd', 1),
('aoc', 'env_explosion', 'Fire', 1),
('aoc', 'Oilpot', 'Oil Pot', 1),
('cstrike','knife','Bundeswehr Advanced Combat Knife',1.80),
('cstrike','usp','H&K USP .45 Tactical',1.50),
('cstrike','glock18','Glock 18 Select Fire',1.50),
('cstrike','deagle','Desert Eagle .50AE',1.50),
('cstrike','p228','Sig Sauer P-228',1.50),
('cstrike','m3','Benelli M3 Super 90 Combat',1.40),
('cstrike','xm1014','Benelli/H&K M4 Super 90 XM1014',1.40),
('cstrike','mp5navy','H&K MP5-Navy',1.25),
('cstrike','tmp','Steyr Tactical Machine Pistol',1.25),
('cstrike','p90','FN P90',1.25),
('cstrike','m4a1','Colt M4A1 Carbine',1.00),
('cstrike','ak47','Kalashnikov AK-47',1.00),
('cstrike','sg552','Sig Sauer SG-552 Commando',1.00),
('cstrike','scout','Steyr Scout',1.60),
('cstrike','awp','Arctic Warfare Magnum (Police)',1.40),
('cstrike','g3sg1','H&K G3/SG1 Sniper Rifle',1.40),
('cstrike','m249','M249 PARA Light Machine Gun',0.80),
('cstrike','grenade','High Explosive Grenade',1.80),
('cstrike','elite','Dual Beretta 96G Elite',1.50),
('cstrike','aug','Steyr Aug',1.00),
('cstrike','mac10','Ingram MAC-10',1.25),
('cstrike','fiveseven','FN Five-Seven',1.50),
('cstrike','ump45','H&K UMP45',1.25),
('cstrike','sg550','Sig SG-550 Sniper',1.70),
('cstrike','famas','Fusil Automatique',1.00),
('cstrike','galil','Galil',1.00),
('tfc','sniperrifle','Sniper Rifle',1.00),
('tfc','normalgrenade','Normal Grenade',1.10),
('tfc','ac','Autocannon',1.00),
('tfc','rocket','Rocket Launcher',1.00),
('tfc','sentrygun','Sentry Gun',1.00),
('tfc','supershotgun','Super Shotgun',1.15),
('tfc','autorifle','Sniper Rifle (Auto Mode)',1.20),
('tfc','empgrenade','EMP Grenade',1.25),
('tfc','mirvgrenade','MIRV Grenade',1.25),
('tfc','gl_grenade','Grenade Launcher',1.35),
('tfc','pipebomb','Pipebomb',1.35),
('tfc','timer','Infection Timer',0.00),
('tfc','infection','Infection',1.50),
('tfc','flames','Flame Thrower',1.60),
('tfc','shotgun','Shotgun',1.60),
('tfc','nails','Nail Gun',1.70),
('tfc','nailgrenade','Nail Grenade',1.70),
('tfc','supernails','Super Nail Gun',1.65),
('tfc','axe','Crowbar',1.80),
('tfc','medikit','Medikit',1.85),
('tfc','napalmgrenade','Napalm Grenade',1.70),
('tfc','detpack','Detpack',1.80),
('tfc','gasgrenade','Gas Grenade',1.90),
('tfc','spanner','Spanner',2.00),
('tfc','caltrop','Caltrops',2.00),
('tfc','railgun','Rail Gun',1.85),
('tfc','building_dispenser','Dispenser',2.00),
('dod', 'k43', 'Karbiner 43', '1.50'),
('dod', 'luger', 'Luger 08 Pistol', '1.50'),
('dod', 'kar', 'Mauser Kar 98k', '1.30'),
('dod', 'mp40', 'MP40 Machine Pistol', '1.25'),
('dod', 'scopedkar', 'Mauser Karbiner 98k Sniper Rifle', '1.50'),
('dod', 'mp44', 'MP44 Assault Rifle', '1.35'),
('dod', 'colt', 'Colt .45 model 1911', '1.60'),
('dod', 'garand', 'M1 Garand Rifle', '1.30'),
('dod', 'thompson', 'Thompson Submachine Gun', '1.25'),
('dod', 'spring', 'Springfield Rifle with Scope', '1.50'),
('dod', 'bar', 'BAR Browning Automatic Rifle', '1.20'),
('dod', 'grenade', 'U.S. Grenade', '1.00'),
('dod', 'enf_bayonet', 'Enfield Bayonet', '2.50'),
('dod', 'bren', 'Bren Machine Gun', '1.25'),
('dod', 'm1carbine', 'M1 Carbine', '1.20'),
('dod', 'greasegun', 'Greasegun', '1.30'),
('dod', '30cal', '.30 Caliber Machine Gun', '1.25'),
('dod', 'mg42', 'MG42 Machine Gun', '1.20'),
('dod', 'grenade2', 'German Grenade', '1.00'),
('dod', 'spade', 'Spade Entrenchment Tool', '3.00'),
('dod', 'gerknife', 'German Knife', '3.00'),
('dod', 'fg42', 'FG42 Paratroop Rifle', '1.25'),
('dod', 'world', 'worldspawn', '0.00'),
('dod', 'amerknife', 'U.S. Issue Knife', '3.00'),
('dod', 'bayonet', 'Karbiner Bayonet', '2.40'),
('dod', 'mg34', 'MG34 Machine Gun', '1.20'),
('dod', 'brit_knife', 'British Knife', '3.00'),
('dod', 'mortar', 'Mortar', '1.00'),
('dod', 'fcarbine', 'F1 Carbine', '1.35'),
('dod', 'scoped_fg42', 'Scoped FG42', '1.30'),
('dod', 'bazooka', 'Bazooka', '2.25'),
('dod', 'enfield', 'Enfield Rifle', '1.35'),
('dod', 'garandbutt', 'Butt Stock Hit', '3.00'),
('dod', 'mills_bomb', 'British Grenade', '1.00'),
('dod', 'piat', 'Piat', '2.25'),
('dod', 'pschreck', 'Panzerschreck', '2.25'),
('dod', 'scoped_enfield', 'Scoped Enfield', '1.50'),
('dod', 'sten', 'Sten Submachine Gun', '1.25'),
('dod', 'webley', 'Webley Revolver', '1.60'),
('ns','welder','Marine Welder','3.00'),
('ns','item_mine','Marine Mine','1.00'),
('ns','handgrenade','Marine Hand Grenade','1.00'),
('ns','grenade','Marine Grenade Launcher','1.00'),
('ns','knife','Marine Knife','4.00'),
('ns','pistol','Marine Pistol','2.00'),
('ns','machinegun','Marine Light Machine Gun','1.25'),
('ns','shotgun','Marine Shotgun','1.00'),
('ns','heavymachinegun','Marine Heavy Machine Gun','1.00'),
('ns','turret','Marine Turret','.75'),
('ns','siegeturret','Marine Siege Turret','1.00'),
('ns','resourcetower','Electrified Marine Resource Tower','2.00'),
('ns','team_turretfactor','Electric Marine Turret Factory','2.00'),
('ns','team_advturretfactor','Electrified Marine Advance Turret Factory','2.00'),
('ns','acidrocket','Fade Acid Rocket','1.00'),
('ns','bitegun','Skulk Bite','1.25'),
('ns','charge','Onos Charge','1.00'),
('ns','claws','Onos Gore','1.00'),
('ns','divinewind','Skulk Xenocide','1.00'),
('ns','leap','Skulk Leap','2.00'),
('ns','bite2gun','Lerk Bite','2.00'),
('ns','spitgunspit','Gorge Spit','2.00'),
('ns','sporegunprojectile','Lerk Spores','1.00'),
('ns','swipe','Fade Slash','1.00'),
('ns','healingspray','Gorge Health Spray','3.00'),
('ns','parasite','Skulk Parasite','3.00'),
('ns','devour','Onos Devour','2.00'),
('ns','offensechamber','Offense Chamber','1.00'),
('l4d', 'rifle', 'M16 Assault Rifle', 1.00),
('l4d', 'autoshotgun', 'Auto Shotgun', 1.00),
('l4d', 'pumpshotgun', 'Pump Shotgun', 1.30),
('l4d', 'smg', 'Uzi', 1.20),
('l4d', 'dual_pistols', 'Dual Pistols', 1.60),
('l4d', 'pipe_bomb', 'Pipe Bomb', 1.00),
('l4d', 'hunting_rifle', 'Hunting Rifle', 1.00),
('l4d', 'pistol', 'Pistol', 2.00),
('l4d', 'prop_minigun', 'Mounted Machine Gun', 1.20),
('l4d', 'tank_claw', 'Tank\'s Claws', 3.00),
('l4d', 'hunter_claw', 'Hunter\'s Claws', 3.00),
('l4d', 'smoker_claw', 'Smoker\'s Claws', 3.00),
('l4d', 'boomer_claw', 'Boomer\'s Claws', 3.00),
('l4d', 'inferno', 'Molotov/Gas Can Fire', 1.20),
('l4d', 'infected', 'Infected Horde', 1.00),
('l4d', 'witch', 'Witch\'s Claws', 1.00),
('l4d', 'entityflame', 'Blaze', 3),
('l4d', 'first_aid_kit', 'First Aid Kit Smash', 1.5),
('l4d', 'gascan', 'Gas Can Smash', 1.5),
('l4d', 'molotov', 'Molotov Smash', 1.5),
('l4d', 'pain_pills', 'Pain Pills Smash', 1.5),
('l4d', 'player', 'Player', 1),
('l4d', 'propanetank', 'Propane Tank Smash', 1.5),
('l4d', 'tank_rock', 'Tank\'s Rock', 1.5),
('l4d', 'oxygentank', 'Oxygen Tank Smash', 1.5),
('l4d', 'world', 'World', 1),
('l4d', 'prop_physics', 'Prop Physics', 1),
('fof', 'deringer', 'Deringer', 1),
('fof', 'carbine', 'Carbine', 1),
('fof', 'coltnavy', 'Colt Navy', 1),
('fof', 'bow', 'Bow', 1),
('fof', 'arrow', 'Arrow', 1),
('fof', 'sharps', 'Sharps', 1),
('fof', 'coachgun', 'Coach Gun', 1),
('fof', 'peacemaker', 'Peacemaker', 1),
('fof', 'knife', 'Knife', 2),
('fof', 'physics', 'Exploding Barrel', 1),
('fof', 'dualderinger', 'Dual Deringers', 1),
('fof', 'thrown_axe', 'Thrown Axe', 3),
('fof', 'arrow_fiery', 'Fire Arrow', 2),
('fof', 'thrown_knife', 'Thrown Knife', 3),
('fof', 'dualnavy', 'Dual Colt Navys', 1),
('fof', 'dynamite', 'Dynamite', 3),
('fof', 'explosive_arrow', 'Explosive Arrow', 2),
('fof', 'fists', 'Fists', 2),
('fof', 'axe', 'Axe', 2),
('fof', 'dualpeacemaker', 'Dual Peacemakers', 1),
('fof', 'henryrifle', 'Henry Rifle', 1),
('ges', '#GE_ProximityMine', 'Proximity Mines', 1),
('ges', '#GE_AutoShotgun', 'Automatic Shotgun', 1),
('ges', '#GE_Phantom', 'Phantom', 1),
('ges', '#GE_Knife', 'Hunting Knife', 1),
('ges', '#GE_D5K', 'D5K Deutsche', 1),
('ges', '#GE_SilverPP7', 'Silver PP7', 1),
('ges', '#GE_DD44', 'DD44', 1),
('ges', '#GE_Grenade', 'Grenade', 1),
('ges', '#GE_CougarMagnum', 'Cougar Magnum', 1),
('ges', '#GE_D5K_SILENCED', 'D5K (Silenced)', 1),
('ges', '#GE_Shotgun', 'Shotgun', 1),
('ges', '#GE_Klobb', 'Klobb', 1),
('ges', '#GE_RCP90', 'RC-P90', 1),
('ges', '#GE_RemoteMine', 'Remote Mines', 1),
('ges', '#GE_KF7Soviet', 'KF7 Soviet', 1),
('ges', '#GE_ZMG', 'ZMG', 1),
('ges', '#GE_SniperRifle', 'Sniper Rifle', 1),
('ges', '#GE_GoldPP7', 'Golden PP7', 1),
('ges', '#GE_AR33', 'US AR33 Assault', 1),
('ges', '#GE_GoldenGun', 'Golden Gun', 1),
('ges', '#GE_ThrowingKnife', 'Throwing Knives', 1),
('ges', '#GE_PP7', 'PP7', 1),
('ges', '#GE_PP7_SILENCED', 'PP7 (Silenced)', 1),
('ges', '#GE_TimedMine', 'Timed Mines', 1),
('ges', '#GE_MilitaryLaser', 'Military Laser', 1),
('ges', '#GE_GrenadeLauncher', 'Grenade Launcher', 1),
('ges', '#GE_Rocket', 'Rocket Launcher', 1),
('ges', '#GE_Taser', 'Taser', 1),
('ges', '#GE_SniperButt', 'Sniper Butt', 1),
('ges', '#GE_Slapper', 'Slappers', 1),
('ges', '#GE_RocketLauncher', 'Rocket Launcher', 1);