CREATE TABLE `geoLiteCity_Blocks` (
  `startIpNum` bigint(11) unsigned NOT NULL default '0',
  `endIpNum` bigint(11) unsigned NOT NULL default '0',
  `locId` bigint(11) unsigned NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `geoLiteCity_Location` (
  `locId` bigint(11) unsigned NOT NULL default '0',
  `country` varchar(2) NOT NULL default '',
  `region` varchar(50) default NULL,
  `city` varchar(50) default NULL,
  `postalCode` varchar(10) default NULL,
  `latitude` decimal(14,4) default NULL,
  `longitude` decimal(14,4) default NULL,
  PRIMARY KEY  (`locId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `hlstats_Actions` 
CHANGE `game` `game` VARCHAR(64) NOT NULL default '',
CHANGE `code` `code` VARCHAR(64) NOT NULL default '',
CHANGE `team` `team` varchar(64) NOT NULL default '',
ADD COLUMN `object` varchar(64) NOT NULL default '',
ADD COLUMN `event` varchar(64) NOT NULL default '',
DROP KEY `gamecode`,
ADD UNIQUE KEY `gamecode` (`game`,`code`,`object`,`event`, `team`);
  
UPDATE `hlstats_Actions` SET `code` = 'builtobject', `object`='OBJ_TELEPORTER_EXIT' WHERE `code`='builtobject_teleporter_exit';
UPDATE `hlstats_Actions` SET `code` = 'builtobject', `object`='OBJ_TELEPORTER_ENTRANCE' WHERE `code`='builtobject_teleporter_entrance';
UPDATE `hlstats_Actions` SET `code` = 'builtobject', `object`='OBJ_DISPENSER' WHERE `code`='builtobject_dispenser';
UPDATE `hlstats_Actions` SET `code` = 'builtobject', `object`='OBJ_SENTRYGUN' WHERE `code`='builtobject_sentrygun';
UPDATE `hlstats_Actions` SET `code` = 'builtobject', `object`='OBJ_ATTACHMENT_SAPPER' WHERE `code`='builtobject_attachment_sapper';
UPDATE `hlstats_Actions` SET `code` = 'killedobject', `object`='OBJ_TELEPORTER_EXIT' WHERE `code`='killedobject_teleporter_exit';
UPDATE `hlstats_Actions` SET `code` = 'killedobject', `object`='OBJ_TELEPORTER_ENTRANCE' WHERE `code`='killedobject_teleporter_entrance';
UPDATE `hlstats_Actions` SET `code` = 'killedobject', `object`='OBJ_DISPENSER' WHERE `code`='killedobject_dispenser';
UPDATE `hlstats_Actions` SET `code` = 'killedobject', `object`='OBJ_SENTRYGUN' WHERE `code`='killedobject_sentrygun';
UPDATE `hlstats_Actions` SET `code` = 'killedobject', `object`='OBJ_ATTACHMENT_SAPPER' WHERE `code`='killedobject_attachment_sapper';
UPDATE `hlstats_Actions` SET `code` = 'owner_killedobject', `object`='OBJ_TELEPORTER_EXIT' WHERE `code`='owner_killedobject_teleporter_exit';
UPDATE `hlstats_Actions` SET `code` = 'owner_killedobject', `object`='OBJ_TELEPORTER_ENTRANCE' WHERE `code`='owner_killedobject_teleporter_entrance';
UPDATE `hlstats_Actions` SET `code` = 'owner_killedobject', `object`='OBJ_DISPENSER' WHERE `code`='owner_killedobject_dispenser';
UPDATE `hlstats_Actions` SET `code` = 'owner_killedobject', `object`='OBJ_SENTRYGUN' WHERE `code`='owner_killedobject_sentrygun';
UPDATE `hlstats_Actions` SET `code` = 'flagevent', `event`='picked up' WHERE `code`='flagevent_picked_up';
UPDATE `hlstats_Actions` SET `code` = 'flagevent', `event`='defended' WHERE `code`='flagevent_defended';
UPDATE `hlstats_Actions` SET `code` = 'flagevent', `event`='dropped' WHERE `code`='flagevent_dropped';
UPDATE `hlstats_Actions` SET `code` = 'flagevent', `event`='captured' WHERE `code`='flagevent_captured';
  
INSERT IGNORE INTO `hlstats_Actions` (`game`, `code`, `reward_player`, `reward_team`, `team`, `description`, `for_PlayerActions`, `for_PlayerPlayerActions`, `for_TeamActions`, `for_WorldActions`, `count`, `object`, `event`) VALUES
('tf', 'flagevent', 1, 0, '', 'Defended the flag', '1', '', '', '', 0, '', 'defended'),
('tf', 'flagevent', 5, 1, '', 'Captured the flag', '1', '', '', '', 0, '', 'captured'),
('tf', 'flagevent', -1, 0, '', 'Dropped the flag', '1', '', '', '', 0, '', 'dropped'),
('tf', 'flagevent', 1, 0, '', 'Picked up the flag', '1', '', '', '', 0, '', 'picked up'),
('tf', 'killedobject', 2, 0, '', 'Destroyed a teleporter exit', '1', '', '', '', 0, 'OBJ_TELEPORTER_EXIT', ''),
('tf', 'killedobject', 2, 0, '', 'Destroyed a teleporter entrance', '1', '', '', '', 0, 'OBJ_TELEPORTER_ENTRANCE', ''),
('tf', 'killedobject', 3, 0, '', 'Destroyed a dispenser', '1', '', '', '', 0, 'OBJ_DISPENSER', ''),
('tf', 'killedobject', 4, 0, '', 'Destroyed a sentry gun', '1', '', '', '', 0, 'OBJ_SENTRYGUN', ''),
('tf', 'builtobject', 2, 0, '', 'Built a teleporter exit', '1', '', '', '', 0, 'OBJ_TELEPORTER_EXIT', ''),
('tf', 'builtobject', 2, 0, '', 'Built a teleporter entrance', '1', '', '', '', 0, 'OBJ_TELEPORTER_ENTRANCE', ''),
('tf', 'builtobject', 3, 0, '', 'Built a dispenser', '1', '', '', '', 0, 'OBJ_DISPENSER', ''),
('tf', 'builtobject', 3, 0, '', 'Built a sentry gun', '1', '', '', '', 0, 'OBJ_SENTRYGUN', ''),
('tf', 'captureblocked', 1, 0, '', 'Capture Blocked', '1', '', '', '', 0, NULL, NULL),
('tf', 'pointcaptured', 5, 5, '', 'Point Captured', '1', '', '1', '', 0, NULL, NULL),
('tf', 'kill assist', 2, 0, '', 'Kill Assist', '1', '', '', '', 0, NULL, NULL),
('tf', 'builtobject', 2, 0, '', 'Attached a Sapper', '1', '', '', '', 0, 'OBJ_ATTACHMENT_SAPPER', ''),
('tf', 'killedobject', 1, 0, '', 'Removed a Sapper', '1', '', '', '', 0, 'OBJ_ATTACHMENT_SAPPER', ''),
('tf', 'chargedeployed', 1, 0, '', 'Ubercharge', '1', '', '', '', 0, NULL, NULL),
('tf', 'domination', 0, 0, '', 'Domination', '1', '', '', '', 0, NULL, NULL),
('tf', 'revenge', 5, 0, '', 'Revenge', '1', '', '', '', 0, NULL, NULL),
('tf', 'Round_Win', 0, 10, 'Blue', 'Round Win - Team Blue', '', '', '1', '0', 0, NULL, NULL),
('tf', 'Round_Win', 0, 10, 'Red', 'Round Win - Team Red', '', '', '1', '0', 0, NULL, NULL),
('tf', 'Mini_Round_Win', 0, 5, 'Blue', 'Mini-Round Win - Team Blue', '', '', '1', '0', 0, NULL, NULL),
('tf', 'owner_killedobject', -1, 0, '', 'Disassembled a sentry gun', '1', '', '', '', 0, 'OBJ_SENTRYGUN', ''),
('tf', 'owner_killedobject', -1, 0, '', 'Disassembled a dispenser', '1', '', '', '', 0, 'OBJ_DISPENSER', ''),
('tf', 'owner_killedobject', -1, 0, '', 'Disassembled a teleporter entrance', '1', '', '', '', 0, 'OBJ_TELEPORTER_ENTRANCE', ''),
('tf', 'owner_killedobject', -1, 0, '', 'Disassembled a teleporter exit', '1', '', '', '', 0, 'OBJ_TELEPORTER_EXIT', ''),
('tf', 'Mini_Round_Win', 0, 5, 'Red', 'Mini-Round Win - Team Red', '', '', '1', '0', 0, NULL, NULL),
('tf', 'backstab', 2, 0, '', 'Backstab Kill', '1', '', '', '', 0, NULL, NULL),
('tf', 'headshot', 2, 0, '', 'Headshot Kill', '1', '', '', '', 0, NULL, NULL),
('tf', 'cube_best_shot', 5, 0, '', 'Cube: Best Shot', '1', '', '', '', 0, NULL, NULL),
('tf', 'cube_distance', 5, 0, '', 'Cube: Most Distance', '1', '', '', '', 0, NULL, NULL),
('tf', 'cube_score', 7, 0, '', 'Cube: Scored a Goal', '1', '', '', '', 0, NULL, NULL),
('tf', 'cube_score_own_goal', -10, 0, '', 'Cube: Scored an Own Goal', '1', '', '', '', 0, NULL, NULL),
('tf', 'cube_score_assist', 5, 0, '', 'Cube: Assisted Scoring a Goal', '1', '', '', '', 0, NULL, NULL),
('tf', 'kill_assist_medic', 3, 0, '', 'Kill Assist - Medic', '1', '0', '0', '0', 0, NULL, NULL),
('tf', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', '', 0, NULL, NULL),
('tf', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', '', 0, NULL, NULL),
('tf', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', '', 0, NULL, NULL),
('tf', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', '', 0, NULL, NULL),
('tf', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', '', 0, NULL, NULL),
('tf', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', '', 0, NULL, NULL),
('tf', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', '', 0, NULL, NULL),
('tf', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', '', 0, NULL, NULL),
('tf', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', '', 0, NULL, NULL),
('tf', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', '', 0, NULL, NULL),
('tf', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', '', 0, NULL, NULL),
('css','Begin_Bomb_Defuse_Without_Kit',0,0,'CT','Start Defusing the Bomb Without a Defuse Kit','1','','','',0,NULL,NULL),
('css','Begin_Bomb_Defuse_With_Kit',0,0,'CT','Start Defusing the Bomb With a Defuse Kit','1','','','',0,NULL,NULL),
('css','Planted_The_Bomb',10,2,'TERRORIST','Plant the Bomb','1','','','',0,NULL,NULL),
('css','Defused_The_Bomb',10,0,'CT','Defuse the Bomb','1','','','',0,NULL,NULL),
('css','Touched_A_Hostage',0,0,'CT','Touch a Hostage','1','','','',0,NULL,NULL),
('css','Rescued_A_Hostage',5,1,'CT','Rescue a Hostage','1','','','',0,NULL,NULL),
('css','Killed_A_Hostage',-15,1,'CT','Kill a Hostage','1','','','',0,NULL,NULL),
('css','Spawned_With_The_Bomb',2,0,'TERRORIST','Spawn with the Bomb','1','','','',0,NULL,NULL),
('css','Got_The_Bomb',2,0,'TERRORIST','Pick up the Bomb','1','','','',0,NULL,NULL),
('css','Dropped_The_Bomb',-2,0,'TERRORIST','Drop the Bomb','1','','','',0,NULL,NULL),
('css','CTs_Win',0,2,'CT','All Terrorists eliminated','','','1','',0,NULL,NULL),
('css','Terrorists_Win',0,2,'TERRORIST','All Counter-Terrorists eliminated','','','1','',0,NULL,NULL),
('css','All_Hostages_Rescued',0,10,'CT','Counter-Terrorists rescued all the hostages','','','1','',0,NULL,NULL),
('css','Target_Bombed',0,5,'TERRORIST','Terrorists bombed the target','','','1','',0,NULL,NULL),
('css','Bomb_Defused',0,5,'CT','Counter-Terrorists defused the bomb','','','1','',0,NULL,NULL),
('css','Escaped_As_VIP',0,10,'CT','VIP escaped','','','1','',0,NULL,NULL),
('css','Assassinated_The_VIP',0,6,'TERRORIST','Terrorists assassinated the VIP','','','1','',0,NULL,NULL),
('css','Became_VIP',1,0,'CT','Become the VIP','1','','','',0,NULL,NULL),
('css','headshot',1,0,'','Headshot','1','','','',0,NULL,NULL),
('css', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', '', 0, NULL, NULL),
('css', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', '', 0, NULL, NULL),
('css', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', '', 0, NULL, NULL),
('css', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', '', 0, NULL, NULL),
('css', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', '', 0, NULL, NULL),
('css', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', '', 0, NULL, NULL),
('css', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', '', 0, NULL, NULL),
('css', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', '', 0, NULL, NULL),
('css', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', '', 0, NULL, NULL),
('css', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', '', 0, NULL, NULL),
('css', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', '', 0, NULL, NULL),
('hl2ctf','ctf_flag_capture',15,0,'','Captured Enemy Flag','1','','','',0,NULL,NULL),
('hl2ctf','ctf_flag_defend',2,0,'','Defended the Flag','1','','','',0,NULL,NULL),
('hl2ctf','ctf_kill_carrier',5,0,'','Killed Enemy Flag Carrier','1','','','',0,NULL,NULL),
('hl2ctf','ctf_flag_return',5,0,'','Returned Flag','1','','','',0,NULL,NULL),
('hl2ctf','ctf_flag_stolen',1,0,'','Stole Enemy Flag','1','','','',0,NULL,NULL),
('hl2ctf','ctf_protect_carrier',5,0,'','Protected Flag Carrier','1','','','',0,NULL,NULL),
('hl2ctf', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', '', 0, NULL, NULL),
('hl2ctf', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', '', 0, NULL, NULL),
('hl2ctf', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', '', 0, NULL, NULL),
('hl2ctf', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', '', 0, NULL, NULL),
('hl2ctf', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', '', 0, NULL, NULL),
('hl2ctf', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', '', 0, NULL, NULL),
('hl2ctf', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', '', 0, NULL, NULL),
('hl2ctf', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', '', 0, NULL, NULL),
('hl2ctf', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', '', 0, NULL, NULL),
('hl2ctf', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', '', 0, NULL, NULL),
('hl2ctf', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', '', 0, NULL, NULL),
('dods','capblock',6,1,'','Capture Blocked','1','','1','',0,NULL,NULL),
('dods','captured_loc',6,1,'','Area Captured','1','','1','',0,NULL,NULL),
('dods','kill_planter',2,0,'','Bomb Planter Killed','1','','','',0,NULL,NULL),
('dods','bomb_defuse',6,1,'','Bomb Defused','1','','1','',0,NULL,NULL),
('dods','bomb_plant',6,1,'','Bomb Planted','1','','1','',0,NULL,NULL),
('dods','round_win',0,5,'','Round Win','','','1','',0,NULL,NULL),
('dods', 'domination', 0, 0, '', 'Domination', '1', '', '', '', 0, NULL, NULL),
('dods', 'revenge', 5, 0, '', 'Revenge', '1', '', '', '', 0, NULL, NULL),
('dods', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', '', 0, NULL, NULL),
('dods', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', '', 0, NULL, NULL),
('dods', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', '', 0, NULL, NULL),
('dods', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', '', 0, NULL, NULL),
('dods', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', '', 0, NULL, NULL),
('dods', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', '', 0, NULL, NULL),
('dods', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', '', 0, NULL, NULL),
('dods', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', '', 0, NULL, NULL),
('dods', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', '', 0, NULL, NULL),
('dods', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', '', 0, NULL, NULL),
('dods', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', '', 0, NULL, NULL),
('hl2mp', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', '', 0, NULL, NULL),
('hl2mp', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', '', 0, NULL, NULL),
('hl2mp', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', '', 0, NULL, NULL),
('hl2mp', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', '', 0, NULL, NULL),
('hl2mp', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', '', 0, NULL, NULL),
('hl2mp', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', '', 0, NULL, NULL),
('hl2mp', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', '', 0, NULL, NULL),
('hl2mp', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', '', 0, NULL, NULL),
('hl2mp', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', '', 0, NULL, NULL),
('hl2mp', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', '', 0, NULL, NULL),
('hl2mp', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', '', 0, NULL, NULL),
('insmod', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', '', 0, NULL, NULL),
('insmod', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', '', 0, NULL, NULL),
('insmod', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', '', 0, NULL, NULL),
('insmod', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', '', 0, NULL, NULL),
('insmod', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', '', 0, NULL, NULL),
('insmod', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', '', 0, NULL, NULL),
('insmod', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', '', 0, NULL, NULL),
('insmod', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', '', 0, NULL, NULL),
('insmod', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', '', 0, NULL, NULL),
('insmod', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', '', 0, NULL, NULL),
('insmod', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', '', 0, NULL, NULL),
('ff', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', '', 0, NULL, NULL),
('ff', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', '', 0, NULL, NULL),
('ff', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', '', 0, NULL, NULL),
('ff', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', '', 0, NULL, NULL),
('ff', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', '', 0, NULL, NULL),
('ff', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', '', 0, NULL, NULL),
('ff', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', '', 0, NULL, NULL),
('ff', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', '', 0, NULL, NULL),
('ff', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', '', 0, NULL, NULL),
('ff', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', '', 0, NULL, NULL),
('ff', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', '', 0, NULL, NULL),
('ff', 'headshot', 1, 0, '', 'Headshot kill', '1', '', '', '', 0, NULL, NULL),
('hidden', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '', '', '', 0, NULL, NULL),
('hidden', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '', '', '', 0, NULL, NULL),
('hidden', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '', '', '', 0, NULL, NULL),
('hidden', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '', '', '', 0, NULL, NULL),
('hidden', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '', '', '', 0, NULL, NULL),
('hidden', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '', '', '', 0, NULL, NULL),
('hidden', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '', '', '', 0, NULL, NULL),
('hidden', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '', '', '', 0, NULL, NULL),
('hidden', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '', '', '', 0, NULL, NULL),
('hidden', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '', '', '', 0, NULL, NULL),
('hidden', 'kill_streak_12', 11, 0, '', 'God Like (12+ kills)', '1', '', '', '', 0, NULL, NULL);

INSERT IGNORE INTO `hlstats_Awards` (`awardType`, `game`, `code`, `name`, `verb`, `d_winner_id`, `d_winner_count`) VALUES
('W','tf','tf_projectile_pipe_remote','Remote Demolition Man','pipe bomb kills',NULL,NULL),
('W','tf','tf_projectile_pipe','Demolition Man','pipe bomb kills',NULL,NULL),
('W','tf','sniperrifle','Top Sniper','snipings',NULL,NULL),
('W','tf','smg','Submachine gun','smg kills',NULL,NULL),
('W','tf','shotgun_soldier','Shotgun Soldier','shotgun kills',NULL,NULL),
('W','tf','shotgun_pyro','Shotgun Pyro','shotgun kills',NULL,NULL),
('W','tf','shotgun_primary','Shotgun','shotgun kills',NULL,NULL),
('W','tf','scattergun','Fast and Furious','scattergun kills',NULL,NULL),
('W','tf','revolver','Wayne','revolver kills',NULL,NULL),
('W','tf','pistol','Pistol','pistol kills',NULL,NULL),
('W','tf','obj_sentrygun','Engineer','sentry kills',NULL,NULL),
('W','tf','minigun','Terminator','minigun kills',NULL,NULL),
('W','tf','knife','Stabber','knifings',NULL,NULL),
('W','tf','flamethrower','Pyro','flame burnings',NULL,NULL),
('W','tf','bat','Baseball freak','bat kills',NULL,NULL),
('O','tf','pointcaptured','Capturer','checkpoint captures',NULL,NULL),
('O','tf','killedobject','Destroyer','object destructions',NULL,NULL),
('O','tf','kill assist','Assistance','kill assists',NULL,NULL),
('O','tf','captureblocked','Blocker','checkpoint blockings',NULL,NULL),
('O','tf','builtobject','Builder','object buildings',NULL,NULL),
('O','tf','chargedeployed','Ubermedic','deployed charges',NULL,NULL),
('O','tf','domination','Dominator','dominations',NULL,NULL),
('O','tf','revenge','Anti-Dominator','revenges',NULL,NULL),
('W','tf','latency','Best Latency','ms average connection',NULL,NULL),
('W','tf','tf_projectile_rocket','Soldier','rocket kills',NULL,NULL),
('W','tf','wrench','Engineer on Rage','wrench kills',NULL,NULL),
('W','tf','shovel','Grave Digger','shovel kills',NULL,NULL),
('W','tf','fireaxe','Axe-O-Mania','axe kills',NULL,NULL),
('W','tf','bottle','Drunken Demoman','bottle kills',NULL,NULL),
('W','tf','bonesaw','The Saw','sawed bones',NULL,NULL),
('W','tf','fists','Fisting king','fistings',NULL,NULL),
('W','tf','club','Clubber','clubbings',NULL,NULL),
('W','tf','pistol_scout','Scout Pistol','pistol kills',NULL,NULL),
('W','tf','shotgun_hwg','Shotgun Heavy','shotgun kills',NULL,NULL),
('W','tf','syringegun_medic','The Injector','syringe kills',NULL,NULL),
('W','tf','axtinguisher', 'Axtinguisher', 'kills with the axtinguisher',NULL,NULL),
('W','tf','backburner', 'Backburner', 'burned backs',NULL,NULL),
('W','tf','blutsauger', 'Blutsauger', 'times sucked blood',NULL,NULL),
('W','tf','gloves', 'Heavy surgery', 'KGB kills',NULL,NULL),
('W','tf','natascha', 'Nataschas Friend', 'Natascha kills',NULL,NULL),
('W','tf','ubersaw', 'Ubersaw', 'kills with ubersaw',NULL,NULL),
('W','hl2mp','crowbar','01. (Crowbar) Rebel for Life','guys slaughtered and some more fleshwounds',NULL,NULL),
('W','hl2mp','physics','04. (Physics) Bummsmaster','kills with the Zeropoint Energyfield Manipulator',NULL,NULL),
('W','hl2mp','physbox','05. (Physbox) Baffmaster','hits with this and that',NULL,NULL),
('W','hl2mp','stunstick','02. (Stunstick) Stockmaster','guys beatn up',NULL,NULL),
('W','hl2mp','pistol','03. (Pistol) Freakin Pistol Freak','times freaked out',NULL,NULL),
('W','hl2mp','shotgun','09. (Pumpgun) Duckmaster','kills with the Duckmaster2k',NULL,NULL),
('W','hl2mp','357','08. (.357) Peacemaker','Killshots',NULL,NULL),
('W','hl2mp','smg1','14. (SMG) SMG Killer','kills with the SMGay',NULL,NULL),
('W','hl2mp','ar2','11. (AR2) Rattertante','kills with the assault rifle',NULL,NULL),
('W','hl2mp','crossbow_bolt','10. (Crossbow) Robin Hood','guys killed instantly',NULL,NULL),
('W','hl2mp','slam','12. (Slam) Trapmaster','guys trapped and killed',NULL,NULL),
('W','hl2mp','grenade_frag','06. (Grenade) Nadethrower 2k','guys nuked',NULL,NULL),
('W','hl2mp','rpg_missile','16. (RPG) Clumsy Smurf found the RPG!','times pissed in the pants',NULL,NULL),
('W','hl2mp','latency','15. (Latency) Lowpinger','ms average',NULL,NULL),
('W','css','awp','AWP','kills with awp',NULL,NULL),
('W','css','latency','Best Latency','ms average connection',NULL,NULL),
('W','css','galil','Galil','kills with galil',NULL,NULL),
('W','css','famas','Fusil Automatique','kills with famas',NULL,NULL),
('W','css','ak47','AK47','kills with ak47',NULL,NULL),
('W','css','glock','Glock','kills with glock',NULL,NULL),
('W','css','m4a1','Colt M4A1 Carbine','kills with m4a1',NULL,NULL),
('W','css','usp','USP Master','kills with usp',NULL,NULL),
('W','css','m3','M3 Shotgun','kills with m3 shotgun',NULL,NULL),
('W','css','deagle','Desert Eagle','kills with deagle',NULL,NULL),
('W','css','p90','P 90','kills with p90',NULL,NULL),
('W','css','knife','Knife Maniac','knifings',NULL,NULL),
('W','css','elite','Dual Berretta Elites','kills with elite',NULL,NULL),
('O','css','Rescued_A_Hostage','Top Hostage Rescuer','hostages rescued',NULL,NULL),
('O','css','Planted_The_Bomb','Top Demolitionist','bomb plantings',NULL,NULL),
('O','css','Defused_The_Bomb','Top Defuser','bomb defusions',NULL,NULL),
('W','css','aug','Steyr Aug','kills with aug',NULL,NULL),
('W','css','fiveseven','Five Seven','kills with fiveseven',NULL,NULL),
('W','css','g3sg1','G3 SG1','kills with g3sg1',NULL,NULL),
('W','css','m249','Para','kills with m249',NULL,NULL),
('W','css','mac10','Mac 10','kills with mac10',NULL,NULL),
('W','css','mp5navy','MP5 Navy','kills with mp5',NULL,NULL),
('W','css','p228','P 228','kills with p228',NULL,NULL),
('W','css','sg550','SG 550','kills with sg550',NULL,NULL),
('W','css','sg552','SG 552','kills with sg552',NULL,NULL),
('W','css','tmp','TMP','kills with tmp',NULL,NULL),
('W','css','ump45','UMP 45','kills with ump45',NULL,NULL),
('W','css','xm1014','XM automatic Shotgun','kills with xm1014',NULL,NULL),
('O','css','headshot','Headshot King','shots in the head',NULL,NULL),
('W','css','scout','Scout Elite','kills with scout',NULL,NULL),
('W','css','hegrenade','Top grenadier','kills with grenade',NULL,NULL),
('O','css','Killed_A_Hostage','Top Hostage Killer','hostages killed',NULL,NULL),
('W','hl2mp','combine_ball','07. (Combine Balls) Ball Player','guys set on fire',NULL,NULL),
('W','hl2mp','smg1_grenade','13. (SMG Nade) SMG Nader','guys exploded by him',NULL,NULL),
('W','hl2ctf','crowbar','Crowbar','bludgeonings with ole red', NULL, NULL),
('W','hl2ctf','physcannon','Anger Issues','kills with physics' ,NULL,NULL),
('W','hl2ctf','stunstick','Stun Stick','kills with stunstick',NULL,NULL),
('W','hl2ctf','pistol','Pistol','kills with pistol',NULL,NULL),
('W','hl2ctf','shotgun','A freakin 12 gague!','kills with shotgun',NULL,NULL),
('W','hl2ctf','357','Clint','kills with .357',NULL,NULL),
('W','hl2ctf','smg1','SMG','kills with the smg',NULL,NULL),
('W','hl2ctf','ar2','Assault','kills with the assault rifle',NULL,NULL),
('W','hl2ctf','crossbow_bolt','Sniper','snipings with crossbow',NULL,NULL),
('W','hl2ctf','slam','SLAMMED!','kills with the slam',NULL,NULL),
('W','hl2ctf','grenade_frag','Grenade Fiend','kills with nades',NULL,NULL),
('W','hl2ctf','rpg_missile','Role Player','kills with RPG',NULL,NULL),
('W','hl2ctf','latency','Best Latency','ms average connection',NULL,NULL),
('O','dods','bomb_defuse','Top Defuser','bomb defusions',NULL,NULL),
('O','dods','bomb_plant','Top Demolitionist','bomb plantings',NULL,NULL),
('O','dods','kill_planter','Bomb Planter Killer','kills',NULL,NULL),
('W','dods','amerknife','Backstabbing Beotch','kills with the American Knife',NULL,NULL),
('W','dods','mp40','MP40 Hor','kills with the MP40 Machine Pistol',NULL,NULL),
('W','dods','spade','Shovel God','kills with the spade',NULL,NULL),
('W','dods','mp44','MP44 Hor','kills with the MP44 Assault Rifle',NULL,NULL),
('W','dods','colt','Colt Freak','kills with the Colt .45 model 1911',NULL,NULL),
('W','dods','garand','GarandMeister','kills with the M1 Garand Rifle',NULL,NULL),
('W','dods','thompson','Thompson Hor','kills with the Thompson Submachine Gun',NULL,NULL),
('W','dods','spring','Spring Sniper','snipings with the Springfield 03 Rifle',NULL,NULL),
('W','dods','bar','Bar Browning Hor','kills with the BAR Browning Automatic Rifle',NULL,NULL),
('W','dods','frag_us','McVeigh Alert','bombings with the U.S. Grenade',NULL,NULL),
('W','dods','frag_ger','Grenade Freak','bombings with the German Grenade',NULL,NULL),
('W','dods','bazooka','Bazooka Joe','kills with the Bazooka',NULL,NULL),
('W','dods','pschreck','Panzerschreck Hans','kills with the Panzerschreck',NULL,NULL),
('W','dods','latency','Best Latency','ms average connection',NULL,NULL),
('W','dods','punch','Puncher','knock-outs',NULL,NULL),
('W','dods','mg42','German Machine Hor','kills with the MG42',NULL,NULL),
('O','dods','captured_loc','Area Captured','flags captured',NULL,NULL),
('W','insmod','latency','Best Latency','ms average connection',NULL,NULL),
('W','insmod','weapon_makarov','Soviet Makarov Combat Pistol','kills with Soviet Makarov Combat Pistol',NULL,NULL),
('W','insmod','weapon_m9','9mm Beretta Pistol','kills with 9mm Beretta Pistol',NULL,NULL),
('W','insmod','weapon_sks','Simonov SKS carbine','kills with Simonov SKS carbine',NULL,NULL),
('W','insmod','world','RPG or Grenade','kills with RPG or Grenade',NULL,NULL),
('W','insmod','weapon_m1014','M1014 Service Combat Shotgun','kills with M1014 Service Combat Shotgun',NULL,NULL),
('W','insmod','weapon_toz','TOZ Rifle','kills with TOZ Rifle',NULL,NULL),
('W','insmod','weapon_svd','Dragunov Sniper Rifle','kills with Dragunov Sniper Rifle',NULL,NULL),
('W','insmod','weapon_rpk','RPK Ruchnoy Pulemyot Kalashnikova','kills with RPK Ruchnoy Pulemyot Kalashnikova',NULL,NULL),
('W','insmod','weapon_m249','M249 SAW (Squad Automatic Weapon)','kills with M249 SAW (Squad Automatic Weapon)',NULL,NULL),
('W','insmod','weapon_m16m203','M16 carbine M203 Grenade Launcher','kills with M16 carbine M203 Grenade Launcher',NULL,NULL),
('W','insmod','weapon_l42a1','Enfield L42A1 Military Sniper Rifle','kills with Enfield L42A1 Military Sniper Rifle',NULL,NULL),
('W','insmod','weapon_m4med','M4 Medium Range Rifle','kills with M4 Medium Range Rifle',NULL,NULL),
('W','insmod','weapon_m4','M4 Carbine Rifle','kills with M4 Carbine Rifle',NULL,NULL),
('W','insmod','weapon_m16a4','M16A4 Infantry Rifle','kills with M16A4 Infantry Rifle',NULL,NULL),
('W','insmod','weapon_m14','Colt M14 Carbine','kills with Colt M14 Carbine',NULL,NULL),
('W','insmod','weapon_fnfa1','FN FAL Automatic Rifle','kills with FN FAL Automatic Rifle',NULL,NULL),
('W','insmod','weapon_aks74u','AKS-74U Awtomat Kalaschnikowa Ukorochennyj','kills with AKS-74U',NULL,NULL),
('W','insmod','weapon_ak47','AK-47 Awtomat Kalaschnikowa','kills with AK-47 Awtomat Kalaschnikowa',NULL,NULL),
('W', 'ff', 'weapon_tranq', 'Drug Dealer', 'kills with tranq gun', NULL, NULL),
('W', 'ff', 'weapon_supershotgun', 'Super Shots', 'kills with super shotgun', NULL, NULL),
('W', 'ff', 'weapon_supernailgun', 'Super Nails', 'kills with super nailgun', NULL, NULL),
('W', 'ff', 'weapon_spanner', 'Whack-A-Mole', 'kills with spanner', NULL, NULL),
('W', 'ff', 'weapon_sniperrifle', 'Snipes-A-Holic', 'kills with sniper rifle', NULL, NULL),
('W', 'ff', 'weapon_rpg', 'ROCKET MAN', 'kills with rpg', NULL, NULL),
('W', 'ff', 'weapon_shotgun', 'N00b shotwhore', 'kills with normal shotgun', NULL, NULL),
('W', 'ff', 'weapon_railgun', 'Pew pew laz0r beams', 'kills with railgun', NULL, NULL),
('W', 'ff', 'weapon_pipelauncher', 'Bouncy pipe whore', 'kills with blues', NULL, NULL),
('W', 'ff', 'weapon_medkit', 'Aids Monger', 'kills with aids', NULL, NULL),
('W', 'ff', 'weapon_knife', 'My name is Skanky Butterpuss(e)', 'kills with knife', NULL, NULL),
('W', 'ff', 'weapon_grenadelauncher', 'Click BOOM', 'kills with grellows', NULL, NULL),
('W', 'ff', 'weapon_flamethrower', 'I like fire!', 'kills with flamethrower', NULL, NULL),
('W', 'ff', 'weapon_autorifle', 'Gay Sniper', 'kills with AR', NULL, NULL),
('W', 'ff', 'weapon_dispenser', 'Remote Control GOD', 'kills with dispenser', NULL, NULL),
('W', 'ff', 'weapon_assaultcannon', 'Best Fatty Ever!', 'kills with ass cannon', NULL, NULL),
('W', 'ff', 'SentryGun', 'Robocop', 'kills with SG', NULL, NULL),
('W', 'ff', 'grenade_normal', 'Flying chicken!', 'kills with frag grenade', NULL, NULL),
('W', 'ff', 'grenade_mirv', 'Look I can kill SGs!', 'kills with mirv grenade', NULL, NULL),
('W', 'ff', 'grenade_emp', 'Wheres all my ammo!', 'kills with emp grenade', NULL, NULL),
('W', 'ff', 'BOOM_HEADSHOT', 'Sharp Eye', 'headshots', NULL, NULL),
('W', 'ff', 'DETPACK', 'Earthquake Machine', 'kills with detpack', NULL, NULL),
('W', 'hidden', 'fn2000', 'FN2000 Assault Rifle', 'kills with FN2000 Assault Rifle', NULL, NULL),
('W', 'hidden', 'p90', 'FN P90 Sub Machine Gun', 'kills with FN P90 Sub Machine Gun', NULL, NULL),
('W', 'hidden', 'shotgun', 'Remington 870 MCS Shotgun', 'kills with Remington 870 MCS Shotgun', NULL, NULL),
('W', 'hidden', 'fn303', 'FN303 Less Lethal Launcher', 'kills with FN303 Less Lethal Launcher', NULL, NULL),
('W', 'hidden', 'pistol', 'FN FiveSeven Pistol', 'kills with FN FiveSeven Pistol', NULL, NULL),
('W', 'hidden', 'pistol2', 'FNP-9 Pistol', 'kills with FNP-9 Pistol', NULL, NULL),
('W', 'hidden', 'knife', 'Kabar D2 Knife', 'kills with Kabar D2 Knife', NULL, NULL),
('W', 'hidden', 'grenade_projectile', 'Pipe Bomb', 'kills with Pipe Bomb', NULL, NULL),
('W', 'hidden', 'physics', 'Physics', 'kills with Physics', NULL, NULL);

CREATE TABLE `hlstats_Awards_Global` (
  `game` varchar(128) NOT NULL,
  `playerId` int(11) unsigned NOT NULL default '0',
  `image` varchar(50) NOT NULL,
  `ribbonName` varchar(50) NOT NULL,
  `playerName` varchar(128) NOT NULL,
  `flag` varchar(10) default NULL,
  `kills` int(11) unsigned NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `hlstats_Clans` ADD COLUMN `hidden` tinyint(3) unsigned NOT NULL default '0';

INSERT IGNORE INTO `hlstats_ClanTags` (`pattern`, `position`) VALUES
('[AXXXXX]', 'EITHER'),
('|AXXXXX|', 'EITHER'),
('(AXXXXX)', 'EITHER'),
('{AXXXXX}', 'EITHER'),
('-=AXXX=-', 'START'),
('=AXXXXX=', 'START'),
('-AXXXXX-', 'START'),
('=[AXXXX]=', 'START'),
('-=|AXXXXXX|=-', 'EITHER'),
('-=[AXXXXXX]=-', 'EITHER'),
('-=]AXXXXXX[=-', 'EITHER'),
('~{|AXXXXXX|}~', 'EITHER'),
('-|-AXXXXXX-|-', 'EITHER'),
('-(AXXXXXX)-', 'EITHER'),
('::AXXXXXX::', 'EITHER'),
('<<AXXXXXX>>', 'EITHER'),
('{{AXXXXXX}}', 'EITHER'),
('((AXXXXXX))', 'EITHER'),
('.|AXXXXXX|.', 'EITHER'),
('--AXXXXXX--', 'EITHER'),
('-)AXXXXXX(-', 'EITHER'),
('/AXXXXXX', 'EITHER'),
('//AXXXXXX', 'EITHER'),
('_AXXXXXX_', 'EITHER'),
('_=|AXXXXXX|=_', 'EITHER'),
('*AXXXXXX*', 'EITHER'),
('.:AXXXXXX:', 'START'),
('[(AXXXXXX)]', 'EITHER');

CREATE TABLE `hlstats_Countries` (
  `flag` varchar(16) NOT NULL,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY  (`flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT IGNORE INTO `hlstats_Countries` (`flag`, `name`) VALUES
('AD', 'Andorra'),
('AE', 'United Arab Emirates'),
('AF', 'Afghanistan'),
('AG', 'Antigua & Barbuda'),
('AI', 'Anguilla'),
('AL', 'Albania'),
('AM', 'Armenia'),
('AN', 'Netherlands Antilles'),
('AO', 'Angola'),
('AQ', 'Antarctica'),
('AR', 'Argentina'),
('AS', 'American Samoa'),
('AT', 'Austria'),
('AU', 'Australia'),
('AW', 'Aruba'),
('AZ', 'Azerbaijan'),
('BA', 'Bosnia and Herzegovina'),
('BB', 'Barbados'),
('BD', 'Bangladesh'),
('BE', 'Belgium'),
('BF', 'Burkina Faso'),
('BG', 'Bulgaria'),
('BH', 'Bahrain'),
('BI', 'Burundi'),
('BJ', 'Benin'),
('BM', 'Bermuda'),
('BN', 'Brunei Darussalam'),
('BO', 'Bolivia'),
('BR', 'Brazil'),
('BS', 'Bahama'),
('BT', 'Bhutan'),
('BU', 'Burma (no longer exists)'),
('BV', 'Bouvet Island'),
('BW', 'Botswana'),
('BY', 'Belarus'),
('BZ', 'Belize'),
('CA', 'Canada'),
('CC', 'Cocos (Keeling) Islands'),
('CF', 'Central African Republic'),
('CG', 'Congo'),
('CH', 'Switzerland'),
('CI', 'Cte D''ivoire (Ivory Coast)'),
('CK', 'Cook Iislands'),
('CL', 'Chile'),
('CM', 'Cameroon'),
('CN', 'China'),
('CO', 'Colombia'),
('CR', 'Costa Rica'),
('CS', 'Czechoslovakia (no longer exists)'),
('CU', 'Cuba'),
('CV', 'Cape Verde'),
('CX', 'Christmas Island'),
('CY', 'Cyprus'),
('CZ', 'Czech Republic'),
('DD', 'German Democratic Republic (no longer exists)'),
('DE', 'Germany'),
('DJ', 'Djibouti'),
('DK', 'Denmark'),
('DM', 'Dominica'),
('DO', 'Dominican Republic'),
('DZ', 'Algeria'),
('EC', 'Ecuador'),
('EE', 'Estonia'),
('EG', 'Egypt'),
('EH', 'Western Sahara'),
('ER', 'Eritrea'),
('ES', 'Spain'),
('ET', 'Ethiopia'),
('FI', 'Finland'),
('FJ', 'Fiji'),
('FK', 'Falkland Islands (Malvinas)'),
('FM', 'Micronesia'),
('FO', 'Faroe Islands'),
('FR', 'France'),
('FX', 'France, Metropolitan'),
('GA', 'Gabon'),
('UK', 'United Kingdom (Great Britain)'),
('GD', 'Grenada'),
('GE', 'Georgia'),
('GF', 'French Guiana'),
('GH', 'Ghana'),
('GI', 'Gibraltar'),
('GL', 'Greenland'),
('GM', 'Gambia'),
('GN', 'Guinea'),
('GP', 'Guadeloupe'),
('GQ', 'Equatorial Guinea'),
('GR', 'Greece'),
('GS', 'South Georgia and the South Sandwich Islands'),
('GT', 'Guatemala'),
('GU', 'Guam'),
('GW', 'Guinea-Bissau'),
('GY', 'Guyana'),
('HK', 'Hong Kong'),
('HM', 'Heard & McDonald Islands'),
('HN', 'Honduras'),
('HR', 'Croatia'),
('HT', 'Haiti'),
('HU', 'Hungary'),
('ID', 'Indonesia'),
('IE', 'Ireland'),
('IL', 'Israel'),
('IN', 'India'),
('IO', 'British Indian Ocean Territory'),
('IQ', 'Iraq'),
('IR', 'Islamic Republic of Iran'),
('IS', 'Iceland'),
('IT', 'Italy'),
('JM', 'Jamaica'),
('JO', 'Jordan'),
('JP', 'Japan'),
('KE', 'Kenya'),
('KG', 'Kyrgyzstan'),
('KH', 'Cambodia'),
('KI', 'Kiribati'),
('KM', 'Comoros'),
('KN', 'St. Kitts and Nevis'),
('KP', 'Korea, Democratic People''s Republic of'),
('KR', 'Korea, Republic of'),
('KW', 'Kuwait'),
('KY', 'Cayman Islands'),
('KZ', 'Kazakhstan'),
('LA', 'Lao People''s Democratic Republic'),
('LB', 'Lebanon'),
('LC', 'Saint Lucia'),
('LI', 'Liechtenstein'),
('LK', 'Sri Lanka'),
('LR', 'Liberia'),
('LS', 'Lesotho'),
('LT', 'Lithuania'),
('LU', 'Luxembourg'),
('LV', 'Latvia'),
('LY', 'Libyan Arab Jamahiriya'),
('MA', 'Morocco'),
('MC', 'Monaco'),
('MD', 'Moldova, Republic of '),
('MG', 'Madagascar'),
('MH', 'Marshall Islands'),
('ML', 'Mali'),
('MM', 'Myanmar'),
('MN', 'Mongolia'),
('MO', 'Macau'),
('MP', 'Northern Mariana Islands'),
('MQ', 'Martinique'),
('MR', 'Mauritania'),
('MS', 'Monserrat'),
('MT', 'Malta'),
('MU', 'Mauritius'),
('MV', 'Maldives'),
('MW', 'Malawi'),
('MX', 'Mexico'),
('MY', 'Malaysia'),
('MZ', 'Mozambique'),
('NA', 'Namibia'),
('NC', 'New Caledonia'),
('NE', 'Niger'),
('NF', 'Norfolk Island'),
('NG', 'Nigeria'),
('NI', 'Nicaragua'),
('NL', 'Netherlands'),
('NO', 'Norway'),
('NP', 'Nepal'),
('NR', 'Nauru'),
('NT', 'Neutral Zone (no longer exists)'),
('NU', 'Niue'),
('NZ', 'New Zealand'),
('OM', 'Oman'),
('PA', 'Panama'),
('PE', 'Peru'),
('PF', 'French Polynesia'),
('PG', 'Papua New Guinea'),
('PH', 'Philippines'),
('PK', 'Pakistan'),
('PL', 'Poland'),
('PM', 'St. Pierre & Miquelon'),
('PN', 'Pitcairn'),
('PR', 'Puerto Rico'),
('PT', 'Portugal'),
('PW', 'Palau'),
('PY', 'Paraguay'),
('QA', 'Qatar'),
('RE', 'Runion'),
('RO', 'Romania'),
('RU', 'Russian Federation'),
('RW', 'Rwanda'),
('SA', 'Saudi Arabia'),
('SB', 'Solomon Islands'),
('SC', 'Seychelles'),
('SD', 'Sudan'),
('SE', 'Sweden'),
('SG', 'Singapore'),
('SH', 'St. Helena'),
('SI', 'Slovenia'),
('SJ', 'Svalbard & Jan Mayen Islands'),
('SK', 'Slovakia'),
('SL', 'Sierra Leone'),
('SM', 'San Marino'),
('SN', 'Senegal'),
('SO', 'Somalia'),
('SR', 'Suriname'),
('ST', 'Sao Tome & Principe'),
('SU', 'Union of Soviet Socialist Republics (no longer exi'),
('SV', 'El Salvador'),
('SY', 'Syrian Arab Republic'),
('SZ', 'Swaziland'),
('TC', 'Turks & Caicos Islands'),
('TD', 'Chad'),
('TF', 'French Southern Territories'),
('TG', 'Togo'),
('TH', 'Thailand'),
('TJ', 'Tajikistan'),
('TK', 'Tokelau'),
('TM', 'Turkmenistan'),
('TN', 'Tunisia'),
('TO', 'Tonga'),
('TP', 'East Timor'),
('TR', 'Turkey'),
('TT', 'Trinidad & Tobago'),
('TV', 'Tuvalu'),
('TW', 'Taiwan, Province of China'),
('TZ', 'Tanzania, United Republic of'),
('UA', 'Ukraine'),
('UG', 'Uganda'),
('UM', 'United States Minor Outlying Islands'),
('US', 'United States of America'),
('UY', 'Uruguay'),
('UZ', 'Uzbekistan'),
('VA', 'Vatican City State (Holy See)'),
('VC', 'St. Vincent & the Grenadines'),
('VE', 'Venezuela'),
('VG', 'British Virgin Islands'),
('VI', 'United States Virgin Islands'),
('VN', 'Viet Nam'),
('VU', 'Vanuatu'),
('WF', 'Wallis & Futuna Islands'),
('WS', 'Samoa'),
('YD', 'Democratic Yemen (no longer exists)'),
('YE', 'Yemen'),
('YT', 'Mayotte'),
('YU', 'Yugoslavia'),
('ZA', 'South Africa'),
('ZM', 'Zambia'),
('ZR', 'Zaire'),
('ZW', 'Zimbabwe'),
('ZZ', 'Unknown or unspecified country');

ALTER TABLE `hlstats_Events_Connects` ADD COLUMN `eventTime_Disconnect` datetime default NULL;

ALTER TABLE `hlstats_Events_Frags`
ADD COLUMN `killerRole` varchar(128) NOT NULL default '',
ADD COLUMN `victimRole` varchar(128) NOT NULL default '',
ADD COLUMN `pos_x` varchar(10) character set utf8 collate utf8_unicode_ci default NULL,
ADD COLUMN `pos_y` varchar(10) character set utf8 collate utf8_unicode_ci default NULL,
ADD COLUMN `pos_z` varchar(10) character set utf8 collate utf8_unicode_ci default NULL;

ALTER TABLE `hlstats_Events_PlayerActions`
ADD COLUMN `pos_x` varchar(10) character set utf8 collate utf8_unicode_ci default NULL,
ADD COLUMN `pos_y` varchar(10) character set utf8 collate utf8_unicode_ci default NULL,
ADD COLUMN `pos_z` varchar(10) character set utf8 collate utf8_unicode_ci default NULL;

ALTER TABLE `hlstats_Events_PlayerPlayerActions`
ADD COLUMN `pos_x` varchar(10) character set utf8 collate utf8_unicode_ci default NULL,
ADD COLUMN `pos_y` varchar(10) character set utf8 collate utf8_unicode_ci default NULL,
ADD COLUMN `pos_z` varchar(10) character set utf8 collate utf8_unicode_ci default NULL;

ALTER TABLE `hlstats_Events_Suicides`
ADD COLUMN `pos_x` varchar(10) character set utf8 collate utf8_unicode_ci default NULL,
ADD COLUMN `pos_y` varchar(10) character set utf8 collate utf8_unicode_ci default NULL,
ADD COLUMN `pos_z` varchar(10) character set utf8 collate utf8_unicode_ci default NULL;

ALTER TABLE `hlstats_Events_Teamkills`
ADD COLUMN `pos_x` varchar(10) character set utf8 collate utf8_unicode_ci default NULL,
ADD COLUMN `pos_y` varchar(10) character set utf8 collate utf8_unicode_ci default NULL,
ADD COLUMN `pos_z` varchar(10) character set utf8 collate utf8_unicode_ci default NULL;

INSERT IGNORE INTO `hlstats_Games` (`code`, `name`, `hidden`) VALUES
('css','Counter-Strike: Source','1'),
('hl2mp','Half-Life 2 Multiplayer','1'),
('tf','Team Fortress 2','1'),
('hl2ctf','Half-Life 2 Capture the flag','1'),
('dods','Day of Defeat: Source','1'),
('insmod','Insurgency: Modern Infantry Combat','1'),
('ff', 'Fortress Forever', '1'),
('hidden','The Hidden: Source','1');

INSERT IGNORE INTO `hlstats_Options` (`keyname`, `value`) VALUES
('imgdir', 'hlstatsimg'),
('contact', 'your@email.address'),
('sitename', 'HLstatsX'),
('siteurl', 'http://your.stats.url.here'),
('style', 'psychonic.css'),
('imgpath', 'hlstatsimg'),
('map_dlurl', 'http://your.server.here/fastdownload/%GAME%/%MAP%.bsp.bz2'),
('awards_d_date', '2008-08-30'),
('awards_numdays', '1'),
('graphbg_trend', '000000'),
('graphbg_load', '000000'),
('graphtxt_trend', '0066CC'),
('graphtxt_load', '0066CC'),
('rankingtype', '1'),
('bannerfile', 'hlxbanner3.png'),
('bannerdisplay', '0'),
('awarddailycols', '4'),
('awardglobalcols', '5'),
('awardrankscols', '5'),
('awardribbonscols', '5'),
('freetypeenabled', '1'),
('sigbackground', 'random'),
('trendgraphfile', 'trendgraph1.png'),
('playerinfo_tabs', '1'),
('counter_hits', '0'),
('counter_visits', '0'),
('counter_visit_timeout', '5'),
('nav_globalchat', '1'),
('nav_countryclans', '1'),
('nav_cheaters', '0'),
('show_weapon_target_flash', '1'),
('show_server_load_image', '1'),
('show_flags', '1'),
('gamehome_show_awards', '0');

CREATE TABLE `hlstats_PerlConfig` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `parameter` varchar(50) character set utf8 collate utf8_unicode_ci NOT NULL,
  `value` varchar(128) character set utf8 collate utf8_unicode_ci NOT NULL,
  PRIMARY KEY  (`parameter`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT IGNORE INTO `hlstats_PerlConfig` (`parameter`, `value`) VALUES
('DNSResolveIP', '1'),
('DNSTimeout', '5'),
('Rcon', '1'),
('RconIgnoreSelf', '1'),
('RconRecord', '0'),
('MailTo', ''),
('MailPath', '/usr/sbin/sendmail'),
('Mode', 'Normal'),
('SkillMaxChange', '25'),
('SkillMinChange', '2'),
('PlayerMinKills', '50'),
('DeleteDays', '28'),
('UseTimestamp', '0'),
('MinActivity', '28'),
('AllowOnlyConfigServers', '1'),
('TrackStatsTrend', '1'),
('GlobalBanning', '1'),
('LogChat', '1'),
('LogChatAdmins', '0'),
('GlobalChat', '0'),
('HLStatsXCountryMaster', '1'),
('MasterBanlistBantime', '60');

CREATE TABLE `hlstats_PerlConfig_Default` (
  `parameter` varchar(50) character set utf8 collate utf8_unicode_ci NOT NULL,
  `value` varchar(128) character set utf8 collate utf8_unicode_ci NOT NULL,
  `description` mediumtext character set utf8 collate utf8_unicode_ci,
  PRIMARY KEY  (`parameter`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT IGNORE INTO `hlstats_PerlConfig_Default` (`parameter`, `value`, `description`) VALUES
('DNSResolveIP', '1', 'Resolve player IP addresses to hostnames. Requires a working DNS setup (on the box running hlstats.pl). 1=on 0=off'),
('DNSTimeout', '5', 'Time in seconds to wait for DNS queries to complete before cancelling DNS resolves. \r\nYou may need to increase this if on a slow connection or if you find a lot of IPs are not being resolved. \r\nHowever, while hlstats.pl is waiting for an IP to resolve it cannot be parsing log data.\r\n'),
('Rcon', '1', 'Allow HLstatsX to send Rcon commands to the game servers. 1=on 0=off'),
('RconIgnoreSelf', '0', 'Ignore (do not log) Rcon commands originating from the same IP as the server being Rcon''d. \r\n(Useful if you run any kind of monitoring script which polls the server regularly by Rcon.) 1=on 0=off\r\n'),
('RconRecord', '0', 'Sets whether to record Rcon commands to the Admin event table.\r\nThis can be useful to see what your admins are doing. But if you run programs like PB it can also fill your database up with a lot of useless junk. (1=on 0=off)\r\n'),
('MailTo', '', 'E-mail address to mail database errors to. (See also MailPath.)'),
('MailPath', '/usr/sbin/sendmail', 'Path to the ''mail'' program -- usually /bin/mail'),
('Mode', 'Normal', 'EXPERIMENTAL: Sets the player-tracking mode.\r\nPossible values:<UL>\r\n<LI>Normal     - Recommended for public Internet server use. Players will be tracked by WON ID.\r\n<LI>NameTrack  - Useful for shared-PC environments, such as Internet cafes, etc. Players will be tracked by nickname. EXPERIMENTAL!\r\n<LI>LAN        - Useful for LAN servers where players do not have a real WON ID. Players will be tracked by IP Address. EXPERIMENTAL!\r\n</UL>\r\n++ Note: Make sure you change the setting of MODE at the top of config.php, as well.'),
('SkillMaxChange', '25', 'Specifies the maximum number of skill points a player can gain at one time through frags. Because players with low skill ratings gain more for killing players with high skill ratings, this cap is needed to prevent e.g. a player with a skill rating of ''100'' killing a player with a skill rating of ''2000'' and therefore gaining several hundred or thousand skill points. Instead they cannot gain more than the value specified here. \r\n(Default is 25 skill points maximum change.)'),
('SkillMinChange', '2', 'Specifies the minimum number of skill points a player will\r\ngain at one time through frags. (Default is 2 skill points minimum change)\r\n'),
('PlayerMinKills', '50', 'Specifies the number of kills a player must have to get regular points. \r\nIf not the killer and victim will always get the points of SkillMinChange. (Default are 50 kills).'),
('DeleteDays', '30', 'HLstats will automatically delete history events from the events tables when they are over this many days old.\r\nThis is important for performance reasons. Set lower if you are logging a large number of game servers or find the load on the MySQL server is too high. \r\n++ Don''t forget to also change the DELETEDAYS define at the top of config.php.'),
('UseTimestamp', '0', 'Set to 0 (the default) to use the current time on the database server for the timestamp when recording events. \r\nSet to 1 to use the timestamp provided on the log data. Unless you are processing old log files on STDIN, you probably want to set this to 0; otherwise you will need to ensure that the clocks on your game servers are accurate. (1=on 0=off)\r\n'),
('MinActivity', '28', 'HLstatsX will automatically hide players which have no event more days than this value. (Default 28 days)\r\n++ Note: Make sure you change the setting of MINACTIVITY at the top of config.php, as well.'),
('AllowOnlyConfigServers', '1', 'If set to 1 (default) then only servers which are config in this file are tracked. Other servers will NOT automatically added and tracked! This is a big scurity thing!'),
('TrackStatsTrend', '1', 'Saves every day how many players, kills etc, are in the database and gvies access to graphical statistics. 1=on(default) 0=off'),
('GlobalBanning', '0', 'Set to 1 to make player bans available on all participating servers. Players who were banned permanently are automatic hided from rankings. 1=on 0=off(default)'),
('LogChat', '1', 'Defines if chat logging should be saved in the database. 1=on 0=off(default)\r\n++ Note: Make sure you change the setting of LOG_CHAT in the config.php, as well.'),
('LogChatAdmins', '1', 'Defines if admins chat should be logged. 1=on 0=off(default)'),
('GlobalChat', '0', 'Defines if chat messages are broadcasted through all particapting servers. 0=off(default), 1=Broadcast to all, 2=Broadcast only to admins'),
('HLStatsXCountryMaster', '0', 'Fallback for the Country Information -> GeoCityDB sometimes gives wrong information - Custom CountryCode on a SteamID could NOT be set.\r\nTherefore you can fall back to the HLstatsX Masterserver for country lookups (set this to 1) otherwise use the ELstatsNEO Masterserver with GeoCityDB (set this to 0)'),
('MasterBanlistBantime', '0', '0 = Disable Mast0rserver global Banlist\r\n>0 = Temporarily ban the global banlisted player X minutes after connecting the server\r\nThe time can be 1-1440 Minutes (maximum 1 day temporary ban)');

ALTER TABLE `hlstats_Players`
ADD COLUMN `displayEvents` int(1) unsigned NOT NULL default '1',
ADD COLUMN `kill_streak` int(6) NOT NULL default '0',
ADD COLUMN `death_streak` int(6) NOT NULL default '0';

CREATE TABLE `hlstats_Players_Awards` (
  `awardTime` date NOT NULL,
  `awardId` int(11) unsigned NOT NULL default '0',
  `playerId` int(11) unsigned NOT NULL default '0',
  `count` int(11) unsigned NOT NULL default '0',
  `game` varchar(128) character set utf8 collate utf8_unicode_ci NOT NULL,
  PRIMARY KEY  (`awardTime`,`awardId`,`playerId`,`game`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `hlstats_Players_Ribbons` (
  `playerId` int(11) unsigned NOT NULL default '0',
  `ribbonId` int(11) unsigned NOT NULL default '0',
  `game` varchar(128) character set utf8 collate utf8_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `hlstats_Players_Sametime` (
  `playerId` int(11) unsigned NOT NULL default '0',
  `buddyId` int(11) unsigned NOT NULL default '0',
  `minutes` int(11) unsigned NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `hlstats_PlayerUniqueIds`
CHANGE `uniqueId` `uniqueId` VARCHAR(128),
CHANGE `game` `game` VARCHAR(128);

CREATE TABLE IF NOT EXISTS `hlstats_Ranks` (
  `rankId` int(11) unsigned NOT NULL auto_increment, 
  `image` varchar(30) NOT NULL,
  `minKills` int(11) unsigned NOT NULL default '0',
  `maxKills` int(11) NOT NULL default '0',
  `rankName` varchar(50) NOT NULL,
  `game` varchar(128) NOT NULL,
  PRIMARY KEY  (`rankId`),
  UNIQUE KEY `rankgame` (`image`,`game`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=91 ;

--
-- Dumping data for table `hlstats_Ranks`
--

INSERT IGNORE INTO `hlstats_Ranks` (`image`, `minKills`, `maxKills`, `rankName`, `game`) VALUES
('recruit',0,49,'Recruit','css'),
('private',50,99,'Private','css'),
('private_firstclass',100,149,'Private First Class','css'),
('second_lieutenant',150,249,'2nd Lieutenant','css'),
('first_lieutenant',250,499,'1st Lieutenant','css'),
('captain',500,749,'Captain','css'),
('major',750,999,'Major','css'),
('lieutenant_colonel',1000,1249,'Lieutenant Colonel','css'),
('colonel',1250,1749,'Colonel','css'),
('brigadier_general',1750,2499,'Brigardier General','css'),
('major_general',2500,4999,'Major General','css'),
('lieutenant_general',5000,7499,'Lieutenant General','css'),
('general',7500,9999,'General','css'),
('general_5Star',10000,14999,'5 Star General','css'),
('ubersoldat',15000,999999999,'The Ubersoldat','css'),
('recruit',0,49,'Recruit','dods'),
('private_firstclass',100,149,'Private First Class','dods'),
('private',50,99,'Private','dods'),
('second_lieutenant',150,249,'2nd Lieutenant','dods'),
('first_lieutenant',250,499,'1st Lieutenant','dods'),
('captain',500,749,'Captain','dods'),
('major',750,999,'Major','dods'),
('lieutenant_colonel',1000,1249,'Lieutenant Colonel','dods'),
('colonel',1250,1749,'Colonel','dods'),
('brigadier_general',1750,2499,'Brigardier General','dods'),
('major_general',2500,4999,'Major General','dods'),
('lieutenant_general',5000,7499,'Lieutenant General','dods'),
('general',7500,9999,'General','dods'),
('general_5Star',10000,14999,'5 Star General','dods'),
('ubersoldat',15000,999999999,'The Ubersoldat','dods'),
('recruit',0,49,'Recruit','hl2ctf'),
('private',50,99,'Private','hl2ctf'),
('private_firstclass',100,149,'Private First Class','hl2ctf'),
('second_lieutenant',150,249,'2nd Lieutenant','hl2ctf'),
('first_lieutenant',250,499,'1st Lieutenant','hl2ctf'),
('captain',500,749,'Captain','hl2ctf'),
('major',750,999,'Major','hl2ctf'),
('lieutenant_colonel',1000,1249,'Lieutenant Colonel','hl2ctf'),
('colonel',1250,1749,'Colonel','hl2ctf'),
('brigadier_general',1750,2499,'Brigardier General','hl2ctf'),
('major_general',2500,4999,'Major General','hl2ctf'),
('lieutenant_general',5000,7499,'Lieutenant General','hl2ctf'),
('general',7500,9999,'General','hl2ctf'),
('general_5Star',10000,14999,'5 Star General','hl2ctf'),
('ubersoldat',15000,999999999,'The Ubersoldat','hl2ctf'),
('recruit',0,49,'Recruit','hl2mp'),
('private',50,99,'Private','hl2mp'),
('private_firstclass',100,149,'Private First Class','hl2mp'),
('second_lieutenant',150,249,'2nd Lieutenant','hl2mp'),
('first_lieutenant',250,499,'1st Lieutenant','hl2mp'),
('captain',500,749,'Captain','hl2mp'),
('major',750,999,'Major','hl2mp'),
('lieutenant_colonel',1000,1249,'Lieutenant Colonel','hl2mp'),
('colonel',1250,1749,'Colonel','hl2mp'),
('brigadier_general',1750,2499,'Brigardier General','hl2mp'),
('major_general',2500,4999,'Major General','hl2mp'),
('lieutenant_general',5000,7499,'Lieutenant General','hl2mp'),
('general',7500,9999,'General','hl2mp'),
('general_5Star',10000,14999,'5 Star General','hl2mp'),
('ubersoldat',15000,999999999,'The Ubersoldat','hl2mp'),
('recruit',0,49,'Recruit','tf'),
('private',50,99,'Private','tf'),
('private_firstclass',100,149,'Private First Class','tf'),
('second_lieutenant',150,249,'2nd Lieutenant','tf'),
('first_lieutenant',250,499,'1st Lieutenant','tf'),
('captain',500,749,'Captain','tf'),
('major',750,999,'Major','tf'),
('lieutenant_colonel',1000,1249,'Lieutenant Colonel','tf'),
('colonel',1250,1749,'Colonel','tf'),
('brigadier_general',1750,2499,'Brigardier General','tf'),
('major_general',2500,4999,'Major General','tf'),
('lieutenant_general',5000,7499,'Lieutenant General','tf'),
('general',7500,9999,'General','tf'),
('general_5Star',10000,14999,'5 Star General','tf'),
('ubersoldat',15000,999999999,'The Ubersoldat','tf'),
('recruit',0,49,'Recruit','insmod'),
('private',50,99,'Private','insmod'),
('private_firstclass',100,149,'Private First Class','insmod'),
('second_lieutenant',150,249,'2nd Lieutenant','insmod'),
('first_lieutenant',250,499,'1st Lieutenant','insmod'),
('captain',500,749,'Captain','insmod'),
('major',750,999,'Major','insmod'),
('lieutenant_colonel',1000,1249,'Lieutenant Colonel','insmod'),
('colonel',1250,1749,'Colonel','insmod'),
('brigadier_general',1750,2499,'Brigardier General','insmod'),
('major_general',2500,4999,'Major General','insmod'),
('lieutenant_general',5000,7499,'Lieutenant General','insmod'),
('general',7500,9999,'General','insmod'),
('general_5Star',10000,14999,'5 Star General','insmod'),
('ubersoldat',15000,999999999,'The Ubersoldat','insmod'),
('recruit',0,49,'Recruit','ff'),
('private',50,99,'Private','ff'),
('private_firstclass',100,149,'Private First Class','ff'),
('second_lieutenant',150,249,'2nd Lieutenant','ff'),
('first_lieutenant',250,499,'1st Lieutenant','ff'),
('captain',500,749,'Captain','ff'),
('major',750,999,'Major','ff'),
('lieutenant_colonel',1000,1249,'Lieutenant Colonel','ff'),
('colonel',1250,1749,'Colonel','ff'),
('brigadier_general',1750,2499,'Brigardier General','ff'),
('major_general',2500,4999,'Major General','ff'),
('lieutenant_general',5000,7499,'Lieutenant General','ff'),
('general',7500,9999,'General','ff'),
('general_5Star',10000,14999,'5 Star General','ff'),
('ubersoldat',15000,999999999,'The Ubersoldat','ff'),
('recruit',0,49,'Recruit','hidden'),
('private',50,99,'Private','hidden'),
('private_firstclass',100,149,'Private First Class','hidden'),
('second_lieutenant',150,249,'2nd Lieutenant','hidden'),
('first_lieutenant',250,499,'1st Lieutenant','hidden'),
('captain',500,749,'Captain','hidden'),
('major',750,999,'Major','hidden'),
('lieutenant_colonel',1000,1249,'Lieutenant Colonel','hidden'),
('colonel',1250,1749,'Colonel','hidden'),
('brigadier_general',1750,2499,'Brigardier General','hidden'),
('major_general',2500,4999,'Major General','hidden'),
('lieutenant_general',5000,7499,'Lieutenant General','hidden'),
('general',7500,9999,'General','hidden'),
('general_5Star',10000,14999,'5 Star General','hidden'),
('ubersoldat',15000,999999999,'The Ubersoldat','hidden');

CREATE TABLE IF NOT EXISTS `hlstats_Ribbons` (
  `ribbonId` int(11) unsigned NOT NULL auto_increment,
  `awardCode` varchar(50) NOT NULL,
  `awardCount` int(11) NOT NULL default '0',
  `special` tinyint(3) NOT NULL default '0',
  `game` varchar(128) NOT NULL,
  `image` varchar(50) NOT NULL,
  `ribbonName` varchar(50) NOT NULL,
  PRIMARY KEY  (`ribbonId`),
  UNIQUE KEY `award` (`awardCode`,`awardCount`,`game`, `special`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

INSERT IGNORE INTO `hlstats_Ribbons` (`awardCode`, `awardCount`, `special`, `game`, `image`, `ribbonName`) VALUES
('p90',0,3,'css','global_p90.png','P90'),
('knife',0,3,'css','global_knife.png','Combat Knife'),
('hegrenade',0,3,'css','global_grenade.png','HE Grenades'),
('glock',0,3,'css','global_glock.png','Glock'),
('elite',0,3,'css','global_elites.png','Dual Beretta Elites'),
('deagle',0,3,'css','global_deagle.png','Desert Eagle'),
('awp',0,3,'css','global_awp.png','AWP Sniper'),
('ak47',0,3,'css','global_ak47.png','AK47'),
('*Headshots*',2500,1,'css','ribbon_of_silver_star.gif','Sharpshooter'),
('*total connection hours*',48,2,'css','ribbon_of_army_service.gif','Army Service'),
('*total connection hours*',168,2,'hl2mp','1waward.png','Connection Time 1 Week '),
('ump45',0,3,'css','global_ump.png','UMP 45'),
('tmp',0,3,'css','global_tmp.png','TMP'),
('p228',0,3,'css','global_sig_p228.png','Sig P228'),
('sg552',0,3,'css','global_sg552.png','SG 552'),
('sg550',0,3,'css','global_sg550.png','SG 550'),
('m249',0,3,'css','global_para.png','M249 Para'),
('mp5navy',0,3,'css','global_mp5.png','MP5 Navy'),
('mac10',0,3,'css','global_mac10.png','MAC 10'),
('m4a1',0,3,'css','global_m4a1.png','Colt M4A1'),
('m3',0,3,'css','global_m3_super.png','M3 Shotgun'),
('g3sg1',0,3,'css','global_g3sg1.png','G3 SG1'),
('fiveseven',0,3,'css','global_fiveseven.png','Five-Seven'),
('aug',0,3,'css','global_aug.png','Steyr Aug'),
('usp',0,3,'css','global_usp.png','USP'),
('scout',0,3,'css','global_scout.png','Scout Elite'),
('crowbar',3,0,'hl2mp','1_crowbaraward.png','Award of Crowbar'),
('crossbow_bolt',3,0,'hl2mp','1_crossbow_boltaward.png','Award of Xbow'),
('combine_ball',3,0,'hl2mp','1_combine_ballaward.png','Award of Combine Ball'),
('ar2',3,0,'hl2mp','1_ar2award.png','Award of AR2'),
('357',3,0,'hl2mp','1_357award.png','Award of 357'),
('*total connection hours*',336,2,'hl2mp','2waward.png','Connection Time 2 Weeks '),
('grenade_frag',3,0,'hl2mp','1_grenade_fragaward.png','Award of Grenade'),
('physbox',3,0,'hl2mp','1_physboxaward.png','Award of Physbox'),
('physics',3,0,'hl2mp','1_physicsaward.png','Award of Physics'),
('pistol',3,0,'hl2mp','1_pistolaward.png','Award of Pistol'),
('rpg_missile',3,0,'hl2mp','1_rpg_missileaward.png','Award of RPG'),
('shotgun',3,0,'hl2mp','1_shotgunaward.png','Award of Shotgun'),
('slam',3,0,'hl2mp','1_slamaward.png','Award of Slam'),
('smg1_grenade',3,0,'hl2mp','1_smg1_grenadeaward.png','Award of SMG Grenade'),
('smg1',3,0,'hl2mp','1_smg1award.png','Award of SMG'),
('stunstick',3,0,'hl2mp','1_stunstickaward.png','Award of Stunstick'),
('357',7,0,'hl2mp','2_357award.png','Bronze 357'),
('ar2',7,0,'hl2mp','2_ar2award.png','Bronze AR2'),
('combine_ball',7,0,'hl2mp','2_combine_ballaward.png','Bronze Combine Ball'),
('crowbar',7,0,'hl2mp','2_crowbaraward.png','Bronze Crowbar'),
('grenade_frag',7,0,'hl2mp','2_grenade_fragaward.png','Bronze Grenade'),
('physbox',7,0,'hl2mp','2_physboxaward.png','Bronze Physbox'),
('physics',7,0,'hl2mp','2_physicsaward.png','Bronze Physics'),
('pistol',7,0,'hl2mp','2_pistolaward.png','Bronze Pistol'),
('rpg_missile',7,0,'hl2mp','2_rpg_missileaward.png','Bronze RPG'),
('shotgun',7,0,'hl2mp','2_shotgunaward.png','Bronze Shotgun'),
('slam',7,0,'hl2mp','2_slamaward.png','Bronze Slam'),
('smg1',7,0,'hl2mp','2_smg1award.png','Bronze SMG'),
('smg1_grenade',7,0,'hl2mp','2_smg1_grenadeaward.png','Bronze SMG Grenade'),
('stunstick',7,0,'hl2mp','2_stunstickaward.png','Bronze Stunstick'),
('crossbow_bolt',7,0,'hl2mp','2_crossbow_boltaward.png','Bronze Xbow'),
('ar2',12,0,'hl2mp','3_ar2award.png','Silver AR2'),
('357',12,0,'hl2mp','3_357award.png','Silver 357'),
('combine_ball',12,0,'hl2mp','3_combine_ballaward.png','Silver Combine Ball'),
('crossbow_bolt',12,0,'hl2mp','3_crossbow_boltaward.png','Silver Xbow'),
('crowbar',12,0,'hl2mp','3_crowbaraward.png','Silver Crowbar'),
('grenade_frag',12,0,'hl2mp','3_grenade_fragaward.png','Silver Grenade'),
('physbox',12,0,'hl2mp','3_physboxaward.png','Silver Physbox'),
('physics',12,0,'hl2mp','3_physicsaward.png','Silver Physics'),
('pistol',12,0,'hl2mp','3_pistolaward.png','Silver Pistol'),
('rpg_missile',12,0,'hl2mp','3_rpg_missileaward.png','Silver RPG'),
('shotgun',12,0,'hl2mp','3_shotgunaward.png','Silver Shotgun'),
('slam',12,0,'hl2mp','3_slamaward.png','Silver Slam'),
('smg1_grenade',12,0,'hl2mp','3_smg1_grenadeaward.png','Silver SMG Grenade'),
('smg1',12,0,'hl2mp','3_smg1award.png','Silver SMG'),
('stunstick',12,0,'hl2mp','3_stunstickaward.png','Silver Stunstick'),
('357',17,0,'hl2mp','x_357supreme.png','Supreme 357'),
('ar2',17,0,'hl2mp','x_ar2supreme.png','Supreme AR2'),
('combine_ball',17,0,'hl2mp','x_combine_ballsupreme.png','Supreme Combine Ball'),
('crossbow_bolt',17,0,'hl2mp','x_crossbow_boltsupreme.png','Supreme Xbow'),
('crowbar',17,0,'hl2mp','x_crowbarsupreme.png','Supreme Crowbar'),
('grenade_frag',17,0,'hl2mp','x_grenade_fragsupreme.png','Supreme Grenade'),
('physbox',17,0,'hl2mp','x_physboxsupreme.png','Supreme Physbox'),
('physics',17,0,'hl2mp','x_physicssupreme.png','Supreme Physics'),
('pistol',17,0,'hl2mp','x_pistolsupreme.png','Supreme Pistol'),
('rpg_missile',17,0,'hl2mp','x_rpg_missilesupreme.png','Supreme RPG'),
('shotgun',17,0,'hl2mp','x_shotgunsupreme.png','Supreme Shotgun'),
('slam',17,0,'hl2mp','x_slamsupreme.png','Supreme Slam'),
('smg1_grenade',17,0,'hl2mp','x_smg1_grenadesupreme.png','Supreme SMG Grenade'),
('smg1',17,0,'hl2mp','x_smg1supreme.png','Supreme SMG'),
('stunstick',17,0,'hl2mp','x_stunsticksupreme.png','Supreme Stunstick'),
('*total connection hours*',504,2,'hl2mp','3waward.png','Connection Time 3 Weeks '),
('*total connection hours*',672,2,'hl2mp','x_swaward.png','Connection Time - Supreme'),
('357',0,3,'hl2mp','357global.png','Global Award 357'),
('ar2',0,3,'hl2mp','ar2global.png','Global Award AR2'),
('combine_ball',0,3,'hl2mp','combine_ballglobal.png','Global Award Combine Ball'),
('crossbow_bolt',0,3,'hl2mp','crossbow_boltglobal.png','Global Award Xbow'),
('crowbar',0,3,'hl2mp','crowbarglobal.png','Global Award Crowbar'),
('grenade_frag',0,3,'hl2mp','grenade_fragglobal.png','Global Award Grenade'),
('physbox',0,3,'hl2mp','physboxglobal.png','Global Award Physbox'),
('physics',0,3,'hl2mp','physicsglobal.png','Global Award Physics'),
('pistol',0,3,'hl2mp','pistolglobal.png','Global Award Pistol'),
('rpg_missile',0,3,'hl2mp','rpgglobal.png','Global Award RPG'),
('shotgun',0,3,'hl2mp','shotgunglobal.png','Global Award Shotgun'),
('slam',0,3,'hl2mp','slamglobal.png','Global Award Slam'),
('smg1_grenade',0,3,'hl2mp','smg1_grenadeglobal.png','Global Award SMG Grenade'),
('smg1',0,3,'hl2mp','smg1global.png','Global Award SMG'),
('stunstick',0,3,'hl2mp','stunstickglobal.png','Global Award Stunstick'),
('xm1014',0,3,'css','global_xm1014.png','XM Shotgun'),
('ak47',5,0,'css','1_ak47.png','AK47'),
('awp',5,0,'css','1_awp.png','AWP Sniper'),
('deagle',5,0,'css','1_deagle.png','Desert Eagle'),
('elite',5,0,'css','1_elite.png','Dual Beretta Elites'),
('glock',5,0,'css','1_glock.png','Glock'),
('hegrenade',5,0,'css','1_hegrenade.png','HE Grenades'),
('knife',5,0,'css','1_knife.png','Combat Knife'),
('p90',5,0,'css','1_p90.png','P90'),
('scout',5,0,'css','1_scout.png','Scout Elite'),
('usp',5,0,'css','1_usp.png','USP'),
('aug',5,0,'css','1_aug.png','Steyr Aug'),
('fiveseven',5,0,'css','1_fiveseven.png','Five-Seven'),
('g3sg1',5,0,'css','1_g3sg1.png','G3 SG1'),
('m3',5,0,'css','1_m3.png','M3 Shotgun'),
('m4a1',5,0,'css','1_m4a1.png','Colt M4A1'),
('mac10',5,0,'css','1_mac10.png','MAC 10'),
('mp5navy',5,0,'css','1_mp5navy.png','MP5 Navy'),
('m249',5,0,'css','1_m249.png','M249 Para'),
('sg550',5,0,'css','1_sg550.png','SG 550'),
('sg552',5,0,'css','1_sg552.png','SG 552'),
('p228',5,0,'css','1_p228.png','Sig P228'),
('tmp',5,0,'css','1_tmp.png','TMP'),
('ump45',5,0,'css','1_ump45.png','UMP 45'),
('xm1014',5,0,'css','1_xm1014.png','XM Shotgun'),
('bat',0,3,'tf','global_bat.png','Baseball Bat'),
('bonesaw',0,3,'tf','global_bonesaw.png','Bone Saw'),
('bottle',0,3,'tf','global_bottle.png','Whiskey Bottle'),
('club',0,3,'tf','global_club.png','Club'),
('fireaxe',0,3,'tf','global_fireaxe.png','Fire Axe'),
('fists',0,3,'tf','global_fists.png','The Fists'),
('flamethrower',0,3,'tf','global_flamethrower.png','Flame Thrower'),
('knife',0,3,'tf','global_knife.png','Knife'),
('minigun',0,3,'tf','global_minigun.png','Minigun'),
('obj_sentrygun',0,3,'tf','global_obj_sentrygun.png','Sentry Gun'),
('pistol',0,3,'tf','global_pistol.png','Pistol'),
('pistol_scout',0,3,'tf','global_pistol_scout.png','Scout Pistol'),
('revolver',0,3,'tf','global_revolver.png','Revolver'),
('scattergun',0,3,'tf','global_scattergun.png','Scattergun'),
('shotgun_hwg',0,3,'tf','global_shotgun_hwg.png','Heavy Shotgun'),
('shotgun_primary',0,3,'tf','global_shotgun_primary.png','Primary Shotgun'),
('shotgun_pyro',0,3,'tf','global_shotgun_pyro.png','Pyro Shotgun'),
('shotgun_soldier',0,3,'tf','global_shotgun_soldier.png','Soldier Shotgun'),
('shovel',0,3,'tf','global_shovel.png','Shovel'),
('smg',0,3,'tf','global_smg.png','SMG'),
('sniperrifle',0,3,'tf','global_sniperrifle.png','Sniper Rifle'),
('syringegun_medic',0,3,'tf','global_syringegun_medic.png','Syringe Gun'),
('tf_projectile_pipe',0,3,'tf','global_tf_projectile_pipe.png','Pipe Bomb'),
('tf_projectile_pipe_remote',0,3,'tf','global_tf_projectile_pipe_remote.png','Sticky Bomb'),
('tf_projectile_rocket',0,3,'tf','global_tf_projectile_rocket.png','RPG'),
('world',0,3,'tf','global_world.png','The World'),
('wrench',0,3,'tf','global_wrench.png','Wrench'),
('bat',5,0,'tf','1_bat.png','Silver Baseball Bat'),
('bonesaw',5,0,'tf','1_bonesaw.png','Silver Bone Saw'),
('bottle',5,0,'tf','1_bottle.png','Silver Whiskey Bottle'),
('club',5,0,'tf','1_club.png','Silver Club'),
('fireaxe',5,0,'tf','1_fireaxe.png','Silver Fire Axe'),
('fists',5,0,'tf','1_fists.png','Silver Fists'),
('flamethrower',5,0,'tf','1_flamethrower.png','Silver Flamethrower'),
('knife',5,0,'tf','1_knife.png','Silver Knife'),
('minigun',5,0,'tf','1_minigun.png','Silver Minigun'),
('obj_sentrygun',5,0,'tf','1_obj_sentrygun.png','Silver Sentry Gun'),
('pistol',5,0,'tf','1_pistol.png','Silver Pistol'),
('pistol_scout',5,0,'tf','1_pistol_scout.png','Silver Scout Pistol'),
('revolver',5,0,'tf','1_revolver.png','Silver Revolver'),
('scattergun',5,0,'tf','1_scattergun.png','Silver Scattergun'),
('shotgun_hwg',5,0,'tf','1_shotgun_hwg.png','Silver Shotgun HWG'),
('shotgun_primary',5,0,'tf','1_shotgun_primary.png','Silver Shotgun'),
('shotgun_pyro',5,0,'tf','1_shotgun_pyro.png','Silver Shotgun Pyro'),
('shotgun_soldier',5,0,'tf','1_shotgun_soldier.png','Silver Shotgun Soldier'),
('shovel',5,0,'tf','1_shovel.png','Silver Shovel'),
('smg',5,0,'tf','1_smg.png','Silver SMG'),
('sniperrifle',5,0,'tf','1_sniperrifle.png','Silver Sniperrifle'),
('syringegun_medic',5,0,'tf','1_syringegun_medic.png','Silver Syringe Gun'),
('tf_projectile_pipe',5,0,'tf','1_tf_projectile_pipe.png','Silver Pipe bomb'),
('tf_projectile_pipe_remote',5,0,'tf','1_tf_projectile_pipe_remote.png','Silver Sticky bomb'),
('tf_projectile_rocket',5,0,'tf','1_tf_projectile_rocket.png','Silver RPG'),
('world',5,0,'tf','1_world.png','Silver World'),
('wrench',5,0,'tf','1_wrench.png','Silver Wrench'),
('builtobject',5,0,'tf','1_builtobject.png','Silver Object Builder'),
('captureblocked',5,0,'tf','1_captureblocked.png','Silver Checkpoint Blocker'),
('chargedeployed',5,0,'tf','1_chargedeployed.png','Silver Uber-Medic'),
('domination',5,0,'tf','1_domination.png','Silver Dominator'),
('kill assist',5,0,'tf','1_kill-assist.png','Silver Assistance'),
('killedobject',5,0,'tf','1_killedobject.png','Silver Object Destroyer'),
('pointcaptured',5,0,'tf','1_pointcaptured.png','Silver Capturer'),
('revenge',5,0,'tf','1_revenge.png','Silver Revenge'),
('axtinguisher', 0, 3, 'tf', 'global_axtinguisher.png', 'Axtinguisher'),
('backburner', 0, 3, 'tf', 'global_backburner.png', 'Backburner'),
('blutsauger', 0, 3, 'tf', 'global_blutsauger.png', 'Blutsauger'),
('gloves', 0, 3, 'tf', 'global_gloves.png', 'K.G.B.'),
('natascha', 0, 3, 'tf', 'global_natascha.png', 'Natascha'),
('ubersaw', 0, 3, 'tf', 'global_ubersaw.png', 'Ubersaw'),
('axtinguisher', 5, 0, 'tf', '1_axtinguisher.png', 'Silver Axtinguisher'),
('backburner', 5, 0, 'tf', '1_backburner.png', 'Silver Axtinguisher'),
('blutsauger', 5, 0, 'tf', '1_blutsauger.png', 'Silver Blutsauger'),
('gloves', 5, 0, 'tf', '1_gloves.png', 'Silver K.G.B.'),
('natascha', 5, 0, 'tf', '1_natascha.png', 'Silver Natascha'),
('ubersaw', 5, 0, 'tf', '1_ubersaw.png', 'Silver Ubersaw'),
('*total connection hours*',168,2,'insmod','1waward.png','Connection Time 1 Week '),
('weapon_makarov',0,3,'insmod','','Makarov Combat Pistol'),
('weapon_makarov',3,0,'insmod','','Silver Makarov'),
('weapon_m9',0,3,'insmod','','9mm Beretta'),
('weapon_m9',3,0,'insmod','','Silver 9mm Beretta'),
('weapon_world',0,3,'insmod','','RPG or Grenade'),
('weapon_world',3,0,'insmod','','Silver RPG or Grenade'),
('weapon_sks',0,3,'insmod','','Simonov SKS carbine'),
('weapon_sks',3,0,'insmod','','Silver Simonov SKS carbine'),
('weapon_m1014',0,3,'insmod','','M1014 Service Combat Shotgun'),
('weapon_m1014',3,0,'insmod','','Silver M1014 Shotgun'),
('weapon_toz',0,3,'insmod','','TOZ Rifle'),
('weapon_toz',3,0,'insmod','','Silver TOZ Rifle'),
('weapon_svd',0,3,'insmod','','Dragunov Sniper Rifle'),
('weapon_svd',3,0,'insmod','','Silver Dragunov Sniper Rifle'),
('weapon_rpk',0,3,'insmod','','RPK Ruchnoy Pulemyot Kalashnikova'),
('weapon_rpk',3,0,'insmod','','Silver RPK'),
('weapon_m249',0,3,'insmod','','M249 SAW (Squad Automatic Weapon)'),
('weapon_m249',3,0,'insmod','','Silver M249 SAW'),
('weapon_m16m203',0,3,'insmod','','M16 carbine M203 Grenade Launcher'),
('weapon_m16m203',3,0,'insmod','','Silver M16 & M203'),
('weapon_l42a1',0,3,'insmod','','Enfield L42A1 Military Sniper Rifle'),
('weapon_l42a1',3,0,'insmod','','Silver Enfield L42A1 Sniper Rifle'),
('weapon_m4med',0,3,'insmod','','M4 Medium Range Rifle'),
('weapon_m4med',3,0,'insmod','','Silver M4 Medium Range Rifle'),
('weapon_m4',0,3,'insmod','','M4 Carbine Rifle'),
('weapon_m4',3,0,'insmod','','Silver M4 Carbine Rifle'),
('weapon_m16a4',0,3,'insmod','','M16A4 Infantry Rifle'),
('weapon_m16a4',3,0,'insmod','','Silver M16A4 Infantry Rifle'),
('weapon_m14',0,3,'insmod','','M16A4 Infantry Rifle'),
('weapon_m14',3,0,'insmod','','Silver M16A4 Infantry Rifle'),
('weapon_fnfa1',0,3,'insmod','','FN FAL Automatic Rifle'),
('weapon_fnfa1',3,0,'insmod','','Silver FN FAL Automatic Rifle'),
('weapon_aks74u',0,3,'insmod','','AKS-74U Awtomat Kalaschnikowa Ukorochennyj'),
('weapon_aks74u',3,0,'insmod','','Silver AKS-74U'),
('weapon_ak47',0,3,'insmod','','AK-47'),
('weapon_ak47',3,0,'insmod','','Silver AK-47');

ALTER TABLE `hlstats_Roles`
ADD COLUMN `picked` int(6) unsigned NOT NULL default '0',
ADD COLUMN `deaths` int(6) unsigned NOT NULL default '0',
ADD COLUMN `kills` int(6) unsigned NOT NULL default '0';

INSERT IGNORE INTO `hlstats_Roles` (`game`, `code`, `name`, `hidden`, `picked`, `kills`, `deaths`) VALUES
('tf','engineer','Engineer','0',0,0,0),
('tf','spy','Spy','0',0,0,0),
('tf','soldier','Soldier','0',0,0,0),
('tf','scout','Scout','0',0,0,0),
('tf','demoman','Demo Man','0',0,0,0),
('tf','sniper','Sniper','0',0,0,0),
('tf','medic','Medic','0',0,0,0),
('tf','pyro','Pyro','0',0,0,0),
('tf','heavyweapons','Heavy','0',0,0,0),
('dods','Random','Random','0',0,0,0),
('dods','#class_allied_garand','American Rifleman','0',0,0,0),
('dods','#class_allied_thompson','American Master Sergeant','0',0,0,0),
('dods','#class_allied_heavy','American Support Infantry','0',0,0,0),
('dods','#class_allied_sniper','American Sniper','0',0,0,0),
('dods','#class_allied_mg','American Machine Gunner','0',0,0,0),
('dods','#class_allied_bazooka','American Bazooka ','0',0,0,0),
('dods','#class_axis_kar98','Axis Grenadier','0',0,0,0),
('dods','#class_axis_mp40','Axis Unteroffizier','0',0,0,0),
('dods','#class_axis_mp44','Axis Sturmtruppe','0',0,0,0),
('dods','#class_axis_sniper','Axis Scharfschtze','0',0,0,0),
('dods','#class_axis_mg42','Axis MG42-Schtze','0',0,0,0),
('dods','#class_axis_pschreck','Axis Panzerschreck','0',0,0,0);

CREATE TABLE `hlstats_Servers_Config` (
  `serverId` int(11) unsigned NOT NULL default '0',
  `parameter` varchar(50) character set utf8 collate utf8_unicode_ci NOT NULL,
  `value` varchar(128) character set utf8 collate utf8_unicode_ci NOT NULL,
  `serverConfigId` int(11) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`serverId`,`parameter`),
  KEY `serverConfigId` (`serverConfigId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

CREATE TABLE `hlstats_Servers_Config_Default` (
  `parameter` varchar(50) character set utf8 collate utf8_unicode_ci NOT NULL,
  `value` varchar(128) character set utf8 collate utf8_unicode_ci NOT NULL,
  `description` mediumtext character set utf8 collate utf8_unicode_ci,
  PRIMARY KEY  (`parameter`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT IGNORE INTO `hlstats_Servers_Config_Default` (`parameter`, `value`, `description`) VALUES
('AddressPort', '0.0.0.0:27015', 'Server address (IP:Port)'),
('AdminContact', 'user@yourdomain.com', 'E-Mail Adress. This is broadcasted to master server and displays ingame.'),
('Admins', '', 'Steamids seperated by "," ("STEAM_0:1:XXX,STEAM_0:0:XXX,STEAM_0:1:XXX").'),
('AutoBanRetry', '0', 'Auto-bans player for 5 minutes if the disconnect from the server. Prevent players from reconnecting until the have a good team and won''t loose many points. 1=on 0=off(default)'),
('AutoTeamBalance', '0', 'If rcon is enabled hlstats automatically analyzed teams and balance players for fair teams. It will make teams numerical even and also swap players based on there skill to balance teams. 1=on, 0=off(default)'),
('BonusRoundIgnore', '0', 'Ignore frags and actions after round has ended (for applicable games). 1=on, 0=off(default)'),
('BonusRoundTime', '0', 'Length (in seconds) of mp_bonusroundtime (as failsafe in case round_start event is not detected). 1=on, 0=off(default)'),
('BroadCastEvents', '1', 'Nearly all Events will be directly broadcasted through rcon on the server. You will directly see, how many points you got for a kill or bomb plating etc. 1=on 0=off(default)'),
('BroadCastEventsCommand', 'hlx_sm_psay', 'The command to broadcast the events. Default is the "say"-command'),
('BroadCastEventsCommandAnnounce', 'hlx_sm_csay', 'Command to announce ingame summary stats and admin email etc. Default is "say".'),
('BroadCastEventsCommandSteamid', '1', 'If the BroadCastCommand needs as second argument the steamid of the player set this value to 1. 1=on 0=off(default)'),
('BroadCastPlayerActions', '1', 'Toggle broadcasting PlayerActions ingame. (f.e Touched a hostage or dropped the Bomb). 1=on 0=off(default)'),
('DisplayResultsInBrowser', '1', 'If enabled (1=on 0=off(default)) the player queries will displayed in the valve browser as small html files instead of sending the data with rawsockets to the console. <br>Requires mani_admin_plugin V1.0.1f or later (RECOMMENDED)'),
('EnablePublicCommands', '1', 'If activated players can report their statistics to all players in the chat area.'),
('GameType', '0', 'Mode of the current gametype:<UL>\r\n<LI>0 = Normal mod standard (default).\r\n<LI>1 = Deathmatch for CSS.</UL>'),
('HLStatsURL', 'http://yoursite.com/hlstats', 'URL to your HLStats. This is broadcasted to master server and displays ingame.'),
('IgnoreBots', '1', 'If enabled bots are not tracked by ELstatsNEO 1=on 0=off(default).'),
('MasterServerData', '7', 'Broadcasting server data to the hlstats master server. You can set up which informations are sent:\r\n<UL>\r\n<LI>0 = Nothing\r\n<LI>1 = Server details (contact, url, address, map, players etc.)\r\n<LI>2 = Player details (name, frags, latency, skill etc)\r\n<LI>4 = Activate global ranking\r\n</UL>\r\nExamples:\r\n<UL>\r\n<LI> Send all informations: MasterServerData = 7 (1+2+4)\r\n<LI> Send serverdata and playerdata without particapting global ranking: MasterServerData = 3 (1+2) (Default)\r\n<LI> Send just serverdata:  MasterServerData = 1 (1)  (Notice: Sending just players is not possible)\r\n<LI> Turn off communication with master server: MasterServerData = 0\r\n</UL>'),
('MasterServerInterval', '200', 'Sets the interval broadcasting data to the master server. Default are 200 lines. (Minimum: 50 lines, Maximum: 1000 lines).'),
('MinimumPlayersRank', '0', 'Required players position to be allowed playing on the server (e.g Top500-Server).'),
('MinPlayers', '4', 'Specifies the minimum number of players required in the server for most player events (objectives, frags, etc.) to be recorded.\r\nThis prevents players from hopping on an empty server and boosting their skill rating by capturing the flag, etc., with no opposition.'),
('Mod', 'SOURCEMOD', 'Valid values are SOURCEMOD, MINISTATS, BEETLE or MANI if one of such plugins are installed.'),
('PlayerEvents', '1', 'Determine if players can get player-specific display ingame (f.e. /skill)'),
('PlayerEventsAdminCommand', '', 'Some messages (f.e. team-balancer) are only for admins. here you can specify a admin-command. Default is "".'),
('PlayerEventsCommand', 'hlx_sm_psay', 'The command to display player events. Default is the "say"-command.'),
('PlayerEventsCommandOSD', 'hlx_sm_msay', 'The command to display amx style menu for "/rank", "/session", "/kpd" commands. Default is "".'),
('PlayerEventsCommandSteamid', '1', 'If the PlayerEventsCommand needs as second argument the steamid of the player set this value to 1. 1=on 0=off(default)'),
('RawSocketHelpNotice', '0', 'A help notice for players is shown ingame with PlayerEventsCommand if PlayerEvents are enabled. 1=on 0=off(default)'),
('RawSocketSupport', '0', 'With raw sockets you get access ingame to all important stats. Its content is displayed into the console. Works only on unix-systems. 1=on 0=off(default)'),
('ShowStats', '1', 'If set to 1 (default) periodically stats are shown ingame with the boradcast-command.'),
('SkillMode', '2', 'Mode of skill changes on frags with following options:\r\n<UL>\r\n<LI>0 = Normal (Victims lost all the points which the killer got).\r\n<LI>1 = Victims lost 3/4 the points which the killer got.\r\n<LI>2 = Victims lost 1/2 the points which the killer got.\r\n<LI>3 = Victims lost 1/4 the points which the killer got.\r\n<LI>4 = Victims lost no points.\r\n</UL>'),
('SuicidePenalty', '5', 'Penalty for a suicide (Default: 5 points).'),
('SwitchAdmins', '0', 'Defines if admins are switched from auto-team balancer 1=on 0=off(default).'),
('TKPenalty', '50', 'Penalty for a team kill (Default: 50 points).'),
('TrackServerLoad', '1', 'Saves every 5 min how much players are playing on the server.');

CREATE TABLE IF NOT EXISTS `hlstats_Servers_Teamspeak` (
  `tsId` int(11) unsigned NOT NULL auto_increment,
  `tsName` varchar(128) NOT NULL,
  `tsAddr` varchar(128) NOT NULL,
  `tsPassword` varchar(128) default NULL,
  `tsDesc` varchar(255) default NULL,
  `tsQueryPort` int(11) unsigned NOT NULL default '51234',
  `tsUDPPort` int(11) unsigned NOT NULL default '8767',
  PRIMARY KEY  (`tsId`),
  UNIQUE KEY `address` (`tsAddr`,`tsUDPPort`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

ALTER TABLE `hlstats_server_load`
ADD COLUMN `map` varchar(128) character set utf8 collate utf8_unicode_ci default NULL,
ADD COLUMN `uptime` varchar(10) character set utf8 collate utf8_unicode_ci NOT NULL default '0',
ADD COLUMN `fps` varchar(10) character set utf8 collate utf8_unicode_ci NOT NULL default '0';

ALTER TABLE `hlstats_Teams`
ADD COLUMN `playerlist_bgcolor` varchar(7) character set utf8 collate utf8_unicode_ci default NULL,
ADD COLUMN `playerlist_color` varchar(7) character set utf8 collate utf8_unicode_ci default NULL,
ADD COLUMN `playerlist_index` tinyint(3) unsigned NOT NULL default '0';

INSERT IGNORE INTO `hlstats_Teams` (`game`, `code`, `name`, `hidden`, `playerlist_bgcolor`, `playerlist_color`, `playerlist_index`) VALUES
('css','TERRORIST','Terrorist','0','#FFD5D5','#FF2D2D',1),
('css','CT','Counter-Terrorist','0','#D2E8F7','#0080C0',2),
('css','SPECTATOR','Spectator','0','#D5D5D5','#050505',0),
('hl2mp','Combine','The Combine','0','#D2E8F7','#0080C0',1),
('hl2mp','Rebels','Rebel Forces','0','#FFD5D5','#FF2D2D',2),
('hl2mp','Spectator','Spectator','0','#D5D5D5','#050505',0),
('tf','Red','The RED','','#FFD5D5','#FF2D2D',2),
('tf','Blue','The BLU','','#D2E8F7','#0080C0',1),
('tf','Spectator','Spectators','','#D5D5D5','#050505',0),
('hl2ctf','Combine','Combine','0','#D2E8F7','#0080C0',1),
('hl2ctf','Rebels','Rebels','0','#FFD5D5','#FF2D2D',2),
('hl2ctf','Spectator','Spectator','0','#D5D5D5','#050505',0),
('dods','Allies','Allies','0','#C1FFC1','#006600',2),
('dods','Axis','Axis','0','#FFD5D5','#FF2D2D',1),
('dods','Spectators','Spectators','0','#D5D5D5','#050505',0),
('insmod','usmarines','U.S. Marines','0','#D2E8F7','#0080C0',2),
('insmod','iraqi','Iraqi Insurgents','0','#FFD5D5','#FF2D2D',1),
('insmod','Spectators','Spectators','0','#EFEFEF','#000000',0),
('ff', '#FF_TEAM_YELLOW', 'Yellow Team', '0', '#F7FF89', '#808700', 3),
('ff', '#FF_TEAM_GREEN', 'Green Team', '0', '#93FF89', '#4B8246', 4),
('ff', '#FF_TEAM_UNASSIGNED', 'SPECTATOR', '0', '#D5D5D5','#050505', 0),
('ff', 'Defenders', 'Defenders', '0', '#D2E8F7','#0080C0', 5),
('ff', 'Attackers', 'Attackers', '0', '#FFD5D5', '#FF2D2D', 6),
('ff', '#FF_TEAM_RED', 'Red Team', '0', '#FFD5D5', '#FF2D2D', 1),
('ff', '#FF_TEAM_BLUE', 'Blue Team', '0', '#D2E8F7','#0080C0', 2),
('hidden','Hidden','Subject 617', '0', '#F7FF89', '#808700', 1),
('hidden','IRIS','I.R.I.S.', '0', '#D2E8F7','#0080C0', 2),
('hidden','Spectator','Spectator','0', '#D5D5D5','#050505', 0);

UPDATE `hlstats_Teams` SET `playerlist_bgcolor` = '#FFD5D5', `playerlist_color` = '#FF2D2D', `playerlist_index` = 1 WHERE `game`='css' AND `code`='TERRORIST';
UPDATE `hlstats_Teams` SET `playerlist_bgcolor` = '#D2E8F7', `playerlist_color` = '#0080C0', `playerlist_index` = 2 WHERE `game`='css' AND `code`='CT';
UPDATE `hlstats_Teams` SET `playerlist_bgcolor` = '#D5D5D5', `playerlist_color` = '#050505', `playerlist_index` = 0 WHERE `game`='css' AND `code`='SPECTATOR';
UPDATE `hlstats_Teams` SET `playerlist_bgcolor` = '#D2E8F7', `playerlist_color` = '#0080C0', `playerlist_index` = 1 WHERE `game`='hl2mp' AND `code`='Combine';
UPDATE `hlstats_Teams` SET `playerlist_bgcolor` = '#FFD5D5', `playerlist_color` = '#FF2D2D', `playerlist_index` = 2 WHERE `game`='hl2mp' AND `code`='Rebels';
UPDATE `hlstats_Teams` SET `playerlist_bgcolor` = '#D5D5D5', `playerlist_color` = '#050505', `playerlist_index` = 0 WHERE `game`='hl2mp' AND `code`='Spectator';
UPDATE `hlstats_Teams` SET `playerlist_bgcolor` = '#FFD5D5', `playerlist_color` = '#FF2D2D', `playerlist_index` = 2 WHERE `game`='tf' AND `code`='Red';
UPDATE `hlstats_Teams` SET `playerlist_bgcolor` = '#D2E8F7', `playerlist_color` = '#0080C0', `playerlist_index` = 1 WHERE `game`='tf' AND `code`='Blue';
UPDATE `hlstats_Teams` SET `playerlist_bgcolor` = '#D5D5D5', `playerlist_color` = '#050505', `playerlist_index` = 0 WHERE `game`='tf' AND `code`='Spectator';
UPDATE `hlstats_Teams` SET `playerlist_bgcolor` = '#D2E8F7', `playerlist_color` = '#0080C0', `playerlist_index` = 1 WHERE `game`='hl2ctf' AND `code`='Combine';
UPDATE `hlstats_Teams` SET `playerlist_bgcolor` = '#FFD5D5', `playerlist_color` = '#FF2D2D', `playerlist_index` = 2 WHERE `game`='hl2ctf' AND `code`='Rebels';
UPDATE `hlstats_Teams` SET `playerlist_bgcolor` = '#D5D5D5', `playerlist_color` = '#050505', `playerlist_index` = 0 WHERE `game`='hl2ctf' AND `code`='Spectator';
UPDATE `hlstats_Teams` SET `playerlist_bgcolor` = '#D5D5D5', `playerlist_color` = '#050505', `playerlist_index` = 0 WHERE `game`='dods' AND `code`='Spectators';
UPDATE `hlstats_Teams` SET `playerlist_bgcolor` = '#C1FFC1', `playerlist_color` = '#006600', `playerlist_index` = 2 WHERE `game`='dods' AND `code`='Allies';
UPDATE `hlstats_Teams` SET `playerlist_bgcolor` = '#FFD5D5', `playerlist_color` = '#FF2D2D', `playerlist_index` = 1 WHERE `game`='dods' AND `code`='Axis';

INSERT IGNORE INTO `hlstats_Weapons` (`game`, `code`, `name`, `modifier`, `kills`, `headshots`) VALUES
('tf', 'tf_projectile_rocket', 'Rocket', 1.00, 0, 0),
('tf', 'sniperrifle', 'Sniper Rifle', 1.00, 0, 0),
('tf', 'minigun', 'Minigun (Sasha)', 1.00, 0, 0),
('tf', 'obj_sentrygun', 'Sentry Gun', 1.00, 0, 0),
('tf', 'knife', 'Knife', 2.00, 0, 0),
('tf', 'scattergun', 'Scatter Gun', 1.25, 0, 0),
('tf', 'tf_projectile_pipe', 'Pipe', 1.00, 0, 0),
('tf', 'flamethrower', 'Flame', 1.00, 0, 0),
('tf', 'tf_projectile_pipe_remote', 'Remote Pipe', 1.00, 0, 0),
('tf', 'shotgun_primary', 'Engy Shotgun', 1.00, 0, 0),
('tf', 'smg', 'Submachine Gun', 1.00, 0, 0),
('tf', 'shotgun_soldier', 'Soldier Shotgun', 1.00, 0, 0),
('tf', 'syringegun_medic', 'Syringe Gun', 1.00, 0, 0),
('tf', 'revolver', 'Revolver', 1.00, 0, 0),
('tf', 'shotgun_pyro', 'Pyro Shotgun', 1.00, 0, 0),
('tf', 'world', 'World', 1.00, 0, 0),
('tf', 'bat', 'Bat', 2.00, 0, 0),
('tf', 'wrench', 'Wrench', 2.00, 0, 0),
('tf', 'bonesaw', 'Bone Saw', 2.00, 0, 0),
('tf', 'shotgun_hwg', 'Heavy Shotgun', 1.00, 0, 0),
('tf', 'club', 'Club', 2.00, 0, 0),
('tf', 'pistol_scout', 'Scout Pistol', 1.50, 0, 0),
('tf', 'pistol', 'Engy Pistol', 1.00, 0, 0),
('tf', 'bottle', 'Bottle', 2.00, 0, 0),
('tf', 'shovel', 'Shovel', 2.00, 0, 0),
('tf', 'fireaxe', 'Fire Axe', 2.00, 0, 0),
('tf', 'fists', 'Fists', 2.00, 0, 0),
('tf', 'axtinguisher', 'Axtinguisher', 2.00, 0, 0),
('tf', 'backburner', 'Backburner', 1.00, 0, 0),
('tf', 'blutsauger', 'Blutsauger', 1.50, 0, 0),
('tf', 'deflect_flare', 'Deflected Flare', 20.00, 0, 0),
('tf', 'deflect_promode', 'Deflected Grenade', 2.00, 0, 0),
('tf', 'deflect_rocket', 'Deflected Rocket', 2.00, 0, 0),
('tf', 'deflect_sticky', 'Deflected Sticky', 2.00, 0, 0),
('tf', 'flaregun', 'Flaregun', 2.00, 0, 0),
('tf', 'natascha', 'Minigun (Natascha)', 1.00, 0, 0),
('tf', 'gloves', 'K.G.B.', 2.00, 0, 0),
('tf', 'taunt_heavy', 'Heavy taunt', 5.00, 0, 0),
('tf', 'taunt_pyro', 'Hadouken', 5.00, 0, 0),
('tf', 'ubersaw', 'Ubersaw', 2.00, 0, 0),
('css','knife','Bundeswehr Advanced Combat Knife',2.00,0,0),
('css','usp','H&K USP .45 Tactical',1.40,0,0),
('css','glock','Glock 18 Select Fire',1.40,0,0),
('css','deagle','Desert Eagle .50AE',1.20,0,0),
('css','p228','Sig Sauer P-228',1.50,0,0),
('css','m3','Benelli M3 Super 90 Combat',1.20,0,0),
('css','xm1014','Benelli/H&K M4 Super 90 XM1014',1.10,0,0),
('css','mp5navy','H&K MP5-Navy',1.20,0,0),
('css','tmp','Steyr Tactical Machine Pistol',1.50,0,0),
('css','p90','FN P90',1.20,0,0),
('css','m4a1','Colt M4A1 Carbine',1.00,0,0),
('css','ak47','Kalashnikov AK-47',1.00,0,0),
('css','sg552','Sig Sauer SG-552 Commando',1.00,0,0),
('css','scout','Steyr Scout',1.10,0,0),
('css','awp','Arctic Warfare Magnum (Police)',1.00,0,0),
('css','g3sg1','H&K G3/SG1 Sniper Rifle',0.80,0,0),
('css','m249','M249 PARA Light Machine Gun',1.20,0,0),
('css','hegrenade','High Explosive Grenade',1.80,0,0),
('css','flashbang','Flashbang',5.00,0,0),
('css','elite','Dual Beretta 96G Elite',1.40,0,0),
('css','aug','Steyr Aug',1.00,0,0),
('css','mac10','Ingram MAC-10',1.50,0,0),
('css','fiveseven','FN Five-Seven',1.50,0,0),
('css','ump45','H&K UMP45',1.20,0,0),
('css','sg550','Sig SG-550 Sniper',0.80,0,0),
('css','famas','Fusil Automatique',1.00,0,0),
('css','galil','Galil',1.10,0,0),
('css','smokegrenade_projectile','Smoke Grenade',5.00,0,0),
('css','PROP_PHYSICS','Rare Physics kill',10.00,0,0),
('hl2mp','env_explosion','Explosion',2.70,0,0),
('hl2mp','player','pTelefrag',10.00,0,0),
('hl2mp','physbox','bTelefrag',7.20,0,0),
('hl2mp','physics','Physics',7.00,0,0),
('hl2mp','crowbar','Crowbar',15.00,0,0),
('hl2mp','stunstick','Stun Stick',15.00,0,0),
('hl2mp','pistol','USP Match',10.00,0,0),
('hl2mp','357','.357 Magnum',4.30,0,0),
('hl2mp','smg1','Sub Machine Gun',0.00,0,0),
('hl2mp','smg1_grenade','Impact Grenade',2.50,0,0),
('hl2mp','ar2','Combine Assault Rifle',1.00,0,0),
('hl2mp','combine_ball','Combine Ball',2.40,0,0),
('hl2mp','shotgun','Shotgun',3.80,0,0),
('hl2mp','crossbow_bolt','Crossbow',7.30,0,0),
('hl2mp','rpg_missile','Rocket Propelled Grenade',0.00,0,0),
('hl2mp','grenade_frag','Frag Grenade',3.70,0,0),
('hl2mp','slam','Slam',4.60,0,0),
('hl2mp','physcannon','Physics Cannon',2.70,0,0),
('hl2ctf','stunstick','Stun Stick',2.50,0,0),
('hl2ctf','Crowbar','Crowbar',2.50,0,0),
('hl2ctf','crossbow_bolt','Crossbow',1.75,0,0),
('hl2ctf','Slam','S.L.A.M',1.80,0,0),
('hl2ctf','Pistol','USP Match',1.75,0,0),
('hl2ctf','grenade_frag','Grenade',1.75,0,0),
('hl2ctf','combine_ball','Combine Ball',1.50,0,0),
('hl2ctf','physcannon','Gravity Gun',1.15,0,0),
('hl2ctf','Shotgun','Shotgun',1.10,0,0),
('hl2ctf','357','.357 Magnum',1.10,0,0),
('hl2ctf','rpg_missile','Rocket Propelled Grenade',1.00,0,0),
('hl2ctf','ar2','Combine Assault Rifle',1.00,0,0),
('hl2ctf','smg1','Sub Machine Gun',1.00,0,0),
('hl2ctf','env_explosion','Explosion',1.00,0,0),
('hl2ctf','ctf_combine_turret','Combine Turret',1.25,0,0),
('hl2ctf','ctf_rebel_turret','Rebel Turret',1.25,0,0),
('hl2ctf','ctf_oicw','OICW Rifle',1.00,0,0),
('hl2ctf','ctf_sniper','Sniper Rifle',1.10,0,0),
('hl2ctf','grenade_ctf_oicw_airburst','OICW Grenade',1.20,0,0),
('hl2ctf','ctf_alyxgun','Alyx Gun',1.15,0,0),
('hl2ctf','smg1_grenade','SMG Grenade',1.10,0,0),
('dods','k98','Mauser Kar 98k',1.30,0,0),
('dods','mp40','MP40 Machine Pistol',1.25,0,0),
('dods','k98_scoped','Mauser Karbiner k98 Sniper Rifle',1.50,0,0),
('dods','mp44','MP44 Assault Rifle',1.35,0,0),
('dods','colt','Colt .45 model 1911',1.60,0,0),
('dods','riflegren_us','M1 Garand Rifle',1.30,0,0),
('dods','thompson','Thompson Submachine Gun',1.25,0,0),
('dods','spring','Springfield Rifle with Scope',1.50,0,0),
('dods','bar','BAR Browning Automatic Rifle',1.20,0,0),
('dods','frag_us','U.S. Grenade',1.00,0,0),
('dods','m1carbine','M1 Carbine',1.20,0,0),
('dods','30cal','.30 Caliber Machine Gun',1.25,0,0),
('dods','frag_ger','German Grenade',1.00,0,0),
('dods','spade','Spade Entrenchment Tool',3.00,0,0),
('dods','amerknife','U.S. Issue Knife',3.00,0,0),
('dods','bazooka','Bazooka',2.25,0,0),
('dods','pschreck','Panzerschreck',2.25,0,0),
('dods','riflegren_ger','German Rifle Grenade',1.30,0,0),
('dods','garand','M1 Garand Rifle',1.30,0,0),
('dods','p38','Pistol 38',1.50,0,0),
('dods','c96','Pistol c96',1.50,0,0),
('dods','punch','Butt Stock Hit',3.00,0,0),
('dods','mg42','MG42 Machine Gun',1.20,0,0),
('dods','smoke_ger','German Smoke Grenade',5.00,0,0),
('dods','smoke_us','U.S. Smoke Grenade',5.00,0,0),
('dods','dod_bomb_target','TNT Bomb',1.00,0,0),
('insmod','weapon_makarov','Soviet Makarov Combat Pistol',1.5,0,0),
('insmod','weapon_m9','9mm Beretta Pistol',1.5,0,0),
('insmod','world','RPG or Grenade',1.4,0,0),
('insmod','weapon_sks','Simonov SKS carbine',1.3,0,0),
('insmod','weapon_m1014','M1014 Service Combat Shotgun',1.2,0,0),
('insmod','weapon_toz','TOZ Rifle',1.1,0,0),
('insmod','weapon_svd','Dragunov Sniper Rifle',1.1,0,0),
('insmod','weapon_rpk','RPK Ruchnoy Pulemyot Kalashnikova',1.1,0,0),
('insmod','weapon_m249','M249 SAW (Squad Automatic Weapon)',1.1,0,0),
('insmod','weapon_m16m203','M16 carbine M203 Grenade Launcher',1.1,0,0),
('insmod','weapon_l42a1','Enfield L42A1 Military Sniper Rifle',1.1,0,0),
('insmod','weapon_m4med','M4 Medium Range Rifle',1,0,0),
('insmod','weapon_m4','M4 Carbine Rifle',1,0,0),
('insmod','weapon_m16a4','M16A4 Infantry Rifle',1,0,0),
('insmod','weapon_m14','Colt M14 Carbine',1,0,0),
('insmod','weapon_fnfa1','FN FAL Automatic Rifle',1,0,0),
('insmod','weapon_aks74u','AKS-74U Awtomat Kalaschnikowa Ukorochennyj',1,0,0),
('insmod','weapon_ak47','AK-47 Awtomat Kalaschnikowa',1,0,0),
('ff', 'weapon_railgun', 'Railgun', 1.00, 0, 0),
('ff', 'weapon_tranq', 'Tranq Gun', 1.00, 0, 0),
('ff', 'weapon_medkit', 'Medkit', 1.00, 0, 0),
('ff', 'weapon_spanner', 'Spanner', 1.00, 0, 0),
('ff', 'weapon_crowbar', 'Crowbar', 1.00, 0, 0),
('ff', 'weapon_shotgun', 'Shotgun', 1.00, 0, 0),
('ff', 'grenade_napalm', 'Napalm Grenade', 1.00, 0, 0),
('ff', 'weapon_ic', 'IC', 1.00, 0, 0),
('ff', 'grenade_nail', 'Nail Grenade', 1.00, 0, 0),
('ff', 'weapon_supershotgun', 'Super Shotgun', 1.00, 0, 0),
('ff', 'weapon_supernailgun', 'Super Nailgun', 1.00, 0, 0),
('ff', 'weapon_sniperrifle', 'Sniper Rifle', 1.00, 0, 0),
('ff', 'weapon_rpg', 'Rocket Launcher', 1.00, 0, 0),
('ff', 'weapon_pipelauncher', 'Pipe Launcher', 1.00, 0, 0),
('ff', 'weapon_knife', 'Knife', 1.00, 0, 0),
('ff', 'weapon_grenadelauncher', 'Grenade Launcher', 1.00, 0, 0),
('ff', 'weapon_flamethrower', 'Flamethrower', 1.00, 0, 0),
('ff', 'Dispenser', 'Dispenser', 1.00, 0, 0),
('ff', 'weapon_autorifle', 'Auto Rifle', 1.00, 0, 0),
('ff', 'weapon_assaultcannon', 'Assault Cannon', 1.00, 0, 0),
('ff', 'SentryGun', 'Sentry Gun', 1.00, 0, 0),
('ff', 'grenade_normal', 'Frag Grenade', 1.00, 0, 0),
('ff', 'grenade_mirv', 'Mirv Grenade', 1.00, 0, 0),
('ff', 'grenade_emp', 'Emp Grenade', 1.00, 0, 0),
('ff', 'DETPACK', 'Detpack', 1.00, 0, 0),
('ff', 'weapon_umbrella','Umbrella', 10.00, 0, 0),
('ff', 'grenade_gas','Gas Grenade', 1.00, 0, 0),
('ff', 'weapon_tommygun', 'Tommygun', 1.00, 0, 0),
('ff', 'weapon_nailgun', 'Nailgun', 1.00, 0, 0),
('hidden', 'fn2000','FN2000 Assault Rifle',1.50, 0, 0),
('hidden', 'p90','FN P90 Sub Machine Gun',2.00, 0, 0),
('hidden', 'shotgun','Remington 870 MCS Shotgun',2.00, 0, 0),
('hidden', 'fn303','FN303 Less Lethal Launcher',2.00, 0, 0),
('hidden', 'pistol','FN FiveSeven Pistol',3.00, 0, 0),
('hidden', 'pistol2','FNP-9 Pistol',3.00, 0, 0),
('hidden', 'knife','Kabar D2 Knife',2.50, 0, 0),
('hidden', 'grenade_projectile','Pipe Bomb',2.00, 0, 0),
('hidden', 'physics','Physics',3.00, 0, 0);