/* Copyright (c) 2025 The Solo Fortress 2 Team, all rights reserved. =============================================
 *
 * Purpose:
 *
 * ===============================================================================================================*
 */
const sourceEngLocale = new Map();
let uiSoundDefaultVolume = 0.5;
let testing = false;

preLoadLocaleStrs();

function readSingleFile(file) {
  // Since you're using the Steam HTML surface, you can't directly fetch local files due to CORS restrictions.
  // Instead, you can use the Steam API to load the file or embed the content directly in your application.
  try {
    const xhr = new XMLHttpRequest();
    xhr.open("GET", file, false); // Synchronous request
    xhr.send(null);

    if (xhr.status === 200) {
      return xhr.responseText;
    } else {
      console.error(`Failed to load file: ${file}, Status: ${xhr.status}`);
      return null;
    }
  } catch (error) {
    console.error(`Error loading file: ${file}`, error);
    return null;
  }
}

function embedHtmlToElement(htmlContent, element) {
  const container = $(element);
  if (container) {
    container.html(htmlContent);
  } else {
    console.error(`Element ${element} not found.`);
  }
}

function wrapAlert(msg) {
  if (!testing)
    alert(msg);
}

// thanks w3schools, your code is mine now
// /jk /jk /jk /jk /jk /jk /jk /jk /jk /jk
function dragElement(elmnt) {
  var pos1 = 0, pos2 = 0, pos3 = 0, pos4 = 0;
  if (document.getElementById(elmnt.id + "header")) {
    // if present, the header is where you move the DIV from:
    document.getElementById(elmnt.id + "header").onmousedown = dragMouseDown;
  } else {
    // otherwise, move the DIV from anywhere inside the DIV:
    elmnt.onmousedown = dragMouseDown;
  }

  function dragMouseDown(e) {
    e = e || window.event;
    e.preventDefault();
    // get the mouse cursor position at startup:
    pos3 = e.clientX;
    pos4 = e.clientY;
    document.onmouseup = closeDragElement;
    // call a function whenever the cursor moves:
    document.onmousemove = elementDrag;
  }

  function elementDrag(e) {
    e = e || window.event;
    e.preventDefault();
    // calculate the new cursor position:
    pos1 = pos3 - e.clientX;
    pos2 = pos4 - e.clientY;
    pos3 = e.clientX;
    pos4 = e.clientY;
    // set the element's new position:
    elmnt.style.top = (elmnt.offsetTop - pos2) + "px";
    elmnt.style.left = (elmnt.offsetLeft - pos1) + "px";
  }

  function closeDragElement() {
    // stop moving when mouse button is released:
    document.onmouseup = null;
    document.onmousemove = null;
  }
}

$("document").ready(() => {
  echoToEngine(`main.js: Document is ready.`);

  dragElement($(".browser-window .top-bar"));

  mainLayout();
  bindEvents();

  showWarningBetaDlg();

  // Serve the file using a local HTTP server or embed the content directly
  fetch("../embedded/mainmenu.html")
    .then(response => {
      if (!response.ok) {
        throw new Error(`HTTP error! status: ${response.status}`);
      }
      return response.text();
    })
    .then(htmlContent => {
      embedHtmlToElement(htmlContent, "#root");
    })
    .catch(error => {
      console.error("Failed to load mainmenu.html:", error);
    });

  setButtonContentToLocaleStrs(500);

  sourceEngCmd("sf2_html_menu_jscall_set_version");

  //sourceEngCmd("show_quest_log"); // this somehow initializes the tf2 main menu so.
});

// called by client.dll
function onVolumeChange(volume) {
  echoToEngine(`main.js - onVolumeChange(): Volume changed to ${volume}`);
  uiSoundDefaultVolume = volume;
}
function onMusicVolumeChange(_) {
  echoToEngine(`main.js - onMusicVolumeChange(): Music volume changed to ${_}`);
  // this is not used yet, but it will be used to set the music volume in the main menu
  // when we have a music player.
  //uiSoundDefaultVolume = volume;
}

function preLoadLocaleStrs() {
  // add the localization strings to the map if needed.
  // web ui
  loadLocaleStr("WebUI_WowOk");
  loadLocaleStr("WebUI_WaitingForStableBuild");
  loadLocaleStr("WebUI_Dlg_BetaWarnTitle");
  loadLocaleStr("WebUI_Dlg_BetaWarnText");
  loadLocaleStr("WebUI_Dlg_DisconnectTitle");
  loadLocaleStr("WebUI_Dlg_DisconnectText");
  loadLocaleStr("WebUI_FuckYou");
  loadLocaleStr("WebUI_No");

  // game ui
  loadLocaleStr("GameUI_GameMenu_ResumeGame");
  loadLocaleStr("GameUI_GameMenu_Disconnect");
  loadLocaleStr("GameUI_GameMenu_PlayerList");
  loadLocaleStr("GameUI_GameMenu_FindServers");
  loadLocaleStr("GameUI_GameMenu_CreateServer");
  loadLocaleStr("GameUI_GameMenu_Options");
  loadLocaleStr("GameUI_GameMenu_AdvOptions");
  loadLocaleStr("GameUI_GameMenu_CharacterSetup");
  loadLocaleStr("GameUI_GameMenu_PlayerStats");
  loadLocaleStr("GameUI_GameMenu_Achievements");
  loadLocaleStr("GameUI_GameMenu_Quit");
}

function loadLocaleStr(key) {
  wrapAlert(`localize:${key}`);
}

// timeoutMs is important just in case we haven't recieved the strings in time
function setButtonContentToLocaleStrs(timeoutMs) {
  echoToEngine(
    `main.js - setButtonContentToLocaleStrs(): Setting the menu item contents after ${timeoutMs}ms`
  );
  setTimeout(() => {
    // main layout
    $("#btn-find-server").html(sourceEngLocaleFind("GameUI_GameMenu_FindServers"));
    $("#btn-create-server").html(sourceEngLocaleFind("GameUI_GameMenu_CreateServer"));
    $("#btn-options").html(sourceEngLocaleFind("GameUI_GameMenu_Options"));
    $("#btn-advoptions").html(sourceEngLocaleFind("GameUI_GameMenu_AdvOptions"));
    $("#btn-change-loadout").html(sourceEngLocaleFind("GameUI_GameMenu_CharacterSetup"));
    $("#btn-stats").html(sourceEngLocaleFind("GameUI_GameMenu_PlayerStats"));
    $("#btn-achievements").html(sourceEngLocaleFind("GameUI_GameMenu_Achievements"));
    $("#btn-quit").html(sourceEngLocaleFind("GameUI_GameMenu_Quit"));
  }, timeoutMs)
}

const quitMsgs = [
  "Are you really really sure that you wanna quit?",
  "Really quit?",
  "Kepler is always watching.",
  "Are you insane!?",
  "Why do we have to wear those ridiculous ties?",
];

function echoToEngine(msg) {
  sourceEngCmd("echo \"" + msg + "\"");
}

function sourceEngLocaleFind(key) {
  if (sourceEngLocale.has(key)) {
    // Return the localized string if it exists in the map
    return sourceEngLocale.get(key);
  } else {
    // If the key is not found, request it from the C++ backend
    echoToEngine(
      `main.js - sourceEngLocaleFind(): Localization key '${key}' not found in cache. Requesting from backend.`
    );
    loadLocaleStr(key);
    return null; // Return null for now, the localized string will be added to the map when received
  }
}

function receiveLocalizedString(key, localizedString) {
  if (localizedString) {
    echoToEngine(`main.js - recieveLocalizedString(): Localized string for key '${key}': ${localizedString}`);
    // Use the localized string in your application
    sourceEngLocale.set(key, localizedString);
  } else {
    echoToEngine(`main.js - recieveLocalizedString(): Localization key '${key}' not found.`);
    // Handle the case where the key is not found
    // For example, show a default message
    sourceEngLocale.set(key, null);
  }
}

function getRandomNumber(min, max) {
  return Math.random() * (max - min) + min;
}

// called by client.dll
function onGameUIHidden() {
  hideMainMenu();
}
function onGameUIVisible() {
  showMainMenu();
}
function onGameUIUnload() {
  hideMainMenu();
}

function showMainMenu() {
  $("#left-menu").css("display", "block");
  $("#main-image").css("display", "block");
  $("#left-menu").removeClass("hide");
  $("#main-image").removeClass("hide");
}

function hideMainMenu() {
  $("#left-menu").css("display", "none");
  $("#left-menu").addClass("hide");
  $("#main-image").css("display", "none");
  $("#main-image").addClass("hide");
}

function showDialog(
  id,
  title,
  content,
  btn1Text,
  btn1Func,
  btn2Text,
  btn2Func,
  hideOnPress = false,
  bypassErrMsg = false
) {
  if (id === null || title === null || content === null || btn1Text === null) {
    console.error("some of the parameters are null, please try again.");
    return;
  }

  if (document.querySelector("#" + id) !== null) {
    const dialogEl = document.querySelector("#" + id);
    dialogEl.remove();
  }

  let btn1El;
  if (btn1Text !== null && btn1Text !== undefined) {
    btn1El = `
        <button id="${id}-dialog-btn1">${btn1Text}</button>
      `;
  } else {
    btn1El = "";
  }
  console.log(`[showDialog] btn1 element:\n${btn1El}`);

  let btn2El;
  if (btn2Text !== null && btn2Text !== undefined) {
    btn2El = `
        <button id="${id}-dialog-btn2">${btn2Text}</button>
      `;
  } else {
    btn2El = "";
  }
  console.log(`[showDialog] btn2 element:\n${btn2El}`);

  const currentBtn1El = btn1El;
  const currentBtn2El = btn2El;

  let element = `
    <dialog id="${id}" open>
      <h1 class="text-4xl font-bold">${title}</h1>
      <p>
        ${content}
      </p>
      ${currentBtn1El}
      ${currentBtn2El}
    </dialog>
    `;
  console.log(`[showDialog] full element:\n${element}`);

  const dialogContainerEl = document.querySelector("#dialog-container");
  dialogContainerEl.classList.remove("hide");
  dialogContainerEl.style.display = "block";
  dialogContainerEl.innerHTML += element;

  hideMainMenu();

  const dialogBtn1El = document.querySelector(`#${id}-dialog-btn1`);
  if (dialogBtn1El !== null) {
    dialogBtn1El.addEventListener("click", () => {
      if (btn1Func !== null && typeof btn1Func === "function") {
        btn1Func();
      } else {
        if (bypassErrMsg !== true) {
          showDialog(
            "error-dialog-func-0",
            `Error executing a function on ${id}.`,
            `There was an issue trying to execute a button 1 function at the ${id} dialog. It's probably NULL or a wrong type.`,
            "Close",
            undefined,
            undefined,
            undefined,
            true,
            true
          );
        }
      }

      if (hideOnPress === true) {
        hideDialog(id);
        showMainMenu();
      }
    });
  }

  const dialogBtn2El = document.querySelector(`#${id}-dialog-btn2`);
  if (dialogBtn2El !== null) {
    dialogBtn2El.addEventListener("click", () => {
      if (btn2Func !== null && typeof btn2Func === "function") {
        btn2Func();
      } else {
        if (bypassErrMsg !== true) {
          showDialog(
            "error-dialog-func-1",
            `Error executing a function on ${id}.`,
            `There was an issue trying to execute a button 2 function at the ${id} dialog. It's probably NULL or a wrong type.`,
            "Close",
            undefined,
            undefined,
            undefined,
            true,
            true
          );
        }
      }

      if (hideOnPress === true) {
        hideDialog(id);
        showMainMenu();
      }
    });
  }

  var audio = new Audio("assets/sound/ui/Back.wav");
  audio.volume = uiSoundDefaultVolume;
  var audioPromise = audio.play();
  if (audioPromise !== undefined) {
    audioPromise.then((_) => {}).catch((error) => {});
  }
}
function hideDialog(id) {
  const dialogEl = document.getElementById(id);
  if (dialogEl !== null) {
    dialogEl.close();

    const dialogContainerEl = document.querySelector("#dialog-container");
    dialogContainerEl.classList.add("hide");
    dialogContainerEl.style.display = "none";

    setTimeout(() => {
      dialogEl.remove();
    }, 650);
  }
}

function setVersionStr(str) {
  echoToEngine(`main.js - setVersionStr(): Setting version string to ${str}`)
  $("#version-str").html(str);
}

function sourceEngCmd(cmd) {
  wrapAlert("engine:" + cmd);
}

function inGameLayout() {
  $(".in-game").css("display", "block");
  $(".main-only").css("display", "none");
}
function mainLayout() {
  $(".in-game").css("display", "none");
  $(".main-only").css("display", "block");
}

function bindEvents() {
  $("button").on("mouseover", () => {
    var btnHoverAudio = new Audio("assets/sound/ui/buttonrollover.wav");
    btnHoverAudio.volume = uiSoundDefaultVolume;
    var hoverAudioPromise = btnHoverAudio.play();
    if (hoverAudioPromise !== undefined) {
      hoverAudioPromise.then((_) => {}).catch((error) => {});
    }
  });
  $("button").on("mousedown", () => {
    var btnClickAudio = new Audio("assets/sound/ui/buttonclick.wav");
    btnClickAudio.volume = uiSoundDefaultVolume;
    var clickAudioPromise = btnClickAudio.play();
    if (clickAudioPromise !== undefined) {
      clickAudioPromise.then((_) => {}).catch((error) => {});
    }
  });
  $("button").on("mouseup", () => {
    var btnClickReleaseAudio = new Audio("assets/sound/ui/buttonclickrelease.wav");
    btnClickReleaseAudio.volume = uiSoundDefaultVolume;
    var clickReleaseAudioPromise = btnClickReleaseAudio.play();
    if (clickReleaseAudioPromise !== undefined) {
      clickReleaseAudioPromise.then((_) => {}).catch((error) => {});
    }
  });
  $("#btn-resume-game").on("click", () => {
    sourceEngCmd("gamemenucommand resumegame");
  });
  $("#btn-leave-game").on("click", () => {
    showDialog(
      "disconnect-dialog",
      sourceEngLocaleFind("WebUI_Dlg_DisconnectTitle"),
      sourceEngLocaleFind("WebUI_Dlg_DisconnectText"),
      sourceEngLocaleFind("WebUI_FuckYou"),
      () => sourceEngCmd("gamemenucommand disconnect"),
      sourceEngLocaleFind("WebUI_No"),
      () => {},
      true,
      true
    );
  });
  $("#btn-mute-players").on("click", () => {
    sourceEngCmd("gamemenucommand openplayerlistdialog");
  });
  $("#btn-find-server").on("click", () => {
    sourceEngCmd("gamemenucommand openserverbrowser");
  });
  $("#btn-create-server").on("click", () => {
    sourceEngCmd("gamemenucommand opencreatemultiplayergamedialog");
  });
  $("#btn-options").on("click", () => {
    sourceEngCmd("gamemenucommand openoptionsdialog");
  });
  $("#btn-advoptions").on("click", () => {
    sourceEngCmd("opentf2options");
  });
  $("#btn-change-loadout").on("click", () => {
    sourceEngCmd("open_charinfo");
  });
  $("#btn-call-vote").on("click", () => {
    sourceEngCmd("callvote; gamemenucommand resumegame");
  });
  $("#btn-achievements").on("click", () => {
    sourceEngCmd("gamemenucommand openachievementsdialog");
  });
  $("#btn-stats").on("click", () => {
    sourceEngCmd("showstatsdlg");
  });
  $("#btn-quit").on("click", () => {
    quitPrompt();
  });
}

function quitPrompt() {
  let rand = Math.floor(Math.random() * quitMsgs.length);
  sourceEngCmd("gameui_activate");
  showDialog(
    "quit-dialog",
    "bruh you really wanna quit?",
    quitMsgs[rand],
    //"Are you sure that you really really want to quit?",
    "ya pakyu",
    () => sourceEngCmd("gamemenucommand quitnoconfirm"),
    "nawrr",
    () => {},
    true,
    true
  );
  //sourceEngCmd("gamemenucommand quit");
}

function openUrlWithSteam(url) {
  sourceEngCmd('open_url_with_steam "' + url + '"');
}

function showWarningBetaDlg() {
  loadLocaleStr("WebUI_Dlg_BetaWarnText");

  showDialog(
    "warn-beta-dialog",
    sourceEngLocaleFind("WebUI_Dlg_BetaWarnTitle"),
    //quitMsgs[rand],
    sourceEngLocaleFind("WebUI_Dlg_BetaWarnText"),
    sourceEngLocaleFind("WebUI_WowOk"),
    () => {},
    sourceEngLocaleFind("WebUI_WaitingForStableBuild"),
    () => {
      sourceEngCmd("gamemenucommand quitnoconfirm");
    },
    true,
    true
  );
}
