<?php
    if ( !defined('IN_UPDATER') )
    {
        die('Do not access this file directly.');
    }

    $dbversion = 67;
    $version = "1.6.15";

    // Tracker #1487 - Add Nuclear Dawn support
    print "#1487 - Adding Nuclear Dawn game support.<br />";
    $db->query("
        INSERT IGNORE INTO `hlstats_Actions` (`game`, `code`, `reward_player`, `reward_team`, `team`, `description`, `for_PlayerActions`, `for_PlayerPlayerActions`, `for_TeamActions`, `for_WorldActions`) VALUES
            ('nd', 'headshot', 1, 0, '', 'Headshot', '1', '0', '0', '0'),
            ('nd', 'kill_streak_2', 1, 0, '', 'Double Kill (2 kills)', '1', '0', '0', '0'),
            ('nd', 'kill_streak_3', 2, 0, '', 'Triple Kill (3 kills)', '1', '0', '0', '0'),
            ('nd', 'kill_streak_4', 3, 0, '', 'Domination (4 kills)', '1', '0', '0', '0'),
            ('nd', 'kill_streak_5', 4, 0, '', 'Rampage (5 kills)', '1', '0', '0', '0'),
            ('nd', 'kill_streak_6', 5, 0, '', 'Mega Kill (6 kills)', '1', '0', '0', '0'),
            ('nd', 'kill_streak_7', 6, 0, '', 'Ownage (7 kills)', '1', '0', '0', '0'),
            ('nd', 'kill_streak_8', 7, 0, '', 'Ultra Kill (8 kills)', '1', '0', '0', '0'),
            ('nd', 'kill_streak_9', 8, 0, '', 'Killing Spree (9 kills)', '1', '0', '0', '0'),
            ('nd', 'kill_streak_10', 9, 0, '', 'Monster Kill (10 kills)', '1', '0', '0', '0'),
            ('nd', 'kill_streak_11', 10, 0, '', 'Unstoppable (11 kills)', '1', '0', '0', '0'),
            ('nd', 'kill_streak_12', 11, 0, '', 'God Like (12 kills)', '1', '0', '0', '0'),
            ('nd', 'round_win', 0, 20, 'Consortium', 'Consortium Win Round', '0', '0', '1', '0'),
            ('nd', 'round_win', 0, 20, 'Empire', 'Empire Win Round', '0', '0', '1', '0'),
            ('nd', 'round_lose', 0, -20, 'Consortium', 'Consortium Lose Round', '0', '0', '1', '0'),
            ('nd', 'round_lose', 0, -20, 'Empire', 'Empire Lose Round', '0', '0', '1', '0'),
            ('nd', 'structure_kill', 0, 20, 'Consortium', 'Empire Structure Destroyed', '1', '0', '1', '0'),
            ('nd', 'structure_kill', 0, 20, 'Empire', 'Consortium Structure Destroyed', '1', '0', '1', '0'),
            ('nd', 'killed_commander', 5, 0, '', 'Killed the enemy commander', '1', '0', '0', '0'),
            ('nd', 'promoted_to_commander', 10, 0, '', 'Promoted to commander', '1', '0', '0', '0'),
            ('nd', 'damaged_opposite_bunker', 0, 1, '', '500dmg at enemy bunker', '0', '0', '1', '0'),
            ('nd', 'resource_captured', 0, 1, '', 'Captured resource', '0', '0', '1', '0'),
            ('nd', 'armoury_destroyed', 10, 0, '', 'Destroyed Armory', '1', '0', '0', '0'),
            ('nd', 'artillery_destroyed', 10, 0, '', 'Destroyed Artillery', '1', '0', '0', '0'),
            ('nd', 'assembler_destroyed', 10, 0, '', 'Destroyed Assembler', '1', '0', '0', '0'),
            ('nd', 'flamethrowerturret_destroyed', 10, 0, '', 'Destroyed Empire Flamethrower Turret', '1', '0', '0', '0'),
            ('nd', 'wirelessrepeater_destroyed', 10, 0, '', 'Destroyed Consortium Wireless Repeater', '1', '0', '0', '0'),
            ('nd', 'powerstation_destroyed', 10, 0, '', 'Destroyed Power Station', '1', '0', '0', '0'),
            ('nd', 'radar_destroyed', 10, 0, '', 'Destroyed Radar Station', '1', '0', '0', '0'),
            ('nd', 'powerrelay_destroyed', 10, 0, '', 'Destroyed Empire Relay Tower', '1', '0', '0', '0'),
            ('nd', 'rocketturret_destroyed', 10, 0, '', 'Destroyed Rocket Turret', '1', '0', '0', '0'),
            ('nd', 'sonicturret_destroyed', 10, 0, '', 'Destroyed Consortium Sonic Turret', '1', '0', '0', '0'),
            ('nd', 'supply_destroyed', 10, 0, '', 'Destroyed Supply Station', '1', '0', '0', '0'),
            ('nd', 'transportgate_destroyed', 10, 0, '', 'Destroyed Transport Gate', '1', '0', '0', '0'),
            ('nd', 'machineguneturret_destroyed', 10, 0, '', 'Destroyed Machinegun Turret', '1', '0', '0', '0');
    ");
    
    $db->query("
        INSERT IGNORE INTO `hlstats_Awards` (`awardType`, `game`, `code`, `name`, `verb`) VALUES
            ('O', 'nd', 'headshot', 'Headshot King', 'shots in the head'),
            ('O', 'nd', 'structure_kill', 'Destroyer', 'destroyed structures'),
            ('O', 'nd', 'killed_commander', 'Commander Killer', 'enemy commander kills'),
            ('O', 'nd', 'promoted_to_commander', 'Master Commander', 'times commander'),
            ('O', 'nd', 'armoury_destroyed', 'Armoury Destroyer', 'destroyed armouries'),
            ('O', 'nd', 'artillery_destroyed', 'Armoury Destroyer', 'destroyed artilleries'),
            ('O', 'nd', 'assembler_destroyed', 'Armoury Destroyer', 'destroyed assemblers'),
            ('O', 'nd', 'flamethrowerturret_destroyed', 'Armoury Destroyer', 'destroyed flameghrower turrets'),
            ('O', 'nd', 'wirelessrepeater_destroyed', 'Armoury Destroyer', 'destroyed wireless repeaters'),
            ('O', 'nd', 'powerstation_destroyed', 'Armoury Destroyer', 'destroyed power stations'),
            ('O', 'nd', 'radar_destroyed','Armoury Destroyer', 'destroyed radars'),
            ('O', 'nd', 'powerrelay_destroyed', 'Armoury Destroyer', 'destroyed relay towers'),
            ('O', 'nd', 'rocketturret_destroyed', 'Armoury Destroyer', 'destroyed rocket turrets'),
            ('O', 'nd', 'sonicturret_destroyed', 'Armoury Destroyer', 'destroyed sonic turrets'),
            ('O', 'nd', 'supply_destroyed', 'Armoury Destroyer', 'destroyed supplies'),
            ('O', 'nd', 'transportgate_destroyed', 'Armoury Destroyer', 'destroyed transport gates'),
            ('O', 'nd', 'machineguneturret_destroyed', 'Armoury Destroyer', 'destroyed machinegun turrets'),
            ('W', 'nd', 'armblade', 'BLADES', 'kills with BLADES'),
            ('W', 'nd', 'armknives', 'KNIVES', 'kills with KNIVES'),
            ('W', 'nd', 'artillery', 'Artillerist', 'kills with Artillery'),
            ('W', 'nd', 'avenger', 'C1 AVENGER', 'kills with C1 AVENGER'),
            ('W', 'nd', 'bag90', 'BAG-90', 'kills with BAG-90'),
            ('W', 'nd', 'bonuspoints', 'Improved Player', 'bonus points'),
            ('W', 'nd', 'chaingun', 'GAU-20P', 'kills with GAU-20P'),
            ('W', 'nd', 'commander damage', 'Damage Commander', 'kills with Commander Damage Ability'),
            ('W', 'nd', 'commander poison', 'Poison Commander', 'kills with Commander Poison Ability'),
            ('W', 'nd', 'connectiontime', 'Play Time', 's in game'),
            ('W', 'nd', 'daisy cutter', 'DAISYCUTTER', 'kills with DAISYCUTTER'),
            ('W', 'nd', 'deathstreak', 'Victim', 'death streak'),
            ('W', 'nd', 'env_explosion', 'Blaster', 'kills with Environment Explosion'),
            ('W', 'nd', 'f2000', 'FN-H F2100 TR', 'kills with FN-H F2100 TR'),
            ('W', 'nd', 'flamethrower turret', 'Flamethrower Turret', 'kills with Flamethrower Turret'),
            ('W', 'nd', 'frag grenade', 'M-87 FRAG', 'kills with M-87 FRAG'),
            ('W', 'nd', 'grenade launcher', 'M52 HYDRA', 'kills with M52 HYDRA'),
            ('W', 'nd', 'killstreak', 'Slayer', 'kill streak'),
            ('W', 'nd', 'latency', 'Lowpinger', 'ms average connection'),
            ('W', 'nd', 'm95', 'M-95 L.A.W.S', 'kills with M-95 L.A.W.S'),
            ('W', 'nd', 'mg turret', 'Machine-gun Turret', 'kills with Machine-gun Turret'),
            ('W', 'nd', 'mostkills', 'Killer', 'kills'),
            ('W', 'nd', 'mp500', 'MP-500', 'kills with MP-500'),
            ('W', 'nd', 'mp7', 'MP-7', 'kills with MP-7'),
            ('W', 'nd', 'nx300', 'NX-300', 'kills with NX-300'),
            ('W', 'nd', 'p12 grenade', 'P12 POISON', 'kills with P12 POISON'),
            ('W', 'nd', 'p900', 'P-900', 'kills with P-900'),
            ('W', 'nd', 'paladin', 'PALADIN PLR-5', 'kills with PALADIN PLR-5'),
            ('W', 'nd', 'pp22', 'PP-22', 'kills with PP-22'),
            ('W', 'nd', 'psg', 'PSG-L', 'kills with PSG-L'),
            ('W', 'nd', 'R.E.D.', 'R.E.D.', 'kills with R.E.D.'),
            ('W', 'nd', 'repair tool', 'Engineer', 'kills with BLOWTORCH'),
            ('W', 'nd', 'rocket turret', 'Rocket Turret', 'kills with Rocket Turret'),
            ('W', 'nd', 'shotgun', 'SPETZ-9', 'kills with SPETZ-9'),
            ('W', 'nd', 'sp5', 'SP-5 K1', 'kills with SP-5 K1'),
            ('W', 'nd', 'suicide', 'Self-murderer', 'suicides'),
            ('W', 'nd', 'teamkills', 'Betrayer', 'team kills'),
            ('W', 'nd', 'u23 grenade', 'U23 POISON', 'kills with U23 POISON'),
            ('W', 'nd', 'x01', 'X-01', 'kills with X-01');
    ");
    
    $db->query("
        INSERT IGNORE INTO `hlstats_Games` (`code`, `name`, `realgame`, `hidden`) VALUES 
            ('nd', 'Nuclear Dawn', 'nd', '1');
    ");    
        
    $db->query("
        INSERT IGNORE INTO `hlstats_Games_Defaults` (`code`, `parameter`, `value`) VALUES
            ('nd', 'Admins', ''),
            ('nd', 'AutoBanRetry', '0'),
            ('nd', 'AutoTeamBalance', '0'),
            ('nd', 'BonusRoundIgnore', '1'),
            ('nd', 'BonusRoundTime', '0'),
            ('nd', 'BroadCastEvents', '1'),
            ('nd', 'BroadCastEventsCommand', 'hlx_sm_psay'),
            ('nd', 'BroadCastEventsCommandAnnounce', 'hlx_sm_psay'),
            ('nd', 'BroadCastPlayerActions', '1'),
            ('nd', 'ConnectAnnounce', '1'),
            ('nd', 'DefaultDisplayEvents', '1'),
            ('nd', 'DisplayResultsInBrowser', '0'),
            ('nd', 'EnablePublicCommands', '1'),
            ('nd', 'GameEngine', '3'),
            ('nd', 'GameType', '0'),
            ('nd', 'HLStatsURL', 'http://yoursite.com/hlstats'),
            ('nd', 'IgnoreBots', '1'),
            ('nd', 'MinimumPlayersRank', '0'),
            ('nd', 'MinPlayers', '4'),
            ('nd', 'PlayerEvents', '1'),
            ('nd', 'PlayerEventsCommand', 'hlx_sm_psay'),
            ('nd', 'PlayerEventsCommandHint', 'hlx_sm_hint'),
            ('nd', 'PlayerEventsCommandOSD', 'hlx_sm_msay'),
            ('nd', 'ShowStats', '1'),
            ('nd', 'SkillMode', '0'),
            ('nd', 'SuicidePenalty', '5'),
            ('nd', 'SwitchAdmins', '0'),
            ('nd', 'TKPenalty', '0'),
            ('nd', 'TrackServerLoad', '1'),
            ('nd', 'UpdateHostname', '1');
    ");

    $db->query("
        INSERT IGNORE INTO `hlstats_Games_Supported` (`code`, `name`) VALUES
            ('nd', 'Nuclear Dawn');
    ");    
  
  $db->query("
        INSERT IGNORE INTO `hlstats_Heatmap_Config` (`map`, `game`, `xoffset`, `yoffset`, `flipx`, `flipy`, `days`, `brush`, `scale`, `font`, `thumbw`, `thumbh`, `cropx1`, `cropy1`, `cropx2`, `cropy2`) VALUES
            ('clocktower', 'nd', 12330, 8013, 0, 1, 30, 'small', 16.50, 10, 0.170312, 0.170312, 0, 0, 0, 0),
            ('downtown', 'nd', 9377, 10471,  0, 1, 30, 'small', 19.00, 10, 0.170312, 0.170312, 0, 0, 0, 0),
            ('hydro', 'nd', 8560, 6600, 0, 1, 30, 'small', 12.50, 10, 0.170312, 0.170312, 0, 0, 0, 0),
            ('metro', 'nd', 5908, 4819, 0, 1, 30, 'small', 11.20, 10, 0.170312, 0.170312, 0, 0, 0, 0),
            ('oasis', 'nd', 5904, 6969, 0, 1, 30, 'small', 12.50, 10, 0.170312, 0.170312, 0, 0, 0, 0),
            ('silo', 'nd', 10865, 7962, 0, 1, 30, 'small', 18.00, 10, 0.170312, 0.170312, 0, 0, 0, 0),
            ('oilfield_beta', 'nd', 10659, 11345, 0, 1, 30, 'small', 22.00, 10, 0.170312, 0.170312, 0, 0, 0, 0);
    ");    
  
  $db->query("
        INSERT IGNORE INTO `hlstats_Ranks` (`game`, `image`, `minKills`, `maxKills`, `rankName`) VALUES
            ('nd', 'recruit', '0', '49', 'Recruit'),
            ('nd', 'private', '50', '99', 'Private'),
            ('nd', 'private-first-class', '100', '199', 'Private First Class'),
            ('nd', 'lance-corporal', '200', '299', 'Lance Corporal'),
            ('nd', 'corporal', '300', '399', 'Corporal'),
            ('nd', 'sergeant', '400', '499', 'Sergeant'),
            ('nd', 'staff-sergeant', '500', '599', 'Staff Sergeant'),
            ('nd', 'gunnery-sergeant', '600', '699', 'Gunnery Sergeant'),
            ('nd', 'master-sergeant', '700', '799', 'Master Sergeant'),
            ('nd', 'first-sergeant', '800', '899', 'First Sergeant'),
            ('nd', 'master-chief', '900', '999', 'Master Chief'),
            ('nd', 'sergeant-major', '1000', '1199', 'Sergeant Major'),
            ('nd', 'ensign', '1200', '1399', 'Ensign'),
            ('nd', 'third-lieutenant', '1400', '1599', 'Third Lieutenant'),
            ('nd', 'second-lieutenant', '1600', '1799', 'Second Lieutenant'),
            ('nd', 'first-lieutenant', '1800', '1999', 'First Lieutenant'),
            ('nd', 'captain', '2000', '2249', 'Captain'),
            ('nd', 'group-captain', '2250', '2499', 'Group Captain'),
            ('nd', 'senior-captain', '2500', '2749', 'Senior Captain'),
            ('nd', 'lieutenant-major', '2750', '2999', 'Lieutenant Major'),
            ('nd', 'major', '3000', '3499', 'Major'),
            ('nd', 'group-major', '3500', '3999', 'Group Major'),
            ('nd', 'lieutenant-commander', '4000', '4499', 'Lieutenant Commander'),
            ('nd', 'commander', '4500', '4999', 'Commander'),
            ('nd', 'group-commander', '5000', '5749', 'Group Commander'),
            ('nd', 'lieutenant-colonel', '5750', '6499', 'Lieutenant Colonel'),
            ('nd', 'colonel', '6500', '7249', 'Colonel'),
            ('nd', 'brigadier', '7250', '7999', 'Brigadier'),
            ('nd', 'brigadier-general', '8000', '8999', 'Brigadier General'),
            ('nd', 'major-general', '9000', '9999', 'Major General'),
            ('nd', 'lieutenant-general', '10000', '12499', 'Lieutenant General'),
            ('nd', 'general', '12500', '14999', 'General'),
            ('nd', 'commander-general', '15000', '17499', 'Commander General'),
            ('nd', 'field-vice-marshal', '17500', '19999', 'Field Vice Marshal'),
            ('nd', 'field-marshal', '20000', '22499', 'Field Marshal'),
            ('nd', 'vice-commander-of-the-army', '22500', '24999', 'Vice Commander of the Army'),
            ('nd', 'commander-of-the-army', '25000', '27499', 'Commander of the Army'),
            ('nd', 'high-commander', '27500', '29999', 'High Commander'),
            ('nd', 'supreme-commander', '30000', '34999', 'Supreme Commander'),
            ('nd', 'terminator', '35000', '9999999', 'Terminator');
    ");
    
  $db->query("
        INSERT IGNORE INTO `hlstats_Ribbons` (`awardCode`, `awardCount`, `special`, `game`, `image`, `ribbonName`) VALUES
            ('*total connection hours*', 25, 2, 'nd', '1_connectiontime.png', 'Connection Time: 25 Hours'),
            ('armblade', 1, 0, 'nd', '1_armblade.png', 'Young: BLADES'),
            ('armknives', 1, 0, 'nd', '1_armknives.png', 'Young: KNIVES'),
            ('artillery', 1, 0, 'nd', '1_artillery.png', 'Young: Artillerist'),
            ('avenger', 1, 0, 'nd', '1_avenger.png', 'Young: C1 AVENGER'),
            ('bag90', 1, 0, 'nd', '1_bag90.png', 'Young: BAG-90'),
            ('bonuspoints', 1, 0, 'nd', '1_bonuspoints.png', 'Young: Improved Player'),
            ('chaingun', 1, 0, 'nd', '1_chaingun.png', 'Young: GAU-20P'),
            ('commander damage', 1, 0, 'nd', '1_commander ability.png', 'Young: Damage Commander'),
            ('commander poison', 1, 0, 'nd', '1_commander ability.png', 'Young: Poison Commander'),
            ('daisy cutter', 1, 0, 'nd', '1_daisy cutter.png', 'Young: DAISYCUTTER'),
            ('deathstreak', 1, 0, 'nd', '1_deathstreak.png', 'Young: Victim'),
            ('env_explosion', 1, 0, 'nd', '1_latency.png', 'Young: Blaster'),
            ('f2000', 1, 0, 'nd', '1_f2000.png', 'Young: FN-H F2100 TR'),
            ('flamethrower turret', 1, 0, 'nd', '1_flamethrower turret.png', 'Young: Flamethrower Turret'),
            ('frag grenade', 1, 0, 'nd', '1_frag grenade.png', 'Young: M-87 FRAG'),
            ('grenade launcher', 1, 0, 'nd', '1_grenade launcher.png', 'Young: M52 HYDRA'),
            ('headshot', 1, 0, 'nd', '1_headshot.png', 'Young: Headshot King'),
            ('killstreak', 1, 0, 'nd', '1_killstreak.png', 'Young: Slayer'),
            ('latency', 1, 0, 'nd', '1_latency.png', 'Young: Lowpinger'),
            ('m95', 1, 0, 'nd', '1_m95.png', 'Young: M-95 L.A.W.S'),
            ('mg turret', 1, 0, 'nd', '1_mg turret.png', 'Young: Machine-gun Turret'),
            ('mostkills', 1, 0, 'nd', '1_mostkills.png', 'Young: Killer'),
            ('mp500', 1, 0, 'nd', '1_mp500.png', 'Young: MP-500'),
            ('mp7', 1, 0, 'nd', '1_mp7.png', 'Young: MP-7'),
            ('nx300', 1, 0, 'nd', '1_nx300.png', 'Young: NX-300'),
            ('p12 grenade', 1, 0, 'nd', '1_p12 grenade.png', 'Young: P12 POISON'),
            ('p900', 1, 0, 'nd', '1_latency.png', 'Young: P-900'),
            ('paladin', 1, 0, 'nd', '1_paladin.png', 'Young: PALADIN PLR-5'),
            ('pp22', 1, 0, 'nd', '1_pp22.png', 'Young: PP-22'),
            ('psg', 1, 0, 'nd', '1_psg.png', 'Young: PSG-L'),
            ('R.E.D.', 1, 0, 'nd', '1_latency.png', 'Young: R.E.D.'),
            ('repair tool', 1, 0, 'nd', '1_repair tool.png', 'Young: Engineer'),
            ('rocket turret', 1, 0, 'nd', '1_rocket turret.png', 'Young: Rocket Turret'),
            ('shotgun', 1, 0, 'nd', '1_shotgun.png', 'Young: SPETZ-9'),
            ('sp5', 1, 0, 'nd', '1_sp5.png', 'Young: SP-5 K1'),
            ('structure_kill', 1, 0, 'nd', '1_structure_kill.png', 'Young: Destroyer'),
            ('suicide', 1, 0, 'nd', '1_suicide.png', 'Young: Self-murderer'),
            ('teamkills', 1, 0, 'nd', '1_teamkills.png', 'Young: Betrayer'),
            ('u23 grenade', 1, 0, 'nd', '1_u23 grenade.png', 'Young: U23 POISON'),
            ('x01', 1, 0, 'nd', '1_x01.png', 'Young: X-01'),
            ('*total connection hours*', 50, 2, 'nd', '2_connectiontime.png', 'Connection Time: 50 Hours'),
            ('armblade', 5, 0, 'nd', '2_armblade.png', 'Bronze: BLADES'),
            ('armknives', 5, 0, 'nd', '2_armknives.png', 'Bronze: KNIVES'),
            ('artillery', 5, 0, 'nd', '2_artillery.png', 'Bronze: Artillerist'),
            ('avenger', 5, 0, 'nd', '2_avenger.png', 'Bronze: C1 AVENGER'),
            ('bag90', 5, 0, 'nd', '2_bag90.png', 'Bronze: BAG-90'),
            ('bonuspoints', 5, 0, 'nd', '2_bonuspoints.png', 'Bronze: Improved Player'),
            ('chaingun', 5, 0, 'nd', '2_chaingun.png', 'Bronze: GAU-20P'),
            ('commander damage', 5, 0, 'nd', '2_commander ability.png', 'Bronze: Damage Commander'),
            ('commander poison', 5, 0, 'nd', '2_commander ability.png', 'Bronze: Poison Commander'),
            ('daisy cutter', 5, 0, 'nd', '2_daisy cutter.png', 'Bronze: DAISYCUTTER'),
            ('deathstreak', 5, 0, 'nd', '2_deathstreak.png', 'Bronze: Victim'),
            ('env_explosion', 5, 0, 'nd', '2_latency.png', 'Bronze: Blaster'),
            ('f2000', 5, 0, 'nd', '2_f2000.png', 'Bronze: FN-H F2100 TR'),
            ('flamethrower turret', 5, 0, 'nd', '2_flamethrower turret.png', 'Bronze: Flamethrower Turret'),
            ('frag grenade', 5, 0, 'nd', '2_frag grenade.png', 'Bronze: M-87 FRAG'),
            ('grenade launcher', 5, 0, 'nd', '2_grenade launcher.png', 'Bronze: M52 HYDRA'),
            ('headshot', 5, 0, 'nd', '2_headshot.png', 'Bronze: Headshot King'),
            ('killstreak', 5, 0, 'nd', '2_killstreak.png', 'Bronze: Slayer'),
            ('latency', 5, 0, 'nd', '2_latency.png', 'Bronze: Lowpinger'),
            ('m95', 5, 0, 'nd', '2_m95.png', 'Bronze: M-95 L.A.W.S'),
            ('mg turret', 5, 0, 'nd', '2_mg turret.png', 'Bronze: Machine-gun Turret'),
            ('mostkills', 5, 0, 'nd', '2_mostkills.png', 'Bronze: Killer'),
            ('mp500', 5, 0, 'nd', '2_mp500.png', 'Bronze: MP-500'),
            ('mp7', 5, 0, 'nd', '2_mp7.png', 'Bronze: MP-7'),
            ('nx300', 5, 0, 'nd', '2_nx300.png', 'Bronze: NX-300'),
            ('p12 grenade', 5, 0, 'nd', '2_p12 grenade.png', 'Bronze: P12 POISON'),
            ('p900', 5, 0, 'nd', '2_latency.png', 'Bronze: P-900'),
            ('paladin', 5, 0, 'nd', '2_paladin.png', 'Bronze: PALADIN PLR-5'),
            ('pp22', 5, 0, 'nd', '2_pp22.png', 'Bronze: PP-22'),
            ('psg', 5, 0, 'nd', '2_psg.png', 'Bronze: PSG-L'),
            ('R.E.D.', 5, 0, 'nd', '2_latency.png', 'Bronze: R.E.D.'),
            ('repair tool', 5, 0, 'nd', '2_repair tool.png', 'Bronze: Engineer'),
            ('rocket turret', 5, 0, 'nd', '2_rocket turret.png', 'Bronze: Rocket Turret'),
            ('shotgun', 5, 0, 'nd', '2_shotgun.png', 'Bronze: SPETZ-9'),
            ('sp5', 5, 0, 'nd', '2_sp5.png', 'Bronze: SP-5 K1'),
            ('structure_kill', 5, 0, 'nd', '2_structure_kill.png', 'Bronze: Destroyer'),
            ('suicide', 5, 0, 'nd', '2_suicide.png', 'Bronze: Self-murderer'),
            ('teamkills', 5, 0, 'nd', '2_teamkills.png', 'Bronze: Betrayer'),
            ('u23 grenade', 5, 0, 'nd', '2_u23 grenade.png', 'Bronze: U23 POISON'),
            ('x01', 5, 0, 'nd', '2_x01.png', 'Bronze: X-01'),
            ('*total connection hours*', 75, 2, 'nd', '3_connectiontime.png', 'Connection Time: 75 Hours'),
            ('armblade', 15, 0, 'nd', '3_armblade.png', 'Silver: BLADES'),
            ('armknives', 15, 0, 'nd', '3_armknives.png', 'Silver: KNIVES'),
            ('artillery', 15, 0, 'nd', '3_artillery.png', 'Silver: Artillerist'),
            ('avenger', 15, 0, 'nd', '3_avenger.png', 'Silver: C1 AVENGER'),
            ('bag90', 15, 0, 'nd', '3_bag90.png', 'Silver: BAG-90'),
            ('bonuspoints', 15, 0, 'nd', '3_bonuspoints.png', 'Silver: Improved Player'),
            ('chaingun', 15, 0, 'nd', '3_chaingun.png', 'Silver: GAU-20P'),
            ('commander damage', 15, 0, 'nd', '3_commander ability.png', 'Silver: Damage Commander'),
            ('commander poison', 15, 0, 'nd', '3_commander ability.png', 'Silver: Poison Commander'),
            ('daisy cutter', 15, 0, 'nd', '3_daisy cutter.png', 'Silver: DAISYCUTTER'),
            ('deathstreak', 15, 0, 'nd', '3_deathstreak.png', 'Silver: Victim'),
            ('env_explosion', 15, 0, 'nd', '3_latency.png', 'Silver: Blaster'),
            ('f2000', 15, 0, 'nd', '3_f2000.png', 'Silver: FN-H F2100 TR'),
            ('flamethrower turret', 15, 0, 'nd', '3_flamethrower turret.png', 'Silver: Flamethrower Turret'),
            ('frag grenade', 15, 0, 'nd', '3_frag grenade.png', 'Silver: M-87 FRAG'),
            ('grenade launcher', 15, 0, 'nd', '3_grenade launcher.png', 'Silver: M52 HYDRA'),
            ('headshot', 15, 0, 'nd', '3_headshot.png', 'Silver: Headshot King'),
            ('killstreak', 15, 0, 'nd', '3_killstreak.png', 'Silver: Slayer'),
            ('latency', 15, 0, 'nd', '3_latency.png', 'Silver: Lowpinger'),
            ('m95', 15, 0, 'nd', '3_m95.png', 'Silver: M-95 L.A.W.S'),
            ('mg turret', 15, 0, 'nd', '3_mg turret.png', 'Silver: Machine-gun Turret'),
            ('mostkills', 15, 0, 'nd', '3_mostkills.png', 'Silver: Killer'),
            ('mp500', 15, 0, 'nd', '3_mp500.png', 'Silver: MP-500'),
            ('mp7', 15, 0, 'nd', '3_mp7.png', 'Silver: MP-7'),
            ('nx300', 15, 0, 'nd', '3_nx300.png', 'Silver: NX-300'),
            ('p12 grenade', 15, 0, 'nd', '3_p12 grenade.png', 'Silver: P12 POISON'),
            ('p900', 15, 0, 'nd', '3_latency.png', 'Silver: P-900'),
            ('paladin', 15, 0, 'nd', '3_paladin.png', 'Silver: PALADIN PLR-5'),
            ('pp22', 15, 0, 'nd', '3_pp22.png', 'Silver: PP-22'),
            ('psg', 15, 0, 'nd', '3_psg.png', 'Silver: PSG-L'),
            ('R.E.D.', 15, 0, 'nd', '3_latency.png', 'Silver: R.E.D.'),
            ('repair tool', 15, 0, 'nd', '3_repair tool.png', 'Silver: Engineer'),
            ('rocket turret', 15, 0, 'nd', '3_rocket turret.png', 'Silver: Rocket Turret'),
            ('shotgun', 15, 0, 'nd', '3_shotgun.png', 'Silver: SPETZ-9'),
            ('sp5', 15, 0, 'nd', '3_sp5.png', 'Silver: SP-5 K1'),
            ('structure_kill', 15, 0, 'nd', '3_structure_kill.png', 'Silver: Destroyer'),
            ('suicide', 15, 0, 'nd', '3_suicide.png', 'Silver: Self-murderer'),
            ('teamkills', 15, 0, 'nd', '3_teamkills.png', 'Silver: Betrayer'),
            ('u23 grenade', 15, 0, 'nd', '3_u23 grenade.png', 'Silver: U23 POISON'),
            ('x01', 15, 0, 'nd', '3_x01.png', 'Silver: X-01'),
            ('*total connection hours*', 100, 2, 'nd', '4_connectiontime.png', 'Connection Time: 100 Hours'),
            ('armblade', 30, 0, 'nd', '4_armblade.png', 'Golden: BLADES'),
            ('armknives', 30, 0, 'nd', '4_armknives.png', 'Golden: KNIVES'),
            ('artillery', 30, 0, 'nd', '4_artillery.png', 'Golden: Artillerist'),
            ('avenger', 30, 0, 'nd', '4_avenger.png', 'Golden: C1 AVENGER'),
            ('bag90', 30, 0, 'nd', '4_bag90.png', 'Golden: BAG-90'),
            ('bonuspoints', 30, 0, 'nd', '4_bonuspoints.png', 'Golden: Improved Player'),
            ('chaingun', 30, 0, 'nd', '4_chaingun.png', 'Golden: GAU-20P'),
            ('commander damage', 30, 0, 'nd', '4_commander ability.png', 'Golden: Damage Commander'),
            ('commander poison', 30, 0, 'nd', '4_commander ability.png', 'Golden: Poison Commander'),
            ('daisy cutter', 30, 0, 'nd', '4_daisy cutter.png', 'Golden: DAISYCUTTER'),
            ('deathstreak', 30, 0, 'nd', '4_deathstreak.png', 'Golden: Victim'),
            ('env_explosion', 30, 0, 'nd', '4_latency.png', 'Golden: Blaster'),
            ('f2000', 30, 0, 'nd', '4_f2000.png', 'Golden: FN-H F2100 TR'),
            ('flamethrower turret', 30, 0, 'nd', '4_flamethrower turret.png', 'Golden: Flamethrower Turret'),
            ('frag grenade', 30, 0, 'nd', '4_frag grenade.png', 'Golden: M-87 FRAG'),
            ('grenade launcher', 30, 0, 'nd', '4_grenade launcher.png', 'Golden: M52 HYDRA'),
            ('headshot', 30, 0, 'nd', '4_headshot.png', 'Golden: Headshot King'),
            ('killstreak', 30, 0, 'nd', '4_killstreak.png', 'Golden: Slayer'),
            ('latency', 30, 0, 'nd', '4_latency.png', 'Golden: Lowpinger'),
            ('m95', 30, 0, 'nd', '4_m95.png', 'Golden: M-95 L.A.W.S'),
            ('mg turret', 30, 0, 'nd', '4_mg turret.png', 'Golden: Machine-gun Turret'),
            ('mostkills', 30, 0, 'nd', '4_mostkills.png', 'Golden: Killer'),
            ('mp500', 30, 0, 'nd', '4_mp500.png', 'Golden: MP-500'),
            ('mp7', 30, 0, 'nd', '4_mp7.png', 'Golden: MP-7'),
            ('nx300', 30, 0, 'nd', '4_nx300.png', 'Golden: NX-300'),
            ('p12 grenade', 30, 0, 'nd', '4_p12 grenade.png', 'Golden: P12 POISON'),
            ('p900', 30, 0, 'nd', '4_latency.png', 'Golden: P-900'),
            ('paladin', 30, 0, 'nd', '4_paladin.png', 'Golden: PALADIN PLR-5'),
            ('pp22', 30, 0, 'nd', '4_pp22.png', 'Golden: PP-22'),
            ('psg', 30, 0, 'nd', '4_psg.png', 'Golden: PSG-L'),
            ('R.E.D.', 30, 0, 'nd', '4_latency.png', 'Golden: R.E.D.'),
            ('repair tool', 30, 0, 'nd', '4_repair tool.png', 'Golden: Engineer'),
            ('rocket turret', 30, 0, 'nd', '4_rocket turret.png', 'Golden: Rocket Turret'),
            ('shotgun', 30, 0, 'nd', '4_shotgun.png', 'Golden: SPETZ-9'),
            ('sp5', 30, 0, 'nd', '4_sp5.png', 'Golden: SP-5 K1'),
            ('structure_kill', 30, 0, 'nd', '4_structure_kill.png', 'Golden: Destroyer'),
            ('suicide', 30, 0, 'nd', '4_suicide.png', 'Golden: Self-murderer'),
            ('teamkills', 30, 0, 'nd', '4_teamkills.png', 'Golden: Betrayer'),
            ('u23 grenade', 30, 0, 'nd', '4_u23 grenade.png', 'Golden: U23 POISON'),
            ('x01', 30, 0, 'nd', '4_x01.png', 'Golden: X-01'),
            ('*total connection hours*', 125, 2, 'nd', '5_connectiontime.png', 'Connection Time: 125 Hours'),
            ('armblade', 50, 0, 'nd', '5_armblade.png', 'Platinum: BLADES'),
            ('armknives', 50, 0, 'nd', '5_armknives.png', 'Platinum: KNIVES'),
            ('artillery', 50, 0, 'nd', '5_artillery.png', 'Platinum: Artillerist'),
            ('avenger', 50, 0, 'nd', '5_avenger.png', 'Platinum: C1 AVENGER'),
            ('bag90', 50, 0, 'nd', '5_bag90.png', 'Platinum: BAG-90'),
            ('bonuspoints', 50, 0, 'nd', '5_bonuspoints.png', 'Platinum: Improved Player'),
            ('chaingun', 50, 0, 'nd', '5_chaingun.png', 'Platinum: GAU-20P'),
            ('commander damage', 50, 0, 'nd', '5_commander ability.png', 'Platinum: Damage Commander'),
            ('commander poison', 50, 0, 'nd', '5_commander ability.png', 'Platinum: Poison Commander'),
            ('daisy cutter', 50, 0, 'nd', '5_daisy cutter.png', 'Platinum: DAISYCUTTER'),
            ('deathstreak', 50, 0, 'nd', '5_deathstreak.png', 'Platinum: Victim'),
            ('env_explosion', 50, 0, 'nd', '5_latency.png', 'Platinum: Blaster'),
            ('f2000', 50, 0, 'nd', '5_f2000.png', 'Platinum: FN-H F2100 TR'),
            ('flamethrower turret', 50, 0, 'nd', '5_flamethrower turret.png', 'Platinum: Flamethrower Turret'),
            ('frag grenade', 50, 0, 'nd', '5_frag grenade.png', 'Platinum: M-87 FRAG'),
            ('grenade launcher', 50, 0, 'nd', '5_grenade launcher.png', 'Platinum: M52 HYDRA'),
            ('headshot', 50, 0, 'nd', '5_headshot.png', 'Platinum: Headshot King'),
            ('killstreak', 50, 0, 'nd', '5_killstreak.png', 'Platinum: Slayer'),
            ('latency', 50, 0, 'nd', '5_latency.png', 'Platinum: Lowpinger'),
            ('m95', 50, 0, 'nd', '5_m95.png', 'Platinum: M-95 L.A.W.S'),
            ('mg turret', 50, 0, 'nd', '5_mg turret.png', 'Platinum: Machine-gun Turret'),
            ('mostkills', 50, 0, 'nd', '5_mostkills.png', 'Platinum: Killer'),
            ('mp500', 50, 0, 'nd', '5_mp500.png', 'Platinum: MP-500'),
            ('mp7', 50, 0, 'nd', '5_mp7.png', 'Platinum: MP-7'),
            ('nx300', 50, 0, 'nd', '5_nx300.png', 'Platinum: NX-300'),
            ('p12 grenade', 50, 0, 'nd', '5_p12 grenade.png', 'Platinum: P12 POISON'),
            ('p900', 50, 0, 'nd', '5_latency.png', 'Platinum: P-900'),
            ('paladin', 50, 0, 'nd', '5_paladin.png', 'Platinum: PALADIN PLR-5'),
            ('pp22', 50, 0, 'nd', '5_pp22.png', 'Platinum: PP-22'),
            ('psg', 50, 0, 'nd', '5_psg.png', 'Platinum: PSG-L'),
            ('R.E.D.', 50, 0, 'nd', '5_latency.png', 'Platinum: R.E.D.'),
            ('repair tool', 50, 0, 'nd', '5_repair tool.png', 'Platinum: Engineer'),
            ('rocket turret', 50, 0, 'nd', '5_rocket turret.png', 'Platinum: Rocket Turret'),
            ('shotgun', 50, 0, 'nd', '5_shotgun.png', 'Platinum: SPETZ-9'),
            ('sp5', 50, 0, 'nd', '5_sp5.png', 'Platinum: SP-5 K1'),
            ('structure_kill', 50, 0, 'nd', '5_structure_kill.png', 'Platinum: Destroyer'),
            ('suicide', 50, 0, 'nd', '5_suicide.png', 'Platinum: Self-murderer'),
            ('teamkills', 50, 0, 'nd', '5_teamkills.png', 'Platinum: Betrayer'),
            ('u23 grenade', 50, 0, 'nd', '5_u23 grenade.png', 'Platinum: U23 POISON'),
            ('x01', 50, 0, 'nd', '5_x01.png', 'Platinum: X-01'),
            ('*total connection hours*', 150, 2, 'nd', '6_connectiontime.png', 'Connection Time: 150 Hours'),
            ('armblade', 75, 0, 'nd', '6_armblade.png', 'Bloody: BLADES'),
            ('armknives', 75, 0, 'nd', '6_armknives.png', 'Bloody: KNIVES'),
            ('artillery', 75, 0, 'nd', '6_artillery.png', 'Bloody: Artillerist'),
            ('avenger', 75, 0, 'nd', '6_avenger.png', 'Bloody: C1 AVENGER'),
            ('bag90', 75, 0, 'nd', '6_bag90.png', 'Bloody: BAG-90'),
            ('bonuspoints', 75, 0, 'nd', '6_bonuspoints.png', 'Bloody: Improved Player'),
            ('chaingun', 75, 0, 'nd', '6_chaingun.png', 'Bloody: GAU-20P'),
            ('commander damage', 75, 0, 'nd', '6_commander ability.png', 'Bloody: Damage Commander'),
            ('commander poison', 75, 0, 'nd', '6_commander ability.png', 'Bloody: Poison Commander'),
            ('daisy cutter', 75, 0, 'nd', '6_daisy cutter.png', 'Bloody: DAISYCUTTER'),
            ('deathstreak', 75, 0, 'nd', '6_deathstreak.png', 'Bloody: Victim'),
            ('env_explosion', 75, 0, 'nd', '6_latency.png', 'Bloody: Blaster'),
            ('f2000', 75, 0, 'nd', '6_f2000.png', 'Bloody: FN-H F2100 TR'),
            ('flamethrower turret', 75, 0, 'nd', '6_flamethrower turret.png', 'Bloody: Flamethrower Turret'),
            ('frag grenade', 75, 0, 'nd', '6_frag grenade.png', 'Bloody: M-87 FRAG'),
            ('grenade launcher', 75, 0, 'nd', '6_grenade launcher.png', 'Bloody: M52 HYDRA'),
            ('headshot', 75, 0, 'nd', '6_headshot.png', 'Bloody: Headshot King'),
            ('killstreak', 75, 0, 'nd', '6_killstreak.png', 'Bloody: Slayer'),
            ('latency', 75, 0, 'nd', '6_latency.png', 'Bloody: Lowpinger'),
            ('m95', 75, 0, 'nd', '6_m95.png', 'Bloody: M-95 L.A.W.S'),
            ('mg turret', 75, 0, 'nd', '6_mg turret.png', 'Bloody: Machine-gun Turret'),
            ('mostkills', 75, 0, 'nd', '6_mostkills.png', 'Bloody: Killer'),
            ('mp500', 75, 0, 'nd', '6_mp500.png', 'Bloody: MP-500'),
            ('mp7', 75, 0, 'nd', '6_mp7.png', 'Bloody: MP-7'),
            ('nx300', 75, 0, 'nd', '6_nx300.png', 'Bloody: NX-300'),
            ('p12 grenade', 75, 0, 'nd', '6_p12 grenade.png', 'Bloody: P12 POISON'),
            ('p900', 75, 0, 'nd', '6_latency.png', 'Bloody: P-900'),
            ('paladin', 75, 0, 'nd', '6_paladin.png', 'Bloody: PALADIN PLR-5'),
            ('pp22', 75, 0, 'nd', '6_pp22.png', 'Bloody: PP-22'),
            ('psg', 75, 0, 'nd', '6_psg.png', 'Bloody: PSG-L'),
            ('R.E.D.', 75, 0, 'nd', '6_latency.png', 'Bloody: R.E.D.'),
            ('repair tool', 75, 0, 'nd', '6_repair tool.png', 'Bloody: Engineer'),
            ('rocket turret', 75, 0, 'nd', '6_rocket turret.png', 'Bloody: Rocket Turret'),
            ('shotgun', 75, 0, 'nd', '6_shotgun.png', 'Bloody: SPETZ-9'),
            ('sp5', 75, 0, 'nd', '6_sp5.png', 'Bloody: SP-5 K1'),
            ('structure_kill', 75, 0, 'nd', '6_structure_kill.png', 'Bloody: Destroyer'),
            ('suicide', 75, 0, 'nd', '6_suicide.png', 'Bloody: Self-murderer'),
            ('teamkills', 75, 0, 'nd', '6_teamkills.png', 'Bloody: Betrayer'),
            ('u23 grenade', 75, 0, 'nd', '6_u23 grenade.png', 'Bloody: U23 POISON'),
            ('x01', 75, 0, 'nd', '6_x01.png', 'Bloody: X-01');
    ");    
  
  $db->query("
        INSERT IGNORE INTO `hlstats_Roles` (`game`, `code`, `name`, `hidden`) VALUES
            ('nd', 'ASSAULT', 'Assault', '0'),
            ('nd', 'EXO', 'Exo', '0'),
            ('nd', 'STEALTH', 'Stealth', '0'),
            ('nd', 'SUPPORT', 'Support', '0');    
    ");    
  
    $db->query("
        INSERT IGNORE INTO `hlstats_Teams` (`game`, `code`, `name`, `hidden`, `playerlist_bgcolor`, `playerlist_color`, `playerlist_index`) VALUES
            ('nd', 'CONSORTIUM', 'Consortium', '0', '#63B6EF', '#072D52', 1),
            ('nd', 'EMPIRE', 'Empire', '0', '#FA3232', '#680E10', 2);    
    ");    
    
    $db->query("
        INSERT IGNORE INTO `hlstats_Weapons` (`game`, `code`, `name`, `modifier`) VALUES
            ('nd', 'armblade', 'BLADES', 2.00),
            ('nd', 'armknives', 'KNIVES', 2.00),
            ('nd', 'artillery', 'Artillery', 1.00),
            ('nd', 'avenger', 'C1 AVENGER', 1.00),
            ('nd', 'bag90', 'BAG-90', 2.00),
            ('nd', 'chaingun', 'GAU-20P', 1.00),
            ('nd', 'commander damage', 'Commander Damage Ability', 1.00),
            ('nd', 'commander poison', 'Commander Poison Ability', 1.00),
            ('nd', 'daisy cutter', 'DAISYCUTTER', 2.00),
            ('nd', 'f2000', 'FN-H F2100 TR', 1.00),
            ('nd', 'env_explosion', 'Environment Explosion', 2.00),
            ('nd', 'flamethrower turret', 'Flamethrower Turret', 1.50),
            ('nd', 'frag grenade', 'M-87 FRAG', 1.50),
            ('nd', 'grenade launcher', 'M52 HYDRA', 1.00),
            ('nd', 'm95', 'M-95 L.A.W.S', 1.00),
            ('nd', 'mg turret', 'Machine-gun Turret', 1.50),
            ('nd', 'mp500', 'MP-500', 1.20),
            ('nd', 'mp7', 'MP-7', 1.20),
            ('nd', 'nx300', 'NX-300', 1.50),
            ('nd', 'p12 grenade', 'P12 POISON', 2.00),
            ('nd', 'p900', 'P-900', 2.00),
            ('nd', 'paladin', 'PALADIN PLR-5', 0.80),
            ('nd', 'pp22', 'PP-22', 1.20),
            ('nd', 'psg', 'PSG-L', 0.80),
            ('nd', 'R.E.D.', 'R.E.D', 2.00),
            ('nd', 'repair tool', 'BLOWTORCH', 2.00),
            ('nd', 'rocket turret', 'Rocket Turret', 1.50),
            ('nd', 'sp5', 'SP-5 K1', 1.30),
            ('nd', 'shotgun', 'SPETZ-9', 1.40),
            ('nd', 'u23 grenade', 'U23 POISON', 2.00),
            ('nd', 'x01', 'X-01', 1.00);
    ");    

    // Perform database schema update notification
    print "Updating database and verion schema numbers.<br />";
    $db->query("UPDATE hlstats_Options SET `value` = '$version' WHERE `keyname` = 'version'");
    $db->query("UPDATE hlstats_Options SET `value` = '$dbversion' WHERE `keyname` = 'dbversion'");
?>